DROP TABLE wp_commentmeta;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE wp_comments;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE wp_links;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE wp_options;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=1477 DEFAULT CHARSET=utf8;

INSERT INTO wp_options VALUES("1","siteurl","http://comfortsolutions.com.au/airconditioning","yes");
INSERT INTO wp_options VALUES("2","blogname","Sunshine Coast Airconditioning &amp; Electrical","yes");
INSERT INTO wp_options VALUES("3","blogdescription","Domestic or commercial installations and service","yes");
INSERT INTO wp_options VALUES("4","users_can_register","0","yes");
INSERT INTO wp_options VALUES("5","admin_email","info@edgewebdesign.com.au","yes");
INSERT INTO wp_options VALUES("6","start_of_week","1","yes");
INSERT INTO wp_options VALUES("7","use_balanceTags","0","yes");
INSERT INTO wp_options VALUES("8","use_smilies","1","yes");
INSERT INTO wp_options VALUES("9","require_name_email","1","yes");
INSERT INTO wp_options VALUES("10","comments_notify","1","yes");
INSERT INTO wp_options VALUES("11","posts_per_rss","10","yes");
INSERT INTO wp_options VALUES("12","rss_use_excerpt","0","yes");
INSERT INTO wp_options VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO wp_options VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO wp_options VALUES("15","mailserver_pass","password","yes");
INSERT INTO wp_options VALUES("16","mailserver_port","110","yes");
INSERT INTO wp_options VALUES("17","default_category","1","yes");
INSERT INTO wp_options VALUES("18","default_comment_status","closed","yes");
INSERT INTO wp_options VALUES("19","default_ping_status","open","yes");
INSERT INTO wp_options VALUES("20","default_pingback_flag","1","yes");
INSERT INTO wp_options VALUES("21","posts_per_page","10","yes");
INSERT INTO wp_options VALUES("22","date_format","F j, Y","yes");
INSERT INTO wp_options VALUES("23","time_format","g:i a","yes");
INSERT INTO wp_options VALUES("24","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO wp_options VALUES("25","links_recently_updated_prepend","<em>","yes");
INSERT INTO wp_options VALUES("26","links_recently_updated_append","</em>","yes");
INSERT INTO wp_options VALUES("27","links_recently_updated_time","120","yes");
INSERT INTO wp_options VALUES("28","comment_moderation","1","yes");
INSERT INTO wp_options VALUES("29","moderation_notify","1","yes");
INSERT INTO wp_options VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO wp_options VALUES("31","gzipcompression","0","yes");
INSERT INTO wp_options VALUES("32","hack_file","0","yes");
INSERT INTO wp_options VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO wp_options VALUES("34","moderation_keys","","no");
INSERT INTO wp_options VALUES("35","active_plugins","a:1:{i:0;s:34:\"wp-clone-by-wp-academy/wpclone.php\";}","yes");
INSERT INTO wp_options VALUES("1463","_transient_timeout_feed_867bd5c64f85878d03a060509cd2f92c","1403726165","no");
INSERT INTO wp_options VALUES("1464","_transient_feed_867bd5c64f85878d03a060509cd2f92c","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: New oEmbed Providers Coming in WordPress 4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25298\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:152:\"http://wptavern.com/new-oembed-providers-coming-in-wordpress-4-0?utm_source=rss&utm_medium=rss&utm_campaign=new-oembed-providers-coming-in-wordpress-4-0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3326:\"<div id=\"attachment_25314\" class=\"wp-caption aligncenter\"><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/embed.jpg\" rel=\"prettyphoto[25298]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/embed.jpg?resize=1019%2C468\" alt=\"photo credit: Scorpions and Centaurs - cc\" class=\"size-full wp-image-25314\" /></a><p class=\"wp-caption-text\">photo credit: <a href=\"http://www.flickr.com/photos/sshb/4087071625/\">Scorpions and Centaurs</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a></p></div>\n<p>WordPress 4.0 is on track to introduce several new oEmbed providers, according to the most recent <a href=\"http://make.wordpress.org/core/2014/06/19/last-week-in-wordpress-core-11/\" target=\"_blank\">core report</a> from Mike Schroder. The following sites and services have been added to the <a href=\"http://codex.wordpress.org/Embeds#oEmbed\" target=\"_blank\">whitelist of oEmbed providers</a>:</p>\n<ul>\n<li>TED talks</li>\n<li>Mixcloud</li>\n<li>CollegeHumor.com</li>\n<li>Issuu</li>\n<li>Polldaddy’s short URL format</li>\n<li>YouTube playlist URLs</li>\n</ul>\n<p>The <a href=\"http://make.wordpress.org/core/handbook/design-decisions/#whitelisting-oembed-providers\" target=\"_blank\">process of getting added to the whitelist of providers</a> is not as easy as it seems. The design decision section of the WordPress core handbook states that the provider must be an established, popular, and trusted site. It must also properly and fully implement the <a href=\"http://oembed.com/\" target=\"_blank\">oEmbed specification</a>.</p>\n<p>When determining how established and popular a service is, there are nine questions to consider, i.e. <em>&#8220;If similar services are already supported, how does this service compare in terms of size, features, and backing?&#8221;</em> and <em>&#8220;Does the service make an effort to build relationships with developers, such as through robust APIs?&#8221;</em> New oEmbed service providers that are proposed for inclusion in core will have to answer these considerations to ensure that it&#8217;s not a hasty, shortsighted addition.</p>\n<p>However, if a site supports oEmbed, anyone can add the site and URL format to the internal whitelist by calling <a href=\"http://codex.wordpress.org/Function_Reference/wp_oembed_add_provider\" target=\"_blank\">wp_oembed_add_provider()</a>. Many plugins take this route when the provider hasn&#8217;t yet been added to core. For example, a trac <a href=\"https://core.trac.wordpress.org/ticket/27658\" target=\"_blank\">ticket</a> was submitted for adding oembed support for CodePen. Since the site needs time to become established and popular, <a href=\"http://wptavern.com/new-plugin-adds-codepen-oembed-support-to-wordpress\" target=\"_blank\">a simple plugin</a> with one line of code uses the wp_oembed_add_provider() method to add support in the meantime. This helps to gauge the community&#8217;s interest before whitelisting the provider.</p>\n<p>Of the six new providers listed above, the YouTube playlist URLs addition is likely to have the broadest appeal, given YouTube&#8217;s massive user base. You&#8217;ll be able to make use of the new oEmbed providers as soon as WordPress 4.0 ships. A beta is expected around the first week of July. The official release is targeted for the week of August 25.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Jun 2014 23:18:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Free Revisr Plugin Offers Git Management for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25260\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:172:\"http://wptavern.com/free-revisr-plugin-offers-git-management-for-wordpress?utm_source=rss&utm_medium=rss&utm_campaign=free-revisr-plugin-offers-git-management-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9057:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/revisr-banner.png\" rel=\"prettyphoto[25260]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/revisr-banner.png?resize=772%2C250\" alt=\"revisr-banner\" class=\"aligncenter size-full wp-image-25266\" /></a></p>\n<p>This month we featured a project called <a href=\"http://wptavern.com/versionpress-hopes-to-bring-version-control-to-the-masses\" target=\"_blank\">VersionPress</a> that brings version control to WordPress, a concept that has many in the community excited. The VersionPress development team is seeking $30,000 in funding by the end of June in order to get it off the ground. However, they aren&#8217;t the only ones working on adding git-based version control to WordPress.</p>\n<p>Earlier this month, developer Matt Shaw quietly released <a href=\"http://wordpress.org/plugins/revisr/\" target=\"_blank\">Revisr</a> on WordPress.org. Revisr is a plugin that allows developers to synchronize with any Git repository and easily commit, push, pull, and branch changes from within the WordPress admin. It&#8217;s different from VersionPress in that it&#8217;s designed to integrate with a remote repository, ie. one hosted on GitHub or Bitbucket. Unlike VersionPress, which hasn&#8217;t yet met its funding goals, <a href=\"http://wordpress.org/plugins/revisr/\" target=\"_blank\">Revisr</a> is free and available now.</p>\n<p>The plugin  allows you to manage your WordPress website with a git repository and currently includes the following features:</p>\n<ul>\n<li>Track changes to the files and database of your WordPress installation</li>\n<li>Optionally use different database versions for each branch</li>\n<li>Commit and push changes to a remote repository (including Bitbucket and Github)</li>\n<li>Pull changes down from a remote repository</li>\n<li>Easily toggle between branches</li>\n<li>Revert your website files and/or database to an earlier commit</li>\n<li>Discard any unwanted changes</li>\n<li>Manage .gitignore to prevent unwanted files/directories from being tracked</li>\n</ul>\n<p><strong>&#8220;I made Revisr to simplify the development process,&#8221;</strong> Shaw told the Tavern. &#8220;There are currently no plugins on WordPress.org that allow developers or site admins to use all of the main features of Git through the WordPress dashboard, and I made Revisr to do just that,&#8221; he said.</p>\n<p>&#8220;At the same time, I wanted it to be simple enough so it could be used by people who aren&#8217;t necessarily interested in Git, but are interested in having backups and being able to quickly revert changes if needed.&#8221;</p>\n<p>For the sake of user-friendliness, Revisr includes an interface in the admin for committing, reverting, pushing and pulling changes:</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/revisr-main-dashboard.png\" rel=\"prettyphoto[25260]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/revisr-main-dashboard.png?resize=530%2C288\" alt=\"revisr-main-dashboard\" class=\"aligncenter size-full wp-image-25262\" /></a></p>\n<p>Revisr makes it easy to view changes in files:</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/revisr-view-diff.png\" rel=\"prettyphoto[25260]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/revisr-view-diff.png?resize=530%2C324\" alt=\"revisr-view-diff\" class=\"aligncenter size-full wp-image-25263\" /></a></p>\n<p>A commit history for the site is available in the WordPress admin:</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/revisr-commit-history.png\" rel=\"prettyphoto[25260]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/revisr-commit-history.png?resize=530%2C309\" alt=\"revisr-commit-history\" class=\"aligncenter size-full wp-image-25264\" /></a></p>\n<h3>How to Set Up Revisr</h3>\n<p>The plugin has three requirements:</p>\n<ul>\n<li>A WordPress installation in the root folder of a Git repository</li>\n<li>Git must be installed on the server (most updated versions of cPanel have it preinstalled)</li>\n<li>PHP exec (safe mode off, can be configured in your php.ini)</li>\n</ul>\n<p>If you want to use Revisr with an existing site, you must ensure that the &#8220;.git&#8221; directory is in the root directory of the WordPress installation. The plugin will then attempt to use the settings stored in Git for pushing to/pulling from any remote repositories, which can be defined on the plugin settings page. Revisr supports git through SSH or HTTPS:</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/revisr-git-settings-options.png\" rel=\"prettyphoto[25260]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/revisr-git-settings-options.png?resize=530%2C353\" alt=\"revisr-git-settings-options\" class=\"aligncenter size-full wp-image-25265\" /></a></p>\n<p>If you&#8217;re using SSH for authentication, you will need to generate an SSH key and add it to Bitbucket/Github.</p>\n<p>The process for setting up a new installation with Revisr is fairly easy:</p>\n<ul>\n<li>Create the repository on Bitbucket or Github</li>\n<li>Clone the repository to your computer, add WordPress, and push it to the repository.</li>\n<li>Upload the entire repository to the server, install WordPress, and add Revisr</li>\n</ul>\n<h3>Benefits of Using Revisr: Revision Tracking, Branching, and Backups</h3>\n<p>Matt Shaw believes that Revisr can benefit WordPerss admins in several ways in addition to revision tracking. &#8220;Revisr helps the admins see all files that have been changed and the specific changes within those,&#8221; he said. &#8220;This is an advantage if many files need to be modified and helps to keep issues at a minimum. An added benefit is having backups and being able to quickly spot and revert some website hacks if they occur.&#8221;</p>\n<p>&#8220;Branching also enables site admins to easily test theme changes or new functionality and quickly toggle back and forth between different versions of the site,&#8221; Shaw noted. &#8220;For example, a site admin could create a new branch to preview layout changes, and switch back to the original branch and old layout if needed.&#8221;</p>\n<p>Recent updates to the plugin include the option to keep the database separate between branches. This allows users to go back and restore the database from any commit in which the database was also backed up.</p>\n<p>Since Revisr tracks both database and file changes, it is suitable for keeping a complete backup of the site. Site admins can easily make full restore points before major changes such as a WordPress core or plugin upgrade.</p>\n<p>In the next major update, Shaw plans to give admins more control on what gets committed and reverted, allowing specific files to be reverted without affecting the overall project. He also plans on adding the ability to tag commits with a version number and the ability to view/merge changes between branches. Future versions of the plugin will include the ability to merge changes between branches and the ability to schedule backups of both the website files and database.</p>\n<h3>The Future of the Revisr Plugin</h3>\n<p>I asked Shaw about the future of the plugin and if he plans on monetizing it. &#8220;The plugin will always be completely free and open source,&#8221; he replied. &#8220;We are also working on a paid standalone application that can interface with Revisr that will allow teams and web firms to manage multiple websites using Git. However, the full functionality of the plugin will always be free.&#8221;</p>\n<p>Shaw is working with a team that aims to launch Revisr Pro, a paid application, later this year. Revisr Pro will work with any type of project, but it will also be able to interface with the Revisr plugin via an API to add more features to both the plugin and the standalone application. &#8220;It&#8217;s designed to simplify managing large amounts of websites (20+) with multiple environments, with file and database tracking with Git, project-level tasks, and team support,&#8221; Shaw said. &#8220;Revisr Pro is also able to deploy and configure new projects, simplifying the workflow for teams using Git, and allowing more time to be spent focused on the project itself.&#8221; They plan to feature straightforward pricing, and won&#8217;t charge for additional users or projects.</p>\n<p>Shaw is currently the sole developer on the Revisr WordPress plugin project, although he has friends who are helping out with testing and design. His plugin is different from <a href=\"http://versionpress.net/\" target=\"_blank\">VersionPress</a> in that it isn&#8217;t targeted toward bringing version control to the masses. Revisr is geared more toward developers and isn&#8217;t supported by a crowd-funding campaign. Shaw is just one man working to create a plugin that helps improve his own workflow. You can download <a href=\"http://wordpress.org/plugins/revisr/screenshots/\" target=\"_blank\">Revisr on WordPress.org</a> and watch for updates as the plugin continues to develop.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Jun 2014 19:53:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WordPress.tv: Scott Bolinger: Building Mobile Apps with WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35636\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wordpress.tv/2014/06/24/scott-bolinger-building-mobile-apps-with-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:685:\"<div id=\"v-g4LEMIpQ-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35636/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35636/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35636&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/24/scott-bolinger-building-mobile-apps-with-wordpress/\"><img alt=\"Scott Bolinger: Building Mobile Apps with WordPress\" src=\"http://videos.videopress.com/g4LEMIpQ/video-266642d1af_scruberthumbnail_1.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Jun 2014 18:34:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WordPress.tv: John Saddington: How to Start a WordPress-Centric Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35273\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wordpress.tv/2014/06/24/john-saddington-how-to-start-a-wordpress-centric-business/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:699:\"<div id=\"v-OmxbxzvV-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35273/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35273/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35273&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/24/john-saddington-how-to-start-a-wordpress-centric-business/\"><img alt=\"John Saddington: How to Start a WordPress-Centric Business\" src=\"http://videos.videopress.com/OmxbxzvV/video-30fbff16a0_scruberthumbnail_1.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Jun 2014 18:23:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WordPress.tv: Cody Landefeld: UX for WordPress Platforms\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35591\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wordpress.tv/2014/06/24/cody-landefeld-ux-for-wordpress-platforms/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:661:\"<div id=\"v-OQijgf19-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35591/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35591/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35591&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/24/cody-landefeld-ux-for-wordpress-platforms/\"><img alt=\"Cody Landefeld: UX for WordPress Platforms\" src=\"http://videos.videopress.com/OQijgf19/video-1bdf16bd9a_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Jun 2014 18:13:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: Easy Pricing Table Plugin Creates Beautiful, Responsive Pricing Tables for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25218\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:230:\"http://wptavern.com/easy-pricing-table-plugin-creates-beautiful-responsive-pricing-tables-for-wordpress?utm_source=rss&utm_medium=rss&utm_campaign=easy-pricing-table-plugin-creates-beautiful-responsive-pricing-tables-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3288:\"<p>A pricing table gives your potential customers the ability to quickly compare and visualize the different feature options within your pricing structure. With a little bit of pricing strategy, these comparison tables can be an effective way of positioning your packages for better sales.</p>\n<p>Creating and styling pricing tables can be a challenge if you&#8217;re not very handy with HTML and CSS. <a href=\"http://wordpress.org/plugins/easy-pricing-table-manager/\" target=\"_blank\">Easy Pricing Table</a> is a new free plugin that aims to make it simple for anyone to set up a visually compelling pricing table. The default design is a flat style with colors that can be set via a user-friendly colorpicker in the admin.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/pricing-tables.png\" rel=\"prettyphoto[25218]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/pricing-tables.png?resize=1025%2C639\" alt=\"pricing-tables\" class=\"aligncenter size-full wp-image-25221\" /></a></p>\n<p>The pricing table is responsive and includes smooth hover effects when mousing over the columns. A live demo is available at <a href=\"http://jwthemes.com/easy-pricing-table/\" target=\"_blank\">JW Themes and Plugins</a>.</p>\n<p>Easing Pricing Table has a settings panel where you can easily customize the appearance of the table as well as each individual column. You&#8217;ll have the option to set the title, price, features, duration, button text, URL, column color and order.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/pricing-details.png\" rel=\"prettyphoto[25218]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/pricing-details.png?resize=889%2C1134\" alt=\"pricing-details\" class=\"aligncenter size-full wp-image-25235\" /></a></p>\n<p>Tables can be displayed using the auto-generated shortcode or via a widget. The plugin allows you to create multiple pricing tables and maintain separate customization settings for each. Be advised that if the pricing tables don&#8217;t match the demo exactly, it&#8217;s likely because they are designed to take on some of the characteristics of your theme, ie. typography, headline styles, etc. You can further customize this via CSS if necessary.</p>\n<p>I was impressed by how easy this plugin is to use. Many other pricing table plugins also use shortcodes, but they often require you to manually input all the information as attributes. This becomes messy and difficult to visualize. However, this plugin does an excellent job of providing an interface that allows you to quickly create, customize, and visualize the columns of your pricing table.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/columns.png\" rel=\"prettyphoto[25218]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/columns.png?resize=1025%2C490\" alt=\"columns\" class=\"aligncenter size-full wp-image-25253\" /></a></p>\n<p><a href=\"http://wordpress.org/plugins/easy-pricing-table-manager/\" target=\"_blank\">Easy Pricing Table</a> is one of the fastest ways to create a beautiful pricing table without having to touch any code. If you&#8217;re using a theme with a flat style design, then this plugin should drop in nicely. Download it for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Jun 2014 01:48:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WordPress.tv: Caspar Hübinger: WordPress, On Fait Speak My Language, Va Bene?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wordpress.tv/2014/06/23/caspar-huebinger-wordpress-on-fait-speak-my-language-va-bene/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:715:\"<div id=\"v-z4zCj5Rz-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35907/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35907/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35907&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/23/caspar-huebinger-wordpress-on-fait-speak-my-language-va-bene/\"><img alt=\"Caspar Hübinger: WordPress, On Fait Speak My Language, Va Bene?\" src=\"http://videos.videopress.com/z4zCj5Rz/caspar-huebinger-wcch14_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jun 2014 18:00:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WordPress.tv: Tom Forrer and Michael Sebel: OOP In WordPress Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35554\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://wordpress.tv/2014/06/23/forrer-sebel-oop-in-wordpress-themes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:683:\"<div id=\"v-ZogQ7StV-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35554/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35554/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35554&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/23/forrer-sebel-oop-in-wordpress-themes/\"><img alt=\"Tom Forrer and Michael Sebel: OOP In WordPress Themes\" src=\"http://videos.videopress.com/ZogQ7StV/forrer-sebel-wcch14-slides_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jun 2014 18:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordPress.tv: Rona Kilmer: Theme SASSification\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35625\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"http://wordpress.tv/2014/06/23/rona-kilmer-theme-sassification/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:647:\"<div id=\"v-g8V8IzoY-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35625/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35625/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35625&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/23/rona-kilmer-theme-sassification/\"><img alt=\"Rona Kilmer: Theme SASSification\" src=\"http://videos.videopress.com/g8V8IzoY/video-a1649c7bb6_scruberthumbnail_1.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jun 2014 18:00:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: WordPress JSON REST API Version 1.1 Released with New Authentication Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25160\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:228:\"http://wptavern.com/wordpress-json-rest-api-version-1-1-released-with-new-authentication-documentation?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-json-rest-api-version-1-1-released-with-new-authentication-documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3242:\"<p>Over the weekend, Ryan McCue and collaborators released version 1.1 of the <a href=\"http://wordpress.org/plugins/json-rest-api/\" target=\"_blank\">JSON REST API</a> plugin. The WP API team is aiming to have it <a href=\"http://wptavern.com/json-rest-api-slated-for-wordpress-4-1-release\" target=\"_blank\">ready for inclusion in WordPress 4.1</a>, which will drop later this year.</p>\n<p>This release focused heavily on testing, fixing bugs discovered through tests, and improving the API documentation. New routes have been added for taxonomies and terms. Excerpts and password-protected post handling have also been improved. Revision endpoint tests are new in 1.1. Coverage for post endpoint testing is now at more than 54% for the whole class and more than 80% for the main methods. McCue says this figure will continue to rise over the next few releases. You can <a href=\"https://github.com/WP-API/WP-API/compare/1.0...1.1\" target=\"_blank\">view all the changes and bug fixes</a> for this release on GitHub.</p>\n<p>The WP API team often receives questions regarding how to handle authentication. Version 1.1 includes full <a href=\"https://github.com/WP-API/WP-API/blob/master/docs/authentication.md\" target=\"_blank\">documentation on authentication methods</a>, including cookie authentication (for plugins/themes running on a site) and OAuth (for desktop/web/mobile clients accessing a site externally). A basic authentication method is also included in the docs and is useful for development purposes only.</p>\n<p>I&#8217;ve been working with the WP API team to help get documentation organized and presented in a way that&#8217;s easy to read and navigate. We&#8217;re in the process of merging all the docs into one centralized hub at <a href=\"http://wp-api.org/\" target=\"_blank\">wp-api.org</a>, which pulls from the various docs in the <a href=\"https://github.com/WP-API\" target=\"_blank\">WP API</a> GitHub repos. We&#8217;re working to make this a top-notch resource for any developer who wants to build with the new API.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/wp-api-docs.png\" rel=\"prettyphoto[25160]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/wp-api-docs.png?resize=1025%2C472\" alt=\"WordPress API Documentation\" class=\"aligncenter size-full wp-image-25193\" /></a></p>\n<p>Work for <a href=\"https://github.com/WP-API/WP-API/issues?milestone=7&state=open\" target=\"_blank\">version 1.2</a> is already underway. &#8220;With version 1.2 and onwards, we’ll be tackling a bunch of <a href=\"https://github.com/WP-API/WP-API/issues?labels=Testing\" target=\"_blank\">extra testing for our endpoints</a>, with the aim of eventually reaching >90% coverage,&#8221; McCue noted in the <a href=\"http://make.wordpress.org/core/2014/06/23/json-rest-api-version-1-1/\" target=\"_blank\">release announcement</a>. If you&#8217;d like to join in collaboration on <a href=\"https://github.com/WP-API/WP-API/blob/master/CONTRIBUTING.md\" target=\"_blank\">GitHub</a>, the team is always looking for help.</p>\n<p>Are any of our readers already building something with the new JSON REST API? Let us know in the comments. Is there anything specific that you&#8217;d like to see added to the documentation?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jun 2014 16:40:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Matt: Apply to Speak at WordCamp SF\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=43842\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"http://ma.tt/2014/06/apply-to-speak-at-wordcamp-sf/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:310:\"<p>The big daddy of WordCamps is open about another week for speaker submissions, if you have something interesting you&#8217;d like to say to the WordPress world <a href=\"http://2014.sf.wordcamp.org/2014/06/16/speaking-at-wordcamp-san-francisco/\">send in your application to speak at WordCamp SF here</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jun 2014 15:53:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Dates Announced For PressNomics 3 – Jan 22nd-24th, 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25176\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"http://wptavern.com/dates-announced-for-pressnomics-3-jan-22nd-24th-2015?utm_source=rss&utm_medium=rss&utm_campaign=dates-announced-for-pressnomics-3-jan-22nd-24th-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2889:\"<p>Dates have been announced for the third annual <a title=\"http://pressnomics.com/\" href=\"http://pressnomics.com/\">PressNomics conference</a>. Organized by Joshua and Sally Strebel of <a title=\"http://pagely.com/\" href=\"http://pagely.com/\">Pagely</a>, PressNomics is a conference similar to a WordCamp but focuses exclusively on the business of WordPress and the economy surrounding it.</p>\n<p>The conference will take place J<strong>anuary 22nd &#8211; 24th, </strong>2015 in Tempe, AZ. The venue is the same as last year, the <a title=\"http://www.missionpalms.com/\" href=\"http://www.missionpalms.com/\">Tempe Mission Palms Hotel</a>. There is a discounted rate of <a title=\"https://gc.synxis.com/rez.aspx?Hotel=12318&Chain=5156&arrive=1/21/2015&depart=1/25/2015&adult=1&child=0&group=2U25J7\" href=\"https://gc.synxis.com/rez.aspx?Hotel=12318&Chain=5156&arrive=1/21/2015&depart=1/25/2015&adult=1&child=0&group=2U25J7\">$194 per night</a> available on a first come, first serve basis. PressNomics sells out fast but while you can book your hotel room now, tickets don&#8217;t go on sale until <strong>August 6th at 10AM Pacific</strong>.</p>\n<div id=\"attachment_25180\" class=\"wp-caption aligncenter\"><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/PressNomics2FeaturedImage.png\" rel=\"prettyphoto[25176]\"><img class=\"size-full wp-image-25180\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/PressNomics2FeaturedImage.png?resize=740%2C300\" alt=\"PressNomics 2 Featured Image\" /></a><p class=\"wp-caption-text\">PressNomics 2 Courtesy Of <a title=\"http://mattreport.com/pressnomics-review/\" href=\"http://mattreport.com/pressnomics-review/\">Mattreport.com</a></p></div>\n<p>PressNomics is a three-day event to relax, collaborate, and discuss the economics surrounding WordPress.  Notable speakers in the past include Mark Jaquith, Cory Miller, and Mikkel Svane. <a title=\"http://chrislema.com/pressnomics-good-bad-awesome/\" href=\"http://chrislema.com/pressnomics-good-bad-awesome/\">Chris Lema</a> and <a title=\"http://mattreport.com/pressnomics-review/\" href=\"http://mattreport.com/pressnomics-review/\">Matt Mederios</a> both have great reviews of the event when they attended in 2013. It&#8217;s quickly become one of the premiere events outside of WordCamps.</p>\n<p>PressNomics is something I&#8217;ve been wanting to attend since its creation. I was never able to attend due to finances and timing. However, I&#8217;m happy to say that I&#8217;ll be in attendance for version 3 of the event and will be covering it for the Tavern.</p>\n<p>I&#8217;m really looking forward to surrounding myself with the movers and shakers of the WordPress business world. I want to know what everyone is thinking and get a feel for what direction WordPress is heading. Let me know in the comments if you plan on going to PressNomics 3. I&#8217;d love to meet and talk to you.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jun 2014 04:53:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: What Naming Convention Do You Use For WordPress Media?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25166\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:170:\"http://wptavern.com/what-naming-convention-do-you-use-for-wordpress-media?utm_source=rss&utm_medium=rss&utm_campaign=what-naming-convention-do-you-use-for-wordpress-media\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2695:\"<p>After <strong>six years</strong> of serving cold beverages at the Tavern and publishing more than <strong>2,100 posts</strong>, our media library has over <strong>2,770 images</strong>. Over the years, the meta information I give images has changed from very little to as descriptive as possible. For example, we use a theme that utilizes featured images. When I upload a featured image, I&#8217;ll give it a title that&#8217;s descriptive to the post it will be attached to.</p>\n<p>In this example, the title of the image is <em>Market Share Pie Featured Image</em> since the post it would be attached to talks about the market share of GravityForms and would be the featured image for the post. For the Alt Text, I described the image as,<em> GravityForms Market Share Pie Featured Image</em>. The ALT text is usually just the image title with spaces in between.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/HowILabelFeaturedImages.png\" rel=\"prettyphoto[25166]\"><img class=\"aligncenter size-full wp-image-25167\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/HowILabelFeaturedImages.png?resize=553%2C620\" alt=\"HowILabelFeaturedImages\" /></a></p>\n<p>When I need to reuse a featured image, all I have to do is search for <strong>Featured Image</strong> in the media library. The search results are made up of all of the previous featured images I&#8217;ve uploaded. Since we don&#8217;t have too many to wade through, finding the one I want doesn&#8217;t take long.</p>\n<h3>Empowered To Improve Media Library Search Results</h3>\n<p>The WordPress media library is an archive of content. The larger it gets, the more difficult it can be to find things. Personally, I think being as descriptive as possible with each field with the exception of the caption is the easiest way to improve the media library search engine results. If I fail to be descriptive with images and provide ample meta information, then whose fault is it when the media library can&#8217;t find what I&#8217;m looking for?</p>\n<p>This is one of those areas of WordPress where I believe users are empowered. They have the choice of either providing as much or as little information as possible. I think the less information provided over time could prove to be detrimental to the media library search functionality. I&#8217;d love to hear from those with experience in this area, especially from site owners who have thousands of items within their media library.</p>\n<p><strong>What naming convention you use to manage your WordPress media library?</strong> Do you use any plugins to aid in media management? I don&#8217;t think my convention is the best, but it works for me.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jun 2014 03:46:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: WPWeekly Episode 152 – Electrifying Interview With Nikhil Vimal Of TechVoltz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=25068&preview_id=25068\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:212:\"http://wptavern.com/wpweekly-episode-152-electrifying-interview-with-nikhil-vimal-of-techvoltz?utm_source=rss&utm_medium=rss&utm_campaign=wpweekly-episode-152-electrifying-interview-with-nikhil-vimal-of-techvoltz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2732:\"<p>At age 15, Nikhil Vimal is the youngest guest to ever be interviewed on WordPress Weekly. Based out of Minnesota, Vimal has <a href=\"http://profiles.wordpress.org/nikv\" title=\"http://profiles.wordpress.org/nikv\">quickly made his mark</a> in the WordPress community. He&#8217;s already spoken at his first WordCamp and contributed to the core of WordPress through the inline documentation project. He&#8217;s also been confirmed to speak at <a href=\"http://2014.milwaukee.wordcamp.org/\" title=\"http://2014.milwaukee.wordcamp.org/\">WordCamp Milwaukee 2014</a>.</p>\n<p>In this interview, we get a unique perspective on what it&#8217;s like to contribute to WordPress at such a young age. We also learn about some of the projects he&#8217;s working on with <a title=\"http://techvoltz.com/\" href=\"http://techvoltz.com/\">TechVoltz.com</a>. This young man has a good head on his shoulders and is in line to be part of the next generation of WordPress developers.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-trunk-adds-new-beta-testing-tab-to-plugins-screen\" title=\"http://wptavern.com/wordpress-trunk-adds-new-beta-testing-tab-to-plugins-screen\">WordPress Trunk Adds New Beta Testing Tab to Plugins Screen</a><br />\n<a href=\"http://wptavern.com/versionpress-adopts-the-gpl-software-license\" title=\"http://wptavern.com/versionpress-adopts-the-gpl-software-license\">VersionPress Adopts The GPL Software License</a><br />\n<a href=\"http://wptavern.com/preview-the-wordpress-menu-customizer-alpha-plugin-ready-for-testing\" title=\"http://wptavern.com/preview-the-wordpress-menu-customizer-alpha-plugin-ready-for-testing\">Preview the WordPress Menu Customizer: Alpha Plugin Ready for Testing</a><br />\n<a href=\"http://wptavern.com/wordpress-themes-suck-at-accessibility-its-time-to-fix-it\" title=\"http://wptavern.com/wordpress-themes-suck-at-accessibility-its-time-to-fix-it\">WordPress Themes Suck at Accessibility: It’s Time to Fix It</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Friday, June 27th 3 P.M. Eastern &#8211; Peter Bui of the <a title=\"http://joomlabe.at/\" href=\"http://joomlabe.at/\">Joomla Beat</a> podcast</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #152:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jun 2014 02:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WordPress.tv: WordPress Security Show: Is Your Site Really Secure? (2/2)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35771\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://wordpress.tv/2014/06/22/wordpress-security-show-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:670:\"<div id=\"v-E2swTpRH-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35771/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35771/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35771&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/22/wordpress-security-show-2/\"><img alt=\"WordPress Security Show: Is Your Site Really Secure? (2/2)\" src=\"http://videos.videopress.com/E2swTpRH/wordpress-security-show-2_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 22 Jun 2014 18:36:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WordPress.tv: WordPress Security Show – Is Your Site Really Secure? (1/2)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35768\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://wordpress.tv/2014/06/22/wordpress-security-show-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:683:\"<div id=\"v-d10sGLb9-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35768/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35768/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35768&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/22/wordpress-security-show-1/\"><img alt=\"WordPress Security Show &#8211; Is Your Site Really Secure? (1/2)\" src=\"http://videos.videopress.com/d10sGLb9/wordpress-security-show-1_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 22 Jun 2014 18:36:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WordPress.tv: Konstantin Obenland: Contributing to WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35765\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wordpress.tv/2014/06/22/konstantin-obenland-contributing-to-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:789:\"<div id=\"v-Nhs9DKsx-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35765/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35765/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35765&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/22/konstantin-obenland-contributing-to-wordpress/\"><img alt=\"「WordPress への貢献（Contributing to WordPress）」 WordCamp Tokyo 2013\" src=\"http://videos.videopress.com/Nhs9DKsx/e3808cwordpress-e381b8e381aee8b2a2e78caeefbc88contributing-to-wordpressefbc89e3808d-wordcamp-tokyo-2013_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 22 Jun 2014 18:15:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: How to Create Demo Data for a BuddyPress Site\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25131\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:154:\"http://wptavern.com/how-to-create-demo-data-for-a-buddypress-site?utm_source=rss&utm_medium=rss&utm_campaign=how-to-create-demo-data-for-a-buddypress-site\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3156:\"<p>When testing BuddyPress themes and plugins, it&#8217;s helpful to have some data to populate the network and demo its social components. Manually adding users with avatars, activity updates, messages, etc,  can be a tedious process. Fortunately, there&#8217;s a way to automate the creation of demo data.</p>\n<p>The <a href=\"http://wordpress.org/plugins/bp-default-data/\" target=\"_blank\">BuddyPress Default Data</a> plugin instantly creates a bunch of users, messages, friend connections, groups, topics, and activity items for testing purposes. Users are created with avatars generated by <a href=\"http://8biticon.com/\" target=\"_blank\">8biticon.com</a>. After installing the plugin, you&#8217;ll have the option to select what kind of demo data you want to create:</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/buddypress-default-data.png\" rel=\"prettyphoto[25131]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/buddypress-default-data.png?resize=1025%2C565\" alt=\"buddypress-default-data\" class=\"aligncenter size-full wp-image-25139\" /></a></p>\n<p>After you make your selections and import the data, you&#8217;ll see a success message detailing all the new data created:</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/success.png\" rel=\"prettyphoto[25131]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/success.png?resize=690%2C364\" alt=\"success\" class=\"aligncenter size-full wp-image-25141\" /></a></p>\n<p>Check your site and you&#8217;ll find all the new members, activity, groups, etc. Activity items will all have the same timestamp, as they were created at the same time.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/activity.png\" rel=\"prettyphoto[25131]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/activity.png?resize=800%2C387\" alt=\"activity\" class=\"aligncenter size-full wp-image-25147\" /></a></p>\n<p>Before using the plugin, you&#8217;ll want to make sure to turn off email notifications for the admin user or else you&#8217;ll blow up your inbox with a ton of emails generated by the data as it&#8217;s created.</p>\n<p>The plugin also has the ability to automatically clean out all the test data when you&#8217;re finished. Using the &#8220;Clear BuddyPress Data&#8221; button will truncate the tables for messages, groups, notifications, friends and forum posts. Be advised that it will delete all users except for the one with ID=1 and all the corresponding data, i.e. usermeta, activity, etc. This plugin should be used with caution and only on a test site.</p>\n<p>Hopefully the <a href=\"http://wordpress.org/plugins/bp-default-data/\" target=\"_blank\">BuddyPress Default Data</a> plugin will save you a little time when testing BuddyPress and its extensions. You can download it from WordPress.org. If WP-CLI is part of your workflow, then you might opt for using Boone Gorges&#8217; <a href=\"http://wptavern.com/a-library-of-wp-cli-commands-for-buddypress\" target=\"_blank\">WP-CLI community package of BuddyPress commands</a>. It allows you to quickly create demo data using the command line.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 22 Jun 2014 02:15:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WordPress.tv: Evan Mullins: Custom Post Types or Choose Your Own Adventure\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35332\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wordpress.tv/2014/06/21/evan-mullins-custom-post-types-or-choose-your-own-adventure/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:697:\"<div id=\"v-4So1Kn1Z-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35332/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35332/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35332&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/21/evan-mullins-custom-post-types-or-choose-your-own-adventure/\"><img alt=\"Evan Mullins: Custom Post Types or Choose Your Own Adventure\" src=\"http://videos.videopress.com/4So1Kn1Z/video-543d09d8a5_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 21 Jun 2014 18:46:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WordPress.tv: Things to Keep in Mind When Programming with WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35774\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wordpress.tv/2014/06/21/things-to-keep-in-mind-when-programming-with-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:696:\"<div id=\"v-6n3ZBvhB-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35774/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35774/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35774&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/21/things-to-keep-in-mind-when-programming-with-wordpress/\"><img alt=\"Things to Keep in Mind When Programming with WordPress\" src=\"http://videos.videopress.com/6n3ZBvhB/wordpress-programming-tips_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 21 Jun 2014 18:10:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WordPress.tv: Renee Hobbs: How We Built the Harrington School Website with WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21682\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://wordpress.tv/2014/06/21/renee-hobbs-how-we-built-the-harrington-school-website-with-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:745:\"<div id=\"v-Pr5wcZsP-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21682/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21682/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21682&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/21/renee-hobbs-how-we-built-the-harrington-school-website-with-wordpress/\"><img alt=\"Renee Hobbs: How We Built the Harrington School Website with WordPress\" src=\"http://videos.videopress.com/Pr5wcZsP/building-the-harrington-school-website_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 21 Jun 2014 18:06:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"WordPress.tv: Mary Baum: The Reality Behind Responsive Design. Does More Responsive Mean Less Design?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35659\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://wordpress.tv/2014/06/20/mary-baum-the-reality-behind-responsive-design-does-more-responsive-mean-less-design/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:755:\"<div id=\"v-E7J8jKmF-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35659/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35659/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35659&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/20/mary-baum-the-reality-behind-responsive-design-does-more-responsive-mean-less-design/\"><img alt=\"Mary Baum: The Reality Behind Responsive Design. Does More Responsive Mean Less Design?\" src=\"http://videos.videopress.com/E7J8jKmF/video-2365764b44_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jun 2014 18:59:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WordPress.tv: Jesse Friedman: The UX of Real-Time Site Personalization\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35474\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wordpress.tv/2014/06/20/jesse-friedman-the-ux-of-real-time-site-personalization/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:695:\"<div id=\"v-G3hiCIid-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35474/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35474/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35474&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/20/jesse-friedman-the-ux-of-real-time-site-personalization/\"><img alt=\"Jesse Friedman: The UX of Real-Time Site Personalization\" src=\"http://videos.videopress.com/G3hiCIid/video-fd76407a73_scruberthumbnail_1.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jun 2014 18:18:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WordPress.tv: Professor Uli Gencarrelle: The Professional Design Process\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wordpress.tv/2014/06/20/professor-uli-gencarrelle-the-professional-design-process/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:699:\"<div id=\"v-5mdFCpsM-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35321/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35321/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35321&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/20/professor-uli-gencarrelle-the-professional-design-process/\"><img alt=\"Professor Uli Gencarrelle: The Professional Design Process\" src=\"http://videos.videopress.com/5mdFCpsM/video-f50dc68caa_scruberthumbnail_1.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jun 2014 18:08:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: WordPress Publish to Twitter Plugin Lets You Tweet by Category\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25103\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"http://wptavern.com/wordpress-publish-to-twitter-plugin-lets-you-tweet-by-category?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-publish-to-twitter-plugin-lets-you-tweet-by-category\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2564:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/tweetbycategory.jpg\" rel=\"prettyphoto[25103]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/tweetbycategory.jpg?resize=772%2C250\" alt=\"tweetbycategory\" class=\"aligncenter size-full wp-image-25114\" /></a></p>\n<p>Last month, Twitter rolled out its new <a href=\"https://blog.twitter.com/2014/another-way-to-edit-your-twitter-experience-with-mute\" target=\"_blank\">mute button feature</a> which allows users to filter out unwanted tweets. This makes it easy for your followers to turn you off entirely if they feel that you&#8217;re overloading them with tweets. Users won&#8217;t always opt to unfollow you, so you&#8217;ll never know who has pushed the mute button and is no longer listening. That&#8217;s why it&#8217;s important not to flood your followers with a constant stream of information that may not be relevant to your core audience.</p>\n<p>In light of the new ease of muting on Twitter, some WordPress publishers may want to consider scaling back the tweets that are automatically sent out when posts are published. <a href=\"https://wordpress.org/plugins/publish-to-twitter/\" target=\"_blank\">Publish to Twitter </a>is a free plugin from the folks at <a href=\"http://10up.com/\" target=\"_blank\">10up</a>. It essentially allows you to tweet by category, instead of publishing all of your posts to Twitter.</p>\n<p>Additionally, the plugin allows you to authorize multiple Twitter accounts and associate categories with each one. This can help you target your content to send to the right group of followers.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/settings.png\" rel=\"prettyphoto[25103]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/settings.png?resize=1025%2C618\" alt=\"settings\" class=\"aligncenter size-full wp-image-25110\" /></a></p>\n<p>In order to use the plugin, you&#8217;ll need to <a href=\"https://apps.twitter.com/apps\" target=\"_blank\">create a new Twitter application</a>, which is an easy/guided process. Next, copy the Consumer and Consumer Secret keys from your new application and paste them into the plugin&#8217;s settings page. You can then successfully associate categories to your authenticated Twitter accounts.</p>\n<p>If you&#8217;re constantly publishing content and automatically sending it to Twitter, this handy plugin may save you from getting muted. Download <a href=\"http://wordpress.org/plugins/publish-to-twitter/\" target=\"_blank\">Publish to Twitter</a> for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jun 2014 18:08:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Quick Reference Guide For Those Writing About WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24430\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:174:\"http://wptavern.com/quick-reference-guide-for-those-writing-about-wordpress?utm_source=rss&utm_medium=rss&utm_campaign=quick-reference-guide-for-those-writing-about-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4512:\"<p>After participating in the WordPress community for several years, it&#8217;s easy to forget there are new users entering the community every day. As someone who writes about WordPress for a living, it&#8217;s frustrating to come across errors such as the incorrect spelling of WordPress or the incorrect logo being used. However, I&#8217;ve discovered that most of the time, they just don&#8217;t know any better. Even established websites make simple mistakes such as labeling Automattic as the parent company of WordPress.</p>\n<p>The following cheat sheet for newcomers and veterans of WordPress quickly addresses some of the most common mistakes often made when writing about WordPress. It also has general information about the project for quick reference.</p>\n<ol>\n<li>WordPress is camel cased meaning the P is capitalized. It&#8217;s spelled WordPress.</li>\n<li>WordPress is a <a title=\"http://wordpressfoundation.org/trademark-policy/\" href=\"http://wordpressfoundation.org/trademark-policy/\">registered trademark</a>. As such, you&#8217;re not allowed to have WordPress in the domain name without explicit permission.</li>\n<li>Here is the <a title=\"http://wordpress.org/about/logos/\" href=\"http://wordpress.org/about/logos/\">correct WordPress logo</a> to use. Notice the short and squat versus the tall and eloquent.</li>\n<li><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2009/02/correct-wordpress-logos.png\" rel=\"prettyphoto[24430]\"><img class=\"aligncenter size-full wp-image-408\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2009/02/correct-wordpress-logos.png?resize=743%2C452\" alt=\"correct-wordpress-logos\" /></a></li>\n<li>WordPress the open source project is free (free as in speech) and licensed under the <a title=\"http://wordpress.org/about/license/\" href=\"http://wordpress.org/about/license/\">GPLv2</a></li>\n<li>Automattic does not own WordPress and is not the parent company of WordPress. It&#8217;s the parent company of <a href=\"http://www.wordpress.com\">WordPress.com</a>.</li>\n<li><a title=\"http://www.wordpress.org\" href=\"http://www.wordpress.org\">WordPress.org</a> is a free open source project anyone can use. WordPress.com is a hosted platform. A good analogy is to think of WordPress the open source project as a house that you can manipulate any way you want. WordPress.com is like an apartment complex. <a title=\"http://en.support.wordpress.com/com-vs-org/\" href=\"http://en.support.wordpress.com/com-vs-org/\">This guide</a> explains the major differences between the two.</li>\n<li>Matt Mullenweg and Mike Little are the creators of WordPress. For historical purposes, <a title=\"http://ma.tt/2003/01/the-blogging-software-dilemma/\" href=\"http://ma.tt/2003/01/the-blogging-software-dilemma/\">read this post and the first comment</a> which is considered the birth of WordPress.</li>\n<li>WordPress the open source project <a title=\"http://wordpress.org/about/\" href=\"http://wordpress.org/about/\">was started in 2003</a> and is over 10 years old.</li>\n<li>Matt Mullenweg is the CEO of <a title=\"http://automattic.com/\" href=\"http://automattic.com/\">Automattic</a>, the founder of the non-profit <a title=\"http://wordpressfoundation.org/\" href=\"http://wordpressfoundation.org/\">WordPress Foundation</a>, occasional lead developer for the open source WordPress Project, and owner of investment company <a title=\"http://audrey.co/\" href=\"http://audrey.co/\">Audrey.co</a>.</li>\n<li>The <a title=\"http://wordpress.org/support/\" href=\"http://wordpress.org/support/\">WordPress.org support forum</a> is staffed by non-paid volunteers.</li>\n<li>The recommended place to download <a title=\"http://wordpress.org/themes/\" href=\"http://wordpress.org/themes/\">WordPress themes</a> and <a title=\"http://wordpress.org/plugins/\" href=\"http://wordpress.org/plugins/\">plugins</a> is from their respective directories. Every theme and plugin hosted on WordPress.org is free of charge.</li>\n<li>13. It’s Automattic with two t&#8217;s. via <a title=\"http://wptavern.com/quick-reference-guide-for-those-writing-about-wordpress#comment-56126\" href=\"http://wptavern.com/quick-reference-guide-for-those-writing-about-wordpress#comment-56126\">Michael Quinn</a></li>\n</ol>\n<p>This is by no means an exhaustive list. If you have any tips or suggestions, please add them in the comments. I&#8217;ll keep the post updated so it can be a relevant, living guide. By the way, if you read an article about WordPress that contains a mistake, respectfully point the author in the right direction.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jun 2014 18:01:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"WordPress.tv: Tony Archambeau : Accessibilité &amp; WordPress : créer des sites pour tous les utilisateurs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=36016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"http://wordpress.tv/2014/06/20/tony-archambeau-accessibilite-wordpress-creer-des-sites-pour-tous-les-utilisateurs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:707:\"<div id=\"v-32bCd27X-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/36016/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/36016/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=36016&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/20/tony-archambeau-accessibilite-wordpress-creer-des-sites-pour-tous-les-utilisateurs/\"><img alt=\"15 &#8211; Tony Archambeau-Conf-WCParis2014.mp4\" src=\"http://videos.videopress.com/32bCd27X/video-53502ee6a0_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jun 2014 10:20:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: CLI Cheat Sheet: A Beginner’s Resource for Using the Command Line\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25005\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:190:\"http://wptavern.com/cli-cheat-sheet-a-beginners-resource-for-using-the-command-line?utm_source=rss&utm_medium=rss&utm_campaign=cli-cheat-sheet-a-beginners-resource-for-using-the-command-line\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1887:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/cheatsheet.png\" rel=\"prettyphoto[25005]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/cheatsheet.png?resize=900%2C429\" alt=\"cheatsheet\" class=\"aligncenter size-full wp-image-25078\" /></a></p>\n<p><a href=\"https://github.com/WebDevStudios/CLI-Cheat-Sheet\" target=\"_blank\">CLI Cheat Sheet</a> is a handy new resource for any WordPress developer who is just getting started with the command line. This week on the <a href=\"http://dradcast.com/\" target=\"_blank\">Dradcast</a>, Brad Williams linked to the cheat sheet, which the folks at <a href=\"http://webdevstudios.com/\" target=\"_blank\">WebDevStudios</a> put together for their team. They decided to share the resource with the community.</p>\n<p>The repository is broken down into several files, separated by command type, including:</p>\n<ul>\n<li>General Command Line (CLI) basics</li>\n<li>Git Commands</li>\n<li>Grunt Commands</li>\n<li>Server Commands</li>\n<li>Moderate/Advanced Commands</li>\n</ul>\n<p>The basic commands document covers the very basics, such as changing directories and opening files. A section for more moderate/advanced commands is prefaced with a friendly notation: &#8220;The somewhat scary crevices of the command line.&#8221;</p>\n<p>The team at WebDevStudios plans to continue building out the cheat sheet and will be adding more commands into the repo as they are using them and remember them. If you want to share a few commands that every beginner ought to know, feel free to contribute on GitHub.</p>\n<p>Make sure to star the <a href=\"https://github.com/WebDevStudios/CLI-Cheat-Sheet\" target=\"_blank\">CLI Cheat Sheet</a> repo for easy reference and check back periodically for more commands. If you&#8217;re just starting with the command line, this is a nice resource to help you grasp the basics and get your footing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jun 2014 03:06:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"WPTavern: GravityForms Detected On 53% Of The Top 1 Million Sites Ranked By Alexa Using Hosted Forms\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:204:\"http://wptavern.com/gravityforms-detected-on-53-of-the-top-1-million-sites-ranked-by-alexa?utm_source=rss&utm_medium=rss&utm_campaign=gravityforms-detected-on-53-of-the-top-1-million-sites-ranked-by-alexa\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2702:\"<p><a title=\"http://www.datanyze.com\" href=\"http://www.datanyze.com\">Datanyze</a>, a company specializing in determining what web technologies are being used based on their code signature, <a title=\"http://www.datanyze.com/market-share/forms/\" href=\"http://www.datanyze.com/market-share/forms/\">has new data</a> indicating GravityForms has the most market share. Out of the top one million websites ranked by Alexa <strong>that use hosted forms</strong>, GravityForms was detected on 53.3% of them. That&#8217;s more than all of the other form plugins and services in the chart combined.</p>\n<div id=\"attachment_25053\" class=\"wp-caption aligncenter\"><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/GFormsDatanyzeChart.png\" rel=\"prettyphoto[25017]\"><img class=\"size-full wp-image-25053\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/GFormsDatanyzeChart.png?resize=636%2C503\" alt=\"GravityForms Leading The Way With 53.3%\" /></a><p class=\"wp-caption-text\">GravityForms Leading The Way With 53.3%</p></div>\n<p>I&#8217;m surprised Ninja Forms or Contact Form 7 is not on the pie chart. I thought Contact Form 7 would be their biggest competitor but it turns out it&#8217;s Wufoo and other form generating services. I contacted Datanyze to figure out if those systems are tracked or not.</p>\n<p>Jon Hearty of Datanyze said, &#8220;The reason they aren&#8217;t there is because we do not currently track them. We add technologies everyday, usually based on requests from our customers and prospects.&#8221;</p>\n<p>Datanyze explains on their <a title=\"http://www.datanyze.com/faq/#market-share\" href=\"http://www.datanyze.com/faq/#market-share\">frequently asked questions</a> page how they obtain the data and determine code signatures.</p>\n<blockquote><p>Most web technologies have certain footprints or &#8220;signatures&#8221; when used by one of the websites. For example, if you view the HTML code for any WordPress site, you will find something like this: <i>&lt;meta name=&#8221;generator&#8221; content=&#8221;WordPress &#8230;&#8221; /&gt;</i>. By finding and cataloging these signatures, Datanyze can determine not only which technologies a website is using, but also when they added or dropped them.</p></blockquote>\n<p>With the top one million websites ranked by Alexa changing each month, the data represented in the pie chart is only a snapshot of time. But what the data shows is that GravityForms is doing exceptionally well, especially against the other form solutions being monitored.</p>\n<p>I&#8217;d love to see more WordPress specific contact form solutions added to the chart such as Contact Form 7 and Ninja forms just to get a more complete picture.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jun 2014 21:40:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: Make Forms More User-Friendly With the Chosen jQuery Plugin for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=25021\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:210:\"http://wptavern.com/make-forms-more-user-friendly-with-the-chosen-jquery-plugin-for-wordpress?utm_source=rss&utm_medium=rss&utm_campaign=make-forms-more-user-friendly-with-the-chosen-jquery-plugin-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4747:\"<div id=\"attachment_25058\" class=\"wp-caption aligncenter\"><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/long-list.jpg\" rel=\"prettyphoto[25021]\"><img class=\"size-full wp-image-25058\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/long-list.jpg?resize=1025%2C477\" alt=\"photo credit: Orí - cc\" /></a><p class=\"wp-caption-text\">photo credit: <a href=\"http://www.flickr.com/photos/ori/2467863551/\">Orí</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a></p></div>\n<p>Select boxes with a long list of options can quickly get out of hand. One common example is a state or country dropdown. Perhaps you&#8217;ve become desensitized to the expert scrolling and mousework required to navigate the most cumbersome select boxes. Ordinarily, they&#8217;re anything but user-friendly.</p>\n<p><a href=\"http://harvesthq.github.io/chosen/\" target=\"_blank\">Chosen</a> is a handy jQuery plugin created by the folks at <a href=\"http://www.getharvest.com/\" target=\"_blank\">Harvest</a> with the purpose of making select boxes more customizable and easier to use. The project is well maintained and has received contributions from more than 70 contributors on GitHub. You can view a <a href=\"http://harvesthq.github.io/chosen/\" target=\"_blank\">live example</a> of Chosen on its project demo page with side by side comparisons to browser default select boxes.</p>\n<p>With Chosen in place, simple select boxes get a larger, more sleek display with an auto-suggest-enabled search box at the top:</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/simple-select.png\" rel=\"prettyphoto[25021]\"><img class=\"aligncenter size-full wp-image-25035\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/simple-select.png?resize=362%2C267\" alt=\"simple-select\" /></a></p>\n<p>Multiple select boxes are notoriously difficult to use for making multiple selections. Chosen allows you to type in your selections and easily view / remove selections.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/multiple-select.png\" rel=\"prettyphoto[25021]\"><img class=\"aligncenter size-full wp-image-25037\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/multiple-select.png?resize=370%2C170\" alt=\"multiple-select\" /></a></p>\n<p>It also has optgroup support for multiple select boxes with groups:</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/multiple-select-with-groups.png\" rel=\"prettyphoto[25021]\"><img class=\"aligncenter size-full wp-image-25038\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/multiple-select-with-groups.png?resize=363%2C257\" alt=\"multiple-select-with-groups\" /></a></p>\n<p>Those are just a couple of examples of how Chosen makes long, unwieldy select boxes more user-friendly. The <a href=\"http://harvesthq.github.io/chosen/\" target=\"_blank\">project demo page </a>includes additional examples and instructions on how to customize the default text, change the no results text, limit selected options, add right to left support and much more.</p>\n<h3>Chosen for WordPress</h3>\n<p>The good news for WordPress users is that <a href=\"http://find.brentshepherd.com/\" target=\"_blank\">Brent Shepherd</a> wrote a plugin that utilizes Chosen with select boxes in posts and pages. If your site has a form with a long select box, you may want to check out <a href=\"http://wordpress.org/plugins/chosen/\" target=\"_blank\">Chosen for WordPress</a>.</p>\n<p>It applies Chosen to any select box within post or page content and will only load the relevant JS and CSS files if a select box is included in your form. The plugin has support out of the box for the [ contact-form ] shortcode which is used by the Grunion Contact form, Contact Form 7, and Jetpack. You can also force the Chosen script and styles to load on a page by including the [ chosen ] shortcode.</p>\n<p>Chosen works nicely for contact forms that have long location select boxes or questions with a limited list of possible answers. Another excellent use case for the script is with BuddyPress profile fields. Profile questions are a common place where you might find long, cumbersome select boxes. Putting the power of Chosen to work for BuddyPress would be a welcome addition to the compatibility already included for contact form plugins.</p>\n<p>Browser support includes Firefox, Chrome, Safari and IE9. Chosen also has legacy support for IE8. Please note that the script is currently disabled on iPhone, iPod Touch, and Android mobile devices.</p>\n<p>If you like how Chosen transforms select boxes, you can download <a href=\"http://wordpress.org/plugins/chosen/\" target=\"_blank\">Chosen for WordPress</a> for free from the official plugin directory.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jun 2014 20:38:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WordPress.tv: Steven Slack: Information Architecture Has Everything To Do With Your Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35867\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://wordpress.tv/2014/06/19/steven-slack-information-architecture-has-everything-to-do-with-your-theme/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:727:\"<div id=\"v-dxPg3Io1-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35867/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35867/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35867&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/19/steven-slack-information-architecture-has-everything-to-do-with-your-theme/\"><img alt=\"Steven Slack: Information Architecture Has Everything To Do With Your Theme\" src=\"http://videos.videopress.com/dxPg3Io1/video-6529b2a834_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jun 2014 18:25:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WordPress.tv: Sean Malseed: How to Monetize WordPress with AdSense\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35864\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wordpress.tv/2014/06/19/sean-malseed-how-to-monetize-wordpress-with-adsense/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:681:\"<div id=\"v-yeTV2ksT-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35864/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35864/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35864&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/19/sean-malseed-how-to-monetize-wordpress-with-adsense/\"><img alt=\"Sean Malseed: How to Monetize WordPress with AdSense\" src=\"http://videos.videopress.com/yeTV2ksT/video-7eca220f61_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jun 2014 18:21:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WordPress.tv: Keeping Up Your Site: Maintenance, Monetization, and Self-Branding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35775\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"http://wordpress.tv/2014/06/19/keeping-up-your-site-maintenance-monetization-and-self-branding/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:716:\"<div id=\"v-zoFmlSC4-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35775/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35775/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35775&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/19/keeping-up-your-site-maintenance-monetization-and-self-branding/\"><img alt=\"Keeping Up Your Site: Maintenance, Monetization, and Self-Branding\" src=\"http://videos.videopress.com/zoFmlSC4/keeping-up-with-your-site_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jun 2014 18:10:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: What’s Your Perception Of ThemeForest?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24827\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"http://wptavern.com/whats-your-perception-of-themeforest?utm_source=rss&utm_medium=rss&utm_campaign=whats-your-perception-of-themeforest\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3782:\"<p>Philip Arthur Moore has <a title=\"https://philiparthurmoore.com/ruining-wordpress/\" href=\"https://philiparthurmoore.com/ruining-wordpress/\">published a great post</a> that I think strikes a nerve for many. Although the entire article is blockquote worthy, I think the most important point he made is that WordPress developers need to step up their game and stop contributing to the perception that WordPress sucks.</p>\n<p>Whether you&#8217;re a theme or plugin developer, turning on <a title=\"http://codex.wordpress.org/WP_DEBUG\" href=\"http://codex.wordpress.org/WP_DEBUG\">WP_DEBUG</a> only helps you. It&#8217;s a simple step and helps catch general coding errors before shipping products. Later in the article, Moore requested that ThemeForest sellers turn on WP_DEBUG before selling a theme.</p>\n<blockquote><p>All ThemeForest authors need to turn on <a href=\"https://core.trac.wordpress.org/ticket/28551\"><code>WP_DEBUG</code></a>. I don’t care about your GPL choices or your mega-menus or your features arms race towards taking a 70% cut on $40 USD for an unsustainable lifetime of support and free updates. All I care about is that you turn on <a href=\"https://core.trac.wordpress.org/ticket/28551\"><code>WP_DEBUG</code></a>. Your buggy products are hurting WordPress and making everyone in the WordPress community miserable, from support people to developers to consumers. You’re ruining trust in WordPress and you’re making the platform seem amateurish and childish.</p></blockquote>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2010/09/themeforestlogo.png\" rel=\"prettyphoto[24827]\"><img class=\"alignright size-full wp-image-4550\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2010/09/themeforestlogo.png?resize=295%2C150\" alt=\"theme forest logo\" /></a>ThemeForest is a huge presence in the community.  It&#8217;s the go to marketplace for commercial WordPress themes for several users, so it&#8217;s really important that the marketplace does everything it can to encourage <a title=\"http://codex.wordpress.org/WordPress_Coding_Standards\" href=\"http://codex.wordpress.org/WordPress_Coding_Standards\">best practices</a>. In fact, their <a title=\"http://support.envato.com/index.php?/Knowledgebase/Article/View/472\" href=\"http://support.envato.com/index.php?/Knowledgebase/Article/View/472\">theme submission guidelines</a> specifically state that, &#8220;Themes must not have any PHP notices, warnings, or errors &#8211; please develop with errors enabled, and <a href=\"http://codex.wordpress.org/WP_DEBUG\"><em>WP_DEBUG</em></a> set to <em>true</em>.&#8221; There&#8217;s no excuse for ThemeForest themes to generate errors.</p>\n<p>That brings me to my poll question.</p>\nNote: There is a poll embedded within this post, please visit the site to participate in this post\'s poll.\n<p>Based on everything I&#8217;ve read and the commercial plugin developers I&#8217;ve talked to, the perception of ThemeForest is that it&#8217;s a place to buy good-looking, poorly coded themes. I&#8217;ve never purchased a theme from them myself, but have <a title=\"http://wptavern.com/wpweekly-episode-137-making-a-living-on-themeforest-with-jonathan-atkinson\" href=\"http://wptavern.com/wpweekly-episode-137-making-a-living-on-themeforest-with-jonathan-atkinson\">interviewed theme sellers such as Jonathan Atkinson</a> doing their part to try to change this mind-set.</p>\n<p>Ironically, the comments on Moore&#8217;s post have been disabled <a title=\"http://wptavern.com/why-comments-still-matter\" href=\"http://wptavern.com/why-comments-still-matter\">which is terrible</a> considering he raised a number of great discussion points. What do you think of his article and the general idea that every developer is responsible for the perception of WordPress?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jun 2014 01:33:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: WordCamp San Francisco to Host WordPress Community Summit and Contributor Meetups\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24974\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:226:\"http://wptavern.com/wordcamp-san-francisco-to-host-wordpress-community-summit-and-contributor-meetups?utm_source=rss&utm_medium=rss&utm_campaign=wordcamp-san-francisco-to-host-wordpress-community-summit-and-contributor-meetups\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2723:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/wcsf.jpeg\" rel=\"prettyphoto[24974]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/wcsf.jpeg?resize=810%2C300\" alt=\"wcsf\" class=\"aligncenter size-full wp-image-24984\" /></a></p>\n<p><a href=\"http://2014.sf.wordcamp.org/\" target=\"_blank\">WordCamp San Francisco</a> is one of the most important WordPress events of the year. Contributors from all over the globe travel to connect and inspire one another at the event where Matt Mullenweg traditionally delivers the annual State of the Word address.</p>\n<p>This year the activities will be spread out over five days to incorporate community and contributor events. Saturday and Sunday, October 25-26 will will be dedicated to the 2-track WordCamp conference at <a href=\"http://2014.sf.wordcamp.org/location/\" target=\"_blank\">Mission Bay Conference Center</a>. The organization team expects approximately 800 attendees. Applications for <a href=\"http://2014.sf.wordcamp.org/2014/06/16/speaking-at-wordcamp-san-francisco/\" target=\"_blank\">speaking at WordCamp San Francisco</a> are now open, and you can even nominate speakers for the event.</p>\n<p>The <a href=\"http://2014.sf.wordcamp.org/schedule/community-summit/\" target=\"_blank\">WordPress Community Summit</a>  will take place on Monday, October 27. Unlike the first summit, which was held in 2012 by invitation only, this year&#8217;s event will have an open signup form. Signups will be reviewed in order to ensure each attendee&#8217;s involvement in the open source project.</p>\n<p>Tuesday and Wednesday, October 28-29, will be dedicated to <a href=\"http://2014.sf.wordcamp.org/schedule/contributor-team-meetups/\" target=\"_blank\">mini-meetups for WordPress contributor teams</a> where they will connect in person and work on projects together. The agenda and goals for these days will be decided in advance on the team blogs.</p>\n<p>WordCamp San Francisco organizers are expanding the <a href=\"http://2014.sf.wordcamp.org/location/travel-assistance/\" target=\"_blank\">travel assistance program</a> this year in order to help bring in a more diverse group of WordPress contributors, users, and educators. The <a href=\"http://2014.sf.wordcamp.org/location/travel-assistance/\" target=\"_blank\">application</a> deadline for travel assistance is June 30, 2014. Anyone who is unable to attend the event without financial assistance is encouraged to apply.</p>\n<p>If you want to get in on a week&#8217;s worth of top-notch WordPress events, make sure to put the WordCamp San Francisco dates on your calendar. Follow <a href=\"https://twitter.com/WordCampSF\" target=\"_blank\">@WordCampSF</a> on Twitter to find out when tickets go on sale.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jun 2014 23:17:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Ravel By ThemeHybrid Is A Modern WordPress Theme Designed By Tung Do\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24911\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:200:\"http://wptavern.com/ravel-by-themehybrid-is-a-modern-wordpress-theme-designed-by-tung-do?utm_source=rss&utm_medium=rss&utm_campaign=ravel-by-themehybrid-is-a-modern-wordpress-theme-designed-by-tung-do\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5026:\"<p>Ravel is a <a title=\"http://themehybrid.com/weblog/ravel-wordpress-theme\" href=\"http://themehybrid.com/weblog/ravel-wordpress-theme\">free new WordPress theme</a> released by ThemeHybrid with a focus on blog, portfolio, and professional sites. It&#8217;s the result of teamwork between Justin Tadlock and Tung Do. Ravel is slick, modern, and has an eye pleasing color scheme.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/RavelScreenshot.jpg\" rel=\"prettyphoto[24911]\"><img class=\"aligncenter size-full wp-image-24946\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/RavelScreenshot.jpg?resize=800%2C709\" alt=\"Screenshot Of Ravel\" /></a>One of my favorite features of Ravel is the social icons that blend in seamlessly with the design. Ravel also makes use of <a title=\"http://justintadlock.com/archives/2013/08/07/social-media-nav-menus\" href=\"http://justintadlock.com/archives/2013/08/07/social-media-nav-menus\">Tadlock&#8217;s technique</a> of using menus to add social media links making it easy to add and remove buttons. If you&#8217;re planning on using this theme to blog, the content width is only 540 pixels which is a bit cramped for my liking. Because of the cramped content space and the sidebar, it&#8217;s easy to have a post title look like a paragraph. I&#8217;d like to see at least 600 pixels dedicated to the blog portion of the theme.</p>\n<div id=\"attachment_24951\" class=\"wp-caption aligncenter\"><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/SmallContentWidthInRavel.png\" rel=\"prettyphoto[24911]\"><img class=\"size-full wp-image-24951\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/SmallContentWidthInRavel.png?resize=1025%2C285\" alt=\"Post Titles Can Easily Look Like Paragraphs\" /></a><p class=\"wp-caption-text\">Post Titles Can Easily Look Like Paragraphs</p></div>\n<p>The theme is responsive but instead of shoving all of the sidebar widgets below the site, Ravel keeps the sidebar as is and hides it. It&#8217;s accessible via a red icon that expands or contracts the sidebar. I&#8217;m curious as to whether users prefer this method over the typical behavior.</p>\n<div id=\"attachment_24953\" class=\"wp-caption aligncenter\"><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/ResponsiveSidebar.png\" rel=\"prettyphoto[24911]\"><img class=\"size-full wp-image-24953\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/ResponsiveSidebar.png?resize=940%2C633\" alt=\"Expanding or Hiding The Sidebar In Ravel\" /></a><p class=\"wp-caption-text\">Expanding or Hiding The Sidebar In Ravel</p></div>\n<p>Ravel has built-in support for the <a title=\"http://themehybrid.com/plugins/custom-content-portfolio\" href=\"http://themehybrid.com/plugins/custom-content-portfolio\">Custom Content Portfolio</a> plugin. This plugin allows you to manage your portfolio of design, photography, and other artwork. One of the other nice features is the custom made tabs widget. You&#8217;ll find it in the widgets administration area labeled as <strong>Ravel Tabs</strong>. Ravel Tabs is like four widgets in one. It displays recent <em>posts</em>, <em>popular posts</em>, <em>recent comments</em>, and a <em>tag cloud</em>. (Do people still use tag clouds anymore?) Tabbed widget plugins can be finicky to configure and sometimes, they don&#8217;t work well with themes. Ravel Tabs works great and is easy to configure.</p>\n<p>Ravel contains an introductory template. This is great to use as your site&#8217;s frontpage instead of the most recent blog posts. One feature that sets ThemeHybrid themes apart from others is the use of <a title=\"http://codex.wordpress.org/Function_Reference/add_editor_style\" href=\"http://codex.wordpress.org/Function_Reference/add_editor_style\">custom styles</a> for the visual editor. This stylesheet enables the visual editor to take on the look and feel of the frontend of the site, delivering a <em>what you see is what you get</em> experience. Although I prefer a darker style for the visual editor, I wonder if users will see it as a downside because of the contrast difference between the surrounding meta boxes and the editor.</p>\n<div id=\"attachment_24965\" class=\"wp-caption aligncenter\"><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/VisualEditorStyleInRavel.png\" rel=\"prettyphoto[24911]\"><img class=\"size-full wp-image-24965\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/VisualEditorStyleInRavel.png?resize=920%2C683\" alt=\"Visual Editor Style Matches The Frontend Of Ravel\" /></a><p class=\"wp-caption-text\">Visual Editor Style Matches The Frontend Of Ravel</p></div>\n<p>Ravel is a great looking theme that has a look and style I&#8217;d pay for. It&#8217;s available for free from <a title=\"http://themehybrid.com/themes/ravel\" href=\"http://themehybrid.com/themes/ravel\">ThemeHybrid</a> and soon, the WordPress.org Theme Directory. Tadlock said the theme has already been submitted to the directory and that&#8217;s where future updates will come from.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jun 2014 21:08:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: WordPress Themes Suck at Accessibility: It’s Time to Fix It\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24915\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:178:\"http://wptavern.com/wordpress-themes-suck-at-accessibility-its-time-to-fix-it?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-themes-suck-at-accessibility-its-time-to-fix-it\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11140:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/simone.png\" rel=\"prettyphoto[24915]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/simone.png?resize=300%2C224\" alt=\"simone\" class=\"alignright size-medium wp-image-24929\" /></a>Earlier this month WordPress developer <a href=\"http://mor10.com/\" target=\"_blank\">Morten Rand-Hendriksen</a> released <a href=\"http://wordpress.org/themes/simone\" target=\"_blank\">Simone</a>, a free theme based on <a href=\"http://underscores.me/\" target=\"_blank\">Underscores</a>. Like many themes, Simone is responsive, wired for translation, utilizes the customizer, and includes editor styles. One feature, however, sets Simone apart &#8211; a heavy emphasis on accessibility.</p>\n<p>Rand-Hendriksen believes that the accessibility-ready tag should be <a href=\"http://mor10.com/accessibility-ready-tag-required-wordpress-themes/\" target=\"_blank\">required for all WordPress themes</a>. <strong>&#8220;My main inspiration for accessibility is that I want everyone, regardless of accessibility challenges, to be able to access all content on the web in the way they want and/or need,&#8221;</strong> he said. To that end, he has educated himself on the requirements for making a WordPress theme accessible. He is, however, only one among a very small minority of theme developers to do so.</p>\n<h3>WordPress Themes Lag in Meeting Accessibility Guidelines</h3>\n<p>&#8220;The alarming reality is only a handful of WordPress themes (and thus WordPress-powered sites) meet basic accessibility guidelines,&#8221; Rand-Hendriksen said. As WordPress powers an ever-increasing segment of the web, the platform and its themes play a big role in the accessibility of the web as a whole.</p>\n<p>&#8220;<span class=\"pullquote alignleft\">Accessibility can no longer be treated as a bonus feature</span>,&#8221; Rand-Hendriksen told the Tavern. &#8220;In many countries it is now a legislated requirement and that trend will likely go global in a few years.&#8221;</p>\n<p>When examining the official WordPress Themes Directory, you&#8217;ll be hard-pressed to find much of a selection when it comes to <a href=\"http://wordpress.org/themes/tags/accessibility-ready\" target=\"_blank\">accessibility-ready</a> themes. In fact, there&#8217;s only one page of them. Rand-Hendriksen calculates that accessibility-ready themes account for &#8220;a dismal 0.5%,&#8221; and said that the directory is severely lagging in regard to presenting options.</p>\n<p>One major reason for this is that theme developers mistakenly believe that meeting accessibility guidelines is only for the experts. <strong>&#8220;In building Simone I wanted to prove that building an accessibility-ready theme is not hard and does not require a lot of extra work,&#8221;</strong> Rand-Hendriksen said. He believes that if you can follow web standards, then you can build accessible WordPress themes.</p>\n<blockquote><p>For the most part, the challenges involved in web accessibility are imaginary and based on the myth that accessibility is hard and expensive. Here&#8217;s the thing: It&#8217;s neither. Web accessibility mainly has to do with following web standards and coding for content first. This does require a bit of a reframing of the development process which historically is mainly focused on getting code to match intricate designs, but that is not a hindrance.</p></blockquote>\n<p>Rand-Hendriksen chose <a href=\"http://underscores.me/\" target=\"_blank\">Underscores</a> as a base for Simone because it meets nearly all of the <a href=\"http://make.wordpress.org/themes/guidelines/guidelines-accessibility/\" target=\"_blank\">requirements for using the accessibility-ready tag</a> on a WordPress theme.  He subsequently submitted two patches to _s that got baked in to get it even closer to the specifications. From there the only thing remaining was to make the drop-down menu keyboard accessible and continue following web and WCAG standards as he built the theme.</p>\n<h3>Resources for Building Accessibility as a Baseline Requirement</h3>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/05/guided-road.jpg\" rel=\"prettyphoto[24915]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/05/guided-road.jpg?resize=900%2C421\" alt=\"guided-road\" class=\"aligncenter size-full wp-image-22575\" /></a></p>\n<p>Rand-Hendriksen&#8217;s advice for theme developers looking to build accessibility-ready themes: Change your mindset so that accessibility considerations are no longer an afterthought.</p>\n<blockquote><p>The key is to build accessibility in as a baseline requirement, not a feature added on after the fact. When you start building accessibility in as a baseline you discover your code gets more structured, easier to understand, and as a developer you start caring more about the content itself, not just how to bend to the will of the design.</p></blockquote>\n<p>Once you&#8217;ve made up your mind to develop accessible themes, there are many excellent resources available to help you. &#8220;The Accessibility Project recently published a set of <a href=\"http://wptavern.com/ http://a11yproject.com/patterns/\" target=\"_blank\">living patterns</a> that can be baked into any project,&#8221; Rand-Hendriksen advised. His next step on the Simone theme is to swap out the currently accessible (albeit a bit clunky) Superfish menu for the one proposed in the pattern library.</p>\n<p>Rand-Hendriksen cites the <a href=\"http://make.wordpress.org/themes/guidelines/guidelines-accessibility/\" target=\"_blank\">WordPress Theme Accessibility Guidelines</a> as a helpful resource for keeping your theme on the right track. The instructions there are straight-forward and easy to follow and understand. &#8220;Most of them are just web standards that should be followed anyway,&#8221; he said.</p>\n<p>He outlined the process for submitting an accessibility-ready theme to WordPress.org:</p>\n<blockquote><p>Once a theme is submitted to the Directory with the accessibility-tag applied it will be manually tested by the WP Accessibility Team (currently Joe Dolson is the sole person responsible for doing this). They (or rather he) will go through the theme with a fine-toothed comb, test everything, and come back with very detailed instructions on what, if anything, needs to be changed.</p></blockquote>\n<p>Rand-Hendriksen believes that the process doesn&#8217;t have to be complicated. His advice? Start with _s, add in a solution for a keyboard accessible menu, and follow web standards. You&#8217;ll be well on your way to being able to use that accessibility-ready tag.</p>\n<p>&#8220;In addition, I run my themes through a set of manual tests that include disabling my mouse and working with the theme for several hours, using <a href=\"https://chrome.google.com/webstore/detail/chromevox/kgejglhpjiefppelpmljglcjbhoiplfn?hl=en\" target=\"_blank\">ChromeVox</a> to experience the theme through a screen reader, and using voice commands and screen readers on mobile devices to make sure everything works as expected.&#8221;</p>\n<p>For ensuring that contrasts are high enough, Rand-Hendriksen recommends the<a href=\"http://leaverou.github.io/contrast-ratio/\" target=\"_blank\"> Contrast Ratio tool</a> built by Lea Verou.</p>\n<h3>7 Practical Tips for Developing Accessible WordPress Themes</h3>\n<p>Most WordPress theme developers don&#8217;t consider themselves to be accessibility experts. In reality, you already have all of the knowledge and tools you need to start getting your themes up to standards. Someday, meeting accessibility requirements may be mandated by law, so if you want to be ahead of the game you should start now.</p>\n<p>How can you make accessibility part of your standard baseline for all projects? In summary, a few of the practical takeaways from our interview with Morten Rand-Hendriksen include:</p>\n<ul>\n<li>Get a new mindset: Build accessibility in as a baseline requirement, not a feature added on after the fact.</li>\n<li>If you don&#8217;t know where to start, try <a href=\"http://underscores.me/\" target=\"_blank\">Underscores</a> as a base theme for meeting most of the requirements</li>\n<li>Check out the Accessibility Project&#8217;s <a href=\"http://a11yproject.com/patterns/\" target=\"_blank\">widget and pattern library</a></li>\n<li>Familiarize yourself with <a href=\"http://make.wordpress.org/themes/guidelines/guidelines-accessibility/\" target=\"_blank\">WordPress&#8217; guidelines for the accessibility-ready tag</a>\n<li>Try disabling your mouse and working with your theme with <a href=\"https://chrome.google.com/webstore/detail/chromevox/kgejglhpjiefppelpmljglcjbhoiplfn?hl=en\" target=\"_blank\">ChromeVox</a></li>\n<li>Use voice commands and screen readers on mobile devices to make sure everything works</li>\n<li>Make sure contrast ratios are high enough using this <a href=\"http://leaverou.github.io/contrast-ratio/\" target=\"_blank\">handy tool</a> built by Lea Verou</li>\n</ul>\n<h3>Why is Accessibility Such a Big Deal?</h3>\n<p><div id=\"attachment_24960\" class=\"wp-caption aligncenter\"><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/prevailing-sentiment.jpg\" rel=\"prettyphoto[24915]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/prevailing-sentiment.jpg?resize=1024%2C429\" alt=\"photo credit: allaboutgeorge - cc\" class=\"size-full wp-image-24960\" /></a><p class=\"wp-caption-text\">photo credit: <a href=\"http://www.flickr.com/photos/allaboutgeorge/2325230694/\">allaboutgeorge</a> &#8211; <a href=\"http://creativecommons.org/licenses/by/2.0/\">cc</a></p></div>If the dire lack of accessible WordPress themes on WordPress.org is any indication, then 99%+ of WordPress theme developers have no concern for accessibility. The rationale behind not caring is usually something like this: <strong>The vast majority of the people who access my website will not be disabled at all, so why should I care?</strong></p>\n<p>Rand-Hendriksen believes that accessibility is a rights issue:</p>\n<blockquote><p>As I mentioned earlier accessibility is now becoming a legislated requirement in many countries. This is because accessibility is a rights issue. To put it bluntly, if you are building a website that is not accessible you are discriminating against anyone with accessibility challenges. Those are not my words by the way: That&#8217;s the reasoning used by several governments including the government of Norway for passing accessibility laws.</p></blockquote>\n<p>The situation may soon become critical as accessibility mandates are adopted by more countries. <strong>&#8220;WordPress is facing a huge challenge here because once these laws kick in (in many places later this year) website owners running WordPress will for the most part be in breach of the laws thanks to the almost universal lack of accessibility support in WordPress themes</strong>,&#8221; Rand-Hendriksen said.</p>\n<p>His warning applies to both self-hosted WordPress sites and WordPress.com sites: &#8220;If we as a community don&#8217;t embrace accessibility now we will quickly paint ourselves into a corner it&#8217;ll be hard to escape from.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jun 2014 20:32:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WordPress.tv: How to Create Appealing Contents and Spread the Word\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35787\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wordpress.tv/2014/06/18/how-to-create-appealing-contents-and-spread-the-word/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:718:\"<div id=\"v-l87fBtW9-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35787/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35787/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35787&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/18/how-to-create-appealing-contents-and-spread-the-word/\"><img alt=\"How to Create Appealing Contents and Spread the Word\" src=\"http://videos.videopress.com/l87fBtW9/how-to-create-appealing-contents-and-spread-the-word_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jun 2014 18:49:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WordPress.tv: Sara Rosso: WordPress Use Cases in Enterprise, Media, and Government (2/2)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35781\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wordpress.tv/2014/06/18/sara-rosso-wordpress-use-cases-in-enterprise-media-and-government-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:742:\"<div id=\"v-ia0KEWEV-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35781/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35781/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35781&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/18/sara-rosso-wordpress-use-cases-in-enterprise-media-and-government-2/\"><img alt=\"Sara Rosso: WordPress Use Cases in Enterprise, Media, and Government (2/2)\" src=\"http://videos.videopress.com/ia0KEWEV/wordpress-enterprise-media-government-2_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jun 2014 18:05:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WordPress.tv: Sara Rosso: WordPress Use Cases in Enterprise, Media, and Government (1/2)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wordpress.tv/2014/06/18/sara-rosso-wordpress-use-cases-in-enterprise-media-and-government-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:742:\"<div id=\"v-2jGG37f7-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35780/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35780/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35780&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/18/sara-rosso-wordpress-use-cases-in-enterprise-media-and-government-1/\"><img alt=\"Sara Rosso: WordPress Use Cases in Enterprise, Media, and Government (1/2)\" src=\"http://videos.videopress.com/2jGG37f7/wordpress-enterprise-media-government-1_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jun 2014 18:01:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: WordPress Developer Resource Hookr.io Now With Improved Search\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24865\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"http://wptavern.com/wordpress-developer-resource-hookr-io-now-with-improved-search?utm_source=rss&utm_medium=rss&utm_campaign=wordpress-developer-resource-hookr-io-now-with-improved-search\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2157:\"<p><a title=\"http://hookr.io/\" href=\"http://hookr.io/\">Hookr.io</a>, the WordPress developer resource that <a title=\"http://wptavern.com/introducing-hookr-io-a-new-resource-for-wordpress-developers\" href=\"http://wptavern.com/introducing-hookr-io-a-new-resource-for-wordpress-developers\">launched earlier this year</a> has undergone a series of improvements. The search engine now shows results as your typing. The detailed results page has been completely redesigned making it easier to read. If the source code contains indexed objects such as actions, filters, functions, etc, those items are hyper-linked for ease of navigation. Additionally, those objects are highlighted by a gaussian blur effect removing unrelated items from the source code.</p>\n<a href=\"http://wptavern.com/wordpress-developer-resource-hookr-io-now-with-improved-search#gallery-24865-1-slideshow\">Click to view slideshow.</a>\n<p>I asked Christopher Sanford what the traffic has been like since the launch. Sanford is seeing about 40% returning visitors but cites sparse information and functionality as the culprit. The first alpha version of the site inaccurately displayed the hook count which has since been corrected. Several people also commented that they use <a title=\"http://adambrown.info/p/wp_hooks\" href=\"http://adambrown.info/p/wp_hooks\">Adam Browns hook database</a> which Sanford is using as a baseline to compare notes against.</p>\n<p>When asked how Hookr.io compares to the <a title=\"https://developer.wordpress.org/reference/\" href=\"https://developer.wordpress.org/reference/\">official WordPress code reference</a> site, Sanford said, &#8220;the user experience is consistent with <a href=\"http://wordpress.org\">wordpress.org</a>&#8220;. The beta version of the site is already being worked on and if all goes well, Sanford hopes to release it prior to attending <a title=\"http://2014.nyc.wordcamp.org/\" href=\"http://2014.nyc.wordcamp.org/\">WordCamp New York City</a> in August. &#8220;Ultimately, the goal of the site is for developers to obtain relevant information without incessant clicking, which I feel Alpha 2 is beginning to fulfill this vision.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jun 2014 20:42:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Preview the WordPress Menu Customizer: Alpha Plugin Ready for Testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:200:\"http://wptavern.com/preview-the-wordpress-menu-customizer-alpha-plugin-ready-for-testing?utm_source=rss&utm_medium=rss&utm_campaign=preview-the-wordpress-menu-customizer-alpha-plugin-ready-for-testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4846:\"<p><a href=\"http://wptavern.com/wordpress-3-9-smith-released\" target=\"_blank\">WordPress 3.9</a> made huge strides toward improving the theme customization experience by adding widgets to the customizer for live previews. But have you ever thought about the possibility of setting up your WordPress menus within the customizer?</p>\n<p><a href=\"http://celloexpressions.com/\" target=\"_blank\">Nick Halsey</a> is tackling this as part of his Google Summer of Code 2014 Project and has just released an <a href=\"http://wordpress.org/plugins/menu-customizer/\" target=\"_blank\">alpha plugin</a> for testing the menu customizer. It will be under heavy development throughout the summer and certain features will require core patches. Using the plugin requires the latest trunk version of WordPress (4.0).</p>\n<p>Halsey explains his larger vision for the project in the original <a href=\"http://celloexpressions.com/blog/gsoc-project-proposal-menu-customizer/\" target=\"_blank\">proposal,</a> which reaches beyond simply bringing menus into the customizer. The goal is to help mature the customizer into a tool that can realistically be used for live editing anything on the frontend, in cooperation with the planned frontend content editor:</p>\n<blockquote><p>Once the Customizer is feature-complete, we can begin to experiment with alternative approaches to accessing the customizer, making it feel more like an editing mode on the front-end of the site, alongside the front-end content-editor</p></blockquote>\n<p>He is developing the plugin with backwards compatibility and with the hopes of it being something that can be added to core later this year, although there are no guarantees. In the <a href=\"http://celloexpressions.com/blog/gsoc-menu-customizer-revised-schedulescope/\" target=\"_blank\">revised project scope</a>, Halsey suggests that the menu customizer could potentially replace the existing menus screen for supported users. At the beginning of August he plans to prepare a core patch for the plugin merge and draft a proposal for its inclusion in core.</p>\n<h3>A Preview of the Menu Customizer Plugin</h3>\n<p>The Menu Customizer provides a convenient way to assign locations for menus within the theme&#8217;s available options:</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/theme-locations.png\" rel=\"prettyphoto[24860]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/theme-locations.png?resize=1025%2C620\" alt=\"theme-locations\" class=\"aligncenter size-full wp-image-24878\" /></a></p>\n<p>It also allows for editing, reordering, deleting, and adding individual menu items within any menu:</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/customize-menu.png\" rel=\"prettyphoto[24860]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/customize-menu.png?resize=1025%2C487\" alt=\"customize-menu\" class=\"aligncenter size-full wp-image-24880\" /></a></p>\n<p>Currently, the process of adding links seems rather complex and a bit chaotic, even for a seasoned WordPress user. Longer menus and those that are deep-nested have the potential to become quite unwieldly to manage within the narrow customizer controls area.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/add-links.png\" rel=\"prettyphoto[24860]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/add-links.png?resize=937%2C599\" alt=\"add-links\" class=\"aligncenter size-full wp-image-24892\" /></a></p>\n<p>Halsey is well-aware of these challenges and in the coming weeks he will be addressing the need to implement screen options into the new menus interface. His GSoC project includes time for working through outstanding issues with implementation and responding to UI/UX feedback from the core team and community.</p>\n<p>The ability to customize menus and set their locations within the theme customizer is convenient, especially for those who are new to WordPress. Finding just a few options in the customizer while also having to hunt around the dashboard to make other frontend changes can be confusing. One of the more difficult challenges here will be for UI/UX contributors to ensure that menu management in the customizer is just as easy as it would be in the dashboard.</p>\n<p>To follow along with the progress, check out the <a href=\"http://celloexpressions.com/blog/gsoc-menu-customizer-revised-schedulescope/\" target=\"_blank\">revised scope</a> and its related <a href=\"https://core.trac.wordpress.org/my-patches?USER=celloexpressions\" target=\"_blank\">core patches</a>. If you&#8217;re feeling adventurous and want to try out the plugin, make sure to install the <a href=\"http://wordpress.org/plugins/menu-customizer/\" target=\"_blank\">Menu Customizer</a> on a test site only, as it&#8217;s still very alpha and not yet ready for use in production.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jun 2014 20:13:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WordPress.tv: Designer Discussion: Making the Best Use of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35786\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wordpress.tv/2014/06/17/designer-discussion-making-the-best-use-of-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:715:\"<div id=\"v-y9OKAXiK-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35786/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35786/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35786&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/17/designer-discussion-making-the-best-use-of-wordpress/\"><img alt=\"Designer Discussion: Making the Best Use of WordPress\" src=\"http://videos.videopress.com/y9OKAXiK/designer-discussion-making-the-best-of-wordpress_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jun 2014 18:40:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WordPress.tv: Micah Wood: 7 Habits of Highly Effective WordPress Developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35859\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wordpress.tv/2014/06/17/micah-wood-7-habits-of-highly-effective-wordpress-developers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:699:\"<div id=\"v-5mXSVIcs-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35859/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35859/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35859&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/17/micah-wood-7-habits-of-highly-effective-wordpress-developers/\"><img alt=\"Micah Wood: 7 Habits of Highly Effective WordPress Developers\" src=\"http://videos.videopress.com/5mXSVIcs/video-5069f8b07f_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jun 2014 18:30:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WordPress.tv: Josh Mallard: Rapid Development with WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35841\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wordpress.tv/2014/06/17/josh-mallard-rapid-development-with-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:669:\"<div id=\"v-eSkhfgX1-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35841/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35841/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35841&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/17/josh-mallard-rapid-development-with-wordpress/\"><img alt=\"Josh Mallard: Rapid Development with WordPress\" src=\"http://videos.videopress.com/eSkhfgX1/video-2f4e087473_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jun 2014 18:25:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Eighties: A Bold Free WordPress Theme Focused on Content\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24812\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:174:\"http://wptavern.com/eighties-a-bold-free-wordpress-theme-focused-on-content?utm_source=rss&utm_medium=rss&utm_campaign=eighties-a-bold-free-wordpress-theme-focused-on-content\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3309:\"<p>WordPress themes are getting simpler and bolder this year. Bloggers are gravitating toward designs that feature large typography and scaled back post meta in order to allow the visitor to focus on the main content. To compliment this design style, many theme developers are opting to keep the peripherals (widgets, menus, etc) hidden from view.</p>\n<p><a href=\"http://kopepasah.com/\" target=\"_blank\">Justin Kopepasah</a> is making his debut in the WordPress Themes Directory with <a href=\"http://wordpress.org/themes/eighties\" target=\"_blank\">Eighties</a>, a beautiful new theme that epitomizes the simple, bold style trending with new blogging themes. Despite the iconic name, the Eighties theme is not actually a tribute to big hair, leg warmers and the Cold War. Kopepasah said the theme was inspired by his favorite <a href=\"http://chriskempson.github.io/base16/#eighties\" target=\"_blank\">color scheme</a>.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/eighties.png\" rel=\"prettyphoto[24812]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/eighties.png?resize=880%2C660\" alt=\"eighties\" class=\"aligncenter size-full wp-image-24821\" /></a></p>\n<p>Eighties was created based on the <a href=\"http://underscores.me/\" target=\"_blank\">_s theme by Automattic</a>. It was designed to keep the menu and sidebar out of the way until the visitor toggles them into view.</p>\n<p>The theme offers just a couple of customization options to make it your own, including the ability to set your own header and header text color. You can add widgets to the pop out sidebar area or the footer. It ships with the image you see in the header, so making your site look exactly like the demo takes no time at all.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/eighties-customizer.png\" rel=\"prettyphoto[24812]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/eighties-customizer.png?resize=1025%2C557\" alt=\"eighties-customizer\" class=\"aligncenter size-full wp-image-24819\" /></a></p>\n<p>Eighties includes support for several Jetpack modules. <a href=\"http://eighties.me/portfolio/\" target=\"_blank\">Portfolios</a> are a unique feature included in this theme if you use Jetpack (coming soon) or blog on WordPress.com. It includes styles for showcasing your projects with the <a href=\"http://en.support.wordpress.com/portfolios/\" target=\"_blank\">portfolio custom post type</a>.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/portfolio.png\" rel=\"prettyphoto[24812]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/portfolio.png?resize=1025%2C650\" alt=\"portfolio\" class=\"aligncenter size-full wp-image-24840\" /></a></p>\n<p>You can check out a live demo of the theme in action at <a href=\"http://eighties.me/\" target=\"_blank\">eighties.me</a>.</p>\n<p>The Eighties theme was designed to give readers the content they&#8217;re looking for without all the extra fluff. Right now, it&#8217;s only available for self-hosted WordPress sites but Kopepasah is currently waiting for approval for listing on WordPress.com. You can download <a href=\"http://wordpress.org/themes/eighties\" target=\"_blank\">Eighties</a> from WordPress.org or install it directly via your theme browser in the WordPress admin.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jun 2014 07:22:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: VersionPress Adopts The GPL Software License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24810\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:152:\"http://wptavern.com/versionpress-adopts-the-gpl-software-license?utm_source=rss&utm_medium=rss&utm_campaign=versionpress-adopts-the-gpl-software-license\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7342:\"<p>When I <a title=\"http://wptavern.com/versionpress-hopes-to-bring-version-control-to-the-masses\" href=\"http://wptavern.com/versionpress-hopes-to-bring-version-control-to-the-masses\">wrote about the VersionPress project</a> and campaign last week, a major sticking point with people was whether the project would be licensed under the GPL. After a few consultation emails and deliberation, the developers have decided the plugin <a title=\"http://versionpress.wordpress.com/2014/06/16/announcing-full-gpl-licensing/\" href=\"http://versionpress.wordpress.com/2014/06/16/announcing-full-gpl-licensing/\">will be 100% GPL licensed</a>.</p>\n<blockquote><p>When we set off with <a href=\"http://versionpress.net/\">VersionPress </a>and the crowd-funding campaign for it, we were focused on technical things and wanted to postpone the final decision on licensing. That was a mistake and you let us know loud and clear. We heard you and have an important and exciting announcement to make today: <strong>VersionPress will be 100% GNU GPL-licensed</strong>.</p></blockquote>\n<p>This is fantastic news and I hope those who are on the fence will consider <a title=\"http://versionpress.net/\" href=\"http://versionpress.net/\">backing the project</a>. For those that don&#8217;t know, the GPLv2 license gives users and developers a set of freedoms. Since <a title=\"http://wordpress.org/about/license/\" href=\"http://wordpress.org/about/license/\">WordPress is licensed under the GPL</a>, these same freedoms are passed on to everyone who uses or develops the software.</p>\n<ul>\n<li>The freedom to run the program as you wish, for any purpose (freedom 0).</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish (freedom 1). Access to the source code is a precondition for this.</li>\n<li>The freedom to redistribute copies so you can help your neighbor (freedom 2).</li>\n<li>The freedom to distribute copies of your modified versions to others (freedom 3). By doing this you can give the whole community a chance to benefit from your changes. Access to the source code is a precondition for this.</li>\n</ul>\n<p>Matt Mullenweg has a <a title=\"http://ma.tt/2014/01/four-freedoms/\" href=\"http://ma.tt/2014/01/four-freedoms/\">great article</a> that articulates the significance of these freedoms. When VersionPress announced they were unsure of whether to license the plugin under the GPL, it&#8217;s not because they wanted to create something proprietary. It&#8217;s because they are two software developers outside of the WordPress community, unsure of how WordPress and its community works.</p>\n<h3>Helping Newcomers Understand Why The GPL License Is Important</h3>\n<p>After I published the article about VersionPress on WP Tavern last week, several people voiced their concern over the lack of licensing details. I got in touch with Borek Bernard and explained why so many people are concerned. I explained what the GPL means to the project and the WordPress community in general. I cited examples of successful WordPress product businesses that use the GPL.</p>\n<p>There are two camps of people. Those who know and understand the importance of the GPL and those who don&#8217;t care what license a product has as long as it works and is supported well. At this stage of the game, WordPress products not GPL licensed are at a serious disadvantage. You won&#8217;t get as much press and risk being ignored by influential members of the community. This is especially true for new products entering the market.</p>\n<h3>I Backed The Project With $20 and Here&#8217;s Why</h3>\n<p>Despite a working copy of VersionPress not being publicly available, I feel the same amount of excitement for the project that I did when I was given a GravityForms demonstration in 2009. I&#8217;m told there are already plugins available that provide <a title=\"http://wordpress.org/plugins/search.php?q=version+control\" href=\"http://wordpress.org/plugins/search.php?q=version+control\">version control</a> but most of them deal with content, not with the database itself. After listening to Bernard explain some of the features and how it would work in <a title=\"http://wptavern.com/wpweekly-episode-151-version-control-for-all-maybe\" href=\"http://wptavern.com/wpweekly-episode-151-version-control-for-all-maybe\">episode 151 of WordPress Weekly</a>, I&#8217;m even more excited to see the project succeed.</p>\n<div id=\"attachment_24813\" class=\"wp-caption aligncenter\"><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/VersionPressMonitorLog.png\" rel=\"prettyphoto[24810]\"><img class=\"size-full wp-image-24813\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/VersionPressMonitorLog.png?resize=525%2C330\" alt=\"VersionPress Monitor Log\" /></a><p class=\"wp-caption-text\">VersionPress Monitor Log</p></div>\n<p>For example, let&#8217;s say there&#8217;s a change you&#8217;d like to undo but you&#8217;ve published five posts since the change. Normally, you&#8217;d have to restore a backup which would reset the entire site back to that time frame. With VersionPress, you&#8217;d be able to drill down and only undo that change without losing everything that happened after it. In a future version, it could be possible to undo changes at the user level.</p>\n<p>This type of granular control over database changes is huge, especially if the interface is as simple as selecting an undo button. This plugin potentially has mass appeal but I fear that a lot of users wouldn&#8217;t understand the changes being registered to the database. Hopefully, the interface does a good job of pin-pointing what parts of WordPress are altering the database to make it easier to understand.</p>\n<h3>Getting Site Wide Revision Control In Core Will Be Difficult</h3>\n<p>Even if VersionPress doesn&#8217;t get off the ground, I&#8217;ve now been exposed to the idea and will highly support any developer or team of developers to create something like it. WordPress has support for <a title=\"http://codex.wordpress.org/Revisions\" href=\"http://codex.wordpress.org/Revisions\">Post Revisions</a> but again, that deals with content and not with other changes throughout the site. At some point, it would be great to see a revisions API built into WordPress that can monitor revisions of more than just content. Plugins could then take advantage of the API and build on top of it. There could be multiple implementations of VersionPress to choose from.</p>\n<p>The road to getting something like site wide revisions into core will be difficult. In 2013, <a href=\"http://yrnxt.com/\" target=\"_blank\">Alexander Höreth</a> participated in the Google Summer of Code project for WordPress. His project was the <a title=\"http://wordpress.org/plugins/code-revisions/\" href=\"http://wordpress.org/plugins/code-revisions/\">Code Revisions plugin</a> which would have added revision support to the code editors in WordPress. His work was never added to the core of WordPress. If that&#8217;s anything to go by, extending revision support to other areas of core may be just a pipe dream.</p>\n<p>That discussion took place nine months ago. Let&#8217;s start a new discussion on the positives and negatives of a site wide revision system in core. I know there are security issues to take note of but what other concerns do you have for such a system?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jun 2014 04:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Forbes Publishes Transcript Of Extended Interview With Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24678\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:202:\"http://wptavern.com/forbes-publishes-transcript-of-extended-interview-with-matt-mullenweg?utm_source=rss&utm_medium=rss&utm_campaign=forbes-publishes-transcript-of-extended-interview-with-matt-mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5763:\"<p>Typically when reading interviews people have done with Matt Mullenweg, I don&#8217;t learn anything new. That&#8217;s the not the case with the <a title=\"http://www.forbes.com/sites/jjcolao/2014/06/11/an-extended-interview-with-wordpress-creator-matt-mullenweg/\" href=\"http://www.forbes.com/sites/jjcolao/2014/06/11/an-extended-interview-with-wordpress-creator-matt-mullenweg/\">extended interview he did</a> with J.J. Colao of Forbes.com. In the interview, Mullenweg goes into detail about his role of CEO at Automattic and emphasized how important mobile is within the company. Here are a few things I took away from the interview.</p>\n<div id=\"attachment_22370\" class=\"wp-caption aligncenter\"><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/05/automattic-offices.jpg\" rel=\"prettyphoto[24678]\"><img class=\"size-full wp-image-22370\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/05/automattic-offices.jpg?resize=1025%2C478\" alt=\"photo credit: Peter Slutsky\" /></a><p class=\"wp-caption-text\">photo credit: <a href=\"http://peterslutsky.com/2013/05/14/pics-touring-automattics-new-office/\">Peter Slutsky</a></p></div>\n<p>When people ask how does Automattic make money, I tell them through advertising, paid upgrades, and the VIP partner program. Mullenweg specified that WordAds and the VIP program are each 10% of the total revenue Automattic generates. Meanwhile, subscriptions make up 80% of the revenue. This makes sense but I was surprised subscriptions were that high of a percentage. I thought VIP generated the most revenue for the company based on what they charge and the types of clients they have. Then again, there are more regular users than there are VIP clients.</p>\n<p>One thing that hasn&#8217;t changed with the move to CEO is that Mullenweg still spends about a third of his time conducting interviews with new employees. If you&#8217;re interested in <a title=\"http://automattic.com/work-with-us/\" href=\"http://automattic.com/work-with-us/\">working for Automattic</a>, now is as good a time as ever to apply since the company is aggressively growing as fast as they find the best people.</p>\n<h3>Transforming Automattic Into a Mobile Company</h3>\n<p>Over the past two years, the one constant I&#8217;ve noticed in almost every interview featuring Mullenweg is his focus on mobile. This interview is no different. While Automattic has been aggressive in mobile acquisitions and new hires, the company will be training existing engineers to be mobile first. The entire company will be a mobile team instead of consisting of 10 individuals.</p>\n<blockquote><p>So in addition to our aggressive hiring on the mobile side and acquisitions, we’re going to start converting our existing engineers to be mobile first. I would hate to have to do this at a 20,000-person company because it’s hard enough as 200-person company.</p>\n<p>The mobile world is very closed and proprietary just by definition. Android is open source-ish but not really. iOS is locked down. I want to be more of a mobile company but as we do that I don’t want to lose the things that make us the engine of the independent Web.</p></blockquote>\n<h3>Is It Time For Two WordPress Mobile Apps?</h3>\n<p>As Automattic continues to increase its focus on mobile, I wonder what the future holds for the current mobile app. I use it primarily as a site management tool and not to consume content. Since Automattic loves data, I wonder if they have internal stats that show whether the WordPress mobile app is used more for managing sites or consuming content.</p>\n<div id=\"attachment_24807\" class=\"wp-caption aligncenter\"><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/WPMobileAppComposingScreen.jpg\" rel=\"prettyphoto[24678]\"><img class=\"size-full wp-image-24807\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/WPMobileAppComposingScreen.jpg?resize=1025%2C769\" alt=\"WordPress Mobile App For iOS Compose Screen\" /></a><p class=\"wp-caption-text\">WordPress Mobile App For iOS Compose Screen</p></div>\n<p>If the data shows that most people use it as a site management tool, I&#8217;d like them to consider removing Reader and the blogs I follow feature set from the app and moved into a separate WordPress.com focused app. I never use Reader, I&#8217;m not following any blogs, and I don&#8217;t have any friends on WordPress.com making almost half the app useless to me.</p>\n<p>I understand that WordPress.com and the open source WordPress project have similar feature sets, but I don&#8217;t think one app can satisfy both audiences without one or the other getting stuck with unused portions of the application. An alternative would be to create a WordPress Lite application that only gives me the features I need to manage a site. Unfortunately, every time there&#8217;s a decent alternative to the WordPress mobile app, Automattic <a title=\"http://venturebeat.com/2013/06/17/automattic-buys-poster-app/\" href=\"http://venturebeat.com/2013/06/17/automattic-buys-poster-app/\">acquires them</a>.</p>\n<p>Overall, it&#8217;s a <a title=\"http://www.forbes.com/sites/jjcolao/2014/06/11/an-extended-interview-with-wordpress-creator-matt-mullenweg/\" href=\"http://www.forbes.com/sites/jjcolao/2014/06/11/an-extended-interview-with-wordpress-creator-matt-mullenweg/\">great interview</a> but I wish the full transcript of 13,500 words was available versus 2,800. It&#8217;s also reassuring to read Mullenweg&#8217;s response when asked whether he will be with Automattic for life: &#8220;Yes. I’m kind of a one trick pony.&#8221;</p>\n<p>What do you think of splitting the app in two? Could it work or would it be too confusing? Should I give it the WordPress treatment and just ignore those areas of the app I don&#8217;t use?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jun 2014 01:22:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Experimental BuddyPress Plugin Adds Finer Controls for Public Groups\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=24769\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:200:\"http://wptavern.com/experimental-buddypress-plugin-adds-finer-controls-for-public-groups?utm_source=rss&utm_medium=rss&utm_campaign=experimental-buddypress-plugin-adds-finer-controls-for-public-groups\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5729:\"<div id=\"attachment_24792\" class=\"wp-caption aligncenter\"><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/group.jpg\" rel=\"prettyphoto[24769]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/group.jpg?resize=1025%2C525\" alt=\"photo credit: avrene - cc\" class=\"size-full wp-image-24792\" /></a><p class=\"wp-caption-text\">photo credit: <a href=\"http://www.flickr.com/photos/enerva/14186751646/\">avrene</a> &#8211; <a href=\"http://creativecommons.org/licenses/by/2.0/\">cc</a></p></div>\n<p><a href=\"http://buddypress.org/about/groups/\" target=\"_blank\">BuddyPress Groups</a> are one of the more social components of the plugin, as they&#8217;re used primarily for bringing members together around a shared interest, goal, or collaborative project. In some ways groups are like their own mini-networks within a social network, each having its own homepage, activity stream, member directory and administrative panel.</p>\n<p>Groups are a highly effective way of organizing members and as such have been extended to serve a multitude of different requirements. Search WordPress.org and you&#8217;ll find a couple dozen pages of <a href=\"http://wordpress.org/plugins/search.php?page=4&q=buddypress+groups\" target=\"_blank\">plugins devoted to BuddyPress groups</a>, with extensions that add new functionality, such as email subscriptions, documents, reviews, blogs, chat, and so much more. We&#8217;re going to look at how the basic group settings can be changed in order to provide more pathways for the creation of different kinds of groups.</p>\n<h3>A Brief Overview of BuddyPress Group Privacy Options</h3>\n<p>BuddyPress has three privacy options for setting up groups: Public, Private, or Hidden. When you create a group at /groups/create, you&#8217;ll find the privacy options located under settings.</p>\n<p>Anyone can join a public group and all of the activity and content are public. Private groups require users to request membership, while hidden groups are invitation only. Private and hidden groups are similar in that the group content and activity will only be visible to members. Unlike public and private groups, a hidden group is not listed in the groups directory or search results.</p>\n<p>Not all groups fit neatly into these three privacy options. That&#8217;s why BuddyPress core developer Mathieu Viet (<a href=\"https://twitter.com/imath\" target=\"_blank\">@imath</a>) has created a new experimental plugin to allow for a different combination of these settings.</p>\n<h3>Alternative Public Group Control</h3>\n<p>One problem with the way private groups are structured is that potential members cannot see any content or any of the other members in the group. This is a bit off putting and doesn&#8217;t help to attract new group members.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/private-group.png\" rel=\"prettyphoto[24769]\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/private-group.png?resize=900%2C442\" alt=\"private-group\" class=\"aligncenter size-full wp-image-24782\" /></a></p>\n<p>When examining the BuddyPress core, @imath found it difficult to override the way private groups are structured. Instead, he opted to extend public groups and the <a href=\"https://github.com/imath/altctrl-public-group\" target=\"_blank\">Alternative Public Group Control</a> plugin was born.</p>\n<p>This new experimental plugin gives admins more fine-grained control over public groups. It doesn&#8217;t override the group creation process but rather creates a new control tab within the group admin with three additional options.</p>\n<p>The first allows you to require users to request membership in order to join, a feature previously limited to private groups. The second option is the ability to make certain group tabs visible to members only, ie. members, docs, attachments, etc.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/group-admin-control.png\" rel=\"prettyphoto[24769]\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/group-admin-control.png?resize=1025%2C775\" alt=\"group-admin-control\" class=\"aligncenter size-full wp-image-24785\" /></a></p>\n<p>The last option included in the plugin is the convenient way to create a simple custom homepage which will be displayed when non-members are viewing the group.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/custom-homepage.png\" rel=\"prettyphoto[24769]\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/06/custom-homepage.png?resize=900%2C377\" alt=\"custom-homepage\" class=\"aligncenter size-full wp-image-24787\" /></a></p>\n<p>This optional homepage space is useful if you want to further explain the process of joining the group or elaborate a bit more on what participation entails. Previously, the only place to do this was in the group&#8217;s description, which is better left short and sweet for its listing in the groups directory.</p>\n<p>The <a href=\"https://github.com/imath/altctrl-public-group\" target=\"_blank\">Alternative Public Group Control</a> plugin offers greater flexibility to groups with unique requirements. If you need more control over your groups and want to try out this plugin, your can download it from GitHub.  Be advised that it&#8217;s still experimental. If you have feedback, please send it to <a href=\"https://twitter.com/imath\" target=\"_blank\">@imath</a> by posting in the issues queue. Want to see the plugin in action without installing it? Check out the live demo video below:</p>\n<p></p>\n<p><a href=\"http://vimeo.com/98253453\">Alternative Control for BuddyPress public groups</a> from <a href=\"http://vimeo.com/imath\">imath</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jun 2014 21:29:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WordPress.tv: Aaron K. Altman: Migrating a Website with BackupBuddy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=35302\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wordpress.tv/2014/06/16/aaron-k-altman-migrating-a-website-with-backupbuddy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:688:\"<div id=\"v-rLKg1NKD-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/35302/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/35302/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=35302&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2014/06/16/aaron-k-altman-migrating-a-website-with-backupbuddy/\"><img alt=\"Aaron K. Altman: Migrating a Website with BackupBuddy\" src=\"http://videos.videopress.com/rLKg1NKD/video-aef286b0f3_scruberthumbnail_1.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jun 2014 18:59:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 25 Jun 2014 07:56:03 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"159799\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Wed, 25 Jun 2014 07:45:13 GMT\";s:4:\"x-nc\";s:11:\"HIT lax 250\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("36","home","http://comfortsolutions.com.au/airconditioning","yes");
INSERT INTO wp_options VALUES("37","category_base","","yes");
INSERT INTO wp_options VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO wp_options VALUES("39","advanced_edit","0","yes");
INSERT INTO wp_options VALUES("40","comment_max_links","2","yes");
INSERT INTO wp_options VALUES("41","gmt_offset","0","yes");
INSERT INTO wp_options VALUES("42","default_email_category","1","yes");
INSERT INTO wp_options VALUES("43","recently_edited","","no");
INSERT INTO wp_options VALUES("44","template","airconbasix","yes");
INSERT INTO wp_options VALUES("45","stylesheet","airconbasix","yes");
INSERT INTO wp_options VALUES("46","comment_whitelist","1","yes");
INSERT INTO wp_options VALUES("47","blacklist_keys","","no");
INSERT INTO wp_options VALUES("48","comment_registration","","yes");
INSERT INTO wp_options VALUES("49","html_type","text/html","yes");
INSERT INTO wp_options VALUES("50","use_trackback","0","yes");
INSERT INTO wp_options VALUES("51","default_role","subscriber","yes");
INSERT INTO wp_options VALUES("52","db_version","26692","yes");
INSERT INTO wp_options VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO wp_options VALUES("54","upload_path","","yes");
INSERT INTO wp_options VALUES("55","blog_public","1","yes");
INSERT INTO wp_options VALUES("56","default_link_category","2","yes");
INSERT INTO wp_options VALUES("57","show_on_front","page","yes");
INSERT INTO wp_options VALUES("58","tag_base","","yes");
INSERT INTO wp_options VALUES("59","show_avatars","1","yes");
INSERT INTO wp_options VALUES("60","avatar_rating","G","yes");
INSERT INTO wp_options VALUES("61","upload_url_path","","yes");
INSERT INTO wp_options VALUES("62","thumbnail_size_w","150","yes");
INSERT INTO wp_options VALUES("63","thumbnail_size_h","150","yes");
INSERT INTO wp_options VALUES("64","thumbnail_crop","1","yes");
INSERT INTO wp_options VALUES("65","medium_size_w","300","yes");
INSERT INTO wp_options VALUES("66","medium_size_h","300","yes");
INSERT INTO wp_options VALUES("67","avatar_default","mystery","yes");
INSERT INTO wp_options VALUES("68","large_size_w","1024","yes");
INSERT INTO wp_options VALUES("69","large_size_h","1024","yes");
INSERT INTO wp_options VALUES("70","image_default_link_type","file","yes");
INSERT INTO wp_options VALUES("71","image_default_size","","yes");
INSERT INTO wp_options VALUES("72","image_default_align","","yes");
INSERT INTO wp_options VALUES("73","close_comments_for_old_posts","","yes");
INSERT INTO wp_options VALUES("74","close_comments_days_old","14","yes");
INSERT INTO wp_options VALUES("75","thread_comments","1","yes");
INSERT INTO wp_options VALUES("76","thread_comments_depth","5","yes");
INSERT INTO wp_options VALUES("77","page_comments","","yes");
INSERT INTO wp_options VALUES("78","comments_per_page","50","yes");
INSERT INTO wp_options VALUES("79","default_comments_page","newest","yes");
INSERT INTO wp_options VALUES("80","comment_order","asc","yes");
INSERT INTO wp_options VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO wp_options VALUES("82","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("83","widget_text","a:0:{}","yes");
INSERT INTO wp_options VALUES("84","widget_rss","a:0:{}","yes");
INSERT INTO wp_options VALUES("85","uninstall_plugins","a:1:{s:27:\"wp-super-cache/wp-cache.php\";s:23:\"wpsupercache_deactivate\";}","no");
INSERT INTO wp_options VALUES("86","timezone_string","","yes");
INSERT INTO wp_options VALUES("87","page_for_posts","16","yes");
INSERT INTO wp_options VALUES("88","page_on_front","12","yes");
INSERT INTO wp_options VALUES("89","default_post_format","0","yes");
INSERT INTO wp_options VALUES("90","link_manager_enabled","0","yes");
INSERT INTO wp_options VALUES("91","initial_db_version","26691","yes");
INSERT INTO wp_options VALUES("92","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO wp_options VALUES("93","_transient_random_seed","79fc5fb54911e4a5d359fcc52820e641","yes");
INSERT INTO wp_options VALUES("94","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("95","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("96","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("97","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("98","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("99","sidebars_widgets","a:10:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:19:\"primary-widget-area\";a:0:{}s:18:\"header-widget-area\";a:0:{}s:21:\"first-nav-widget-area\";a:0:{}s:22:\"second-nav-widget-area\";N;s:21:\"first-top-widget-area\";N;s:22:\"second-top-widget-area\";N;s:24:\"first-bottom-widget-area\";N;s:25:\"second-bottom-widget-area\";N;s:13:\"array_version\";i:3;}","yes");
INSERT INTO wp_options VALUES("154","theme_sample_data","a:5:{s:5:\"posts\";a:2:{i:0;i:27;i:1;i:28;}s:5:\"pages\";a:5:{i:0;i:12;i:1;i:13;i:2;i:14;i:3;i:15;i:4;i:16;}s:7:\"widgets\";a:0:{}s:5:\"vmenu\";a:0:{}s:4:\"menu\";a:2:{i:0;i:2;i:1;i:3;}}","yes");
INSERT INTO wp_options VALUES("155","theme_content_import","1","yes");
INSERT INTO wp_options VALUES("184","recently_activated","a:1:{s:19:\"jetpack/jetpack.php\";i:1403592169;}","yes");
INSERT INTO wp_options VALUES("101","cron","a:6:{i:1403686800;a:1:{s:11:\"wp_cache_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1403716636;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1403723940;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1403759856;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1403764197;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO wp_options VALUES("102","ossdl_off_cdn_url","http://comfortsolutions.com.au/airconditioning","yes");
INSERT INTO wp_options VALUES("103","ossdl_off_include_dirs","wp-content,wp-includes","yes");
INSERT INTO wp_options VALUES("104","ossdl_off_exclude",".php","yes");
INSERT INTO wp_options VALUES("105","ossdl_cname","","yes");
INSERT INTO wp_options VALUES("1442","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1403682954;s:7:\"checked\";a:4:{s:11:\"airconbasix\";s:3:\"1.0\";s:14:\"twentyfourteen\";s:3:\"1.0\";s:14:\"twentythirteen\";s:3:\"1.1\";s:12:\"twentytwelve\";s:3:\"1.3\";}s:8:\"response\";a:3:{s:14:\"twentyfourteen\";a:4:{s:5:\"theme\";s:14:\"twentyfourteen\";s:11:\"new_version\";s:3:\"1.1\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfourteen\";s:7:\"package\";s:60:\"https://wordpress.org/themes/download/twentyfourteen.1.1.zip\";}s:14:\"twentythirteen\";a:4:{s:5:\"theme\";s:14:\"twentythirteen\";s:11:\"new_version\";s:3:\"1.2\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentythirteen\";s:7:\"package\";s:60:\"https://wordpress.org/themes/download/twentythirteen.1.2.zip\";}s:12:\"twentytwelve\";a:4:{s:5:\"theme\";s:12:\"twentytwelve\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:41:\"https://wordpress.org/themes/twentytwelve\";s:7:\"package\";s:58:\"https://wordpress.org/themes/download/twentytwelve.1.4.zip\";}}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("114","tadv_version","3420","yes");
INSERT INTO wp_options VALUES("115","tadv_plugins","a:6:{i:0;s:5:\"style\";i:1;s:8:\"emotions\";i:2;s:5:\"print\";i:3;s:13:\"searchreplace\";i:4;s:10:\"xhtmlxtras\";i:5;s:8:\"advimage\";}","yes");
INSERT INTO wp_options VALUES("116","tadv_options","a:7:{s:8:\"advlink1\";i:0;s:8:\"advimage\";i:1;s:11:\"editorstyle\";i:0;s:11:\"hideclasses\";i:0;s:11:\"contextmenu\";i:0;s:8:\"no_autop\";i:1;s:7:\"advlist\";i:0;}","yes");
INSERT INTO wp_options VALUES("117","tadv_toolbars","a:4:{s:9:\"toolbar_1\";a:20:{i:0;s:4:\"bold\";i:1;s:6:\"italic\";i:2;s:13:\"strikethrough\";i:3;s:9:\"underline\";i:4;s:7:\"bullist\";i:5;s:7:\"numlist\";i:6;s:7:\"outdent\";i:7;s:6:\"indent\";i:8;s:11:\"justifyleft\";i:9;s:13:\"justifycenter\";i:10;s:12:\"justifyright\";i:11;s:4:\"link\";i:12;s:6:\"unlink\";i:13;s:5:\"image\";i:14;s:10:\"styleprops\";i:15;s:7:\"wp_more\";i:16;s:7:\"wp_page\";i:17;s:12:\"spellchecker\";i:18;s:6:\"search\";i:19;s:10:\"fullscreen\";}s:9:\"toolbar_2\";a:17:{i:0;s:14:\"fontsizeselect\";i:1;s:12:\"formatselect\";i:2;s:9:\"pastetext\";i:3;s:9:\"pasteword\";i:4;s:12:\"removeformat\";i:5;s:7:\"charmap\";i:6;s:5:\"print\";i:7;s:9:\"forecolor\";i:8;s:9:\"backcolor\";i:9;s:8:\"emotions\";i:10;s:3:\"sup\";i:11;s:3:\"sub\";i:12;s:5:\"media\";i:13;s:4:\"undo\";i:14;s:4:\"redo\";i:15;s:7:\"attribs\";i:16;s:7:\"wp_help\";}s:9:\"toolbar_3\";a:0:{}s:9:\"toolbar_4\";a:0:{}}","no");
INSERT INTO wp_options VALUES("118","tadv_btns1","a:20:{i:0;s:4:\"bold\";i:1;s:6:\"italic\";i:2;s:13:\"strikethrough\";i:3;s:9:\"underline\";i:4;s:7:\"bullist\";i:5;s:7:\"numlist\";i:6;s:7:\"outdent\";i:7;s:6:\"indent\";i:8;s:11:\"justifyleft\";i:9;s:13:\"justifycenter\";i:10;s:12:\"justifyright\";i:11;s:4:\"link\";i:12;s:6:\"unlink\";i:13;s:5:\"image\";i:14;s:10:\"styleprops\";i:15;s:7:\"wp_more\";i:16;s:7:\"wp_page\";i:17;s:12:\"spellchecker\";i:18;s:6:\"search\";i:19;s:10:\"fullscreen\";}","no");
INSERT INTO wp_options VALUES("1452","rewrite_rules","a:68:{s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=12&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}","yes");
INSERT INTO wp_options VALUES("119","tadv_btns2","a:17:{i:0;s:14:\"fontsizeselect\";i:1;s:12:\"formatselect\";i:2;s:9:\"pastetext\";i:3;s:9:\"pasteword\";i:4;s:12:\"removeformat\";i:5;s:7:\"charmap\";i:6;s:5:\"print\";i:7;s:9:\"forecolor\";i:8;s:9:\"backcolor\";i:9;s:8:\"emotions\";i:10;s:3:\"sup\";i:11;s:3:\"sub\";i:12;s:5:\"media\";i:13;s:4:\"undo\";i:14;s:4:\"redo\";i:15;s:7:\"attribs\";i:16;s:7:\"wp_help\";}","no");
INSERT INTO wp_options VALUES("120","tadv_btns3","a:0:{}","no");
INSERT INTO wp_options VALUES("121","tadv_btns4","a:0:{}","no");
INSERT INTO wp_options VALUES("122","tadv_allbtns","a:66:{i:0;s:2:\"hr\";i:1;s:6:\"wp_adv\";i:2;s:10:\"blockquote\";i:3;s:4:\"bold\";i:4;s:6:\"italic\";i:5;s:13:\"strikethrough\";i:6;s:9:\"underline\";i:7;s:7:\"bullist\";i:8;s:7:\"numlist\";i:9;s:7:\"outdent\";i:10;s:6:\"indent\";i:11;s:11:\"justifyleft\";i:12;s:13:\"justifycenter\";i:13;s:12:\"justifyright\";i:14;s:11:\"justifyfull\";i:15;s:3:\"cut\";i:16;s:4:\"copy\";i:17;s:5:\"paste\";i:18;s:4:\"link\";i:19;s:6:\"unlink\";i:20;s:5:\"image\";i:21;s:7:\"wp_more\";i:22;s:7:\"wp_page\";i:23;s:6:\"search\";i:24;s:7:\"replace\";i:25;s:10:\"fontselect\";i:26;s:14:\"fontsizeselect\";i:27;s:7:\"wp_help\";i:28;s:10:\"fullscreen\";i:29;s:11:\"styleselect\";i:30;s:12:\"formatselect\";i:31;s:9:\"forecolor\";i:32;s:9:\"backcolor\";i:33;s:9:\"pastetext\";i:34;s:9:\"pasteword\";i:35;s:12:\"removeformat\";i:36;s:7:\"cleanup\";i:37;s:12:\"spellchecker\";i:38;s:7:\"charmap\";i:39;s:5:\"print\";i:40;s:4:\"undo\";i:41;s:4:\"redo\";i:42;s:13:\"tablecontrols\";i:43;s:4:\"cite\";i:44;s:3:\"ins\";i:45;s:3:\"del\";i:46;s:4:\"abbr\";i:47;s:7:\"acronym\";i:48;s:7:\"attribs\";i:49;s:5:\"layer\";i:50;s:5:\"advhr\";i:51;s:4:\"code\";i:52;s:11:\"visualchars\";i:53;s:11:\"nonbreaking\";i:54;s:3:\"sub\";i:55;s:3:\"sup\";i:56;s:9:\"visualaid\";i:57;s:10:\"insertdate\";i:58;s:10:\"inserttime\";i:59;s:6:\"anchor\";i:60;s:10:\"styleprops\";i:61;s:8:\"emotions\";i:62;s:5:\"media\";i:63;s:7:\"iespell\";i:64;s:9:\"separator\";i:65;s:1:\"|\";}","no");
INSERT INTO wp_options VALUES("125","wpsupercache_gc_time","1403683212","yes");
INSERT INTO wp_options VALUES("150","theme_mods_twentyfourteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1391145637;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","yes");
INSERT INTO wp_options VALUES("1475","_transient_timeout_feed_mod_a41fbee65e190c85018f9081fcc3dfc4","1403726195","no");
INSERT INTO wp_options VALUES("1476","_transient_feed_mod_a41fbee65e190c85018f9081fcc3dfc4","1403682995","no");
INSERT INTO wp_options VALUES("227","wpcf7","a:1:{s:7:\"version\";s:5:\"3.8.1\";}","yes");
INSERT INTO wp_options VALUES("1454","can_compress_scripts","1","yes");
INSERT INTO wp_options VALUES("1455","_site_transient_timeout_theme_roots","1403684753","yes");
INSERT INTO wp_options VALUES("1456","_site_transient_theme_roots","a:4:{s:11:\"airconbasix\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";s:12:\"twentytwelve\";s:7:\"/themes\";}","yes");
INSERT INTO wp_options VALUES("1457","_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","1403726154","no");
INSERT INTO wp_options VALUES("1458","_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:51:\"\n	\n	\n	\n	\n	\n	\n		\n		\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 May 2014 18:40:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"http://wordpress.org/?v=4.0-alpha-20140624\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 3.9.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"http://wordpress.org/news/2014/05/wordpress-3-9-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://wordpress.org/news/2014/05/wordpress-3-9-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 May 2014 18:40:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3241\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"After three weeks and more than 9 million downloads of WordPress 3.9, we&#8217;re pleased to announce that WordPress 3.9.1 is now available. This maintenance release fixes 34 bugs in 3.9, including numerous fixes for multisite networks, customizing widgets while previewing themes, and the updated visual editor. We&#8217;ve also made some improvements to the new audio/video [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3077:\"<p>After three weeks and more than 9 million downloads of <a title=\"WordPress 3.9 “Smith”\" href=\"http://wordpress.org/news/2014/04/smith/\">WordPress 3.9</a>, we&#8217;re pleased to announce that WordPress 3.9.1 is now available.</p>\n<p>This maintenance release fixes 34 bugs in 3.9, including numerous fixes for multisite networks, customizing widgets while previewing themes, and the updated visual editor. We&#8217;ve also made some improvements to the new audio/video playlists feature and made some adjustments to improve performance. For a full list of changes, consult the <a href=\"https://core.trac.wordpress.org/query?milestone=3.9.1\">list of tickets</a> and the <a href=\"https://core.trac.wordpress.org/log/branches/3.9?rev=28353&amp;stop_rev=28154\">changelog</a>.</p>\n<p>If you are one of the millions already running WordPress 3.9, we&#8217;ve started rolling out automatic background updates for 3.9.1. For sites <a href=\"http://wordpress.org/plugins/background-update-tester/\">that support them</a>, of course.</p>\n<p><a href=\"http://wordpress.org/download/\">Download WordPress 3.9.1</a> or venture over to <strong>Dashboard → Updates</strong> and simply click &#8220;Update Now.&#8221;</p>\n<p>Thanks to all of these fine individuals for contributing to 3.9.1: <a href=\"http://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"http://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"http://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"http://profiles.wordpress.org/rzen\">Brian Richards</a>, <a href=\"http://profiles.wordpress.org/ehg\">Chris Blower</a>, <a href=\"http://profiles.wordpress.org/jupiterwise\">Corey McKrill</a>, <a href=\"http://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"http://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"http://profiles.wordpress.org/feedmeastraycat\">feedmeastraycat</a>, <a href=\"http://profiles.wordpress.org/gcorne\">Gregory Cornelius</a>, <a href=\"http://profiles.wordpress.org/helen\">Helen Hou-Sandi</a>, <a href=\"http://profiles.wordpress.org/imath\">imath</a>, <a href=\"http://profiles.wordpress.org/avryl\">Janneke Van Dorpe</a>, <a href=\"http://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"http://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"http://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"http://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"http://profiles.wordpress.org/m_i_n\">m_i_n</a>, <a href=\"http://profiles.wordpress.org/clorith\">Marius Jensen</a>, <a href=\"http://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"http://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"http://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"http://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"http://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"http://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, and <a href=\"http://profiles.wordpress.org/westonruter\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/news/2014/05/wordpress-3-9-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 3.9 “Smith”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://wordpress.org/news/2014/04/smith/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://wordpress.org/news/2014/04/smith/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Apr 2014 18:33:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3154\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:411:\"Version 3.9 of WordPress, named &#8220;Smith&#8221; in honor of jazz organist Jimmy Smith, is available for download or update in your WordPress dashboard. This release features a number of refinements that we hope you&#8217;ll love. A smoother media editing experience Improved visual editing The updated visual editor has improved speed, accessibility, and mobile support. You can paste into the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:23297:\"<p>Version 3.9 of WordPress, named &#8220;Smith&#8221; in honor of jazz organist <a href=\"http://en.wikipedia.org/wiki/Jimmy_Smith_(musician)\">Jimmy Smith</a>, is available <a href=\"http://wordpress.org/download/\">for download</a> or update in your WordPress dashboard. This release features a number of refinements that we hope you&#8217;ll love.</p>\n<embed src=\"//v0.wordpress.com/player.swf?v=1.03\" type=\"application/x-shockwave-flash\" width=\"640\" height=\"360\" wmode=\"direct\" seamlesstabbing=\"true\" allowfullscreen=\"true\" allowscriptaccess=\"always\" overstretch=\"true\" flashvars=\"guid=sAiXhCfV&amp;isDynamicSeeking=true\" title=\"\"></embed>\n<h2 class=\"about-headline-callout\" style=\"text-align: center\">A smoother media editing experience</h2>\n<div>\n<p><img class=\"alignright wp-image-3168\" src=\"//wordpress.org/news/files/2014/04/editor1-300x233.jpg\" alt=\"editor\" width=\"228\" height=\"177\" /></p>\n<h3>Improved visual editing</h3>\n<p>The updated visual editor has improved speed, accessibility, and mobile support. You can paste into the visual editor from your word processor without wasting time to clean up messy styling. (Yeah, we’re talking about you, Microsoft Word.)</p>\n</div>\n<div style=\"clear: both\"></div>\n<div>\n<p><img class=\"alignright wp-image-3170\" src=\"//wordpress.org/news/files/2014/04/image1-300x233.jpg\" alt=\"image\" width=\"228\" height=\"178\" /></p>\n<h3>Edit images easily</h3>\n<p>With quicker access to crop and rotation tools, it’s now much easier to edit your images while editing posts. You can also scale images directly in the editor to find just the right fit.</p>\n</div>\n<div style=\"clear: both\"></div>\n<div>\n<p><img class=\"alignright wp-image-3187\" src=\"//wordpress.org/news/files/2014/04/dragdrop1-300x233.jpg\" alt=\"dragdrop\" width=\"228\" height=\"178\" /></p>\n<h3>Drag and drop your images</h3>\n<p>Uploading your images is easier than ever. Just grab them from your desktop and drop them in the editor.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<h2 style=\"text-align: center\">Gallery previews</h2>\n<p><img class=\"aligncenter size-full wp-image-3169\" src=\"//wordpress.org/news/files/2014/04/gallery1.jpg\" alt=\"gallery\" width=\"980\" height=\"550\" /></p>\n<p>Galleries display a beautiful grid of images right in the editor, just like they do in your published post.</p>\n<hr />\n<h2 style=\"text-align: center\">Do more with audio and video</h2>\n\n<a href=\'http://wordpress.org/news/files/2014/04/AintMisbehavin.mp3\'>Ain\'t Misbehavin\'</a>\n<a href=\'http://wordpress.org/news/files/2014/04/DavenportBlues.mp3\'>Davenport Blues</a>\n<a href=\'http://wordpress.org/news/files/2014/04/JellyRollMorton-BuddyBoldensBlues.mp3\'>Buddy Bolden\'s Blues</a>\n<a href=\'http://wordpress.org/news/files/2014/04/Johnny_Hodges_Orchestra-Squaty_Roo-1941.mp3\'>Squaty Roo</a>\n<a href=\'http://wordpress.org/news/files/2014/04/Louisiana_Five-Dixie_Blues-1919.mp3\'>Dixie Blues</a>\n<a href=\'http://wordpress.org/news/files/2014/04/WolverineBlues.mp3\'>Wolverine Blues</a>\n\n<p>Images have galleries; now we’ve added simple audio and video playlists, so you can showcase your music and clips.</p>\n<hr />\n<h2 style=\"text-align: center\">Live widget and header previews</h2>\n<div style=\"width: 692px; max-width: 100%;\" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-3154-1\" width=\"692\" height=\"448\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"//wordpress.org/news/files/2014/04/widgets.mp4?_=1\" /><a href=\"//wordpress.org/news/files/2014/04/widgets.mp4\">//wordpress.org/news/files/2014/04/widgets.mp4</a></video></div>\n<p>Add, edit, and rearrange your site’s widgets right in the theme customizer. No “save and surprise” — preview your changes live and only save them when you’re ready.</p>\n<p>The improved header image tool also lets you upload, crop, and manage headers while customizing your theme.</p>\n<hr />\n<h2 style=\"text-align: center\">Stunning new theme browser</h2>\n<p><img class=\"aligncenter size-full wp-image-3172\" src=\"//wordpress.org/news/files/2014/04/theme1.jpg\" alt=\"theme\" width=\"1003\" height=\"558\" /><br />\nLooking for a new theme should be easy and fun. Lose yourself in the boundless supply of free WordPress.org themes with the beautiful new theme browser.</p>\n<hr />\n<h2 style=\"text-align: center\">The Crew</h2>\n<p>This release was led by <a href=\"http://nacin.com/\">Andrew Nacin</a> and <a href=\"http://www.getsource.net/\">Mike Schroder</a>, with the help of these fine individuals. There are 267 contributors with props in this release, a new high:</p>\n<p><a href=\"http://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"http://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"http://profiles.wordpress.org/kawauso\">Adam Harley</a>, <a href=\"http://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"http://profiles.wordpress.org/adelval\">adelval</a>, <a href=\"http://profiles.wordpress.org/ajay\">Ajay</a>, <a href=\"http://profiles.wordpress.org/akeda\">Akeda Bagus</a>, <a href=\"http://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"http://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"http://profiles.wordpress.org/aliso\">Alison Barrett</a>, <a href=\"http://profiles.wordpress.org/collinsinternet\">Allan Collins</a>, <a href=\"http://profiles.wordpress.org/sabreuse\">Amy Hendrix (sabreuse)</a>, <a href=\"http://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"http://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"http://profiles.wordpress.org/norcross\">Andrew Norcross</a>, <a href=\"http://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"http://profiles.wordpress.org/rarst\">Andrey \"Rarst\" Savchenko</a>, <a href=\"http://profiles.wordpress.org/andykeith\">Andy Keith</a>, <a href=\"http://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"http://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"http://profiles.wordpress.org/aubreypwd\">Aubrey Portwood</a>, <a href=\"http://profiles.wordpress.org/barry\">Barry</a>, <a href=\"http://profiles.wordpress.org/toszcze\">Bartosz Romanowski</a>, <a href=\"http://profiles.wordpress.org/bassgang\">bassgang</a>, <a href=\"http://profiles.wordpress.org/bcworkz\">bcworkz</a>, <a href=\"http://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"http://profiles.wordpress.org/neoxx\">Bernhard Riedl</a>, <a href=\"http://profiles.wordpress.org/bigdawggi\">bigdawggi</a>, <a href=\"http://profiles.wordpress.org/bobbravo2\">Bob Gregor</a>, <a href=\"http://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"http://profiles.wordpress.org/bradt\">Brad Touesnard</a>, <a href=\"http://profiles.wordpress.org/bradparbs\">bradparbs</a>, <a href=\"http://profiles.wordpress.org/bramd\">bramd</a>, <a href=\"http://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"http://profiles.wordpress.org/brasofilo\">brasofilo</a>, <a href=\"http://profiles.wordpress.org/bravokeyl\">bravokeyl</a>, <a href=\"http://profiles.wordpress.org/bpetty\">Bryan Petty</a>, <a href=\"http://profiles.wordpress.org/cgaffga\">cgaffga</a>, <a href=\"http://profiles.wordpress.org/chiragswadia\">Chirag Swadia</a>, <a href=\"http://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"http://profiles.wordpress.org/ehg\">Chris Blower</a>, <a href=\"http://profiles.wordpress.org/cmmarslender\">Chris Marslender</a>, <a href=\"http://profiles.wordpress.org/c3mdigital\">Chris Olbekson</a>, <a href=\"http://profiles.wordpress.org/chrisscott\">Chris Scott</a>, <a href=\"http://profiles.wordpress.org/chriseverson\">chriseverson</a>, <a href=\"http://profiles.wordpress.org/chrisguitarguy\">chrisguitarguy</a>, <a href=\"http://profiles.wordpress.org/cfinke\">Christopher Finke</a>, <a href=\"http://profiles.wordpress.org/ciantic\">ciantic</a>, <a href=\"http://profiles.wordpress.org/antorome\">Comparativa de Bancos</a>, <a href=\"http://profiles.wordpress.org/cojennin\">Connor Jennings</a>, <a href=\"http://profiles.wordpress.org/corvannoorloos\">Cor van Noorloos</a>, <a href=\"http://profiles.wordpress.org/corphi\">Corphi</a>, <a href=\"http://profiles.wordpress.org/cramdesign\">cramdesign</a>, <a href=\"http://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"http://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"http://profiles.wordpress.org/dannydehaan\">Danny de Haan</a>, <a href=\"http://profiles.wordpress.org/koop\">Daryl Koopersmith</a>, <a href=\"http://profiles.wordpress.org/eightface\">Dave Kellam (eightface)</a>, <a href=\"http://profiles.wordpress.org/dpe415\">DaveE</a>, <a href=\"http://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"http://profiles.wordpress.org/davidanderson\">David Anderson</a>, <a href=\"http://profiles.wordpress.org/davidmarichal\">David Marichal</a>, <a href=\"http://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"http://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"http://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"http://profiles.wordpress.org/dougwollison\">Doug Wollison</a>, <a href=\"http://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"http://profiles.wordpress.org/drprotocols\">DrProtocols</a>, <a href=\"http://profiles.wordpress.org/dustyf\">Dustin Filippini</a>, <a href=\"http://profiles.wordpress.org/eatingrules\">eatingrules</a>, <a href=\"http://profiles.wordpress.org/plocha\">edik</a>, <a href=\"http://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"http://profiles.wordpress.org/enej\">enej</a>, <a href=\"http://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"http://profiles.wordpress.org/ericmann\">Eric Mann</a>, <a href=\"http://profiles.wordpress.org/evarlese\">Erica Varlese</a>, <a href=\"http://profiles.wordpress.org/ethitter\">Erick Hitter</a>, <a href=\"http://profiles.wordpress.org/ejdanderson\">Evan Anderson</a>, <a href=\"http://profiles.wordpress.org/fahmiadib\">Fahmi Adib</a>, <a href=\"http://profiles.wordpress.org/fboender\">fboender</a>, <a href=\"http://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"http://profiles.wordpress.org/garyc40\">Gary Cao</a>, <a href=\"http://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"http://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"http://profiles.wordpress.org/genkisan\">genkisan</a>, <a href=\"http://profiles.wordpress.org/soulseekah\">Gennady Kovshenin</a>, <a href=\"http://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"http://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"http://profiles.wordpress.org/vancoder\">Grant Mangham</a>, <a href=\"http://profiles.wordpress.org/gcorne\">Gregory Cornelius</a>, <a href=\"http://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"http://profiles.wordpress.org/hakre\">hakre</a>, <a href=\"http://profiles.wordpress.org/hanni\">hanni</a>, <a href=\"http://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"http://profiles.wordpress.org/ippetkov\">ippetkov</a>, <a href=\"http://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"http://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"http://profiles.wordpress.org/jackreichert\">Jack Reichert</a>, <a href=\"http://profiles.wordpress.org/_jameslee\">jameslee</a>, <a href=\"http://profiles.wordpress.org/avryl\">Janneke Van Dorpe</a>, <a href=\"http://profiles.wordpress.org/janrenn\">janrenn</a>, <a href=\"http://profiles.wordpress.org/jaycc\">JayCC</a>, <a href=\"http://profiles.wordpress.org/jeffsebring\">Jeff Sebring</a>, <a href=\"http://profiles.wordpress.org/jenmylo\">Jen Mylo</a>, <a href=\"http://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"http://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"http://profiles.wordpress.org/jayjdk\">Jesper Johansen (jayjdk)</a>, <a href=\"http://profiles.wordpress.org/jnielsendotnet\">jnielsendotnet</a>, <a href=\"http://profiles.wordpress.org/jartes\">Joan Artes</a>, <a href=\"http://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"http://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"http://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"http://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"http://profiles.wordpress.org/johnpbloch\">John P. Bloch</a>, <a href=\"http://profiles.wordpress.org/johnregan3\">John Regan</a>, <a href=\"http://profiles.wordpress.org/duck_\">Jon Cave</a>, <a href=\"http://profiles.wordpress.org/jond3r\">Jonas Bolinder (jond3r)</a>, <a href=\"http://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"http://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"http://profiles.wordpress.org/joshuaabenazer\">Joshua Abenazer</a>, <a href=\"http://profiles.wordpress.org/jstraitiff\">jstraitiff</a>, <a href=\"http://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"http://profiles.wordpress.org/kopepasah\">Justin Kopepasah</a>, <a href=\"http://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"http://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"http://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"http://profiles.wordpress.org/kasparsd\">Kaspars</a>, <a href=\"http://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"http://profiles.wordpress.org/kerikae\">kerikae</a>, <a href=\"http://profiles.wordpress.org/kworthington\">Kevin Worthington</a>, <a href=\"http://profiles.wordpress.org/kpdesign\">Kim Parsell</a>, <a href=\"http://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"http://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"http://profiles.wordpress.org/klihelp\">klihelp</a>, <a href=\"http://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"http://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"http://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"http://profiles.wordpress.org/drozdz\">Krzysiek Drozdz</a>, <a href=\"http://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"http://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"http://profiles.wordpress.org/lpointet\">lpointet</a>, <a href=\"http://profiles.wordpress.org/ldebrouwer\">Luc De Brouwer</a>, <a href=\"http://profiles.wordpress.org/spmlucas\">Lucas Karpiuk</a>, <a href=\"http://profiles.wordpress.org/lkwdwrd\">Luke Woodward</a>, <a href=\"http://profiles.wordpress.org/mark8barnes\">Mark Barnes</a>, <a href=\"http://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"http://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"http://profiles.wordpress.org/marventus\">Marventus</a>, <a href=\"http://profiles.wordpress.org/iammattthomas\">Matt (Thomas) Miklic</a>, <a href=\"http://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"http://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"http://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"http://profiles.wordpress.org/mdbitz\">Matthew Denton</a>, <a href=\"http://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"http://profiles.wordpress.org/mattonomics\">mattonomics</a>, <a href=\"http://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"http://profiles.wordpress.org/matveb\">Matías Ventura</a>, <a href=\"http://profiles.wordpress.org/maxcutler\">Max Cutler</a>, <a href=\"http://profiles.wordpress.org/mcadwell\">mcadwell</a>, <a href=\"http://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"http://profiles.wordpress.org/meloniq\">meloniq</a>, <a href=\"http://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"http://profiles.wordpress.org/michelwppi\">Michel - xiligroup dev</a>, <a href=\"http://profiles.wordpress.org/mcsf\">Miguel Fonseca</a>, <a href=\"http://profiles.wordpress.org/gradyetc\">Mike Burns</a>, <a href=\"http://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"http://profiles.wordpress.org/mikemanger\">Mike Manger</a>, <a href=\"http://profiles.wordpress.org/mikeschinkel\">Mike Schinkel</a>, <a href=\"http://profiles.wordpress.org/dh-shredder\">Mike Schroder</a>, <a href=\"http://profiles.wordpress.org/mikecorkum\">mikecorkum</a>, <a href=\"http://profiles.wordpress.org/mitchoyoshitaka\">mitcho (Michael Yoshitaka Erlewine)</a>, <a href=\"http://profiles.wordpress.org/batmoo\">Mohammad Jangda</a>, <a href=\"http://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"http://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"http://profiles.wordpress.org/Nao\">Naoko Takano</a>, <a href=\"http://profiles.wordpress.org/alex-ye\">Nashwan Doaqan</a>, <a href=\"http://profiles.wordpress.org/nendeb55\">nendeb55</a>, <a href=\"http://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"http://profiles.wordpress.org/nicolealleyinteractivecom\">Nicole Arnold</a>, <a href=\"http://profiles.wordpress.org/nikv\">Nikhil Vimal (NikV)</a>, <a href=\"http://profiles.wordpress.org/nivijah\">Nivi Jah</a>, <a href=\"http://profiles.wordpress.org/nofearinc\">nofearinc</a>, <a href=\"http://profiles.wordpress.org/nunomorgadinho\">Nuno Morgadinho</a>, <a href=\"http://profiles.wordpress.org/olivm\">olivM</a>, <a href=\"http://profiles.wordpress.org/jbkkd\">Omer Korner</a>, <a href=\"http://profiles.wordpress.org/originalexe\">OriginalEXE</a>, <a href=\"http://profiles.wordpress.org/oso96_2000\">oso96_2000</a>, <a href=\"http://profiles.wordpress.org/patricknami\">patricknami</a>, <a href=\"http://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"http://profiles.wordpress.org/djpaul\">Paul Gibbs</a>, <a href=\"http://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"http://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"http://profiles.wordpress.org/westi\">Peter Westwood</a>, <a href=\"http://profiles.wordpress.org/philiparthurmoore\">Philip Arthur Moore</a>, <a href=\"http://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"http://profiles.wordpress.org/nprasath002\">Prasath Nadarajah</a>, <a href=\"http://profiles.wordpress.org/prettyboymp\">prettyboymp</a>, <a href=\"http://profiles.wordpress.org/raamdev\">Raam Dev</a>, <a href=\"http://profiles.wordpress.org/rachelbaker\">rachelbaker</a>, <a href=\"http://profiles.wordpress.org/mauryaratan\">Ram Ratan Maurya</a>, <a href=\"http://profiles.wordpress.org/ramonchiara\">ramonchiara</a>, <a href=\"http://profiles.wordpress.org/ounziw\">Rescuework Support</a>, <a href=\"http://profiles.wordpress.org/rhyswynne\">Rhys Wynne</a>, <a href=\"http://profiles.wordpress.org/ricardocorreia\">Ricardo Correia</a>, <a href=\"http://profiles.wordpress.org/theorboman\">Richard Sweeney</a>, <a href=\"http://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"http://profiles.wordpress.org/richard2222\">richard2222</a>, <a href=\"http://profiles.wordpress.org/rickalee\">Ricky Lee Whittemore</a>, <a href=\"http://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"http://profiles.wordpress.org/robmiller\">robmiller</a>, <a href=\"http://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"http://profiles.wordpress.org/romaimperator\">romaimperator</a>, <a href=\"http://profiles.wordpress.org/roothorick\">roothorick</a>, <a href=\"http://profiles.wordpress.org/ruudjoyo\">ruud@joyo</a>, <a href=\"http://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"http://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"http://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"http://profiles.wordpress.org/otto42\">Samuel Wood (Otto)</a>, <a href=\"http://profiles.wordpress.org/sandyr\">Sandeep</a>, <a href=\"http://profiles.wordpress.org/scottlee\">Scott Lee</a>, <a href=\"http://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"http://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"http://profiles.wordpress.org/greglone\">ScreenfeedFr</a>, <a href=\"http://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"http://profiles.wordpress.org/sdasse\">sdasse</a>, <a href=\"http://profiles.wordpress.org/bootsz\">Sean Butze</a>, <a href=\"http://profiles.wordpress.org/seanchayes\">Sean Hayes</a>, <a href=\"http://profiles.wordpress.org/nessworthy\">Sean Nessworthy</a>, <a href=\"http://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"http://profiles.wordpress.org/shahpranaf\">shahpranaf</a>, <a href=\"http://profiles.wordpress.org/shaunandrews\">Shaun Andrews</a>, <a href=\"http://profiles.wordpress.org/shinichin\">ShinichiN</a>, <a href=\"http://profiles.wordpress.org/pross\">Simon Prosser</a>, <a href=\"http://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"http://profiles.wordpress.org/siobhan\">Siobhan</a>, <a href=\"http://profiles.wordpress.org/siobhyb\">Siobhan Bamber (siobhyb)</a>, <a href=\"http://profiles.wordpress.org/sirzooro\">sirzooro</a>, <a href=\"http://profiles.wordpress.org/solarissmoke\">solarissmoke</a>, <a href=\"http://profiles.wordpress.org/sonjanyc\">sonjanyc</a>, <a href=\"http://profiles.wordpress.org/spencerfinnell\">Spencer Finnell</a>, <a href=\"http://profiles.wordpress.org/piontkowski\">Spencer Piontkowski</a>, <a href=\"http://profiles.wordpress.org/stephcook22\">stephcook22</a>, <a href=\"http://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"http://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"http://profiles.wordpress.org/sbruner\">Steve Bruner</a>, <a href=\"http://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"http://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"http://profiles.wordpress.org/tanner-m\">Tanner Moushey</a>, <a href=\"http://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"http://profiles.wordpress.org/tbrams\">tbrams</a>, <a href=\"http://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"http://profiles.wordpress.org/tomauger\">Tom Auger</a>, <a href=\"http://profiles.wordpress.org/willmot\">Tom Willmot</a>, <a href=\"http://profiles.wordpress.org/topher1kenobe\">Topher</a>, <a href=\"http://profiles.wordpress.org/topquarky\">topquarky</a>, <a href=\"http://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"http://profiles.wordpress.org/toru\">Toru</a>, <a href=\"http://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"http://profiles.wordpress.org/umeshsingla\">Umesh Kumar</a>, <a href=\"http://profiles.wordpress.org/undergroundnetwork\">undergroundnetwork</a>, <a href=\"http://profiles.wordpress.org/varunagw\">VarunAgw</a>, <a href=\"http://profiles.wordpress.org/wawco\">wawco</a>, <a href=\"http://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"http://profiles.wordpress.org/wokamoto\">wokamoto</a>, <a href=\"http://profiles.wordpress.org/xsonic\">xsonic</a>, <a href=\"http://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"http://profiles.wordpress.org/yurivictor\">Yuri Victor</a>, <a href=\"http://profiles.wordpress.org/zbtirrell\">Zach Tirrell</a>, and <a href=\"http://profiles.wordpress.org/vanillalounge\">Ze Fontainhas</a>. Also thanks to <a href=\"http://michaelpick.wordpress.com/\">Michael Pick</a> for producing the release video.</p>\n<p>If you want to follow along or help out, check out <a href=\"http://make.wordpress.org/\">Make WordPress</a> and our <a href=\"http://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress. See you soon for version 4.0!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"http://wordpress.org/news/2014/04/smith/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 3.9 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://wordpress.org/news/2014/04/wordpress-3-9-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wordpress.org/news/2014/04/wordpress-3-9-release-candidate-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2014 09:47:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3151\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:356:\"The second release candidate for WordPress 3.9 is now available for testing. If you haven&#8217;t tested 3.9 yet, you&#8217;re running out of time! We made about five dozen changes since the first release candidate, and those changes are all helpfully summarized in our weekly post on the development blog. Probably the biggest fixes are to live [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2273:\"<p>The second release candidate for WordPress 3.9 is now available for testing.</p>\n<p>If you haven&#8217;t tested 3.9 yet, you&#8217;re running out of time! We made about five dozen changes since the <a title=\"WordPress 3.9 Release Candidate\" href=\"//wordpress.org/news/2014/04/wordpress-3-9-release-candidate/\">first release candidate</a>, and those changes are all helpfully summarized <a href=\"//make.wordpress.org/core/?p=10237\">in our weekly post</a> on the development blog. Probably the biggest fixes are to live widget previews and the new theme browser, along with some extra TinyMCE compatibility and some RTL fixes.</p>\n<p><strong>Plugin authors:</strong> Could you test your plugins against 3.9, and if they&#8217;re compatible, make sure they are marked as tested up to 3.9? It only takes a few minutes and this really helps make launch easier. Be sure to follow along the core development blog; we&#8217;ve been posting <a href=\"//make.wordpress.org/core/tag/3-9-dev-notes/\">notes for developers for 3.9</a>. (For example: <a href=\"//make.wordpress.org/core/2014/04/15/html5-galleries-captions-in-wordpress-3-9/\">HTML5</a>, <a href=\"//make.wordpress.org/core/2014/04/14/symlinked-plugins-in-wordpress-3-9/\">symlinks</a>, <a href=\"//make.wordpress.org/core/2014/04/07/mysql-in-wordpress-3-9/\">MySQL</a>, <a href=\"//make.wordpress.org/core/2014/04/11/plupload-2-x-in-wordpress-3-9/\">Plupload</a>.)</p>\n<p>To test WordPress 3.9 RC2, try the <a href=\"//wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"//wordpress.org/wordpress-3.9-RC2.zip\">download the release candidate here</a> (zip). If you’d like to learn more about what’s new in WordPress 3.9, visit the nearly complete About screen in your dashboard (<strong><img src=\"//i0.wp.com/core.svn.wordpress.org/branches/3.6/wp-content/themes/twentyten/images/wordpress.png?w=692\" alt=\"\" width=\"16\" height=\"16\" /> → About</strong> in the toolbar) and also check out <a title=\"WordPress 3.9 Beta 1\" href=\"//wordpress.org/news/2014/03/wordpress-3-9-beta-1/\">the Beta 1 post</a>.</p>\n<p><em>This is for testing,</em><br />\n<em>so not recommended for<br />\nproduction sites—yet.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wordpress.org/news/2014/04/wordpress-3-9-release-candidate-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 3.8.3 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"http://wordpress.org/news/2014/04/wordpress-3-8-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://wordpress.org/news/2014/04/wordpress-3-8-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Apr 2014 19:29:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3145\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:338:\"WordPress 3.8.3 is now available to fix a small but unfortunate bug in the WordPress 3.8.2 security release. The &#8220;Quick Draft&#8221; tool on the dashboard screen was broken in the 3.8.2 update. If you tried to use it, your draft would disappear and it wouldn&#8217;t save. While we doubt anyone was writing a novella using [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2339:\"<p>WordPress 3.8.3 is now available to fix a small but unfortunate bug in the <a title=\"WordPress 3.8.2 Security Release\" href=\"http://wordpress.org/news/2014/04/wordpress-3-8-2/\">WordPress 3.8.2 security release</a>.</p>\n<p>The &#8220;Quick Draft&#8221; tool on the dashboard screen was broken in the 3.8.2 update. If you tried to use it, your draft would disappear and it wouldn&#8217;t save. While we doubt anyone was writing a novella using this tool, <em>any</em> loss of content is unacceptable to us.</p>\n<p>We recognize how much trust you place in us to safeguard your content, and we take this responsibility very seriously. We&#8217;re sorry we let you down.</p>\n<p>We&#8217;ve all lost words we&#8217;ve written before, like an email thanks to a cat on the keyboard or a term paper to a blue screen of death. Over the last few WordPress releases, we&#8217;ve made a number of improvements to features like autosaves and revisions. With revisions, an old edit can always be restored. We&#8217;re trying our hardest to save your content somewhere even if your power goes out or your browser crashes. We even monitor your internet connection and prevent you from hitting that &#8220;Publish&#8221; button at the exact moment the coffee shop Wi-Fi has a hiccup.</p>\n<p>It&#8217;s <em>possible</em> that the quick draft you lost last week is still in the database, and just hidden from view. As an added complication, these &#8220;discarded drafts&#8221; normally get deleted after seven days, and it&#8217;s already been six days since the release. If we were able to rescue your draft, you&#8217;ll see it on the &#8220;All Posts&#8221; screen after you update to 3.8.3. (We&#8217;ll also be pushing 3.8.3 out as a background update, so you may just see a draft appear.)</p>\n<p>So, if you tried to jot down a quick idea last week, I hope WordPress has recovered it for you. Maybe it&#8217;ll turn into that novella.</p>\n<p><a href=\"http://wordpress.org/download/\">Download WordPress 3.8.3</a> or click &#8220;Update Now&#8221; on Dashboard → Updates.</p>\n<p><em>This affected version 3.7.2 as well, so we&#8217;re pushing a 3.7.3 to these installs, but we&#8217;d encourage you to update to the latest and greatest.</em></p>\n<hr />\n<p><em>Now for some good news:<br />\nWordPress 3.9 is near.<br />\nExpect it this week</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/news/2014/04/wordpress-3-8-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 3.9 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://wordpress.org/news/2014/04/wordpress-3-9-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wordpress.org/news/2014/04/wordpress-3-9-release-candidate/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Apr 2014 21:05:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3129\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:338:\"As teased earlier, the first release candidate for WordPress 3.9 is now available for testing! We hope to ship WordPress 3.9 next week, but we need your help to get there. If you haven’t tested 3.9 yet, there’s no time like the present. (Please, not on a production site, unless you’re adventurous.) To test WordPress 3.9 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2967:\"<p><a href=\"//wordpress.org/news/2014/04/wordpress-3-8-2/\">As teased earlier</a>, the first release candidate for WordPress 3.9 is now available for testing!</p>\n<p>We hope to ship WordPress 3.9 <em>next week</em>, but we need your help to get there. If you haven’t tested 3.9 yet, there’s no time like the present. (Please, not on a production site, unless you’re adventurous.)</p>\n<p>To test WordPress 3.9 RC1, try the <a href=\"//wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"//wordpress.org/wordpress-3.9-RC1.zip\">download the release candidate here</a> (zip). If you’d like to learn more about what’s new in WordPress 3.9, visit the work-in-progress About screen in your dashboard (<strong><img src=\"//i0.wp.com/core.svn.wordpress.org/branches/3.6/wp-content/themes/twentyten/images/wordpress.png?w=692\" alt=\"\" width=\"16\" height=\"16\" /> → About</strong> in the toolbar) and check out <a title=\"WordPress 3.9 Beta 1\" href=\"//wordpress.org/news/2014/03/wordpress-3-9-beta-1/\">the Beta 1 post</a>.</p>\n<p><strong>Think you’ve found a bug? </strong>Please post to the <a href=\"//wordpress.org/support/forum/alphabeta/\">Alpha/Beta area in the support forums</a>. If any known issues come up, you’ll be able to <a href=\"//core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p><strong>If you&#8217;re a plugin author</strong>, there are two important changes in particular to be aware of:</p>\n<ul>\n<li>TinyMCE received a major update, to version 4.0. Any editor plugins written for TinyMCE 3.x might require some updates. (If things broke, we&#8217;d like to hear about them so we can make adjustments.) For more, see TinyMCE&#8217;s <a href=\"http://www.tinymce.com/wiki.php/Tutorial:Migration_guide_from_3.x\">migration guide</a> and <a href=\"http://www.tinymce.com/wiki.php/api4:index\">API documentation</a>, and the notes on the <a href=\"//make.wordpress.org/core/2014/01/18/tinymce-4-0-is-in-core/\">core development blog</a>.</li>\n<li>WordPress 3.9 now uses the MySQLi Improved extension for sites running PHP 5.5. Any plugins that made direct calls to <code>mysql_*</code> functions will experience some problems on these sites. For more information, see the notes on the <a href=\"//make.wordpress.org/core/2014/04/07/mysql-in-wordpress-3-9/\">core development blog</a>.</li>\n</ul>\n<p>Be sure to follow along the core development blog, where we will be continuing to post <a href=\"//make.wordpress.org/core/tag/3-9-dev-notes/\">notes for developers for 3.9</a>. (For example, read <a href=\"//make.wordpress.org/core/2014/03/27/masonry-in-wordpress-3-9/\">this</a> if you are using Masonry in your theme.) And please, please update your plugin&#8217;s <em>Tested up to</em> version in the readme to 3.9 before April 16.</p>\n<p><em>Release candidate<br />\nThis haiku&#8217;s the easy one<br />\n3.9 is near</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"http://wordpress.org/news/2014/04/wordpress-3-9-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 3.8.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"http://wordpress.org/news/2014/04/wordpress-3-8-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://wordpress.org/news/2014/04/wordpress-3-8-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Apr 2014 19:04:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3124\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:355:\"WordPress 3.8.2 is now available. This is an important security release for all previous versions and we strongly encourage you to update your sites immediately. This releases fixes a weakness that could let an attacker force their way into your site by forging authentication cookies. This was discovered and fixed by Jon Cave of the WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2272:\"<p>WordPress 3.8.2 is now available. This is an important security release for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>This releases fixes a weakness that could let an attacker force their way into your site by forging authentication cookies. This was discovered and fixed by <a href=\"http://joncave.co.uk/\">Jon Cave</a> of the WordPress security team.</p>\n<p>It also contains a fix to prevent a user with the Contributor role from improperly publishing posts. Reported by <a href=\"http://edik.ch/\">edik</a>.</p>\n<p>This release also fixes nine bugs and contains three other security hardening changes:</p>\n<ul>\n<li>Pass along additional information when processing pingbacks to help hosts identify potentially abusive requests.</li>\n<li>Fix a low-impact SQL injection by trusted users. Reported by <a href=\"http://www.dxw.com/\">Tom Adams</a> of dxw.</li>\n<li>Prevent possible cross-domain scripting through Plupload, the third-party library WordPress uses for uploading files. Reported by <a href=\"http://szgru.website.pl/\">Szymon Gruszecki</a>.</li>\n</ul>\n<p>We appreciated <a href=\"http://codex.wordpress.org/FAQ_Security\">responsible disclosure</a> of these security issues directly to our security team. For more information on all of the changes, see the <a href=\"http://codex.wordpress.org/Version_3.8.2\">release notes</a> or consult <a href=\"https://core.trac.wordpress.org/log/branches/3.8?rev=28057&amp;stop_rev=27024\">the list of changes</a>.</p>\n<p><a href=\"http://wordpress.org/download/\">Download WordPress 3.8.2</a> or venture over to <strong>Dashboard → Updates</strong> and simply click &#8220;Update Now.&#8221;</p>\n<p>Sites that support automatic background updates will be updated to WordPress 3.8.2 within 12 hours. If you are still on WordPress 3.7.1, you will be updated to 3.7.2, which contains the same security fixes as 3.8.2. We don&#8217;t support older versions, so please update to 3.8.2 for the latest and greatest.</p>\n<p>Already testing WordPress 3.9? The first release candidate is <a href=\"https://wordpress.org/wordpress-3.9-RC1.zip\">now available</a> (zip) and it contains these security fixes. Look for a full announcement later today; we expect to release 3.9 next week.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/news/2014/04/wordpress-3-8-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 3.9 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/news/2014/03/wordpress-3-9-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://wordpress.org/news/2014/03/wordpress-3-9-beta-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 29 Mar 2014 13:15:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3106\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:373:\"The third (and maybe last) beta of WordPress 3.9 is now available for download. Beta 3 includes more than 200 changes, including: New features like live widget previews and the new theme installer are now more ready for prime time, so check &#8216;em out. UI refinements when editing images and when working with media in the editor. We&#8217;ve also brought [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2668:\"<p>The third (and maybe last) beta of WordPress 3.9 is now available for download.</p>\n<p>Beta 3 includes more than 200 <a href=\"https://core.trac.wordpress.org/log?rev=27850&amp;stop_rev=27639&amp;limit=300\">changes</a>, including:</p>\n<ul>\n<li>New features like live widget previews and the new theme installer are now more ready for prime time, so check &#8216;em out.</li>\n<li>UI refinements when editing images and when working with media in the editor. We&#8217;ve also brought back some of the advanced display settings for images.</li>\n<li>If you want to test out audio and video playlists, the links will appear in the media manager once you&#8217;ve uploaded an audio or video file.</li>\n<li>For theme developers, we&#8217;ve added HTML5 caption support (<a class=\"reopened ticket\" title=\"task (blessed): HTML5 captions (reopened)\" href=\"https://core.trac.wordpress.org/ticket/26642\">#26642</a>) to match the new gallery support (<a class=\"closed ticket\" title=\"enhancement: HTML5 Galleries (closed: fixed)\" href=\"https://core.trac.wordpress.org/ticket/26697\">#26697</a>).</li>\n<li>The formatting function that turns straight quotes into smart quotes (among other things) underwent some changes to drastically speed it up, so let us know if you see anything weird.</li>\n</ul>\n<p><strong>We need your help</strong>. We&#8217;re still aiming for an April release, which means the next week will be critical for identifying and squashing bugs. If you&#8217;re just joining us, please see <a href=\"https://wordpress.org/news/2014/03/wordpress-3-9-beta-1/\">the Beta 1 announcement post</a> for what to look out for.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"http://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums, where friendly moderators are standing by. <b>Plugin developers</b><strong>,</strong> if you haven&#8217;t tested WordPress 3.9 yet, now is the time — and be sure to update the &#8220;tested up to&#8221; version for your plugins so they&#8217;re listed as compatible with 3.9.</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 3.9, try the <a href=\"http://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"http://wordpress.org/wordpress-3.9-beta3.zip\">download the beta here</a> (zip).</p>\n<p><em>WordPress 3.9<br />\nLet&#8217;s make the date official<br />\nIt&#8217;s April 16</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://wordpress.org/news/2014/03/wordpress-3-9-beta-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 3.9 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/news/2014/03/wordpress-3-9-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://wordpress.org/news/2014/03/wordpress-3-9-beta-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Mar 2014 05:01:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3101\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:309:\"WordPress 3.9 Beta 2 is now available for testing! We&#8217;ve made more than a hundred changes since Beta 1, but we still need your help if we&#8217;re going to hit our goal of an April release. For what to look out for, please head on over to the Beta 1 announcement post. Some of the changes in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1901:\"<p>WordPress 3.9 Beta 2 is now available for testing!</p>\n<p>We&#8217;ve made more than a hundred <a href=\"https://core.trac.wordpress.org/log?rev=27639&amp;stop_rev=27500&amp;limit=200\">changes</a> since Beta 1, but we still need your help if we&#8217;re going to hit our goal of an April release. For what to look out for, please head on over to <a href=\"https://wordpress.org/news/2014/03/wordpress-3-9-beta-1/\">the Beta 1 announcement post</a>. Some of the changes in Beta 2 include:</p>\n<ul>\n<li>Rendering of embedded audio and video players directly in the visual editor.</li>\n<li>Visual and functional improvements to the editor, the media manager, and theme installer.</li>\n<li>Various bug fixes to TinyMCE, the software behind the visual editor.</li>\n<li>Lots of fixes to widget management in the theme customizer.</li>\n</ul>\n<p>As always,<strong> if you think you’ve found a bug</strong>, you can post to the <a href=\"http://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"http://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"http://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=3.9\">everything we’ve fixed</a> so far.</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 3.9, try the <a href=\"http://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"http://wordpress.org/wordpress-3.9-beta2.zip\">download the beta here</a> (zip).</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://wordpress.org/news/2014/03/wordpress-3-9-beta-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 3.9 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/news/2014/03/wordpress-3-9-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://wordpress.org/news/2014/03/wordpress-3-9-beta-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Mar 2014 13:42:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3083\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"I&#8217;m excited to announce that the first beta of WordPress 3.9 is now available for testing. WordPress 3.9 is due out next month &#8212; but in order to hit that goal, we need your help testing all of the goodies we&#8217;ve added: We updated TinyMCE, the software powering the visual editor, to the latest version. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6065:\"<p>I&#8217;m excited to announce that the <strong>first beta of WordPress 3.9</strong> is now available for testing.</p>\n<p>WordPress 3.9 is due out next month &#8212; but in order to hit that goal, <strong>we need your help</strong> testing all of the goodies we&#8217;ve added:</p>\n<ul>\n<li>We updated TinyMCE, the software powering the visual editor, to the latest version. Be on the lookout for cleaner markup. Also try the new paste handling &#8212; if you paste in a block of text from Microsoft Word, for example, it will no longer come out terrible. (The &#8220;Paste from Word&#8221; button you probably never noticed has been removed.) It&#8217;s possible some plugins that added stuff to the visual editor (like a new toolbar button) no longer work, so we&#8217;d like to hear about them (<a href=\"https://core.trac.wordpress.org/ticket/24067\">#24067</a>). (And be sure to <a href=\"http://wordpress.org/support/\">open a support thread</a> for the plugin author.)</li>\n<li>We&#8217;ve added <strong>widget management to live previews</strong> (the customizer). Please test editing, adding, and rearranging widgets! (<a href=\"https://core.trac.wordpress.org/ticket/27112\">#27112</a>) We&#8217;ve also added the ability to upload, crop, and manage header images, without needing to leave the preview. (<a href=\"https://core.trac.wordpress.org/ticket/21785\">#21785</a>)</li>\n<li>We brought 3.8&#8217;s beautiful new theme browsing experience to the <strong>theme installer</strong>. Check it out! (<a title=\"View ticket\" href=\"https://core.trac.wordpress.org/ticket/27055\">#27055</a>)</li>\n<li><strong>Galleries</strong> now receive a live preview in the editor. Upload some photos and insert a gallery to see this in action. (<a href=\"https://core.trac.wordpress.org/ticket/26959\">#26959</a>)</li>\n<li>You can now <strong>drag-and-drop</strong> images directly onto the editor to upload them. It can be a bit finicky, so try it and help us work out the kinks. (<a href=\"https://core.trac.wordpress.org/ticket/19845\">#19845</a>)</li>\n<li>Some things got improved around <strong>editing images</strong>. It&#8217;s a lot easier to make changes to an image after you insert it into a post (<a class=\"closed\" title=\"View ticket\" href=\"https://core.trac.wordpress.org/ticket/24409\">#24409</a>) and you no longer get kicked to a new window when you need to crop or rotate an image (<a href=\"https://core.trac.wordpress.org/ticket/21811\">#21811</a>).</li>\n<li>New <strong>audio/video playlists</strong>. Upload a few audio or video files to test these. (<a href=\"https://core.trac.wordpress.org/ticket/26631\">#26631</a>)</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"http://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We&#8217;d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"http://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"http://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=3.9\">everything we’ve fixed</a> so far.</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 3.9, try the <a href=\"http://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"http://wordpress.org/wordpress-3.9-beta1.zip\">download the beta here</a> (zip).</p>\n<hr />\n<p><strong>DEVELOPERS!</strong> Hello! There&#8217;s lots for you, too.</p>\n<p><strong>Please test your plugins and themes!</strong> There&#8217;s a lot of great stuff under the hood in 3.9 and we hope to blog a bit about them in the coming days. If you haven&#8217;t been reading the awesome <a href=\"http://make.wordpress.org/core/tag/week-in-core/\">weekly summaries</a> on the <a href=\"http://make.wordpress.org/core/\">main core development blog</a>, that&#8217;s a great place to start. (You should definitely follow that blog.) For now, here are some things to watch out for when testing:</p>\n<ul>\n<li>The <strong>load process in multisite</strong> got rewritten. If you notice any issues with your network, see <a href=\"https://core.trac.wordpress.org/ticket/27003\">#27003</a>.</li>\n<li>We now use the <strong>MySQL Improved (mysqli) database extension</strong> if you&#8217;re running a recent version of PHP (<a href=\"https://core.trac.wordpress.org/ticket/21663\">#21663</a>). Please test your plugins and see that everything works well, and please make sure you&#8217;re not calling <code>mysql_*</code> functions directly.</li>\n<li><strong>Autosave</strong> was refactored, so if you see any issues related to autosaving, heartbeat, etc., let us know (<a href=\"https://core.trac.wordpress.org/ticket/25272\">#25272</a>).</li>\n<li>Library updates, in particular Backbone 1.1 and Underscore 1.6 (<a href=\"https://core.trac.wordpress.org/ticket/26799\">#26799</a>). Also Masonry 3 (<a href=\"https://core.trac.wordpress.org/ticket/25351\">#25351</a>), PHPMailer (<a href=\"https://core.trac.wordpress.org/ticket/25560\">#25560</a>), Plupload (<a href=\"https://core.trac.wordpress.org/ticket/25663\">#25663</a>), and TinyMCE (<a href=\"https://core.trac.wordpress.org/ticket/24067\">#24067</a>).</li>\n<li>TinyMCE 4.0 is a <em>major</em> update. Please see TinyMCE&#8217;s <a href=\"http://www.tinymce.com/wiki.php/Tutorial:Migration_guide_from_3.x\">upgrade guide</a> and our <a href=\"https://core.trac.wordpress.org/ticket/24067\">implementation ticket</a> for more. If you have any questions or problems, please <a href=\"http://wordpress.org/support/forum/alphabeta\">open a thread in the support forums</a>.</li>\n</ul>\n<p>Happy testing!</p>\n<p><em><em>Lots of improvements<br />\nLittle things go a long way</em><br />\nPlease test beta one<br />\n</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://wordpress.org/news/2014/03/wordpress-3-9-beta-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 3.8.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"http://wordpress.org/news/2014/01/wordpress-3-8-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://wordpress.org/news/2014/01/wordpress-3-8-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jan 2014 20:37:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3063\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"After six weeks and more than 9.3 million downloads of WordPress 3.8, we&#8217;re pleased to announce WordPress 3.8.1 is now available. Version 3.8.1 is a maintenance releases that addresses 31 bugs in 3.8, including various fixes and improvements for the new dashboard design and new themes admin screen. An issue with taxonomy queries in WP_Query [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3809:\"<p>After six weeks and more than <a href=\"http://wordpress.org/download/counter/\">9.3 million downloads</a> of WordPress 3.8, we&#8217;re pleased to announce WordPress 3.8.1 is now available.</p>\n<p>Version 3.8.1 is a maintenance releases that addresses 31 bugs in 3.8, including various fixes and improvements for the new dashboard design and new themes admin screen. An issue with taxonomy queries in WP_Query was resolved. And if you&#8217;ve been frustrated by submit buttons that won&#8217;t do anything when you click on them (or thought you were going crazy, like some of us), we&#8217;ve found and fixed this &#8220;dead zone&#8221; on submit buttons.</p>\n<p>It also contains a fix for <strong>embedding tweets</strong> (by placing the URL to the tweet on its own line), which was broken due to a recent Twitter API change. (For more on Embeds, see <a href=\"http://codex.wordpress.org/Embeds\">the Codex</a>.)</p>\n<p>For a full list of changes, consult the <a href=\"http://core.trac.wordpress.org/query?milestone=3.8.1\">list of tickets</a> and <a href=\"https://core.trac.wordpress.org/log/branches/3.8?rev=27018&amp;stop_rev=26862\">the changelog</a>. There&#8217;s also a <a href=\"http://make.wordpress.org/core/2014/01/22/wordpress-3-8-1-release-candidate/\">detailed summary</a> for developers on the development blog.</p>\n<p>If you are one of the millions already running WordPress 3.8, we will start rolling out automatic background updates for WordPress 3.8.1 in the next few hours. For sites <a href=\"http://wordpress.org/plugins/background-update-tester/\">that support them</a>, of course.</p>\n<p><a href=\"http://wordpress.org/download/\">Download WordPress 3.8.1</a> or venture over to <strong>Dashboard → Updates</strong> and simply click &#8220;Update Now.&#8221;</p>\n<p>Thanks to all of these fine individuals for contributing to 3.8.1:</p>\n<p><a href=\"http://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"http://profiles.wordpress.org/collinsinternet\">Allan Collins</a>, <a href=\"http://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"http://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"http://profiles.wordpress.org/aubreypwd\">Aubrey Portwood</a>, <a href=\"http://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"http://profiles.wordpress.org/cojennin\">Connor Jennings</a>, <a href=\"http://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"http://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"http://profiles.wordpress.org/fboender\">fboender</a>, <a href=\"http://profiles.wordpress.org/avryl\">Janneke Van Dorpe</a>, <a href=\"http://profiles.wordpress.org/janrenn\">janrenn</a>, <a href=\"http://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"http://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"#\">José Pino</a>, <a href=\"http://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"http://profiles.wordpress.org/matveb\">Matias Ventura</a>, <a href=\"http://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"http://profiles.wordpress.org/iammattthomas\">Matt Thomas</a>, <a href=\"http://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"http://profiles.wordpress.org/batmoo\">Mohammad Jangda</a>, <a href=\"http://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"http://profiles.wordpress.org/nivijah\">nivijah</a>, <a href=\"http://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"http://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"http://profiles.wordpress.org/undergroundnetwork\">undergroundnetwork</a>, and <a href=\"http://profiles.wordpress.org/yurivictor\">Yuri Victor</a>.</p>\n<p><em>WordPress three eight one<br />\nWe heard you didn&#8217;t like bugs<br />\nSo we took them out</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/news/2014/01/wordpress-3-8-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:31:\"http://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 25 Jun 2014 07:55:52 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:10:\"x-pingback\";s:36:\"http://wordpress.org/news/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Thu, 08 May 2014 18:40:58 GMT\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("1459","_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1403726154","no");
INSERT INTO wp_options VALUES("1460","_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1403682954","no");
INSERT INTO wp_options VALUES("1461","_transient_timeout_plugin_slugs","1403769388","no");
INSERT INTO wp_options VALUES("1462","_transient_plugin_slugs","a:7:{i:0;s:39:\"custom-login-page/custom-login-page.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:3;s:55:\"ultimate-maintenance-mode/ultimate-maintenance-mode.php\";i:4;s:37:\"wordpress-database-reset/wp-reset.php\";i:5;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:6;s:27:\"wp-super-cache/wp-cache.php\";}","no");
INSERT INTO wp_options VALUES("1465","_transient_timeout_feed_mod_867bd5c64f85878d03a060509cd2f92c","1403726165","no");
INSERT INTO wp_options VALUES("1466","_transient_feed_mod_867bd5c64f85878d03a060509cd2f92c","1403682965","no");
INSERT INTO wp_options VALUES("1467","_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109","1403726166","no");
INSERT INTO wp_options VALUES("1468","_transient_feed_b9388c83948825c1edaef0d856b7b109","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordPress Plugins » View: Most Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Jun 2014 07:30:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:15:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"http://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"23862@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"Supercharge your WordPress site with powerful features previously only available to WordPress.com users.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"753@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"http://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"132@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"arnee\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2141@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"WordPress SEO by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"http://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"8321@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the WordPress SEO plugin by Yoast.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"http://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"15@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"MailPoet Newsletters\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://wordpress.org/plugins/wysija-newsletters/#post-32629\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Dec 2011 17:09:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"32629@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Send newsletters, post notifications or autoresponders from WordPress easily, and beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"MailPoet Staff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29860@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"18101@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"http://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29832@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"Wordfence Security is a free enterprise class security and performance plugin that makes your site up to 50 times faster and more secure.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"21738@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"The easiest, most effective way to secure WordPress in seconds.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Disqus Comment System\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"http://wordpress.org/plugins/disqus-comment-system/#post-6808\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Aug 2008 01:22:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"6808@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"The Disqus comment system replaces your WordPress comment system with your comments hosted and powered by Disqus.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Disqus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"1169@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 10 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Fast Secure Contact Form\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"http://wordpress.org/plugins/si-contact-form/#post-12636\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Aug 2009 01:20:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"12636@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"An easy and powerful form builder that lets your visitors send you email. Blocks all automated spammers. No templates to mess with.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mike Challis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"http://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2082@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:45:\"http://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 25 Jun 2014 07:56:04 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:7:\"expires\";s:29:\"Wed, 25 Jun 2014 08:05:59 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Wed, 25 Jun 2014 07:30:59 +0000\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("1469","_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109","1403726166","no");
INSERT INTO wp_options VALUES("1470","_transient_feed_mod_b9388c83948825c1edaef0d856b7b109","1403682966","no");
INSERT INTO wp_options VALUES("1471","_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51","1403726166","no");
INSERT INTO wp_options VALUES("1472","_transient_dash_4077549d03da2e451c8b5f002294ff51","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wordpress.org/news/2014/05/wordpress-3-9-1/\' title=\'After three weeks and more than 9 million downloads of WordPress 3.9, we’re pleased to announce that WordPress 3.9.1 is now available. This maintenance release fixes 34 bugs in 3.9, including numerous fixes for multisite networks, customizing widgets while previewing themes, and the updated visual editor. We’ve also made some improvements to the new audio/video […]\'>WordPress 3.9.1 Maintenance Release</a> <span class=\"rss-date\">May 8, 2014</span><div class=\'rssSummary\'>After three weeks and more than 9 million downloads of WordPress 3.9, we’re pleased to announce that WordPress 3.9.1 is now available. This maintenance release fixes 34 bugs in 3.9, including numerous fixes for multisite networks, customizing widgets while previewing themes, and the updated visual editor. We’ve also made some improvements to the new audio/vi [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wptavern.com/new-oembed-providers-coming-in-wordpress-4-0?utm_source=rss&#038;utm_medium=rss&#038;utm_campaign=new-oembed-providers-coming-in-wordpress-4-0\' title=\'photo credit: Scorpions and Centaurs – cc WordPress 4.0 is on track to introduce several new oEmbed providers, according to the most recent core report from Mike Schroder. The following sites and services have been added to the whitelist of oEmbed providers:  TED talks Mixcloud CollegeHumor.com Issuu Polldaddy’s short URL format YouTube playlist URLs  The process of getting added to the whitelist of providers is not as easy as it seems. The design decision section of the WordPress core handbook states that the provider must be an established, popular, and trusted site. It must also properly and fully implement the oEmbed specification. When determining how established and popular a service is, there are nine questions to consider, i.e. “If similar services are already supported, how does this service compare in terms of size, features, and backing?” and “Does the service make an effort to build relationships with developers, such as through robust APIs?” New oEmbed service providers that are proposed for inclusion in core will have to answer these considerations to ensure that it’s not a hasty, shortsighted addition. However, if a site supports oEmbed, anyone can add the site and URL format to the internal whitelist by calling wp_oembed_add_provider(). Many plugins take this route when the provider hasn’t yet been added to core. For example, a trac ticket was submitted for adding oembed support for CodePen. Since the site needs time to become established and popular, a simple plugin with one line of code uses the wp_oembed_add_provider() method to add support in the meantime. This helps to gauge the community’s interest before whitelisting the provider. Of the six new providers listed above, the YouTube playlist URLs addition is likely to have the broadest appeal, given YouTube’s massive user base. You’ll be able to make use of the new oEmbed providers as soon as WordPress 4.0 ships. A beta is expected around the first week of July. The official release is targeted for the week of August 25.\'>WPTavern: New oEmbed Providers Coming in WordPress 4.0</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/free-revisr-plugin-offers-git-management-for-wordpress?utm_source=rss&#038;utm_medium=rss&#038;utm_campaign=free-revisr-plugin-offers-git-management-for-wordpress\' title=\' This month we featured a project called VersionPress that brings version control to WordPress, a concept that has many in the community excited. The VersionPress development team is seeking $30,000 in funding by the end of June in order to get it off the ground. However, they aren’t the only ones working on adding git-based version control to WordPress. Earlier this month, developer Matt Shaw quietly released Revisr on WordPress.org. Revisr is a plugin that allows developers to synchronize with any Git repository and easily commit, push, pull, and branch changes from within the WordPress admin. It’s different from VersionPress in that it’s designed to integrate with a remote repository, ie. one hosted on GitHub or Bitbucket. Unlike VersionPress, which hasn’t yet met its funding goals, Revisr is free and available now. The plugin  allows you to manage your WordPress website with a git repository and currently includes the following features:  Track changes to the files and database of your WordPress installation Optionally use different database versions for each branch Commit and push changes to a remote repository (including Bitbucket and Github) Pull changes down from a remote repository Easily toggle between branches Revert your website files and/or database to an earlier commit Discard any unwanted changes Manage .gitignore to prevent unwanted files/directories from being tracked  “I made Revisr to simplify the development process,” Shaw told the Tavern. “There are currently no plugins on WordPress.org that allow developers or site admins to use all of the main features of Git through the WordPress dashboard, and I made Revisr to do just that,” he said. “At the same time, I wanted it to be simple enough so it could be used by people who aren’t necessarily interested in Git, but are interested in having backups and being able to quickly revert changes if needed.” For the sake of user-friendliness, Revisr includes an interface in the admin for committing, reverting, pushing and pulling changes:  Revisr makes it easy to view changes in files:  A commit history for the site is available in the WordPress admin:  How to Set Up Revisr The plugin has three requirements:  A WordPress installation in the root folder of a Git repository Git must be installed on the server (most updated versions of cPanel have it preinstalled) PHP exec (safe mode off, can be configured in your php.ini)  If you want to use Revisr with an existing site, you must ensure that the “.git” directory is in the root directory of the WordPress installation. The plugin will then attempt to use the settings stored in Git for pushing to/pulling from any remote repositories, which can be defined on the plugin settings page. Revisr supports git through SSH or HTTPS:  If you’re using SSH for authentication, you will need to generate an SSH key and add it to Bitbucket/Github. The process for setting up a new installation with Revisr is fairly easy:  Create the repository on Bitbucket or Github Clone the repository to your computer, add WordPress, and push it to the repository. Upload the entire repository to the server, install WordPress, and add Revisr  Benefits of Using Revisr: Revision Tracking, Branching, and Backups Matt Shaw believes that Revisr can benefit WordPerss admins in several ways in addition to revision tracking. “Revisr helps the admins see all files that have been changed and the specific changes within those,” he said. “This is an advantage if many files need to be modified and helps to keep issues at a minimum. An added benefit is having backups and being able to quickly spot and revert some website hacks if they occur.” “Branching also enables site admins to easily test theme changes or new functionality and quickly toggle back and forth between different versions of the site,” Shaw noted. “For example, a site admin could create a new branch to preview layout changes, and switch back to the original branch and old layout if needed.” Recent updates to the plugin include the option to keep the database separate between branches. This allows users to go back and restore the database from any commit in which the database was also backed up. Since Revisr tracks both database and file changes, it is suitable for keeping a complete backup of the site. Site admins can easily make full restore points before major changes such as a WordPress core or plugin upgrade. In the next major update, Shaw plans to give admins more control on what gets committed and reverted, allowing specific files to be reverted without affecting the overall project. He also plans on adding the ability to tag commits with a version number and the ability to view/merge changes between branches. Future versions of the plugin will include the ability to merge changes between branches and the ability to schedule backups of both the website files and database. The Future of the Revisr Plugin I asked Shaw about the future of the plugin and if he plans on monetizing it. “The plugin will always be completely free and open source,” he replied. “We are also working on a paid standalone application that can interface with Revisr that will allow teams and web firms to manage multiple websites using Git. However, the full functionality of the plugin will always be free.” Shaw is working with a team that aims to launch Revisr Pro, a paid application, later this year. Revisr Pro will work with any type of project, but it will also be able to interface with the Revisr plugin via an API to add more features to both the plugin and the standalone application. “It’s designed to simplify managing large amounts of websites (20+) with multiple environments, with file and database tracking with Git, project-level tasks, and team support,” Shaw said. “Revisr Pro is also able to deploy and configure new projects, simplifying the workflow for teams using Git, and allowing more time to be spent focused on the project itself.” They plan to feature straightforward pricing, and won’t charge for additional users or projects. Shaw is currently the sole developer on the Revisr WordPress plugin project, although he has friends who are helping out with testing and design. His plugin is different from VersionPress in that it isn’t targeted toward bringing version control to the masses. Revisr is geared more toward developers and isn’t supported by a crowd-funding campaign. Shaw is just one man working to create a plugin that helps improve his own workflow. You can download Revisr on WordPress.org and watch for updates as the plugin continues to develop.\'>WPTavern: Free Revisr Plugin Offers Git Management for WordPress</a></li><li><a class=\'rsswidget\' href=\'http://wordpress.tv/2014/06/24/scott-bolinger-building-mobile-apps-with-wordpress/\' title=\'    \'>WordPress.tv: Scott Bolinger: Building Mobile Apps with WordPress</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Popular Plugin:</span> <a href=\'http://wordpress.org/plugins/jetpack/\' class=\'dashboard-news-plugin-link\'>Jetpack by WordPress.com</a></h5>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=jetpack&amp;_wpnonce=f5086c09c3&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'Jetpack by WordPress.com\'>Install</a>)</span></li></ul></div>","no");
INSERT INTO wp_options VALUES("944","auto_updater.lock","1403595602","no");
INSERT INTO wp_options VALUES("151","current_theme","airconbasix","yes");
INSERT INTO wp_options VALUES("152","theme_mods_airconbasix","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:3;}}","yes");
INSERT INTO wp_options VALUES("153","theme_switched","","yes");
INSERT INTO wp_options VALUES("282","seedprod_maintenancemode_options","a:4:{s:19:\"comingsoon_bg_image\";s:76:\"http://moodsofafrica.com/develop/wp-content/uploads/2013/07/maintenance1.jpg\";s:19:\"comingsoon_headline\";s:25:\"Website under development\";s:3:\"msg\";s:112:\"<p style=\"text-align: center;\">Please contact <a href=\"http://edgewebdesign.com.au\">edgewebdesign.com.au</a></p>\";s:24:\"comingsoon_footer_credit\";s:1:\"0\";}","yes");
INSERT INTO wp_options VALUES("285","seedprod_maintenancemode_mshot_pass","TAOtzli64XeI","yes");
INSERT INTO wp_options VALUES("369","wpsupercache_start","1392000846","yes");
INSERT INTO wp_options VALUES("370","wpsupercache_count","0","yes");
INSERT INTO wp_options VALUES("463","supercache_stats","a:3:{s:9:\"generated\";i:1392704311;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:12:\"expired_list\";a:0:{}s:6:\"cached\";i:0;s:11:\"cached_list\";a:0:{}s:2:\"ts\";i:1392704311;}s:7:\"wpcache\";a:3:{s:6:\"cached\";i:0;s:7:\"expired\";i:0;s:5:\"fsize\";s:3:\"0KB\";}}","yes");
INSERT INTO wp_options VALUES("501","wp_login_logo_settings","a:3:{s:11:\"enable_logo\";s:2:\"no\";s:8:\"logo_url\";s:0:\"\";s:15:\"custom_bg_color\";s:0:\"\";}","yes");
INSERT INTO wp_options VALUES("505","clp_options","a:22:{s:7:\"version\";s:5:\"1.9.1\";s:4:\"logo\";s:88:\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/login-logo.png\";s:3:\"url\";s:0:\"\";s:5:\"title\";s:0:\"\";s:10:\"logo_width\";s:3:\"239\";s:11:\"logo_height\";s:2:\"63\";s:8:\"h1_width\";s:0:\"\";s:9:\"h1_height\";s:0:\"\";s:9:\"h1_margin\";s:0:\"\";s:10:\"h1_padding\";s:0:\"\";s:9:\"h1_corner\";s:0:\"\";s:11:\"h1_shadow_x\";s:0:\"\";s:11:\"h1_shadow_y\";s:0:\"\";s:18:\"h1_shadow_softness\";s:0:\"\";s:15:\"h1_shadow_color\";s:0:\"\";s:15:\"body_background\";s:0:\"\";s:15:\"body_img_repeat\";s:0:\"\";s:12:\"body_img_pos\";s:0:\"\";s:14:\"body_bg_color1\";s:0:\"\";s:14:\"body_bg_color2\";s:0:\"\";s:12:\"body_bg_size\";s:0:\"\";s:9:\"multisite\";b:0;}","yes");
INSERT INTO wp_options VALUES("1451","db_upgraded","","yes");
INSERT INTO wp_options VALUES("1453","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:3:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-3.9.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-3.9.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-3.9.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-3.9.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"3.9.1\";s:7:\"version\";s:5:\"3.9.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"3.8\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":10:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-3.9.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-3.9.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-3.9.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-3.9.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"3.9.1\";s:7:\"version\";s:5:\"3.9.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"3.8\";s:15:\"partial_version\";s:0:\"\";}i:2;O:8:\"stdClass\":10:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-3.9.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-3.9.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"3.9\";s:7:\"version\";s:3:\"3.9\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"3.8\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1403682935;s:15:\"version_checked\";s:5:\"3.8.3\";s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("1432","_site_transient_update_plugins","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1403682980;s:7:\"checked\";a:7:{s:39:\"custom-login-page/custom-login-page.php\";s:5:\"2.1.1\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"3.8.1\";s:37:\"tinymce-advanced/tinymce-advanced.php\";s:7:\"3.5.9.1\";s:55:\"ultimate-maintenance-mode/ultimate-maintenance-mode.php\";s:5:\"1.5.4\";s:37:\"wordpress-database-reset/wp-reset.php\";s:5:\"2.3.1\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:5:\"2.1.6\";s:27:\"wp-super-cache/wp-cache.php\";s:3:\"1.4\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("1473","_transient_timeout_feed_a41fbee65e190c85018f9081fcc3dfc4","1403726195","no");
INSERT INTO wp_options VALUES("1474","_transient_feed_a41fbee65e190c85018f9081fcc3dfc4","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:51:\"\n	\n	\n	\n	\n	\n	\n		\n		\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress Training » News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://members.wpacademy.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jun 2014 14:42:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"WP Encyclopedia 2014 is almost ready!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://members.wpacademy.com/2014/06/wp-encyclopedia-2014-is-almost-ready/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://members.wpacademy.com/2014/06/wp-encyclopedia-2014-is-almost-ready/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jun 2014 13:43:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19764\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:587:\"<p>Great news!  The WordPress Business Encyclopedia, 2014 Edition, is almost ready.  In particular the plugin reviews section is nearly complete (I am just tying up loose ends).  It is now the most comprehensive plugin reviews site on the web: 350+ plugins in 52 categories, with reviews and recommendations.  The list should include all the most [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/06/wp-encyclopedia-2014-is-almost-ready/\">WP Encyclopedia 2014 is almost ready!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2122:\"<p></p><p><img class=\"alignright size-medium wp-image-19770\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/06/be_cd2-300x300.jpg\" alt=\"WP Encyclopedai 2014\" width=\"300\" height=\"300\" />Great news!  <strong>The WordPress Business Encyclopedia, 2014 Edition</strong>, is almost ready.  In particular the <a href=\"http://wpencyclopedia.com/index.htm?plugin_reviews.htm\" target=\"_blank\">plugin reviews</a> section is nearly complete (I am just tying up loose ends).  It is now the most comprehensive plugin reviews site on the web: 350+ plugins in 52 categories, with reviews and recommendations.  The list should include all the most popular WordPress plugins.  Enjoy!</p>\n<p>I wish to thank our generous crowd funders for making this possible.  Thanks to them, the review articles are free for everyone.  If you have already donated, you can also access all the videos including our <a href=\"http://wpencyclopedia.com/index.htm?theme_selection__customization.htm\" target=\"_blank\">WordPress Theme Selection</a> course and the <a href=\"http://wpencyclopedia.com/index.htm?wp_live_course_recordings.htm\" target=\"_blank\">WP Live Course Recordings</a>.  If you have not yet donated to WP Encyclopedia, you can still access all these resources at the discounted rate of $30 <a href=\"http://wpacademy.com/enc/\" target=\"_blank\">here</a> – but only for the next 10 days or so, when we release the final product for $47.</p>\n<p>(Note: if you donated to the DVD version last year, I will be emailing you within the next 2 weeks).</p>\n<p>A reminder also that our new, super-affordable <strong>Starter Website Packages</strong> are doing well – and we only have 7 left (out of 10) for the summer production cycle.  I anticipate they will sell out within a week, so <a href=\"http://www.wpacademy.com/websites/\" target=\"_blank\">get yours now</a> if you want your site ready by Labor day.</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/06/wp-encyclopedia-2014-is-almost-ready/\">WP Encyclopedia 2014 is almost ready!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://members.wpacademy.com/2014/06/wp-encyclopedia-2014-is-almost-ready/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Super-affordable Website Design Packages are now available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://members.wpacademy.com/2014/06/super-affordable-website-design-packages-are-now-available/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://members.wpacademy.com/2014/06/super-affordable-website-design-packages-are-now-available/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Jun 2014 14:43:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19754\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:569:\"<p>This is a big moment for WP Academy. For years, people have asked us: do we do websites?&#160; And we had to say &#34;No, but we will teach you how to do it&#34;.&#160; And we did just that &#8212; over 500 people have attended our live courses, while 10,000+ took one of our courses on [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/06/super-affordable-website-design-packages-are-now-available/\">Super-affordable Website Design Packages are now available</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3867:\"<p></p><p>This is a big moment for WP Academy. </p>\n<p>For years, people have asked us: do we do websites?&#160; And we had to say &quot;No, but we will teach you how to do it&quot;.&#160; And we did just that &#8212; over 500 people have attended our live courses, while 10,000+ took one of our courses on <a href=\"http://wpencyclopedia.com\">WP Encyclopedia</a> or on Udemy.&#160; But many people in our do-it-yourself training needed either a little extra help, or to be told directly what to do.&#160; </p>\n<p>If you need a new website that looks professional and gets you business; or if you already have a website but it needs more work than you have either the desire or the skills for, then this mail will be of interest to you.&#160; </p>\n<p>&gt;&gt; <a href=\"http://wpacademy.com/websites\">View our super-affordable Website Design Starter Package here</a> &lt;&lt;</p>\n<p><strong>Who are these sites for?</strong></p>\n<p><strong></strong></p>\n<p>These sites are for entrepreneurs on a money- and time-budget who want a quick website that does the job and looks professional.&#160; They don&#8217;t want to mess with all the technical details of setting it up.&#160; They probably have their sales copy ready but need the opinion of a professional marketer.&#160; They may already know a little WordPress but want to learn how a professional does it, so that they can do it again on their own later.</p>\n<p><strong>Does your site pass the &quot;5 second test&quot;?</strong></p>\n<p>Statistics show that most visitors to your site will leave unless your website answers the following questions within 5 seconds: </p>\n<ul>\n<li>Who are you?</li>\n<li>What product or service do you provide?</li>\n<li>&quot;What&#8217;s in it for me&quot;?</li>\n</ul>\n<p>Many website development projects fail because the sites are not designed or written for a clear business purpose.&#160; And many traditional website designers (and particularly offshore contractors) can&#8217;t help you with this.&#160; </p>\n<p>&gt;&gt; <a href=\"http://wpacademy.com/websites\">See other reasons why website development projects fail</a> &lt;&lt;</p>\n<p>Myself and my associates Christopher Staser and George Plumley have a combined 25 years of website development and internet marketing experiences.&#160; Each starter website package includes 2 hours direct one-on-one consultation with one of us &#8212; this time is likely to be a very valuable investment for you.&#160; </p>\n<p><strong>Very limited availability during June and July</strong></p>\n<p>During June and July we are prototyping this model, to make sure that we have everything in place when this service officially launches in September.&#160; As such, we can only offer 10 of these packages right now.&#160; Getting on the beta program for these sites is to your advantage, as we will be making double-sure that you are taken care of (we want that testimonial!).&#160; But you will need to act fast as the packages will likely sell out quickly.</p>\n<p><strong></strong></p>\n<p><strong>Book a free 15 minute consultation and website diagnosis</strong></p>\n<p>Curious to find out more?&#160; Then book yourself a free 15-minute consultation and website diagnosis <a href=\"http://wpacademy.com/websites\">here</a>.</p>\n<p><strong>PS: We do higher-end sites too</strong>, with optional full verbal and visual branding and messaging.&#160; Simply respond to this email for details.</p>\n<p>To Your Success,</p>\n<p><img border=\"0\" src=\"https://d1yoaun8syyxxt.cloudfront.net/gt121-6abc1e07-2a24-4224-9ceb-2de5b32743e7-v2\" width=\"150\" align=\"bottom\" height=\"150\" /></p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/06/super-affordable-website-design-packages-are-now-available/\">Super-affordable Website Design Packages are now available</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://members.wpacademy.com/2014/06/super-affordable-website-design-packages-are-now-available/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Free ebook: Spark a movement, change the world\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://members.wpacademy.com/2014/04/free-ebook-spark-a-movement-change-the-world/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://members.wpacademy.com/2014/04/free-ebook-spark-a-movement-change-the-world/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Apr 2014 22:48:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19636\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:604:\"<p>I am excited to share a completely free, live online event, with my friends and colleagues Jason and Tom.  They are experts at collaborative and alternative business models, and will be sharing their expertise tomorrow, Friday 4/17 at Noon (EST). Jason Spencer, founder of TRIBE.LY and The Flight Formula, uses community models (TRIBES) to foster [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/04/free-ebook-spark-a-movement-change-the-world/\">Free ebook: Spark a movement, change the world</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3406:\"<p></p><p>I am excited to share a completely free, live online event, with my friends and colleagues Jason and Tom.  They are experts at collaborative and alternative business models, and will be sharing their expertise tomorrow, <span style=\"text-decoration: underline;\">Friday 4/17 at Noon (EST).</span></p>\n<p>Jason Spencer, founder of TRIBE.LY and The Flight Formula, uses community models (TRIBES) to foster the incubation space to bring ideas and businesses to life.</p>\n<p>Tom Morkes, author and entrepreneur, founder of The Creative Entrepreneur digital magazine and Insurgent Publishing, is a leading expert in Pay What You Want Pricing models. Tom&#8217;s unique area of expertise and experience has helped jump-start many fledging, boot-strapped businesses during the critical start phase.</p>\n<p>For more information on this special live online event happening tomorrow, Friday 4/17 at Noon (EST), and to reserve your spot, visit here:</p>\n<p><a href=\"http://www.theflightformula.com/starting-from-scratch\">http://www.theflightformula.com/starting-from-scratch</a></p>\n<p>If you can’t attend the live event, register anyway to receive a copy of Jason&#8217;s eBook, &#8220;The TRIBE Builder&#8217;s Manifesto: Spark a Movement. Change the World.&#8221;</p>\n<p>There will be also be live Q&amp;A on the topic of starting and incubating business, so be sure to bring your questions, so Jason and Tom can respond to you directly!</p>\n<p>At the end of the webinar, Jason and Tom will be unveiling details on a limited opportunity to get involved in <b>The Flight Formula</b> experience. They are in the midst of taking applications for 6 open spots in a 7-day mastermind program taking place near Asheville, NC in the Blue Ridge Mountains of Western North Carolina the week of June 1-7, 2014.</p>\n<p>The Flight Formula is a hybrid between:</p>\n<p>1. Empowering Tribalpreneurs through the <b><span style=\"text-decoration: underline;\">inner work of discovering your purpose</span></b>, your gifts, and everything you have to offer to the world. This requires digging deep and learning about your own limiting beliefs and the things that are holding you back, and assisting you in the process of letting those go, so that your gift can be free to fly.</p>\n<p>and</p>\n<p>2. Equipping Tribalpreneurs with the <b><span style=\"text-decoration: underline;\">business skills and strategies</span></b> required to launch your gift sustainably through lean startup models. From launching websites and lead generation mechanisms, to professionally recording your first promotional video, The Flight Formula ensures you have the tools, resources and skills necessary to fly in the context of modern online business.</p>\n<p>I hope that you&#8217;ll join us tomorrow, experience some tremendous value in the steps Jason and Tom will be leading us through in &#8220;Starting From Scratch&#8221;, get your own questions answered, and find out more about the amazing Flight Formula mastermind TRIBE assembling in June.</p>\n<p>Register here:</p>\n<p><a href=\"http://www.theflightformula.com/starting-from-scratch\">http://www.theflightformula.com/starting-from-scratch</a></p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/04/free-ebook-spark-a-movement-change-the-world/\">Free ebook: Spark a movement, change the world</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://members.wpacademy.com/2014/04/free-ebook-spark-a-movement-change-the-world/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WP Live Beginner &amp; Advanced Session starting next week\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://members.wpacademy.com/2014/03/wp-live-beginner-advanced-session-starting-next-week/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://members.wpacademy.com/2014/03/wp-live-beginner-advanced-session-starting-next-week/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Mar 2014 14:55:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19593\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:621:\"<p>A reminder that we are starting a new WP Live Beginner session this coming Tuesdays April 1-29, 7-8:30pm EST (+ 30 min Q&#38;A).&#160; This will be followed by the Advanced Session, Tuesdays April 29 – May 20, 2-3:30pm EST (+ Q&#38;A).&#160; The content coverage of the Beginner and Advanced sessions are listed below.&#160; Essentially, this [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/03/wp-live-beginner-advanced-session-starting-next-week/\">WP Live Beginner &amp; Advanced Session starting next week</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2778:\"<p></p><p>A reminder that we are starting a new <u>WP Live Beginner session this coming</u> <u>Tuesdays April 1-29, 7-8:30pm EST (+ 30 min Q&amp;A)</u>.&#160; This will be followed by the <u>Advanced Session, Tuesdays April 29 – May 20, 2-3:30pm EST (+ Q&amp;A)</u>.&#160; </p>\n<p>The content coverage of the Beginner and Advanced sessions are listed below.&#160; Essentially, this is the most comprehensive WordPress-based web marketing course on the web, with a whole bunch of additional services (group coaching, themes, stock photos etc) providing a complete do-it-yourself web marketing solution.&#160; </p>\n<p><strong>&gt;&gt; </strong><a href=\"http://www.wpacademy.com/wordpress-training/\"><strong>Register Here</strong></a><strong> &lt;&lt;</strong></p>\n<p><strong>Beginner Session content</strong> </p>\n<p>The Beginner sessions give you, in 4 weeks, a fundamental knowledge of the WordPress application, user-interface and best practices.&#160; They cover a similar curriculum to the <a href=\"http://wpencyclopedia.com/index.htm?wordpress_essentials_training.htm\">WordPress Essentials for Business</a> series and the <a href=\"http://wpencyclopedia.com/index.htm?theme_selection__customization.htm\">WordPress Theme Selection &amp; Customization</a> courses on WP Encyclopedia.&#160; </p>\n<p><strong>Advanced Session content</strong></p>\n<p>The Advanced sessions cover pretty well all the things that you need to know to setup a lead-generating, money-making website.&#160; Included are: </p>\n<ul>\n<li>Week 1: HTML/CSS introduction, Backup &amp; Security, Social media integration &amp; Facebook fan pages</li>\n<li>Week 2: Newsletter systems, shopping carts, payment systems, membership systems</li>\n<li>Week 3: SEO &amp; Blogging, Google analytics</li>\n<li>Week 4: Online video: scripting, equipment &amp; shooting, editing, delivering</li>\n</ul>\n<p>All sessions are recorded, so even if you can’t make the live sessions, just watch the recordings and then come to the best coaching session for your schedule.</p>\n<p>I hope you can join us!&#160; </p>\n<p>If you would like to hear what people are saying about the WordPress for Business Course, watch the testimonials video on the <a href=\"http://www.wpacademy.com/wordpress-training/\">Courses page</a>.&#160; </p>\n<p>To Your Success,</p>\n<p><img title=\"Marc Beneteau\" alt=\"\" src=\"http://wpacademy.tv/wp-content/uploads/2011/09/marc-full-150x150.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau   <br />”Your Small-Biz Web Technology Mentor” </p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/03/wp-live-beginner-advanced-session-starting-next-week/\">WP Live Beginner &amp; Advanced Session starting next week</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"http://members.wpacademy.com/2014/03/wp-live-beginner-advanced-session-starting-next-week/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WP Live discount expires tomorrow\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"http://members.wpacademy.com/2014/03/wp-live-discount-expires-tomorrow/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://members.wpacademy.com/2014/03/wp-live-discount-expires-tomorrow/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Mar 2014 15:35:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19555\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:601:\"<p>As promised, here are some segments of the first “WordPress for Business Live” class that started last Tuesday.&#160; It describes how we work, the content coverage, and also how WordPress fits in to modern-day business development methodologies (“Lean Startup”) and will help you increase your income.&#160; Click-through to watch the 8 minute video: Three WP [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/03/wp-live-discount-expires-tomorrow/\">WP Live discount expires tomorrow</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3130:\"<p></p><p>As promised, here are some segments of the first “WordPress for Business Live” class that started last Tuesday.&#160; It describes how we work, the content coverage, and also how WordPress fits in to modern-day business development methodologies (“Lean Startup”) and <u>will</u> help you increase your income.&#160; </p>\n<p>Click-through to watch the 8 minute video:</p>\n<p><a href=\"http://vimeo.com/wpacademy/review/88657878/1f9304018c\"><img title=\"SNAGHTML199656bd\" style=\"border-top: 0px; border-right: 0px; background-image: none; border-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; display: inline; padding-right: 0px\" border=\"0\" alt=\"SNAGHTML199656bd\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/03/SNAGHTML199656bd.png\" width=\"308\" height=\"232\" /></a></p>\n<p><strong>Three WP Live sessions this Spring</strong></p>\n<ul>\n<li>Session 1 (Beginner ): Tuesdays March 4 – March 25, 2-4pm EST (4 sessions) </li>\n<li>Session 2 (Beginner repeats): Tuesdays April 1 – April 22, 7-9pm EST (4 sessions)</li>\n<li>Session 3 (Advanced): Tuesdays April 29 – May 20, 2-4pm EST (4 sessions)</li>\n</ul>\n<p>As you will see if you watch the video, the course covers all the WordPress bases, and much, much more.&#160; You could pay thousands of dollars from a business development coach for this information and get less.&#160; A lot less.</p>\n<p><strong>Price increases to $497 tomorrow (Tuesday) night</strong></p>\n<p>We have recently doubled the content coverage and duration of the course, including the support &amp; coaching period (to 8 lectures / 3 months) but have kept the same price as before ($347).&#160; Tomorrow night, however (Tuesday 3/11) the price does go up to $497 for the 3 month course.&#160; Forever.&#160; We will only be running this a few times a year going forward.&#160; So this is also your last chance to join before the fall.&#160; </p>\n<p>Register here:</p>\n<p><a title=\"http://www.wpacademy.com/wordpress-training/\" href=\"http://www.wpacademy.com/wordpress-training/\">http://www.wpacademy.com/wordpress-training/</a></p>\n<p>You can either join the current beginner session (Tuesdays 2-4pm) or the next one that starts in April.&#160; Then join us in May for the 4 advanced lectures.&#160; The price covers all 3 sessions, 48+ hours group coaching, themes worth $1300, stock photos and ticket support.&#160; This is quite simply the best WordPress &amp; Web Marketing technology training on the web.&#160; Not to mention one of the most affordable.&#160; And George and myself will both be teaching, to bring you the best WP Live course ever.&#160; </p>\n<p>Hope you can join us.&#160; </p>\n<p>To Your Success,</p>\n<p><img title=\"Marc Beneteau\" alt=\"\" src=\"http://wpacademy.tv/wp-content/uploads/2011/09/marc-full-150x150.jpg\" width=\"150\" height=\"150\" />    <br />Marc Beneteau    <br />”Your Small-Biz Web Technology Mentor” </p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/03/wp-live-discount-expires-tomorrow/\">WP Live discount expires tomorrow</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"http://members.wpacademy.com/2014/03/wp-live-discount-expires-tomorrow/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WordPress for Business Live Courses starting soon!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://members.wpacademy.com/2014/03/wordpress-for-business-live-courses-starting-soon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://members.wpacademy.com/2014/03/wordpress-for-business-live-courses-starting-soon/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Mar 2014 17:17:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19551\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:587:\"<p>A reminder that we just started a WP Live session last Tuesday (and it’s not too late to join);&#160; and also that we will be repeating the beginner session starting Tuesday April 1, 7-9pm EST. If you are interested in either session, you will most likely want to register very soon.&#160; Why?&#160; Because the price [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/03/wordpress-for-business-live-courses-starting-soon/\">WordPress for Business Live Courses starting soon!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2371:\"<p></p><p>A reminder that we just started a WP Live session last Tuesday (and it’s not too late to join);&#160; and also that we will be repeating the beginner session starting <u>Tuesday April 1, 7-9pm EST</u>.</p>\n<p>If you are interested in either session, you will most likely want to register very soon.&#160; Why?&#160; Because <strong>the price goes up to retail this coming Tuesday night, to $497</strong> – we decided to keep it as affordable as possible while still having the new price reflect the fact that we have doubled the services.&#160; <strong>But the current price (until Tuesday) is just $347</strong></p>\n<p><strong>Why a Live Course?</strong>&#160; </p>\n<p>Three reasons (fundamentally):</p>\n<ol>\n<li>The WordPress software is relatively simple (you can learn it an hour) but to use it well (actually make attractive websites that make money) you need to know a whole lot more.&#160; You will need information that is widely scattered over the web and frequently poorly-presented or out-of-date</li>\n<li>You will likely learn better (and more pleasurably as well) in a more interactive (live Q&amp;A) format</li>\n<li>You will likely hugely accelerate your learning curve by having a live mentor</li>\n</ol>\n<p>Remember: we don’t just teach you WordPress. <strong>We teach you how to make money online</strong>.&#160; George and I have been doing this with our clients for 10-15 years.&#160; “Been there, done that”. </p>\n<p>On Monday I will put out a video with some brief takeaways of last Tuesday’s class.&#160; But if you already know you want this (and don’t want to risk having to pay the higher price from next Tuesday), you should register here:</p>\n<p><a title=\"http://www.wpacademy.com/wordpress-training#purchase\" href=\"http://www.wpacademy.com/wordpress-training#purchase\">http://www.wpacademy.com/wordpress-training#purchase</a></p>\n<p>To your success,</p>\n<p><img title=\"Marc Beneteau\" alt=\"\" src=\"http://wpacademy.tv/wp-content/uploads/2011/09/marc-full-150x150.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau   <br />”Your Small-Biz Web Technology Mentor” </p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/03/wordpress-for-business-live-courses-starting-soon/\">WordPress for Business Live Courses starting soon!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://members.wpacademy.com/2014/03/wordpress-for-business-live-courses-starting-soon/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WP Live starts tomorrow – three sessions, time-limited pricing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://members.wpacademy.com/2014/03/wp-live-starts-tomorrow-three-sessions-time-limited-pricing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://members.wpacademy.com/2014/03/wp-live-starts-tomorrow-three-sessions-time-limited-pricing/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Mar 2014 14:56:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19527\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:641:\"<p>This is reminder that our next WP Live (“WordPress for Business” 8-week course) begins tomorrow.  There are actually 3 sessions as follows: Session 1 (Beginner): Tuesdays March 4 – March 25, 2-4pm EST (4 sessions) Session 2 (Beginner session repeats): Tuesdays April 1 – April 22, 7-9pm EST Session 3 (Advanced): Tuesdays April 29 &#8211; [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/03/wp-live-starts-tomorrow-three-sessions-time-limited-pricing/\">WP Live starts tomorrow &#8211; three sessions, time-limited pricing</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4501:\"<p></p><p>This is reminder that our next WP Live (“WordPress for Business” 8-week course) begins tomorrow.  There are actually 3 sessions as follows:</p>\n<ul>\n<li>Session 1 (Beginner): Tuesdays March 4 – March 25, 2-4pm EST (4 sessions)</li>\n<li>Session 2 (Beginner session repeats): Tuesdays April 1 – April 22, 7-9pm EST</li>\n<li>Session 3 (Advanced): Tuesdays April 29 &#8211; May 20, 2-4pm EST</li>\n</ul>\n<p>Note that the second beginner session is now an <span style=\"text-decoration: underline;\">evening session</span> (as per student demand).  If you can’t attend any session, they are all recorded – just watch the recording and then come to the best coaching session for your schedule and time zone. Note also that by registering today, you get almost 4 months of services (coaching, support, themes and stock photos).</p>\n<p>We have been running these courses 3 years (and have recently resurrected the “original WP Live” as well).  If you are tired of fighting with your WordPress website and your web marketing technology, then look no further.  Nobody does this better than we do.  We also throw in valuable business and marketing advice for free – advice that might cost you thousands of dollars from a business or marketing coach, and that could transform your business overnight.  George and I have both “been there, done that”.  Not just for ourselves, but for hundreds of clients.</p>\n<p><strong>Coaching schedule sessions</strong></p>\n<p>Here is the current coaching schedule (but note that we add sessions depending on enrollment and student demand – we want you to be happy! – <a href=\"mailto:support@wpacademy.com\" target=\"_blank\">write to us</a> for special requests).  These are all drop-in sessions that take place via GotoMeeting.</p>\n<p><img style=\"background-image: none; padding-top: 0px; padding-left: 0px; display: inline; padding-right: 0px; border: 0px;\" title=\"SNAGHTMLd3462cd\" alt=\"SNAGHTMLd3462cd\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/03/SNAGHTMLd3462cd2.png\" width=\"600\" height=\"150\" border=\"0\" /></p>\n<p>Register from <a href=\"http://www.wpacademy.com/wordpress-training/\" target=\"_blank\">here</a>.  There are payment plans (and remember price is going up dramatically on <span style=\"text-decoration: underline;\">Tuesday March 11</span> – we have doubled the services but keeping the old price – but only for a short time)</p>\n<p><strong>Hear some recent student testimonials:</strong></p>\n<p>(We get these every week, here just a few recent ones)</p>\n<p>&#8220;The value of the group coaching alone is priceless.  It&#8217;s like getting the course and everything else free.  In addition to their technical expertise, Marc and George have business experience that can save you thousands of dollars.&#8221; – Eugenia K.</p>\n<p>“I wanted to tell you that I think George is an incredible instructor. He is clear, humorous, and covers a whole lot of ground in each lecture. Thank you for providing this class.  I am finally feeling empowered with wordpress!” – Sue C.</p>\n<p>“Without doubt your Academy is the best resource I have come across on e training. I am still finding, and gaining great knowledge..” – Darby C.</p>\n<p><strong>Questions / feedback?</strong></p>\n<p>Just email support@wpacademy.com or call (610) 314-7712 Ext. 1. That is my direct line and I will do my best to get back to you asap.  But don’t delay – the first section starts tomorrow!</p>\n<p>Here again is the direct registration link:</p>\n<p><a title=\"http://www.wpacademy.com/wordpress-training/\" href=\"http://www.wpacademy.com/wordpress-training/\">http://www.wpacademy.com/wordpress-training/</a></p>\n<p>If you are interested in the Second beginner session (April 1-22) you may still want to register sooner rather than later to lock in your price (but remember no later than March 11 if you want to save the big bucks).</p>\n<p>All course details will be sent to you after registering.</p>\n<p>To your success,<br />\n<img title=\"Marc Beneteau\" alt=\"\" src=\"http://wpacademy.tv/wp-content/uploads/2011/09/marc-full-150x150.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau<br />\n”Your Small-Biz Web Technology Mentor”</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/03/wp-live-starts-tomorrow-three-sessions-time-limited-pricing/\">WP Live starts tomorrow &#8211; three sessions, time-limited pricing</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://members.wpacademy.com/2014/03/wp-live-starts-tomorrow-three-sessions-time-limited-pricing/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Free WordPress eCommerce w/ WooCommerce course\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://members.wpacademy.com/2014/02/free-wordpress-ecommerce-w-woocommerce-course/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://members.wpacademy.com/2014/02/free-wordpress-ecommerce-w-woocommerce-course/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Feb 2014 14:53:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19519\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:592:\"<p>Our latest course WordPress eCommerce w/ WooCommerce has been published to WP Encyclopedia (get it here) and to Udemy (get it here for just $12 or get the free course here).&#160; The free course includes the eCommerce introduction and WooCommerce Quick Start series, and it is very good.&#160; In fact, this is&#160; perhaps the best [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/02/free-wordpress-ecommerce-w-woocommerce-course/\">Free WordPress eCommerce w/ WooCommerce course</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2499:\"<p></p><p>Our latest course <strong>WordPress eCommerce w/ WooCommerce</strong> has been published to WP Encyclopedia (get it <a href=\"http://wpencyclopedia.com/index.htm?shopping_carts__payment_system.htm\" target=\"_blank\">here</a>) and to Udemy (get it <a href=\"https://www.udemy.com/woocommerce/?couponCode=WPA\" target=\"_blank\">here</a> for just $12 or get the free course <a href=\"https://www.udemy.com/woocommerce-free\" target=\"_blank\">here</a>).&#160; </p>\n<p>The free course includes the eCommerce introduction and WooCommerce Quick Start series, and it is very good.&#160; In fact, this is&#160; perhaps the best short course I have ever made and a major milestone in the development of WP Encyclopedia (that will be coming out in July).&#160; We are able to provide this level of high-quality, free content due to your <a href=\"http://wpacademy.com/enc/\" target=\"_blank\">generous donations to WP Encyclopedia</a>.&#160; </p>\n<p><strong>Reminder: WP Live starts next week (and price goes up to $597 quite soon)</strong></p>\n<p>Also a friendly reminder that our popular live training “WP Live” starts next week (<u>Tuesday March 4</u>, repeating again <u>Tuesday April 1</u>, with the advanced lectures in <u>May</u>).&#160; And that the price of the live course goes up to $597 on <u>March 11</u> – forever.&#160; Note that even the higher price is still very cheap considering that it includes 16 hours live lectures, 48+ hours group coaching, themes worth $1350 and ticket support for all your WordPress questions.&#160; For 3 full months (4 months if you register now).</p>\n<p>If you have been wanting to fast-start your education in WordPress and Web Marketing Technology, I suggest you register for the course now.&#160; There is really nothing like it anywhere else.&#160; We will even accept a rain-check (pay now and attend the next course in the fall).&#160; Register <a href=\"http://www.wpacademy.com/wordpress-training/\" target=\"_blank\">here</a> (there are payment options as well).&#160; </p>\n<p>To Your Success,</p>\n<p><img title=\"Marc Beneteau\" alt=\"\" src=\"http://wpacademy.tv/wp-content/uploads/2011/09/marc-full-150x150.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau   <br />”Your Small-Biz Web Technology Mentor”</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/02/free-wordpress-ecommerce-w-woocommerce-course/\">Free WordPress eCommerce w/ WooCommerce course</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://members.wpacademy.com/2014/02/free-wordpress-ecommerce-w-woocommerce-course/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WP Live Dates &amp; limited-time savings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://members.wpacademy.com/2014/02/wp-live-dates-limited-time-savings/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://members.wpacademy.com/2014/02/wp-live-dates-limited-time-savings/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Feb 2014 17:18:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19511\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:565:\"<p>Great news! Our next WP Live course begins next Tuesday March 4, 2-4pm (with a follow-up session a month later).&#160; And even better news – we are doubling the content (adding 4 advanced classes), and doubling the length of coaching and other services (to 4 months)… for the same price ($347).&#160; See below for this [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/02/wp-live-dates-limited-time-savings/\">WP Live Dates &amp; limited-time savings</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3962:\"<p></p><p>Great news! <strong> Our next WP Live course begins next <u>Tuesday March 4, 2-4pm</u> (with a follow-up session a month later).</strong>&#160; </p>\n<p>And even better news – we are doubling the content (adding 4 advanced classes), and doubling the length of coaching and other services (to 4 months)…<em> for the same price ($347).</em>&#160; See below for this astonishing offer.</p>\n<p>If you are looking to gain a solid web marketing technology education in 3 months, and you have the time and a little money (<em>very</em> little money), you will want to read on.</p>\n<p>Let me explain first – the original WP Live program included 4 beginner lectures: the 2 “WordPress Essentials” lectures, a theme selection lecture, and a plugin selection lecture.&#160; And it had 4 advanced lectures: HTML/CSS, Social Media, Newsletters/Autoresponders, Shopping Carts &amp; Membership, SEO, and online video.&#160; </p>\n<p>About a year ago (after running this program to packed-houses many times at prices around $600), we changed to a rolling registration system and cut the last four live lectures.&#160; Well, registration dropped.&#160; People simply wanted the live lectures.&#160; </p>\n<p><strong><em>We heard you, and we’re back!</em></strong>&#160; George Plumley and myself are teaming up to give you the best WP Live course ever created.&#160; And it will go the full 8-12 weeks and include the advanced lectures.&#160; Live.&#160; In classes small enough that we will take your questions on the chat and even on the webinar itself.&#160; </p>\n<p>Now I could go on and on about the value of having a flesh-and-blood teacher and mentor, among so many other things, but instead I will direct you to the sales page:</p>\n<p><a title=\"http://www.wpacademy.com/wordpress-training/\" href=\"http://www.wpacademy.com/wordpress-training/\">http://www.wpacademy.com/wordpress-training/</a></p>\n<p>You will see registration options at the bottom.&#160; There are two identical beginner sessions (one in March and one in April) and an advanced session in May.</p>\n<p><strong>But here is the best part of it: the cost</strong></p>\n<p>We will be increasing the price for the new, 3-month WP Live program on <u>Monday March 10</u> to what it used to be ($597).&#160; But not yet.</p>\n<p>In others words: you can reserve a seat in the next WP Live course now and attend either the March or April beginner session, return for the May advanced session, and pay the old price!&#160; </p>\n<p>And remember that all WP Live programs include 4+ hours of weekly group coaching, unlimited theme downloads, stock photos, and ticket support.&#160; And a 28-day Money-Back Guarantee.&#160; </p>\n<p><strong>&gt;&gt;&gt; </strong><a href=\"http://www.wpacademy.com/wordpress-training/\" target=\"_blank\"><strong>Register Here</strong></a><strong> &lt;&lt;&lt;</strong></p>\n<p>Maybe you have a friend who needs this?&#160; Then forward them this email.&#160; Just remember that WP Live will never be so affordable again.&#160; </p>\n<p>PS: We sometimes add course sections.&#160; If you really want to take the course but can’t do the Tuesday 2pm, please email to our <a href=\"mailto:support@wpacademy.com\">support@wpacademy.com</a> and tell them your constraints</p>\n<p>PPS: Did you know that we also now do high-value mid-range websites on spec?&#160; ($1000-$2500). Just write to our <a href=\"mailto:support@wpacademy.com\">support@wpacademy.com</a> with your requirements and/or a request to contact.</p>\n<p>To Your Success,</p>\n<p><img title=\"Marc Beneteau\" alt=\"\" src=\"http://wpacademy.tv/wp-content/uploads/2011/09/marc-full-150x150.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau   <br />”Your Small-Biz Web Technology Mentor” </p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/02/wp-live-dates-limited-time-savings/\">WP Live Dates &amp; limited-time savings</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://members.wpacademy.com/2014/02/wp-live-dates-limited-time-savings/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Cash flow crash course (for solo business owners)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://members.wpacademy.com/2014/01/cash-flow-crash-course-for-solo-business-owners/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://members.wpacademy.com/2014/01/cash-flow-crash-course-for-solo-business-owners/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jan 2014 15:12:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19485\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:606:\"<p>For years my colleague Christine Kane has been teaching heart-centered business owners how to make money in their businesses – while keeping their soul and authenticity intact. So that’s why I&#8217;m writing. This week, Christine is doing a free training that will teach you how to stop struggling and how to “Crack the Cashflow Code” [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/01/cash-flow-crash-course-for-solo-business-owners/\">Cash flow crash course (for solo business owners)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2510:\"<p></p><p>For years my colleague Christine Kane has been teaching heart-centered business owners how to make money in their businesses – while keeping their soul and authenticity intact. </p>\n<p>So that’s why I&#8217;m writing. This week, Christine is doing a free training that will teach you how to stop struggling and how to “Crack the Cashflow Code” in your business… </p>\n<p><a href=\"https://christinekane.infusionsoft.com/go/cashflowcode/marc/\" target=\"_blank\"><strong>Cashflow Code Training &lt;== register now</strong></a></p>\n<p>Here’s what you’ll get:</p>\n<p>• How to finally end that painful cycle of dry spells that leaves you fearfully praying for clients.</p>\n<p>• How to get clear on your offer so that your ideal clients will pay you what you’re worth.</p>\n<p>• How to raise your prices without all the internal drama. <img src=\"http://members.wpacademy.com/wp-includes/images/smilies/icon_smile.gif\" alt=\":)\" class=\"wp-smiley\" /> </p>\n<p>• A 10-step “Money Map” that shows you exactly how to attract and convert your ideal client every time. (Post this by your desk!)</p>\n<p>Christine transitioned her music career into a multi-million dollar coaching company using these very strategies. She’ll also share inside secrets of her students who have doubled and tripled their income using these simple steps.</p>\n<p>This is a ONE-TIME training event (totally free) and the doors close next week&#8230;</p>\n<p>Here’s the link to grab your space:</p>\n<p><a href=\"https://christinekane.infusionsoft.com/go/cashflowcode/marc/\" target=\"_blank\"><strong>Cashflow Code Training &lt;== register now</strong></a></p>\n<p>P.S. Warning: This ain’t no new-age “get rich through positive thinking” program. Christine’s got her own style of teaching that combines (IMHO) the best of “mindset” (attitude) with practical and effective business strategies that her clients have been working successfully for years.&#160; Heck, my own <a href=\"http://pleasureevolution.com\" target=\"_blank\">wife</a> is in her program and generating brilliant results.&#160; Christine’s programs are particularly good for people developing coaching or personal-service businesses, but many different types of businesses have been served.</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/01/cash-flow-crash-course-for-solo-business-owners/\">Cash flow crash course (for solo business owners)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://members.wpacademy.com/2014/01/cash-flow-crash-course-for-solo-business-owners/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:48:\"http://members.wpacademy.com/category/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:4:\"date\";s:29:\"Wed, 25 Jun 2014 07:56:32 GMT\";s:6:\"server\";s:9:\"LiteSpeed\";s:10:\"connection\";s:5:\"close\";s:12:\"x-powered-by\";s:10:\"PHP/5.4.19\";s:10:\"set-cookie\";a:5:{i:0;s:55:\"wlmdebug=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT\";i:1;s:210:\"wc_session_cookie_d0fb3bf6a09f702cdfb97e4d2c564710=jqqhEny011vxyax77tsemZOtsEUizeSL%7C%7C1403855791%7C%7C1403852191%7C%7C3aaa40f215f0e0dddda66317ecafb382; expires=Fri, 27-Jun-2014 07:56:31 GMT; path=/; httponly\";i:2;s:74:\"woocommerce_items_in_cart=0; expires=Wed, 25-Jun-2014 06:56:32 GMT; path=/\";i:3;s:70:\"woocommerce_cart_hash=0; expires=Wed, 25-Jun-2014 06:56:32 GMT; path=/\";i:4;s:76:\"wfvt_1871270157=53aa80b0a2587; expires=Wed, 25-Jun-2014 08:26:32 GMT; path=/\";}s:10:\"x-pingback\";s:39:\"http://members.wpacademy.com/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Wed, 18 Jun 2014 14:42:19 GMT\";s:4:\"etag\";s:34:\"\"37fdd3d50c7e85bb9820048231d79861\"\";s:12:\"x-robots-tag\";s:14:\"noindex,follow\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("1414","_site_transient_timeout_browser_7df5c10583e393ed36ed7157f4f7e7e6","1404196763","yes");
INSERT INTO wp_options VALUES("1415","_site_transient_browser_7df5c10583e393ed36ed7157f4f7e7e6","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"35.0.1916.153\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");



DROP TABLE wp_postmeta;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=233 DEFAULT CHARSET=utf8;

INSERT INTO wp_postmeta VALUES("1","2","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("4","5","_wp_attached_file","2014/01/contactus-large.jpg");
INSERT INTO wp_postmeta VALUES("5","5","_wp_attachment_metadata","a:5:{s:5:\"width\";i:275;s:6:\"height\";i:413;s:4:\"file\";s:27:\"2014/01/contactus-large.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"contactus-large-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"contactus-large-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("8","7","_wp_attached_file","2014/01/contactus2_sml.png");
INSERT INTO wp_postmeta VALUES("9","7","_wp_attachment_metadata","a:5:{s:5:\"width\";i:125;s:6:\"height\";i:125;s:4:\"file\";s:26:\"2014/01/contactus2_sml.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("216","211","_wp_attached_file","2014/01/about2.jpg");
INSERT INTO wp_postmeta VALUES("217","211","_wp_attachment_metadata","a:5:{s:5:\"width\";i:220;s:6:\"height\";i:674;s:4:\"file\";s:18:\"2014/01/about2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"about2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"about2-97x300.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("202","143","_wp_attached_file","2014/02/blog1.jpg");
INSERT INTO wp_postmeta VALUES("203","143","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:266;s:4:\"file\";s:17:\"2014/02/blog1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"blog1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"blog1-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("212","206","_wp_attached_file","2014/01/Logo.png");
INSERT INTO wp_postmeta VALUES("213","206","_wp_attachment_metadata","a:5:{s:5:\"width\";i:375;s:6:\"height\";i:99;s:4:\"file\";s:16:\"2014/01/Logo.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"Logo-150x99.png\";s:5:\"width\";i:150;s:6:\"height\";i:99;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"Logo-300x79.png\";s:5:\"width\";i:300;s:6:\"height\";i:79;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("16","11","_wp_attached_file","2014/01/contactus.jpg");
INSERT INTO wp_postmeta VALUES("17","11","_wp_attachment_metadata","a:5:{s:5:\"width\";i:247;s:6:\"height\";i:371;s:4:\"file\";s:21:\"2014/01/contactus.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"contactus-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"contactus-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("18","12","_theme_show_in_menu","1");
INSERT INTO wp_postmeta VALUES("19","12","_theme_show_as_separator","0");
INSERT INTO wp_postmeta VALUES("20","12","_theme_title_in_menu","Home");
INSERT INTO wp_postmeta VALUES("21","12","_theme_show_page_title","0");
INSERT INTO wp_postmeta VALUES("22","12","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("23","12","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("24","12","_theme_header_image_with_flash","0");
INSERT INTO wp_postmeta VALUES("25","12","theme_head","<style>.edg-content .post-12 .layout-item-0 {  border-collapse: separate;  }\r\n.edg-content .post-12 .layout-item-1 { border-right-style:solid;border-right-width:0px;border-right-color:#D9D9D9; padding-right: 0px;padding-left: 0px;  }\r\n.edg-content .post-12 .layout-item-2 { margin-bottom: 7px;  }\r\n.edg-content .post-12 .layout-item-3 { border-right-style:solid;border-right-width:0px;border-right-color:#D9D9D9; color: #002E4D; background: #1AA3FF; padding-top: 0px;padding-right: 6px;padding-bottom: 5px;padding-left: 6px; border-radius: 15px;  }\r\n.edg-content .post-12 .layout-item-4 { margin-right: 10px;margin-left: 10px;  }\r\n.edg-content .post-12 .layout-item-5 { border-spacing: 10px 0px; border-collapse: separate;  }\r\n.edg-content .post-12 .layout-item-6 { border-right-style:solid;border-right-width:0px;border-right-color:#D9D9D9; color: #003152; background: #F7F7F7 url(\'http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/2dd6c.png\') scroll; padding-right: 6px;padding-left: 6px;  }\r\n.edg-content .post-12 .layout-item-7 { border-right-style:solid;border-right-width:0px;border-right-color:#D9D9D9; color: #003152; background: #F7F7F7 url(\'http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/8b180.png\') scroll; padding-right: 0px;padding-left: 0px;  }\r\n.edg-content .post-12 .layout-item-8 { border-right-style:solid;border-right-width:0px;border-right-color:#D9D9D9; color: #003152; background: #F7F7F7 url(\'http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0171.png\') scroll; padding-right: 6px;padding-left: 6px;  }\r\n.edg-content .post-12 .layout-item-9 { margin-top: 0px;margin-bottom: 0px;  }\r\n.edg-content .post-12 .layout-item-10 { border-bottom-style:Dotted;border-bottom-width:0px;border-bottom-color:#D9D9D9;  }\r\n.edg-content .post-12 .layout-item-11 { margin-top: 2px;  }\r\n.edg-content .post-12 .layout-item-12 { border-right-style:solid;border-right-width:1px;border-right-color:#D9D9D9; padding-right: 5px;padding-left: 5px;  }\r\n.edg-content .post-12 .layout-item-13 { padding-right: 10px;padding-left: 10px;  }\r\n.ie7 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\r\n.ie6 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\r\n\r\n</style>");
INSERT INTO wp_postmeta VALUES("26","12","page_title","Home");
INSERT INTO wp_postmeta VALUES("27","12","use_wpautop","false");
INSERT INTO wp_postmeta VALUES("28","13","_theme_show_in_menu","1");
INSERT INTO wp_postmeta VALUES("29","13","_theme_show_as_separator","0");
INSERT INTO wp_postmeta VALUES("30","13","_theme_title_in_menu","About Us");
INSERT INTO wp_postmeta VALUES("31","13","_theme_show_page_title","1");
INSERT INTO wp_postmeta VALUES("32","13","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("33","13","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("34","13","_theme_header_image_with_flash","0");
INSERT INTO wp_postmeta VALUES("35","13","page_title","About Us");
INSERT INTO wp_postmeta VALUES("36","13","use_wpautop","false");
INSERT INTO wp_postmeta VALUES("37","14","_theme_show_in_menu","1");
INSERT INTO wp_postmeta VALUES("38","14","_theme_show_as_separator","0");
INSERT INTO wp_postmeta VALUES("39","14","_theme_title_in_menu","Services");
INSERT INTO wp_postmeta VALUES("40","14","_theme_show_page_title","1");
INSERT INTO wp_postmeta VALUES("41","14","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("42","14","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("43","14","_theme_header_image_with_flash","0");
INSERT INTO wp_postmeta VALUES("44","14","page_title","Services");
INSERT INTO wp_postmeta VALUES("45","14","use_wpautop","false");
INSERT INTO wp_postmeta VALUES("46","15","_theme_show_in_menu","1");
INSERT INTO wp_postmeta VALUES("47","15","_theme_show_as_separator","0");
INSERT INTO wp_postmeta VALUES("48","15","_theme_title_in_menu","Contact Us");
INSERT INTO wp_postmeta VALUES("49","15","_theme_show_page_title","1");
INSERT INTO wp_postmeta VALUES("50","15","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("51","15","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("52","15","_theme_header_image_with_flash","0");
INSERT INTO wp_postmeta VALUES("53","15","theme_head","<style>.edg-content .post-15 .layout-item-0 { padding-left: 5px;  }\r\n.edg-content .post-15 .layout-item-1 { padding: 5px;  }\r\n.ie7 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\r\n.ie6 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\r\n\r\n</style>");
INSERT INTO wp_postmeta VALUES("54","15","page_title","Contact Us");
INSERT INTO wp_postmeta VALUES("55","15","use_wpautop","false");
INSERT INTO wp_postmeta VALUES("56","16","_theme_show_in_menu","1");
INSERT INTO wp_postmeta VALUES("57","16","_theme_show_as_separator","0");
INSERT INTO wp_postmeta VALUES("58","16","_theme_title_in_menu","Blog");
INSERT INTO wp_postmeta VALUES("59","16","_theme_show_page_title","1");
INSERT INTO wp_postmeta VALUES("60","16","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("61","16","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("62","16","_theme_header_image_with_flash","1");
INSERT INTO wp_postmeta VALUES("63","16","theme_head","<style>.edg-content .post-16 .layout-item-0 { padding-right: 10px;padding-left: 10px;  }\n.ie7 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\n.ie6 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }.edg-content .post-16 .layout-item-0 { padding-right: 10px;padding-left: 10px;  }\n.ie7 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\n.ie6 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\n\n</style>");
INSERT INTO wp_postmeta VALUES("64","16","page_title","Blog Page");
INSERT INTO wp_postmeta VALUES("65","16","use_wpautop","false");
INSERT INTO wp_postmeta VALUES("66","17","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("67","17","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("68","17","_menu_item_object_id","12");
INSERT INTO wp_postmeta VALUES("69","17","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("70","17","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("71","17","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("72","17","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("73","17","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("74","18","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("75","18","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("76","18","_menu_item_object_id","13");
INSERT INTO wp_postmeta VALUES("77","18","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("78","18","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("79","18","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("80","18","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("81","18","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("82","19","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("83","19","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("84","19","_menu_item_object_id","14");
INSERT INTO wp_postmeta VALUES("85","19","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("86","19","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("87","19","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("88","19","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("89","19","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("90","20","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("91","20","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("92","20","_menu_item_object_id","15");
INSERT INTO wp_postmeta VALUES("93","20","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("94","20","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("95","20","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("96","20","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("97","20","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("98","21","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("99","21","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("100","21","_menu_item_object_id","16");
INSERT INTO wp_postmeta VALUES("101","21","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("102","21","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("103","21","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("104","21","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("105","21","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("106","22","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("107","22","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("108","22","_menu_item_object_id","12");
INSERT INTO wp_postmeta VALUES("109","22","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("110","22","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("111","22","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("112","22","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("113","22","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("114","23","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("115","23","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("116","23","_menu_item_object_id","13");
INSERT INTO wp_postmeta VALUES("117","23","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("118","23","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("119","23","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("120","23","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("121","23","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("122","24","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("123","24","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("124","24","_menu_item_object_id","14");
INSERT INTO wp_postmeta VALUES("125","24","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("126","24","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("127","24","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("128","24","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("129","24","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("130","25","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("131","25","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("132","25","_menu_item_object_id","15");
INSERT INTO wp_postmeta VALUES("133","25","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("134","25","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("135","25","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("136","25","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("137","25","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("138","26","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("139","26","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("140","26","_menu_item_object_id","16");
INSERT INTO wp_postmeta VALUES("141","26","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("142","26","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("143","26","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("144","26","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("145","26","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("228","2","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("229","2","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("230","2","_theme_show_page_title","1");
INSERT INTO wp_postmeta VALUES("160","13","_edit_lock","1392626507:1");
INSERT INTO wp_postmeta VALUES("161","32","_wp_attached_file","2014/01/about.jpg");
INSERT INTO wp_postmeta VALUES("162","32","_wp_attachment_metadata","a:5:{s:5:\"width\";i:220;s:6:\"height\";i:530;s:4:\"file\";s:17:\"2014/01/about.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"about-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"about-124x300.jpg\";s:5:\"width\";i:124;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("163","13","_edit_last","1");
INSERT INTO wp_postmeta VALUES("164","14","_edit_lock","1392704669:1");
INSERT INTO wp_postmeta VALUES("168","42","_wp_attached_file","2014/01/service.jpg");
INSERT INTO wp_postmeta VALUES("169","42","_wp_attachment_metadata","a:5:{s:5:\"width\";i:175;s:6:\"height\";i:645;s:4:\"file\";s:19:\"2014/01/service.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"service-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"service-81x300.jpg\";s:5:\"width\";i:81;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("167","14","_edit_last","1");
INSERT INTO wp_postmeta VALUES("170","12","_edit_lock","1393036980:1");
INSERT INTO wp_postmeta VALUES("171","12","_edit_last","1");
INSERT INTO wp_postmeta VALUES("172","54","_form","<p>Your Name (required)<br />\n    [text* your-name] </p>\n\n<p>Your Email (required)<br />\n    [email* your-email] </p>\n\n<p>Subject<br />\n    [text your-subject] </p>\n\n<p>Your Message<br />\n    [textarea your-message] </p>\n\n<p>[submit \"Send\"]</p>");
INSERT INTO wp_postmeta VALUES("173","54","_mail","a:7:{s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:26:\"[your-name] <[your-email]>\";s:4:\"body\";s:231:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Sunshine Coast Airconditioning &amp; Electrical (http://comfortsolutions.com.au/airconditioning)\";s:9:\"recipient\";s:28:\"info@comfortsolutions.com.au\";s:18:\"additional_headers\";s:0:\"\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;}");
INSERT INTO wp_postmeta VALUES("174","54","_mail_2","a:8:{s:6:\"active\";b:0;s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:26:\"[your-name] <[your-email]>\";s:4:\"body\";s:173:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Sunshine Coast Airconditioning &amp; Electrical (http://comfortsolutions.com.au/airconditioning)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:0:\"\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;}");
INSERT INTO wp_postmeta VALUES("175","54","_messages","a:21:{s:12:\"mail_sent_ok\";s:43:\"Your message was sent successfully. Thanks.\";s:12:\"mail_sent_ng\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:16:\"validation_error\";s:74:\"Validation errors occurred. Please confirm the fields and submit it again.\";s:4:\"spam\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:12:\"accept_terms\";s:35:\"Please accept the terms to proceed.\";s:16:\"invalid_required\";s:31:\"Please fill the required field.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:14:\"invalid_number\";s:28:\"Number format seems invalid.\";s:16:\"number_too_small\";s:25:\"This number is too small.\";s:16:\"number_too_large\";s:25:\"This number is too large.\";s:13:\"invalid_email\";s:28:\"Email address seems invalid.\";s:11:\"invalid_url\";s:18:\"URL seems invalid.\";s:11:\"invalid_tel\";s:31:\"Telephone number seems invalid.\";s:23:\"quiz_answer_not_correct\";s:27:\"Your answer is not correct.\";s:12:\"invalid_date\";s:26:\"Date format seems invalid.\";s:14:\"date_too_early\";s:23:\"This date is too early.\";s:13:\"date_too_late\";s:22:\"This date is too late.\";s:13:\"upload_failed\";s:22:\"Failed to upload file.\";s:24:\"upload_file_type_invalid\";s:30:\"This file type is not allowed.\";s:21:\"upload_file_too_large\";s:23:\"This file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"Failed to upload file. Error occurred.\";}");
INSERT INTO wp_postmeta VALUES("176","54","_additional_settings","");
INSERT INTO wp_postmeta VALUES("177","54","_locale","en_US");
INSERT INTO wp_postmeta VALUES("178","15","_edit_lock","1392685611:1");
INSERT INTO wp_postmeta VALUES("179","15","_edit_last","1");
INSERT INTO wp_postmeta VALUES("180","100","_wp_attached_file","2014/01/domstic.jpg");
INSERT INTO wp_postmeta VALUES("181","100","_wp_attachment_metadata","a:5:{s:5:\"width\";i:530;s:6:\"height\";i:350;s:4:\"file\";s:19:\"2014/01/domstic.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"domstic-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"domstic-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("187","135","_wp_attached_file","2014/02/sidebar.jpg");
INSERT INTO wp_postmeta VALUES("188","135","_wp_attachment_metadata","a:5:{s:5:\"width\";i:175;s:6:\"height\";i:2000;s:4:\"file\";s:19:\"2014/02/sidebar.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"sidebar-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"sidebar-26x300.jpg\";s:5:\"width\";i:26;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"sidebar-89x1024.jpg\";s:5:\"width\";i:89;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("184","126","_wp_attached_file","2014/02/home_right.jpg");
INSERT INTO wp_postmeta VALUES("185","126","_wp_attachment_metadata","a:5:{s:5:\"width\";i:530;s:6:\"height\";i:350;s:4:\"file\";s:22:\"2014/02/home_right.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"home_right-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"home_right-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("186","126","_edit_lock","1392608568:1");
INSERT INTO wp_postmeta VALUES("189","135","_edit_lock","1392618162:1");
INSERT INTO wp_postmeta VALUES("227","1","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("197","142","_theme_show_post_title","1");
INSERT INTO wp_postmeta VALUES("198","142","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("199","142","_theme_header_image_with_flash","0");
INSERT INTO wp_postmeta VALUES("200","142","_edit_last","1");
INSERT INTO wp_postmeta VALUES("201","142","_edit_lock","1392619827:1");
INSERT INTO wp_postmeta VALUES("218","223","_wp_attached_file","2014/02/Logo.png");
INSERT INTO wp_postmeta VALUES("219","223","_wp_attachment_metadata","a:5:{s:5:\"width\";i:375;s:6:\"height\";i:99;s:4:\"file\";s:16:\"2014/02/Logo.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"Logo-150x99.png\";s:5:\"width\";i:150;s:6:\"height\";i:99;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"Logo-300x79.png\";s:5:\"width\";i:300;s:6:\"height\";i:79;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("220","224","_wp_attached_file","2014/02/daiken_small.jpg");
INSERT INTO wp_postmeta VALUES("221","224","_wp_attachment_metadata","a:5:{s:5:\"width\";i:100;s:6:\"height\";i:48;s:4:\"file\";s:24:\"2014/02/daiken_small.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("222","225","_wp_attached_file","2014/02/Comfort-Solutions_72.bmp");
INSERT INTO wp_postmeta VALUES("223","226","_wp_attached_file","2014/02/login-logo.png");
INSERT INTO wp_postmeta VALUES("224","226","_wp_attachment_metadata","a:5:{s:5:\"width\";i:239;s:6:\"height\";i:63;s:4:\"file\";s:22:\"2014/02/login-logo.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"login-logo-150x63.png\";s:5:\"width\";i:150;s:6:\"height\";i:63;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("225","226","_edit_lock","1392796059:1");
INSERT INTO wp_postmeta VALUES("226","42","_edit_lock","1393036223:1");
INSERT INTO wp_postmeta VALUES("231","3","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("232","4","_theme_header_image","");



DROP TABLE wp_posts;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=228 DEFAULT CHARSET=utf8;

INSERT INTO wp_posts VALUES("2","1","2014-01-31 05:17:14","2014-01-31 05:17:14","This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my blog. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://comfortsolutions.com.au/airconditioning/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!","Sample Page","","publish","open","open","","sample-page","","","2014-01-31 05:17:14","2014-01-31 05:17:14","","0","http://comfortsolutions.com.au/airconditioning/?page_id=2","0","page","","0");
INSERT INTO wp_posts VALUES("5","1","2014-01-31 05:20:41","2014-01-31 05:20:41","","contactus-large","","inherit","open","open","","contactus-large","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus-large.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("145","1","2014-02-17 06:48:16","2014-02-17 06:48:16","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\n<p>Providing a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\n<p>Split system or ducted air conditioners professionally installed by qualified technicians. We will also install your pre purchased unit if required.</p>\n<p>Ventilation solutions provided for any situation including bathrooms, parking garages and more.</p>\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p><a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","Airconditioning and Electrical Sunshine Coast","","inherit","open","open","","142-autosave-v1","","","2014-02-17 06:48:16","2014-02-17 06:48:16","","142","http://comfortsolutions.com.au/airconditioning/142-autosave-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("7","1","2014-01-31 05:20:41","2014-01-31 05:20:41","","contactus2_sml","","inherit","open","open","","contactus2_sml","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png","0","attachment","image/png","0");
INSERT INTO wp_posts VALUES("143","1","2014-02-17 06:35:19","2014-02-17 06:35:19","","blog1","","inherit","open","open","","blog1","","","2014-02-17 06:35:19","2014-02-17 06:35:19","","142","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("144","1","2014-02-17 06:42:22","2014-02-17 06:42:22","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\r\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\r\n<p>We provide a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\r\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\r\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p>","Airconditioning and Electrical Sunshine Coast","","inherit","open","open","","142-revision-v1","","","2014-02-17 06:42:22","2014-02-17 06:42:22","","142","http://comfortsolutions.com.au/airconditioning/142-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("11","1","2014-01-31 05:20:41","2014-01-31 05:20:41","","contactus","","inherit","open","open","","contactus","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("12","1","2014-01-31 05:20:36","2014-01-31 05:20:36","<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://comfortsolutions.com.au/airconditioning/services/\"><img class=\"#\" style=\"margin: 0px;\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://comfortsolutions.com.au/airconditioning/services/\"><img class=\"#\" style=\"margin: 0px;\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\" style=\"margin-bottom: 10px;\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%; padding-bottom: 8px;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\" style=\"padding-bottom: 5px;\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","publish","closed","open","","home","","","2014-02-17 09:06:06","2014-02-17 09:06:06","","0","http://comfortsolutions.com.au/airconditioning/?page_id=12","1","page","","0");
INSERT INTO wp_posts VALUES("105","1","2014-02-17 03:22:44","2014-02-17 03:22:44","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:22:44","2014-02-17 03:22:44","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("104","1","2014-02-17 03:22:24","2014-02-17 03:22:24","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:22:24","2014-02-17 03:22:24","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("102","1","2014-02-17 03:18:06","2014-02-17 03:18:06","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:18:06","2014-02-17 03:18:06","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("46","1","2014-02-03 04:09:17","2014-02-03 04:09:17","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Nunc a sollicitudin est. Curabitur ullamcorper gravida felis, sit amet scelerisque lorem iaculis sed. Donec vel neque in neque porta venenatis.  <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Nunc a sollicitudin est. Curabitur ullamcorper gravida felis, sit amet scelerisque lorem iaculis sed. Donec vel neque in neque porta venenatis.  <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 04:09:17","2014-02-03 04:09:17","","12","http://comfortsolutions.com.au/airconditioning/?p=46","0","revision","","0");
INSERT INTO wp_posts VALUES("13","1","2014-01-31 05:20:37","2014-01-31 05:20:37","<p><img class=\"alignleft size-full wp-image-211\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about2.jpg\" width=\"220\" height=\"674\" /></p>\r\n<p><span style=\"font-weight: bold;\">Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned. It is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service. </p>\r\n<p><strong>Licenced operator</strong></p>\r\n<ul>\r\n<li>Arctic lic #  AU29333</li>\r\n<li>BSA # 1191385</li>\r\n<li>Elec cont # 74839</li>\r\n</ul>\r\n<h2>Customer Satisfaction</h2>\r\n<p>Our commitment to customer satisfaction is paramount and we offer service that is second to none.<br /> We specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.</p>\r\n<h2>Professional Service</h2>\r\n<p>Our professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.</p>\r\n<h2>Electrical Contractor</h2>\r\n<p>We are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.</p>\r\n<h2>Domestic and Commercial Airconditioning and Electrical</h2>\r\n<p>We provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p>\r\n<p>Please contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","About Us","","publish","closed","open","","about-us","","","2014-02-17 08:41:46","2014-02-17 08:41:46","","0","http://comfortsolutions.com.au/airconditioning/?page_id=13","2","page","","0");
INSERT INTO wp_posts VALUES("14","1","2014-01-31 05:20:38","2014-01-31 05:20:38","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/sidebar.jpg\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and Ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p>We supply and install the following major brands: <strong>Daikin - Fujitsu - Mitsubishi - Samsung - Toshiba</strong></p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n<li>Air handling/fancoil systems.</li>\r\n<li>General ventilation fans</li>\r\n<li>Roof mounted exhaust fans</li>\r\n<li>Toilet exhaust fans</li>\r\n<li>Roof ventilators</li>\r\n<li>Car park exhaust fans</li>\r\n<li>Supply air fans.</li>\r\n<li>Smoke split and exhaust systems</li>\r\n<li>Warehouse exhaust fans</li>\r\n<li>Multi splits systems</li>\r\n<li>Ducted systems</li>\r\n<li>Split systems</li>\r\n<li>Computer room air conditioning systems</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check fan and air handler operation</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation</li>\r\n<li> Check operation and condition of the compressor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","publish","closed","open","","services","","","2014-02-18 06:24:29","2014-02-18 06:24:29","","0","http://comfortsolutions.com.au/airconditioning/?page_id=14","3","page","","0");
INSERT INTO wp_posts VALUES("15","1","2014-01-31 05:20:39","2014-01-31 05:20:39","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n<p><img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n<p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p>\r\n<p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Mob: 0410 205 271</span></p>\r\n<p>Email: info@comfortsolutions.com.au</p>\r\n<p><img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\"><br /> </span></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n<p>[contact-form-7 id=\"54\" title=\"Contact form 1\"]</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>","Contact Us","","publish","closed","open","","contact-us","","","2014-02-17 06:57:26","2014-02-17 06:57:26","","0","http://comfortsolutions.com.au/airconditioning/?page_id=15","4","page","","0");
INSERT INTO wp_posts VALUES("149","1","2014-02-17 06:56:23","2014-02-17 06:56:23","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n<p><img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n<p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p>\r\n<p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p>\r\n<p>Tel: (07) 5499 6299</p>\r\n<p><span style=\"font-weight: bold;\">Mob: 0410 205 271</span></p>\r\n<p>&nbsp;</p>\r\n<p>Email: info@comfortsolutions.com.au</p>\r\n<p><img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\"><br /> </span></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n<p>[contact-form-7 id=\"54\" title=\"Contact form 1\"]</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-17 06:56:23","2014-02-17 06:56:23","","15","http://comfortsolutions.com.au/airconditioning/15-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("55","1","2014-02-03 06:05:01","2014-02-03 06:05:01","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 25%;\">\r\n\r\n<span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:05:01","2014-02-03 06:05:01","","15","http://comfortsolutions.com.au/airconditioning/?p=55","0","revision","","0");
INSERT INTO wp_posts VALUES("16","1","2014-01-31 05:20:40","2014-01-31 05:20:40","<article class=\"edg-post edg-article\">\n                                <h2 class=\"edg-postheader\"><a href=\"#\">Conse ctetur</a>\n                                </h2>\n                                                <div class=\"edg-postheadericons edg-metadata-icons\">\n                    <span class=\"edg-postdateicon\"></span>\n                     | <span class=\"edg-postauthoricon\"> <a href=\"#\" title=\"Posts by Admin\">Admin</a></span>\n                     | <span class=\"edg-postediticon\"></span>\n                                    </div>\n                <div class=\"edg-postcontent edg-postcontent-0 clearfix\" >\n<div class=\"edg-content-layout\">\n<div class=\"edg-content-layout-row\">\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 100%\">\n<div class=\"image-caption-wrapper\" style=\"width: 55%; float: left\"><img alt=\"an image\" style=\"width: 100%; max-width:360px\" class=\"edg-lightbox\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/shutterstock_32050237.png\"></div>\n<p>Lorem <sup>superscript</sup> dolor <sub>subscript</sub>&nbsp;amet, consectetuer adipiscing elit, <a href=\"#\" title=\"test link\">test link</a>. Nullam dignissim convallis est. Quisque aliquam. <cite>cite</cite>. Nunc iaculis suscipit dui. Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.</p>\n<p>Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus. Maecenas ornare tortor. Donec sed tellus eget sapien fringilla nonummy. <abbr title=\"National Basketball Association\">NBA</abbr> Mauris a ante.</p></div></div></div><br /><a href=\"#\">Read more...</a>\n                </div>\n\n</article>\n<article class=\"edg-post edg-article\">\n                                <h2 class=\"edg-postheader\"><a href=\"#\">Lorem ipsum</a>\n                                </h2>\n                                                <div class=\"edg-postheadericons edg-metadata-icons\">\n                    <span class=\"edg-postdateicon\"></span>\n                     | <span class=\"edg-postauthoricon\"> <a href=\"#\" title=\"Posts by Admin\">Admin</a></span>\n                     | <span class=\"edg-postediticon\"></span>\n                                    </div>\n                <div class=\"edg-postcontent edg-postcontent-1 clearfix\" >\n<div class=\"edg-content-layout\">\n<div class=\"edg-content-layout-row\">\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 100%\">\n<div class=\"image-caption-wrapper\" style=\"width: 55%; float: left\"><img alt=\"an-image\" style=\"width: 100%; max-width:360px\" class=\"edg-lightbox\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/shutterstock_62287657-01-3.jpg\"></div>\n<h1>Heading 1</h1>\n<h2>Heading 2</h2>\n<h3>Heading 3</h3>\n<h4>Heading 4</h4>\n<h5>Heading 5</h5>\n<h6>Heading 6</h6>\n<p>Lorem dolor&nbsp;amet, consectetuer adipiscing elit. Nullam dignissim convallis est. Quisque aliquam. <cite>cite</cite>. Nunc iaculis suscipit dui. Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.</p>\n \n<blockquote>\n This stylesheet is going to help so freaking much.</blockquote></div></div></div><br /><a href=\"#\">Read more...</a>\n                </div>\n\n</article>\n","Blog Page","","publish","closed","open","","blog","","","2014-01-31 05:20:40","2014-01-31 05:20:40","","0","http://comfortsolutions.com.au/airconditioning/?page_id=16","5","page","","0");
INSERT INTO wp_posts VALUES("17","1","2014-01-31 05:20:41","2014-01-31 05:20:41"," ","","","publish","open","open","","17","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/?p=17","0","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("18","1","2014-01-31 05:20:41","2014-01-31 05:20:41"," ","","","publish","open","open","","18","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/?p=18","2","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("19","1","2014-01-31 05:20:41","2014-01-31 05:20:41"," ","","","publish","open","open","","19","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/?p=19","3","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("20","1","2014-01-31 05:20:41","2014-01-31 05:20:41"," ","","","publish","open","open","","20","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/?p=20","4","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("21","1","2014-01-31 05:20:41","2014-01-31 05:20:41","","Blog","","publish","open","open","","blog","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/?p=21","5","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("22","1","2014-01-31 05:20:42","2014-01-31 05:20:42"," ","","","publish","open","open","","22","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","0","http://comfortsolutions.com.au/airconditioning/?p=22","0","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("23","1","2014-01-31 05:20:42","2014-01-31 05:20:42"," ","","","publish","open","open","","23","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","0","http://comfortsolutions.com.au/airconditioning/?p=23","2","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("24","1","2014-01-31 05:20:42","2014-01-31 05:20:42"," ","","","publish","open","open","","24","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","0","http://comfortsolutions.com.au/airconditioning/?p=24","3","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("25","1","2014-01-31 05:20:42","2014-01-31 05:20:42"," ","","","publish","open","open","","25","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","0","http://comfortsolutions.com.au/airconditioning/?p=25","4","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("26","1","2014-01-31 05:20:42","2014-01-31 05:20:42","","Blog","","publish","open","open","","blog-2","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","0","http://comfortsolutions.com.au/airconditioning/?p=26","5","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("29","1","2014-01-31 05:20:42","2014-01-31 05:20:42","<span style=\"font-weight: bold;\">Comfort Solutions</span>&nbsp;is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned, it is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.<h2>Customer Satisfaction</h2><p>Our commitment to customer satisfaction is paramount and we offer service that is second to none.<br>We specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.</p><h3>Professional Service</h3><p>Our professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.</p><h4>Electrical Contractor</h4><p>We are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.<br>\n</p><h5>Domestic and Commercial Airconditioning and Electrical</h5><p>We provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p><p>Please contact us today to discuss your air conditioning or electrical requirements&nbsp;<a href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\" title=\"Contact us\" class=\"edg-button\">Contact Us</a>&nbsp;</p>","About Us","","inherit","open","open","","13-revision-v1","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","13","http://comfortsolutions.com.au/airconditioning/?p=29","0","revision","","0");
INSERT INTO wp_posts VALUES("30","1","2014-01-31 05:20:42","2014-01-31 05:20:42","<h1>Airconditioning and Electrical</h1><p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p><h2>AIRCONDITIONING</h2><p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p><h3>ELECTRICAL</h3><p style=\"text-align: left;\">Switchboard upgrades, new wiring, rewiring, commercial, electricalsurge protection, new power points,electrical safety inspections, smoke detectors, indoor lighting solutions, outdoor and landscaping lighting, and appliance installations</p><p style=\"text-align: left;\">Please contact us today for more infromation&nbsp;<a href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\" title=\"Contact us\" class=\"edg-button\">Contact Us</a>&nbsp;</p>","Services","","inherit","open","open","","14-revision-v1","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","14","http://comfortsolutions.com.au/airconditioning/?p=30","0","revision","","0");
INSERT INTO wp_posts VALUES("32","1","2014-02-03 02:37:41","2014-02-03 02:37:41","","about","","inherit","open","open","","about","","","2014-02-03 02:37:41","2014-02-03 02:37:41","","13","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("33","1","2014-02-03 02:38:06","2014-02-03 02:38:06","<span style=\"font-weight: bold;\"><img class=\"alignleft size-full wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"220\" height=\"530\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned, it is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.\r\n<h2>Customer Satisfaction</h2>\r\nOur commitment to customer satisfaction is paramount and we offer service that is second to none.\r\nWe specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.\r\n<h3>Professional Service</h3>\r\nOur professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.\r\n<h4>Electrical Contractor</h4>\r\nWe are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.\r\n<h5>Domestic and Commercial Airconditioning and Electrical</h5>\r\nWe provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.\r\n\r\nPlease contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 02:38:06","2014-02-03 02:38:06","","13","http://comfortsolutions.com.au/airconditioning/?p=33","0","revision","","0");
INSERT INTO wp_posts VALUES("34","1","2014-02-03 02:39:05","2014-02-03 02:39:05","<span style=\"font-weight: bold;\"><img class=\"alignleft  wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"176\" height=\"424\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned, it is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.\r\n<h2>Customer Satisfaction</h2>\r\nOur commitment to customer satisfaction is paramount and we offer service that is second to none.\r\nWe specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.\r\n<h3>Professional Service</h3>\r\nOur professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.\r\n<h4>Electrical Contractor</h4>\r\nWe are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.\r\n<h5>Domestic and Commercial Airconditioning and Electrical</h5>\r\nWe provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.\r\n\r\nPlease contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 02:39:05","2014-02-03 02:39:05","","13","http://comfortsolutions.com.au/airconditioning/?p=34","0","revision","","0");
INSERT INTO wp_posts VALUES("35","1","2014-02-03 02:40:39","2014-02-03 02:40:39","<span style=\"font-weight: bold;\"><img class=\"alignleft  wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"176\" height=\"424\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned, it is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.\r\n<h2>Customer Satisfaction</h2>\r\nOur commitment to customer satisfaction is paramount and we offer service that is second to none.\r\nWe specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.\r\n<h3>Professional Service</h3>\r\nOur professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.\r\n<h4>Electrical Contractor</h4>\r\nWe are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.\r\n<h5>Domestic and Commercial Airconditioning and Electrical</h5>\r\nWe provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p>\r\n\r\nPlease contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 02:40:39","2014-02-03 02:40:39","","13","http://comfortsolutions.com.au/airconditioning/?p=35","0","revision","","0");
INSERT INTO wp_posts VALUES("42","1","2014-02-03 03:09:39","2014-02-03 03:09:39","","service","","inherit","open","open","","service","","","2014-02-03 03:09:39","2014-02-03 03:09:39","","14","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("37","1","2014-02-03 02:51:46","2014-02-03 02:51:46","<h1><img class=\"alignleft size-full wp-image-36\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"480\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Switchboard upgrades, new wiring, rewiring, commercial, electricalsurge protection, new power points,electrical safety inspections, smoke detectors, indoor lighting solutions, outdoor and landscaping lighting, and appliance installations</p>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 02:51:46","2014-02-03 02:51:46","","14","http://comfortsolutions.com.au/airconditioning/?p=37","0","revision","","0");
INSERT INTO wp_posts VALUES("39","1","2014-02-03 02:56:38","2014-02-03 02:56:38","<h1><img class=\"alignleft size-full wp-image-36\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"480\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<p style=\"text-align: left;\">switchboard upgrades, new wiring, rewiring, commercial, electricalsurge protection, new power points,electrical safety inspections, smoke detectors, indoor lighting solutions, outdoor/landscaping lighting, and appliance installations.</p>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 02:56:38","2014-02-03 02:56:38","","14","http://comfortsolutions.com.au/airconditioning/?p=39","0","revision","","0");
INSERT INTO wp_posts VALUES("40","1","2014-02-03 02:59:17","2014-02-03 02:59:17","<h1><img class=\"alignleft size-full wp-image-36\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"480\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n\r\n<ul>\r\n	<li>switchboard upgrades,</li>\r\n	<li>new wiring,</li>\r\n	<li>rewiring,</li>\r\n	<li>commercial,</li>\r\n	<li>electricalsurge protection,</li>\r\n	<li>new power points</li>\r\n	<li>,electrical safety inspections,</li>\r\n	<li>smoke detectors,</li>\r\n	<li>indoor lighting solutions,</li>\r\n	<li>outdoor/landscaping lighting,</li>\r\n	<li>and appliance installations.</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 02:59:17","2014-02-03 02:59:17","","14","http://comfortsolutions.com.au/airconditioning/?p=40","0","revision","","0");
INSERT INTO wp_posts VALUES("41","1","2014-02-03 03:03:56","2014-02-03 03:03:56","<h1><img class=\"alignleft size-full wp-image-36\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"480\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n\r\n<ul>\r\n	<li>Switchboard upgrades,</li>\r\n	<li>New wiring,</li>\r\n	<li>Rewiring,</li>\r\n	<li>Commercial,</li>\r\n	<li>Electricalsurge protection,</li>\r\n	<li>New power points</li>\r\n	<li>Electrical safety inspections,</li>\r\n	<li>Smoke detectors,</li>\r\n	<li>Indoor lighting solutions,</li>\r\n	<li>Outdoor/landscaping lighting,</li>\r\n	<li>Appliance installations.</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 03:03:56","2014-02-03 03:03:56","","14","http://comfortsolutions.com.au/airconditioning/?p=41","0","revision","","0");
INSERT INTO wp_posts VALUES("43","1","2014-02-03 03:09:48","2014-02-03 03:09:48","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n\r\n<ul>\r\n	<li>Switchboard upgrades,</li>\r\n	<li>New wiring,</li>\r\n	<li>Rewiring,</li>\r\n	<li>Commercial,</li>\r\n	<li>Electricalsurge protection,</li>\r\n	<li>New power points</li>\r\n	<li>Electrical safety inspections,</li>\r\n	<li>Smoke detectors,</li>\r\n	<li>Indoor lighting solutions,</li>\r\n	<li>Outdoor/landscaping lighting,</li>\r\n	<li>Appliance installations.</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 03:09:48","2014-02-03 03:09:48","","14","http://comfortsolutions.com.au/airconditioning/?p=43","0","revision","","0");
INSERT INTO wp_posts VALUES("44","1","2014-02-03 03:10:50","2014-02-03 03:10:50","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n\r\n<ul>\r\n	<li>Switchboard upgrades</li>\r\n	<li>New wiring</li>\r\n	<li>Rewiring</li>\r\n	<li>Commercial</li>\r\n	<li>Electrical surge protection</li>\r\n	<li>New power points</li>\r\n	<li>Electrical safety inspections</li>\r\n	<li>Smoke detectors</li>\r\n	<li>Indoor lighting solutions</li>\r\n	<li>Outdoor/landscaping lighting</li>\r\n	<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 03:10:50","2014-02-03 03:10:50","","14","http://comfortsolutions.com.au/airconditioning/?p=44","0","revision","","0");
INSERT INTO wp_posts VALUES("47","1","2014-02-03 04:59:23","2014-02-03 04:59:23","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners prompt professional service guranteed.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Nunc a sollicitudin est. Curabitur ullamcorper gravida felis, sit amet scelerisque lorem iaculis sed. Donec vel neque in neque porta venenatis.  <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 04:59:23","2014-02-03 04:59:23","","12","http://comfortsolutions.com.au/airconditioning/?p=47","0","revision","","0");
INSERT INTO wp_posts VALUES("48","1","2014-02-03 05:09:52","2014-02-03 05:09:52","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners prompt professional service guranteed.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 05:09:52","2014-02-03 05:09:52","","12","http://comfortsolutions.com.au/airconditioning/?p=48","0","revision","","0");
INSERT INTO wp_posts VALUES("49","1","2014-02-03 05:10:44","2014-02-03 05:10:44","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We offer a prompt professional service, guranteed.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 05:10:44","2014-02-03 05:10:44","","12","http://comfortsolutions.com.au/airconditioning/?p=49","0","revision","","0");
INSERT INTO wp_posts VALUES("52","1","2014-02-03 06:02:34","2014-02-03 06:02:34","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 06:02:34","2014-02-03 06:02:34","","12","http://comfortsolutions.com.au/airconditioning/?p=52","0","revision","","0");
INSERT INTO wp_posts VALUES("50","1","2014-02-03 05:56:16","2014-02-03 05:56:16","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 05:56:16","2014-02-03 05:56:16","","12","http://comfortsolutions.com.au/airconditioning/?p=50","0","revision","","0");
INSERT INTO wp_posts VALUES("51","1","2014-02-03 06:02:01","2014-02-03 06:02:01","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 06:02:01","2014-02-03 06:02:01","","12","http://comfortsolutions.com.au/airconditioning/?p=51","0","revision","","0");
INSERT INTO wp_posts VALUES("53","1","2014-02-03 06:03:08","2014-02-03 06:03:08","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n<img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n<img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 06:03:08","2014-02-03 06:03:08","","12","http://comfortsolutions.com.au/airconditioning/?p=53","0","revision","","0");
INSERT INTO wp_posts VALUES("54","1","2014-02-03 06:04:16","2014-02-03 06:04:16","<p>Your Name (required)<br />\r\n    [text* your-name] </p>\r\n\r\n<p>Your Email (required)<br />\r\n    [email* your-email] </p>\r\n\r\n<p>Subject<br />\r\n    [text your-subject] </p>\r\n\r\n<p>Your Message<br />\r\n    [textarea your-message] </p>\r\n\r\n<p>[submit \"Send\"]</p>\n[your-subject]\n[your-name] <[your-email]>\nFrom: [your-name] <[your-email]>\r\nSubject: [your-subject]\r\n\r\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on Sunshine Coast Airconditioning &amp; Electrical (http://comfortsolutions.com.au/airconditioning)\ninfo@comfortsolutions.com.au\n\n\n\n\n[your-subject]\n[your-name] <[your-email]>\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on Sunshine Coast Airconditioning &amp; Electrical (http://comfortsolutions.com.au/airconditioning)\n[your-email]\n\n\n\nYour message was sent successfully. Thanks.\nFailed to send your message. Please try later or contact the administrator by another method.\nValidation errors occurred. Please confirm the fields and submit it again.\nFailed to send your message. Please try later or contact the administrator by another method.\nPlease accept the terms to proceed.\nPlease fill the required field.\nYour entered code is incorrect.\nNumber format seems invalid.\nThis number is too small.\nThis number is too large.\nEmail address seems invalid.\nURL seems invalid.\nTelephone number seems invalid.\nYour answer is not correct.\nDate format seems invalid.\nThis date is too early.\nThis date is too late.\nFailed to upload file.\nThis file type is not allowed.\nThis file is too large.\nFailed to upload file. Error occurred.","Contact form 1","","publish","open","open","","contact-form-1","","","2014-02-19 03:36:37","2014-02-19 03:36:37","","0","http://comfortsolutions.com.au/airconditioning/?post_type=wpcf7_contact_form&#038;p=54","0","wpcf7_contact_form","","0");
INSERT INTO wp_posts VALUES("56","1","2014-02-17 06:55:47","2014-02-17 06:55:47","<div class=\"edg-content-layout\">\n<div class=\"edg-content-layout-row\">\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\n<p><img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /></p>\n</div>\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\n<p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p>\n<p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p>\n<p>Tel: (07) 5499 6299</p>\n<p><span style=\"font-weight: bold;\">Mob: 0418 155 313</span></p>\n<p>&nbsp;</p>\n<p>Email: info@comfortsolutions.com.au</p>\n<p><img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\"><br /> </span></p>\n</div>\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\n<p>[contact-form-7 id=\"54\" title=\"Contact form 1\"]</p>\n</div>\n</div>\n</div>\n<div class=\"edg-content-layout\">\n<div class=\"edg-content-layout-row\">\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\n<p>&nbsp;</p>\n</div>\n</div>\n</div>","Contact Us","","inherit","open","open","","15-autosave-v1","","","2014-02-17 06:55:47","2014-02-17 06:55:47","","15","http://comfortsolutions.com.au/airconditioning/?p=56","0","revision","","0");
INSERT INTO wp_posts VALUES("57","1","2014-02-03 06:06:09","2014-02-03 06:06:09","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 35%;\">\r\n\r\n<span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:06:09","2014-02-03 06:06:09","","15","http://comfortsolutions.com.au/airconditioning/?p=57","0","revision","","0");
INSERT INTO wp_posts VALUES("58","1","2014-02-03 06:07:06","2014-02-03 06:07:06","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 35%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:07:06","2014-02-03 06:07:06","","15","http://comfortsolutions.com.au/airconditioning/?p=58","0","revision","","0");
INSERT INTO wp_posts VALUES("59","1","2014-02-03 06:07:46","2014-02-03 06:07:46","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 45%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:07:46","2014-02-03 06:07:46","","15","http://comfortsolutions.com.au/airconditioning/?p=59","0","revision","","0");
INSERT INTO wp_posts VALUES("60","1","2014-02-03 06:08:01","2014-02-03 06:08:01","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 25%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:08:01","2014-02-03 06:08:01","","15","http://comfortsolutions.com.au/airconditioning/?p=60","0","revision","","0");
INSERT INTO wp_posts VALUES("70","1","2014-02-03 06:15:59","2014-02-03 06:15:59","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:15:59","2014-02-03 06:15:59","","15","http://comfortsolutions.com.au/airconditioning/?p=70","0","revision","","0");
INSERT INTO wp_posts VALUES("61","1","2014-02-03 06:09:03","2014-02-03 06:09:03","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 25%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:09:03","2014-02-03 06:09:03","","15","http://comfortsolutions.com.au/airconditioning/?p=61","0","revision","","0");
INSERT INTO wp_posts VALUES("62","1","2014-02-03 06:09:31","2014-02-03 06:09:31","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:09:31","2014-02-03 06:09:31","","15","http://comfortsolutions.com.au/airconditioning/?p=62","0","revision","","0");
INSERT INTO wp_posts VALUES("63","1","2014-02-03 06:10:31","2014-02-03 06:10:31","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; margin-left: 15px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:10:31","2014-02-03 06:10:31","","15","http://comfortsolutions.com.au/airconditioning/?p=63","0","revision","","0");
INSERT INTO wp_posts VALUES("64","1","2014-02-03 06:10:54","2014-02-03 06:10:54","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 15px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:10:54","2014-02-03 06:10:54","","15","http://comfortsolutions.com.au/airconditioning/?p=64","0","revision","","0");
INSERT INTO wp_posts VALUES("65","1","2014-02-03 06:11:35","2014-02-03 06:11:35","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:11:35","2014-02-03 06:11:35","","15","http://comfortsolutions.com.au/airconditioning/?p=65","0","revision","","0");
INSERT INTO wp_posts VALUES("69","1","2014-02-03 06:15:12","2014-02-03 06:15:12","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:15:12","2014-02-03 06:15:12","","15","http://comfortsolutions.com.au/airconditioning/?p=69","0","revision","","0");
INSERT INTO wp_posts VALUES("66","1","2014-02-03 06:12:22","2014-02-03 06:12:22","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; margin-top: 5px;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:12:22","2014-02-03 06:12:22","","15","http://comfortsolutions.com.au/airconditioning/?p=66","0","revision","","0");
INSERT INTO wp_posts VALUES("67","1","2014-02-03 06:13:06","2014-02-03 06:13:06","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%; margin-top: 5px;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:13:06","2014-02-03 06:13:06","","15","http://comfortsolutions.com.au/airconditioning/?p=67","0","revision","","0");
INSERT INTO wp_posts VALUES("68","1","2014-02-03 06:13:47","2014-02-03 06:13:47","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%; margin-top: 25px;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:13:47","2014-02-03 06:13:47","","15","http://comfortsolutions.com.au/airconditioning/?p=68","0","revision","","0");
INSERT INTO wp_posts VALUES("71","1","2014-02-03 06:16:41","2014-02-03 06:16:41","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; margin-right: 20px;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:16:41","2014-02-03 06:16:41","","15","http://comfortsolutions.com.au/airconditioning/?p=71","0","revision","","0");
INSERT INTO wp_posts VALUES("76","1","2014-02-03 06:26:15","2014-02-03 06:26:15","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob: 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:26:15","2014-02-03 06:26:15","","15","http://comfortsolutions.com.au/airconditioning/?p=76","0","revision","","0");
INSERT INTO wp_posts VALUES("72","1","2014-02-03 06:17:04","2014-02-03 06:17:04","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 20px;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:17:04","2014-02-03 06:17:04","","15","http://comfortsolutions.com.au/airconditioning/?p=72","0","revision","","0");
INSERT INTO wp_posts VALUES("73","1","2014-02-03 06:17:23","2014-02-03 06:17:23","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:17:23","2014-02-03 06:17:23","","15","http://comfortsolutions.com.au/airconditioning/?p=73","0","revision","","0");
INSERT INTO wp_posts VALUES("74","1","2014-02-03 06:19:00","2014-02-03 06:19:00","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n<img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n<img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring, switchboards and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 06:19:00","2014-02-03 06:19:00","","12","http://comfortsolutions.com.au/airconditioning/?p=74","0","revision","","0");
INSERT INTO wp_posts VALUES("75","1","2014-02-03 06:20:36","2014-02-03 06:20:36","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n<img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n<img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring, switchboards and more.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 06:20:36","2014-02-03 06:20:36","","12","http://comfortsolutions.com.au/airconditioning/?p=75","0","revision","","0");
INSERT INTO wp_posts VALUES("77","1","2014-02-03 06:34:06","2014-02-03 06:34:06","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p> </span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Tel: (07) 5499 6299</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:34:06","2014-02-03 06:34:06","","15","http://comfortsolutions.com.au/airconditioning/?p=77","0","revision","","0");
INSERT INTO wp_posts VALUES("78","1","2014-02-03 06:35:02","2014-02-03 06:35:02","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p> </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:35:02","2014-02-03 06:35:02","","15","http://comfortsolutions.com.au/airconditioning/?p=78","0","revision","","0");
INSERT INTO wp_posts VALUES("79","1","2014-02-03 06:35:45","2014-02-03 06:35:45","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p> </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:35:45","2014-02-03 06:35:45","","15","http://comfortsolutions.com.au/airconditioning/?p=79","0","revision","","0");
INSERT INTO wp_posts VALUES("80","1","2014-02-03 06:36:16","2014-02-03 06:36:16","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p> </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:36:16","2014-02-03 06:36:16","","15","http://comfortsolutions.com.au/airconditioning/?p=80","0","revision","","0");
INSERT INTO wp_posts VALUES("81","1","2014-02-03 06:37:16","2014-02-03 06:37:16","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p> </span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Tel: (07) 5499 6299</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:37:16","2014-02-03 06:37:16","","15","http://comfortsolutions.com.au/airconditioning/?p=81","0","revision","","0");
INSERT INTO wp_posts VALUES("82","1","2014-02-03 06:37:41","2014-02-03 06:37:41","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Tel: (07) 5499 6299</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:37:41","2014-02-03 06:37:41","","15","http://comfortsolutions.com.au/airconditioning/?p=82","0","revision","","0");
INSERT INTO wp_posts VALUES("83","1","2014-02-03 07:09:26","2014-02-03 07:09:26","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n<img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n<img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" /></p>\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a<br />\r\nprofessional, cost effective solution for all your airconditioning requirements.   <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring, switchboards and more.   <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\"><p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p></blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:09:26","2014-02-03 07:09:26","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("84","1","2014-02-03 07:11:37","2014-02-03 07:11:37","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:11:37","2014-02-03 07:11:37","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("85","1","2014-02-03 07:12:24","2014-02-03 07:12:24","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:12:24","2014-02-03 07:12:24","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("86","1","2014-02-03 07:13:08","2014-02-03 07:13:08","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region, domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:13:08","2014-02-03 07:13:08","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("87","1","2014-02-03 07:14:00","2014-02-03 07:14:00","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:14:00","2014-02-03 07:14:00","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("100","1","2014-02-17 03:17:26","2014-02-17 03:17:26","","domstic","","inherit","open","open","","domstic","","","2014-02-17 03:17:26","2014-02-17 03:17:26","","12","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("88","1","2014-02-03 07:18:25","2014-02-03 07:18:25","<p><span style=\"font-weight: bold;\"><img class=\"alignleft  wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"176\" height=\"424\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned, it is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.</p>\r\n<h2>Customer Satisfaction</h2>\r\n<p>Our commitment to customer satisfaction is paramount and we offer service that is second to none.<br />\r\nWe specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.</p>\r\n<h2>Professional Service</h2>\r\n<p>Our professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.</p>\r\n<h2>Electrical Contractor</h2>\r\n<p>We are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.</p>\r\n<h2>Domestic and Commercial Airconditioning and Electrical</h2>\r\n<p>We provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p>\r\n<p>Please contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>\r\n","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 07:18:25","2014-02-03 07:18:25","","13","http://comfortsolutions.com.au/airconditioning/13-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("89","1","2014-02-03 07:18:54","2014-02-03 07:18:54","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<h2>ELECTRICAL</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>\r\n","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 07:18:54","2014-02-03 07:18:54","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("90","1","2014-02-03 07:20:00","2014-02-03 07:20:00","<p><span style=\"font-weight: bold;\"><img class=\"alignleft  wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"176\" height=\"424\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned. It is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.</p>\r\n<h2>Customer Satisfaction</h2>\r\n<p>Our commitment to customer satisfaction is paramount and we offer service that is second to none.<br /> We specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.</p>\r\n<h2>Professional Service</h2>\r\n<p>Our professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.</p>\r\n<h2>Electrical Contractor</h2>\r\n<p>We are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.</p>\r\n<h2>Domestic and Commercial Airconditioning and Electrical</h2>\r\n<p>We provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p>\r\n<p>Please contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 07:20:00","2014-02-03 07:20:00","","13","http://comfortsolutions.com.au/airconditioning/13-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("93","1","2014-02-03 07:26:58","2014-02-03 07:26:58","<p><span style=\"font-weight: bold;\"><img class=\"alignleft  wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"198\" height=\"477\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned. It is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.</p>\r\n<h2>Customer Satisfaction</h2>\r\n<p>Our commitment to customer satisfaction is paramount and we offer service that is second to none.<br /> We specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.</p>\r\n<h2>Professional Service</h2>\r\n<p>Our professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.</p>\r\n<h2>Electrical Contractor</h2>\r\n<p>We are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.</p>\r\n<h2>Domestic and Commercial Airconditioning and Electrical</h2>\r\n<p>We provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p>\r\n<p>Please contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 07:26:58","2014-02-03 07:26:58","","13","http://comfortsolutions.com.au/airconditioning/13-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("91","1","2014-02-03 07:22:24","2014-02-03 07:22:24","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 07:22:24","2014-02-03 07:22:24","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("92","1","2014-02-03 07:24:59","2014-02-03 07:24:59","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 07:24:59","2014-02-03 07:24:59","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("96","1","2014-02-03 07:30:01","2014-02-03 07:30:01","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding=left: 5px;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:30:01","2014-02-03 07:30:01","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("97","1","2014-02-03 07:31:25","2014-02-03 07:31:25","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" /></p>\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding=left: 5px; !important\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:31:25","2014-02-03 07:31:25","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("98","1","2014-02-03 07:32:27","2014-02-03 07:32:27","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" /></p>\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding=left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:32:27","2014-02-03 07:32:27","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("99","1","2014-02-03 07:33:05","2014-02-03 07:33:05","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" /></p>\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:33:05","2014-02-03 07:33:05","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("103","1","2014-02-17 03:21:25","2014-02-17 03:21:25","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:21:25","2014-02-17 03:21:25","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("106","1","2014-02-17 03:23:14","2014-02-17 03:23:14","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:23:14","2014-02-17 03:23:14","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("107","1","2014-02-17 03:23:25","2014-02-17 03:23:25","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:23:25","2014-02-17 03:23:25","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("108","1","2014-02-17 03:24:11","2014-02-17 03:24:11","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-righ: 10px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:24:11","2014-02-17 03:24:11","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("109","1","2014-02-17 03:24:25","2014-02-17 03:24:25","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-right: 10px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:24:25","2014-02-17 03:24:25","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("158","1","2014-02-17 07:30:09","2014-02-17 07:30:09","<div class=\"edg-content-layout layout-item-0\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:30:09","2014-02-17 07:30:09","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("110","1","2014-02-17 03:25:00","2014-02-17 03:25:00","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: 0px; width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-right: 10px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:25:00","2014-02-17 03:25:00","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("111","1","2014-02-17 03:25:28","2014-02-17 03:25:28","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: 0px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 10px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:25:28","2014-02-17 03:25:28","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("112","1","2014-02-17 03:26:53","2014-02-17 03:26:53","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: 0px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width:45%; margin-right:50px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:26:53","2014-02-17 03:26:53","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("113","1","2014-02-17 03:27:09","2014-02-17 03:27:09","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width:45%; margin-right:50px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:27:09","2014-02-17 03:27:09","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("114","1","2014-02-17 03:27:24","2014-02-17 03:27:24","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width:45%; margin-right:55px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:27:24","2014-02-17 03:27:24","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("115","1","2014-02-17 03:27:36","2014-02-17 03:27:36","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width:45%; margin-right:60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:27:36","2014-02-17 03:27:36","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("127","1","2014-02-17 03:43:13","2014-02-17 03:43:13","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:43:13","2014-02-17 03:43:13","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("116","1","2014-02-17 03:30:09","2014-02-17 03:30:09","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:30:09","2014-02-17 03:30:09","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("117","1","2014-02-17 03:30:55","2014-02-17 03:30:55","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 50%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:30:55","2014-02-17 03:30:55","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("118","1","2014-02-17 03:31:13","2014-02-17 03:31:13","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:31:13","2014-02-17 03:31:13","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("119","1","2014-02-17 03:31:28","2014-02-17 03:31:28","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:31:28","2014-02-17 03:31:28","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("120","1","2014-02-17 03:31:38","2014-02-17 03:31:38","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 48%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:31:38","2014-02-17 03:31:38","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("121","1","2014-02-17 03:31:53","2014-02-17 03:31:53","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 46%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 46%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:31:53","2014-02-17 03:31:53","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("122","1","2014-02-17 03:32:06","2014-02-17 03:32:06","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 48%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 46%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:32:06","2014-02-17 03:32:06","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("123","1","2014-02-17 03:32:16","2014-02-17 03:32:16","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 48%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:32:16","2014-02-17 03:32:16","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("124","1","2014-02-17 03:32:29","2014-02-17 03:32:29","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:32:29","2014-02-17 03:32:29","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("126","1","2014-02-17 03:42:44","2014-02-17 03:42:44","","home_right","","inherit","open","open","","home_right-2","","","2014-02-17 03:42:44","2014-02-17 03:42:44","","12","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("125","1","2014-02-17 03:34:00","2014-02-17 03:34:00","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" border-right: 1px; /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:34:00","2014-02-17 03:34:00","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("129","1","2014-02-17 04:30:52","2014-02-17 04:30:52","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p>&nbsp;</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:30:52","2014-02-17 04:30:52","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("130","1","2014-02-17 04:31:35","2014-02-17 04:31:35","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:31:35","2014-02-17 04:31:35","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("131","1","2014-02-17 04:39:20","2014-02-17 04:39:20","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:39:20","2014-02-17 04:39:20","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("132","1","2014-02-17 04:40:41","2014-02-17 04:40:41","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:40:41","2014-02-17 04:40:41","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("133","1","2014-02-17 04:40:52","2014-02-17 04:40:52","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and Ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:40:52","2014-02-17 04:40:52","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("138","1","2014-02-17 06:28:53","2014-02-17 06:28:53","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/sidebar.jpg\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and Ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n<li>Air handling/fancoil systems.</li>\r\n<li>Fume cupboards</li>\r\n<li>General ventilation fans</li>\r\n<li>Roof mounted exhaust fans</li>\r\n<li>Toilet exhaust fans</li>\r\n<li>Roof ventilators</li>\r\n<li>Car park exhaust fans</li>\r\n<li>Supply air fans.</li>\r\n<li>Smoke split and exhaust systems</li>\r\n<li>Warehouse exhaust fans</li>\r\n<li>Multi splits systems</li>\r\n<li>Ducted systems</li>\r\n<li>Split systems</li>\r\n<li>Computer room air conditioning systems</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 06:28:53","2014-02-17 06:28:53","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("134","1","2014-02-17 04:59:11","2014-02-17 04:59:11","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and Ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n<li>Air handling/fancoil systems.</li>\r\n<li>Fume cupboards</li>\r\n<li>General ventilation fans</li>\r\n<li>Roof mounted exhaust fans</li>\r\n<li>Toilet exhaust fans</li>\r\n<li>Roof ventilators</li>\r\n<li>Car park exhaust fans</li>\r\n<li>Supply air fans.</li>\r\n<li>Smoke split and exhaust systems</li>\r\n<li>Lift motor room ventilation</li>\r\n<li>Warehouse exhaust fans</li>\r\n<li>Multi splits systems</li>\r\n<li>Ducted systems</li>\r\n<li>Split systems</li>\r\n<li>Computer room air conditioning systems</li>\r\n<li>Pressurization system</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:59:11","2014-02-17 04:59:11","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("136","1","2014-02-17 06:23:19","2014-02-17 06:23:19","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/sidebar.jpg\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and Ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n<li>Air handling/fancoil systems.</li>\r\n<li>Fume cupboards</li>\r\n<li>General ventilation fans</li>\r\n<li>Roof mounted exhaust fans</li>\r\n<li>Toilet exhaust fans</li>\r\n<li>Roof ventilators</li>\r\n<li>Car park exhaust fans</li>\r\n<li>Supply air fans.</li>\r\n<li>Smoke split and exhaust systems</li>\r\n<li>Lift motor room ventilation</li>\r\n<li>Warehouse exhaust fans</li>\r\n<li>Multi splits systems</li>\r\n<li>Ducted systems</li>\r\n<li>Split systems</li>\r\n<li>Computer room air conditioning systems</li>\r\n<li>Pressurization system</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 06:23:19","2014-02-17 06:23:19","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("135","1","2014-02-17 06:22:39","2014-02-17 06:22:39","","sidebar","","inherit","open","open","","sidebar","","","2014-02-17 06:22:39","2014-02-17 06:22:39","","0","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/sidebar.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("137","1","2014-02-18 06:25:31","2014-02-18 06:25:31","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/sidebar.jpg\" />Airconditioning and Electrical</h1>\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\n<h2>Airconditioning and Ventilation</h2>\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\n<p>We supply and install the following major brands: <strong>Daikin - Fujitsu - Mitsubishi - Samsung - Toshiba</strong></p>\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\n<ul>\n<li>Hi-Wall split Systems</li>\n<li>Ducted Split Systems</li>\n<li>Commercial Packages Units</li>\n<li>Mechanical Ventilation Systems</li>\n<li>Variable Refrigerant Flow Systems (VRF)</li>\n<li>Variable Air Volume (VAV)</li>\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\n<li>Air handling/fancoil systems.</li>\n<li>General ventilation fans</li>\n<li>Roof mounted exhaust fans</li>\n<li>Toilet exhaust fans</li>\n<li>Roof ventilators</li>\n<li>Car park exhaust fans</li>\n<li>Supply air fans.</li>\n<li>Smoke split and exhaust systems</li>\n<li>Warehouse exhaust fans</li>\n<li>Multi splits systems</li>\n<li>Ducted systems</li>\n<li>Split systems</li>\n<li>Computer room air conditioning systems</li>\n</ul>\n<h2>Service</h2>\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\n<h2>Comprehensive Airconditioning Service</h2>\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\n<p>Please see a guide below:</p>\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\n<ul>\n<ul>\n<li>Inspect refrigerant lines for signs of leakage</li>\n<li>Check and clean standard air filters over</li>\n<li> Check operating temperatures</li>\n<li> Check fan and air handler operation</li>\n<li> Check condensate drain and clean as necessary</li>\n<li> Check operational controls and thermostat</li>\n</ul>\n</ul>\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\n<ul>\n<ul>\n<li> Inspect refrigerant lines for signs of leakage</li>\n<li> Inspect and clean condenser coil as necessary</li>\n<li> Check condenser fan operation</li>\n<li> Check operation and condition of the compressor</li>\n<li> Check system voltage</li>\n<li> Check operating temperatures</li>\n</ul>\n</ul>\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\n<h2>Electrical</h2>\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\n<ul>\n<li>Switchboard upgrades</li>\n<li>New wiring</li>\n<li>Rewiring</li>\n<li>Commercial</li>\n<li>Electrical surge protection</li>\n<li>New power points</li>\n<li>Electrical safety inspections</li>\n<li>Smoke detectors</li>\n<li>Indoor lighting solutions</li>\n<li>Outdoor/landscaping lighting</li>\n<li>Appliance installations</li>\n</ul>\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-autosave-v1","","","2014-02-18 06:25:31","2014-02-18 06:25:31","","14","http://comfortsolutions.com.au/airconditioning/14-autosave-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("142","1","2014-02-17 06:42:22","2014-02-17 06:42:22","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\r\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\r\n<p>Providing a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\r\n<p>Split system or ducted air conditioners professionally installed by qualified technicians. We will also install your pre purchased unit if required.</p>\r\n<p>Ventilation solutions provided for any situation including bathrooms, parking garages and more.</p>\r\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\r\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p><a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","Airconditioning and Electrical Sunshine Coast","","publish","open","open","","airconditioning-and-electrical-sunshine-coast","","","2014-02-17 06:48:18","2014-02-17 06:48:18","","0","http://comfortsolutions.com.au/airconditioning/?p=142","0","post","","0");
INSERT INTO wp_posts VALUES("146","1","2014-02-17 06:45:26","2014-02-17 06:45:26","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\r\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\r\n<p>Providing a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\r\n<p>Split system or ducted air conditioners professionally installed by qualified technicians. We will install your pre purchased unit if required.</p>\r\n<p>Ventilation for any situation </p>\r\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\r\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p>","Airconditioning and Electrical Sunshine Coast","","inherit","open","open","","142-revision-v1","","","2014-02-17 06:45:26","2014-02-17 06:45:26","","142","http://comfortsolutions.com.au/airconditioning/142-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("147","1","2014-02-17 06:47:14","2014-02-17 06:47:14","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\r\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\r\n<p>Providing a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\r\n<p>Split system or ducted air conditioners professionally installed by qualified technicians. We will also install your pre purchased unit if required.</p>\r\n<p>Ventilation solutions provided for any situation including bathrooms, parking garages and more.</p>\r\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\r\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p>","Airconditioning and Electrical Sunshine Coast","","inherit","open","open","","142-revision-v1","","","2014-02-17 06:47:14","2014-02-17 06:47:14","","142","http://comfortsolutions.com.au/airconditioning/142-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("148","1","2014-02-17 06:48:18","2014-02-17 06:48:18","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\r\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\r\n<p>Providing a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\r\n<p>Split system or ducted air conditioners professionally installed by qualified technicians. We will also install your pre purchased unit if required.</p>\r\n<p>Ventilation solutions provided for any situation including bathrooms, parking garages and more.</p>\r\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\r\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p><a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","Airconditioning and Electrical Sunshine Coast","","inherit","open","open","","142-revision-v1","","","2014-02-17 06:48:18","2014-02-17 06:48:18","","142","http://comfortsolutions.com.au/airconditioning/142-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("150","1","2014-02-17 06:56:46","2014-02-17 06:56:46","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n<p><img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n<p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p>\r\n<p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p>\r\n<p>Tel: (07) 5499 6299</p>\r\n<p><span style=\"font-weight: bold;\">Mob: 0410 205 271</span></p>\r\n<p>Email: info@comfortsolutions.com.au</p>\r\n<p><img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\"><br /> </span></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n<p>[contact-form-7 id=\"54\" title=\"Contact form 1\"]</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-17 06:56:46","2014-02-17 06:56:46","","15","http://comfortsolutions.com.au/airconditioning/15-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("151","1","2014-02-17 06:57:26","2014-02-17 06:57:26","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n<p><img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n<p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p>\r\n<p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Mob: 0410 205 271</span></p>\r\n<p>Email: info@comfortsolutions.com.au</p>\r\n<p><img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\"><br /> </span></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n<p>[contact-form-7 id=\"54\" title=\"Contact form 1\"]</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-17 06:57:26","2014-02-17 06:57:26","","15","http://comfortsolutions.com.au/airconditioning/15-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("152","1","2014-02-17 07:08:33","2014-02-17 07:08:33","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:08:33","2014-02-17 07:08:33","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("153","1","2014-02-17 07:09:17","2014-02-17 07:09:17","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: 0px; width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 0px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:09:17","2014-02-17 07:09:17","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("154","1","2014-02-17 07:14:37","2014-02-17 07:14:37","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: 0px; width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 0px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:14:37","2014-02-17 07:14:37","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("155","1","2014-02-17 07:15:15","2014-02-17 07:15:15","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: 0px; width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 0px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" name=\"headline\"><br />\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:15:15","2014-02-17 07:15:15","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("157","1","2014-02-17 07:22:55","2014-02-17 07:22:55","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: 0px; width: 50%;\"><a href=\"http://#\"><img class=\"size-full wp-image-100 alignnone\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 0px;\"><a href=\"http://#\"><img class=\"size-full wp-image-101 alignnone\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n<p><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" name=\"headline\"></a></span></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:22:55","2014-02-17 07:22:55","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("156","1","2014-02-17 07:21:45","2014-02-17 07:21:45","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: 0px; width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 0px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\"><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"></a></span></span>\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n<span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" name=\"headline\"></a></span></div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:21:45","2014-02-17 07:21:45","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("159","1","2014-02-17 07:32:36","2014-02-17 07:32:36","<div class=\"edg-content-layout layout-item-0\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> <a href=\"http://#\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:32:36","2014-02-17 07:32:36","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("160","1","2014-02-17 07:41:25","2014-02-17 07:41:25","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\">\r\n<a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> <a href=\"http://#\"></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:41:25","2014-02-17 07:41:25","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("163","1","2014-02-17 07:47:19","2014-02-17 07:47:19","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:47:19","2014-02-17 07:47:19","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("162","1","2014-02-17 07:47:03","2014-02-17 07:47:03","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:47:03","2014-02-17 07:47:03","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("161","1","2014-02-17 07:46:42","2014-02-17 07:46:42","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:46:42","2014-02-17 07:46:42","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("164","1","2014-02-17 07:47:45","2014-02-17 07:47:45","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:47:45","2014-02-17 07:47:45","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("165","1","2014-02-17 07:48:06","2014-02-17 07:48:06","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:48:06","2014-02-17 07:48:06","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("166","1","2014-02-17 07:48:19","2014-02-17 07:48:19","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:48:19","2014-02-17 07:48:19","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("167","1","2014-02-17 07:49:16","2014-02-17 07:49:16","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:49:16","2014-02-17 07:49:16","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("168","1","2014-02-17 07:49:58","2014-02-17 07:49:58","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:49:58","2014-02-17 07:49:58","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("169","1","2014-02-17 07:50:24","2014-02-17 07:50:24","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:50:24","2014-02-17 07:50:24","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("170","1","2014-02-17 07:50:45","2014-02-17 07:50:45","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:50:45","2014-02-17 07:50:45","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("171","1","2014-02-17 07:51:18","2014-02-17 07:51:18","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:51:18","2014-02-17 07:51:18","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("172","1","2014-02-17 07:54:16","2014-02-17 07:54:16","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:54:16","2014-02-17 07:54:16","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("182","1","2014-02-17 08:03:06","2014-02-17 08:03:06","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 08:03:06","2014-02-17 08:03:06","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("173","1","2014-02-17 07:55:36","2014-02-17 07:55:36","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:55:36","2014-02-17 07:55:36","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("175","1","2014-02-17 07:56:26","2014-02-17 07:56:26","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:56:26","2014-02-17 07:56:26","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("174","1","2014-02-17 07:56:09","2014-02-17 07:56:09","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:56:09","2014-02-17 07:56:09","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("176","1","2014-02-17 07:56:50","2014-02-17 07:56:50","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 48%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:56:50","2014-02-17 07:56:50","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("177","1","2014-02-17 07:57:27","2014-02-17 07:57:27","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 51%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 48%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:57:27","2014-02-17 07:57:27","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("178","1","2014-02-17 07:57:48","2014-02-17 07:57:48","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 100%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 48%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:57:48","2014-02-17 07:57:48","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("179","1","2014-02-17 07:59:55","2014-02-17 07:59:55","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 100%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 100%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:59:55","2014-02-17 07:59:55","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("180","1","2014-02-17 08:00:17","2014-02-17 08:00:17","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 100%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 08:00:17","2014-02-17 08:00:17","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("181","1","2014-02-17 08:00:33","2014-02-17 08:00:33","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 08:00:33","2014-02-17 08:00:33","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("183","1","2014-02-17 08:05:15","2014-02-17 08:05:16","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"#\" style=\"margin: 0px;\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 08:05:15","2014-02-17 08:05:16","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("184","1","2014-02-17 08:06:08","2014-02-17 08:06:08","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"#\" style=\"margin: 0px;\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"#\" style=\"margin: 0px;\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 08:06:08","2014-02-17 08:06:08","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("187","1","2014-02-17 08:09:29","2014-02-17 08:09:29","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"#\" style=\"margin: 0px;\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"#\" style=\"margin: 0px;\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n\r\n<h1 class=\"edg-layout-cell layout-item-3\" style=\"width: 100%; margin-bottom: 3px;\">\r\n<span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span>\r\n</h1>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 08:09:29","2014-02-17 08:09:29","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("185","1","2014-02-17 08:08:02","2014-02-17 08:08:02","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"#\" style=\"margin: 0px;\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"#\" style=\"margin: 0px;\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%; margin-bottom: 3px;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 08:08:02","2014-02-17 08:08:02","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("186","1","2014-02-17 08:08:51","2014-02-17 08:08:51","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"#\" style=\"margin: 0px;\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"#\" style=\"margin: 0px;\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<h1><div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%; margin-bottom: 3px;\">\r\n<span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span>\r\n</div></h1>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 08:08:51","2014-02-17 08:08:51","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("188","1","2014-02-17 08:09:52","2014-02-17 08:09:52","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"#\" style=\"margin: 0px;\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"#\" style=\"margin: 0px;\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%; margin-bottom: 3px;\">\r\n<span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span><br />\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 08:09:52","2014-02-17 08:09:52","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("190","1","2014-02-17 08:10:42","2014-02-17 08:10:42","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"#\" style=\"margin: 0px;\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"#\" style=\"margin: 0px;\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%; padding: 3px;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 08:10:42","2014-02-17 08:10:42","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("189","1","2014-02-17 08:10:21","2014-02-17 08:10:21","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"#\" style=\"margin: 0px;\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"#\" style=\"margin: 0px;\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%; margin-bottom: 3px;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditionin