DROP TABLE wp_commentmeta;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE wp_comments;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE wp_links;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE wp_options;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=12062 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wp_options VALUES("1","siteurl","http://comfortsolutions.com.au/airconditioning","yes");
INSERT INTO wp_options VALUES("2","blogname","Sunshine Coast Air Conditioning &amp; Electrical","yes");
INSERT INTO wp_options VALUES("3","blogdescription","Domestic or commercial installations and service","yes");
INSERT INTO wp_options VALUES("4","users_can_register","0","yes");
INSERT INTO wp_options VALUES("5","admin_email","info@edgewebdesign.com.au","yes");
INSERT INTO wp_options VALUES("6","start_of_week","1","yes");
INSERT INTO wp_options VALUES("7","use_balanceTags","0","yes");
INSERT INTO wp_options VALUES("8","use_smilies","1","yes");
INSERT INTO wp_options VALUES("9","require_name_email","1","yes");
INSERT INTO wp_options VALUES("10","comments_notify","1","yes");
INSERT INTO wp_options VALUES("11","posts_per_rss","10","yes");
INSERT INTO wp_options VALUES("12","rss_use_excerpt","0","yes");
INSERT INTO wp_options VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO wp_options VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO wp_options VALUES("15","mailserver_pass","password","yes");
INSERT INTO wp_options VALUES("16","mailserver_port","110","yes");
INSERT INTO wp_options VALUES("17","default_category","1","yes");
INSERT INTO wp_options VALUES("18","default_comment_status","closed","yes");
INSERT INTO wp_options VALUES("19","default_ping_status","open","yes");
INSERT INTO wp_options VALUES("20","default_pingback_flag","1","yes");
INSERT INTO wp_options VALUES("21","posts_per_page","10","yes");
INSERT INTO wp_options VALUES("22","date_format","F j, Y","yes");
INSERT INTO wp_options VALUES("23","time_format","g:i a","yes");
INSERT INTO wp_options VALUES("24","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO wp_options VALUES("28","comment_moderation","1","yes");
INSERT INTO wp_options VALUES("29","moderation_notify","1","yes");
INSERT INTO wp_options VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO wp_options VALUES("31","gzipcompression","0","yes");
INSERT INTO wp_options VALUES("32","hack_file","0","yes");
INSERT INTO wp_options VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO wp_options VALUES("34","moderation_keys","","no");
INSERT INTO wp_options VALUES("35","active_plugins","a:6:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1;s:39:\"custom-login-page/custom-login-page.php\";i:2;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:3;s:55:\"ultimate-maintenance-mode/ultimate-maintenance-mode.php\";i:4;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:5;s:27:\"wp-super-cache/wp-cache.php\";}","yes");
INSERT INTO wp_options VALUES("11872","_transient_timeout_feed_mod_867bd5c64f85878d03a060509cd2f92c","1439545341","no");
INSERT INTO wp_options VALUES("11873","_transient_feed_mod_867bd5c64f85878d03a060509cd2f92c","1439502141","no");
INSERT INTO wp_options VALUES("12052","_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109","1440006336","no");
INSERT INTO wp_options VALUES("36","home","http://comfortsolutions.com.au/airconditioning","yes");
INSERT INTO wp_options VALUES("37","category_base","","yes");
INSERT INTO wp_options VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO wp_options VALUES("39","advanced_edit","0","yes");
INSERT INTO wp_options VALUES("40","comment_max_links","2","yes");
INSERT INTO wp_options VALUES("41","gmt_offset","0","yes");
INSERT INTO wp_options VALUES("42","default_email_category","1","yes");
INSERT INTO wp_options VALUES("43","recently_edited","","no");
INSERT INTO wp_options VALUES("44","template","airconbasix","yes");
INSERT INTO wp_options VALUES("45","stylesheet","airconbasix","yes");
INSERT INTO wp_options VALUES("46","comment_whitelist","1","yes");
INSERT INTO wp_options VALUES("47","blacklist_keys","","no");
INSERT INTO wp_options VALUES("48","comment_registration","","yes");
INSERT INTO wp_options VALUES("49","html_type","text/html","yes");
INSERT INTO wp_options VALUES("50","use_trackback","0","yes");
INSERT INTO wp_options VALUES("51","default_role","subscriber","yes");
INSERT INTO wp_options VALUES("52","db_version","31536","yes");
INSERT INTO wp_options VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO wp_options VALUES("54","upload_path","","yes");
INSERT INTO wp_options VALUES("55","blog_public","1","yes");
INSERT INTO wp_options VALUES("56","default_link_category","2","yes");
INSERT INTO wp_options VALUES("57","show_on_front","page","yes");
INSERT INTO wp_options VALUES("58","tag_base","","yes");
INSERT INTO wp_options VALUES("59","show_avatars","1","yes");
INSERT INTO wp_options VALUES("60","avatar_rating","G","yes");
INSERT INTO wp_options VALUES("61","upload_url_path","","yes");
INSERT INTO wp_options VALUES("62","thumbnail_size_w","150","yes");
INSERT INTO wp_options VALUES("63","thumbnail_size_h","150","yes");
INSERT INTO wp_options VALUES("64","thumbnail_crop","1","yes");
INSERT INTO wp_options VALUES("65","medium_size_w","300","yes");
INSERT INTO wp_options VALUES("66","medium_size_h","300","yes");
INSERT INTO wp_options VALUES("67","avatar_default","mystery","yes");
INSERT INTO wp_options VALUES("68","large_size_w","1024","yes");
INSERT INTO wp_options VALUES("69","large_size_h","1024","yes");
INSERT INTO wp_options VALUES("70","image_default_link_type","file","yes");
INSERT INTO wp_options VALUES("71","image_default_size","","yes");
INSERT INTO wp_options VALUES("72","image_default_align","","yes");
INSERT INTO wp_options VALUES("73","close_comments_for_old_posts","","yes");
INSERT INTO wp_options VALUES("74","close_comments_days_old","14","yes");
INSERT INTO wp_options VALUES("75","thread_comments","1","yes");
INSERT INTO wp_options VALUES("76","thread_comments_depth","5","yes");
INSERT INTO wp_options VALUES("77","page_comments","","yes");
INSERT INTO wp_options VALUES("78","comments_per_page","50","yes");
INSERT INTO wp_options VALUES("79","default_comments_page","newest","yes");
INSERT INTO wp_options VALUES("80","comment_order","asc","yes");
INSERT INTO wp_options VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO wp_options VALUES("82","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("83","widget_text","a:0:{}","yes");
INSERT INTO wp_options VALUES("84","widget_rss","a:0:{}","yes");
INSERT INTO wp_options VALUES("85","uninstall_plugins","a:1:{s:27:\"wp-super-cache/wp-cache.php\";s:23:\"wpsupercache_deactivate\";}","no");
INSERT INTO wp_options VALUES("86","timezone_string","","yes");
INSERT INTO wp_options VALUES("87","page_for_posts","16","yes");
INSERT INTO wp_options VALUES("88","page_on_front","12","yes");
INSERT INTO wp_options VALUES("89","default_post_format","0","yes");
INSERT INTO wp_options VALUES("90","link_manager_enabled","0","yes");
INSERT INTO wp_options VALUES("91","initial_db_version","26691","yes");
INSERT INTO wp_options VALUES("92","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO wp_options VALUES("93","_transient_random_seed","4b78d06243a27ad42a3feabe7e515d49","yes");
INSERT INTO wp_options VALUES("94","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("95","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("96","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("97","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("98","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("99","sidebars_widgets","a:10:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:19:\"primary-widget-area\";a:0:{}s:18:\"header-widget-area\";a:0:{}s:21:\"first-nav-widget-area\";a:0:{}s:22:\"second-nav-widget-area\";N;s:21:\"first-top-widget-area\";N;s:22:\"second-top-widget-area\";N;s:24:\"first-bottom-widget-area\";N;s:25:\"second-bottom-widget-area\";N;s:13:\"array_version\";i:3;}","yes");
INSERT INTO wp_options VALUES("154","theme_sample_data","a:5:{s:5:\"posts\";a:2:{i:0;i:27;i:1;i:28;}s:5:\"pages\";a:5:{i:0;i:12;i:1;i:13;i:2;i:14;i:3;i:15;i:4;i:16;}s:7:\"widgets\";a:0:{}s:5:\"vmenu\";a:0:{}s:4:\"menu\";a:2:{i:0;i:2;i:1;i:3;}}","yes");
INSERT INTO wp_options VALUES("155","theme_content_import","1","yes");
INSERT INTO wp_options VALUES("184","recently_activated","a:0:{}","yes");
INSERT INTO wp_options VALUES("101","cron","a:6:{i:1439964000;a:1:{s:11:\"wp_cache_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1439965797;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1439968740;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1440004636;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1440047856;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO wp_options VALUES("102","ossdl_off_cdn_url","http://comfortsolutions.com.au/airconditioning","yes");
INSERT INTO wp_options VALUES("103","ossdl_off_include_dirs","wp-content,wp-includes","yes");
INSERT INTO wp_options VALUES("104","ossdl_off_exclude",".php","yes");
INSERT INTO wp_options VALUES("105","ossdl_cname","","yes");
INSERT INTO wp_options VALUES("114","tadv_version","4000","yes");
INSERT INTO wp_options VALUES("11889","rewrite_rules","a:68:{s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=12&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}","yes");
INSERT INTO wp_options VALUES("11910","_site_transient_timeout_available_translations","1439515129","yes");
INSERT INTO wp_options VALUES("11911","_site_transient_available_translations","a:59:{s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:19:\"2015-05-26 06:57:37\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.2/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-28 10:19:19\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-08 17:43:43\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-09 05:25:37\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-08 11:08:34\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-29 07:26:05\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-28 16:26:14\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-12 10:52:32\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-24 12:08:43\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-12 11:12:13\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:19:\"2015-04-25 13:39:01\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.2/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"4.0\";s:7:\"updated\";s:19:\"2014-09-04 19:47:01\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.0/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-05 20:09:08\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-04 18:19:10\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-10 14:16:27\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:3:\"4.0\";s:7:\"updated\";s:19:\"2014-09-05 17:37:43\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.0/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.1.7\";s:7:\"updated\";s:19:\"2015-03-26 15:20:27\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.7/haz.zip\";s:3:\"iso\";a:1:{i:2;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-12 11:07:42\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-07 17:26:35\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-23 11:42:14\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-07 13:29:19\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-04 17:21:56\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-27 01:39:56\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:19:\"2015-04-23 15:23:08\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.2/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:5:\"4.1.7\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.7/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-02 17:06:22\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-12 12:07:26\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-29 10:11:53\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-01 08:03:33\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.2.4/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-26 23:08:12\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:5:\"4.1.7\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.7/ps.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ps\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"دوام\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-22 10:25:51\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-12 11:05:21\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-26 00:43:12\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-30 17:27:24\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.1.7\";s:7:\"updated\";s:19:\"2015-03-26 16:25:46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.7/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:19:\"2015-05-29 08:27:12\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-03 18:34:59\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-06 10:10:09\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-24 13:30:08\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.1.7\";s:7:\"updated\";s:19:\"2015-03-26 16:45:38\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.7/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-08-11 11:08:44\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.2.4/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-23 13:52:20\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.2.4\";s:7:\"updated\";s:19:\"2015-07-04 19:52:42\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.4/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}","yes");
INSERT INTO wp_options VALUES("125","wpsupercache_gc_time","1439962615","yes");
INSERT INTO wp_options VALUES("150","theme_mods_twentyfourteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1391145637;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","yes");
INSERT INTO wp_options VALUES("227","wpcf7","a:1:{s:7:\"version\";s:5:\"4.2.2\";}","yes");
INSERT INTO wp_options VALUES("12037","_site_transient_timeout_theme_roots","1439964416","yes");
INSERT INTO wp_options VALUES("12038","_site_transient_theme_roots","a:4:{s:11:\"airconbasix\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";s:12:\"twentytwelve\";s:7:\"/themes\";}","yes");
INSERT INTO wp_options VALUES("12042","_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","1440006333","no");
INSERT INTO wp_options VALUES("12043","_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Aug 2015 21:45:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://wordpress.org/?v=4.4-alpha-33640\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 4.3 “Billie”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2015/08/billie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/08/billie/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Aug 2015 19:12:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3845\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:352:\"Version 4.3 of WordPress, named &#8220;Billie&#8221; in honor of jazz singer Billie Holiday, is available for download or update in your WordPress dashboard. New features in 4.3 make it even easier to format your content and customize your site. Menus in the Customizer Create your menu, update it, and assign it, all while live-previewing in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:21817:\"<p style=\"margin: 0;height: 0\"><img src=\"https://wordpress.org/news/files/2015/08/WordPress-4-3-billie-1024x574.png\" alt=\"WordPress 4.3 - &quot;Billie&quot;\" width=\"692\" height=\"388\" class=\"alignnone size-large wp-image-3896\" style=\"height:0px;width: 0px;margin: 0\" /></p>\n<p>Version 4.3 of WordPress, named &#8220;Billie&#8221; in honor of jazz singer <a href=\"https://en.wikipedia.org/wiki/Billie_Holiday\">Billie Holiday</a>, is available for <a href=\"https://wordpress.org/download/\">download</a> or update in your WordPress dashboard. New features in 4.3 make it even easier to format your content and customize your site.</p>\n<p><iframe width=\'692\' height=\'389\' src=\'https://videopress.com/embed/T54Iy7Tw?hd=1\' frameborder=\'0\' allowfullscreen></iframe><script src=\'http://s0.wp.com/wp-content/plugins/video/assets/js/next/videopress-iframe.js?m=1435166243\'></script></p>\n<hr style=\"margin-top: -2em\" />\n<h2>Menus in the Customizer</h2>\n<div><img src=\"//s.w.org/images/core/4.3/menu-customizer.png\" alt=\"\" /></div>\n<p>Create your menu, update it, and assign it, all while live-previewing in the customizer. The streamlined customizer design provides a mobile-friendly and accessible interface. With every release, it becomes easier and faster to make your site just the way you want it.</p>\n<hr />\n<h2>Formatting Shortcuts</h2>\n<div style=\"margin-bottom: 0\"><div style=\"width: 640px; \" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-3845-1\" width=\"640\" height=\"360\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"//s.w.org/images/core/4.3/formatting.mp4?_=1\" /><source type=\"video/webm\" src=\"//s.w.org/images/core/4.3/formatting.webm?_=1\" /><source type=\"video/ogg\" src=\"//s.w.org/images/core/4.3/formatting.ogv?_=1\" /><a href=\"//s.w.org/images/core/4.3/formatting.mp4\">//s.w.org/images/core/4.3/formatting.mp4</a></video></div></div>\n<p>Your writing flow just got faster with new formatting shortcuts in WordPress 4.3. Use asterisks to create lists and number signs to make a heading. No more breaking your flow; your text looks great with a <code>*</code> and a <code>#</code>.</p>\n<hr />\n<h2>Site Icons</h2>\n<p><img src=\"//s.w.org/images/core/4.3/site-icon-customizer.png\" alt=\"\" /><br />\n&nbsp;<br />\nSite icons represent your site in browser tabs, bookmark menus, and on the home screen of mobile devices. Add your unique site icon in the customizer; it will even stay in place when you switch themes. Make your whole site reflect your brand.</p>\n<hr />\n<h2>Better Passwords</h2>\n<p><img src=\"//s.w.org/images/core/4.3/better-passwords.png\" alt=\"\" /><br />\n&nbsp;<br />\nKeep your site more secure with WordPress’ improved approach to passwords. Instead of receiving passwords via email, you’ll get a password reset link. When you add new users to your site or edit a user profile, WordPress will automatically generate a secure password.</p>\n<hr />\n<h2>Other improvements</h2>\n<ul>\n<li><strong>A smoother admin experience</strong> &#8211; Refinements to the list view across the admin make your WordPress more accessible and easier to work with on any device.</li>\n<li><strong>Comments turned off on pages</strong> &#8211; All new pages that you create will have comments turned off. Keep discussions to your blog, right where they’re supposed to happen.</li>\n<li><strong>Customize your site quickly</strong> &#8211; Wherever you are on the front-end, you can click the customize link in the toolbar to swiftly make changes to your site.</li>\n</ul>\n<hr />\n<h2>The Team</h2>\n<p><a class=\"alignleft\" href=\"https://profiles.wordpress.org/obenland\"><img src=\"https://www.gravatar.com/avatar/2370ea5912750f4cb0f3c51ae1cbca55?d=mm&amp;s=180&amp;r=G\" alt=\"Konstantin Obenland\" width=\"80\" height=\"80\" /></a>This release was led by <a href=\"http://konstantin.obenland.it/\">Konstantin Obenland</a>, with the help of these fine individuals. There are 246 contributors with props in this release. Pull up some Billie Holiday on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/mercime\">@mercime</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamkheckler\">Adam Heckler</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bjorklund</a>, <a href=\"https://profiles.wordpress.org/akirk\">Alex Kirk</a>, <a href=\"https://profiles.wordpress.org/viper007bond\">Alex Mills (Viper007Bond)</a>, <a href=\"https://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/deconf\">Alin Marcu</a>, <a href=\"https://profiles.wordpress.org/andfinally\">andfinally</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andg\">Andrea Gandino</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/antpb\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/anubisthejackle\">anubisthejackle</a>, <a href=\"https://profiles.wordpress.org/aramzs\">Aram Zucker-Scharff</a>, <a href=\"https://profiles.wordpress.org/arjunskumar\">Arjun S Kumar</a>, <a href=\"https://profiles.wordpress.org/avnarun\">avnarun</a>, <a href=\"https://profiles.wordpress.org/brad2dabone\">Bad Feather</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/binarykitten\">BinaryKitten</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornjohansen\">Bjorn Johansen</a>, <a href=\"https://profiles.wordpress.org/bolo1988\">bolo1988</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradt\">Brad Touesnard</a>, <a href=\"https://profiles.wordpress.org/bramd\">Bram Duvigneau</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/brianlayman\">Brian Layman</a>, <a href=\"https://profiles.wordpress.org/icaleb\">Caleb Burks</a>, <a href=\"https://profiles.wordpress.org/calevans\">CalEvans</a>, <a href=\"https://profiles.wordpress.org/chasewiseman\">Chase Wiseman</a>, <a href=\"https://profiles.wordpress.org/chipbennett\">Chip Bennett</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/c3mdigital\">Chris Olbekson</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/posykrat\">Clement Biron</a>, <a href=\"https://profiles.wordpress.org/craig-ralston\">Craig Ralston</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Mte90 Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/daniluk4000\">daniluk4000</a>, <a href=\"https://profiles.wordpress.org/dmchale\">Dave McHale</a>, <a href=\"https://profiles.wordpress.org/daveal\">DaveAl</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/daxelrod\">daxelrod</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/realloc\">Dennis Ploetner</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipesh.kakadiya</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/kucrut\">Dzikri Aziz</a>, <a href=\"https://profiles.wordpress.org/eclev91\">eclev91</a>, <a href=\"https://profiles.wordpress.org/eligijus\">eligijus</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ericmann\">Eric Mann</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/francoeurdavid\">francoeurdavid</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/gabrielperezs\">gabrielperezs</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">Garth Mortensen</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/glennm\">glennm</a>, <a href=\"https://profiles.wordpress.org/gtuk\">gtuk</a>, <a href=\"https://profiles.wordpress.org/hailin\">hailin</a>, <a href=\"https://profiles.wordpress.org/hauvong\">hauvong</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/henrikakselsen\">henrikakselsen</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hrishiv90\">Hrishikesh Vaipurkar</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/isaacchapman\">isaacchapman</a>, <a href=\"https://profiles.wordpress.org/izem\">izem</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jacklenox\">Jack Lenox</a>, <a href=\"https://profiles.wordpress.org/jadpm\">jadpm</a>, <a href=\"https://profiles.wordpress.org/jamesgol\">jamesgol</a>, <a href=\"https://profiles.wordpress.org/jancbeck\">jancbeck</a>, <a href=\"https://profiles.wordpress.org/jfarthing84\">Jeff Farthing</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jmichaelward\">Jeremy Ward</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">jipmoors</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/jkudish\">Joey Kudish</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/picard102\">John Leschinski</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/jpyper\">Jpyper</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/ungestaltbar\">Kai</a>, <a href=\"https://profiles.wordpress.org/karinchristen\">karinchristen</a>, <a href=\"https://profiles.wordpress.org/karpstrucking\">karpstrucking</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kevkoeh\">kevkoeh</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leogopal\">Leo Gopal</a>, <a href=\"https://profiles.wordpress.org/loushou\">loushou</a>, <a href=\"https://profiles.wordpress.org/lumaraf\">Lumaraf</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/nofearinc\">Mario Peshev</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius (Clorith)</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/marsjaninzmarsa\">marsjaninzmarsa</a>, <a href=\"https://profiles.wordpress.org/martinsachse\">martinsachse</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/maxxsnake\">maxxsnake</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/nikonratm\">Michael</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michaelryanmcneill\">michaelryanmcneill</a>, <a href=\"https://profiles.wordpress.org/mcguive7\">Mickey Kay</a>, <a href=\"https://profiles.wordpress.org/mihai\">mihai</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Mike Nelson</a>, <a href=\"https://profiles.wordpress.org/dh-shredder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinic</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mrutz\">mrutz</a>, <a href=\"https://profiles.wordpress.org/nabil_kadimi\">nabil_kadimi</a>, <a href=\"https://profiles.wordpress.org/Nao\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nazmulhossainnihal\">Nazmul Hossain Nihal</a>, <a href=\"https://profiles.wordpress.org/nicholas_io\">nicholas_io</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nickmomrik\">Nick Momrik</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/ohryan\">ohryan</a>, <a href=\"https://profiles.wordpress.org/onnimonni\">Onni Hakala</a>, <a href=\"https://profiles.wordpress.org/ozh\">Ozh</a>, <a href=\"https://profiles.wordpress.org/pareshradadiya-1\">Paresh Radadiya</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/djpaul\">Paul Gibbs</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/gungeekatx\">Pete Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/peterrknight\">PeterRKnight</a>, <a href=\"https://profiles.wordpress.org/philiparthurmoore\">Philip Arthur Moore</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">polevaultweb</a>, <a href=\"https://profiles.wordpress.org/pragunbhutani\">pragunbhutani</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/rarylson\">rarylson</a>, <a href=\"https://profiles.wordpress.org/lamosty\">Rastislav Lamos</a>, <a href=\"https://profiles.wordpress.org/rauchg\">rauchg</a>, <a href=\"https://profiles.wordpress.org/ravinderk\">Ravinder Kumar</a>, <a href=\"https://profiles.wordpress.org/rclations\">RC Lations</a>, <a href=\"https://profiles.wordpress.org/greuben\">Reuben Gunday</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/ritteshpatel\">Ritesh Patel</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/rdall\">Robert Dall</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/rhurling\">Rouven Hurling</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/rmarks\">Ryan Marks</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/sagarjadhav\">Sagar Jadhav</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/santagada\">santagada</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/scruffian\">scruffian</a>, <a href=\"https://profiles.wordpress.org/seanchayes\">Sean Hayes</a>, <a href=\"https://profiles.wordpress.org/sebastiantiede\">sebastiantiede</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shooper\">Shawn Hooper</a>, <a href=\"https://profiles.wordpress.org/designsimply\">Sheri Bigelow</a>, <a href=\"https://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"https://profiles.wordpress.org/siobhan\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/stephdau\">Stephane Daury (stephdau)</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/stuartshields\">stuartshields</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar</a>, <a href=\"https://profiles.wordpress.org/sunnyratilal\">Sunny Ratilal</a>, <a href=\"https://profiles.wordpress.org/taka2\">taka2</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/thorbrink\">Thor Brink</a>, <a href=\"https://profiles.wordpress.org/creativeinfusion\">Tim Smith</a>, <a href=\"https://profiles.wordpress.org/tlexcellent\">tlexcellent</a>, <a href=\"https://profiles.wordpress.org/tmatsuur\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tomasm\">Tomas Mackevicius</a>, <a href=\"https://profiles.wordpress.org/tomharrigan\">TomHarrigan</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/toru\">Toru Miki</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/tryon\">Tryon Eggleston</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/desaiuditd\">Udit Desai</a>, <a href=\"https://profiles.wordpress.org/vivekbhusal\">vivekbhusal</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/willnorris\">Will Norris</a>, <a href=\"https://profiles.wordpress.org/willgladstone\">willgladstone</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/willstedt\">willstedt</a>, <a href=\"https://profiles.wordpress.org/eltobiano\">WPMU DEV Jose</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/ysalame\">Yuri Salame</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/katzwebdesign\">Zack Katz</a>, and <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>.\n<p>&nbsp;</p>\n<p>Special thanks go to <a href=\"http://siobhanmckeown.com/\">Siobhan McKeown</a> for producing the release video, <a href=\"http://hugobaeta.com/\">Hugo Baeta</a> for the design, and <a href=\"http://jacklenox.com/\">Jack Lenox</a> for the voice-over.</p>\n<p>Finally, thanks to all of the contributors who provided subtitles for the release video, which at last count had been translated into 30 languages!</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress. See you soon for version 4.4!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/news/2015/08/billie/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.4 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 12:10:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3827\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:397:\"WordPress 4.2.4 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. This release addresses six issues, including three cross-site scripting vulnerabilities and a potential SQL injection that could be used to compromise a site, which were discovered by Marc-Alexandre Montpas of Sucuri, Helen Hou-Sandí [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Samuel Sidler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2011:\"<p>WordPress 4.2.4 is now available. This is a<strong> security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>This release addresses six issues, including three cross-site scripting vulnerabilities and a potential SQL injection that could be used to compromise a site, which were discovered by <a href=\"https://sucuri.net/\">Marc-Alexandre Montpas</a> of Sucuri, <a href=\"http://helenhousandi.com/\">Helen Hou-Sandí</a> of the WordPress security team, <a href=\"http://www.checkpoint.com/\">Netanel Rubin</a> of Check Point, and <a href=\"https://hackerone.com/reactors08\">Ivan Grigorov</a>. It also includes a fix for a potential timing side-channel attack, discovered by <a href=\"http://www.scrutinizer-ci.com/\">Johannes Schmitt</a> of Scrutinizer, and prevents an attacker from locking a post from being edited, discovered by <a href=\"https://www.linkedin.com/in/symbiansymoh\">Mohamed A. Baset</a>.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.4 also fixes four bugs. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.4\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=33573&amp;stop_rev=33396\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.4</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.4.</p>\n<p><em>Already testing WordPress 4.3? The second release candidate is now available (<a href=\"https://wordpress.org/wordpress-4.3-RC2.zip\">zip</a>) and it contains these fixes. For more on 4.3, see <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/\">the RC 1 announcement post</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.3 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 23:50:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3817\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:340:\"The release candidate for WordPress 4.3 is now available. We&#8217;ve made more than 100 changes since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.3 on Tuesday, August 18, but we [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2256:\"<p>The release candidate for WordPress 4.3 is now available.</p>\n<p>We&#8217;ve made more than <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33512&amp;stop_rev=33372&amp;limit=120\">100 changes</a> since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.3 on <strong>Tuesday, August 18</strong>, but we need your help to get there.</p>\n<p>If you haven’t tested 4.3 yet, now is the time!</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you&#8217;ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.3 RC1, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.3-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.3 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.3 before next week. If you find compatibility problems, we never want to break things, so please be sure to post to the support forums so we can figure those out before the final release.</p>\n<p>Be sure to <a href=\"https://make.wordpress.org/core/\">follow along the core development blog</a>, where we&#8217;ll continue to post <a href=\"https://make.wordpress.org/core/tag/dev-notes+4-3/\">notes for developers</a> for 4.3.</p>\n<p><em>Drei Monate Arbeit</em><br />\n<em>Endlich das Ziel vor Augen</em><br />\n<em>Bald hab ich Urlaub!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.3 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2015/07/wordpress-4-2-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 11:21:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3807\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:380:\"WordPress 4.2.3 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was initially reported by Jon Cave and [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2708:\"<p>WordPress 4.2.3 is now available. This is a<strong> security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was initially reported by <a href=\"https://profiles.wordpress.org/duck_\">Jon Cave</a> and fixed by <a href=\"http://www.miqrogroove.com/\">Robert Chapin</a>, both of the WordPress security team, and later reported by <a href=\"http://klikki.fi/\">Jouko Pynnönen</a>.</p>\n<p>We also fixed an issue where it was possible for a user with Subscriber permissions to create a draft through Quick Draft. Reported by Netanel Rubin from <a href=\"https://www.checkpoint.com/\">Check Point Software Technologies</a>.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.3 also contains fixes for 20 bugs from 4.2. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.3\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=33382&amp;stop_rev=32430\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.3</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.3.</p>\n<p>Thanks to everyone who contributed to 4.2.3:</p>\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/gabrielperezs\">Gabriel Pérez</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Mike Adams</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, and <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-2-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 21:55:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3796\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.3 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2212:\"<p>WordPress 4.3 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\">Beta 3</a> blog posts. Some of the changes in Beta 4 include:</p>\n<ul>\n<li><span class=\"s1\">Fixed several bugs and broken flows in the </span><span class=\"s1\"><strong>publish box </strong></span><span class=\"s1\">in the edit screen.</span></li>\n<li>Addressed a number of edge cases for word count in the <strong>editor</strong>.</li>\n<li><span class=\"s1\"><strong>Site icons</strong> </span><span class=\"s1\">can now be previewed within the customizer. The feature has been removed from general settings.</span></li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33369&amp;stop_rev=33289\">more than 60 changes</a> in the last week.</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.3\">everything we’ve fixed</a>.</p>\n<p><em>Few Tickets Remain</em><br />\n<em>Edge Cases Disappearing</em><br />\n<em>You Must Test Today</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jul 2015 21:49:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3787\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.3 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2529:\"<p>WordPress 4.3 Beta 3 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta3.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a> blog posts. Some of the changes in Beta 3 include:</p>\n<ul>\n<li>Performance improvements for <strong>Menus in the Customizer</strong>, as well as bug fixes and visual enhancements.</li>\n<li>Added <strong>Site Icon</strong> to the Customizer. The feature is now complete and requires lots of testing. Please help us ensure the site icon feature works well in both Settings and the Customizer.</li>\n<li>The improvements to <strong>Passwords</strong> have been added to the installation flow. When installing and setting up WordPress, a strong password will be suggested to site administrators. Please test and let us know if you encounter issues.</li>\n<li>Improved <strong>accessibility of comments and media list tables</strong>. If you use a screen reader, please let us know if you encounter any issues.</li>\n<li>Lots and lots of code documentation improvements.</li>\n<li><strong>Various other bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33286&amp;stop_rev=33141&amp;limit=150\">more than 140 changes</a> in the last week.</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.3\">everything we’ve fixed</a>.</p>\n<p><em>Want to test new things?</em><br />\n<em>Wonder how four three shapes up?</em><br />\n<em>Answer: beta three</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jul 2015 22:04:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3769\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.3 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2876:\"<p>WordPress 4.3 Beta 2 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta2.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">check out the Beta 1 blog post</a>. Some of the changes in Beta 2 include:</p>\n<ul>\n<li>Fixed an issue in beta 1 where an alert appeared when saving or publishing a new post/page for the first time.</li>\n<li><strong><strong>Customizer</strong></strong> improvements including enhanced accessibility, smoother menu creation and location assignment, and the ability to handle nameless menus. Please help us test menus in the Customizer to fix any remaining edge cases!</li>\n<li>More robust<strong> list tables</strong> with full content support on small screens and a fallback for the primary column for custom list tables. We&#8217;d love to know how these list tables, such as All Posts and Comments, work for you now on small screen devices.</li>\n<li>The <strong>Site Icon</strong> feature has been improved so that cropping is skipped if the image is the exact size (512px square) and the media modal now suggests a minimum icon size. Please let us know how the flow feels and if you encounter any glitches!</li>\n<li>The <strong>toolbar</strong> now has a direct link to the customizer, along with quick access to themes, widgets, and menus in the dashboard.</li>\n<li>We enabled <strong>utf8mb4 for MySQL</strong> extension users, which was previously unintentionally limited to MySQLi users. Please let us know if you run into any issues.</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33138&amp;stop_rev=33046\">almost 100 changes</a> in the last week.</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.3&amp;group=component&amp;order=priority\">everything we’ve fixed</a>.</p>\n<p><em>Edges polished up</em><br />\n<em>Features meliorated</em><br />\n<em>Beta Two: go test!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordCamps Update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/news/2015/07/wordcamps-update/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordcamps-update/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jul 2015 16:13:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3758\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:311:\"Last week saw the halfway point for 2015, yay! This seems like a good time to update you on WordCamp happenings in the first half of this year. There have been 39 WordCamps in 2015 so far, with events organized in 17 different countries and on 5 continents. More than 14,000 people have registered for [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9419:\"<p>Last week saw the halfway point for 2015, yay! This seems like a good time to update you on WordCamp happenings in the first half of this year.</p>\n<p>There have been <a href=\"https://central.wordcamp.org/schedule/past-wordcamps/\">39 WordCamps in 2015</a> so far, with events organized in 17 different countries and on 5 continents. More than 14,000 people have registered for WordCamp tickets so far this year, isn&#8217;t that amazing?</p>\n<p><a href=\"https://europe.wordcamp.org/2015/\">WordCamp Europe</a> was held in Seville, Spain just a few weeks ago, with close to 1,000 registered participants and over 500 live stream participants. You can watch  <a href=\"http://wordpress.tv/2015/07/04/matt-mullenweg-keynote-qanda-wordcamp-europe-2015/\">Matt Mullenweg’s keynote Q&amp;A</a> session from WordCamp Europe right now on WordPress.tv.</p>\n<p>WordPress.tv has published 537 videos so far in 2015 from WordCamps around the world. Some of the more popular 2015 WordCamp talks on WordPress.tv include <a href=\"http://wordpress.tv/2015/03/13/tammie-lister-theme-dont-be-my-everything/\">Tammie Lister: Theme, Don’t Be My Everything </a>from WordCamp Maui, <a href=\"http://wordpress.tv/2015/04/17/jenny-munn-seo-for-2015-whats-in-whats-out-and-how-to-be-in-it-to-win-it-for-good/\">Jenny Munn: SEO for 2015 – What’s In, What’s Out and How to Be In It to Win It (For Good)</a> from WordCamp Atlanta, <a href=\"http://wordpress.tv/2015/02/27/fabrice-ducarme-les-constructeurs-de-page-pour-wordpress/\">Fabrice Ducarme: Les Constructeurs de Page pour WordPress</a> from WordCamp Paris, <a href=\"http://wordpress.tv/2015/06/02/ben-furfie-how-to-value-price-websites/\">Ben Furfie: How to Value Price Websites</a> from WordCamp London, and <a href=\"http://wordpress.tv/2015/06/09/morten-rand-hendriksen-building-themes-from-scratch-using-underscores-_s/\">Morten Rand-Hendriksen: Building Themes From Scratch Using Underscores (_S)</a> from WordCamp Seattle. Check them out!</p>\n<h3>Lots of great WordCamps are still to come</h3>\n<p><a href=\"http://ma.tt/2015/06/wordcamp-us-survey/\">WordCamp US</a> is currently in pre-planning, in the process of deciding on a host city. The following cities have proposed themselves as a great place to host the first WordCamp US: Chattanooga, Chicago, Detroit, Orlando, Philadelphia, and Phoenix. It&#8217;s possible the first WordCamp US will be held in 2016 so we can organize the best first WordCamp US imaginable.</p>\n<p>At this time, there are 28 <a href=\"https://central.wordcamp.org/schedule/\">WordCamps</a>, in 9 different countries, that have announced their dates for the rest of 2015. Twelve of these have tickets on sale:</p>\n<ul>\n<li><a href=\"https://columbus.wordcamp.org/2015/\">WordCamp Columbus</a>, Columbus, Ohio: July 17-18</li>\n<li><a href=\"https://scranton.wordcamp.org/2015/\">WordCamp Scranton</a>, Scranton, Pennsylvania: July 18</li>\n<li><a href=\"https://boston.wordcamp.org/2015/\">WordCamp Boston</a>, Boston, Massachussetts: July 18-19</li>\n<li><a href=\"https://milwaukee.wordcamp.org/2015/\">WordCamp Milwaukee</a>, Milwaukee, Wisconsin: July 24-26</li>\n<li><a href=\"https://asheville.wordcamp.org/2015/\">WordCamp Asheville</a>, Asheville, North Carolina: July 24-26</li>\n<li><a href=\"https://kansai.wordcamp.org/2015/\">WordCamp Kansai</a>, Kansai, Japan: July 25-26</li>\n<li><a href=\"https://fayetteville.wordcamp.org/2015/\">WordCamp Fayetteville</a>, Fayetteville, Arkansas: July 31-August 2</li>\n<li><a href=\"https://brighton.buddycamp.org/2015/\">BuddyCamp Brighton</a>,  Brighton, UK: August 8</li>\n<li><a href=\"https://vancouver.wordcamp.org/2015/\">WordCamp Vancouver, BC,</a> Vancouver, BC, Canada: August 15-16</li>\n<li><a href=\"https://russia.wordcamp.org/2015/\">WordCamp Russia</a>, Moscow, Russia: August 15</li>\n<li><a href=\"https://norrkoping.wordcamp.org/2015/\">WordCamp Norrköping</a>, Norrköping, Sweden: August 28-29</li>\n<li><a href=\"https://croatia.wordcamp.org/2015/\">WordCamp Croatia</a>, Rijeka, Croatia: September 5-6</li>\n<li><a href=\"https://krakow.wordcamp.org/2015/\">WordCamp Krakow,</a>  Krakow, Poland: September 12-13</li>\n<li><a href=\"https://nyc.wordcamp.org/2015/\">WordCamp NYC</a>, New York City, New York: October 30-November 1</li>\n</ul>\n<p>The other 16 events don’t have tickets on sale yet, but they’ve set their dates! Subscribe to the sites to find out when registration opens:</p>\n<ul>\n<li><a href=\"https://pune.wordcamp.org/2015/\">WordCamp Pune</a>, Pune, India: September 6</li>\n<li><a href=\"https://capetown.wordcamp.org/2015/\">WordCamp Cape Town</a>, Cape Town, South Africa: September 10-11</li>\n<li><a href=\"https://baltimore.wordcamp.org/2015/\">WordCamp Baltimore</a>, Baltimore, Maryland: September 12</li>\n<li><a href=\"https://slc.wordcamp.org/2015/\">WordCamp Salt Lake City</a>, Salt Lake City, Utah: September 12</li>\n<li><a href=\"https://lithuania.wordcamp.org/2015/\">WordCamp Lithuania</a>, Vilnius, Lithuania: September 19</li>\n<li><a href=\"https://vegas.wordcamp.org/2015\">WordCamp Vegas</a>, Las Vegas, Nevada: September 19-20</li>\n<li><a href=\"https://switzerland.wordcamp.org/2015/\">WordCamp Switzerland</a>, Zurich, Switzerland: September 19-20</li>\n<li><a href=\"https://tampa.wordcamp.org/2015/\">WordCamp Tampa</a>, Tampa, Florida: September 25-27</li>\n<li><a href=\"https://rhodeisland.wordcamp.org/2015/\">WordCamp Rhode Island</a>,  Providence, Rhode Island: September 25-26</li>\n<li><a href=\"https://la.wordcamp.org/2015/\">WordCamp Los Angeles</a>, Los Angeles, California: September 26-27</li>\n<li><a href=\"https://denmark.wordcamp.org/2015/\">WordCamp Denmark,</a>  Copenhagen, Denmark: October 3-4</li>\n<li><a href=\"https://toronto.wordcamp.org/2015\">WordCamp Toronto</a>, Toronto, Ontario, Canada: October 3-4</li>\n<li><a href=\"https://hamptonroads.wordcamp.org/2015/\">WordCamp Hampton Roads, </a>  Virginia Beach, VA, USA: October 17</li>\n<li><a href=\"https://annarbor.wordcamp.org/2015\">WordCamp Ann Arbor</a>, Ann Arbor, Michigan: October 24</li>\n<li><a href=\"https://portland.wordcamp.org/2015/\">WordCamp Portland</a>,  Portland, OR: October 24-25</li>\n</ul>\n<p>On top of all those exciting community events, there are 26 WordCamps in pre-planning as they look for the right event space.  If you have a great idea for a free or cheap WordCamp venue in any of the below locations, get in touch with the organizers through the WordCamp sites:</p>\n<ul>\n<li><a href=\"https://dfw.wordcamp.org/2015/\">WordCamp DFW</a>:  Dallas/Fort Worth, Texas</li>\n<li><a href=\"https://riodejaneiro.wordcamp.org/2015/\">WordCamp Rio</a>: Rio de Janeiro, Brazil</li>\n<li><a href=\"https://saratoga.wordcamp.org/2015/\">WordCamp Saratoga</a>:  Saratoga Springs, New York</li>\n<li><a href=\"https://sofia.wordcamp.org/2015\">WordCamp Sofia</a>:  Sofia, Bulgaria</li>\n<li><a href=\"https://austin.wordcamp.org/2015/\">WordCamp Austin</a>:  Austin, TX</li>\n<li><a href=\"https://ottawa.wordcamp.org/2015/\">WordCamp Ottawa</a>:  Ottawa, Canada</li>\n<li><a href=\"https://charleston.wordcamp.org/2015/\">WordCamp Charleston</a>:  Charleston, South Carolina</li>\n<li><a href=\"https://chicago.wordcamp.org/2015/\">WordCamp Chicago</a>:  Chicago, Illinois</li>\n<li><a href=\"https://albuquerque.wordcamp.org/2015/\">WordCamp Albuquerque</a>:  Albuquerque, New Mexico</li>\n<li><a href=\"https://prague.wordcamp.org/2015/\">WordCamp Prague</a>:  Prague, Czech Republic</li>\n<li><a href=\"https://seoul.wordcamp.org/2014/\">WordCamp Seoul: </a>Seoul, South Korea</li>\n<li><a href=\"https://louisville.wordcamp.org/2014/\">WordCamp Louisville</a>: Louisville, Kentucky</li>\n<li><a href=\"https://omaha.wordcamp.org/2015/\">WordCamp Omaha</a>:  Omaha, Nebraska</li>\n<li><a href=\"https://grandrapids.wordcamp.org/2015/\">WordCamp Grand Rapids</a>:  Grand Rapids, Michigan</li>\n<li><a href=\"https://easttroy.wordcamp.org/2015/\">WordCamp East Troy</a>:  East Troy, Wisconsin</li>\n<li><a href=\"https://palmademallorca.wordcamp.org/2015\">WordCamp Mallorca</a>: Palma de Mallorca, Spain</li>\n<li><a href=\"https://edinburgh.wordcamp.org/2015/\">WordCamp Edinburgh</a>:  Edinburgh, United Kingdom</li>\n<li><a href=\"https://orlando.wordcamp.org/2015/\">WordCamp Orlando</a>:  Orlando, Florida</li>\n<li><a href=\"https://mexico.wordcamp.org/2015/\">WordCamp Mexico City</a>:  Mexico City, Mexico</li>\n<li><a href=\"https://netherlands.wordcamp.org/2015/\">WordCamp Netherlands</a>:  Utrecht, Netherlands</li>\n<li><a href=\"https://phoenix.wordcamp.org/2016/\">WordCamp Phoenix</a>:  Phoenix, Arizona</li>\n<li><a href=\"https://saopaulo.wordcamp.org/2015/\">WordCamp São Paulo</a>:  São Paulo, Brazil</li>\n<li><a href=\"https://manchester.wordcamp.org/2015/\">WordCamp Manchester</a>:  Manchester, United Kingdom</li>\n<li><a href=\"https://tokyo.wordcamp.org/2015/\">WordCamp Tokyo</a>:  Tokyo, Japan</li>\n<li><a href=\"https://lima.wordcamp.org/2015/\">WordCamp Lima</a>:  Lima, Peru</li>\n<li><a href=\"https://seattle.wordcamp.org/2015-beginner/\">WordCamp Seattle: Beginner</a>: Seattle, WA</li>\n</ul>\n<p>Don’t see your city on the list, but yearning for a local WordCamp? WordCamps are organized by local volunteers from the WordPress community, and we have a whole team of people to support new organizers setting up a first-time WordCamp. If you want to bring WordCamp to town, check out how you can <a href=\"https://central.wordcamp.org/become-an-organizer/\">become a WordCamp organizer</a>!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/news/2015/07/wordcamps-update/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Jul 2015 01:30:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3738\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.3 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4352:\"<p>WordPress 4.3 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta1.zip\">download the beta here</a> (zip).</p>\n<p>4.3 is due out next month, but to get there, we need your help testing what we&#8217;ve been working on:</p>\n<ul>\n<li><strong>Menus</strong> can now be managed with the <strong>Customizer</strong>, which allows you to live preview changes you’re making without changing your site for visitors until you’re ready. We&#8217;re especially interested to know if this helps streamline the process of setting up your site (<a href=\"https://core.trac.wordpress.org/ticket/32576\">#32576</a>).</li>\n<li>Take control of another piece of your site with the <strong>Site Icon</strong> feature. You can now manage your site’s favicon and app icon from the admin area (<a href=\"https://core.trac.wordpress.org/ticket/16434\">#16434</a>).</li>\n<li>We put a lot of work into <strong>Better Passwords</strong> throughout WordPress. Now, WordPress will limit the life time of password resets, no longer send passwords via email, and generate and suggest secure passwords for you. Try it out and let us know what you think! (<a href=\"https://core.trac.wordpress.org/ticket/32589\">#32589</a>)</li>\n<li>We’ve also added <strong>Editor Improvements</strong>. Certain text patterns are automatically transformed as you type, including <code>*</code> and <code>-</code> transforming into unordered lists, <code>1.</code> and <code>1)</code> for ordered lists, <code>&gt;</code> for blockquotes and two to six number signs (<code>#</code>) for headings (<a href=\"https://core.trac.wordpress.org/ticket/31441\">#31441</a>).</li>\n<li>We’ve improved the <strong>list view</strong> across the admin dashboard. Now, when you view your posts and pages <strong>on small screen devices</strong>, columns are not truncated and can be toggled into view (<a href=\"https://core.trac.wordpress.org/ticket/32395\">#32395</a>).</li>\n</ul>\n<p><strong>Developers</strong>: There have been a few of changes for you to test as well, including:</p>\n<ul>\n<li><strong>Taxonomy Roadmap:</strong> Terms shared across multiple taxonomies will <a href=\"https://make.wordpress.org/core/2015/06/09/eliminating-shared-taxonomy-terms-in-wordpress-4-3/\">now be split</a> into separate terms on update to 4.3. Please let us know if you hit any snags (<a href=\"https://core.trac.wordpress.org/ticket/30261\">#30261</a>).</li>\n<li>Added <code>singular.php</code> to the template hierarchy as a fallback for <code>single.php</code> and <code>page.php</code>. (<a href=\"https://core.trac.wordpress.org/ticket/22314\">#22314</a>).</li>\n<li>The old Distraction Free Writing code was removed (<a href=\"https://core.trac.wordpress.org/ticket/30949\">#30949</a>).</li>\n<li>List tables now can (and often should) have a primary column defined. We’re working on a fallback for existing custom list tables but right now they likely have some breakage in the aforementioned responsive view (<a href=\"https://core.trac.wordpress.org/ticket/25408\">#25408</a>).</li>\n</ul>\n<p>If you want a more in-depth view of what changes have made it into 4.3, <a href=\"https://make.wordpress.org/core/tag/4-3/\">check out all 4.3-tagged posts</a> on the main development blog.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.3\">everything we’ve fixed</a> so far.</p>\n<p>Happy testing!</p>\n<p><em>Site icons for all</em><br />\n<em>Live preview menu changes</em><br />\n<em>Four three beta now</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.2 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/05/wordpress-4-2-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2015/05/wordpress-4-2-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 07 May 2015 02:24:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3718\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:355:\"WordPress 4.2.2 is now available. This is a critical security release for all previous versions and we strongly encourage you to update your sites immediately. Version 4.2.2 addresses two security issues: The Genericons icon font package, which is used in a number of popular themes and plugins, contained an HTML file vulnerable to a cross-site [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Samuel Sidler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3213:\"<p>WordPress 4.2.2 is now available. This is a <strong>critical security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>Version 4.2.2 addresses two security issues:</p>\n<ul>\n<li>The Genericons icon font package, which is used in a number of popular themes and plugins, contained an HTML file vulnerable to a cross-site scripting attack. All affected themes and plugins hosted on <a href=\"https://wordpress.org/\">WordPress.org</a> (including the Twenty Fifteen default theme) have been updated today by the WordPress security team to address this issue by removing this nonessential file. To help protect other Genericons usage, WordPress 4.2.2 proactively scans the wp-content directory for this HTML file and removes it. Reported by Robert Abela of <a href=\"http://netsparker.com\">Netsparker</a>.</li>\n<li>WordPress versions 4.2 and earlier are affected by a <a href=\"https://wordpress.org/news/2015/04/wordpress-4-2-1/\">critical cross-site scripting vulnerability</a>, which could enable anonymous users to compromise a site. WordPress 4.2.2 includes a comprehensive fix for this issue. Reported separately by Rice Adu and Tong Shi from Baidu[X-team].</li>\n</ul>\n<p>The release also includes hardening for a potential cross-site scripting vulnerability when using the visual editor. This issue was reported by Mahadev Subedi.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.2 also contains fixes for 13 bugs from 4.2. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.2\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=32418&amp;stop_rev=32324\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.2</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.2.</p>\n<p>Thanks to everyone who contributed to 4.2.2:</p>\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Mike Adams</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/taka2\">taka2</a>, and <a href=\"https://profiles.wordpress.org/willstedt\">willstedt</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/05/wordpress-4-2-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 19 Aug 2015 05:45:32 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:10:\"x-pingback\";s:37:\"https://wordpress.org/news/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Tue, 18 Aug 2015 21:45:57 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("11870","_transient_timeout_feed_867bd5c64f85878d03a060509cd2f92c","1439545341","no");
INSERT INTO wp_options VALUES("11871","_transient_feed_867bd5c64f85878d03a060509cd2f92c","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: A Look at Why Some Frontend Developers are Decoupling WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47735\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://wptavern.com/decoupling-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5540:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/DecoupledWordPressFeaturedImage.png\"><img class=\"size-full wp-image-47758\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/DecoupledWordPressFeaturedImage.png?resize=677%2C240\" alt=\"Decoupled WordPress Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/77742560@N06/7782209734\">Coupler: Immigration Museum</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<hr />\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/Emily_Miller1.jpg\"><img class=\"alignright wp-image-47736 size-thumbnail\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/Emily_Miller1.jpg?resize=150%2C150\" alt=\"Emily_Miller1\" /></a>This post was contributed by <a href=\"https://twitter.com/emilymiller317\">Emily Miller</a>. A native Hoosier, Emily now lives in San Francisco, CA, and is a content specialist at hosting platform <a href=\"http://pantheon.io\">Pantheon</a>. She enjoys exploring the great outdoors with her dog and researching the latest trends in open source.</p>\n<hr />\n<p>WordPress developers are getting serious about developing flexible, powerful websites of all sizes. One trend, started as a way to break free of the constraints of traditional WordPress theming, is using a decoupled architecture to customize the frontend.</p>\n<p>There are certainly pros and cons to this method, and this post aims to examine the various reasons why some frontend developers are implementing a headless WordPress.</p>\n<h2>What Is Decoupled WordPress?</h2>\n<p>Decoupled WordPress is the separation of the backend from the frontend. WordPress is traditionally monolithic, giving you the dashboard, plugins and themes all-in-one. Many developers have been playing around with decoupled builds lately with the primary motivation of creating a better user experience.</p>\n<p>Decoupling allows you to experiment with different JavaScript frameworks, such as Angular, to build a truly custom experience for users. That’s not to say everyone should go headless, but rather that decoupling is an option if your project has a set of requirements that call for a more flexible build.</p>\n<p>In these cases, decoupling allows WordPress to do what it does best, content organization and editing while avoiding a lot of the complex custom code that goes into developing for a set CMS.</p>\n<h2>Why Are Developers Adopting It for the Frontend?</h2>\n<p>Translating modern design into a tightly coupled CMS can be tricky, so separating the UX layer of a site allows developers to leverage the tools they want, making the frontend truly agile and the end-user experience more friendly.</p>\n<p>For the right use case it’s a win-win situation. Use the best tools for frontend development, while making the WordPress authoring experience even better to empower everyone! Quite a few developers have mentioned that decoupled projects renew their love for a chosen CMS, and that the flexibility makes it fun to work with again.</p>\n<p>Another benefit of a decoupled architecture is the upgrade process. A headless build simplifies future updates by not requiring a CMS upgrade, ultimately saving a great deal of time and money come redesign. Frontend developers can now work at their own pace, independent of the CMS’s timeline, and focus on the best language for the task at hand.</p>\n<p>A good case study of a decoupled WordPress build is <a href=\"http://www.pixotech.com/\">Pixo Tech’s</a> project with the University of Illinois. They chose the best frontend tools for the job, understanding that frontend developers and CMS developers are not necessarily one in the same. For the nitty-gritty of the project, <a href=\"https://pantheon.io/what-know-about-decoupled-cms-recording\">check out this webinar. </a></p>\n<h2>What’s the Catch?</h2>\n<p>As mentioned above, although a decoupled architecture may sound like that captivating and challenging project we’ve all been waiting for, it still has its pitfalls and is probably not the route for every project.</p>\n<p>Decoupling WordPress is a more customized, complex build that could mean more time and money up front, although cost-effective in the long run. It also means losing the content previews, easy string translations and UI oriented plugins and themes we’re used to in a coupled architecture.</p>\n<p>Additionally, decoupled WordPress is still a young concept, and best practices are still emerging. There’s no set way to do it, and you certainly won’t find a how-to tailored to your specific needs.</p>\n<h2>How Would You Approach a Decoupled Build?</h2>\n<p>The <a href=\"https://github.com/WP-API/WP-API\">WP REST API</a> is a great way to facilitate a decoupled build—you can download it and then decide how much of your site you want to separate. Integrated into core and available to all WordPress users, the plugin provides an easy-to-use REST API, available via HTTP.</p>\n<p>This gives developers a great deal of flexibility for creating applications that use a WordPress backend and brings WordPress one step closer to being a complete application framework.</p>\n<h2>What Now?</h2>\n<p>Decoupled CMS is still a new concept, and as a community it is important to share our methods and what we learn as we continue to experiment with such projects, ultimately standardizing on best practices for the future.The possibilities for decoupled are endless, and it’s up to the open-source community to lead the charge and document what we learn.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 21:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WordPress for iOS: Version 5.4 Adds Statistical Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47740\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/wordpress-for-ios-version-5-4-adds-statistical-insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2285:\"<p>WordPress for iOS: Version 5.4 is <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">available on the app store</a> and includes a couple of new features. To compliment the <a href=\"http://wptavern.com/wordpress-for-ios-5-3-released-with-refreshed-stats-and-a-new-layout-for-posts-and-pages\">improvements to stats in 5.3</a>, 5.4 adds a new stats screen called insights.</p>\n<p>Insights is similar to the Right Now widget in the WordPress dashboard in that it displays a summary of key statistics for a site including, total number of published posts, views, visitors, and the best traffic day. There&#8217;s also a section that displays the current day&#8217;s stats.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/IMG_7433.png\"><img class=\"size-large wp-image-47744\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/IMG_7433.png?resize=282%2C500\" alt=\"Stat Insights\" /></a>Stat Insights\n<p>Prior to 5.4, you could only add images to posts that were stored on the device. WordPress for iOS 5.4 adds the ability to insert images from the WordPress media library.</p>\n<p>To add an image from the WordPress media library, select media library from the menu at the top of the screen. If you have a lot of items in the media library, it may take a few minutes to load.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/WPiPhoneMediaLibrary.png\"><img class=\"aligncenter size-large wp-image-47746\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/WPiPhoneMediaLibrary.png?resize=500%2C399\" alt=\"WP For iOS 5.4 Media Library Selection\" /></a>Other improvements include the ability to search the My Sites list and viewing embedded images in comments. This makes it easier to see the full context of a comment without having to view it in a different part of the app.</p>\n<p>Last but not least, the team fixed a bug that caused the app to not restore its state properly. WordPress for iOS: Version 5.4 is <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">free and available</a> on the app store. If you encounter any issues, you&#8217;re encouraged to report them on the <a href=\"https://ios.forums.wordpress.org/\">WordPress for iOS support forums</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 20:15:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Short Interview With Nikolay Bachiyski WordPress’ Security Czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2331:\"<p>While on stage at <a href=\"https://europe.wordcamp.org/2015/\">WordCamp Europe</a> answering a question related to WordPress’ security track record, Matt Mullenweg named <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a> as the first Security Czar for the <a href=\"https://wordpress.org/\">WordPress project</a>.</p>\n<p>I interviewed Bachiyski to learn why the role was created and what its purpose is.</p>\n<p><strong>What are the responsibilities of your new role?</strong></p>\n<p>My responsibilities are to coordinate the security efforts of<span class=\"Apple-converted-space\"> </span><a href=\"http://wordpress.org/\" target=\"_blank\" rel=\"noreferrer\">WordPress.org</a><span class=\"Apple-converted-space\">, </span>mostly with incident response and to make sure we respond quickly, have solid fixes, and make sure everyone involved is informed.</p>\n<p><strong>What circumstances led to this role&#8217;s creation?<br />\n</strong></p>\n<p>Nothing too spicy around the creation of the role. As the volume of requests increased, we realized a bit more structure would be helpful so that we are more focused and use our resources wisely.</p>\n<p><strong>Will you only handle security issues for the open source project or will you also help with Automattic’s bounty program as well?</strong></p>\n<p>There are other colleagues at Automattic who are responsible for the bounty program.</p>\n<p><strong>How important are the connections and trust you’ve established over the last 11 years to your role?</strong></p>\n<p>Offline relationships are very important in an online community and I am lucky to know many of the members of the security team in person. This definitely makes working with them easier.</p>\n<h2>Learn More About the WordPress Security Team</h2>\n<p>If you&#8217;d like to learn more about who&#8217;s on the WordPress security team, what they do, and how they handle security releases, listen to my interview with Gary Pendergast.</p>\n<p>Pendergast who works for Automattic, is a WordPress core contributor, and a member of the WordPress core security team. In the interview, we discuss what happened behind the scenes before <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\">4.2.3 was released</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 18:26:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: WPWeekly Episode 203 – Interview With Kiko Doran Co-organizer of Prestige Conference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47721&preview_id=47721\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/wpweekly-episode-203-interview-with-kiko-doran-co-organizer-of-prestige-conference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2165:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://kikodoran.com/\">Kiko Doran</a>, co-organizer of <a href=\"http://prestigeconf.com/\">Prestige conference</a>. Doran describes how he discovered WordPress in 2009 and explains the origin of Prestige, a career and business development conference.</p>\n<p>We discuss the <a href=\"http://wptavern.com/the-mantra-of-family-comes-first\">mantra of family first </a>and how Brazilian Jiu Jitsu helps him in his everyday life. Near the end of the interview, we learn Prestige 4 is in the planning stages.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-plugin-directory-surpasses-one-billion-total-downloads\">WordPress Plugin Directory Surpasses One Billion Total Downloads</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/site-import/\">Site Import</a> allows you to import posts and items from other websites without having to export anything. The content is extracted directly from the site.</p>\n<p><a href=\"https://wordpress.org/plugins/followprice/\">Followprice</a> adds a button to your storefront that when clicked, saves products into a universal wish list. This allows visitors to subscribe and receive price or stock alerts from your store.</p>\n<p><a href=\"https://wordpress.org/plugins/revision-strike/\">Revision Strike</a> is designed to automatically remove unneeded revisions on older, published posts.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 19th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #203:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 16:31:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt: Avis GPS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://ma.tt/2015/08/avis-gps/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2713:\"<p>After an amazing WordCamp Scranton on Saturday I was heading to a friend&#8217;s birthday on Long Island on Sunday, a few people were surprised I had flown from New York and said driving took about the same amount of time when you factor in all the airport hassle.</p>\n<p>I Google Mapped it and it did look like it was only 5-6 hours from Scranton to where I was going. Being a born and raised Texan, I love a good drive, and I probably haven&#8217;t had a proper road trip since my sister&#8217;s birthday a few years ago when we went up Highway 1. I&#8217;ve also never driven on the East Coast, and it seemed like there were some really pretty parks and lakes in between Scranton and Long Island so I ended up going to the airport anyway because that&#8217;s where the rental cars were.</p>\n<p>I like <a href=\"http://www.avis.com/\">Avis</a>. They try harder. <img src=\"http://i2.wp.com/s.ma.tt/blog/wp-includes/images/smilies/simple-smile.png?w=604\" alt=\":)\" class=\"wp-smiley\" /> One thing they do that&#8217;s pretty cool is sell  decent cables, USB wall chargers, and car chargers for a cheap price right at the check-in desk. (I always carry my own car charger, <a href=\"http://www.amazon.com/Incase-Speed-Charger-Lightning-Cable/dp/B00P7Y6M2Y/\">this is my current pick</a>. It&#8217;s super-handy in Ubers as well.) Amazingly though they still try to give you one of those Garmin GPS units that&#8217;s worse than your smartphone in every possible way. I&#8217;m sure it&#8217;s a money maker, otherwise the only reasonable thing to do would be provide <a href=\"http://www.amazon.com/dp/B00O5JARCI\">a smartphone mount</a> (or have one already set up in the car) rather than saddling people with an <a href=\"http://www.amazon.com/gp/bestsellers/electronics/559938/ref=zg_b_bs_559938_1\">archaic, non-networked navigation device</a> that has no idea about construction or traffic.</p>\n<p>I ended up going to a Walmart that was nearby to pick up a car mount (price, $12) that ended up being a life-saver for the trip. <strong>I also believe that every person in tech should visit Walmart at least once a year, and spend time in their technology section.</strong> It&#8217;s good to understand and see how people who don&#8217;t live for technology every day interact with it. It&#8217;s eye-opening, and it&#8217;s handy to know what&#8217;s in stock in case you need 50 feet of ethernet at 4 AM.</p>\n<p>Dropping the car off in Manhattan, it looks like they charged me $20 for a GPS which I don&#8217;t even have, so now going to need to sort out both the fee and the &#8220;missing&#8221; GPS system.</p>\n<p>tl; dr: Smart car rental companies should ditch the GPS, provide smartphone mounts instead.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 02:44:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: Filled With Wonder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45288\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://ma.tt/2015/08/filled-with-wonder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"<blockquote><p>Teach when you are filled with wonder, before you become a boring expert.</p>\n<p>— Mark Pilgrim</p></blockquote>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Aug 2015 01:44:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Organizing Team Explains Why Philadelphia Should Host WordCamp US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47699\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wptavern.com/organizing-team-explains-why-philadelphia-should-host-wordcamp-us\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2198:\"<p>When organizing teams in different <a href=\"http://wptavern.com/wordcamp-us-2015-now-accepting-applications-for-host-city\">cities applied to host</a> WordCamp US earlier this year, they provided a substantial amount of information through the application process. While <a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">Philadelphia will host</a> the event in 2015 and 2016, their application is not public information.</p>\n<p>Juliana Reyes, who writes for <a href=\"http://technical.ly/philly\">Technical.ly Philly</a>, acquired and <a href=\"http://technical.ly/philly/2015/08/11/wordcamp-us-philadelphia-wordpress-devs/\">published a few</a> of the responses from the organizing team&#8217;s application, specifically questions four, nine, ten, and eleven.</p>\n<p>Question nine on the application asks, why do you think your city should host WordCamp US 2015? The organizing team responded:</p>\n<blockquote>\n<p dir=\"ltr\">Philadelphia is the birthplace of our nation. The United States started here, and so should WordCamp US.</p>\n<p dir=\"ltr\">We’re ideally situated on the East Coast between New York and Washington DC, and the halfway point between the West Coast and parts of Europe.</p>\n<p dir=\"ltr\">With a population of 1.5 million, it is the 5th largest city in North America, and is a cultural hub for all things food, music, art, and technology. It is well-known for its many excellent medical and educational facilities, including the University of Pennsylvania, Temple University, Drexel University, and the University of the Sciences.</p>\n<p dir=\"ltr\">With over 1,200 daily inbound and outbound flights, Philadelphia is easy to reach from anywhere in the world. The average hotel room and cost of living, is far below any other major East Coast city, and nowhere else has cheesesteaks like we do.</p>\n</blockquote>\n<p dir=\"ltr\">I&#8217;ve yet to visit Philadelphia but one thing I&#8217;ve learned is that residents take their reputation for cheesesteaks seriously. Be sure to read <a href=\"http://technical.ly/philly/2015/08/11/wordcamp-us-philadelphia-wordpress-devs/\">the post</a> to see the team&#8217;s responses to the other three questions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 18:58:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: ThemeConf a Conference for Front-End Developers and Designers September 2nd-4th, 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47686\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://wptavern.com/themeconf-a-conference-for-front-end-developers-and-designers-september-2nd-4th-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2009:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/ThemeConfLogo.png\"><img class=\"alignright size-full wp-image-47688\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/ThemeConfLogo.png?resize=215%2C181\" alt=\"ThemeConf Logo\" /></a><a href=\"http://themeconf.com/\">ThemeConf</a> is a new conference set to take place September 2nd-4th, 2015, in Keswick, England aimed at front-end developers and designers. Confirmed speakers include a handful of Automattic theme wranglers, Noel Tock of Human Made, freelancer Adam Onishi, and Chris Hutchinson of The Times.</p>\n<p>The session schedule is expected to be released later this week however, here are some of the topics that will be covered at the event.</p>\n<ul>\n<li>Craft, workflow and best practices</li>\n<li>Browser performance and developer tools</li>\n<li>Design and photography</li>\n<li>JavaScript and REST APIs</li>\n<li>User experience</li>\n<li>Build tools</li>\n</ul>\n<p>Jack Lenox and Tammie Lister, who are the primary organizers of the event, originally came up with the idea for ThemeConf at the Automattic UK Christmas dinner, &#8220;Lenox wanted to bring a conference to where he lives in the Lake district and I wanted to do one focusing on themes,&#8221; Lister said.</p>\n<p>The two have been planning the event since January of this year. Although most of the confirmed speakers work with WordPress, ThemeConf is not dedicated to it, &#8220;It&#8217;s geared to those making themes in general and working on the front end. We have tried hard not to focus on WordPress,&#8221; Lister said.</p>\n<p><a href=\"https://ti.to/themeconf/2015\">Tickets for ThemeConf</a> are £49 and £99 respectively. The £49 tickets are for speaker sessions only while the £99 tickets include access to a workshop on using the REST API and lunch. Accommodations in the Lake District two hours from Manchester, Glasgow, Edinburgh, Newcastle, Liverpool and Leeds are available through <a href=\"http://www.keswick.org/\">Keswick.org.</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 16:37:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: $46M Scam\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://ma.tt/2015/08/46m-scam/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"<p>An incredible story: <a href=\"http://krebsonsecurity.com/2015/08/tech-firm-ubiquiti-suffers-46m-cyberheist/\">Tech Firm Ubiquiti Suffers $46M Cyberheist</a>. Notable for two reasons: I love Ubiquiti&#8217;s products, <a href=\"https://www.ubnt.com/products/#enterprise\">especially their Unifi line</a>, and I&#8217;ve never heard of phishing getting so much from a single victim.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 06:33:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: WordPress Plugin Directory Surpasses One Billion Total Downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47673\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/wordpress-plugin-directory-surpasses-one-billion-total-downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1706:\"<p>The WordPress project achieved a milestone earlier today as the official WordPress plugin directory <a href=\"https://wordpress.org/plugins/\">surpassed one billion</a> total downloads.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/1billiondownloads.png\"><img class=\"size-full wp-image-47674\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/1billiondownloads.png?resize=944%2C312\" alt=\"One billion total plugin downloads\" /></a>More than one billion total downloads\n<p>According to Scott Reilly who helps maintain WordPress.org, we&#8217;ll never know which plugin generated the one billionth download. That&#8217;s because WordPress.org doesn&#8217;t log information that matches downloads to plugins.</p>\n<p>&#8220;A download counter exists for each plugin for each day and the total amount is the summation of all those daily download counts,&#8221; Reilly said.</p>\n<p>As WordPress&#8217; <a href=\"http://w3techs.com/technologies/details/cm-wordpress/all/all\">market share</a> continues to grow, so does the amount of downloads from the plugin directory. The following numbers are the total amount of downloads from March 2006 to August 2015. This year, the directory is on pace to serve more than 300 million downloads.</p>\n<ul>\n<li>March 2006  191,567</li>\n<li>2007  2,845,802</li>\n<li>2008  15,130,856</li>\n<li>2009  49,822,116</li>\n<li>2010  72,342,598</li>\n<li>2011  108,501,907</li>\n<li>2012  141,609,682</li>\n<li>2013  182,236,517</li>\n<li>2014  241,142,505</li>\n<li>January 2015 to August 2015  186,243,700</li>\n</ul>\n<p>It took nine years for the plugin directory to reach one billion downloads, when do you think it will reach two billion?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 03:41:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: SkiPress a Week Long Excursion in the French Alps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47654\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/skipress-a-week-long-excursion-in-the-french-alps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1333:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/SkiPressFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-47658\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/SkiPressFeaturedImage.png?resize=852%2C269\" alt=\"SkiPress Featured Image\" /></a>If you enjoy skiing and WordPress, mark your calendars for <a href=\"http://skipressweek.com/\">SkiPress</a>, November 21-28, 2015. SkiPress is a week long excursion to Serre Chevalier, a ski resort in the French Alps. The cottage can hold up to 15 people where attendees can ski, discuss WordPress, develop code, or disconnect from technology.</p>\n<p><a href=\"http://skipressweek.com/\">Bernard-Jacquet</a> who writes for <a href=\"http://wp-spread.com\" target=\"_blank\">WP-spread</a>, and helps organize the local WordPress meetup in Grenoble, France, is organizing the event.</p>\n<p>Rooms at the cottage cost 350 euros. This amount covers the room for a week plus dinner at two restaurants. Prepare to bring some extra cash as the bus, skipass, and ski rental are additional costs.</p>\n<p>There&#8217;s not an official deadline to book a room but the sooner you book the better. If you&#8217;re interested in booking a room, please <a href=\"http://skipressweek.com/\">contact Berard-Jacquet</a> as soon as possible so he can make arrangements.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 20:29:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Richard Best Publishes Human Readable Version of the GPLv2 License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/richard-best-publishes-human-readable-version-of-the-gplv2-license\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2234:\"<p>WordPress is licensed under the <a href=\"https://wordpress.org/about/gpl/\">GPLv2</a> and the four freedoms it allows is considered to be its <a href=\"http://ma.tt/2014/01/four-freedoms/\">Bill of Rights</a>. The four freedoms are:</p>\n<ol start=\"0\">\n<li>The freedom to run the program, for any purpose.</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish.</li>\n<li>The freedom to redistribute copies so you can help your neighbor.</li>\n<li>The freedom to distribute copies of your modified versions, giving the community a chance to benefit from your changes.</li>\n</ol>\n<p>There is a lot more to the GPL than the four freedoms listed above however, the license details can be difficult to read and decipher. Richard Best, a qualified lawyer in New Zealand, England, and Wales, has published a <a href=\"http://wpandlegalstuff.com/a-human-readable-summary-of-the-gpl/\">human readable summary</a> of the GPL license.</p>\n<p>Inspired by how Creative Commons offers a <a href=\"http://creativecommons.org/licenses/by/3.0/\">human readable version</a> of its licenses, the summary explains the core concepts of the GPL and outlines the position in relation to copying, distribution, fees, modifications/derivative works, distributing non-source forms, termination, and downstream licensing.</p>\n<p>It&#8217;s important to note that the document is not endorsed by the Free Software Foundation nor a substitute for the full license text.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/GPLSummarySample2.png\"><img class=\"size-full wp-image-47647\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/GPLSummarySample2.png?resize=705%2C554\" alt=\"Sample of the human readable summary of the GPL\" /></a>Sample of the human readable summary of the GPL\n<p>I encourage everyone participating in the WordPress ecosystem to read the <a href=\"https://wordpress.org/about/gpl/\">full license</a> text at least once. However, the summary does a good job explaining the core components of the GPL without having to dig into the license.</p>\n<p>If you have questions concerning the GPL, I suggest seeking legal council with a lawyer familiar with software licensing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 18:31:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WPWeekly Episode 202 – Prestige is Serious Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47628&preview_id=47628\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/wpweekly-episode-202-prestige-is-serious-business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2339:\"<p>On this week&#8217;s episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I talk about the news of the week, including the release of WordPress 4.2.4 which patches six security vulnerabilities.</p>\n<p>I shared my experience attending Prestige last weekend while Marcus describes what it was like to watch the livestream. Marcus and I closed out the show with a candid conversation on the difficulty of achieving balance between work and life.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\">WordPress 4.2.4 Patches Six Security Vulnerabilities</a><br />\n<a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\"> Recap of Prestige a Conference Geared Towards Growing Businesses</a><br />\n<a href=\"http://nickhaskins.com/2015/07/on-life-and-family/\"> Aesop Interactive LLC For Sale</a><br />\n<a href=\"http://wptavern.com/the-mantra-of-family-comes-first\"> The Mantra of Family Comes First</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/export-plugins-and-templates/\">Export Plugins and Templates</a> exports your plugins and templates to a Zip file directly from the WordPress dashboard.</p>\n<p><a href=\"https://wordpress.org/plugins/expire-posts/\">Expire posts</a> automatically expires posts in WordPress and supports custom post types.</p>\n<p><a href=\"https://wordpress.org/plugins/local-seo-and-business-listings/\">Local SEO and Business Listings</a> allows you to optimize your local business website through a step by step actionable Local SEO Guide and a host of tools proven to increase web rankings.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 12th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #202:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 16:20:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: The WordPress Core Team Receives Praise for Their Efforts to Maintain Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47619\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"http://wptavern.com/the-wordpress-core-team-receives-praise-for-their-efforts-to-maintain-security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1832:\"<p>Netanel Rubin, a vulnerability researcher for <a href=\"http://www.checkpoint.com/\">Check Point Software</a> and <a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">credited</a> for properly disclosing a security vulnerability to WordPress, published the <a href=\"http://blog.checkpoint.com/2015/08/04/wordpress-vulnerabilities-1/\">first in a trilogy of posts</a> that explains how he discovered it.</p>\n<p>The vulnerability was discovered during a full audit of WordPress&#8217; code base in which Rubin praised the efforts of the WordPress development team.</p>\n<blockquote><p>In contrast to these frequent findings in 3rd party plug-ins’ code, barebones WordPress issues are rare, as WordPress core developers are well-trained to hold high security awareness for all released code.</p>\n<p>We can confirm that during our audit of the source code, we witnessed the developers ‘leaving nothing to chance’, and implementing multiple layers of security protecting most attack vectors we could think of.</p>\n<p>WordPress developers deserve praise for their efforts to maintain such complex software in this level of security, specifically considering the presence of the notoriously trigger-happy foot-gun called PHP.</p></blockquote>\n<p>I recommend <a href=\"http://blog.checkpoint.com/2015/08/04/wordpress-vulnerabilities-1/\">reading the post</a> as it&#8217;s a brief look into the mind of a <a href=\"https://en.wikipedia.org/wiki/White_hat\">white hat</a> security researcher.</p>\n<p>Although WordPress has <a href=\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\">seen its fair share</a> of security related releases this year, it&#8217;s reassuring to hear a third-party whose job it is to penetrate software security praise WordPress&#8217; codebase.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Aug 2015 00:05:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WPTavern: The Mantra of Family Comes First\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47609\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wptavern.com/the-mantra-of-family-comes-first\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2219:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/FamilyFirstFeaturedImage.png\"><img class=\"size-full wp-image-47611\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/FamilyFirstFeaturedImage.png?resize=669%2C247\" alt=\"Family First Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/63122283@N06/11867028263\">Mama&#8217;s </a>&#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>At <a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\">Prestige over the weekend</a>, I heard a presenter say that family comes first. This isn&#8217;t the first time I&#8217;ve heard this advice but it&#8217;s becoming more prevalent. I generally hear this advice from those who are living comfortably, have two kids or more, and/or have gone through the startup process more than once.</p>\n<p>I&#8217;m a distributed worker who receives a check every two weeks. I&#8217;m married, have no kids, and write about WordPress for a living. Putting family first should be easy but it&#8217;s not. The last two years as a distributed worker, I&#8217;ve put work before family unless it&#8217;s an emergency.</p>\n<p>Two weeks ago, my wife and I had a serious conversation about the way I work and how it has negatively impacted our marriage. I&#8217;m a late owl and on most nights, my wife sleeps alone. As a distributed worker, I get to make the rules and put myself in the best environment to get the job done.</p>\n<p>The conversation with my wife involved words not fit for reproduction but everything she said was right. I&#8217;m spending too much time on digital devices and not enough with her. Our conversation was the wake up call I didn&#8217;t know I needed.</p>\n<p>It&#8217;s not easy putting family first all the time. Some argue that you need to put yourself before family so that you can provide for them. Others find a critical balance between spending time with family and getting the job done.</p>\n<p>How do you put family first when there are bills that need to be paid, sites to be built, and a constant deluge of work to be done? Please share your thoughts, experiences, and advice in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Aug 2015 01:43:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: WordPress 4.2.4 Patches Six Security Vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47605\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2004:\"<p>WordPress <a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">4.2.4 is available</a> and patches six security vulnerabilities. The vulnerabilities were discovered by outside parties and members of the WordPress core security team. This release also fixes four bugs:</p>\n<ul>\n<ul>\n<li>WPDB: When checking the encoding of strings against the database, make sure we&#8217;re only relying on the return value of strings that were sent to the database. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/32279\">#32279</a></li>\n<li>Don&#8217;t blindly trust the output of <tt>glob()</tt> to be an array. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33093\">#33093</a></li>\n<li>Shortcodes: Handle <tt>do_shortcode(\'&lt;[shortcode]\')</tt> edge cases. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33116\">#33116</a></li>\n<li>Shortcodes: Protect newlines inside of <tt>CDATA</tt>. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33106\">#33106</a></li>\n</ul>\n</ul>\n<p>It&#8217;s been a busy year for the WordPress security team. Since the beginning of the year, there has been five security releases.</p>\n<ul>\n<ul>\n<li><a href=\"https://wordpress.org/news/2015/04/wordpress-4-1-2/\">WordPress 4.1.2</a></li>\n<li><a href=\"https://wordpress.org/news/2015/04/wordpress-4-2-1/\">WordPress 4.2.1</a></li>\n<li><a href=\"https://wordpress.org/news/2015/05/wordpress-4-2-2/\">WordPress 4.2.2</a></li>\n<li><a href=\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\">WordPress 4.2.3</a></li>\n<li><a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">WordPress 4.2.4</a></li>\n</ul>\n</ul>\n<p>Users should check their sites to make sure they&#8217;re running 4.2.4. If your site hasn&#8217;t automatically updated yet, you should perform a full backup and manually update. Sites running WordPress RC 2 are safe since it fixes the same issues as 4.2.4.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 23:45:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Recap of Prestige a Conference Geared Towards Growing Businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47580\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4245:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/PrestigeconfFeaturedImage.png\"><img class=\"size-full wp-image-47595\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/PrestigeconfFeaturedImage.png?resize=677%2C268\" alt=\"Tony Perez of Sucuri\" /></a>Tony Perez of Sucuri Presenting on Security at Prestige\n<p>Over the weekend, I attended <a href=\"http://prestigeconf.com/\">Prestige</a>, a conference geared towards freelancers, entrepreneurs, and small agencies looking to grow their businesses. Unlike WordCamps, plugins, themes, and WordPress in general were rarely mentioned. Instead, sessions included high level topics such as, how to land enterprise clients, knowing when to move on to the next big thing, and the benefits of partnerships.</p>\n<p>The venue was perfect with plenty of space and the WiFi worked well. Lunch was an hour-long and provided on both days. The lunchroom can easily seat 300 people or more. Only a third of the space was used when attendees ate lunch providing a great environment to network with people.</p>\n<h2>Nancy Lyons and Technology&#8217;s Dirty Little Secret</h2>\n<p>Since I don&#8217;t deal with clients or own an agency, many of the sessions at Prestige are non-applicable to my day job. However, there is one session in particular that resonated with me. <a href=\"http://www.nancylyons.com/\">Nancy Lyons</a>, founder and CEO of <a href=\"http://www.clockwork.net/\">Clockwork</a>, shared her philosophies on hiring and getting employees engaged. Happy employees do good work but what makes them happy?</p>\n<ul>\n<li>Autonomy:  Control over time, technique, team, or task.</li>\n<li>Mastery: Make progress and get better.</li>\n<li>Purpose: Be part of something bigger.</li>\n</ul>\n<p>A lot of the tips shared by Lyons are geared towards employers but they&#8217;re just as applicable to employees. The biggest danger to agencies and freelancers is the inability to have conversations with clients about what is and isn&#8217;t possible. According to Lyons, you can love someone and still tell them what they need to hear. One of the best tips she shared is to find and have fun at work as there&#8217;s nothing wrong with having fun.</p>\n<h2>Behind the Scenes of the Livestream</h2>\n<p>Prestige is <a href=\"http://prestigeconf.com/free-livestream-minneapolis-2015/\">known for having</a> a high quality livestream where more than 1,000 people can watch the conference live. The livestream is produced by <a href=\"http://pixpromedia.com/\">PixProMedia</a>. The gentleman in charge uses a TriCaster to switch between speakers and slides during sessions. Here are a couple of photographs of his equipment.</p>\n<a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses#gallery-47580-1-slideshow\">Click to view slideshow.</a>\n<p>According to some viewers, watching the livestream was like being at the conference but is not a substitute for face-to-face interactions.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">.<a href=\"https://twitter.com/jeffr0\">@jeffr0</a> The learning is like being there.  I miss the handshakes in the hallway, meeting people face-to-face.&#10;&#10;<a href=\"https://twitter.com/hashtag/prestigeconf?src=hash\">#prestigeconf</a></p>\n<p>&mdash; Cate DeRosia (@mysweetcate) <a href=\"https://twitter.com/mysweetcate/status/627924263799009280\">August 2, 2015</a></p></blockquote>\n<p></p>\n<h2>Westwerk Is a Great Venue for After Parties</h2>\n<p>The after party was held at <a href=\"http://westwerk.com/\">Westwerk</a>, a WordPress development agency and primary sponsor of the event. Their office was perfect for an after party as it includes, a foosball table, Nintendo Wii, shuffleboard, drinks, pool table, and small offices for private conversations. It&#8217;s one of the best after parties for a conference that I&#8217;ve attended.</p>\n<h2>Prestige is Serious Business</h2>\n<p>It may seem like a WordPress conference on the surface but Prestige is geared towards business minded people. It&#8217;s highly focused and filled with information you can apply to companies in and outside of WordPress. If you want to learn how to take your business to the next level, Prestige is an excellent value.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 20:40:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: How to Avoid This Embarrassing Sharing Bug on WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47476\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://wptavern.com/how-to-avoid-embarrassing-sharing-bug-on-wordpress-com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1804:\"<p>If you use the sharing feature on WordPress.com, you may have noticed an anomaly between your post title and what&#8217;s shared to social services. Since the post title is the first field to complete when writing a post, it makes sense to fill it in even if it&#8217;s a work in progress.</p>\n<p>The sharing module on WordPress.com has a bug where the initial text in a post title is used when sharing the post to social networks. For the past several months, I&#8217;ve published many articles on WordPress.com where the text within social links does not match the text used in the post title leaving me feeling embarrassed.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/BuginAction.png\"><img class=\"size-full wp-image-47477\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/BuginAction.png?resize=728%2C482\" alt=\"WordPress.com Bug in Action\" /></a>WordPress.com Bug in Action\n<p>To avoid this embarrassment, you&#8217;ll need to alter the text used in the sharing module before publishing each post. If you&#8217;re using the New Dash interface on WordPress.com, locate the Sharing metabox as seen in the screenshot above. When you&#8217;re ready to hit the publish button, change the text to match your title.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/TheCorrectPostTitle.png\"><img class=\"size-full wp-image-47478\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/TheCorrectPostTitle.png?resize=571%2C462\" alt=\"Post Title Matches the Sharing Text\" /></a>Post Title Matches the Sharing Text\n<p>I&#8217;ve spoken to several Automattic employees at various WordPress events and they&#8217;re aware of the bug. Until it&#8217;s fixed, you&#8217;ll need to remember to change the sharing text before you publish a post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jul 2015 21:52:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WPWeekly Episode 201 – Interview With Paul Gibbs and John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47469&preview_id=47469\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://wptavern.com/wpweekly-episode-201-interview-with-paul-gibbs-and-john-james-jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2500:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://byotos.com/\">Paul Gibbs</a> and <a href=\"http://jjj.me/\">John James Jacoby</a>. Jacoby shares what he learned and accomplished <a href=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\">working on bbPress and BuddyPress</a> full-time for six months.</p>\n<p>Gibbs explains his motivation to organize the first ever <a href=\"https://brighton.buddycamp.org/2015/\">BuddyCamp Brighton, UK</a>, that takes place on August 8th. We also discuss a new working group dedicated to possibly bringing back <a href=\"http://backpress.org/\">BackPress</a>. Last but not least, Gibbs and Jacoby offer their opinions on <a href=\"http://wptavern.com/meet-peepso-buddypress-newest-competitor-in-open-source-social-networking-for-wordpress\">PeepSo</a>, a new social networking plugin for WordPress.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">Philadelphia, PA to Host WordCamp US December 4th–6th</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/gallery-for-instagram/\">Instagram Gallery</a> displays a gallery from one or more Instagram accounts.</p>\n<p><a href=\"https://wordpress.org/plugins/backup-amazon-s3/\">Amazon S3 Backup and Restore</a> enables you to create full backups to Amazon S3 and restore, duplicate, clone, or migrate your site.</p>\n<p><a href=\"https://wordpress.org/plugins/responsivevoice-text-to-speech/\">ResponsiveVoice Text To Speech</a> is a HTML5 based text-to-speech library designed to add voice features to WordPress across all smart phone, tablet, and desktop devices. It supports 51 languages through 168 voices and has no dependencies.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 5th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #201:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jul 2015 19:45:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Hong Kong Morning\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45280\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/07/hong-kong-morning/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"<p><span class=\"embed-youtube\"></span></p>\n<p>The upside of jet lag, like <a href=\"http://om.co/2015/07/10/paris-je-laime/\">Om discovering the streets of Paris</a>, are enjoying parts of the day you might not normally be awake for, like a beautiful sun rise. Here&#8217;s a time lapse I made of the Victoria Harbor in Hong Kong taken from the incredible view I have in my room.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 23:40:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Postmatic Brings 100% Realtime Commenting to WordPress with Epoch Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=44317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wptavern.com/postmatic-brings-100-realtime-commenting-to-wordpress-with-epoch-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7876:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch.jpg?resize=919%2C443\" alt=\"epoch\" class=\"aligncenter size-full wp-image-47416\" /></a></p>\n<p>The team behind <a href=\"https://gopostmatic.com/\" target=\"_blank\">Postmatic</a> is aiming to breathe new life into WordPress native comments with the 1.0 release of <a href=\"https://wordpress.org/plugins/epoch/\" target=\"_blank\">Epoch</a> today. The plugin was created to provide a Disqus alternative with faster loading and submitting for comments.</p>\n<p>Epoch&#8217;s creators set an ambitious goal for themselves on the plugin&#8217;s description page:</p>\n<blockquote><p>The goal: To provide a realtime commenting/chat experience using fully native comments while being compatible with page caching, CDNs, mobile, other comment plugins, and SEO best practices.</p></blockquote>\n<p>The plugin submits comments via AJAX, which means that comments appear instantly within the conversation without refreshing the page. The experience is designed to be so fast that it blurs the line between commenting and chatting, as comments from other readers also show up automatically with the same speed. The video below shows the plugin in action and a <a href=\"https://gopostmatic.com/epoch/#reply-title\" target=\"_blank\">live demo of Epoch</a> is available on the Postmatic website.</p>\n<p></p>\n<p></p>\n<p>Epoch <a href=\"https://wordpress.org/plugins/epoch/changelog/\" target=\"_blank\">version 1.0</a> boasts compatibility with virtually any WordPress theme. The plugin will attempt to integrate with your theme via one of three ways:</p>\n<ul>\n<li>The first tries to continue using your existing comment template while still offering all the performance gains</li>\n<li>The second overrides your comment template but inherits typography and colors from your theme</li>\n<li>The third totally replaces your comment template à la Disqus or Jetpack Comments</li>\n</ul>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-theme-integration.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-theme-integration.png?resize=1025%2C839\" alt=\"epoch-theme-integration\" class=\"aligncenter size-full wp-image-47442\" /></a></p>\n<p>Unlike Postmatic, which has a <a href=\"https://gopostmatic.com/premium/\" target=\"_blank\">commercial option</a> for additional features, founder Jason Lemieux says Epoch will not be directly monetized.</p>\n<p>&#8220;We do not have any plans to create a commercial version,&#8221; he said. &#8220;Postmatic is our primary product, Epoch exists only to make it easier for people to move back to native commenting, and in turn to use Postmatic. Epoch will be free forever.&#8221;</p>\n<h3>Compatibility with Other Comment Plugins</h3>\n<p>Epoch works seamlessly with Postmatic, i.e. it will pop up an opt-in modal allowing the commenter to subscribe to new post notifications. Using Postmatic in combination with Epoch is not required, because the plugin was created to work well on its own. It&#8217;s also compatible with many other plugins that extend comments.</p>\n<p>&#8220;Other third party native commenting plugins have taken a heavy-handed approach and do not support the comment template hooks built into WordPress,&#8221; Lemieux said. &#8220;This creates a walled garden in which the innovation and hard work present in existing and future comment plugins is left out.</p>\n<p>&#8220;We decided to take a different approach. We built Epoch to be compatible with other comment plugins as much as possible. Not all are, but with little tweaks here and there they work just fine.&#8221;</p>\n<p>Version 1.0 integrates perfectly out of the box with Postmatic, WordPress Zero Spam, Akismet, WP Markdown, and WordPress Social Login.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-plugin-compatibility.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-plugin-compatibility.png?resize=1025%2C583\" alt=\"epoch-plugin-compatibility\" class=\"aligncenter size-full wp-image-47447\" /></a></p>\n<p>&#8220;In our testing most anything that does not use a lot of JavaScript works just fine,&#8221; Lemieux said. &#8220;Things I haven&#8217;t tested but I assume would work would be anything that modifies or adds fields to the comment form (Subscribe to Comments, CommentLuv, various captchas).</p>\n<p>&#8220;Fancier plugins that allow for comment editing or sorting the comment order based on voting would probably not be happy. We will have to make that functionality ourselves.&#8221;</p>\n<h3>Epoch is a Disqus Alternative with an Emphasis on Privacy</h3>\n<p>When Lemieux and his team created Epoch, the strategy was to address problems with native commenting in order to pave the way for more users to get on board with Postmatic.</p>\n<p>&#8220;We didn&#8217;t set out with intentions of competing with Disqus,&#8221; he said. &#8220;However, a few months in it became clear that there are usually two reasons people were not using native comments, and we would need to address both if we wanted widespread adoption of Postmatic.</p>\n<p>&#8220;The first is that the comment templates that come with a huge majority of themes just plain stink. Theme developers hate dealing with them. It&#8217;s usually an afterthought. So the commenting experience suffers. It is slow, ugly, and not at all fun.</p>\n<p>&#8220;The second reason is that native commenting is extremely hard on the server. You can&#8217;t run native comments on a high traffic site. The server would buckle. A CDN won&#8217;t save you because the page content is constantly changing. For larger sites, native commenting is not even an option.</p>\n<p>&#8220;Both of these problems are solved easily with solutions like Livefyre or Disqus, so they get installed. But it&#8217;s just selling your users down the river. Your data is not yours, ads start showing up on your site. Privacy is out the window. And really, the performance gains are minimal when the embedded comments still take 10 second to load because there is so much tracking JavaScript being queued up in the background.&#8221;</p>\n<p>In contrast, Epoch loads faster than third party solutions and is completely private. Your commenters&#8217; data is not farmed out and comments stay on your server.</p>\n<p>&#8220;For the first time someone can say this: running native WordPress commenting will actually increase your site performance,&#8221; Lemieux said.</p>\n<h3>What&#8217;s on the roadmap for the future of Epoch?</h3>\n<p>Lemieux and his team hope to attract a larger community around the project, which is <a href=\"https://github.com/postmatic/epoch\" target=\"_blank\">open to contribution on GitHub</a>.</p>\n<p>&#8220;We plan on aggressively recruiting others to join the project and we hope other developers will be inspired by what we have started,&#8221; he said.</p>\n<p>&#8220;We are going to build out a small API to make it easier for other plugins to hook into some of the advanced functionality.</p>\n<p>&#8220;And there are a few things that feel like they may be necessary: comment voting and a simple little like button which would be handy as a way to say, &#8216;I appreciate what you said, I do not have anything else to add.&#8217; I would love to integrate that with Postmatic. I often will get a comment in my inbox and I want to recognize the thought that went into it, but don&#8217;t feel like I have anything to add. A simple little +1 would do it nicely,&#8221; Lemieux said.</p>\n<p>The 1.0 release of Epoch is exciting news for those who have been dissatisfied with WordPress native comments but are hoping for a reason to return. The plugin is open source and <a href=\"https://wordpress.org/plugins/epoch/\" target=\"_blank\">available for free on WordPress.org</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 17:45:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: Yuuta: A Free Visual Diary Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47303\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://wptavern.com/yuuta-a-free-visual-diary-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4045:\"<p>Earlier this month, <a href=\"http://wptavern.com/new-proposal-on-trac-to-remove-post-formats-from-wordpress-core\" target=\"_blank\">a new proposal landed on trac</a>, advocating the removal of <a href=\"http://codex.wordpress.org/Post_Formats\" target=\"_blank\">post formats</a> from core. Many believe that this feature would be better as a plugin, since it has received little improvement over the years and is not used by the majority of WordPress users.</p>\n<p>If the UI can be improved to be less confusing and theme support is standardized, post formats may have a chance at more widespread adoption. The feature is entirely dependent on theme support, as post formats are not enabled by default unless the theme author opts to include them. Many still do, which is why ripping them out of core in favor of a plugin would be a major undertaking.</p>\n<p>One of the most common use cases for post formats is a diary style WordPress theme. <a href=\"https://wordpress.org/themes/yuuta/\" target=\"_blank\">Yuuta</a> is a relatively popular theme on WordPress.org that revolves entirely around post formats. In the past four months, it has been downloaded more than 7,000 times. Yuuta was created to serve as a visual diary and includes support for all nine of WordPress&#8217; post formats.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta.png?resize=880%2C660\" alt=\"yuuta\" class=\"aligncenter size-full wp-image-47392\" /></a></p>\n<p>The theme was designed by Felix Dorner, owner of <a href=\"http://drnr.co/\" target=\"_blank\">Studio DRNR</a>, a Berlin-based web development company. According to its description page, Yuuta was selected as the the theme&#8217;s name based on its Japanese meaning:</p>\n<blockquote><p>Yuuta is a Japanese name and is made up of 優 (yuu) “gentleness, superiority”, 悠 (yuu) “distant, leisurely” or 勇 (yuu) “brave” combined with 太 (ta) “thick, big”.</p></blockquote>\n<p>Each post format has its own distinguishing icon and unique display. Dorner opted to use Roboto, Roboto Slab, and a sprinkling of Courier as the theme&#8217;s primary fonts. The typography choices were selected for optimal readability on all screen sizes.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-chat-format.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-chat-format.jpg?resize=961%2C526\" alt=\"yuuta-chat-format\" class=\"aligncenter size-full wp-image-47405\" /></a></p>\n<p>Yuuta also includes specific styles for both standard and Jetpack-enabled galleries.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-jetpack-enabled-gallery.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-jetpack-enabled-gallery.jpg?resize=652%2C572\" alt=\"yuuta-jetpack-enabled-gallery\" class=\"aligncenter size-full wp-image-47407\" /></a></p>\n<p>The theme&#8217;s design is fairly set, unless you opt to create a child theme. There are zero options in the Customizer. Much of the design customization is done on a post-by-post basis, as the featured image serves as a unique background for the post. Yuuta also includes editor styles to match the editing experience to the theme&#8217;s frontend appearance.</p>\n<p>The primary navigation menu is hidden until toggled into view by the icon in the header, which keeps the reader focused on the content. There are no sidebars to contend with but widgets can be added to the footer.</p>\n<p>If you&#8217;re a fan of post formats, the Yuuta theme really makes them shine. It responds to display beautifully on all devices from desktop to tablet to smartphone. Check out a <a href=\"http://demo.felixdorner.com/yuuta/\" target=\"_blank\">live demo</a> on Dorner&#8217;s website to see each post format in action. You can download <a href=\"https://wordpress.org/themes/yuuta/\" target=\"_blank\">Yuuta</a> for free from WordPress.org or install it via your admin themes browser.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 04:06:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Awesome Geek Podcasts: A Curated List of Tech Podcasts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/awesome-geek-podcasts-a-curated-list-of-tech-podcasts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2834:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/headphones.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/headphones.jpg?resize=960%2C482\" alt=\"photo credit: Jan Vašek\" class=\"size-full wp-image-47389\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3YOVALG5DX\">Jan Vašek</a>\n<p>The WordPress community produces a couple dozen high quality podcasts covering diverse topics, such as weekly news, business/entrepreneurship, education, and development. Every year the best WordPress-related podcasts are featured in <a href=\"http://iamdavidgray.com/best-wordpress-podcasts/\" target=\"_blank\">roundup posts</a> highlighting shows that are publishing new episodes regularly.</p>\n<p>One way to venture outside the WordPress world is to expand your horizons when it comes to podcast subscriptions. <a href=\"https://github.com/cv/awesome-geek-podcasts\" target=\"_blank\">Awesome Geek Podcasts</a> is a curated list of tech podcasts that was first published in May of this year on GitHub. Since that time the repository has received 121 commits from 34 contributors.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/awesome-geek-podcasts.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/awesome-geek-podcasts.png?resize=1025%2C551\" alt=\"awesome-geek-podcasts\" class=\"aligncenter size-full wp-image-47382\" /></a></p>\n<p>None of the podcasts listed in the repo are directly related to WordPress, but many cover topics related to the various technologies that work in and with WordPress. The list includes approximately seven PHP-related podcasts in English (and more in other languages), along with shows focused on JavaScript, Sass, Git, and other technologies.</p>\n<p>Other topics included in the Awesome Geek Podcasts list that might be of interest to WordPress developers include:</p>\n<ul>\n<li>Running software companies</li>\n<li>Software design, creation, and delivery</li>\n<li>Front end web design, development, and UX</li>\n<li>Typography, design, prototyping</li>\n<li>Open source software</li>\n<li>Family and life/work balance</li>\n</ul>\n<p>Several of those listed follow a short format of 5 and 10-minute episodes for developers who are short on time. No matter where your interests lie in the various aspects of &#8220;geek life,&#8221; the Awesome Geek Podcast list has something for everyone.</p>\n<p>Currently the list has separate sections for shows in English, Portuguese, Spanish, Russian, Persian, and Swedish, but it is open to contribution. Although it doesn&#8217;t seem to include many podcasts that focus on specific CMS platforms, you can try <a href=\"https://github.com/cv/awesome-geek-podcasts/blob/master/CONTRIBUTING.md\" target=\"_blank\">submitting a pull request</a> for the inclusion of your WordPress-related podcast.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 20:58:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Behind the Scenes of WordPress 4.2.3 With Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47354\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/behind-the-scenes-of-wordpress-4-2-3-with-gary-pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2253:\"<p>When <a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\">WordPress 4.2.3 was released</a> last week, not only did it patch a critical security vulnerability, but also <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\">adversely impacted</a> a number of sites. Changes to the Shortcode API which were necessary as part of the patch caused some plugins that rely on the API to break. These changes were not immediately communicated to plugin developers. Nearly eight hours after its release, a <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/\">post published</a> on the Make WordPress Core blog explained the changes.</p>\n<p>The release process of WordPress 4.2.3 left <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites#comments\">plugin authors and users</a> scratching their heads. On one hand, point releases are not supposed to break anything. On the other, affected plugin authors were left in the dark for nearly eight hours wondering why a point release broke their plugins.</p>\n<p><a href=\"http://pento.net/\">Gary Pendergast</a> who works for Automattic, is a WordPress core contributor, and a member of the WordPress core security team, reached out to me for an interview. In the following conversation, we discuss what happened behind the scenes before 4.2.3 was released.</p>\n<p>He clears up some confusion on when the changes to the Shortcode API were implemented. He also admits the team made some mistakes and has already implemented changes to improve the release process. One of those changes includes publishing a post on the Make WordPress Core blog as soon as the update is pushed out to sites.</p>\n<p>I appreciate and thank Pendergast for reaching out to me to have this conversation. I look forward to similar collaborations with members of the core team in the future. A transcription of this interview is not available but if you have it transcribed and would like to make it available to the public, please <a href=\"http://wptavern.com/contact-me\">contact me</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 19:02:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WordPress Theme Review Team Votes to Allow Themes to Use the REST API Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47342\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://wptavern.com/wordpress-theme-review-team-votes-to-allow-themes-to-use-the-rest-api-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3363:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/colored-pencils.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/colored-pencils.jpg?resize=960%2C470\" alt=\"colored-pencils\" class=\"aligncenter size-full wp-image-42610\" /></a></p>\n<p>During this week&#8217;s WordPress Theme Review Team meeting, members considered the possibility of allowing themes hosted in the directory to make use of the <a href=\"https://wordpress.org/plugins/rest-api/\" target=\"_blank\">WP REST API plugin</a>. Since the API is not yet included in core, any theme or plugin author who wants to use it must have the feature plugin installed.</p>\n<p>Ordinarily, WordPress.org themes are not allowed to require a plugin on installation (although they can suggest one). As per the <a href=\"https://make.wordpress.org/themes/handbook/review/required/#plugins\" target=\"_blank\">Theme Review Handbook on plugins</a>: <em>A theme can recommend plugins but not include those plugins in the theme code.</em></p>\n<p>&#8220;The core team has asked us to consider temporarily allowing the requirement of the REST API for themes that may take advantage of it,&#8221; Tammie Lister said before calling for a vote. She also noted that waiving the rule would be temporary, as the API will soon be going into core.</p>\n<p>&#8220;This does not open up the way for others as an exception because it&#8217;s a core feature,&#8221; she said.</p>\n<p>The team took a quick vote and all present unanimously agreed to allow themes to require the REST API plugin as a temporary measure until it is available in core. Check out the <a href=\"https://make.wordpress.org/themes/2015/07/28/theme-review-team-weekly-meeting-notes-the-logs-7/\" target=\"_blank\">meeting logs</a> for the full discussion.</p>\n<p>The WP REST API is already being used in production in many different ways around the web, as revealed in the comments on project leader Ryan McCue&#8217;s recent <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">post</a> calling for examples. If the Theme Review Team wants to keep pace with where WordPress is headed, it must offer the flexibility to allow for more innovative themes. Temporarily waiving the guideline against plugin requirements is a smart move.</p>\n<p>As WordPress.org accrues more examples of themes that use the REST API in a way that complies with the review team&#8217;s high standards, developers who are just getting started will have strong examples for creating their own. Jack Lenox&#8217;s presentation at WordCamp London this year highlighted a few of the benefits of theming with the REST API:</p>\n<ul>\n<li>Provides a way to retrieve pure data (usually in JSON or XML format) over HTTP</li>\n<li>No loops necessary</li>\n<li>Good for mobile apps and environments where you don’t want a full webpage to render but want content from a blog or site</li>\n</ul>\n<p>With the official directory now welcoming these types of themes, it won&#8217;t be long before the entire landscape of WordPress theme development changes to support more modern ways of presenting content. Check out Jack Lenox&#8217;s presentation on <a href=\"http://wptavern.com/jack-lenox-on-building-themes-with-the-wp-rest-api\" target=\"_blank\">Building themes with the WP REST API</a> for information on how to get started.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 17:30:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Post Status: Don’t make enemies, invest in friendships\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=13860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://poststatus.com/invest-in-friendships/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4756:\"<p><em>Editor&#8217;s note: The following is a guest post by <a href=\"http://corymiller.com/about/\">Cory Miller</a>, the CEO of <a href=\"https://ithemes.com\">iThemes</a>. Cory describes his approach to making friends and avoiding making enemies. You should also check out his recent <a href=\"http://corymiller.com/my-talk-on-mental-health-and-entrepreneurship-is-now-online/\">talk on mental health and entrepreneurship</a>, which is terrific.</em></p>\n<p>I’d rather wave a white flag and compromise than make an enemy. Every. Single. Day.</p>\n<p>I’ve purposefully and intentionally, throughout my life (and business), sought to <em>not</em> make enemies, but rather build friendships.</p>\n<ul>\n<li>Enemies are only trouble.</li>\n<li>Enemies are distractions.</li>\n<li>Enemies eat my time and energy and focus.</li>\n<li>Enemies seek your destruction.</li>\n<li>Enemies oppose you.</li>\n<li>Enemies seek to “harm or weaken” you.</li>\n</ul>\n<p>Friends do the opposite.</p>\n<p>My best example of this is my wife, Lindsey. I think of her as my greatest ally and my best friend. She’s the opposite of an enemy.</p>\n<p>The words I use to describe her are “caring,” “supportive,” “loving,” and “wants my best.”</p>\n<p>So why would I spend my time seeking to <em>create</em> enemies, instead of friendships?</p>\n<ul>\n<li>You can have opinions.</li>\n<li>You can take stands.</li>\n<li>You can and should draw boundary lines.</li>\n<li>You can have your principles and <em>never</em> budge on them.</li>\n</ul>\n<p><em>But,</em> you can also, simultaneously, choose to make and focus on friendships.</p>\n<p>Some of my best friendships have come through business, and some of them would be considered “competitors.”</p>\n<p>But I’ve cherished those friendships.</p>\n<p>Additionally, I sleep better at night knowing we only want each other’s best and that there is plenty of room for each other instead of someone actively, purposefully seeking my destruction.</p>\n<p>But instead of seeking to fester anger and hate and competition, I’ve sought the opposite, asking, &#8220;Where can we find ways to help each other do better for each other?&#8221;</p>\n<p>So what if we approached life and business like this:</p>\n<p>Instead of using that anger, bile, jerk-ness, and negative energy in telling the world who you hate and how big of a jerk you can be, and how you don’t want to be an enemy of &#8212; why not seek to build true, lasting, deep friendships?</p>\n<p>The old quote, “Keep your friends close, and your enemies closer,” is pure B.S.</p>\n<p>Why not create a friend instead of nurture an enemy?</p>\n<p>Why not tell the world that you can be the <em>best</em> friend they ever made? And prove it by your actions.</p>\n<p>Friendships do take an investment. They take consistency. They take time. They take compromise sometimes. It means showing up for them when they most need it.</p>\n<p>But those relationships have been some of the richest relationships I’ve ever had. And totally worth the investment (multiple times over and over in fact).</p>\n<p>And yes, I have made enemies in my life. Purposefully and sometimes not. In fact, someone recently asked me jokingly on Twitter who didn’t like me. I responded with:</p>\n<p>“I can think of 1 or 2 a-holes but I don’t like thinking about them. <img src=\"https://poststatus.com/wp-includes/images/smilies/simple-smile.png\" alt=\":)\" class=\"wp-smiley\" /> hahahahaha”</p>\n<p>And although that’s sadly true, I’ve sought to minimize the enemies I’ve made in my life and business.</p>\n<p>My perspective on making necessary enemies is that <em>if</em> you <em>have</em> to make an enemy &#8212; and when I say that, I don’t mean because your personality defaults to that of a jerk and you sadistically like being labeled one), but you <em>have</em> to make an enemy because you have to set a boundary and tell someone no, or take a legal action &#8212; make dang sure it’s either for a <em>very</em> good purpose, value or strategic reason.</p>\n<p>And even then, question yourself about why.</p>\n<p>As my attorney told me recently: “You catch more flies with honey.”</p>\n<p>So don’t be a jerk while making enemies. You’ll make <em>more</em> enemies in the process.</p>\n<p>Simple, lip-biting kindness in the face of anger and hate and bile helps deflate a situation rather than pour lighter fluid on it.</p>\n<p>I tell people often: it doesn’t cost me anything to be nice and kind. (In fact most of the time it makes me happier.) And I seek out different avenues to vent my frustration and relieve my stress.</p>\n<p>So I say: Don’t make enemies. Invest in friendships.</p>\n<p>It should be common sense, but sometimes I (and maybe you) need a reminder.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 05:13:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Cory Miller\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: Adler: A Unique Personal Blogging Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47272\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/adler-a-unique-personal-blogging-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3395:\"<p>If you&#8217;re on the hunt for a new WordPress blogging theme but the designs are all starting to look too similar, you may want to check out <a href=\"https://wordpress.org/themes/adler/\" target=\"_blank\">Adler</a>. It is one of the more unique themes to land in the WordPress.org directory in recent months with its uncommon typography choices and bright bursts of color.</p>\n<p>Adler was created by Romanian theme designer <a href=\"https://twitter.com/BabBarDeL\" target=\"_blank\">George Olaru</a> of <a href=\"https://pixelgrade.com/\" target=\"_blank\">Pixelgrade</a>. Olaru takes a unique approach to the popular fullscreen splash page style that many themes have adopted for a homepage layout, overlaying it with a serif font title paired with a hand-script style subtitle.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler.png?resize=880%2C660\" alt=\"adler\" class=\"aligncenter size-full wp-image-47315\" /></a></p>\n<p>Styling for single posts is similar to the home page with the featured image serving as a fullscreen background for the title. Scroll further down and the post content is centered with no distracting sidebar widgets.</p>\n<p>Adler combines two unusual Google font choices in the design: Droid Sans Mono for paragraph text and Permanent Marker for blockquotes and subtitles. Images in posts overhang the text column to create a strong visual impact.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler-images-blockquotes.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler-images-blockquotes.jpg?resize=810%2C812\" alt=\"adler-images-blockquotes\" class=\"aligncenter size-full wp-image-47318\" /></a></p>\n<p>Adler&#8217;s files include a tiny leaf icon that is tastefully applied on the home and archive templates to separate posts. The effect is minimalist without appearing to be stark. The theme also includes support for Font Awesome icons.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/font-awesome.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/font-awesome.jpg?resize=656%2C534\" alt=\"font-awesome\" class=\"aligncenter size-full wp-image-47320\" /></a></p>\n<p>The necessity for large featured images can sometimes be a drawback for users when selecting a blogging theme. After testing Adler, I found that the design doesn&#8217;t break if you don&#8217;t have a large featured image assigned to a post. In fact, posts lacking a featured image look just as nice as those that include one, so you&#8217;re not tied down to hunting for one every time you publish.</p>\n<p>Adler supports three menu locations for a primary, footer, and social menu. It includes support for one footer widget area, which spans three columns. There are just two options available in the native customizer that allow you to change the background color or add a background image.</p>\n<p>Adler was created to be a personal blogging theme and the design instantly communicates: &#8220;I have something to say.&#8221; Check out the <a href=\"https://pixelgrade.com/demos/adler/\" target=\"_blank\">live demo</a> on Pixelgrade.com to see it in action. If you like what you see, you can <a href=\"https://wordpress.org/themes/adler/\" target=\"_blank\">download Adler</a> for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 01:09:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: New WordPress Plugin Automates Slack Team Invitations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47267\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/new-wordpress-plugin-automates-slack-team-invitations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4403:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg?resize=700%2C314\" alt=\"slack-logo\" class=\"aligncenter size-full wp-image-33466\" /></a></p>\n<p>Generating Slack team invitations can become rather tedious when you&#8217;re managing a large group of people &#8211; particularly when the team is open to almost anyone. In the case of a company or organization, a Slack admin can use the feature that permits anyone with an email from a specified domain to be accepted on signup. However, this feature isn&#8217;t applicable to teams that are made up of people with diverse email domains and associations.</p>\n<p><a href=\"http://boiteaweb.fr/\" target=\"_blank\">Julio Potier</a>, a French security consultant and prolific <a href=\"https://profiles.wordpress.org/juliobox/\" target=\"_blank\">plugin developer</a>, created a solution for this particular scenario. As an admin on the <a href=\"https://wordpressfr.slack.com/\" target=\"_blank\">WordPressFR.slack.com</a> team, which is open to all French WordPress users, he needed a more convenient way to allow new signups. The team has 27 channels and 250+ members with 200 added in the first week.</p>\n<p>Julio decided to create a plugin to make the invitation process easier in the future. The new <a href=\"https://wordpress.org/plugins/lazy-invitation/\" target=\"_blank\">Slack Lazy Invitation</a> plugin automates the sending of Slack team invitations by adding a frontend signup on your WordPress site.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/join-slack-team.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/join-slack-team.png?resize=404%2C405\" alt=\"join-slack-team\" class=\"aligncenter size-full wp-image-47285\" /></a></p>\n<p>The user simply enters an email address and the invitation is sent. A Slackbot confirmation will appear on the page.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-team-invite-sent.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-team-invite-sent.png?resize=365%2C253\" alt=\"slack-team-invite-sent\" class=\"aligncenter size-full wp-image-47286\" /></a></p>\n<p>To configure the plugin for your Slack team all you need to do is enter the group name and the security token for your Slack invitations. As this token is not easy to find, Julio wrote a bookmarklet that will automatically capture it for you. From the plugin&#8217;s settings page you can drag and drop the bookmarklet into your browser toolbar on the invitation page found at: <code>https://YOURGROUP.slack.com/admin/invites</code>.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/lazy-slack-settings.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/lazy-slack-settings.png?resize=782%2C439\" alt=\"lazy-slack-settings\" class=\"aligncenter size-full wp-image-47295\" /></a></p>\n<p>Once the plugin is configured, the invitation signup page will be available at <code>example.com/wp-login.php?action=slack-invitation</code>. If you&#8217;re using either the <a href=\"https://wordpress.org/plugins/wp-recaptcha/\" target=\"_blank\">wp-reCaptcha</a> or <a href=\"https://wordpress.org/plugins/google-captcha/\" target=\"_blank\">google-captcha</a> plugins, Slack Lazy Invitation will automatically add protection to the form.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-invite-recaptcha.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-invite-recaptcha.jpg?resize=350%2C481\" alt=\"slack-invite-recaptcha\" class=\"aligncenter size-full wp-image-47292\" /></a></p>\n<p>The plugin also includes support for the <a href=\"https://wordpress.org/plugins/sf-move-login/\" target=\"_blank\">SF Move Login</a> plugin, so that the invitation form is available at /slack-invitation instead of the much longer URL. This slug can be changed in the SF Move Login settings panel.</p>\n<p>In the future Julio plans to add support for adding invite pages for multiple groups. I tested <a href=\"https://wordpress.org/plugins/lazy-invitation/\" target=\"_blank\">Slack Lazy Invitation</a> and found that it works exactly as advertised. If you have a large Slack team with open invites, this plugin will save you quite a bit of time. Download it for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jul 2015 22:30:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"WPTavern: Meet PeepSo: BuddyPress’ Newest Competitor in Open Source Social Networking for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46711\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://wptavern.com/meet-peepso-buddypress-newest-competitor-in-open-source-social-networking-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10255:\"<p>When the first <a href=\"https://buddypress.org/2008/12/buddypress-10b1-components/\" target=\"_blank\">BuddyPress beta</a> arrived on the scene in 2008, there was nothing like it for WordPress. Facebook was still relatively new to the public and Twitter was just a couple years old. A plugin that transformed WordPress into a social network was an exciting prospect.</p>\n<p>After seven years of virtually unchallenged dominance among WordPress social networking plugins, BuddyPress has a new competitor. <a href=\"http://www.peepso.com/\" target=\"_blank\">PeepSo</a>, trademarked <em>&#8220;Your people. Your community. Your way,&#8221;</em> is the newest contender in WordPress&#8217; open source social networking plugin niche.</p>\n<p>Unlike <a href=\"https://buddypress.org/\" target=\"_blank\">BuddyPress</a>, which for the most part has improved slowly through community contribution, the <a href=\"http://www.peepso.com/\" target=\"_blank\">PeepSo</a> project is run more like a startup and is 100% self-funded. It is currently being marketed as an alternative to BuddyPress.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">You\'ve been asking for it. An alternative to BuddyPress. It\'s here! <a href=\"http://t.co/Uxd7AQcnCL\">http://t.co/Uxd7AQcnCL</a> <a href=\"https://twitter.com/hashtag/wordpress?src=hash\">#wordpress</a> <a href=\"https://twitter.com/hashtag/buddypress?src=hash\">#buddypress</a> <a href=\"http://t.co/yYRI5pnXJR\">pic.twitter.com/yYRI5pnXJR</a></p>\n<p>&mdash; peepso (@peepsowp) <a href=\"https://twitter.com/peepsowp/status/623768949943984128\">July 22, 2015</a></p></blockquote>\n<p></p>\n<p>The <a href=\"https://wordpress.org/plugins/peepso-core/\" target=\"_blank\">PeepSo plugin</a>, available on WordPress.org, offers many of the same <a href=\"http://www.peepso.com/pricing/\" target=\"_blank\">core features</a> as BuddyPress but was launched with a collection of commercial add-on plugins for things like photos, videos, moods, tagging, locations, friends, and messages. A groups feature is noticeably absent from Peepso but <a href=\"http://www.peepso.com/roadmap/\" target=\"_blank\">planned for version 1.4</a>. Current extensions seem to focus primarily on adding multimedia features to the activity stream.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/peepso-profile.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/peepso-profile.png?resize=1025%2C769\" alt=\"peepso-profile\" class=\"aligncenter size-full wp-image-47235\" /></a></p>\n<h3>Who is Behind PeepSo?</h3>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/merav-peepso.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/merav-peepso.jpg?resize=225%2C300\" alt=\"merav-peepso\" class=\"alignright size-medium wp-image-47241\" /></a>PeepSo was founded by <a href=\"https://about.me/meravknafo\" target=\"_blank\">Merav Knafo</a>, owner of <a href=\"http://www.jomsocial.com/\" target=\"_blank\">JomSocial</a>, Joomla&#8217;s most popular social networking solution. Knafo, a veteran in the Joomla community, brings a unique perspective on the differences between the Joomla and WordPress markets for social networking software. As <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">Joomla captures roughly 7% to WordPress&#8217; 60% of the CMS market share</a>, Knafo saw an opportunity to break into a larger market.</p>\n<p>&#8220;As a business owner, it’s my job to pay attention to trends in my industry and unfortunately, Joomla has been on a downward trend since 2009,&#8221; Knafo said.</p>\n<p>&#8220;Many of our JomSocial customers have asked us to &#8216;make JomSocial for WordPress,&#8217; because they wanted to switch to WordPress but there was nothing like JomSocial for WordPress. Finally, I could not ignore the trend nor the requests and decided to get into the WordPress market as well.&#8221;</p>\n<p>Knafo hopes to parlay her experience with JomSocial into her new venture with PeepSo.</p>\n<p>&#8220;We stuck with Joomla for almost 10 years now and took JomSocial to a whole new level when we took over in 2013,&#8221; she said. &#8220;I am very proud of what we’ve accomplished with JomSocial and super excited to implement all this experience and knowledge into PeepSo.&#8221;</p>\n<h3>How PeepSo Got Started</h3>\n<p>The idea for PeepSo was incubating for a few years before Knafo had the opportunity to execute it.</p>\n<p>&#8220;Brad Bihun used to be a customer of ours at <a href=\"http://www.ijoomla.com/\" target=\"_blank\">iJoomla</a>, and then he switched to WordPress,&#8221; she said. &#8220;We happened to live very close to each other in Encinitas, California, so we met up and suggested I’d created &#8216;JomSocial for WordPress.&#8217;</p>\n<p>&#8220;At that time, I didn’t even own JomSocial and I was too busy with all the iJoomla products. Then a couple of years later, I acquired JomSocial and he approached me again, but once again, I was just too busy. A year and a half into JomSocial acquisition, when things got a lot smoother, I finally said yes, he introduced me to the <a href=\"http://spectromtech.com/\" target=\"_blank\">SpectrOM</a> team, and we got started.&#8221;</p>\n<p>Although the plugin appears to be marketed as a direct competitor to BuddyPress, Knafo said that it wasn&#8217;t created specifically for that purpose but rather to give WordPress users a more robust array of options for building networks.</p>\n<p>&#8220;Obviously we felt there was a need for another product as an alternative to BuddyPress,&#8221; she said. &#8220;Leaving users with just one option is rarely a good idea, people like options.</p>\n<p>&#8220;We don’t necessarily plan to take on BuddyPress, we just want to offer those who want an alternative, a product that is of high quality and that is being continuously developed. Ultimately, people will choose the solution that serves them best. We are just getting started, but we have big plans and an excellent track record doing this successfully with Joomla.&#8221;</p>\n<h3>The Differences Between PeepSo and BuddyPress</h3>\n<p>I asked Knafo what her team perceives to be the most notable differences between PeepSo and its more established competitor, based on what they found to be lacking in BuddyPress.</p>\n<p>&#8220;I’d say the look and feel is a lot more modern in PeepSo right off the bat with no special themes needed,&#8221; she said. &#8220;The features are more up-to-date with the latest and greatest features of big social networks, such as Facebook &#8211; from cover photos to &#8216;likes&#8217; and so on.&#8221;</p>\n<p>BuddyPress core developers have opted to leave the aforementioned features to separate third-party plugins as opposed to packing them into core. With certain features, i.e. photos and videos, PeepSo does the same, except the add-ons are supported by PeepSo core developers.</p>\n<p>&#8220;PeepSo is lightweight and allows you to only add features that you need, to keep it lightweight,&#8221; Knafo said. &#8220;PeepSo’s code is so beautiful it made our developers shed tears of joy when they first saw it &#8211; that said, I never looked at BuddyPress’s code, nor would I be able to tell whether it’s beautiful or not.&#8221;</p>\n<p>In terms of code differences, PeepSo&#8217;s development team cited what they believe to be a few major differences between their <a href=\"https://github.com/wp-plugins/peepso-core\" target=\"_blank\">codebase</a> and BuddyPress:</p>\n<ul>\n<li>All object oriented &#8211; from the PHP to the Javascript</li>\n<li>Built with a templating engine similar to what you see in shopping cart systems. This allows use with virtually any theme.</li>\n<li>The JavaScript uses an extension mechanism, allowing add-ons to extend the abilities of the postbox.</li>\n<li>We made the database queries as optimized as possible to allow for greater scalability.</li>\n</ul>\n<p>&#8220;We have a track record creating and supporting a very large social networking application (JomSocial),&#8221; Knafo told the Tavern. &#8220;We know the ins and out of this business. We may be new to WordPress, but we are veterans when it comes to social networking applications.&#8221;</p>\n<h3>Where is PeepSo Headed?</h3>\n<p>The PeepSo development team, guided by lead architect <a href=\"https://twitter.com/davejesch\" target=\"_blank\">Dave Jesch</a> of <a href=\"http://spectromtech.com/\" target=\"_blank\">SpectrOM</a>, has an aggressive <a href=\"http://www.peepso.com/roadmap/\" target=\"_blank\">roadmap</a> for improving the plugin&#8217;s core and adding more features via commercial plugins.</p>\n<p>&#8220;Our main goal is to add more plugins to PeepSo, you can see our road map here. We’ll start with a chat plugin, custom profile fields and then groups, events, pages and so forth,&#8221; Knafo said. The team also hopes to partner with other developers who want to create PeepSo plugins.</p>\n<p>I asked her if the team plans to create a hosted PeepSo platform for community managers. Knafo said it isn&#8217;t totally out of the question but isn&#8217;t high on the priority list at the moment.</p>\n<p>&#8220;We tried to do this with JomSocial but we had a hard time finding the right hosting solution for it,&#8221; she said. &#8220;That said, we are open to the idea, a bit down the road.&#8221;</p>\n<p>PeepSo is just getting started and has not yet attracted many customers. However, Knafo&#8217;s experience of successfully running an open source project for the past 10 years has given her the determination to break into a new and unfamiliar market.</p>\n<p>&#8220;The sales have been as can be expected this early after the initial release, not too shabby to start with but we expect whole lot more sales as the WordPress users become aware of PeepSo, download the free version and give it a try,&#8221; she said.</p>\n<p>&#8220;We’re here for the long haul and we take no shortcuts in doing this right. We know it’s a huge undertaking; there is so much more to do. I am confident that investing in WordPress was the right move, I’ve been very pleased by the feedback and the community. My hope is that WordPress developers will join us and create awesome plugins to take PeepSo to the next level.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 22:50:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Only 70 Tickets Remain to Livestream Prestige for Free August 1-2, 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47208\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://wptavern.com/only-70-tickets-remain-to-livestream-prestige-for-free-august-1-2-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4855:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/08/PrestigeConfLogo.png\"><img class=\"alignright size-full wp-image-27630\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/08/PrestigeConfLogo.png?resize=275%2C233\" alt=\"Prestige Conference Logo\" /></a>With just a few days remaining before <a href=\"http://prestigeconf.com/\">Prestige takes place</a>, there are only 70 tickets left to watch the event for free. Courtesy of <a href=\"http://www.rocketgenius.com/\">Rocketgenius</a>, the event&#8217;s primary sponsor, more than 500 people will be watching the event for free this weekend. To watch the event for <del>free, use the code <strong>GravityFormsLS </strong></del>when <a href=\"http://prestigeconf.com/tickets/\">purchasing a streaming ticket</a>.</p>\n<p>Free tickets are sold out. However, entering the code <strong>PrestigeStream</strong> when <a href=\"http://prestigeconf.com/tickets/\">purchasing a streaming ticket</a>, will take 50% off the price</p>\n<p>Prestige is a conference founded by Kiko Doran and Josh Broton in 2014 that focuses on the business aspects of WordPress. The first event was held in Minneapolis, MN, in October of 2014. Earlier this year, Prestige was held in Las Vegas, NV. This weekend marks the third time the conference will be held.</p>\n<h2>The Future of Prestige</h2>\n<p>The first and second conference had approximately 100 attendees and Doran expects the same amount this weekend. However, future iterations of Prestige will have lower attendance. &#8220;We are transitioning to more of an online event. We’re actually going to make the in-person events smaller moving forward.&#8221; Doran told the Tavern.</p>\n<p>There&#8217;s also a chance the conference could morph into something completely different. &#8220;After organizing two WordCamps, I figured out some of the things I loved about them and some of the things I don&#8217;t. Prestige has given me the freedom to try new things and see what people like and what they don’t like,&#8221; Doran said.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/PrestigeinVegas.jpg\"><img class=\"wp-image-47216 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/PrestigeinVegas.jpg?resize=1025%2C576\" alt=\"Prestige in Las Vegas Nevada\" /></a>Prestige in Las Vegas, NV Image courtesy of <a href=\"https://www.happyjoe.org/prestige-conference-las-vegas-2015/\">James Dalman</a>\n<p>Although the conference has been held twice this year and in different cities, the organizing team plans to host at least one Prestige conference in Minneapolis every year. Talks are underway for the next event but details are not locked down.</p>\n<p>&#8220;We plan to do one in Minneapolis every year because we love the community there. We’d like to do Minneapolis in the summer time, due to weather, then we’d like to do any winter events in a warm place,&#8221; Doran said.</p>\n<p>Organizing a conference is a challenging experience that benefits from having motivated organizers. Doran explains what motivates him to organize Prestige, sometimes twice a year.</p>\n<p>&#8220;I have a small awesome team of organizers that love putting this event on. That and the people who come and share their knowledge. It’s a smaller event but to me, that&#8217;s the appeal of it. Everyone is far more approachable in this environment,&#8221; he said.</p>\n<h2>A First for Prestige</h2>\n<p>This weekend&#8217;s event features a hands-on workshop by Jennifer Bourn of <a href=\"http://www.bourncreative.com/\">Bourn Creative</a>. It&#8217;s the first session in Prestige&#8217;s young history to involve hands-on exercises. The session is uncharted territory for the conference which has mostly focused on people sharing their experiences building  businesses.</p>\n<h2>How Long Will Doran Organize Prestige?</h2>\n<p>With this being his third conference, I asked Doran how long does he plan to continue organizing Prestige, &#8220;I’ll organize the conference as long as there is a demand for the content. People often say to scratch your own itch. This conference started off as a little self-serving in that I wanted to ask people all of these questions. Then I thought, couldn’t others benefit from this information as well?&#8221; he replied.</p>\n<h2>I&#8217;ll Be at Prestige Conference</h2>\n<p>I&#8217;ll be among the 100 expected attendees at this weekends conference. If you&#8217;re attending the event, please stop me and say hi. If not, make sure you grab one of the <a href=\"http://prestigeconf.com/tickets/\">70 tickets left</a> to watch a livestream of the event. You can also monitor the <a href=\"https://twitter.com/search?q=prestigeconf&src=typd\">#Prestigeconf</a> hashtag on Twitter. If you&#8217;ve previously attended Prestige or watched the livestream, please share your experiences in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 21:13:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: WordPress Users Association Under New Ownership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://wptavern.com/wordpress-users-association-under-new-ownership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5827:\"<p>The <a href=\"http://wpua.org/\">WordPress Users Association</a> (WPUA) is breathing new life after it was acquired by Paul DeMott earlier this year <a href=\"https://flippa.com/4377398-pr-2-2-405-last-12-mos-wordpress-training-membership-site-3500-members\">on Flippa</a> for $797. WPUA originally launched in December 2010, with the goal of providing a central place for WordPress users to swap war stories, learn how to get the most out of WordPress, and take part in getting special discounts on themes and plugins.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUAFrontPage.png\"><img class=\"size-full wp-image-47197\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUAFrontPage.png?resize=1025%2C489\" alt=\"Redesigned Front Page\" /></a>Redesigned Front Page\n<p>Three years after its launch, the site appeared to be dead. In 2013, <a href=\"http://wptavern.com/psa-dont-give-your-money-to-the-wpua\">I paid to become a member</a> to confirm my suspicions and to see if the site still accepted payments. Free themes and plugins offered to members were not impressive and there wasn&#8217;t much to choose from. All of the videos used for WordPress training were broken. Despite these setbacks, I was able to successfully complete the refund process.</p>\n<h2>Financial Details</h2>\n<p>Earlier this year, WPUA.org was listed on <a href=\"https://flippa.com/\">Flippa.com</a>, a domain auctioning site. As part of the auction financial details of WPUA.org were made public. According to <a href=\"https://flippa.com/users/217895\">the seller</a>, the site made $20K when it launched. The previous owners spent between $500-$1,000 on ads and answering WordPress questions through the Ask a WordPress Expert section of the site.</p>\n<p>The following shows revenue, costs, and profit between October 2014 and March 2015. WPUA earned revenue primarily with product or service sales and affiliate income.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUARevenue.png\"><img class=\"size-full wp-image-47198\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUARevenue.png?resize=580%2C273\" alt=\"WPUA Revenue\" /></a>WPUA Revenue\n<p>At the time the site was listed for auction, it had 3,500+ total members made up of free and paid subscriptions. The site today boasts more than 5,600 members.</p>\n<h2>Previous Owner Explains Why He Sold The Site</h2>\n<p>Wesley Williams is the former owner of WPUA.org and helped launch the site in 2010. Williams transitioned away from the domain because his web development business used the majority of his time. &#8220;We felt with our limited time to invest in it that it was best to transition it to someone who shared our passion but had a little more time to invest in growing the community and serving the members. We completed this transition back in April,&#8221; Williams told the Tavern.</p>\n<p>From my perspective, the WPUA was not a successful venture but Williams says otherwise.</p>\n<p>&#8220;I wouldn&#8217;t say it wasn&#8217;t a success. There are thousands of members and we provided a lot of help to a lot of new and experienced WordPress users. As my main core business grew and as the time requirements of our projects increased, we couldn&#8217;t devote the time required to answer questions and give the help needed.</p>\n<p>&#8220;Actually, WPUA was a big success in my mind. Just from a number of members point of view it was a success. From the amount and number of questions and people we helped it was a success and from a financial standpoint it was a success,&#8221; he said.</p>\n<p>Williams explains his goal with WPUA and why some members of the community may not be aware of the growth it had. &#8220;My goal was to help the under-served, those just getting started and without the technical know how to make what is actually simple fixes or changes to their WordPress site.</p>\n<p>&#8220;I didn&#8217;t run the WPUA in the circles of all the established WordPress technical crowd, even though a large number of them became members of the WPUA. I ran it focused on users new to the platform and so because of that, some members of the WordPress community might not be aware of the growth and success it had,&#8221; he said.</p>\n<p>Through the course of time, Williams and his team adjusted membership levels and access points which helped increase registrations. Williams also learned that what members wanted was a direct way to ask questions and receive expert answers.</p>\n<p>&#8220;A person new to the platform didn&#8217;t want to post their question in a forum and they weren&#8217;t really sure what the real question was. Thus, we removed the forum and went to an &#8216;Ask an Expert&#8217; system where they could email their questions. This seemed to work better for everyone,&#8221; he said.</p>\n<p>Overall, Williams is happy with how WPUA progressed and feels fortunate to have played a role in its growth and success.</p>\n<h2><strong>Who is Paul DeMott?</strong></h2>\n<p>In the <a href=\"https://vimeo.com/129324627\">following video,</a> DeMott explains how to build a eCommerce site with WooCommerce and calls himself the new president of recruitment for the WPUA. According to <a href=\"https://www.linkedin.com/pub/paul-demott/79/300/727\">his LinkedIn profile</a>, he lives in Cincinnati, OH and is the owner of Paul&#8217;s SEO and Web Expertise which works with companies to develop websites that bring in internet traffic and sales.</p>\n<p>Not much is known about DeMott and multiple requests for comment have gone unanswered. It&#8217;s unclear what his plans are for WPUA.org but so far, it&#8217;s remained as a paid subscription membership site. If you are a past or current member of the WordPress Users Association, please tell us about your experience in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 20:39:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: MPAA Smoking Gun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45270\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"http://ma.tt/2015/07/mpaa-smoking-gun/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"<p>Sometimes truth is worse than what you would imagine: <a href=\"https://www.techdirt.com/articles/20150724/15501631756/smoking-gun-mpaa-emails-reveal-plan-to-run-anti-google-smear-campaign-via-today-show-wsj.shtml\">Smoking Gun: MPAA Emails Reveal Plan To Run Anti-Google Smear Campaign Via Today Show And WSJ</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 15:34:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"WPTavern: Plugin Developers Demand a Better Security Release Process After WordPress 4.2.3 Breaks Thousands of Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47146\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6880:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/07/security.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/07/security.jpg?resize=1024%2C487\" alt=\"photo credit: Ravages - cc\" class=\"size-full wp-image-27206\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/ravages/6731739485/\">Ravages</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p><a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\" target=\"_blank\"> WordPress 4.2.3</a>, a critical security release, was automatically pushed out to users yesterday to fix an XSS vulnerability. Shortly afterwards, the <a href=\"https://wordpress.org/search/4.2.3?forums=1\" target=\"_blank\">WordPress.org support forums</a> were flooded with reports of websites broken by the update.</p>\n<p>Roughly eight hours later Robert Chapin (@<a href=\"https://profiles.wordpress.org/miqrogroove/\" target=\"_blank\">miqrogroove</a>) published a post to the Make.WordPress.org/Core blog, detailing <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/\" target=\"_blank\">changes to the Shortcode API</a> that were included in the release. According to Chapin, these changes were necessary as part of the security fix:</p>\n<blockquote><p>Due to the nature of the fix – as is often the case with security fixes – we were unable to alert plugin authors ahead of time, however we did make efforts to scan the plugin directory for plugins that may have been affected.</p>\n<p>With this change, every effort has been made to preserve all of the core features of the Shortcode API. That said, there are some new limitations that affect some rare uses of shortcodes.</p></blockquote>\n<p>The security team had no reasonable way of accounting for every single edge case, but the negative impact of these changes were far more wide-reaching than they had anticipated. This particular use case likely wasn&#8217;t covered in their testing. Unfortunately, plugin developers found out about the breaking changes only after the security release had already left a slew of broken websites in its wake.</p>\n<p>&#8220;I fully understand this is an issue, but isn’t this a weird way of updating &#8211; almost all our clients are calling / e-mailing us at the moment as their sites seem to be broken,&#8221; one developer <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/#comment-26449\" target=\"_blank\">commented</a> on the Shortcode API post. &#8220;Normally it would be better to announce such huge impact changes to the plugin and theme developers. This means I need to fully reschedule my agenda, which already is full during holiday season.&#8221;</p></blockquote>\n<p>Comments on the WordPress.org post are full of developers scrambling to find a way to fix client websites. Many were disappointed that the total secrecy of the security team, which is necessary in situations like this, was not immediately followed up with a public post on the important changes to the Shortcode API. Meanwhile, the email inboxes of agencies and plugin developers are filling up with urgent messages from outraged clients.</p>\n<p>Developers want better communication from the those who are managing security releases. <a href=\"https://twitter.com/helzer\" target=\"_blank\">Amir Helzer</a>, author of <a href=\"https://wordpress.org/plugins/types/\" target=\"_blank\">Types</a> and <a href=\"http://wp-types.com/home/views-create-elegant-displays-for-your-content/\" target=\"_blank\">Views</a>, two plugins majorly affected by the release, <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/#comment-26447\" target=\"_blank\">sums up the thoughts of many other commenters</a> on the Make/WordPress.org/Core post:</p>\n<blockquote><p>We are updating the Views plugin today, so that we resolve all shortcodes before passing to WordPress to process content.</p>\n<p>This is a straightforward change, which takes us one day to complete.</p>\n<p>Would have been great to receive a heads-up about an upcoming change in WordPress, so we could do this change on time.</p>\n<p>We received a huge amount of support requests due to this, but this isn’t the issue. We can deal with a wave a support issues. This time it wasn’t “our fault”, but sometimes it is.</p>\n<p>What worries us, as mentioned above, is seeing our clients (folks who build WordPress sites for a living), losing their faith in the system. They feel like the system sees them as little ants and not as humans. People don’t like seeing their problems being dismissed.</p>\n<p>Many of them run hundreds of sites. They cannot afford to stop everything and fix content on so many sites. Especially not if they are currently away for their family vacation.</p>\n<p>What others have asked here, and I would like to ask, too, is to setup a mechanism that allows WordPress core developers to privately communicate such upcoming issues with plugins developers.</p>\n<p>We are your partners.</p>\n<p>Without WordPress (secure, stable and reliable), we would not exist.</p>\n<p>Without great themes and plugins, WordPress would not power 24% of the Web.</p>\n<p>WordPress core members already volunteer a lot of their time. I’m not asking for anyone to volunteer more time. Need help? Ask us. There is a huge community of developers who rely on WordPress. We would be happy to get involved and set up whatever is needed.</p></blockquote>\n<p>User confidence in WordPress&#8217; automatic background updates took a dent with the 4.2.3 release. Waking up to broken websites causes users to second guess automatic updates after being assured that maintenance and security releases would not include breaking changes.</p>\n<p>When users get burned by automatic updates, in the end it doesn&#8217;t matter which party is at fault &#8211; whether it&#8217;s the core team or a theme or plugin. They simply expect updates to work and not break anything. Even in instances where a poorly coded extension may be at fault, the average user has no way of determining whether or not their active plugins follow WordPress best practices.</p>\n<p>The aftermath of the most recent security release is one reason why many developers and users are still wary of automatic updates. Amir Helzer represents many other plugin developers who are eager to find better ways to work together with the core team to provide a better update experience for users. This is especially important for releases like this one where the Shortcode API changes directly affected users&#8217; content. Hezler&#8217;s comment reaffirms the fact that development agencies, plugin developers, and core developers are all partners on the same team. It&#8217;s time to find better ways of working together to provide the best update experience possible for WordPress users.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Jul 2015 02:46:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: FooPlugin’s Digital License Key Management Plugin is Now Open Source for Developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47117\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/fooplugins-digital-license-key-management-plugin-is-now-open-source-for-developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5296:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/06/open-source.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/06/open-source.jpg?resize=1024%2C514\" alt=\"photo credit: 16th st - (license)\" class=\"size-full wp-image-45884\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/79777096@N00/6866996865\">16th st</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">(license)</a>\n<p>Three years ago, <a href=\"http://fooplugins.com/\" target=\"_blank\">FooPlugins</a> built <a href=\"https://bitbucket.org/fooplugins/foolicensing\" target=\"_blank\">FooLicensing</a>, a digital license key management tool that enabled them to manage customers of their <a href=\"https://easydigitaldownloads.com/\" target=\"_blank\">EDD</a>-powered commercial plugins store. Although EDD already offered a license creation and management extension, FooPlugins required more features than it had at that time and opted to build their own.</p>\n<p>As of today, FooLicensing is now open source and free for anyone to use, along with the associated EDD connector plugin.</p>\n<p>&#8220;We love the community and wanted to give back,&#8221; FooPlugins co-founder Adam Warner said.</p>\n<p>&#8220;We know FooLicensing could be so much more but we just don&#8217;t have the time to dedicate to it alone. We are a small team and because of that we find ourselves with dozens of projects that could be so much more if only we had more time and people.&#8221;</p>\n<p>Open sourcing a project can change its trajectory if there&#8217;s enough interest and developers willing to contribute to improve it. Warner isn&#8217;t counting on that, however, and simply hopes other developers will find it useful.</p>\n<p>&#8220;It&#8217;s a bit of a leap of faith, but if it helps someone else get involved to help create an even more robust system, then great,&#8221; he said. &#8220;Bonus if it helps someone build additional extensions to help others.&#8221;</p>\n<p>FooLicensing&#8217;s main features include:</p>\n<ul>\n<li>View and manage the validated domains for your EDD license level</li>\n<li>One click EDD license upgrade/add to cart</li>\n<li>One click EDD license renewal (with associated discount) /add to cart</li>\n</ul>\n<p>A logged-in user who has entered a license key will see all the relevant account information detailing status, activations, expirations, etc.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-user-admin.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-user-admin.png?resize=580%2C332\" alt=\"foolicensing-user-admin\" class=\"aligncenter size-full wp-image-47135\" /></a></p>\n<p>Administrators who are using the plugin together with its <a href=\"https://bitbucket.org/fooplugins/edd-foolicensing\" target=\"_blank\">EDD Connector</a> will see a menu with various license creation and management tools.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-admin-view.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-admin-view.png?resize=160%2C264\" alt=\"foolicensing-admin-view\" class=\"aligncenter size-full wp-image-47137\" /></a></p>\n<p>The <a href=\"https://bitbucket.org/fooplugins/edd-foolicensing\" target=\"_blank\">EDD Connector</a>, also now open source, enables the following:</p>\n<ul>\n<li>Add new licenses to attach to an EDD product</li>\n<li>A searchable list of all license keys that have been created and assigned, complete with attached domains</li>\n<li>A list of licenses that have been renewed</li>\n<li>Testing for license validation and update checks in the API Sandbox</li>\n<li>A management area for various messages (domain attach, detach) and for license renewal discount amount and emails</li>\n</ul>\n<h3>Foo Licensing is Extensible for Other Platforms</h3>\n<p>FooLicensing was built from the beginning to be extensible for use with other platforms beyond EDD. The team at FooPlugins had plans to expand their library of connectors but didn&#8217;t have the time to execute them.</p>\n<p>&#8220;Our goal for FooLicensing was to build additional integrations for other eCommerce plugins and digital sales platforms but it quickly took a back seat as our <a href=\"https://fooplugins.com/plugins/foobox/\" target=\"_blank\">FooBox</a> and other plugins like <a href=\"https://fooplugins.com/plugins/foogallery/\" target=\"_blank\">FooGallery</a> gained popularity,&#8221; Warner said.</p>\n<p>&#8220;Documentation is non-existent at this point, but we welcome you to step through the code and consider getting involved with the core plugin or with extensions for other eCommerce platforms.&#8221;</p>\n<p>Warner said the team is considering a full-fledged site dedicated to FooLicensing if enough developers become interested and would consider the possibility of a marketplace to host any extension built. FooPlugins does not currently have plans to create additional extensions in house.</p>\n<p>&#8220;We&#8217;ll see what the future holds, but for now we need to move forward with some other things rather than holding this tight to our chests,&#8221; Warner said. &#8220;Open sourcing the plugins just fits in with what we believe is the right thing to do to make the web (and the WP community) a better place.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jul 2015 20:17:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Post Status: Thesis, Automattic, and WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=13692\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://poststatus.com/thesis-automattic-and-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70425:\"<p>Chris Pearson and Matt Mullenweg have hardly communicated with one another in the last five years, but they are ideological enemies. They are both wealthy individuals (though of different magnitudes) thanks to their online endeavors, with very strong personalities and unshakable beliefs on business and software. This is a story of their dispute, their idealism, and the implications it will have on the WordPress project.</p>\n<p><a href=\"http://ma.tt/\">Matt Mullenweg</a> co-founded WordPress, founded <a href=\"https://automattic.com\">Automattic</a>, and is one of the most successful entrepreneurs of his generation. He runs a billion dollar &#8220;unicorn&#8221; startup centered on a culture of embracing open source technology and has achieved incredible success embracing principles counterintuitive to either Silicon Valley or big corporate culture. He&#8217;s paving a new path for how to create a valuable software company while religiously defending and promoting open source software.</p>\n<p><a href=\"http://www.pearsonified.com/\">Chris Pearson</a> founded <a href=\"http://diythemes.com/\">DIYthemes</a> and helped pioneer the early WordPress commercial theme industry. He has run his business successfully for over seven years, despite unique hurdles that result from a very public dispute with Mullenweg in 2010. He vehemently defends his work as his own non-derivative achievement and rejects the religiosity and cult mentality that he believes exists in the WordPress ecosystem. He views WordPress as a huge chunk of the web, available to be monetized &#8212; which he has done so to the tune of millions of dollars &#8212; but he does not believe he must adopt Matt Mullenweg&#8217;s principles in order to meet customer demand, run his own business, and protect his own inventions.</p>\n<p>By all normal definitions, Mullenweg and Pearson have done incredibly well for themselves. However, from a pure size perspective and principles aside, Mullenweg is the big nation army and Pearson is the small revolutionary militia. Mullenweg views Pearson as a threat to everything he stands for and has worked to accomplish, and Pearson views Mullenweg as an overbearing figure with no true authority over his decisions.</p>\n<p>Mullenweg has the motivation, resources, and ability to squash Pearson &#8212; and indeed most thought he&#8217;d done so already. While he has far fewer resources, Pearson has some tools available to protect his business or to potentially even disrupt the entire WordPress ecosystem as we know it today.</p>\n<p>During their first conflict in 2010, and in the resurgent one going on now, Mullenweg and Pearson have both at times made mistakes, acted childishly, or been in the wrong. Both also have merit in various aspects of their positions. Neither conflict, so publicly debated, reflects well on the WordPress ecosystem as a whole &#8212; even though I believe it is right that each conflict is best observed under a public eye, as the results can affect so many other businesses and potentially even WordPress itself.</p>\n<p>With this post, I aim to outline the entire conflict; to describe the implications past, present and future; to highlight non-WordPress comparisons for precedent and potential implications; and to share my own thoughts on who is in the right and who is in the wrong, as viewed for the good of the global WordPress community.</p>\n<h2>A history of conflict</h2>\n<p>The commercial theme movement started in 2007 and took off in 2008. Thesis was one of the pioneers of commercial WordPress themes. The theme industry was young and evolving rapidly, and many sellers hardly considered or understood licensing issues at all.</p>\n<p>Many of the sources for this period are from Siobhan McKeown&#8217;s excellent account in the book, <a href=\"https://github.com/WordPress/book\"><em>Milestones: The Story of WordPress</em></a> (which I&#8217;ll refer to as <em>Milestones</em>).</p>\n<h3>Themes as derivative works of WordPress</h3>\n<p>WordPress is licensed by the GNU General Public License (GPL), version 2 or later. The GPL ensures certain freedoms that protect both WordPress and those that utilize it. The &#8220;four freedoms&#8221; that are the heart of the GPL are as follows:</p>\n<blockquote>\n<ul>\n<li>The freedom to run the program as you wish, for any purpose (freedom 0).</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish (freedom 1). Access to the source code is a precondition for this.</li>\n<li>The freedom to redistribute copies so you can help your neighbor (freedom 2).</li>\n<li>The freedom to distribute copies of your modified versions to others (freedom 3). By doing this you can give the whole community a chance to benefit from your changes. Access to the source code is a precondition for this.</li>\n</ul>\n</blockquote>\n<p>As WordPress co-founder Mike Little phrased it in the Post Status Slack, &#8220;The GPL is meant to be restrictive for developers and permissive for users.&#8221; The <a href=\"https://gnu.org/philosophy/philosophy.html\">GNU philosophy page</a> and subsequent articles are a good resource for understanding the nature of the license.</p>\n<p>The GPL is a <a href=\"https://en.wikipedia.org/wiki/Copyleft\">Copyleft</a> license, which creates the &#8220;stipulation that the same rights be preserved in derivative works down the line.&#8221; In an immature theme market, licensing was given relatively little notice, and many theme authors provided their themes with no license or proprietary licenses.</p>\n<p>Matt Mullenweg, to many, would be considered <a href=\"https://en.wikipedia.org/wiki/Benevolent_dictator_for_life\">BDFL</a>, or Benevolent Dictator for Life, of WordPress. It&#8217;s a common term for folks that lead open source projects and have final say on project decisions. In his role as WordPress BDFL, he now has a reputation &#8212; at least within certain circles of folks that pay close attention &#8212; for making large, impactful decisions with little description of why he has done so.</p>\n<p>In late 2008, more than 200 free WordPress themes were removed from the WordPress.org theme repository. While many of the themes were removed due to spammy links, some were pulled due to GPL violations within the themes or within the theme upsells that were linked from the theme listings.</p>\n<p>The move, which was made without announcement, shocked many theme providers that felt they were unfairly included in the group of removed themes. The situation created a spark and initiated a serious debate about theme licensing.</p>\n<p>Authors were concerned that GPL licensed themes would mean that their themes would be bought and freely distributed, removing their ability to make money from their works. A few, such as Brian Gardner with his Revolution theme, <a href=\"http://www.blogherald.com/2008/10/01/brian-gardners-revolution-theme-goes-open-source/\">changed their licensing</a> as a result of conversations with Mullenweg and Toni Schneider, Automattic&#8217;s CEO at the time. In Brian&#8217;s case, he made his theme free and offered paid support services.</p>\n<p>Eventually though, most authors &#8220;selling&#8221; themes started actually selling support, access to download, and updates for their themes. This model was both GPL compatible, as well as workable for authors to get paid.</p>\n<p>In mid-2009, Matt Mullenweg also posted <a href=\"https://wordpress.org/news/2009/07/themes-are-gpl-too/\">on the official</a> WordPress blog that he was introducing a new <a href=\"https://wordpress.org/themes/commercial/\">commercial theme listing page</a> on WordPress.org, and he shared an opinion he requested from the Software Freedom Law Center (SFLC), where they determined that the two themes packaged with WordPress were derivative works.</p>\n<p>The SFLC opinion did leave room for a &#8220;split license&#8221; where the WordPress and PHP code must inherit the GPL, and the CSS, Javascript, and images could be under a proprietary license:</p>\n<blockquote><p>In conclusion, the WordPress themes supplied contain elements that are derivative of WordPress’s copyrighted code. These themes, being collections of distinct works (images, CSS files, PHP files), need not be GPL-licensed as a whole. Rather, the PHP files are subject to the requirements of the GPL while the images and CSS are not. Third-party developers of such themes may apply restrictive copyrights to these elements if they wish.</p>\n<p>Finally, we note that it might be possible to design a valid WordPress theme that avoids the factors that subject it to WordPress’s copyright, but such a theme would have to forgo almost all the WordPress functionality that makes the software useful.</p></blockquote>\n<p>&#8220;Split license&#8221; is the colloquial term the community has assigned to this statement, but in fact the actual splitting of which parts are GPL and which parts are not matters, so it may not do the reality of the situation justice. Perhaps it should be termed &#8220;PHPGPL&#8221; or &#8220;Non-Assets GPL&#8221;.</p>\n<p>A number of prominent theme sellers were unhappy with Mullenweg&#8217;s insistence that their themes maintain a 100% GPL license, but they were not willing to shake the boat over it. At this point, themes were becoming big businesses and making new millionaires (or close to it) of some of these shop owners. This settled the issue for nearly all theme sellers, and most moved to either 100% GPL or a PHPGPL license, and the doomsday scenarios never came; the theme industry continues to thrive.</p>\n<h3>Thesis holds out</h3>\n<p>But not everyone agreed to go either 100% GPL or PHPGPL license. Chris Pearson kept his Thesis theme under a proprietary license.</p>\n<p>Thesis was one of the most popular and flexible themes in the world, and Pearson <a href=\"https://github.com/WordPress/book/blob/925d7dc6293b1662a7e6839a2703e8a858c730ad/Content/Part%205/39-thesis.md\">boasted on Andrew Warner&#8217;s Mixergy podcast</a> of revenues of $1.2 million+ over the 12-18 month period prior to the interview. Mullenweg and Pearson criticized one another publicly, and Warner invited them both to Mixergy where they debated the merits of GPL licensing.</p>\n<p>By most accounts, Mullenweg had the better argument on the Mixergy episode, and also came off as a calmer and more collected personality &#8212; in contrast to Pearson&#8217;s often heated, and sometimes very strange, statements.</p>\n<p>The debate continued between Mullenweg, Pearson, and a variety of WordPress community members and their blogs. Mullenweg was extremely aggressive, to the extent that he <a href=\"https://twitter.com/photomatt/status/18548422506\">offered to buy</a> alternative commercial themes for users of Thesis that agreed to switch. Mullenweg tells me that many took him up on his offer, but it was, &#8220;less than a thousand.&#8221; In my opinion, this was a step too far by Mullenweg, though for him the issue was already personal.</p>\n<p>Pearson held his ground over the following days until an admission by one of his own team members of wholesale copying of code in Thesis from WordPress code, which violates the WordPress copyright.</p>\n<p>At this point, Pearson finally capitulated and announced that Thesis would be a split license GPL compatible theme, and the debate died down. Pearson put his head down and started working on Thesis 2.</p>\n<p>He released Thesis 2 in late 2012, and by this time the debate was cool &#8212; the community had moved on to other drama (yes, even more GPL drama) &#8212; and the release of Thesis 2 was largely ignored outside of DIYthemes&#8217; audience, which was quite large but also largely isolated from the WordPress &#8220;community&#8221; that cares about stuff like licensing.</p>\n<p>Therefore, not many people paid attention to the new Thesis or the licensing it contained. Mullenweg, however, was still paying attention.</p>\n<h2>The battle over thesis.com</h2>\n<p>If you consider the word <em>thesis</em>, what do you think of?</p>\n<p>If you are a regular person walking down the street, you probably think of the general concept for stating a theory, or perhaps you think of the long papers that university students write as part of their programs.</p>\n<p>If you are in the WordPress world, you may also consider the Thesis WordPress theme by DIYthemes.</p>\n<p>Good, single word domain names are hard to come by. Thesis.com, if you visit it now, redirects to the <a href=\"http://themeshaper.com\">ThemeShaper blog</a>. ThemeShaper is owned and operated by Automattic, and frequently posts articles about WordPress themes.</p>\n<p>ThemeShaper is not a dedicated commercial property, but it does link to Automattic&#8217;s primary website, and Automattic does make and sell WordPress themes.</p>\n<h3>Automattic buys thesis.com</h3>\n<p>Automattic hasn&#8217;t always owned <a href=\"http://thesis.com\">thesis.com</a>. Matt Mullenweg met a third party owner of the domain at a conference &#8212; a guy named Larry &#8212; and inquired about the domain by email in January of 2014. Chris Pearson had already attempted to purchase the domain from Larry, and did not agree to pay the $150,000 that Larry requested.</p>\n<p><a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">According to Pearson&#8217;s accounts</a>, he and Larry had a few exchanges that stalled with Pearson unwilling to bid beyond $37,500 for the domain, and Larry sticking to $150,000. With a $100,000 offer on the table from Mullenweg, Larry gave Pearson an opportunity to buy the domain for $115,000, which he didn&#8217;t do &#8212; in part because he thought it too expensive, but also because he suspected Larry didn&#8217;t really have the offer from Mullenweg.</p>\n<p>As we now know, Larry did have the offer and Automattic became the owner of the thesis.com domain name.</p>\n<p>Pearson didn&#8217;t know that Mullenweg actually bought the domain until November of 2014, when he was notified by a friend that Mullenweg&#8217;s WordCamp San Francisco State of the Word Q&amp;A session included a section where Mullenweg noted that he owned the domain (more on that later).</p>\n<h3>Pearson attempts to force domain transfer</h3>\n<p>On April 9th, 2015, Pearson and his lawyers filed a UDRP (Uniform Domain-Name Dispute Resolution Policy) complaint, which is a formal method for resolving domain disputes, recognized by ICANN. UDRP isn&#8217;t a formal government court, but serves as arbitration for domains due to the recognition by ICANN.</p>\n<p>There are many, many examples of UDRP complaints in regard to trademark infringement. There are a <a href=\"https://www.icann.org/resources/pages/policy-2012-02-25-en?routing_type=path\">number of criteria</a> that come into play that guide the UDRP panel&#8217;s decision making process.</p>\n<p>The three basic tenets that must be met are as follows:</p>\n<blockquote><p>(i) your domain name is identical or confusingly similar to a trademark or service mark in which the complainant has rights; and</p>\n<p>(ii) you have no rights or legitimate interests in respect of the domain name; and</p>\n<p>(iii) your domain name has been registered and is being used in bad faith.</p></blockquote>\n<p>The panel reviews the initial complaint (in this case, by Pearson) and gives the respondent (Automattic) an opportunity to respond. All correspondence is in writing and not in person. The panel has two weeks after everything has been submitted to reach a decision.</p>\n<p>In this case, which <a href=\"http://www.adrforum.com/domaindecisions/1613723.htm\">is available publicly</a>, the panel denied Pearson&#8217;s complaint.</p>\n<p>Pearson&#8217;s complaint cited that he fulfilled each of the three criteria:</p>\n<ul>\n<li>By noting his trademark of the word &#8220;thesis&#8221;.</li>\n<li>By noting that Automattic was using the domain with a commercial interest (by redirecting it to ThemeShaper).</li>\n<li>By noting the bad faith clause by citing that Automattic, &#8220;purchased the disputed domain name to confuse and redirect customers and potential customers to Respondent’s competing webpage.&#8221;</li>\n</ul>\n<p>In the response, Automattic did not contest Pearson&#8217;s trademark on the word <em>thesis</em>. However, Automattic also noted that the word is very generic, and also that ThemeShaper was not a commercial part of Automattic, but a &#8220;blogging site.&#8221;</p>\n<p>For the bad faith argument, Automattic claimed that the redirect to ThemeShaper furthers their, &#8220;purpose in providing a blogging site,&#8221; and highlights that the intention for the domain is not as a commercial entity or one to be confused with Pearson&#8217;s trademark.</p>\n<h3>Automattic wins dispute</h3>\n<p>Automattic won the dispute against Pearson. As noted, the panel had two weeks to deliver the decision, and Automattic proposed a settlement with Pearson before the decision was handed down.</p>\n<p>Pearson was considering the settlement when the decision came a day before the two week deadline, which is apparently not a common occurrence. Had the decision not come early, Pearson may have saved himself some trouble, especially in regard to eliminating the <a href=\"http://ttabvue.uspto.gov/ttabvue/v?qs=85115266\">trademark cancellation requests</a> by Automattic on <em>thesis</em> and related terms.</p>\n<p>In Pearson&#8217;s blog post, <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">The Truth about Thesis.com</a>, he notes the general terms of the proposed settlement:</p>\n<blockquote><p>Automattic’s attorneys drafted the original settlement, which included the following terms:</p>\n<ul>\n<li>Automattic would keep thesis.com</li>\n<li>Automattic would withdraw the federal trademark cancellation request</li>\n<li>I would withdraw the UDRP</li>\n<li>Both parties would mutually release one another (agree not to sue over this issue in the future)</li>\n</ul>\n<p>Nothing in the original settlement addressed the trademark infringement, and since this was the reason I took action in the first place, I added a requirement that Automattic no longer infringe upon my mark (which would mean they stop forwarding the domain).</p>\n<p>At this point in the proceedings, I agreed to the settlement.</p></blockquote>\n<p>However, since the decision came early, the settlement was never binding. It&#8217;s also worth noting that Mullenweg commented to me that Pearson&#8217;s stated terms are actually not the terms of the settlement:</p>\n<blockquote><p>In the settlement Automattic offered Chris we agreed not to infringe his trademarks (which is the law, regardless of what the settlement said). He never asked us to change the redirect of thesis.com in the settlement, and if he asked after, we would have said no. There were no restrictions on thesis.com in the settlement.</p></blockquote>\n<p>He also said, &#8220;I wish he had reached out before litigating,&#8221; and noted that it would have &#8220;definitely&#8221; changed the outcome of the entire situation. Whether it truly would have is neither here nor there.</p>\n<h3>Possibility for appeal</h3>\n<p>The UDRP doesn&#8217;t have an official appeals process. Instead, they are willing to not make the changes that a ruling states, if indeed a domain transfer or other action is ordered, if the affected party files a suit in court within ten days of the ruling.</p>\n<p>In this case, Pearson did not file in a court within the given timeline, and since the ruling did not require a change in domain ownership, there is no further recourse with the UDRP. However, there is no time limit if Pearson wishes to file in court &#8212; but that is the only path remaining if he truly wants to go after the domain.</p>\n<h3>Legitimacy of the trademark dispute</h3>\n<p>Trademark law has a long history. Trademarks follow a categorical system, meaning words and terms must be trademarked within a particular category to be applied to.</p>\n<p>Pearson has three trademarks for the Thesis and DIYthemes brands, all under <a href=\"http://www.oppedahl.com/trademarks/tmclasses.htm\">international trademark class</a> 42, for computer, scientific, and legal purposes:</p>\n<ul>\n<li>THESIS</li>\n<li>THESIS THEME</li>\n<li>DIYTHEMES</li>\n</ul>\n<p>The applications were filed in 2010 and registered in 2011. On June 16th, 2015, Automattic filed <a href=\"http://ttabvue.uspto.gov/ttabvue/v?qs=85115266\">cancellation requests</a> for all three trademarks, which were instituted June 25th. Pearson has 40 days from the date the application was instituted (which would be August 4th) to file a response to the cancellation requests. His answers, &#8220;must contain admissions or denials of the allegations in the petition for cancellation, and may include available defenses and counterclaims.&#8221; It is his burden as the defendant to establish his defense, and, &#8220;Failure to file a timely answer may result in entry of default judgment and the cancellation of the registration.&#8221;</p>\n<p>Basically, Automattic is holding his feet to the fire to defend the trademarks, which their counsel feels should not apply for two primary reasons, as listed in their <a href=\"http://ttabvue.uspto.gov/ttabvue/v?pno=92061714&pty=CAN&eno=1\">formal filing</a>.</p>\n<ul>\n<li>The trademarks were registered in Pearson&#8217;s own name, but are used by DIYthemes, and Automattic claims that, &#8220;The Pearson Applications were improperly filed in the name of an individual, who did not have the requisite intent-to-use the marks as of the filing date, and the underlying applications are void ab initio.&#8221; Their claim notes that US Code section <a href=\"https://www.law.cornell.edu/uscode/text/15/1051\">1051(b)</a> offers this justification.</li>\n<li>Furthermore, section <a href=\"https://www.law.cornell.edu/uscode/text/15/1052\">1052(e)(1)</a> requires that a trademark not be &#8220;merely descriptive,&#8221; as Automattic claims his trademarks are.</li>\n</ul>\n<p>If upheld, the trademarks will be deregistered by the US Patent Office, further limiting Pearson&#8217;s options to defend his claims to the thesis.com domain name in a formal court suit.</p>\n<p>I don&#8217;t know how good of a case Automattic has, but purely on the surface it looks pretty good. I spent time reviewing the application and the US Code and the arguments appear fairly sound &#8212; especially the argument that Pearson applied for the trademarks as an individual and utilizes them as DIYthemes, despite DIYthemes already having been registered as an LLC.</p>\n<h3>Automattic&#8217;s justification for the domain</h3>\n<p>During the <a href=\"https://videopress.com/v/WmCl2kwS\">WordCamp San Francisco Q&amp;A</a>, Mullenweg noted the existence of the redirect of the domain name with a sense of pride, and a bit of a side-eyed smirk. In response to a question about relationships with commercial theme sellers and marketplaces, he states:</p>\n<blockquote><p>With the premium theme and plugin folks? &#8230; We have had some ups and downs, particularly with marketplaces that didn&#8217;t follow the GPL, for example, or violated WordPress&#8217;s license &#8212; themes that violated WordPress&#8217;s license. Um, you can go to thesis.com to learn more about that. Type it in, seriously.</p></blockquote>\n<p>I was at this Q&amp;A in person, and don&#8217;t remember him saying this, as it was so buried in a much larger conversation, and I was simultaneously writing a wrap-up post about the State of the Word. However, once the UDRP ruling surfaced publicly, a number of WordPress community members recalled Matt&#8217;s statement and it brought a new dimension to the ruling and Mullenweg&#8217;s motivation for the domain.</p>\n<p>While Automattic bought the domain, Matt Mullenweg was clearly the driving force behind the decision. When <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">WP Tavern prompted Automattic</a> for a comment on their motivation for purchasing the domain, they responded with the following:</p>\n<blockquote><p>We’re happy the panel ruled in our favor. We think Thesis.com is a cool, generic .com that could be used for a variety of things. Just because you have a small WordPress theme doesn’t mean you have a right to seize generic English word .com domains.</p></blockquote>\n<p>We can accept Automattic&#8217;s case that they had a general interest in a generic .com domain, but in reality we know better. Mullenweg was clearly presented with an opportunity by this Larry character that checked all of the right boxes for him.</p>\n<p>He could get a domain he obviously knew Pearson would want, and deny him.</p>\n<p>It has a side benefit that it <em>is</em> a high quality generic domain that will likely maintain or increase its value. And he probably thought it was funny.</p>\n<p>I doubt Mullenweg even knew what kind of trademarks Pearson held, but despite Pearson holding the trademarks, it seems Automattic&#8217;s attorneys now have the upper hand, and it is highly unlikely Pearson will ever own the domain now.</p>\n<p>Mullenweg <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks#comment-70849\">commented</a> on his refusal to give up the domain to Pearson on WP Tavern:</p>\n<blockquote><p>I’m not going to give a domain worth several hundred thousand dollars to the worst actor in the entire WP ecosystem, someone who keeps repeatedly violating the GPL and now has gone beyond that into patents. Why reward that? I wouldn’t sell it if he offered a million dollars.</p>\n<p>There are so many people doing amazing things in the WP community, and 100% GPL! I can and have supported them almost every opportunity I can, and one of the things I’m most proud of in the world is how many fantastic open source businesses have been built on top of WordPress.</p>\n<p>And it’s just the beginning — if you remembered in 2010 Chris said that going GPL would destroy businesses and sticking to the principles of our license would destroy investment in WordPress — we all know how that’s worked out since then.</p></blockquote>\n<p>Such a statement, combined with the WCSF video, highlights that the issue is about far more than the domain and its investment potential &#8212; a 10x return in less than a year would make for an excellent investment, in the near impossible situation Pearson would offer that.</p>\n<p>No, the move was quite clearly a personal one &#8212; if also convenient &#8212; for Mullenweg, and that&#8217;s why terms like &#8220;bully&#8221;, &#8220;petty&#8221;, and &#8220;spiteful&#8221; have been used by many WordPress community members surprised by his actions. They expected more. They expected better, even when directed toward someone as controversial as Chris Pearson.</p>\n<h2>Pearson&#8217;s patent</h2>\n<p>While a tantalizing story, the battle over thesis.com is not <em>the</em> story here. It has simply been the spark to reignite old disputes with new fervor with potentially much bigger consequences than the 2010 affair ever reached.</p>\n<p>One of two additional large components of this story is an active patent application by Pearson that was submitted in 2012 and published in 2014. Keep in mind &#8212; and Chris Pearson reiterated this to me many times &#8212; it is an application for a patent, not a published patent.</p>\n<h3>A patent on Thesis 2, or all web templates?</h3>\n<p>The main patent is titled, <a href=\"https://patents.google.com/patent/US20140095982A1/en?q=thesis&q=diythemes\"><em>Systems, Servers, and Methods for Managing Websites</em></a>. Chris Pearson is listed as the inventor and DIYthemes the assignee.</p>\n<p>The patent never mentions WordPress or WordPress themes, however both in the abstract and in the text, it does have many similarities to what one may expect as a description of a general template mechanism for a website, versus a specific description of the Thesis 2 technology.</p>\n<p>Here is the abstract in full (and here is the <a href=\"https://poststatus.com/wp-content/uploads/2015/07/US20140095982-thesis-patent-app.pdf\">full patent application PDF</a>, including art):</p>\n<blockquote><p>Systems, servers, and methods for managing websites. Some embodiments provide methods which include, according to a user selection of a website skin, activating the selected skin. The skin comprises at least one structural box further comprising structural code for the website. The method also includes receiving a request (for instance a call to a hook) to serve the website. Further, the method includes, responsive to the request, outputting (by echoing PHP code if desired) the structural code with style related code applied thereto according to a reference between the box and a style package (which comprises the stylistic code). The outputting can occur in an order associated with the boxes. In some situations, another skin can be activated. Moreover, a change (or, perhaps, an edit) can be made to another skin and displayed without affecting the website. Moreover, another skin can be selected and associated with the website.</p></blockquote>\n<p>I discussed the patent at length with Chris Pearson, and while much of that conversation is off the record, I can share what I believe his motivations are with the patent application, and what I think the potential implications for this new chapter of Pearson versus Mullenweg are.</p>\n<h3>Discovery and publicity of the patent</h3>\n<p>This patent and another that&#8217;s since been rescinded were discovered by Automattic&#8217;s lawyers during the UDRP proceedings. There is debate as to how members of the WordPress community discovered the patents&#8217; existence &#8212; Jeff Chandler of WP Tavern and Carl Hancock of Gravity Forms were two of the first to discuss it publicly &#8212; but there is speculation from Chris Pearson and others that the community discovery of these patents was leaked by Mullenweg himself in order to deflect the attention at the time away from the domain issue and onto the patents and their potential implications.</p>\n<p>I honestly don&#8217;t care how they came up, though Pearson&#8217;s questioning of Jeff Chandler&#8217;s journalistic integrity were uncalled for. It is anyone&#8217;s right and ability to tip someone off to legitimate news &#8212; and these patent applications are legitimate news &#8212; and I don&#8217;t believe for a second that Chandler has played puppet to his boss&#8217;s wishes. He has dutifully and to the best of his ability written about whatever news matters to the community, and I respect him for it.</p>\n<p>Nevertheless, this patent does potentially have significantly more newsworthiness, depending on if it is approved and how it is defended by Pearson if it is approved.</p>\n<h3>Patent law and litigation</h3>\n<p>Patents often get a bad reputation, and their role in the software world is quite murky. I apologize in advance for this long sidebar on the wild world of patents.</p>\n<h4>Patent trolls</h4>\n<p>Most folks have heard of &#8220;patent trolls&#8221; that prey on companies using vague or overly generic patents, demanding big payouts.</p>\n<p>Patent law is weird, and the lawsuits that result are infamously unpredictable and cause a scenario ripe for abuse. For example, filing patent lawsuits in one district over another can have enormous impact, like <a href=\"http://www.nytimes.com/2006/09/24/business/24ward.html?pagewanted=all&_r=0\">the case of Marshall, Texas</a>, which is a hotbed for patent trolls:</p>\n<blockquote><p>Patent litigation is a growing business across the country; Marshall is just the most visible example. Among the weightier issues behind the mushrooming of its patent docket is whether the elements that have made it expand — hungry plaintiffs’ lawyers, speedy judges and plaintiff-friendly juries — are encouraging an excess of expensive litigation that is actually stifling innovation.</p>\n<p>Some say yes. “A lot of the cases being filed in Marshall are by patent holding companies, or patent trolls, as they’re called, whose primary and only assets are patents,” Mr. Tyler said.</p></blockquote>\n<p>Companies that deal in patents but do not utilize the patented technology are <a href=\"https://www.patentfreedom.com/about-npes/background/\">called non-practicing entities (NPEs)</a>.</p>\n<p>One of the concerns with Pearson&#8217;s patent would be if it were approved and he sold it to an NPE. It&#8217;s not uncommon for NPEs to acquire patents with the express purpose to enforce them:</p>\n<blockquote><p>Finally, of course, some entities buy patents with the express purpose of licensing them aggressively. For instance, about 25% of “parent” NPEs tracked by PatentFreedom are enforcing only patents that they had acquired. Another 60% are asserting patents originally assigned to them, and the remaining 15% are asserting a blend of originally assigned and acquired patents. However, if we add in the more than 2,100 subsidiaries and affiliates of these entities and treat them all as standalone entities, we find that 19% of them are originally assignees, and 69% are acquirers, and 12% are blends.</p>\n<p>Regardless of the important variations in their origin and behavior, NPEs present a fundamentally different challenge than operating company patent assertions.</p></blockquote>\n<h4>Software patents unpredictability and &#8220;obviousness&#8221;</h4>\n<p>The concept of software patents <em>at all</em> has been in dispute for a long time. Thousands have been awarded, but there are a handful of past court rulings that seem to <a href=\"https://www.law.cornell.edu/uscode/text/35/part-II/chapter-10\">govern the US Patent and Trademark office&#8217;s interpretations</a> for making decisions when reviewing software patents.</p>\n<p><a href=\"http://www.ipwatchdog.com/2014/02/01/when-is-an-invention-obvious/id=47709/\">Obviousness</a> is a key term in the patent world. Patent applicants aim to create &#8220;meaningful&#8221; patents, but &#8220;at a minimum you must have claims that embody patent eligible subject matter, demonstrate a useful invention, cover a novel invention and which are non-obvious in light of the prior art. Obviousness is typically the real hurdle to patentability, and unfortunately the law of obviousness can be quite subjective and difficult to understand. At times obviousness determinations almost seems arbitrary.&#8221;</p>\n<p>&#8220;Art&#8221; is the outlay of the invention by the applicant, and the invention&#8217;s ability to be patented depends on &#8220;prior art&#8221; not deeming the invention as obvious. Establishing non-obviousness for software has a contentious history. If it can be shown that, &#8220;any combination of prior art references that when put together would be the invention in question,&#8221; then the applicant is in trouble.</p>\n<p>But there is a great deal of potential for subjectivity from thousands of patent examiners:</p>\n<blockquote><p>Still, ever since the Supreme Court’s decision in KSR [<a href=\"http://www.ipwatchdog.com/2012/04/29/ksr-the-5th-anniversary-one-supremely-obvious-mess/id=24456/\">reference</a>] there has been a great deal of subjectivity in the application of the law of obviousness, which is apparent if you look at the patents that issue, patents that are finally rejected and ultimately abandoned, and the patents the Federal Circuit ultimately finds to include obvious patent claims. There is little to no predictability at the edges.</p></blockquote>\n<h4>The Alice case</h4>\n<p>In my research, the <em>Alice case</em> came up many times as a pivotal case for helping to define the legitamacy of software patents. Martin Goetz is the holder of the first ever software patent, and has <a href=\"http://www.ipwatchdog.com/2015/02/06/alice-v-cls-bank-is-a-victory-for-software-patents/id=54489/\">an excellent write-up on the importance of the Alice case</a>.</p>\n<blockquote><p>I have been asked for my opinion based my long history in the software industry and from my perspective as someone that has followed that controversial question “Is Software patentable”? That question first began to be publicly debated when I received the first software patent in 1968 for an invention on a new way of sorting data on a computer. Shortly thereafter a publication printed a page one headline “First Patent is Issued for Software, Full Implications Are Not Yet Known.”</p>\n<p>Forty five years later a variation of that question was again before the Supreme Court when it agreed to hear the appeal of the Alice v. CLS Bank case.</p></blockquote>\n<p>Goetz argues that the Alice case is a victory for software patents on both sides: that it helps true inventions gain patents (he and others assign a high standard to define &#8220;invention&#8221;), and it also helps prevent abuse of overly vague or non-inventive &#8220;obvious&#8221; patents to be denied:</p>\n<blockquote><p>The Alice v CLS Bank Supreme Court decision in June 2014 was a great victory for those that believe that inventors that use a digital computer to innovate can get a patent on their invention. It is also a victory for those people and organizations that recognize how the patent System has been abused for many years by trolls and others where there was no invention. Since the Supreme Court decision in June, thousands of patents that should never have been issued are now being deemed invalid by the US Courts and by the Patent Office.</p></blockquote>\n<h4>Obviousness and invention for Pearson&#8217;s patent</h4>\n<p>This long and boring description of patents is necessary because Pearson&#8217;s patent application is still just an application, and it can be challenged, both by the patent reviewer, but also by third parties.</p>\n<p>As patent obviousness is &#8220;so unevenly applied,&#8221; there is some risk in not challenging Pearson&#8217;s patent, if a third party like Automattic (or a myriad of other web template providers) is worried about the potential implications of the patent. Although, the Alice case does seem &#8212; in my very amateur opinion &#8212; to offer better guidance to reject the patent based on a lack of true invention.</p>\n<h3>Pearson&#8217;s reasoning for a patent, and its likelihood for success</h3>\n<p>Patents are not cheap to apply for. The patent application Pearson submitted is 34 pages of art diagrams and text describing the inventiveness of Thesis 2, though Thesis 2 is not specifically named.</p>\n<p>I asked Pearson why he applied for the patent, which he did not want to share the specifics of his position due to the open nature of the application. I&#8217;ve racked my brain to try and determine the potential causes as well.</p>\n<p>There are only a couple of decent outcomes for Pearson with this patent application. The most likely, and not good outcome for him, is that he is denied the patent; and in this case he would have spent a great deal of money for nothing.</p>\n<p>In the event he does get the patent &#8212; or perhaps even before it is fully reviewed for approval &#8212; he could face a challenge from Automattic or other parties that may be concerned his invention&#8217;s description could apply more broadly than Thesis 2.</p>\n<p>If he gets the patent, and he survives a challenge, I see three ways he could theoretically use it:</p>\n<ul>\n<li>He can do nothing.</li>\n<li>He can sell it to the highest bidding NPE, which would be a dreadful outcome for any web entities that sell templates.</li>\n<li>He can keep it in his back pocket, in case someone threatens his business or his software license, wherein he can initiate a lawsuit.</li>\n</ul>\n<p>Honestly, the whole patent route seems odd. I don&#8217;t love the idea of this patent being approved, because the application does seem overly broad toward all web templates to me, from the title to the meat of the application&#8217;s art. However, there are loads of patents in the world for incredibly silly things that have never really impacted a lot of folks&#8217; life; it&#8217;s just that it doesn&#8217;t mean a silly patent <em>couldn&#8217;t</em> become a problem. The Electronic Frontier Foundation has <a href=\"https://www.eff.org/patent\">mountains of evidence</a> of patent holders causing havoc.</p>\n<p>I&#8217;m not much of a gambler, but if I had to gamble on this I&#8217;d put my money on this patent never being approved, and definitely never truly impacting the web or WordPress industry at scale.</p>\n<p>I don&#8217;t think Pearson is a bad guy for wanting to patent his work. When I requested comment about the patents, he told me, &#8220;If I were ever to consider selling my business, things like trademarks and patents show up on the balance sheet and add to the bottom line,&#8221; but that he views them as, &#8220;one of many expensive, ridiculous options for bolstering one&#8217;s business,&#8221; versus a way to celebrate and protect his achievements as I previously characterized his intentions.</p>\n<h2>The GPL</h2>\n<p>Most agree that the GPL has not been well tested in court, though a <a href=\"https://en.wikipedia.org/wiki/Software_license\">software license</a> is a &#8220;legal instrument.&#8221; There is often confusion over whether a license is a contract or not.</p>\n<h3>License versus contract</h3>\n<p>One of my favorite <a href=\"http://softwarelawyer.blogspot.com/2008/01/jacobsen-v-katzer.html\">things I&#8217;ve read on this</a> is by former Adobe Associate General Counsel Robert Pierce:</p>\n<blockquote><p>A license is not a contract. This much I know.</p>\n<p>Rather, a license is a permission granted by one party to another allowing use of a property without fear of lawsuit brought by the granting party. A license does not include a return promise (i.e., consideration) from the licensee. So, as we all learned in law school, a license cannot be a contract under law. This is not to say that a license cannot be an element of a contract under which two parties trade promises, one of such promises being a license. This is commonly known as a &#8220;license agreement.&#8221; But a bald license, a one-way promise, is enforceable outside of contract law. It is something apart. It exists and is enforceable under property law doctrine.</p>\n<p>What makes things difficult is that the scope of a license&#8217;s grant, and the conditions and restrictions on the license (or all of them together) can make what is intended to be a one-way license look a lot like a contract. The precise wording used becomes critical.</p></blockquote>\n<p>The distinction can be significant because, &#8220;contracts are enforceable by contract law, whereas licenses are enforced under copyright law,&#8221; though even this rule depends on the jurisdiction where the matter is being discussed. His larger point is that a license is a one-way street, whereas a contract is agreed upon by both sides.</p>\n<h3>Spirit of the GPL</h3>\n<p>There is little debate that a &#8220;Split GPL&#8221; or &#8220;PHP GPL&#8221; license is perfectly GPL compatible, though Mullenweg doesn&#8217;t consider that the &#8220;<a href=\"https://github.com/WordPress/book/blob/e55a93f1056ffac8466944086b2c5104becab9c4/Content/Part%206/42-spirit-of-the-gpl.md\">spirit of the GPL</a>,&#8221; and companies like Envato&#8217;s ThemeForest and others have felt the consequences of not adopting 100% GPL licenses.</p>\n<p>From <em>Milestones</em>:</p>\n<blockquote><p>While not everyone liked the fact that the WordPress project would only support 100% GPL products, most people had accepted it. Many, however, were taken by surprise, by a sudden flare-up around not just the legalities of the GPL, but the “spirit” of the license. In a 2008 interview, Jeff Chandler asks Matt about the spirit of the GPL. Matt says that the spirit of the GPL is about user empowerment, about the four freedoms: to use, distribute, modify, and distribute modifications of the software. Software distributed with these four freedoms is in the spirit of the GPL. WordPress was created and distributed in this spirit, giving users full freedom with regard to the software.</p>\n<p>The Software Freedom Law Center&#8217;s opinion &#8212; with regards to WordPress themes, however &#8212; gives developers a loophole, one that helps them achieve GPL compliance, but denies the same freedoms as WordPress. PHP in themes must be GPL, but the CSS, images, and JavaScript do not have to be GPL. This is how Thesis released with a split license &#8212; the PHP was GPL, while the rest of the code and files were proprietary. This split license ensures that the theme is GPL compliant yet it isn&#8217;t released under the same spirit as the GPL&#8217;s driving user-freedom ethos.</p>\n<p>The loophole may have kept theme sellers in line with the GPL, but WordPress.org didn&#8217;t support that approach. In a 2010 interview, Matt says “in the philosophy there are no loopholes: you’re either following the principles of it or you’re not, regardless of what the specific license of the language is.&#8221; Theme sellers that sell their themes with a 100% GPL license are supported by WordPress. Those that aren’t don’t get any support or promotion on WordPress.org or on official resources. This is also one of the WordCamp guidelines, introduced in 2010; that WordCamps should promote WordPress’ philosophies. If a speaker, volunteer, or organizer is distributing a WordPress product it needs to be 100% GPL, i.e., the CSS, JavaScript, and other assets need to be GPL, just like the PHP.</p></blockquote>\n<p>Mullenweg believes that Thesis 2 is not only not in the spirit of the GPL, but flagrantly operates in total violation of it, as Thesis 2 carries a 100% proprietary license. Considering the implications for folks that make stuff compatible with the GPL, it&#8217;s little surprise that Mullenweg has taken the stance and actions he has toward Pearson.</p>\n<h3>Thesis 2 carries a proprietary license</h3>\n<p>Chris Pearson&#8217;s <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php#comment-1507962\">comment on his blog post</a> describes that the theme has always been a proprietary license, and he describes why it is okay to be such:</p>\n<blockquote><p>In October 2012, I released an all-new version of Thesis that carried the same name as the original (which had a split-GPL license), but that’s where the similarities stopped.</p>\n<p>The new Thesis is not a Theme—it is an operating system for templates and design. This system runs Skins and Boxes, which are similar to Themes and Plugins, but with a boatload of built-in efficiencies that Themes and Plugins cannot provide.</p></blockquote>\n<p>It is worth noting the final paragraph of the SFLC&#8217;s opinion that Mullenweg has cited numerous times as justification against proprietary licenses <em>does</em> have a provision for avoiding WordPress&#8217;s copyright:</p>\n<blockquote><p>Finally, we note that it might be possible to design a valid WordPress theme that avoids the factors that subject it to WordPress’s copyright, but such a theme would have to forgo almost all the WordPress functionality that makes the software useful.</p></blockquote>\n<p>That&#8217;s exactly what Pearson believes Thesis 2 is. But the GPL has rarely been tested in a proper court, and never from a WordPress perspective. The SFLC&#8217;s opinion is just that, for now, whether Mullenweg likes it or not.</p>\n<h3>The GPL in court</h3>\n<p>The Free Software Foundation maintains the copyright on the text of the GPL itself, and between the FSF and the SFLC, a <a href=\"https://en.wikipedia.org/wiki/GNU_General_Public_License#Legal_status\">small number of lawsuits</a> have occurred, and a German court upheld the GPL as a &#8220;valid, legally binding&#8221; license, but most of these tests have occurred outside of the United States. From what I can tell, cases involving the GPL have largely settled outside of court when based in the United States, or were argued on whether the GPL was legally applied, like in the case of <a href=\"https://en.wikipedia.org/wiki/SCO_Group,_Inc._v._International_Business_Machines_Corp.#The_GPL_issue\">SCO vs IBM</a>, rather than whether the GPL was legally binding itself.</p>\n<p>In another case, <a href=\"https://en.wikipedia.org/wiki/Wallace_v._International_Business_Machines_Corp.\">Wallace vs FSF</a>, Daniel Wallace compared the GPL to price fixing, as it required software to be free. The FSF won the case, as the judge cited, &#8220;The GPL encourages, rather than discourages, free competition and the distribution of computer operating systems, the benefits of which directly pass to consumers. These benefits include lower prices, better access and more innovation.&#8221;</p>\n<p>A much <a href=\"http://www.infoworld.com/article/2893695/open-source-software/vmware-heading-to-court-over-gpl-violations.html\">newer case involving VMware</a> again tests the GPL. The Software Freedom Conservancy, &#8220;claims VMware is using the Linux kernel without respecting the terms of its copyright license, the GPL.&#8221; This case may offer a better precedent for WordPress and its derivative works, as it is centered on &#8220;module loading&#8221; in VMware, &#8220;with an insulating layer to allow its kernel to use unmodified Linux drivers.&#8221; The case gets murkier than that, as it may not have been as isolated as it was attempted, but the result could be decent precedent for similarly loading WordPress themes and plugins, in my opinion.</p>\n<h3>Limited guidance</h3>\n<p>Few lawyers want to be the first to test something in court. It&#8217;s easier to make a case when there are many cases before you to provide guidance. With the GPL, there is what&#8217;s called &#8220;limited guidance,&#8221; meaning that it&#8217;s untested, and therefore the outcome of a GPL case in the US could be very difficult to predict.</p>\n<p>If a lawsuit does occur, it could prove costly to all parties involved, and I think it&#8217;s clear that Pearson and Mullenweg both wish that litigation was not happening, though both of them maintain a bit of a &#8220;you started it&#8221; attitude.</p>\n<p>Without a formal court proceeding, which could last years, it&#8217;s going to be near impossible for Matt Mullenweg to fully prevent non-GPL compatible licenses to exist for WordPress themes and plugins. His best method to prevent it is to do what he&#8217;s done so far: make an example of bad offenders and cause anyone thinking of using a non-GPL compatible license to reconsider.</p>\n<h2>Are all WordPress themes derivative works?</h2>\n<p>A key question to whether themes and plugins must be GPL compatible licensed is whether the theme or plugin is a derivative of WordPress itself. If it is derivative, then it is under the umbrella of the GPL&#8217;s Copyleft nature.</p>\n<p>Folks disagree a good bit on how themes and plugins should be considered as derivative works, though most either agree with Mullenweg&#8217;s strict &#8220;spirit of the GPL&#8221; view, or at least have molded to avoid being an outcast.</p>\n<p>The strongest argument I&#8217;ve seen in favor of all themes being derivative of WordPress &#8212; no matter how much or little they rely on WordPress functionality &#8212; is from WordPress lead developer Mark Jaquith:</p>\n<blockquote><p>There is a tendency to think that there are two things: WordPress, and the active theme. But they do not run separately. They run as one cohesive unit. They don’t even run in a sequential order. WordPress starts up, WordPress tells the theme to run its functions and register its hooks and filters, then WordPress runs some queries, then WordPress calls the appropriate theme PHP file, and then the theme hooks into the queried WordPress data and uses WordPress functions to display it, and then WordPress shuts down and finishes the request. On that simple view, it looks like a multi-layered sandwich. But the integration is even more amalgamated than the sandwich analogy suggests.</p>\n<p>Here is one important takeaway: <em>themes interact with WordPress (and WordPress with themes) the exact same way that WordPress interacts with itself</em>. Give that a second read, and then we’ll digest.</p>\n<p>The same core WordPress functions that themes use are used by WordPress itself. The same action/filter hook system that themes use is used by WordPress itself. Themes can thus disable core WordPress functionality, or modify WordPress core data. Not just take WordPress’ ultimate output and change it, but actually reach into the internals of WordPress and change those values before WordPress is finished working with them. If you were thinking that theme code is a separate work because it is contained in a separate file, also consider that many core WordPress files work the same way. They define functions, they use the WordPress hook system to insert themselves at various places in the code, they perform various functions on their own but also interact with the rest of WordPress, etc. No one would argue that these core files don’t have to be licensed under the GPL — but they operate in the same way that themes do!</p>\n<p>It isn’t correct to think of WordPress and a theme as separate entities. As far as the code is concerned, they form one functional unit. The theme code doesn’t sit “on top of” WordPress. It is within it, in multiple different places, with multiple interdependencies. This forms a web of shared data structures and code all contained within a shared memory space. If you followed the code execution for Thesis as it jumped between WordPress core code and Thesis-specific code, you’d get a headache, because you’d be jumping back and forth literally hundreds of times. But that is an artificial distinction that you’d only be aware of based on which file contained a particular function. To the PHP parser, it is all one and the same. There isn’t WordPress core code and theme code. There is merely the resulting product, which parses as one code entity.</p></blockquote>\n<p>Jaquith&#8217;s argument that the theme and WordPress execute together to form a joint &#8220;modified work&#8221; is the key phrase, I believe. As he states, and I tend to agree, it does not matter that the files are separate or that they can be distributed independently; together, when executed, they are so intertwined that they become a single work.</p>\n<p>That said, the theme is clearly dependent on WordPress itself, which is another common justification that themes are derivative. Explaining this concept is simple: WordPress can be distributed without any theme but those that ship with it by default. But a distributed theme, like Thesis, must be <em>installed and activated using WordPress&#8217;s own schema for loading a template</em>, and cannot operate independently of WordPress.</p>\n<h3>What about the WordPress REST API?</h3>\n<p>Thus far, we&#8217;ve discussed the derivative nature of WordPress themes and plugins, which require they operate within the WordPress install. It is a different matter if we consider applications that consume data or interact with WordPress as an outside application.</p>\n<p>The WordPress REST API enables one to interact with or consume data from WordPress, while being wholly independent of the WordPress install. Jaquith makes a clear exception for a scenario like this (and also applies it to technologies like RSS and XML-RPC):</p>\n<blockquote><p>Something that interacts with these APIs sits entirely outside of WordPress. Google Reader doesn’t become part of WordPress by accessing your feed, and MarsEdit doesn’t become part of WordPress when you use it to publish a post on your WordPress blog. These are separate applications, running separately, on separate codebases. All they are doing is communicating. Applications that interact with WordPress this way are separate works, and the author can license them in any way they have authority to do so.</p></blockquote>\n<h3>The GNU&#8217;s take</h3>\n<p>The GNU agrees with Jaquith&#8217;s take. They provide <a>an FAQ</a> to answer, &#8220;&#8221;What is the difference between an &#8216;aggregate&#8217; and other kinds of &#8216;modified versions&#8217;?&#8221; The emphasis provided is my own:</p>\n<blockquote><p>An “aggregate” consists of a number of separate programs, distributed together on the same CD-ROM or other media. The GPL permits you to create and distribute an aggregate, even when the licenses of the other software are non-free or GPL-incompatible. The only condition is that you cannot release the aggregate under a license that prohibits users from exercising rights that each program&#8217;s individual license would grant them.</p>\n<p><em>Where&#8217;s the line between two separate programs, and one program with two parts? This is a legal question, which ultimately judges will decide</em>. We believe that a proper criterion depends both on the mechanism of communication (exec, pipes, rpc, function calls within a shared address space, etc.) and the semantics of the communication (what kinds of information are interchanged).</p>\n<p><em>If the modules are included in the same executable file, they are definitely combined in one program. If modules are designed to run linked together in a shared address space, that almost surely means combining them into one program</em>.</p>\n<p>By contrast, pipes, sockets and command-line arguments are communication mechanisms normally used between two separate programs. So when they are used for communication, the modules normally are separate programs. But if the semantics of the communication are intimate enough, exchanging complex internal data structures, that too could be a basis to consider the two parts as combined into a larger program.</p></blockquote>\n<p>The GNU argument falls very much in line with Jaquith&#8217;s, though admits itself that judges must decide whether it&#8217;s the case, in the end.</p>\n<h3>The case against The GNU position on derivative works</h3>\n<p>The University of Washington School of Law has a <a href=\"http://www.law.washington.edu/lta/swp/index.html\">section of their website</a> devoted to the, &#8220;business, legal and technical consequences of choosing Open Source Software (OSS) or proprietary software.&#8221; They cover many of the topics I&#8217;ve outlined in this post so far, and <a href=\"http://www.law.washington.edu/lta/swp/Law/derivative.html\">in the case of the GPL and derivative works</a>, they believe the GNU is overstepping with an &#8220;expansive definition&#8221; of derivative works with consequences, &#8220;counter to the goals of the proponents of Free Software.&#8221;</p>\n<p>The most compelling of multiple derivative works examples they provide is that of subclasses. For example, imagine a class, <code>Some_Theme_Class</code> that extends <code>Some_Core_WordPress_Class</code>. The GPL FAQ is very hardline on the topic (and for what it&#8217;s worth, Thesis 2 does extend some WordPress core classes). Washington believes the GNU stance on inheritance is too over-reaching:</p>\n<blockquote><p>Example 5: Programmer X wishes to write a class D, that is a subclass of existing class B. Class B is subject to the terms of the GPL. If X distributes D, does it have to be licensed under the terms of the GPL?</p>\n<p>The answer given in the GPL FAQ is short and to the point: &#8220;Subclassing is creating a derivative work.&#8221; In our example, this makes D a work derived from B, and thereby makes D subject to the terms of the GPL upon distribution. This approach attempts to further broaden the reach of the GPL, but it again leads to counter-intuitive results.</p>\n<p>Typical object oriented programming languages include a standard class hierarchy. This hierarchy provides a framework within which application developers can build their programs. The standard classes typically provide useful classes that represent user interface elements (e.g. windows, buttons, etc.), collection classes (for handling collections of data), and input-output abstractions (e.g. files and networking connections). In many object oriented languages, each class must be a subclass of exactly one superclass. And for this reason, the class hierarchies are rooted by a highly generic, standard class called Object. (The question of the superclass of Object is beyond the scope of this article.) The class Object describes only the most general properties and behaviors. For instance, in Java, the class Object only performs a handful of functions. In Java, every class is a subclass (directly or indirectly) of the Object class. Under the GPL approach, then, every program written in Java is a derived work of Object, because every program written in Java by definition consists of classes that inherit from the Object class.</p></blockquote>\n<p>Whether this argument or any of the others Washington outlines would apply to WordPress themes and/or plugins would, again, need to be settled in court. But Washington does give a compelling argument.</p>\n<p>They conclude with the following:</p>\n<blockquote><p>In some ways, the apparent weaknesses in the GPL should come as no surprise, as the GPL was born of an era in which the central artifact of software development and distribution was the monolithic executable. In such a universe, software development proceeded principally by modifying the existing source text of programs, compiling source modules, linking the corresponding object files, and distributing the resulting executable. This model of software development and distribution has become increasingly fractured in an era characterized by highly dynamic, late binding, object- and network-based systems. The GPL, consequently, strains to cover these newly arising scenarios.</p>\n<p>To effectuate the goals of the free software movement, the drafters of the GPL urge a generally expansive definition of derivative work. The great irony is, of course, that such an expansive definition would have second order consequences that are exactly counter to the goals of the proponents of Free Software. A broad definition of derivative would give code authors less freedom to create software that they can truly call their own and do with as they please. And if naive analytic approaches such as &#8220;subclassing equals derivation&#8221; reign, then proprietary vendors such as Microsoft could arguably stake claim to every program ever written in C#, because they authored the original class hierarchy. And since it seems unlikely that courts would employ different standards depending on the goals or ideological motivations of licensors, proponents of free software might want to be careful what they wish for: what&#8217;s good for the GNU might not be good for the gander.</p></blockquote>\n<h3>Aggressive license agreements</h3>\n<p>Both the GPL and DIYthemes&#8217; proprietary license could be appropriately identified as aggressive. The Copyleft nature of the GPL annoys many open source advocates, who would prefer a less restrictive license for developers, like the MIT or BSD licenses. The GPL is absolutely an opinionated license.</p>\n<p>Pearson&#8217;s proprietary license is also aggressive, in the other direction. I&#8217;ve never purchased a WordPress-centric product that so strongly forced me to accept a license. Usually, you have to look in the source code or a page on the website for a license; DIYthemes forces you to accept the <a href=\"http://diythemes.com/thesis/rtfm/software-extensions-license-agreement/\">terms of the proprietary license</a> before you can download the product at all.</p>\n<h3>Derivative works are not a bright line</h3>\n<p>The GNU attempts to offer a &#8220;bright line&#8221; distinction for derivative works. A bright line, in much of the legal analysis I&#8217;ve read, is where <em>thing x</em> is so because of <em>thing y</em>, and can be applied across the board. You can clearly see the bright line, and when it has been crossed.</p>\n<p>Washington proves the point quite well that the GNU&#8217;s bright line approach to derivation is quite challengeable. But I don&#8217;t think their arguments prove that WordPress themes in particular are not derivative. I believe, from a legal perspective, it&#8217;s fuzzier than a bright line approach, and if I were Mullenweg or anyone defending GPL software, I would not be excited to take the issue to court.</p>\n<p>The &#8220;spirit of the GPL&#8221; is to offer users liberal freedoms, even while restricting developers building on a GPL licensed application. And I believe there is merit in the fact that WordPress, its co-founders, its lead developers, and the vast majority of its copyright holders (contributors) wish to defend the spirit of the license, even if it&#8217;s not been tested in court.</p>\n<p>Pearson is not in the majority opinion by using a proprietary license, but he is also not definitively in a position of legal wrongdoing. His desire to protect his works from user freedoms with a proprietary license may well be tested all the way to the courts, and he must be prepared to deal with that, but I don&#8217;t believe there is clear wrongdoing, legally, with his license.</p>\n<h2>A tale of idealism</h2>\n<p>Matt Mullenweg and Chris Pearson are two of the most idealistic people I&#8217;ve ever observed. They are near polar opposites, from their business belief systems and even their general world views.</p>\n<p>One of the most depressing components of my research was something Pearson told me. I asked him why he doesn&#8217;t just get out of it all and do something else. He&#8217;s not married to the culture of WordPress bestowed on it by its leaders. He called it, the &#8220;zeitgeist of western culture,&#8221; with its openness, zen attitude, and more that he feels no need to embrace if he doesn&#8217;t want to.</p>\n<p>But he admits that WordPress, &#8220;is the most used piece of software to build a website in the world. WordPress was the beneficiary of impeccable timing.&#8221; And it&#8217;s a tool for him to make his living; it&#8217;s his job, and he doesn&#8217;t see a need to be in love with every aspect of his job. This is what made me sad, because for most of us that make our living within this space, we were able to escape the &#8220;it&#8217;s just a job&#8221; mentality and be emotionally enriched by what is possible on the open web.</p>\n<p>Matt could probably drop his various issues with Pearson and life would go on. The vast majority of WordPress businesses could understand the status quo and live by it, and those that don&#8217;t can keep living their lives outside of the approval of Mullenweg, and for that matter, the official WordPress project and website. But he too insists to stand up for his ideals and the web he believes in. He sees himself as a defender of the user, and his defense of the GPL is an extension of his core beliefs on software.</p>\n<p>They will never agree on licensing, that much is clear. The question of what&#8217;s next is multi-layered.</p>\n<h3>Will litigation continue?</h3>\n<p>Undoubtedly, yes, litigation will continue. But the litigation should be viewed as three distinct parts:</p>\n<ul>\n<li>In regard to the thesis.com domain, it&#8217;s really a sideline issue that resulted from more deep-rooted differences in ideals that turned into a personal spat. Pearson may continue in court to try and get the domain back, but I doubt it. I don&#8217;t know if Automattic will relent on the trademark cancellation requests, but I wouldn&#8217;t be surprised if they dropped it in some form of settlement.</li>\n<li>The patent issue is not over. I believe Automattic and potentially other organizations will challenge Pearson&#8217;s patent application using a variety of legal options available. The chances the patent gets approved or holds up long term are unlikely (but yes, it is possible), and I don&#8217;t believe there is a significant chance it will have longstanding implications on the WordPress project.</li>\n<li>I believe the GPL will continue to be tested in court, and eventually we may have a proper precedent set to put current questions aside. I won&#8217;t pretend a guess how it will turn out, because I think it truly depends on many, many factors. I do think that if Matt Mullenweg pursues a case himself, he will be joined by a number of interested organizations, including the Free Software Foundation; or the GPL debate could be settled in court in a completely different dispute, unrelated to WordPress &#8212; but have a longstanding impact on products made for WordPress.</li>\n</ul>\n<h3>Is this debate bad for WordPress?</h3>\n<p>The <em>way</em> this debate has occurred is bad for WordPress. Neither Matt Mullenweg nor Chris Pearson looks like a saint right now. And parts of the whole thing don&#8217;t do a whole lot to further the conversation.</p>\n<p>At the root of the debate is licensing, and that debate is worth having.</p>\n<p>It is important that we separate the intent and the legal interpretation of the GPL. It is also important that we separate one&#8217;s legal ability to not license distributed WordPress products as GPL compatible, versus the business and community consequences that may result from such a decision.</p>\n<h2>Endmatter</h2>\n<p>This post would not be possible without the Post Status <a href=\"https://poststatus.com/partners\">Partners</a> and <a href=\"https://poststatus.com/profiles\">Members</a> that fund the website, and my ability to write about WordPress full time. If you enjoyed this post, please consider becoming a <a href=\"https://poststatus.com/club\">Post Status member</a> to fund more free content, plus loads of great members-only benefits, including a daily-ish newsletter that keeps you covered on the happenings of the WordPress world.</p>\n<p>I would also like to thank Matt Mullenweg and Chris Pearson for the interviews they provided me in preparation of this post.</p>\n<p>And I&#8217;d like to thank my lawyer, <a href=\"http://associatesmind.com\">Keith Lee</a> (a WordPress fan and blogger himself!) for helping me think through some of the legal matters discussed &#8212; though the opinions themselves are my own.</p>\n<p>Finally, I&#8217;d like to thank the folks that helped me review the post, consider my positions, and organize my thoughts. You know who you are.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jul 2015 01:42:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: Who’s Using the WordPress REST API?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47039\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"http://wptavern.com/whos-using-the-wordpress-rest-api\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4659:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/04/wp-rest-api.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/04/wp-rest-api.jpg?resize=1025%2C469\" alt=\"wp-rest-api\" class=\"aligncenter size-full wp-image-43000\" /></a></p>\n<p>Ryan McCue and the <a href=\"https://github.com/WP-API/WP-API\" target=\"_blank\">WP REST API</a> team are <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">seeking feedback</a> on the project ahead of the API merging into core. McCue invited comments on the post to find out how and where it&#8217;s currently being used, in hopes of identifying any roadblocks developers may be facing.</p>\n<p>&#8220;We’d love to hear feedback from everyone using this, from JS-only developers coming to WP for the first time, through WordPress plugin and theme developers, all the way through to PHP developers not involved with WordPress,&#8221; he said.</p>\n<p>Comments on the post provide a nice overview of places where the API is already in use in production all over the WordPress development community. A few examples include:</p>\n<ul>\n<li><a href=\"https://hmn.md/\" target=\"_blank\">Human Made</a> uses the API with client projects, i.e. to create a Node-powered frontend and maintain the familiar WordPress admin.</li>\n<li><a href=\"http://reactor.apppresser.com/\" target=\"_blank\">Reactor</a> uses the API to create mobile apps that digest the API themselves.</li>\n<li><a href=\"http://aesopstoryengine.com/\" target=\"_blank\">Aesop Interactive</a> uses the API with <a href=\"http://wptavern.com/lasso-frontend-editing-plugin-for-wordpress-now-available-on-github\" target=\"_blank\">Lasso</a> and also to power the <a href=\"http://wptavern.com/new-wp-live-search-plugin-utilizes-the-wp-rest-api\" target=\"_blank\">WP Live Search</a> plugin.</li>\n<li>A large industrial real estate firm manages its properties via an internal proprietary .NET app with a public-facing site powered by WP. It uses the API to sync property data (in real time) between the internal app and the website so the real estate listings will always be current.</li>\n<li><a href=\"https://www.joininuk.org/\" target=\"_blank\">Join In</a>, a site organizing volunteers in the UK, used the API to create <a href=\"https://www.joininuk.org/widget/\" target=\"_blank\">an embeddable JS widget</a>.</li>\n<li><a href=\"https://profiles.wordpress.org/pers/\" target=\"_blank\">Per Soderlind</a> used the WP REST API as <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/#comment-26372\" target=\"_blank\">a backend for an iOS application</a> for the Norwegian Ministry of Petroleum and Energy.</li>\n<li><a href=\"http://tri.be/about/\" target=\"_blank\">Modern Tribe</a> is building sites that use the REST API to power both Handlebars and full page React templates in themes.</li>\n</ul>\n<p>Those are just a small sampling of places where the API is being used to make WordPress more flexible for creating custom solutions. For many who are using the API or hoping to use it, the main hindrance is that it&#8217;s not yet in core.</p>\n<p>&#8220;The biggest issue right now is that the REST API isn’t included in core,&#8221; a representative from Ashworth Creative <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/#comment-26390\" target=\"_blank\">commented</a>. &#8220;If we build plugins or a theme that needs to consume data asynchronously, we’d either have to bundle the API and have to maintain it in our repositories as a dependency, or have clients install and maintain it on their own.&#8221;</p>\n<p>WordPress developer Nate Wright echoed that opinion and is eager to be able to extend it for use in his products, without having to include it as a plugin.</p>\n<p>&#8220;Put it in core, so that as a plugin developer I can make use of it in my products,&#8221; he <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/#comment-26367\" target=\"_blank\">said</a>. &#8220;I built the most popular Restaurant Reservations plugin in the .org repo, and I am eager to add a robust capacity/table management component for it using the REST API and a jQuery/Underscore/Backbone stack.&#8221;</p>\n<p>Early adopters have the unique opportunity to provide feedback on the REST API and help shape priorities for development. If you are using the API somewhere in the wild, make sure to <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">leave your feedback on McCue&#8217;s post</a> to help the team make any necessary changes required before it&#8217;s merged into core.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 21:15:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: WPWeekly Episode 200 – The Big Two Oh Oh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47083&preview_id=47083\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://wptavern.com/wpweekly-episode-200-the-big-two-oh-oh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3495:\"<p>In this special 200th episode of WordPress Weekly, I&#8217;m joined by <a href=\"http://marcuscouch.com/\">Marcus Couch</a>, <a href=\"http://strangework.com/\">Brad Williams</a>, <a href=\"http://www.ronalfy.com/\">Ronald Huereca</a>, and <a href=\"http://piratedunbar.com/\">Ptah Dunbar</a>. Brad, Ronald, and Ptah were among the first to support WordPress Weekly. They helped get the show off the ground and provided momentum.</p>\n<p>Seven years have passed since I started WordPress Weekly. In those seven years, each one of my guests have gone on to do great things with WordPress. We find out what they&#8217;re up to these days and recall memorable moments of the show. Near the beginning of the show, we held a moment of silence in Kim&#8217;s memory.</p>\n<p>I had a great time hosting episode 200, but I&#8217;m sad that the <a href=\"http://wptavern.com/kim-parsell-affectionately-known-as-wpmom-passes-away\">late Kim Parsell</a> couldn&#8217;t celebrate with us. When I started WordPress Weekly in 2008, Kim would often join me on each episode to provide a countdown before I pressed the record button.</p>\n<p>She was occasionally a <a href=\"http://wptavern.com/wpweekly-episode-87-%E2%80%93-the-lost-episode\">guest on the show</a>. After the show, she would stick around for a half hour to an hour to talk about whatever was on her mind. In many ways, the show offered her an opportunity to connect and speak to WordPress people every week. It was the closest thing to a meetup she could regularly attend.</p>\n<p>Thanks to everyone who listens to the show and provides us with valuable feedback. Join us next Wednesday, as we begin the journey to episode 300.</p>\n<h2>History of WordPress Weekly:</h2>\n<ul>\n<li>My first show on Talkshoe.com was 7 years ago on January 11th, 2008.</li>\n<li>WordPress 2.3.2 was released.</li>\n<li>WordPress 2.5 took the place of 2.4.</li>\n<li>Episode 100 was on June 5th 2010.</li>\n<li>I took a two year break after episode 117 October 28th, 2011.</li>\n<li>I resumed the show on August 16th 2013 which was also my last show on Talkshoe.</li>\n<li>Marcus became a co-host January 18th, 2014, on Episode 134.</li>\n</ul>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/flow-flow-social-streams/\">Flow-Flow Social Streams</a> lets you display your Facebook, Twitter, and Instagram messages in a responsive grid.</p>\n<p><a href=\"https://wordpress.org/plugins/test-gateway-for-woocommerce/\">Test Payment Module for Woocommerce</a> gives you the option to test payments in WooCommerce locally without using services such as Paypal or Authorize.net.</p>\n<p><a href=\"https://wordpress.org/plugins/easy-backup-by-supsystic/\">DropBox Backup by Supsystic</a> allows you to backup to Dropbox and FTP with one click. You can also restore full or partial backups from DropBox.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, July 29th 4 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #200:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 20:30:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Philadelphia, PA to Host WordCamp US December 4th–6th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47068\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1943:\"<p>Matt Mullenweg <a href=\"http://ma.tt/2015/07/wcus-philadelphia/\">announced</a> that Philadelphia, PA, will host WordCamp US December 4th–6th at the <a href=\"http://www.paconvention.com/Pages/default.aspx\">Pennsylvania Convention</a> center. Philadelphia will also host WordCamp US in 2016, although no dates have been chosen yet.</p>\n<p>According to Mullenweg, &#8220;Having it the same place two years in a row allows us to keep logistics a set variable and really focus on the rest of the event in the second year.&#8221; The 2017 and 2018 host cities will be chosen in between the first and second event. This allows the team in the host city to volunteer and gain on-the-ground experience in Philadelphia.</p>\n<p>Out of six cities chosen to possibly host WordCamp US and 1,390 total voters, Tavern <a href=\"http://wptavern.com/which-one-of-these-six-cities-should-host-wordcamp-us\">readers voted</a> to have it in Phoenix, AZ, citing <a href=\"http://wptavern.com/which-one-of-these-six-cities-should-host-wordcamp-us#comment-70157\">its warm weather</a> during winter months. Philadelphia, home of the cheesesteak, was a close second.</p>\n<p>The event is inspired by WordCamp Europe, where organizers take an entire year to <a href=\"http://wptavern.com/vienna-austria-to-host-wordcamp-europe-2016\">plan and coordinate</a> the event. Some <a href=\"http://wptavern.com/which-one-of-these-six-cities-should-host-wordcamp-us#comment-70055\">readers questioned</a> whether the event would be held this year considering <a href=\"http://wptavern.com/wordcamp-us-2015-now-accepting-applications-for-host-city\">applications to be the host city </a>weren&#8217;t accepted until June.</p>\n<p>With only half a year to plan and organize WordCamp US, it will be interesting to see how the first one goes. Let us know if you plan on attending the event and if you&#8217;re going to bring ear muffs as Philadelphia during that time of year is cold.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 17:31:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Matt: WordCamp US to be in Philadelphia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45259\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/07/wcus-philadelphia/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1188:\"<p><img class=\" wp-image-45261 alignright\" src=\"http://i1.wp.com/ma.tt/files/2015/07/wordcamp1-e1437663434378.png?resize=303%2C309\" alt=\"WordCamp US\" />There were <a href=\"http://ma.tt/2015/06/wordcamp-us-survey/\">amazing applications</a> for teams and cities to host the inaugural WordCamp US, a concept originally floated at <a href=\"http://wordpress.tv/2014/10/26/matt-mullenweg-the-state-of-the-word-2014/\">the State of the Word last year</a>. It was very hard to make a choice, but can now announce that the birthplace of the United States, <strong>Philadelphia, will host the first WCUS on December 4th&#8211;6th</strong>. They will also host it in 2016, but no dates have been chosen yet.</p>\n<p>Having it the same place two years in a row allows us to keep logistics a set variable and really focus on the rest of the event in the second year. I also want to use it to facilitate experience transfer: We&#8217;ll choose the 2017 + 2018 host city in between the first and second event, so that team can volunteer on the ground the second year Philadelphia hosts it to learn from their experience. Hat tip: Cool graphic by <a href=\"http://visualrhythm.com/\">Andrew Bergeron</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 16:38:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: WordPress 4.2.3 is a Critical Security Release, Fixes an XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47045\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3025:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/security.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/security.jpg?resize=1024%2C514\" alt=\"photo credit: Lock - (license)\" class=\"size-full wp-image-40187\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/58441544@N00/2660230441\">Lock</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>WordPress users in the Americas woke this morning to find update notices in their inboxes due to a critical security vulnerability. <a href=\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\" target=\"_blank\">WordPress 4.2.3</a> was released today and automatically pushed out to sites that have auto-updates enabled.</p>\n<p>Because this is a security release for all previous versions of WordPress, those who do not have automatic update enabled will need to manually update their sites immediately. Core contributor Gary Pendergast explained the severity of the bug in the release post:</p>\n<blockquote><p>WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was reported by <a href=\"https://profiles.wordpress.org/duck_\" target=\"_blank\">Jon Cave</a> and fixed by <a href=\"http://www.miqrogroove.com/\" target=\"_blank\">Robert Chapin</a>, both of the WordPress security team.</p>\n<p>We also fixed an issue where it was possible for a user with Subscriber permissions to create a draft through Quick Draft.</p></blockquote>\n<p>Pendergast thanked all parties reporting vulnerabilities for <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\" target=\"_blank\">responsibly disclosing them </a> to the WordPress security team.</p>\n<p>This release also contains fixes for 20 bugs from 4.2, including one that might require you to update your database before being allowed back into the admin.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/wp-update-db.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/wp-update-db.jpg?resize=773%2C370\" alt=\"wp-update-db\" class=\"aligncenter size-full wp-image-47047\" /></a></p>\n<p>Not all WordPress users who are updating will be greeted with this message, but if you see it, don&#8217;t panic. It&#8217;s related to one of the bug fixes included in the release.</p>\n<p>&#8220;It was a bug fix in 4.2.3, not backported &#8211; some versions of PHP didn&#8217;t run the utf8mb4 update correctly,&#8221; Pendergast said when asked about the required database update.</p>\n<p>Unfortunately, in some instances, clicking the &#8220;Update WordPress Database&#8221; button may require multiple attempts. This is unusual but Pendergast said that improving database upgrades is high on the team&#8217;s list of priorities.</p>\n<p>A list of all the files revised is available on the <a href=\"https://codex.wordpress.org/Version_4.2.3\" target=\"_blank\">4.2.3 release page</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 14:06:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: WordPress Custom Post Type UI Plugin Passes 1 Million Downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46940\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/wordpress-custom-post-type-ui-plugin-passes-1-million-downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5094:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/celebration.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/celebration.jpg?resize=960%2C482\" alt=\"photo credit: Stephanie McCabe\" class=\"size-full wp-image-47036\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/6V12NODFVM\">Stephanie McCabe</a>\n<p>In June of 2010, <a href=\"http://codex.wordpress.org/Version_3.0\" target=\"_blank\">WordPress 3.0</a> Thelonious was released with the historic merge of WordPress MU into core and the debut of the brand new Twenty Ten default theme. This pivotal release also gave developers the ability to register their own <a href=\"http://codex.wordpress.org/Custom_Post_Types\" target=\"_blank\">custom post types</a>. Expanding WordPress&#8217; custom content capabilities beyond simple posts and pages has been critical to the platform maintaining its dominance as <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">the world&#8217;s most used CMS</a>.</p>\n<p>Thousands of WordPress developers make a living from products that are based on custom post types. Five years ago, when the feature was still new, you had to know how to write the code to register a new post type. That&#8217;s when the folks at <a href=\"http://webdevstudios.com/\" target=\"_blank\">WebDevStudios</a> released <a href=\"https://wordpress.org/plugins/custom-post-type-ui/\" target=\"_blank\">Custom Post Type UI</a>, a plugin that offers an admin interface for creating and managing post types and their associated taxonomies.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/cptui_post_type_editor.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/cptui_post_type_editor.png?resize=1024%2C604\" alt=\"cptui_post_type_editor\" class=\"aligncenter size-full wp-image-47028\" /></a></p>\n<p>The company counts more than <a href=\"https://profiles.wordpress.org/webdevstudios/#content-plugins\" target=\"_blank\">30 plugins</a> in its collection on WordPress.org, but Custom Post Type UI is by far the most successful. Last week it passed one million downloads and maintains a 4.6 out of 5-star average rating from users. The plugin is currently active on more than 200,000 WordPress sites.</p>\n<h3>Passing the 1 Million Downloads Milestone</h3>\n<p>Michael Beckwith, the current maintainer of Custom Post Type UI, published a <a href=\"http://webdevstudios.com/2015/07/17/the-custom-post-type-ui-million-download-celebration/\" target=\"_blank\">post</a> detailing the evolution of the plugin&#8217;s UI and codebase. His transparent account covers how the team overcame the challenges of their massive codebase overhaul and the undetected bugs that come crawling out of the woodwork with a major release.</p>\n<p>A plugin with a user base in the hundreds of thousands that manages to maintain a nearly 5-star average rating on WordPress.org is a notable achievement, especially when it involves weathering the UI and code updates required to keep pace with WordPress.</p>\n<p>&#8220;I believe this milestone represents the fact that making features usable and more user-friendly to the &#8216;average Joe&#8217; can take you a long ways,&#8221; Beckwith said. &#8220;Custom Post Type UI made it easier for more people to tap into the power and customization ability that custom post types and taxonomies offer to a WordPress powered website. Because of that ease of use, many have added it to their toolbox for every website they have or work on, and recommend it to their friends.&#8221;</p>\n<p>The plugin is being developed on <a href=\"https://github.com/WebDevStudios/custom-post-type-ui\" target=\"_blank\">GitHub</a>. Although there are many <a href=\"https://github.com/WebDevStudios/custom-post-type-ui/labels/enhancement\" target=\"_blank\">enhancements</a> under consideration, Beckwith said that no major changes are planned for the near future.</p>\n<p>&#8220;I would love more to get more people up-to-date on the current version and let it be the stable version for awhile,&#8221; he said.</p>\n<p>&#8220;Looking at our stats page, we still have reported active installs using as far back as version 0.6. While I can sit here scratching my head as to why, I also have to consider that that version is stable enough and still meeting the needs of 0.6% of our users.</p>\n<p>&#8220;If it is not breaking for them, and there is no security concerns, then it is not all bad that they are still marching on. There is also the minimum version requirement to keep in mind. There are still WordPress installs active and out in the wild that are not running WordPress 3.8 or higher. Until they are, those users are not going to be notified that there is even an update available,&#8221; he said.</p>\n<p>If you want to learn more about what it takes to maintain a popular plugin while successfully navigating the years of changes and support, check out WebDevStudios&#8217; <a href=\"http://webdevstudios.com/2015/07/17/the-custom-post-type-ui-million-download-celebration/\" target=\"_blank\">1 million downloads celebration post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 01:35:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WordPress 4.3 Moves Customize to Its Own Top-level Menu in the Admin Bar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46979\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/wordpress-4-3-moves-customize-to-its-own-top-level-menu-in-the-admin-bar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3156:\"<p>When menu management was <a href=\"http://wptavern.com/menu-customizer-officially-proposed-for-merge-into-wordpress-4-3\">proposed to be merged into WordPress 4.3</a>, a common complaint <a href=\"http://wptavern.com/menu-customizer-officially-proposed-for-merge-into-wordpress-4-3#comment-68988\">expressed by readers</a> was that clicking the Widgets menu item in the admin bar loads the customizer instead of the Widgets admin screen. WordPress 4.3 separates the management interfaces by moving the Customize link to the top-level menu of the admin bar. This link opens the customizer, allowing you to manage menus, appearance, and widgets through the customizer interface.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP42AdminBar.png\"><img class=\"wp-image-46995 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP42AdminBar.png?resize=429%2C232\" alt=\"WordPress 4.2 Admin Bar\" /></a>WordPress 4.2 Admin Bar\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP43AdminBar.png\"><img class=\"wp-image-46996 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP43AdminBar.png?resize=428%2C202\" alt=\"WP43AdminBar\" /></a>WordPress 4.3 Admin Bar\n<p>The Dashboard, Themes, Widgets, and Menus links take users to their corresponding admin pages in the backend of WordPress. This makes it clear which interface users are about to enter. The enhancement is a result of <a href=\"https://core.trac.wordpress.org/ticket/32678\">ticket #32678</a> where Helen Hou-Sandí and other WordPress core contributors discussed ways to improve the context of each link over the course of five weeks.</p>\n<p>Within the ticket, Nick Halsey, who has spent a lot of time on the customizer, explains that the approach taken in the ticket addresses short-term problems while setting the stage for future improvements.</p>\n<blockquote><p>The Customizer gets the visibility it deserves and becomes more conceptually separated from &#8216;Appearance&#8217;, the admin becomes significantly more accessible from the front-end, the often-unhelpful dashboard is de-emphasized, etc. We also have the ability to easily upgrade the Customize link to do a much faster/shinier loading of the Customizer in the future without moving it.</p>\n<p>Notably, the add-content and edit-content links remain separated from the admin menu (and we skip submenus there for simplicity), setting us up to be able to point them to a front-end-contextual content-creating/editing experience if we build that in the future, without moving links around. This minor rearrangement should be able to last several years without things moving around much if at all, even as further adjustments are made to the features they point to.</p></blockquote>\n<p>On the surface, it appears to be a simple change but a lot of time and effort went into it. It required several core contributors to discuss a variety of mockups, ideas, and flows before the team figured out a solution.</p>\n<p>Separating how users enter each interface will be a welcome enhancement to anyone who prefers one over the other to manage themes, widgets, and menus.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 23:28:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: How and When Mullenweg Learned Thesis Changed Back to a Proprietary License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46960\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"http://wptavern.com/how-and-when-mullenweg-learned-thesis-changed-back-to-a-proprietary-license\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5837:\"<p>We now know when Matt Mullenweg discovered Chris Pearson changed Thesis&#8217; license from split GPL to a proprietary one. On April 1st 2014, Siobhan McKeown <a href=\"http://archive.wordpress.org/interviews/2014_04_01_Mullenweg.html\">interviewed Matt Mullenweg</a> for the <a href=\"https://github.com/WordPress/book\">WordPress history book</a>.</p>\n<p>In the interview, we learn about the history of WordPress themes, the GPL, how Automattic unintentionally created the commercial theme market, why 200 themes were removed from the directory for sponsored links and much more.</p>\n<p>At the 30 minute mark, McKeown asks Mullenweg, at what point did he decide to go to the Software Freedom Law Center to receive clarification on if the default themes that ship with WordPress are derivatives? He responds:</p>\n<blockquote><p>I believe that was around our engagement with Mr. Pearson. I don&#8217;t know if it was before or after the Mixergy interview with our spirited online debate, but it was definitely around that time. I&#8217;m not a lawyer! I can read it and I can understand it from a logical point of view, but the Software Freedom Law Center is obviously the world experts in this and having them officially opine is the closest we can get to &#8211; it&#8217;s the next best thing to having a court case.</p>\n<p>I was actually very excited that perhaps Chris would actually go to court, because as you know there isn&#8217;t a ton of case law around the GPL and normally, because no one is stubborn enough to actually go to court over it, and I thought, &#8220;Oh, we finally got one!&#8221; And I was looking forward to being able to discuss in the U.S. law system and provide the precedent for anyone who comes after us to protect the GPL.</p>\n<p>Because companies like Cisco and LinkSys and huge companies with billions of dollars in resources have opted to not fight it, so you really do need someone who is going to be stubborn enough to fight it.</p></blockquote>\n<p>At the climax of the debate in 2010, <a href=\"http://ma.tt/2010/07/syn-thesis-1/#comment-481743\">some members</a> of the WordPress community wanted to see the argument go to court so a ruling could set a precedent on when a work becomes derivative.</p>\n<p>At the 33 minute mark, McKeown informs Mullenweg that Thesis switched from a split GPL license to a proprietary license. This is the first time since his debate with Pearson in 2010, that Mullenweg discovers Thesis switched back to a proprietary license. He responds:</p>\n<blockquote><p>I have not seen that. So we&#8217;d have to do a code analysis again. As you know the Software Freedom Law Center says that non-PHP, so non-linked code which can be CSS, images and JavaScript, isn&#8217;t required to be GPL. It doesn&#8217;t trigger the viral nature of WordPress&#8217; GPL code.</p>\n<p>The stance of the WordPress community was that a theme without images or CSS isn&#8217;t much of a theme so, even though something could be legally compliant, if the entire package isn&#8217;t providing the same freedoms for users it&#8217;s not something that we want to link to or promote. Because it doesn&#8217;t really follow the things that we hold dear and true in WordPress.</p></blockquote>\n<p>On January 15, 2014, <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">Chris Pearson received</a> a copy of Mullenweg&#8217;s inquiry into thesis.com from Larry of GetYourDomain.com. This is approximately four months prior to discovering Thesis was being sold under a proprietary license. However, the exact date in which Mullenweg obtained ownership of the domain is unknown.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/email-matt.png\"><img class=\"size-full wp-image-46845\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/email-matt.png?resize=486%2C191\" alt=\"Email shared by Pearson showing Mullenweg\'s interest in the domain\" /></a>Email shared by Pearson showing Mullenweg&#8217;s interest in the domain\n<p>The first <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">publicly known use of the domain</a> that confirmed Mullenweg&#8217;s ownership was on October 26th, 2014, at WordCamp San Francisco during the Question and Answer session.</p>\n<p>As the interview continues, McKeown asks Mullenweg if he reached out to companies like Template Monster that sells WordPress themes that are not GPL Licensed. He responds:</p>\n<blockquote><p>We got in touch with everyone that we could, and it was definitely &#8211; it was a lot of time. There are times when WordPress core stuff is more than a full-time job for me and now is definitely one of them.</p>\n<p>I see your link to a [inaudible]. There&#8217;s always ways to word licenses around multi-site support where perhaps the code is GPL but the developer chooses to not provide support for more than one site unless you buy a special license. So sometimes people interpret those to be a GPL violation when actually they&#8217;re not.</p>\n<p>I&#8217;m not aware of what Chris has done and I&#8217;d like to think that he is supportive &#8211; he has done so well from the WordPress community that he&#8217;d be supportive of themes continuing to be GPL, especially since his business didn&#8217;t crash like he was worried it would.</p></blockquote>\n<p>McKeown jokes that lawyers might have written Thesis&#8217; license agreement. Mullenweg responds, &#8220;Well, maybe we&#8217;ll dive back into it.&#8221; More than 14 months later, <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">Mullenweg has dived back into it with Pearson</a>.</p>\n<p>It&#8217;s unclear if in this second round of arguments, Mullenweg will take Pearson to court to settle the GPL derivative argument once and for all.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 23:21:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: Create and Manage BuddyPress Member Types with the BP Member Type Generator Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46893\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/create-and-manage-buddypress-member-types-with-the-bp-member-type-generator-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4810:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/different-users.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/different-users.jpg?resize=1024%2C492\" alt=\"photo credit: Dunechaser - cc\" class=\"size-full wp-image-30565\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/dunechaser/6042984689/\">Dunechaser</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p><a href=\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\" target=\"_blank\">BuddyPress 2.2</a> introduced a <a href=\"https://codex.buddypress.org/developer/member-types/\" target=\"_blank\">Member Type API</a>, which allows developers to register their own unique member types, i.e. teacher, student, coach, etc. This was an exciting addition to BuddyPress but not very accessible to non-technical community managers, since it requires writing your own plugin to utilize it.</p>\n<p><a href=\"https://wordpress.org/plugins/bp-member-type-generator/\" target=\"_blank\">BP Member Type Generator</a> is a new plugin from Brajesh Singh, prolific plugin author and owner of <a href=\"http://buddydev.com/\" target=\"_blank\">BuddyDev</a>. The plugin makes it easy for site administrators to create and manage member types in the admin &#8211; without having to write any code.</p>\n<p>A quick overview of its features includes:</p>\n<ul>\n<li>Create/Edit/Delete Member Types from WordPress admin</li>\n<li>Bulk assign member type to users from the users list screen</li>\n<li>A member type can be marked active/inactive from the edit member type page</li>\n<li>Compatible with multisite installations</li>\n</ul>\n<p>When creating a new member type, administrators have the option to enable a directory that will list all members from that type on one page.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/create-member-type.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/create-member-type.png?resize=968%2C725\" alt=\"create-member-type\" class=\"aligncenter size-full wp-image-46984\" /></a></p>\n<p>If you want to add the plugin and separate your members into different types, the task is not as overwhelming as it might sound. When you visit the user listing page in the admin, you can use the plugin&#8217;s bulk &#8220;change member type&#8221; dropdown to bulk assign users to a new member type. (This feature is also available in the Extended Profile section for each individual user in the admin.)</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/change-member-type.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/change-member-type.png?resize=737%2C440\" alt=\"change-member-type\" class=\"aligncenter size-full wp-image-46988\" /></a></p>\n<p>If you want to make the member types available for selection upon user registration, Singh created a free companion plugin called <a href=\"http://buddydev.com/buddypress/using-buddypress-member-type-as-profile-field-introducing-bp-xprofile-member-type-field-plugin/\" target=\"_blank\">BP Xprofile Member Type Field</a> that puts this on the frontend. If you want to restrict members from modifying their user type after registration, you can also add the free <a href=\"http://buddydev.com/plugins/bp-non-editable-profile-fields/\" target=\"_blank\">Non Editable Profile</a> field plugin.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/registration-member-type-field.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/registration-member-type-field.png?resize=490%2C337\" alt=\"registration-member-type-field\" class=\"aligncenter size-full wp-image-46992\" /></a></p>\n<p>Please note that BP Member Type Generator cannot detect and manage other member types that have previously been added via code in a plugin. This might create some confusion if you already have existing member types. However, if you&#8217;re just starting with setting up and organizing member types, or are willing to reorganize member types, the BP Member Type Generator offers an easy way to do it.</p>\n<p>This plugin is an important and much needed new tool that puts the creation of unique member types into the hands of BuddyPress community administrators, regardless of skill level. You can download <a href=\"https://wordpress.org/plugins/bp-member-type-generator/\" target=\"_blank\">BP Member Type Generator</a> for free from WordPress.org. Singh does not officially support his plugins via the WordPress forums, but users can provide feedback via the <a href=\"http://buddydev.com/buddypress/introducing-buddypress-member-type-generator/\" target=\"_blank\">BuddyDev blog</a> or get professional support on the <a href=\"http://buddydev.com/support/forums/\" target=\"_blank\">BuddyDev Premium Support Forums</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 21:51:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Joseph: Recommended Consultants\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://josephscott.org/?p=9888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://josephscott.org/archives/2015/07/recommended-consultants/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:277:\"<p>My personal list of WordPress consultants has dried up ( some took full time jobs, the rest are always booked solid ).  Now I&#8217;m directing people to the <a href=\"http://jkudish.com/recommendations/\">Recommended Consultants &amp; Resources list</a> from Joey Kudish.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 14:01:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Joseph Scott\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: Nick Haskins Receives Cease and Desist Letter for Violating LassoSoft Trademarks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46768\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"http://wptavern.com/nick-haskins-receives-cease-and-desist-letter-for-violating-lassosoft-trademarks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4619:\"<p><a href=\"http://nickhaskins.com/\">Nick Haskins</a>, the founder and lead developer of <a href=\"https://lasso.is/\">Lasso</a>, is <a href=\"https://lasso.is/the-ugly-truth-about-trademarks/\">rebranding the product</a> after being served a cease and desist letter.</p>\n<p>A few days ago, Haskins was served a cease and desist letter from <a href=\"http://lassosoft.com/\">LassoSoft</a>. According <a href=\"http://www.lassosoft.com/What-Is-Lasso\">to LassoSoft</a>, &#8220;Lasso is a development platform and is the easiest, quickest and most secure method of supporting custom, data-driven web sites on the market today.&#8221;</p>\n<p>Before launching a product, Haskins searches Google to see if similar products exist with the same name, &#8220;Apparently we didn’t look hard enough when naming Lasso,&#8221; he said.</p>\n<h2>Three Requirements That Must Be Met</h2>\n<p>Haskins <a href=\"http://cl.ly/39400J3A100k\">shared the letter</a> to educate others in the business of WordPress. In the letter, attorney&#8217;s for LassoSoft point out the company&#8217;s <a href=\"http://www.tmfile.com/mark/?q=861046116\">registered trademarks</a> and says it commenced using the mark in the US in 1998 and in Canada in 1997.</p>\n<p>LassoSoft claims to have documented at least one case of confusion between the two brands and says the continued use of Lasso will cause even more confusion.</p>\n<p>Attorney&#8217;s for LassoSoft provided three requirements that must be met for an amicable end to the dispute:</p>\n<ol>\n<li>Permanently ceasing all use of the term &#8220;Lasso&#8221; and any trademark which includes or incorporates the term &#8220;Lasso&#8221;, in connection with any software or related goods and services.</li>\n<li>Removing all references to the term &#8220;Lasso&#8221; from the Website.</li>\n<li>Removing all references to the term &#8220;Lasso&#8221; from any marketing materials including flyers, catalogs, etc.</li>\n</ol>\n<p>Haskins has until <strong>July 29th</strong> to satisfy the requirements and provide LassoSoft with written confirmation that he has permanently ceased all use of the term &#8220;Lasso&#8221; in association with software.</p>\n<h2>Transitioning Momentum</h2>\n<p>Rebranding a product that has momentum can be a crushing blow to a business that doesn&#8217;t manage the transition correctly. I asked Haskins how he plans to shift momentum from Lasso to the new brand name.</p>\n<p>&#8220;The first idea I had, was to let the community rename it, possibly even have a $500 prize to the winning name. By incentivizing a rebranding campaign, together with a concentrated effort on re-educating, along with URL redirects and custom messages, I feel pretty strongly that we&#8217;ll be able to move right along without skipping a beat,&#8221; he said.</p>\n<p>When it comes to naming a WordPress product and launching it into the WordPress ecosystem, Haskins offers the following advice:</p>\n<p>&#8220;Use Google to see if it already exists either in the WordPress ecosystem or in a related field. This may seem like a no-brainer and it&#8217;s really common sense, but for some reason, I either never searched or that company never popped up. At any rate, I think you&#8217;ll be in good shape by sticking to something with wp prefixed or appended to the name.&#8221;</p>\n<p>&#8220;Avoid generic terms and verbs because apparently, you can trademark a verb. I&#8217;d also run the search again in six months and if it&#8217;s a product that you plan on working on for a while, go through the process of getting the term trademarked.&#8221;</p>\n<p>In addition to Haskins&#8217; advice, I recommend using a search and discovery process provided by legal counsel familiar with trademark law.</p>\n<h2>Help Haskins Rebrand Lasso</h2>\n<p>In light of the battle between <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">Chris Pearson and Matt Mullenweg</a> involving patents, GPL, and trademarks, Haskins decided to rebrand Lasso, &#8220;There are a lot more important things in life than the name of a plugin for WordPress,&#8221; he said.</p>\n<p>Haskins is giving the community an opportunity to rebrand his product. So far, he&#8217;s ruled out WP Front End Editor as it&#8217;s too similar to the <a href=\"https://wordpress.org/plugins/wp-front-end-editor/\">name of a feature plugin</a> that may one day be merged into WordPress core.</p>\n<p>If you have an idea on what to call Lasso, please leave a comment on this post. Sometime next week, Haskins will gather the suggestions and publish a poll where the community can vote on which one is best.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 01:08:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Matt: There is No Such Thing as a Split License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45256\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"http://ma.tt/2015/07/licenses-going-dutch/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2845:\"<p>There&#8217;s a term that pops in the WordPress community, &#8220;split license&#8221;, that we should put to rest. It&#8217;s sloppy at best, misleading at worst.</p>\n<p>First, some background. WordPress is under a license called the GPL, which basically says you can do whatever you like with the software, but if you distribute changes or create derivative works they also need to be under the GPL. Think of it like a Creative Commons Sharealike license.</p>\n<p>In the past people weren&#8217;t sure if themes for WordPress were derivative works and needed to be GPL. <a href=\"https://wordpress.org/news/2009/07/themes-are-gpl-too/\">In 2009 we got an outside legal opinion that cleared up the matter</a> saying that the PHP in themes definitely had to be GPL, and for CSS and images it was optional. Basically everyone in the WP community went fully GPL, sometimes called 100% GPL, for all the files required to run their theme (PHP, JS, CSS, artwork). The predicted theme apocalypse and death of WordPress didn&#8217;t happen and in fact both theme shops and WordPress flourished, and best of all users had all the same freedoms from their themes as they got from WordPress. It was controversial at the time, but I think history has reflected well on the approach the WP community took.</p>\n<p>As I said the PHP has to be GPL, the other stuff can be something else &#8212; many people started to use the term &#8220;split license&#8221; or &#8220;split GPL&#8221; to describe this. The problem, especially with the latter, is it leaves out the most important information. &#8220;Split GPL&#8221; doesn&#8217;t say whether the theme is violating WordPress&#8217; license or not (maybe it&#8217;s proprietary PHP and GPL CSS), and more importantly doesn&#8217;t say what the non-GPL stuff is, which is the part you need to worry about! It also makes it sound like a split license is a thing, when all it really means is there are different licenses for different parts of the work. If something has a &#8220;split license&#8221; you have no idea what restrictions or freedoms it provides.</p>\n<p>If someone decides to have different licenses for different parts of a theme they ship in one package, it&#8217;s probably worth taking a few extra words to spell out what the rights and restrictions are, like &#8220;GPL PHP, and a restrictive proprietary license for all other elements included with the theme.&#8221; This is really important because if you&#8217;re a smart WordPress consumer you should avoid proprietary software, there is always a GPL alternative that <a href=\"http://www.gnu.org/philosophy/free-sw.en.html\">gives you the rights and freedoms you deserve</a>, and probably is from a nicer person who is more in line with the philosophy of the rest of WordPress. Vote with your pocketbook, buy GPL software!</p>\n<p>&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jul 2015 20:55:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: Shortcake Bakery Plugin Offers a Suite of Useful Shortcodes for WordPress Publishers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46896\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://wptavern.com/shortcake-bakery-plugin-offers-a-suite-of-useful-shortcodes-for-wordpress-publishers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4116:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/baker.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/baker.jpg?resize=1024%2C516\" alt=\"photo credit: Panettiere - (license)\" class=\"size-full wp-image-46899\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/27505428@N06/16282512996\">Panettiere</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p>In March, the <a href=\"http://wptavern.com/shortcake-is-now-a-wordpress-feature-plugin\" target=\"_blank\">Shortcake project officially began its journey as a feature plugin</a> with regular meetings for contributors working to make it ready to propose for inclusion in WordPress core. The <a href=\"https://wordpress.org/plugins/shortcode-ui/\" target=\"_blank\">plugin</a> provides a friendly UI for adding shortcodes and transforms them to render a nice preview in the visual editor.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/pullquote-shortcode.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/pullquote-shortcode.png?resize=1025%2C538\" alt=\"pullquote-shortcode\" class=\"aligncenter size-full wp-image-46904\" /></a></p>\n<p>Last week, <a href=\"https://twitter.com/danielbachhuber\" target=\"_blank\">Daniel Bachhuber</a> and the engineering team at <a href=\"http://fusion.net/\" target=\"_blank\">Fusion</a> released <a href=\"https://wordpress.org/plugins/shortcake-bakery/\" target=\"_blank\">Shortcake Bakery</a>, a plugin that extends the Shortcake project to supply a suite of handy shortcodes for publishers. The plugin currently includes the following:</p>\n<ul>\n<li>Image Comparison (powered by <a href=\"https://juxtapose.knightlab.com/\" target=\"_blank\">JuxtaposeJS</a>)</li>\n<li>Facebook embeds</li>\n<li>iFrames (require whitelisted hostnames)</li>\n<li>Infogram embeds</li>\n<li>PDF’s (powered by <a href=\"https://mozilla.github.io/pdf.js/\" target=\"_blank\">PDF.js</a>)</li>\n<li>Playbuzz embeds</li>\n<li>Rap Genius annotations</li>\n<li>Scribd embeds</li>\n<li>Scripts (require whitelisted hostnames)</li>\n</ul>\n<p>&#8220;We’ve been steadily making shortcodes for use by the Fusion newsroom since we launched Shortcake in November, and by releasing these universally useful patterns to the world, we hope to create a large repository of structured post elements for use by the WordPress community,&#8221; Bachhuber said.</p>\n<p>For example, Shortcake Bakery supplies a friendly UI for embedding an infographic from <a href=\"https://infogr.am/\" target=\"_blank\">Infogra.am</a>. The author selects the post element and then pastes in the URL to the infographic. It instantly appears in the post editor with a TinyMCE preview.</p>\n<p><a href=\"http://wptavern.com/wp-content/uploads/2015/07/shortcake-bakery-demo.mp4\">http://wptavern.com/wp-content/uploads/2015/07/shortcake-bakery-demo.mp4</a></p>\n<p>Shortcake Bakery also makes it easy to embed a single Facebook post, PDF, image comparison, and other content types that might otherwise prove troublesome to include in WordPress. Each content type is optimized for instant visual preview in the editor.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/shortcake-bakery-facebook-embed.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/shortcake-bakery-facebook-embed.png?resize=919%2C689\" alt=\"shortcake-bakery-facebook-embed\" class=\"aligncenter size-full wp-image-46917\" /></a></p>\n<p>Version 0.1.0 includes nine useful post elements that make it easy to embed content from external services commonly referenced by publishers. Shortcodes for Instagram, Tubmlr, and Silk are listed as possible upcoming enhancements on the project&#8217;s <a href=\"https://github.com/fusioneng/shortcake-bakery/labels/enhancement\" target=\"_blank\">GitHub issues queue</a>. <a href=\"https://wordpress.org/plugins/shortcake-bakery/\" target=\"_blank\">Shortcake Bakery</a> is an open source plugin and is now available on WordPress.org. It works best when combined with the <a href=\"https://wordpress.org/plugins/shortcode-ui/\" target=\"_blank\">Shortcake</a> plugin.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jul 2015 02:16:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: WP Rocket Reports $355K in Annual Revenue After 2 Years in Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46719\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/wp-rocket-reports-355k-in-annual-revenue-after-2-years-in-business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4872:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/05/wp-rocket-feature.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/05/wp-rocket-feature.jpg?resize=1025%2C452\" alt=\"wp-rocket-feature\" class=\"aligncenter size-full wp-image-22199\" /></a></p>\n<p><a href=\"http://wp-rocket.me/\" target=\"_blank\">WP Rocket</a> is celebrating its second year in business. The commercial caching plugin for WordPress launched two years ago in the French market and <a href=\"http://blog.wp-rocket.me/2-years-reports-feedbacks/\" target=\"_blank\">opened its doors to international customers</a> last May.</p>\n<p>At that time, WP Rocket was entering unproven territory as the first major caching plugin to launch with a 100% commercial model. Could the plugin succeed in a market dominated by free caching solutions like <a href=\"https://wordpress.org/plugins/w3-total-cache/\" target=\"_blank\">W3 Total Cache</a> and <a href=\"https://wordpress.org/plugins/wp-super-cache/\" target=\"_blank\">WP Super Cache</a>?</p>\n<p>WP Rocket has the numbers to prove that WordPress users are willing to pay for an easy-to-configure solution to site optimization. In February, the 100% bootstrapped company published a transparency report showing that the product was now active on 15,000+ websites and <a href=\"http://wptavern.com/wp-rocket-grows-from-0-to-35k-in-monthly-revenue\" target=\"_blank\">averaging $35K in monthly revenue</a>. Six months later, the plugin is now active on more than 32,000 websites. From July 2014 &#8211; July 2015, WP Rocket <a href=\"http://blog.wp-rocket.me/2-years-reports-feedbacks/\" target=\"_blank\">reports</a> that the company pulled in a total of $351,097 in revenue.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/wprocket-2014-2015.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/wprocket-2014-2015.jpg?resize=629%2C525\" alt=\"photo credit: WP Rocket</a.\" /></a>photo credit: <a href=\"http://blog.wp-rocket.me/2-years-reports-feedbacks/\">WP Rocket</a>\n<p>WP Rocket has been successful in identifying ways to stand out among established competitors. During our <a href=\"http://wptavern.com/wp-rocket-launches-commercial-caching-plugin-for-wordpress\" target=\"_blank\">initial tests of the plugin</a>, we found that it took under a minute to configure caching for a small blogging site using its simple, basic settings panel. Without even touching the more advanced options, such as DNS prefetching and file exclusions, we were able to reduce the page size and load time by roughly 50%.</p>\n<p>Inspired by a recent three-month stay in San Francisco, WP Rocket developers and co-founders  Jonathan Buttigieg and Jean-Baptiste Marchand-Arvier are now working to diversify their product offerings.</p>\n<p>&#8220;WP Rocket will be one product among others from our startup and not the only one,&#8221; Marchand-Arvier said. &#8220;We want to have a portfolio of products and not depend on only one.&#8221;</p>\n<p>To that end, the company is dipping its toes into multiple potentially welcoming revenue streams, including plugins, themes, and SaaS.</p>\n<p>&#8220;For the past few months, Julio has been working on a security plugin,&#8221; Marchand-Arvier said. &#8220;This is going to be a great challenge for us as we experiment with a freemium model for the first time, and because there are great competitors in the space, like WordFence and iThemes Security.</p>\n<p>WP Rocket currently has a dedicated team working on <a href=\"https://imagify.io/\" target=\"_blank\">Imagify</a>, an image compression toolkit and their first SaaS venture. The company also plans to enter the theme market with its own shop.</p>\n<p>&#8220;We want to take on that huge challenge which will be very different compared to selling a plugin,&#8221; Marchand-Arvier said.</p>\n<p>WP Rocket&#8217;s founders believe that building a strong company culture will be one of the key factors to their continued success.</p>\n<p>&#8220;To work in a mostly remote team can create a lack of human connection,&#8221; Marchand-Arvier said. &#8220;That’s why we’ve decided to organize a ‘startup retreat’ every year.&#8221; This decision was inspired by the founders&#8217; 2014 trip to explore Silicon Valley, a pivotal event that changed the way they approached business in the WordPress ecosystem.</p>\n<p>&#8220;This [trip] transformed three guys who were selling a WordPress plugin into a Startup of eight people (today) with a strong company culture,&#8221; he said.</p>\n<p>If the success of WP Rocket&#8217;s caching plugin is any indication, WordPress users should be on the lookout for the company to bring a new twist into other existing product niches. Momentum is running high on their currently incubating projects with <a href=\"https://imagify.io/\" target=\"_blank\">Imagify</a> on track to launch in the upcoming weeks.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Jul 2015 20:33:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Streak Broken\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45251\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://ma.tt/2015/07/streak-broken/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:689:\"<p>Due to some distractions and mishandling of scheduled posts on my part, I broke my blogging streak. I got up to 198 days, which isn&#8217;t bad, and I&#8217;m looking forward to beating it next time. A lot of people might not know this, but if you&#8217;re on <a href=\"http://wordpress.com/\">WordPress.com</a> or run <a href=\"http://jetpack.me/\">Jetpack</a> when you start a posting streak it will give you a notification high-five every day you continue it, this was the last one I got:</p>\n<p><img class=\"aligncenter  wp-image-45252\" src=\"http://i2.wp.com/ma.tt/files/2015/07/Screen-Shot-2015-07-18-at-9.06.19-AM.png?resize=386%2C394\" alt=\"Screen Shot 2015-07-18 at 9.06.19 AM\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Jul 2015 13:08:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 13 Aug 2015 21:42:20 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"276259\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Thu, 13 Aug 2015 21:30:16 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("151","current_theme","airconbasix","yes");
INSERT INTO wp_options VALUES("152","theme_mods_airconbasix","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:3;}}","yes");
INSERT INTO wp_options VALUES("153","theme_switched","","yes");
INSERT INTO wp_options VALUES("282","seedprod_maintenancemode_options","a:4:{s:19:\"comingsoon_bg_image\";s:76:\"http://moodsofafrica.com/develop/wp-content/uploads/2013/07/maintenance1.jpg\";s:19:\"comingsoon_headline\";s:19:\"Website Maintenance\";s:3:\"msg\";s:605:\"<p style=\"text-align: center;\"><a href=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/Logo.png\"><img class=\" size-full wp-image-223 aligncenter\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/Logo.png\" alt=\"Logo\" width=\"375\" height=\"99\" /></a></p>\r\n<p style=\"text-align: center;\">Our website is undergoing routine maintenance.</p>\r\n<p style=\"text-align: center;\">Sorry for the inconvenience - We will back in a couple of hours.</p>\r\n<p style=\"text-align: center;\">Please contact <a href=\"http://edgewebdesign.com.au\">edgewebdesign.com.au</a></p>\";s:24:\"comingsoon_footer_credit\";s:1:\"0\";}","yes");
INSERT INTO wp_options VALUES("285","seedprod_maintenancemode_mshot_pass","TAOtzli64XeI","yes");
INSERT INTO wp_options VALUES("369","wpsupercache_start","1392000846","yes");
INSERT INTO wp_options VALUES("370","wpsupercache_count","0","yes");
INSERT INTO wp_options VALUES("463","supercache_stats","a:3:{s:9:\"generated\";i:1439507932;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:12:\"expired_list\";a:0:{}s:6:\"cached\";i:0;s:11:\"cached_list\";a:0:{}s:2:\"ts\";i:1439507932;}s:7:\"wpcache\";a:3:{s:6:\"cached\";i:0;s:7:\"expired\";i:0;s:5:\"fsize\";s:3:\"0KB\";}}","yes");
INSERT INTO wp_options VALUES("501","wp_login_logo_settings","a:3:{s:11:\"enable_logo\";s:2:\"no\";s:8:\"logo_url\";s:0:\"\";s:15:\"custom_bg_color\";s:0:\"\";}","yes");
INSERT INTO wp_options VALUES("505","clp_options","a:23:{s:7:\"version\";d:2.399999999999999911182158029987476766109466552734375;s:4:\"logo\";s:88:\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/login-logo.png\";s:3:\"url\";s:47:\"http://comfortsolutions.com.au/airconditioning/\";s:5:\"title\";s:34:\"Web design by edgewebdesign.com.au\";s:10:\"logo_width\";s:3:\"239\";s:11:\"logo_height\";s:2:\"63\";s:8:\"h1_width\";s:0:\"\";s:9:\"h1_height\";s:0:\"\";s:9:\"h1_margin\";s:0:\"\";s:10:\"h1_padding\";s:0:\"\";s:9:\"h1_corner\";s:0:\"\";s:11:\"h1_shadow_x\";s:0:\"\";s:11:\"h1_shadow_y\";s:0:\"\";s:18:\"h1_shadow_softness\";s:0:\"\";s:15:\"h1_shadow_color\";s:0:\"\";s:15:\"body_background\";s:0:\"\";s:15:\"body_img_repeat\";s:0:\"\";s:12:\"body_img_pos\";s:0:\"\";s:14:\"body_bg_color1\";s:0:\"\";s:14:\"body_bg_color2\";s:0:\"\";s:12:\"body_bg_size\";s:0:\"\";s:9:\"multisite\";b:0;s:9:\"last_open\";s:8:\"logo_tab\";}","yes");
INSERT INTO wp_options VALUES("1451","db_upgraded","","yes");
INSERT INTO wp_options VALUES("11886","WPLANG","","yes");
INSERT INTO wp_options VALUES("11860","_site_transient_timeout_browser_d222b6a854d35c9c9584e695b623c468","1440106935","yes");
INSERT INTO wp_options VALUES("11861","_site_transient_browser_d222b6a854d35c9c9584e695b623c468","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"44.0.2403.155\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("4859","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:25:\"info@edgewebdesign.com.au\";s:7:\"version\";s:5:\"3.9.8\";s:9:\"timestamp\";i:1439502135;}","yes");
INSERT INTO wp_options VALUES("11897","_transient_timeout_feed_9e53082436aed3c2daf5425e656d2952","1439545721","no");
INSERT INTO wp_options VALUES("11898","_transient_feed_9e53082436aed3c2daf5425e656d2952","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:53:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n	 \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"SeedProd\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://www.seedprod.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Professional WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 19:15:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://wordpress.org/?v=4.2.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:17:\"\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://www.seedprod.com/wp-content/uploads/2014/11/site-icon1-5457a72e_site_icon-32x32.png\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"SeedProd\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://www.seedprod.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"Why Choose Self-Hosted WordPress Over the Alternatives?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://www.seedprod.com/self-hosted-wordpress-versus-alternatives/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://www.seedprod.com/self-hosted-wordpress-versus-alternatives/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Aug 2015 12:16:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://www.seedprod.com/?p=1631\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:639:\"<p>If you&#8217;re at the point where you&#8217;d like to start a blog, whether it&#8217;s for professional or personal reasons, your best option is a self-hosted website powered by WordPress. There is a reason why WordPress, as of this writing, commands almost 50% of the market share of websites using content management technologies. It&#8217;s because WordPress offers [&#8230;]</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/self-hosted-wordpress-versus-alternatives/\">Why Choose Self-Hosted WordPress Over the Alternatives?</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Tom Ewer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11002:\"<p>If you&#8217;re at the point where you&#8217;d like to start a blog, whether it&#8217;s for professional or personal reasons, your best option is a self-hosted website powered by WordPress.</p>\n<p>There is a reason why WordPress, as of this writing, commands <a href=\"http://trends.builtwith.com/cms\" target=\"_blank\">almost 50% of the market share</a> of websites using content management technologies. It&#8217;s because WordPress offers key advantages and ease-of-use features that are lacking in other options.</p>\n<p>In this article we&#8217;ll cover the alternatives to self-hosted WordPress, and the reasons why WordPress is most people&#8217;s CMS of choice.</p>\n<h2>WordPress: The World&#8217;s Favorite Content Management System</h2>\n<p>WordPress is a Content Management System (CMS). This means it&#8217;s a tool that makes it easy to add new blog posts and pages to your website. Using a CMS, you can write articles in a WYSIWYG (What You See Is What You Get) format, just as you do with your favorite word processor. You can also easily embed rich content, such as videos and images.</p>\n<p>A good CMS separates content from design. This means that you can change the look and feel of your website (often called the &#8220;theme&#8221;) without modifying every single blog post that you&#8217;ve created. That&#8217;s an added convenience for webmasters who want to upgrade to a more sophisticated or user-friendly blog format.</p>\n<div id=\"attachment_1661\" style=\"width: 710px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-1661\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Dashboard-1-800x364.png\" alt=\"Dashboard \" width=\"700\" height=\"319\" /><p class=\"wp-caption-text\">The WordPress dashboard</p></div>\n<p>Finally, a good CMS also enables users to extend the functionality of the software. Typically, this is done by adding additional software modules called &#8220;plugins&#8221; that are designed specifically for a particular feature set.</p>\n<h2>WordPress Is Not Without Competition</h2>\n<p>WordPress is not the only CMS available. It faces competition predominantly from two other options, both of which are licensed under the <a href=\"http://www.gnu.org/licenses/old-licenses/gpl-2.0.html\" target=\"_blank\">GNU General Public License</a> and free of charge. There are also three more options that are worth covering.</p>\n<h3>Drupal</h3>\n<p><img class=\"alignright wp-image-1665\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/logo-drupal-400x153.jpg\" alt=\"Drupal logo\" width=\"300\" height=\"115\" /> <a href=\"https://www.drupal.org/\" target=\"_blank\">Drupal</a> is the second most popular CMS behind WordPress.</p>\n<p>It&#8217;s often the choice for large corporations, but that&#8217;s because it&#8217;s designed for people who are tech-savvy. If you&#8217;re someone who&#8217;s more of an author than a software developer, you might opt for a solution that&#8217;s more user-friendly for people who aren&#8217;t programmers.</p>\n<p>Although Drupal is known for fast load times, adding plugins can slow things down considerably.</p>\n<h3>Joomla</h3>\n<p><a href=\"http://www.joomla.org/\" target=\"_blank\"><img class=\"alignright wp-image-1669\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Joomla-Logo-Horz-Color-400x81.png\" alt=\"Joomla Logo \" width=\"300\" height=\"61\" />Joomla</a> is often thought of as the median point between WordPress and Drupal. That&#8217;s because it&#8217;s not as technically sophisticated as Drupal, but offers some of the same benefits.</p>\n<p>One of the key benefits of Joomla is that it&#8217;s especially easy to use to set up an e-commerce site. While you can certainly set up an e-commerce site with either Drupal or WordPress, Joomla makes it particular simple.</p>\n<h3>Wix</h3>\n<p><a href=\"http://www.wix.com/\" target=\"_blank\"><img class=\"alignright wp-image-1671\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Wix.com_Logo-400x107.png\" alt=\"Wix.com Logo\" width=\"300\" height=\"81\" />Wix</a> is different from the previous two options in that it offers not only a CMS, but also a hosting platform as well (WordPress also offers a hosting platform, but this will be discussed later).</p>\n<p>Wix gives you the option to start your own website with a few clicks. It also enables you to select a theme that you can use to customize the look and feel of your blog.</p>\n<p>However, Wix isn&#8217;t open source. That means that you can&#8217;t modify the Wix code to customize the website. Even if you&#8217;re not a coder, the fact that it&#8217;s not open source means that it doesn&#8217;t offer plugins so you cannot enhance the functionality of your site.</p>\n<p>Also, Wix only offers a limited number of themes that you can use. You might have to &#8220;settle&#8221; for a theme that doesn&#8217;t properly convey the statement that you&#8217;re trying to make with your blog.</p>\n<h3>Squarespace</h3>\n<p><a href=\"http://www.squarespace.com/\" target=\"_blank\"><img class=\"alignright wp-image-1672\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/squarespace-logo-400x145.jpg\" alt=\"squarespace-logo\" width=\"300\" height=\"109\" />Squarespace</a> is similar to Wix in that you can easily create your own customized website with just a few clicks. It also offers its own CMS.</p>\n<p>However, like Wix, Squarespace isn&#8217;t open source. So, if you want additional functionality, you&#8217;ll have to submit a formal request to the development team and hope for the best.</p>\n<p>Keep in mind that Squarespace does permit you to make limited modifications to the CSS and HTML code (if you get the developer&#8217;s platform). However, you won&#8217;t be able to change the underlying functionality of the site as you can with WordPress.</p>\n<h3>Weebly</h3>\n<p><img class=\"alignright wp-image-1673\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Weebly-Logo-400x214.png\" alt=\"Weebly Logo\" width=\"300\" height=\"160\" />Another entry in the &#8220;build a website for free in a few simple steps&#8221; contest is <a href=\"http://www.weebly.com/\" target=\"_blank\">Weebly</a>. If you&#8217;re looking for something noticeably simple that offers limited customization, then you might like Weebly.</p>\n<p>However, if you want an industrial strength blog that can adapt to your growing user community, you&#8217;re not going to be satisfied with Weebly. It&#8217;s meant for very simple blogs that are not adaptable or customizable.</p>\n<h2>So Why WordPress?</h2>\n<p>Of the &#8220;big three&#8221;, why is WordPress the best option?</p>\n<p>For starters, WordPress is easy to install. You&#8217;ll find that if you opt for a self-hosted solution (more on this in a moment), a reputable hosting provider will enable you to install WordPress from the administrative console. You won&#8217;t have to know anything about the underlying operating system used to host your site, or which files need to be placed in which directories. The installation is handled for you seamlessly.</p>\n<p>Secondly, it&#8217;s the best option for small-to-medium size businesses and personal bloggers who just want to get right into blogging and not be bogged down with technical details of customization and installation. After installing WordPress and selecting a theme, you&#8217;re ready to start blogging. It&#8217;s that easy.</p>\n<p>Thirdly, you&#8217;re selecting an option that has been tested and selected by millions of fellow bloggers. As noted above, WordPress has almost half of the CMS market share. Its closest competitor, Drupal, only holds about 14% of the market share. So, by selecting WordPress, you&#8217;re choosing an option that has been validated as the best option by the blogging community at large.</p>\n<h2>Hosting at WordPress.com</h2>\n<p>If you&#8217;re interested in simply creating a website and learning how to use WordPress, you can head over to <a href=\"https://wordpress.com/\" target=\"_blank\">WordPress.com</a> and start a blog right now for free.</p>\n<p><img class=\"aligncenter wp-image-1674\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Wordpress-homepage-1-800x487.png\" alt=\"Wordpress homepage \" width=\"700\" height=\"426\" /></p>\n<p>WordPress.com doesn&#8217;t only provide you with the WordPress CMS so that you can start blogging; it also provides you with a host so that you can make your blog available to the world. It&#8217;s a great way to get started blogging with WordPress if you&#8217;ve never done so before.</p>\n<h2>A Self-Hosted Solution Is Best</h2>\n<p>Although you can host your blog for free at WordPress.com, a self-hosted solution is best.</p>\n<p>With a self-hosted solution you create your own domain name, and a professional web host provider hosts it. You do end up paying for your own domain name, along with a monthly charge for hosting the site, but there are several advantages to self-hosting instead of using WordPress.com.</p>\n<p>First of all, you&#8217;ll have more control with a self-hosted website. WordPress.com places restrictions on how much you can modify your website in terms of design and functionality. With a self-hosted solution, the sky is the limit.</p>\n<p>You&#8217;ll also be able to use any theme you want if you opt for a self-hosted WordPress site. At WordPress.com, you&#8217;re limited to several dozen themes, none of which might be what you think is best for your blog.</p>\n<p>You also won&#8217;t have to worry about an uncertain future if you select to host the blog yourself. At WordPress.com (although it&#8217;s unlikely) your site could be pulled down at any moment without notice.</p>\n<p>Finally, if you want to run ads on your WordPress site, you&#8217;ll have to opt for a self-hosted solution. You are prohibited from running ads on WordPress.com.</p>\n<h2>Conclusion</h2>\n<p>WordPress is a CMS that has been selected by the blogging community as the best option. It&#8217;s easy to use for people who aren&#8217;t technically-minded, and it&#8217;s free. As far as we&#8217;re concerned, it&#8217;s not <em>an</em> option – it&#8217;s <em>the</em> option.</p>\n<p>You may want to start your journey with WordPress.com, but if you&#8217;re looking for maximum flexibility, you&#8217;ll find that it&#8217;s best achieved through a self-hosted website that&#8217;s managed by a reputable hosting provider.</p>\n<p>The bottom line is this: If you select a self-hosted WordPress solution, you&#8217;ll not only be siding with an enormous number of bloggers; you&#8217;ll also be adopting a blogging technology that&#8217;s well-supported and can adapt to the specific needs of your website.</p>\n<p><strong>If you have any questions or comments about WordPress and/or its competition, please get in touch via the comments section below!</strong></p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/self-hosted-wordpress-versus-alternatives/\">Why Choose Self-Hosted WordPress Over the Alternatives?</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://www.seedprod.com/self-hosted-wordpress-versus-alternatives/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"How to Use Your Maintenance Page as a Marketing Tool\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://www.seedprod.com/how-to-use-your-maintenance-page-as-a-marketing-tool-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://www.seedprod.com/how-to-use-your-maintenance-page-as-a-marketing-tool-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Aug 2015 11:00:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"How To\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"marketing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"performance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://www.seedprod.com/?p=1678\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:398:\"<p>Got the maintenance page blues? Shake them off by learning how to turn an under construction page into a boon for your marketing.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/how-to-use-your-maintenance-page-as-a-marketing-tool-2/\">How to Use Your Maintenance Page as a Marketing Tool</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"John Turner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8077:\"<p>It’s happened to everyone: you’re all set to visit a page you are interested in, with content that you can’t wait to enjoy.</p>\n<p>After clicking the link, however, you receive a rude interruption to your browsing session: “Page Under Construction,” or “Website Under Maintenance,” flashes before you.</p>\n<p>Clouds suddenly turn dark. Flowers around you begin to wilt. Now you’ve got to figure out a different way to get the information you need. A deep depression sets in. Somewhere in the distance, a sad violin begins to play&#8230;</p>\n<p>Okay, so maybe that last part was a bit of an exaggeration, but it’s still annoying when you visit a website that is unexpectedly under maintenance. It means that visitors aren’t able to immediately find the answers that they seek, and in the worst cases, a page that’s unexpectedly under construction can cost you a customer and/or a subscriber.</p>\n<p>But it doesn’t have to be this way. If you set your page up properly, you can actually use your maintenance mode as a powerful marketing tool that helps attract people to your company and what it has to offer. With some careful planning and a dose of ingenuity, your maintenance mode page can become an asset instead of a liability.</p>\n<div id=\"attachment_1681\" style=\"width: 610px\" class=\"wp-caption alignnone\"><img class=\"size-full wp-image-1681\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/BrainLobesLabelled1.jpg\" alt=\"right side of brain From Manuel de L\'Anatomiste  Morel and Duval  1883\" width=\"600\" height=\"512\" /><p class=\"wp-caption-text\">right side of brain From Manuel de L&#8217;Anatomiste Morel and Duval 1883</p></div>\n<p>The frontal lobe in the right side of this picture is associated with familiarity and rewards</p>\n<h2>Use it to reinforce your brand</h2>\n<p>Your maintenance page should be consistent with the rest of your branding. Use the same colors, font, images, logos, etc. that you do on your other pages. If you have any company images that you use frequently, it’s probably a good idea to include them on your maintenance mode page as well.</p>\n<p>This might not seem like a huge deal, but reinforcing your brand using your maintenance page gives you the opportunity to become further entrenched in the memory of your prospects and customers.</p>\n<p>There’s actually scientific evidence that proves why this is important. Research shows that when people see logo designs they are familiar with, it <a href=\"http://dalepartridge.com/wp-content/uploads/2014/10/StartupCamp-Dale-Partridge.jpg\" target=\"_blank\">activates the parts of the brain that are associated with rewards</a>, including the pallidum, posterior cingulate and frontal cortex. So when you show your visitors your logo or another image related to your brand that they are familiar with, even if it’s on a maintenance page, you are subconsciously connecting your organization with an emotional reward.</p>\n<h2>Link to other sites they might be interested in</h2>\n<p>No matter how great your maintenance mode page might be, there’s still going to be a level of frustration on the part of visitors who were expecting to see the original page that they visited. There’s nothing you can do about this: it’s out of your control.</p>\n<p>What <i>is</i> in your control, however, is the direction that you guide your visitors after they reach your maintenance page. And one of the best directions to point them in is to other pages of your website, especially if these pages contain the answers that they were originally looking for.</p>\n<p>Suppose a visitor comes across a maintenance mode page for a specific product of yours, a site they visited to learn about that product’s specifications. Even though the individual page is down, maybe you have a similar page that has general specifications about your other products, which might contain the answer to their original question. Include a link to this page, and you just might find that your visitors aren’t as frustrated as they might have been.</p>\n<p>You also might discover that, with a bit of guidance, you’re able to get them interested in a completely different product or company offering all together. Don’t overdo it, however: think carefully about the buyer persona of your page visitors and then pick a few links that make the most sense.</p>\n<p><img class=\"alignnone size-full wp-image-1684\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/want-to-succeed.png\" alt=\"want-to-succeed\" width=\"1024\" height=\"512\" /></p>\n<h2>Provide your contact info</h2>\n<p>One of the most important facets of marketing is knowing what your audience wants. But unless you open yourself up to hearing their feedback, how can you expect to gain this understanding?</p>\n<p>The short answer: you can’t. So make sure that you offer at least a general email address where customers can reach you if they have further questions about your page. Even if no one actually contacts you, it’s a show of good faith that you are open to listening to feedback. Sure, you might have to deal with venting from an annoyed customer or prospect here and there, but your audience will appreciate the openness, and you’ll earn big points with them.</p>\n<p><img class=\"alignnone size-full wp-image-1683\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/underconstruction.png\" alt=\"underconstruction\" width=\"1280\" height=\"1280\" /></p>\n<p>&nbsp;</p>\n<p>Remember this guy from under construction websites in the 1990s? Let’s leave him there.</p>\n<h2>Be creative</h2>\n<p>Good marketing is creative marketing. As the digital world continues to grow, it’s becoming harder and harder to stand out from others in your field. Think about how many other businesses have the same old “Under Construction” or “Please pardon our dust” messages on their websites. Boring!</p>\n<p>If you really want to succeed in using your maintenance page as a marketing tool, you’ve got to do something to distinguish yourself. Be unexpected. Take risks. Make people remember you! The specific way that you do this depends on your industry and the kinds of people you are targeting.</p>\n<p>One thing to note: there’s also a slight difference between<a href=\"https://www.seedprod.com/great-b2b-under-construction-pages/\"> B2B maintenance pages</a> and B2C ones. B2C pages should be more focused on the benefits of the product or service, while B2B pages should be establishing authority and building a relationship with team members.</p>\n<h2>Use it as an excuse to reach out</h2>\n<p>This is a valuable maintenance page marketing tactic to use that doesn’t even have to be implemented on the page itself. If you know that you’ll be working on changing a specific website or portion of your site, preemptively send an email to your list or make a social media update about the matter.</p>\n<p>Of course you’ll want to come across as apologetic, but you should also use this opportunity to let people know that you have a new offering or service or you are making an existing one even better. With an explanation, a sincere apology for the inconvenience, and the understanding that the downtime will make your offerings better, it’s much easier for prospects and customers to accept that your page is in maintenance mode.</p>\n<h2>When one door closes, another opens</h2>\n<p>Don’t look at a page in maintenance mode as an obstacle that stands in the way of building relationships with your customers. If you go about it properly, a page in coming soon mode can actually be the opposite. Think creatively about your target audience, keep your branding consistent, and be open and available for your customers and prospects, and you might find that a maintenance mode page actually <i>helps</i> your business instead of hurting it.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/how-to-use-your-maintenance-page-as-a-marketing-tool-2/\">How to Use Your Maintenance Page as a Marketing Tool</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://www.seedprod.com/how-to-use-your-maintenance-page-as-a-marketing-tool-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:51:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"The Ultimate Launch Checklist for Your WordPress Website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://www.seedprod.com/ultimate-launch-checklist-wordpress-website/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://www.seedprod.com/ultimate-launch-checklist-wordpress-website/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jul 2015 13:13:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:12:\"404 Page Pro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:16:\"launch checklist\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:7:\"plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://www.seedprod.com/?p=1603\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:603:\"<p>There are two big problems that generally arise when you have a big list of tasks to complete: you feel overwhelmed by the sheer scale of the project, and in the midst of task overwhelm, you miss something important. Launching your WordPress website can definitely feel like an overwhelming challenge, and one where you don&#8217;t [&#8230;]</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/ultimate-launch-checklist-wordpress-website/\">The Ultimate Launch Checklist for Your WordPress Website</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Tom Ewer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:19005:\"<p>There are two big problems that generally arise when you have a big list of tasks to complete:</p>\n<ol>\n<li>you feel overwhelmed by the sheer scale of the project, and</li>\n<li>in the midst of task overwhelm, you miss something important.</li>\n</ol>\n<p>Launching your WordPress website can definitely feel like an overwhelming challenge, and one where you don&#8217;t want to miss checking over something important. Fortunately, this post is here to help.</p>\n<p>Today, we&#8217;ll look at all the many tasks (big and small) you need to complete before you launch your WordPress site. We&#8217;ll explain why each is important and tell you how to mark each one off your launch checklist.</p>\n<p>Let&#8217;s get cracking!</p>\n<h2>1. No Spelling and Grammar Errors</h2>\n<p>It&#8217;s important to use correct spelling and fix serious grammar errors before publishing your content. We all make mistakes of course, but any more than one or two small errors on your site will lose the trust of your users and impact your business&#8217; credibility.</p>\n<p>There are a number of ways you could check your spelling and grammar. If you want to check from within the WordPress editor, try the <a href=\"https://wordpress.org/plugins/tinymce-spellcheck/\" target=\"_blank\">TinyMCE Spellcheck plugin</a>:</p>\n<p><img class=\"aligncenter size-full wp-image-1605\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/TinyMCE-Spellcheck-Screenshot.png\" alt=\"TinyMCE Spellcheck Screenshot\" width=\"723\" height=\"273\" /></p>\n<p>This plugin adds an easily accessible spell check button to the post editor and features customization options for each user. Here&#8217;s a <a href=\"http://www.wpbeginner.com/plugins/how-to-check-grammar-and-spelling-mistakes-in-wordpress/\" target=\"_blank\">quick tutorial</a> on how to install it and get your content edited and ready for launch.</p>\n<h2>2. Content Has Been Placed in All Content Areas</h2>\n<p>As you&#8217;re building out your site, you may end up using some placeholder content, thinking, <em>I&#8217;ll fill this in later</em>. Placeholder content can be quite helpful as you build and design your site. However, you need to make sure you go back and fill in all your content areas before you launch.</p>\n<p>Unfortunately, there&#8217;s no magic bullet plugin that will seek out such missing content areas. In this case, you&#8217;ll want to keep track of pages and sections where you&#8217;ve loaded placeholder content so you can find them easily. Also consider having other members of your team or a beta user group work through your site to look for problems.</p>\n<h2>3. No Web Page Formatting Errors Exist</h2>\n<p>Are your content and images formatted correctly so that they display correctly on the page? Is the usage of text and image formatting styles consistent across the whole website? Are your stylesheets, scripts, and images rendering your content the way you intended? If so, excellent. If not, fix them now before your users have to confront the problems.</p>\n<p>Again an easy way to test this out is through having a beta user group navigate through your site and report back.</p>\n<h2>4. The Print Stylesheet Has Been Created and Tested</h2>\n<p>This is a launch checklist item that a number of websites forego. Who prints web pages, anyway?</p>\n<p>Still there are a number of reasons your users may choose to hit print:</p>\n<ul>\n<li>Project or services quotes.</li>\n<li>Receipts.</li>\n<li>Resumes and bios.</li>\n<li>Info for viewing offline.</li>\n<li>Sharing an article.</li>\n</ul>\n<p>Giving your users a well-formatted print stylesheet is a nice touch, and it&#8217;s fairly easy to set up. There&#8217;s a great tutorial over at <a href=\"http://www.smashingmagazine.com/2011/11/24/how-to-set-up-a-print-style-sheet/\" target=\"_blank\">Smashing Magazine</a> which covers exactly that.</p>\n<h2>5. Meta Tags Are Set Up</h2>\n<p>Meta tags are WordPress&#8217; way of talking to machines about what&#8217;s on your site. The metadata supplied to search engines like Google and Bing may include information about content, authors, publishers, and media, using fields such as <i>description</i> and <i>keywords</i>.</p>\n<p>It makes sense to spend a bit of time helping search engines as they index and catalog your web pages – ultimately directing more traffic to your site. For a plugin specifically designed to do this, <a href=\"https://wordpress.org/plugins/add-meta-tags/\" target=\"_blank\">Add Meta Tags</a> is a popular choice that&#8217;s been around in various forms for a decade.</p>\n<p><img class=\"aligncenter size-full wp-image-1607\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Add-Meta-Tags-Screenshot.png\" alt=\"Add Meta Tags Screenshot\" width=\"688\" height=\"360\" /></p>\n<p>Another option is to use the Meta Tag features found in SEO plugins, such as <a href=\"https://wordpress.org/plugins/wordpress-seo/\" target=\"_blank\">WordPress SEO by Yoast</a> or <a href=\"https://wordpress.org/plugins/all-in-one-seo-pack/\" target=\"_blank\">All-in-One SEO</a>.</p>\n<h2>6. Page Titles Are Descriptive and Optimized for Search Engines</h2>\n<p>You probably already know that you should be using <a href=\"https://codex.wordpress.org/Using_Permalinks\" target=\"_blank\">Pretty Permalinks</a> for your post titles, because it gives users and search engines more information about your content. There are a number of options for naming your post pages under <i>Settings &gt; Permalinks</i> in the admin area:</p>\n<p><img class=\"aligncenter size-full wp-image-1609\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Pretty-Permalinks-Screenshot.png\" alt=\"Pretty Permalinks Screenshot\" width=\"531\" height=\"226\" /></p>\n<p>However, don&#8217;t forget to set up your site&#8217;s Page Title and Tagline. There are several ways to do this. You can navigate to <i>Settings &gt; General</i> where you&#8217;ll find the following fields:</p>\n<p><img class=\"aligncenter size-full wp-image-1610\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Site-Title-Screenshot.png\" alt=\"Site Title Screenshot\" width=\"618\" height=\"203\" /></p>\n<p>For individual pages on your site, use an <a href=\"https://wordpress.org/plugins/wordpress-seo/\" target=\"_blank\">SEO plugin</a> – this will give you the option to give each page a descriptive and relevant name, right from your admin page editor.</p>\n<h2>7. All Images Have Alt Text</h2>\n<p>Start how you mean to go on – make sure all your site&#8217;s images have alt text. The <em>Alt Text</em> field is right under the <em>Caption</em> field for each image in your Media Library:<img class=\" size-full wp-image-1611 aligncenter\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Alt-Text-Screenshot.png\" alt=\"Alt Text Screenshot\" width=\"257\" height=\"207\" />The alt text attribute was originally created to help support accessibility features such as screen readers, but it is also an important SEO feature. Along with the Title tag, adding alt text will help search engines determine how a particular image relates to the rest of the content on the page. In turn, that could help your users find relevant content on your site via search. <a href=\"http://havecamerawilltravel.com/photographer/image-alt-tags-wordpress\" target=\"_blank\">Photographer David Coleman</a> has more tips over on his blog.</p>\n<h2>8. The Site Favicon Has Been Created and Tested</h2>\n<p>Short for favorites icon, the <a href=\"https://codex.wordpress.org/Creating_a_Favicon\" target=\"_blank\">favicon</a> for your site shows up in a lot of places, despite its small size. It typically shows up in browser tabs next to the title of your page, and can also be used as a bookmark icon on desktop and mobile.</p>\n<p><img class=\"aligncenter size-full wp-image-1612\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Custom-Favicon-Screenshot.png\" alt=\"Custom Favicon Screenshot\" width=\"687\" height=\"359\" /></p>\n<p>Many themes allow you to easily upload your custom favicon image within the theme. For those that don&#8217;t, the <a href=\"https://wordpress.org/plugins/custom-favicon/\" target=\"_blank\">Custom Favicon</a> plugin gives you an easy way to add a favicon image to your site.</p>\n<p>Favicons <a href=\"http://www.wpbeginner.com/news/whats-coming-in-wordpress-4-3-features-and-screenshots/\" target=\"_blank\">will be supported in WordPress 4.3</a>, meaning you&#8217;ll be able to upload your site icon in the admin area and be able to preview the results without needing a plugin.</p>\n<h2>9. The Footer Includes a Copyright Notice, Important Info, and Any Key Links</h2>\n<p>The footer is one of the last parts of your website users see, but that doesn&#8217;t mean you can neglect it.</p>\n<p>Your copyright notice should be included in your footer. It protects your work according to standard copyright laws or (if you want to) you can list your content under a Creative Commons license to allow others to use your content.</p>\n<p>Some sites also choose to include important information such as their business address or contact information. Others include a mini site directory with links to all the important pages available on your site.</p>\n<h2>10. The HTML and CSS Code Is Valid</h2>\n<p>Before you launch your site, you must ensure that your code is valid. W3 Consortium has a <a href=\"http://www.w3schools.com/website/web_validate.asp\" target=\"_blank\">free online validator tool</a>. It will check your HTML, CSS, XHTML, and XML code for errors.</p>\n<p>Why is valid code important? It helps to ensure that your site is compatible with the current standards used by major browsers. Unaddressed errors could also cause your site to break later on if a newer browser version conflicts with an error in your code.</p>\n<p>Your site&#8217;s SEO can also be helped by running your code through validation software. Some errors may cause parts of your site to go unindexed, meaning they won&#8217;t turn up in search results.</p>\n<h2>11. The JavaScript is Free from Errors</h2>\n<p>If your site contains custom JavaScript, you want to make that the code is also free from errors. <a href=\"http://www.jslint.com/help.html\" target=\"_blank\">JSLint</a> is one online tool that enables you to check your code.</p>\n<p><img class=\"aligncenter size-large wp-image-1620\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/JSLint-1-800x307.png\" alt=\"JSLint \" width=\"800\" height=\"307\" /></p>\n<p>The program looks for syntax errors, style conventions, and structural problems, and returns messages if it finds any errors.</p>\n<h2>12. There Are No Broken Links</h2>\n<p>Broken links can be both frustrating for users and damaging to your SEO. The <a href=\"https://wordpress.org/plugins/broken-link-checker/\" target=\"_blank\">Broken Link Checker</a> plugin does exactly what it says it does: find your broken links, missing images, and missing redirects, and alert you so they can be fixed before you launch.</p>\n<p><img class=\"aligncenter size-full wp-image-1613\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Broken-Link-Checker-Screenshot.png\" alt=\"Broken Link Checker Screenshot\" width=\"717\" height=\"171\" /></p>\n<p>The plugin monitors your posts, pages, comments, and blogroll for any errors that may come up. You can choose to be notified in the dashboard or by email when problems are found.</p>\n<h2>13. The Site Displays and Functions in All Compatible Browsers</h2>\n<p>We&#8217;d all prefer for users to only use the latest versions of Chrome, Firefox, and Internet Explorer, but that&#8217;s not how the Internet works. This year, nearly <a href=\"http://gs.statcounter.com/#desktop-browser_version_partially_combined-ww-monthly-201501-201507-bar\" target=\"_blank\">6% of worldwide web users</a> were still using old versions of Internet Explorer.</p>\n<p>If your users are likely to use older browsers, mobile browsers, or non-standard browsers to view your website, you&#8217;ll want to know what your site will look like and how it will function.</p>\n<p><img class=\"aligncenter size-large wp-image-1614\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Browser-Stack-Screenshot-800x540.png\" alt=\"Browser Stack Screenshot\" width=\"800\" height=\"540\" /></p>\n<p><a href=\"https://www.browserstack.com/screenshots\" target=\"_blank\">BrowserStack&#8217;s Browser Screenshots</a> is a great-looking free web tool with an easy-to-use interface. It&#8217;s important to remember to check your site&#8217;s functionality on mobile, which this tool also enables you to do. More and more users are accessing the web through mobile devices, so it&#8217;s important that your site presents correctly for them.</p>\n<h2>14. The Site Has Been Tested for Multiple Devices</h2>\n<p>Speaking of users viewing your site on mobile, make sure that you know how your site will look and function on different devices. Google Chrome&#8217;s <a href=\"https://chrome.google.com/webstore/detail/screen-resolution-tester/bnbpeddmakpmblddofjnoghpjminhjph?hl=en\" target=\"_blank\">Screen Resolution Tester</a> is a handy tool to have. This Chrome extension enables you to see how the site will look on various devices through your Chrome browser.</p>\n<p><img class=\"aligncenter size-large wp-image-1615\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Viewlike-us-Screenshot-800x421.png\" alt=\"Viewlike.us Screenshot\" width=\"800\" height=\"421\" /></p>\n<p>For more information about how functional your site will be on various devices and why, try using a tool like <a href=\"http://www.viewlike.us/\" target=\"_blank\">Viewlike.us</a>. This free web program gives feedback on text legibility, tap target size, and usability for various screen sizes.</p>\n<h2>15. All Forms Are Set Up and Functional</h2>\n<p>Will your soon-to-launch WordPress site include any forms, such as any made by <a href=\"https://wordpress.org/plugins/contact-form-7/\" target=\"_blank\">Contact Form 7</a>? Forms can be great for growing your subscriber base, generating leads, or answering questions.</p>\n<p><img class=\"aligncenter size-full wp-image-1616\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Contact-Form-7-Screenshot.png\" alt=\"Contact Form 7 Screenshot\" width=\"688\" height=\"333\" /></p>\n<p>However, you wouldn&#8217;t want to launch without testing that your forms work as intended. Ensure that your forms not only look great on the user side, but also that any data collected goes to the correct email address or file folder.</p>\n<h2>16. The Analytics Data Plugin is Set Up</h2>\n<p>Before you launch your site, make sure that you have a way to track your site&#8217;s performance. After all the work spent on building and readying your site, you want to know how many users are visiting your new site, how they got there, and where they spend the most time.</p>\n<p><a href=\"http://www.google.com/analytics/\" target=\"_blank\">Google Analytics</a> is the standard choice for many websites wanting to track this data, and there are several great plugins that will integrate Google Analytics with WordPress.</p>\n<p><img class=\"aligncenter size-full wp-image-1617\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Google-Analytics-by-Yoast-Screenshot.png\" alt=\"Google Analytics by Yoast Screenshot\" width=\"691\" height=\"338\" /></p>\n<p><a href=\"https://wordpress.org/plugins/google-analytics-for-wordpress/\" target=\"_blank\">Google Analytics by Yoast</a> makes it easy to add tracking codes to all your pages and collect a variety of data about search results and error pages.</p>\n<p><img class=\"aligncenter size-full wp-image-1618\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/Google-Analytics-Dashboard-Screenshot.png\" alt=\"Google Analytics Dashboard Screenshot\" width=\"689\" height=\"339\" /></p>\n<p>The <a href=\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/\" target=\"_blank\">Google Analytics Dashboard for WP</a> plugin gets your WordPress site connected with Google Analytics, enabling you to review analytics reports straight from your WordPress dashboard.</p>\n<h2>17. The Backup Plugin is Set Up</h2>\n<p>After all the time spent building your site and going through this launch checklist, you wouldn&#8217;t want to lose your work. A backup plugin will provide extra peace of mind that should a server fail or a hacker attack your site, you&#8217;ll be able to recover quickly. For more on the why (and how) of backing up your WordPress site, see <a href=\"https://www.seedprod.com/backing-up-site-before-launch/\" target=\"_blank\">our in-depth post</a>.</p>\n<h2>18. The Security Plugins Are Set Up</h2>\n<p>Now you&#8217;ve got your site protected with a backup solution, your focus should turn to security. Add strong security protocols for even more protection against hackers. There are a number of <a href=\"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/\" target=\"_blank\">plugins</a> that can help you, as well as some smart advice in <a href=\"https://www.seedprod.com/security-before-launching-wordpress-site/\" target=\"_blank\">our recent ten step security article</a>.</p>\n<h2>19. The 404 Page is Set Up</h2>\n<p>If a visitor to your newly launched site does end up navigating to a missing page or a mistyped URL, that mistake should be an opportunity rather than a dead end. Setting up a 404 page before you launch can help you engage with your users, and SeedProd makes a <a href=\"https://www.seedprod.com/wordpress-404-page-plugin/\" target=\"_blank\">nifty 404 page plugin</a> that can help you do just that.</p>\n<p><img class=\"aligncenter size-full wp-image-1297\" src=\"https://www.seedprod.com/wp-content/uploads/2015/05/featured-404.png\" alt=\"404 Page Plugin\" width=\"600\" height=\"460\" /></p>\n<p>The 404 Page Pro plugin enables you to create a custom 404 page, with options to add custom text and imagery, an email signup form, search box, and social links. Head over to the <a href=\"https://www.seedprod.com/wordpress-404-page-pro/\" target=\"_blank\">product page</a> to learn more.</p>\n<h2>Wrapping Up</h2>\n<p>Getting a web page ready for launch is no small task, as you can see. As a quick recap, beyond building the site and adding the content, you need to:</p>\n<ol>\n<li>Check your content and code for errors.</li>\n<li>Optimize your site for search engines, including images and links.</li>\n<li>Ensure your site works on different browsers and screen sizes.</li>\n<li>Set up SEO across your site.</li>\n<li>Make sure you have a backup.</li>\n<li>Check your security.</li>\n<li>Implement analytics plugins.</li>\n<li>Set up a 404 page.</li>\n</ol>\n<p>Work through this launch checklist one step at a time, and in no time you&#8217;ll be ready to release your site into the WordPress wilds.</p>\n<p><b>Did we miss anything? What would you add to our ultimate launch checklist? Let us know in the comments below!</b></p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/ultimate-launch-checklist-wordpress-website/\">The Ultimate Launch Checklist for Your WordPress Website</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://www.seedprod.com/ultimate-launch-checklist-wordpress-website/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:54:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"What’s the Difference Between a Landing Page and a Coming Soon Page?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://www.seedprod.com/whats-the-difference-between-a-landing-page-and-a-coming-soon-page/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://www.seedprod.com/whats-the-difference-between-a-landing-page-and-a-coming-soon-page/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Jul 2015 11:00:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Promotions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"download\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:12:\"Landing Page\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"Ultimate Coming Soon Page\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://www.seedprod.com/?p=1595\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:422:\"<p>Landing Pages and Coming Soon pages: they have a lot alike, but they’re very different. Learn the nuances of both kinds. </p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/whats-the-difference-between-a-landing-page-and-a-coming-soon-page/\">What’s the Difference Between a Landing Page and a Coming Soon Page?</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"John Turner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7796:\"<p>Like an alligator compared to a crocodile or a rectangle compared to a square, landing pages and coming soon pages are very similar, yet not exactly the same thing.</p>\n<p>It’s not immediately apparent right away what the difference is. After all, don’t these two types of pages share the goal of attracting the interest of visitors?</p>\n<p>Well, yes, but so does nearly every other page on the Internet! There are a few critical points that you need to understand about the differences between landing pages and coming soon pages. Let’s dive in and explore them.</p>\n<h2>A Landing Page is Permanent; But a Coming Soon Page is Always Temporary</h2>\n<p>This one is pretty obvious, but it’s still something that some marketers fail to consider. After a certain length of time, every coming soon page will be deleted or changed into a different kind of page. That’s not to say that they should be neglected: just because they are a temporary part of your marketing efforts doesn’t mean that you shouldn’t take the time to carefully plan and design them.</p>\n<p>On the other hand, once you decide on its goal and target audience, a landing page rarely changes. Unless something happens that causes a large-scale shift in the makeup of your audience, or you decide to stop offering the particular product or service that it is dedicated to, your landing page probably isn’t going anywhere.</p>\n<p><img class=\"alignnone size-full wp-image-1598\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/neilpatel.jpg\" alt=\"neilpatel\" width=\"512\" height=\"512\" /></p>\n<p>Listen to Neil Patel’s advice and make sure your landing page only has ONE goal</p>\n<h2>A Landing Page Has One Specific Goal; a Coming Soon Page Can Have Multiple</h2>\n<p>Neil Patel put it best <a href=\"http://blog.crazyegg.com/2014/08/14/unconventional-landing-page-techniques/\" target=\"_blank\">in a blog post for Crazy Egg</a>: a landing page is about <i>one thing</i>. It’s one of the first rules of creating landing pages. Sure, you can include multiple calls-to-action in different formats in a variety of locations on the page, but your landing page is still only in existence to achieve that one goal, whether it is building your email list or selling a specific type of product or service.</p>\n<p>On the other hand, coming soon pages don’t necessarily need to have one single goal. There are <a href=\"https://www.seedprod.com/coming-soon-pages-wordpress/\">many different kinds of great coming soon pages</a> that are all good for different reasons.</p>\n<p>One company might use a coming soon page simply to show off a cool design or a tantalizing picture of their upcoming product. Another business might decide that they want to use their coming soon page as a way to build their email list. Still other companies with a coming soon page might want to direct visitors to a different website, often their main company page.</p>\n<p>All of these options can be correct. Don’t feel like you have to restrict your coming soon page to one specific function (although that’s not necessarily a bad thing). But your landing page should most definitely have only one goal to achieve.</p>\n<p><img class=\"alignnone size-full wp-image-1599\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/multiple-persona.png\" alt=\"multiple-persona\" width=\"1024\" height=\"512\" /></p>\n<h2>A Coming Soon Page Can Have Many Target Audiences; a Landing Page Should Have One</h2>\n<p>Just like your coming soon page can be used for more than one goal or conversion objective, it can also be used to speak to different audiences. Looking to generate interest in your upcoming product or service among potential customers? It’s easy to do that with a coming soon page.</p>\n<p>Trying to get attention from investors who might be able to provide funding for your idea in its early stages? Yes, a coming soon page can do this too. You can also use a coming soon page to generate attention from stores or resellers, who you’ll need to have strong alliances with if you are not selling your product directly to the consumer.</p>\n<p>A landing page, on the other hand, shouldn’t be talking to more than one person. In fact, often the entire point of using landing pages is to gain attention from multiple personas. It’s a very common tactic: companies will start by asking the visitor about the kind of job they have and the kind of solution they are looking for.</p>\n<p>Once the user makes a selection, they are directed to a landing page that is customized based on the profile they selected. An excellent example of this is the way that IBM has segmented its <a href=\"http://www.ibm.com/analytics/watson-analytics/\" target=\"_blank\">landing pages for its Watson Analytics platform</a>.</p>\n<p><img class=\"alignnone size-full wp-image-1597\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/ibm-watson-roles.png\" alt=\"ibm-watson-roles\" width=\"1266\" height=\"706\" /></p>\n<p>As you see, many different types of business professionals would be well-suited for Watson, so IBM has decided to allow visitors to choose their job function and be directed to a customized landing page that has information specifically for them. This is a great approach to designing landing pages, because it allows you to target multiple types of customers yet still abide by the one-audience-per-page rule.</p>\n<h2>A Coming Soon Page Should Be Updated Often; a Landing Page’s <i>Message</i> Should Remain Static</h2>\n<p>Sure, you might not need to update a coming soon page every day, and many people never update them at all. But these types of coming soon pages miss out on a good opportunity to keep people updated about the progress you are making on your new service or product.</p>\n<p>HubSpot provides us a great example of this technique in their blog about their annual marketing conference, INBOUND. Although it’s not exactly a landing page, the company creates<a href=\"http://www.inbound.com/blog\" target=\"_blank\"> a dedicated blog</a> that is designed to share information about the upcoming conference in the months leading up to it.</p>\n<p>Why does HubSpot do this? The same reason that you should share updates and new information on your coming soon page: to stir up excitement, share information with people who are already attending the event, and convince people who are on the fence that it’s a good investment to go to the conference.</p>\n<p>When we look at landing pages, however, their <i>message</i> doesn’t change much. Why is it so important to understand that only the message should remain static? Because one of the big principles of quality landing page design is A/B testing. You should always be running tests on the content of your landing page so that you can make minor tweaks to it.</p>\n<p>But these tweaks are just that: minor. They might be things like trying a new color for a button, or placing a CTA in a different location on the page. Changes like this are fine on landing pages, and in fact you <i>should</i> be making these changes relatively often to help improve your conversion rate. But once you know the message that your landing page is trying to convey, and who it is trying to convey it to, that message should remain relatively unchanged.</p>\n<p>While there are similarities, and both kinds of pages have an ultimate goal of attracting interest in a brand, marketers would do well to understand these differences and stay conscious of them as they work to create either kind of page.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/whats-the-difference-between-a-landing-page-and-a-coming-soon-page/\">What’s the Difference Between a Landing Page and a Coming Soon Page?</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://www.seedprod.com/whats-the-difference-between-a-landing-page-and-a-coming-soon-page/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"10 B2B Under Construction Pages (And What Makes Them Great)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://www.seedprod.com/great-b2b-under-construction-pages/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://www.seedprod.com/great-b2b-under-construction-pages/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Jul 2015 14:00:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://www.seedprod.com/?p=1582\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:585:\"<p>Last week, we took at look at some of our favorite B2C under construction pages and what made them great. This week, we&#8217;re turning our attention to B2B under construction pages and how they differ from B2C pages. Two words come up again and again with B2B businesses: Relationships Value Not only do B2B companies [&#8230;]</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/great-b2b-under-construction-pages/\">10 B2B Under Construction Pages (And What Makes Them Great)</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Tom Ewer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:12606:\"<p>Last week, we took at look at some of our <a href=\"http://seedprod.com/best-b2c-under-construction-pages\" target=\"_blank\">favorite B2C under construction pages</a> and what made them great. This week, we&#8217;re turning our attention to B2B under construction pages and how they differ from B2C pages.</p>\n<p>Two words come up again and again with B2B businesses:</p>\n<ul>\n<li>Relationships</li>\n<li>Value</li>\n</ul>\n<p>Not only do B2B companies need to build a relationship with their clients, they also need to show their clients the value of their products or services.</p>\n<p>Relationships become important because for some B2B companies, sales cycles get longer or more complicated. Sometimes, it&#8217;s not as simple as adding a product to a cart and checking out. To keep a prospective client interested, B2B businesses have to build up relationships.</p>\n<p>Likewise, business leaders don&#8217;t tend to act on spur of the moment emotions. Buying decisions are more rational. Clients need to be shown the business value of your products or services so that they can make an informed decision to buy from you.</p>\n<p>B2B under construction pages that put the right emphasis on business relationships and value are going to perform better than those that don&#8217;t. Let&#8217;s take a look how these B2B concerns are addressed in 10 great B2B under construction pages.</p>\n<h2>Build Relationships with Your B2B Audience</h2>\n<p>Some B2B pages focus on relationships, either to keep potential customers and clients interested through a longer sales cycle, or to help turn them into repeat customers.</p>\n<p>Please be aware that some of the under construction pages below no longer exist, either because the company has taken off or has decided to close.</p>\n<h3><a href=\"http://www.coffeeshopfreelancers.com/\" target=\"_blank\">Coffee Shop Freelancers</a></h3>\n<p><img class=\"aligncenter size-large wp-image-1097\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/coffeeshopfreelancers.com_-800x544.jpeg\" alt=\"Coffee Shop Freelancers Coming Soon Page\" width=\"800\" height=\"544\" /></p>\n<p>For Coffee Shop Freelancers&#8217; under construction page, the focus of the copy is networking, a key concern for a target audience of freelancers. The page offers the value of helping with that top concern, but also uses visuals and the rest of the page content to begin a relationship with potential customers. A subscription signup and social media profile links give visitors several ways to get connected and stay informed.</p>\n<p>After all, repeat customers are important; it actually <a href=\"https://blog.kissmetrics.com/retaining-customers/\" target=\"_blank\">costs more to bring in a new customer</a> than to retain an existing one.</p>\n<h3><a href=\"http://birdboxx.com/\" target=\"_blank\">BirdBoxx</a></h3>\n<p><img class=\"aligncenter size-large wp-image-1583\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/birdboxx-under-construction-800x529.png\" alt=\"birdboxx under construction screenshot\" width=\"800\" height=\"529\" /></p>\n<p>With its page, BirdBoxx hopes to build a long-term relationship with its target audience of accommodation providers. This is important because the company&#8217;s services won&#8217;t be a one-time sale. BirdBoxx will need to get clients to use their services repeatedly to meet their goals.</p>\n<p>The birdhouse design and brand name are prominent in this under construction page design, and will likely be seen time and time again on the finished site and advertising materials. The distinct design could help efforts to build those all-important customer relationships.</p>\n<p>For its value offer, the page promises a &#8220;vibrant new holiday and vacation accommodation directory&#8221; – which, for travel industry clients, could be very appealing. An email signup rounds out the page.</p>\n<h3>Shopidex</h3>\n<p><img class=\"aligncenter size-large wp-image-1121\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/2014-06-19_10-12-01-800x539.jpeg\" alt=\"ShopIndex Coming Soon Page with Gravity Forms\" width=\"800\" height=\"539\" /></p>\n<p>The Shopidex under construction page is about B2B relationships from its very first words. The page promises an offer of a networking &#8220;community&#8221; for small business owners. A Gravity Forms section enables business owners to input their info right on the under construction page to become part of the community.</p>\n<p>However, it&#8217;s worth noting that between the site description and signup form, the page gives a bullet list of values the community will provide. Even though the purpose of this page will be to build long-term relationships with business clients, the page shows clients what value their services will provide.</p>\n<h3>Brand Ahead</h3>\n<p><img class=\"aligncenter size-large wp-image-1041\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/2012-11-28_2125-800x447.jpeg\" alt=\"brandahead.net Coming Soon Page\" width=\"800\" height=\"447\" /></p>\n<p>Brand Ahead is another business that puts the focus of their under construction page on long-term relationship building. This B2B business&#8217; services are focused on advertising, an industry that typically requires longer sales cycles than a quick online purchase.</p>\n<p>The &#8220;thinking outside of the box&#8221; graphic adds an incentive for like-minded visitors to connect with the brand. An email signup along with Facebook and Twitter profile links give those potential customers several ways to begin a relationship with Brand Ahead.</p>\n<h3><a href=\"https://pitchstock.com/\" target=\"_blank\">PitchStock</a></h3>\n<p><img class=\"aligncenter size-large wp-image-1127\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/pitchstock.com_-800x515.jpeg\" alt=\"pitchstock.com Coming Soon Page\" width=\"800\" height=\"515\" /></p>\n<p>PitchStock is another company that does a nice job starting that business relationship with under construction page visitors. A key step is identifying with your potential customers. This page does so with a well-chosen visual and nice copy.</p>\n<p>The boardroom view in the image could be intimidating to many potential customers, and addressing that concern could go a long way to cement a relationship. The page&#8217;s tagline identifies a thought many potential customers might have: the need to impress everyone in the room.</p>\n<p>While the background image and tagline get visitors interested in a B2B relationship, the page&#8217;s email signup, social media links, and blog link give them ample ways to get connected.</p>\n<h2>Demonstrate Value to Your B2B Audience</h2>\n<p>Other B2B under construction pages can focus on the value of a particular product or service. Telling a visitor upfront how your business offer can help their business goes a long way towards winning their business.</p>\n<h3>Bookelish</h3>\n<p><img class=\"aligncenter size-large wp-image-1028\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/bookelish.com_-800x587.jpeg\" alt=\"bookelish.com Coming Soon Page\" width=\"800\" height=\"587\" /></p>\n<p>Bookelish&#8217;s under construction page offers services to authors who want to publish and sell their work. The under construction page offers several values to its audience. The site promises experts in the publishing field help with self-publishing, and the promise that it will be a major publishing company — &#8220;of the decade&#8221; — is of big potential value to authors.</p>\n<p>The page follows up its value-focused copy with a prompt for visitors to sign up for email and a link to the company&#8217;s Twitter page – valuable tools to help Bookelish continue building a relationship.</p>\n<h3>The Threads Collective</h3>\n<p><img class=\"aligncenter size-large wp-image-1003\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/2012-12-19_0817-800x430.jpeg\" alt=\"thethreadscollective.com Coming Soon Page\" width=\"800\" height=\"430\" /></p>\n<p>With its under construction page, the Threads Collective leads off with the value of what types of goods they will sell and what quality potential retail clients can expect. The page promises &#8220;clothing, accessories, and more&#8221; sourced from the latest fashion collections. Big brand names and indie label goods will be on offer and the page emphasizes the added value clients receive by having access to both from the same vendor.</p>\n<p>This site follows up its value case with a few words that might help build a relationship with target clients: <i>we&#8217;re currently hard at work coding, designing and drinking Jack Daniels.</i> This copy makes clear that there are real people behind the business and adds a bit of personality.</p>\n<p>Lastly, the page makes sure to prompt visitors for their email and offers yet more value with the promise of &#8220;early-bird access&#8221;.</p>\n<h3><a href=\"http://fontdeck.com/\" target=\"_blank\">Fontdeck</a></h3>\n<p><img class=\"aligncenter size-large wp-image-1585\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/fontdeck-screenshot-800x396.png\" alt=\"fontdeck screenshot\" width=\"800\" height=\"396\" /></p>\n<p>Fontdeck&#8217;s under construction page keeps things simple, but makes sure to identify how their business can help clients. The company&#8217;s service makes custom font options available to client websites – a simple proposition that could offer a lot of value for businesses that need custom website typography.</p>\n<p>The page features an email signup and a call to action to follow Fontdeck on Twitter.</p>\n<h3>InstantPSD</h3>\n<p><img class=\"aligncenter size-large wp-image-1586\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/instant-psd-screenshot-800x426.png\" alt=\"instant psd screenshot\" width=\"800\" height=\"426\" /></p>\n<p>The under construction page for InstantPSD is short on copy length but not on content. It offers a &#8220;new way to manage your PSD files&#8221; for prospective graphic designer users – a specific pain point graphic designers are likely to identify with. Also notice that the word &#8220;subscribe&#8221; is highlighted in blue – it emphasizes the email signup call to action below.</p>\n<h3><a href=\"http://medialoot.com/\" target=\"_blank\">MediaLoot</a></h3>\n<p><img class=\"aligncenter size-large wp-image-1587\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/medialoot-screenshot-800x428.png\" alt=\"medialoot screenshot\" width=\"800\" height=\"428\" /></p>\n<p>MediaLoot is yet another B2B under construction page targeted at designers. This company&#8217;s tagline makes it clear what value the company offers prospective customers: design resources that are not only &#8220;premium&#8221;, they&#8217;re &#8220;hand-selected&#8221; as well. The under construction page doesn&#8217;t specify the cost of its products, but does suggest it has a valuable deal for designers who sign up — presumably less than $5 for an individual resource, according to the copy.</p>\n<p>This page is yet another that doesn&#8217;t stop at value. Much of the copy also begins the process of connecting with potential customers, by identifying common frustrations with other design resource shops.</p>\n<p>The under construction page closes with an email signup and several ways to connect — Twitter, Facebook, and via RSS.</p>\n<h2>Wrapping Up</h2>\n<p>For B2B businesses it&#8217;s clear: your under construction page should focus on business relationships, business value, or both.</p>\n<p>You can use your under construction page to not only keep the attention of potential customers and clients through a longer sales cycle, but also turn them into repeat customers by building relationships.</p>\n<p>You can also give your B2B customers a reason to buy. Focus on the value your product and services provide to your customers and clients in order to win their business.</p>\n<p>Lastly, remember that you don&#8217;t have to choose only one tactic. Notice that even though some pages focus more on relationships or value, it&#8217;s still hard to separate the two. A number of our favorite under construction pages on this list did a good job balancing both.</p>\n<p>Put the right emphasis on relationships and value, and your B2B under construction page could help bring in business, even before your site launches.</p>\n<p><strong>Do you have a favorite B2B under construction page? Let us know in the comments below. </strong></p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/great-b2b-under-construction-pages/\">10 B2B Under Construction Pages (And What Makes Them Great)</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://www.seedprod.com/great-b2b-under-construction-pages/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:51:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"The Best B2C ‘Under Construction’ Pages (And What Makes Them Great)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://www.seedprod.com/best-b2c-under-construction-pages/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://www.seedprod.com/best-b2c-under-construction-pages/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Jul 2015 17:54:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:15:\"Coming Soon Pro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:25:\"Ultimate Coming Soon Page\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:23:\"under construction page\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://www.seedprod.com/?p=1522\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:654:\"<p>When it comes to building a great under construction page, customer-facing companies have a different set of concerns from business-to-business companies. As Masterful Marketing notes, these types of businesses are similar, but different. B2C companies have to: Put their products or services front and center – that&#8217;s what the customer cares about. Cast a wide [&#8230;]</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/best-b2c-under-construction-pages/\">The Best B2C &#8216;Under Construction&#8217; Pages (And What Makes Them Great)</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Tom Ewer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10965:\"<p>When it comes to building a great under construction page, customer-facing companies have a different set of concerns from business-to-business companies. As <a href=\"http://masterful-marketing.com/marketing-b2b-vs-b2c/\" target=\"_blank\">Masterful Marketing notes</a>, these types of businesses are similar, but different.</p>\n<p>B2C companies have to:</p>\n<ul>\n<li>Put their products or services front and center – that&#8217;s what the customer cares about.</li>\n<li>Cast a wide net – your target market is anyone who&#8217;s interested in your offerings.</li>\n<li>Use imagery to create and reinforce your brand identity.</li>\n<li>Tie the decision to buy to emotions related to identity, desire, or price.</li>\n</ul>\n<p>How does this list factor into an excellent under construction page?</p>\n<p>I&#8217;m glad you asked! Let&#8217;s take a look at some of the best B2C under construction pages from <a href=\"https://www.seedprod.com/showcase/\" target=\"_blank\">SeedProd&#8217;s showcase</a>, as well as a few favorites from the web. We&#8217;ll look at how they get customers excited about their products and services, and then how they use their under construction page to get email signups, social media interactions, and more, from their future customers.</p>\n<p>First up, let&#8217;s look at some great examples from the SeedProd showcase.</p>\n<h2><a href=\"http://revistaocapop.com/\" target=\"_blank\">Revista OcaPop</a></h2>\n<p><img class=\"aligncenter wp-image-1091 size-large\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/revistaocapop.com_-800x628.jpeg\" alt=\"Revista Coming Soon Page\" width=\"800\" height=\"628\" /></p>\n<p>Revista OcaPop&#8217;s under construction page is one of our favorites (after all, it&#8217;s part of our homepage imagery). We&#8217;re guessing it&#8217;s a favorite with its future home interiors magazine customers, too. The imagery shows customers exactly the type of style and design to expect from their digital magazine, and when, thanks to a launch counter. Customers looking for this type of content may be looking for ideas or want the products shown in the image. There&#8217;s a handy email signup to stay informed, and prominent links to follow or share the page on social media.</p>\n<h2><a href=\"http://www.theastonishingpost.com/\" target=\"_blank\">The Astonishing Post</a></h2>\n<p><img class=\"aligncenter wp-image-1088 size-large\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/theastonishingpost.com_-800x979.jpeg\" alt=\"theastonishingpost.com Coming Soon Page\" width=\"800\" height=\"979\" /></p>\n<p>The Astonishing Post under construction page targets a different kind of online magazine audience. The collage of black and white drawings is really distinct and fans of this style of art are likely to identify with it. One image even says &#8220;This is my Internet!&#8221;. The text block, highlighted by a splash of pink, speaks directly to future customers, telling them how the site can help them and then makes a strong call to action to join the newsletter and be notified of the launch.</p>\n<h2><a href=\"http://www.backpackertravel.org/\" target=\"_blank\">Backpacker Travel</a></h2>\n<p><img class=\"aligncenter size-large wp-image-1101\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/2015-03-05_14-14-42-800x490.jpeg\" alt=\"Backpacker Trave Coming Soon Page\" width=\"800\" height=\"490\" /></p>\n<p>Backpackers love beautiful scenic views like this one. It&#8217;s the reward for hiking through rough terrain. A picture like this might have potential customers thinking about their favorite backpacking trip, or planning their next one. The under construction page also invites potential customers to identify with and join a group of like-minded individuals. A simple email signup and social media links show them how.</p>\n<h2><a href=\"http://www.iamthelab.com/\" target=\"_blank\">LAB Petite</a></h2>\n<p><img class=\"aligncenter size-large wp-image-1235\" src=\"https://www.seedprod.com/wp-content/uploads/2015/04/iamthelab.com_-800x561.jpg\" alt=\"iamthelab.com\'s Coming Soon page\" width=\"800\" height=\"561\" /></p>\n<p>Lab Petite&#8217;s under construction page uses repetition of their balloon logo to help reinforce its brand identity. Brightly colored text signals to potential customers that this is a business that caters to their kid&#8217;s needs. The appeal of the products is pretty broad – almost any parent with a small child could be persuaded to buy &#8220;modern handmade&#8221; clothing and toys. A counter tells parents when the site will go live and the email signup means they&#8217;ll be notified when it does.</p>\n<h2><a href=\"http://www.lot17studios.com.au/\" target=\"_blank\">Lot 17 Studios</a></h2>\n<p><img class=\"aligncenter size-large wp-image-1067\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/lot17studios.com_-800x602.jpeg\" alt=\"lot17studios.com Coming Soon Page\" width=\"800\" height=\"602\" /></p>\n<p>Like Lab Petite, Lot 17 Studios is another B2C company that emphasizes their brand to attract future customers. The recording studio&#8217;s oversized logo uses a bold, retro font that likely appeals to their demographic. Links are listed for future customers to learn more and connect through email, and a simple email signup notifies potential customers when the site launches.</p>\n<h2><a href=\"http://fixers.travel\" target=\"_blank\">Fixers</a></h2>\n<p><img class=\"aligncenter size-large wp-image-1108\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/2015-01-27_15-52-06-800x513.jpeg\" alt=\"Fixer Coming Soon Page\" width=\"800\" height=\"513\" /></p>\n<p>An under construction page has the potential to really connect with your customers. Many people could identify with the tagline: &#8220;Life&#8217;s too short for ordinary holidays&#8221;. Everyone wants an &#8220;extraordinary&#8221; vacation. But the page leaves room for potential customers to define for themselves what kind of extraordinary vacation they&#8217;re looking for. The imagery suggests Fixers offers will appeal to young, adventurous travelers, but again, it&#8217;s not too specific. The models could be in any number of countries. The email signup gives customers a way to learn more, with the hashtag opening the door to social media engagement.</p>\n<h2><a href=\"http://gymanda.com/\" target=\"_blank\">Gymanda</a></h2>\n<p><img class=\"aligncenter size-large wp-image-1105\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/2014-11-03_10-12-27-800x478.jpeg\" alt=\"Gymanda Coming Soon Page\" width=\"800\" height=\"478\" /></p>\n<p>If you are your product, it makes sense to put yourself on your under construction page. Gymanda&#8217;s page features the personal trainer and yoga instructor in a fun pose that puts her on top of the world. Future customers can get a good sense of what they&#8217;re signing up for – they can see who they&#8217;ll be working with and that she&#8217;s a fun and positive trainer. The text gives a call to action for interested customers to signup for email news and connect on social media.</p>\n<h2><a href=\"http://www.miabellaocchi.com/\" target=\"_blank\">Mia Bella Occhi</a></h2>\n<p><img class=\"aligncenter size-large wp-image-1085\" src=\"https://www.seedprod.com/wp-content/uploads/2015/03/miabellaocchi-coming-soon-page-800x576.jpeg\" alt=\"miabellaocchi.com Coming Soon Page\" width=\"800\" height=\"576\" /></p>\n<p>Mia Bella Occhi is another under construction page example that puts the products in front of potential customers except, instead of personal training, this company sells a line of fashion eyewear to its customers. Stylish customers will likely identify with the copy in the content window, using fashion to express themselves or feeling &#8220;bold, vivid, and adventurous&#8221;. There&#8217;s an exclusivity to the page&#8217;s offer as well, telling potential customers to sign up for access to their exclusive product line.</p>\n<p>Let&#8217;s look at a few more examples that aren&#8217;t from our SeedProd showcase. As you can see, these under construction pages have similar elements to get their users excited about their products and services.</p>\n<h2><a href=\"http://www.iamdjmos.com/\" target=\"_blank\">IAMDJMOS</a></h2>\n<p><img class=\"aligncenter wp-image-1529 size-large\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/iamdjmos-under-construction-800x428.png\" alt=\"IAMDJMOS Under Construction Page\" width=\"800\" height=\"428\" /></p>\n<p>The IAMDJMOS under construction page puts the product – DJ M.O.S. – front and center. Potential music customers can see who is making the music they&#8217;ll listen to. A unique graphic logo helps build the DJ&#8217;s brand identity. A counter, email signup, and social media links give potential customers three ways to stay informed and connected.</p>\n<h2><a href=\"https://lillystable.com/\" target=\"_blank\">Lilly&#8217;s Table</a></h2>\n<p><img class=\"aligncenter wp-image-1550 size-large\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/best_1402-800x532.jpg\" alt=\"\" width=\"800\" height=\"532\" /></p>\n<p>Lilly&#8217;s Table uses a repetitive graphic and color scheme to help build its brand identity. The bold headline copy appeals to a wide variety of potential customers who want to cook healthy meals. The email signup is prominent and social media and blog links are included for potential customers who want to learn more.</p>\n<h2>Wrapping Up</h2>\n<p>Your B2C under construction page doesn&#8217;t have to be boring or plain. You can use a wide variety of visuals and copy to get your potential customers excited about your products and services, and prompt them with unique calls-to-action to suit your business needs.</p>\n<p>Beyond just imagery and text though, you&#8217;ll notice all these under construction pages included email list signups, social media sharing or profile links, and occasionally links to other content as well. You can and should include these features in your under construction page as well to get customers interacting.</p>\n<p><b>If you’re ready to build your own under construction page, consider </b><a href=\"https://www.seedprod.com/pricing/\"><b>SeedProd’s own Coming Soon Pro WordPress plugin</b></a><b>. Many of the examples you see here were built with it. </b></p>\n<p>As you can see from the SeedProd examples above, this is a really versatile plugin. Each website owner can start with the same plugin, but build completely different and unique under construction pages perfectly suited to their needs. It’s hard to believe so many of these pages were built with the same plugin, but we’re so glad they were.</p>\n<p><strong>What’s your favorite under construction page design and what makes it your favorite? Let us know in the comments! </strong></p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/best-b2c-under-construction-pages/\">The Best B2C &#8216;Under Construction&#8217; Pages (And What Makes Them Great)</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://www.seedprod.com/best-b2c-under-construction-pages/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:51:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"4 Common Mistakes on “Coming Soon” Pages\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://www.seedprod.com/4-common-mistakes-on-coming-soon-pages/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://www.seedprod.com/4-common-mistakes-on-coming-soon-pages/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Jul 2015 11:00:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:15:\"Coming Soon Pro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://www.seedprod.com/?p=1555\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"<p>Your “coming soon” page can be a huge marketing tool, if you know how to use it. To start, make sure to avoid these common failures.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/4-common-mistakes-on-coming-soon-pages/\">4 Common Mistakes on “Coming Soon” Pages</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"John Turner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7959:\"<p>A “coming soon” page can be many things.</p>\n<p>A way to promote your brand. A method of growing your loyal subscriber base. It could even be a way for you to show off some fancy design skills.</p>\n<p>But there’s also a few things that your “coming soon” page <i>shouldn’t</i> be. Agencies, business owners, and all types of marketers in between make mistakes with these pages simply because they generally aren’t an area of focus for a marketing plan.</p>\n<p>That’s a mistake on a broad level, but there are several specific missteps that you should avoid if you want your “coming soon” page to attain optimal success.</p>\n<h2>Not collecting information from visitors</h2>\n<p>Unless they’ve navigated there accidentally, people who are visiting your “coming soon” page are there for a reason. The odds are good that they want to learn something about your brand, your upcoming launch, or both.</p>\n<p>So instead of having them browse away after they check out the information you have on your page, why not collect their details and stay in touch?</p>\n<p>If you’ve done a good job at building interest in your organization and what it has to offer, most people won’t mind giving you their email address and receiving the occasional pre-launch email from you. In fact, collecting contact information is frequently listed as <a href=\"http://www.smashingmagazine.com/2011/09/01/elements-of-a-viral-launch-page/\" target=\"_blank\">a critical ingredient for a viral launch page</a>.</p>\n<p>Just don’t overdo it: save the heavy email marketing guns for after your new site, company or offering is ready.</p>\n<p><img class=\"alignnone size-full wp-image-1559\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/collect-info.png\" alt=\"collect-info\" width=\"1466\" height=\"338\" /></p>\n<p>An example of the type of information you should be collecting from visitors to your “coming soon” page</p>\n<h2>Not providing enough information</h2>\n<p>This is a common one. How many times have you seen a cool abstract design on a “coming soon” page, accompanied by a vague message like one of these:</p>\n<ul>\n<li>“[Company] is coming. [Date].”</li>\n<li>“On [date], [product] will change the industry forever.”</li>\n<li>“The future of [industry] is here on [date].”</li>\n</ul>\n<p>While these phrases may be mysterious and will certainly add a “cool” factor to your brand and upcoming offering, there’s one big problem with them: it doesn’t give your audience any concrete information about just <i>what </i>is coming!</p>\n<p>It’s true: you want to have a certain degree of mystery leading up to your launch. It helps build curiosity, which keeps people interested in what you are offering.</p>\n<p>But you shouldn’t be <i>so</i> mysterious that you completely forget to draw in your target audience. You don’t have to give away all the details of your new offering, product or service, but try to at least hint at it.</p>\n<p>For example: launching a new accounting product? You could make reference to company numbers or reports. Creating a new fashion brand? Mention something about style or confidence. These indirect marketing messages are ambiguous enough to maintain your air of mystery, but they’ll do a better job of keeping your target audience interested.</p>\n<p><img class=\"alignnone size-full wp-image-1563\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/perfect-time.png\" alt=\"perfect-time\" width=\"1024\" height=\"512\" /></p>\n<h2>Not providing additional content</h2>\n<p>A “coming soon” page is great: simply by having this type of website in place, you’re ahead of the curve when it comes to marketing.</p>\n<p>But why stop there?</p>\n<p>The perfect time to use content to engage with your audience is when they are already engaged with your “coming soon” page.</p>\n<p>You can do this in a number of ways. If the layout of your “coming soon” page supports it, you might want to think about creating a blog with updates and information about your upcoming launch.</p>\n<p>Marketing automation company HubSpot does a great job of this with their <a href=\"http://www.inbound.com/blog\" target=\"_blank\">INBOUND marketing conference event</a>. The blog for this upcoming event features information about the speakers, background information about the city of Boston, and other details that people who are interested in the conference might want to know.</p>\n<p>If you’d prefer to keep a cleaner “coming soon” page, that’s okay too. But you should still link out to your existing website, a social media page, or some other destination where your audience can go to find out more about your upcoming product, service or business launch. The more content that you can provide your audience with, the more likely it is that they’ll remain interested until your launch, when there’s a good chance they’ll become some of your earliest customers.</p>\n<p>A couple of ideas for this type of supporting content:</p>\n<ul>\n<li>Behind-the-scenes looks at your team working on your upcoming launch offering</li>\n<li>An in-depth look at a challenge or problem that your new product, brand or service will solve</li>\n<li>A picture of a component, ingredient or tool used to make your new product or offering</li>\n</ul>\n<p>If you think creatively, ideas for content to support your “coming soon” page are nearly endless.</p>\n<h2>Not optimizing your page for search</h2>\n<p>This is a common mistake made by marketers. On the surface, the reasoning for this issue is a simple one. Why invest time and energy into optimizing a “coming soon” page? Wouldn’t your efforts be better spent making a better product, and then launching a significant search engine optimization campaign afterwards?</p>\n<p>The fact is, if you really want to attain search engine optimization success, you have to do both.</p>\n<p>You see, search engine optimization is not the type of marketing technique that can give you overnight success. There’s no one answer when it comes to how long an SEO campaign will take to bear results, but <a href=\"http://www.forbes.com/sites/joshsteimle/2015/02/07/how-long-does-seo-take-to-start-working/\" target=\"_blank\">most experts agree that it usually takes at least 4 months</a>, and sometimes a whole year, before the full results of search engine optimization are realized.</p>\n<p>So why would you want to waste these months not optimizing your “coming soon” page for search engines?</p>\n<p>You shouldn’t.</p>\n<p>When you are building, editing and adding content to your “coming soon” page, make sure that you pay attention to titles, tags, meta descriptions and other <a href=\"https://www.seedprod.com/seo-tips-wordpress-coming-soon-pages/\">important elements of search engine optimization for a “coming soon” page</a>.</p>\n<p><img class=\"alignnone size-full wp-image-1560\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/wordpress-seo-plugin.png\" alt=\"wordpress-seo-plugin\" width=\"904\" height=\"570\" /></p>\n<p>Yoast is one of the most popular WordPress plugins available today.</p>\n<p>This will give you a huge advantage. By the time your product, service or new business is ready to be revealed, you will already be well on your way to ranking highly in relevant search results and acquiring more customers as a result.</p>\n<h2>Your “Coming Soon” Page is Not a Placeholder!</h2>\n<p>This is the most important thing to remember about your page. If you plan carefully, you can avoid mistakes like these and use a “coming soon” page to make serious progress building your audience base and gaining traction on search engines, setting you up for a highly successful launch.</p>\n<p>&nbsp;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/4-common-mistakes-on-coming-soon-pages/\">4 Common Mistakes on “Coming Soon” Pages</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://www.seedprod.com/4-common-mistakes-on-coming-soon-pages/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Introducing Coming Soon Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://www.seedprod.com/coming-soon-themes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://www.seedprod.com/coming-soon-themes/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Jul 2015 14:11:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://45.55.162.90/?p=1161\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:531:\"<p>The Coming Soon Pro plugin is one of the most powerful Coming Soon Plugins for WordPress and comes with an equally customizable default theme. In fact most of the sites in our Showcase were built just using the settings for the default theme. But some of our customers wanted a jump start on their coming soon [&#8230;]</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/coming-soon-themes/\">Introducing Coming Soon Themes</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"John Turner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11426:\"<p>The <a href=\"http://www.seedprod.com\">Coming Soon Pro</a> plugin is one of the most powerful Coming Soon Plugins for WordPress and comes with an equally customizable default theme. In fact most of the sites in our <a href=\"https://www.seedprod.com/showcase/\">Showcase</a> were built just using the settings for the default theme. But some of our customers wanted a jump start on their coming soon page designs. Today we are proud to announce <a href=\"https://www.seedprod.com/themes/\">Premium Coming Soon Page Themes</a> that can be applied to the Coming Soon Pro plugin. It&#8217;s as easy as uploading a plugin and selecting the themes. That&#8217;s it, an instant new look!</p>\n<p>Here are a few of the <a href=\"https://www.seedprod.com/themes/\">themes</a> and we plan to add many more.</p>\n\n<a href=\'https://www.seedprod.com/coming-soon-themes/screenshot/\'><img width=\"200\" height=\"160\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot.png\" class=\"attachment-medium\" alt=\"screenshot\" data-attachment-id=\"1575\" data-orig-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot.png\" data-orig-size=\"200,160\" data-comments-opened=\"1\" data-image-meta=\"{&quot;aperture&quot;:&quot;0&quot;,&quot;credit&quot;:&quot;&quot;,&quot;camera&quot;:&quot;&quot;,&quot;caption&quot;:&quot;&quot;,&quot;created_timestamp&quot;:&quot;0&quot;,&quot;copyright&quot;:&quot;&quot;,&quot;focal_length&quot;:&quot;0&quot;,&quot;iso&quot;:&quot;0&quot;,&quot;shutter_speed&quot;:&quot;0&quot;,&quot;title&quot;:&quot;&quot;,&quot;orientation&quot;:&quot;0&quot;}\" data-image-title=\"screenshot\" data-image-description=\"\" data-medium-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot.png\" data-large-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot.png\" /></a>\n<a href=\'https://www.seedprod.com/coming-soon-themes/screenshot-3/\'><img width=\"200\" height=\"160\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-3.png\" class=\"attachment-medium\" alt=\"screenshot-3\" data-attachment-id=\"1574\" data-orig-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-3.png\" data-orig-size=\"200,160\" data-comments-opened=\"1\" data-image-meta=\"{&quot;aperture&quot;:&quot;0&quot;,&quot;credit&quot;:&quot;&quot;,&quot;camera&quot;:&quot;&quot;,&quot;caption&quot;:&quot;&quot;,&quot;created_timestamp&quot;:&quot;0&quot;,&quot;copyright&quot;:&quot;&quot;,&quot;focal_length&quot;:&quot;0&quot;,&quot;iso&quot;:&quot;0&quot;,&quot;shutter_speed&quot;:&quot;0&quot;,&quot;title&quot;:&quot;&quot;,&quot;orientation&quot;:&quot;0&quot;}\" data-image-title=\"screenshot-3\" data-image-description=\"\" data-medium-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-3.png\" data-large-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-3.png\" /></a>\n<a href=\'https://www.seedprod.com/coming-soon-themes/screenshot-9/\'><img width=\"200\" height=\"160\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-9.png\" class=\"attachment-medium\" alt=\"screenshot-9\" data-attachment-id=\"1567\" data-orig-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-9.png\" data-orig-size=\"200,160\" data-comments-opened=\"1\" data-image-meta=\"{&quot;aperture&quot;:&quot;0&quot;,&quot;credit&quot;:&quot;&quot;,&quot;camera&quot;:&quot;&quot;,&quot;caption&quot;:&quot;&quot;,&quot;created_timestamp&quot;:&quot;0&quot;,&quot;copyright&quot;:&quot;&quot;,&quot;focal_length&quot;:&quot;0&quot;,&quot;iso&quot;:&quot;0&quot;,&quot;shutter_speed&quot;:&quot;0&quot;,&quot;title&quot;:&quot;&quot;,&quot;orientation&quot;:&quot;0&quot;}\" data-image-title=\"screenshot-9\" data-image-description=\"\" data-medium-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-9.png\" data-large-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-9.png\" /></a>\n<a href=\'https://www.seedprod.com/coming-soon-themes/screenshot-5/\'><img width=\"200\" height=\"160\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-5.png\" class=\"attachment-medium\" alt=\"screenshot-5\" data-attachment-id=\"1568\" data-orig-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-5.png\" data-orig-size=\"200,160\" data-comments-opened=\"1\" data-image-meta=\"{&quot;aperture&quot;:&quot;0&quot;,&quot;credit&quot;:&quot;&quot;,&quot;camera&quot;:&quot;&quot;,&quot;caption&quot;:&quot;&quot;,&quot;created_timestamp&quot;:&quot;0&quot;,&quot;copyright&quot;:&quot;&quot;,&quot;focal_length&quot;:&quot;0&quot;,&quot;iso&quot;:&quot;0&quot;,&quot;shutter_speed&quot;:&quot;0&quot;,&quot;title&quot;:&quot;&quot;,&quot;orientation&quot;:&quot;0&quot;}\" data-image-title=\"screenshot-5\" data-image-description=\"\" data-medium-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-5.png\" data-large-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-5.png\" /></a>\n<a href=\'https://www.seedprod.com/coming-soon-themes/screenshot-2/\'><img width=\"200\" height=\"160\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-2.png\" class=\"attachment-medium\" alt=\"screenshot-2\" data-attachment-id=\"1569\" data-orig-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-2.png\" data-orig-size=\"200,160\" data-comments-opened=\"1\" data-image-meta=\"{&quot;aperture&quot;:&quot;0&quot;,&quot;credit&quot;:&quot;&quot;,&quot;camera&quot;:&quot;&quot;,&quot;caption&quot;:&quot;&quot;,&quot;created_timestamp&quot;:&quot;0&quot;,&quot;copyright&quot;:&quot;&quot;,&quot;focal_length&quot;:&quot;0&quot;,&quot;iso&quot;:&quot;0&quot;,&quot;shutter_speed&quot;:&quot;0&quot;,&quot;title&quot;:&quot;&quot;,&quot;orientation&quot;:&quot;0&quot;}\" data-image-title=\"screenshot-2\" data-image-description=\"\" data-medium-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-2.png\" data-large-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-2.png\" /></a>\n<a href=\'https://www.seedprod.com/coming-soon-themes/screenshot-7/\'><img width=\"200\" height=\"160\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-7.png\" class=\"attachment-medium\" alt=\"screenshot-7\" data-attachment-id=\"1570\" data-orig-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-7.png\" data-orig-size=\"200,160\" data-comments-opened=\"1\" data-image-meta=\"{&quot;aperture&quot;:&quot;0&quot;,&quot;credit&quot;:&quot;&quot;,&quot;camera&quot;:&quot;&quot;,&quot;caption&quot;:&quot;&quot;,&quot;created_timestamp&quot;:&quot;0&quot;,&quot;copyright&quot;:&quot;&quot;,&quot;focal_length&quot;:&quot;0&quot;,&quot;iso&quot;:&quot;0&quot;,&quot;shutter_speed&quot;:&quot;0&quot;,&quot;title&quot;:&quot;&quot;,&quot;orientation&quot;:&quot;0&quot;}\" data-image-title=\"screenshot-7\" data-image-description=\"\" data-medium-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-7.png\" data-large-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-7.png\" /></a>\n<a href=\'https://www.seedprod.com/coming-soon-themes/screenshot-4/\'><img width=\"200\" height=\"160\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-4.png\" class=\"attachment-medium\" alt=\"screenshot-4\" data-attachment-id=\"1571\" data-orig-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-4.png\" data-orig-size=\"200,160\" data-comments-opened=\"1\" data-image-meta=\"{&quot;aperture&quot;:&quot;0&quot;,&quot;credit&quot;:&quot;&quot;,&quot;camera&quot;:&quot;&quot;,&quot;caption&quot;:&quot;&quot;,&quot;created_timestamp&quot;:&quot;0&quot;,&quot;copyright&quot;:&quot;&quot;,&quot;focal_length&quot;:&quot;0&quot;,&quot;iso&quot;:&quot;0&quot;,&quot;shutter_speed&quot;:&quot;0&quot;,&quot;title&quot;:&quot;&quot;,&quot;orientation&quot;:&quot;0&quot;}\" data-image-title=\"screenshot-4\" data-image-description=\"\" data-medium-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-4.png\" data-large-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-4.png\" /></a>\n<a href=\'https://www.seedprod.com/coming-soon-themes/screenshot-6/\'><img width=\"200\" height=\"160\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-6.png\" class=\"attachment-medium\" alt=\"screenshot-6\" data-attachment-id=\"1572\" data-orig-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-6.png\" data-orig-size=\"200,160\" data-comments-opened=\"1\" data-image-meta=\"{&quot;aperture&quot;:&quot;0&quot;,&quot;credit&quot;:&quot;&quot;,&quot;camera&quot;:&quot;&quot;,&quot;caption&quot;:&quot;&quot;,&quot;created_timestamp&quot;:&quot;0&quot;,&quot;copyright&quot;:&quot;&quot;,&quot;focal_length&quot;:&quot;0&quot;,&quot;iso&quot;:&quot;0&quot;,&quot;shutter_speed&quot;:&quot;0&quot;,&quot;title&quot;:&quot;&quot;,&quot;orientation&quot;:&quot;0&quot;}\" data-image-title=\"screenshot-6\" data-image-description=\"\" data-medium-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-6.png\" data-large-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-6.png\" /></a>\n<a href=\'https://www.seedprod.com/coming-soon-themes/screenshot-1/\'><img width=\"200\" height=\"160\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-1.png\" class=\"attachment-medium\" alt=\"screenshot-1\" data-attachment-id=\"1573\" data-orig-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-1.png\" data-orig-size=\"200,160\" data-comments-opened=\"1\" data-image-meta=\"{&quot;aperture&quot;:&quot;0&quot;,&quot;credit&quot;:&quot;&quot;,&quot;camera&quot;:&quot;&quot;,&quot;caption&quot;:&quot;&quot;,&quot;created_timestamp&quot;:&quot;0&quot;,&quot;copyright&quot;:&quot;&quot;,&quot;focal_length&quot;:&quot;0&quot;,&quot;iso&quot;:&quot;0&quot;,&quot;shutter_speed&quot;:&quot;0&quot;,&quot;title&quot;:&quot;&quot;,&quot;orientation&quot;:&quot;0&quot;}\" data-image-title=\"screenshot-1\" data-image-description=\"\" data-medium-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-1.png\" data-large-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-1.png\" /></a>\n<a href=\'https://www.seedprod.com/coming-soon-themes/screenshot-8/\'><img width=\"200\" height=\"160\" src=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-8.png\" class=\"attachment-medium\" alt=\"screenshot-8\" data-attachment-id=\"1566\" data-orig-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-8.png\" data-orig-size=\"200,160\" data-comments-opened=\"1\" data-image-meta=\"{&quot;aperture&quot;:&quot;0&quot;,&quot;credit&quot;:&quot;&quot;,&quot;camera&quot;:&quot;&quot;,&quot;caption&quot;:&quot;&quot;,&quot;created_timestamp&quot;:&quot;0&quot;,&quot;copyright&quot;:&quot;&quot;,&quot;focal_length&quot;:&quot;0&quot;,&quot;iso&quot;:&quot;0&quot;,&quot;shutter_speed&quot;:&quot;0&quot;,&quot;title&quot;:&quot;&quot;,&quot;orientation&quot;:&quot;0&quot;}\" data-image-title=\"screenshot-8\" data-image-description=\"\" data-medium-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-8.png\" data-large-file=\"https://www.seedprod.com/wp-content/uploads/2015/07/screenshot-8.png\" /></a>\n\n<p>Got a question about themes? Just <a href=\"https://www.seedprod.com/contact/\">drop us a line</a>!</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/coming-soon-themes/\">Introducing Coming Soon Themes</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://www.seedprod.com/coming-soon-themes/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"Why (And How) You Should Start Backing Up Your Site Before Launch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://www.seedprod.com/backing-up-site-before-launch/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://www.seedprod.com/backing-up-site-before-launch/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Jun 2015 14:00:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://www.seedprod.com/?p=1495\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:599:\"<p>According to a recent survey by CodeGuard, 22% of the WordPress users who participated hadn’t been trained at all in WordPress backup and had “no idea” how to do it. Before you pour hundreds of hours into your freshly launched WordPress site and rely on it to serve an important function for your business and your marketing [&#8230;]</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/backing-up-site-before-launch/\">Why (And How) You Should Start Backing Up Your Site Before Launch</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Tom Ewer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13865:\"<p>According to a recent survey by <a href=\"http://wptavern.com/codeguard-survey-shows-more-education-is-needed-on-backup-software-services-and-strategies-for-wordpress\" target=\"_blank\">CodeGuard</a>, 22% of the WordPress users who participated hadn’t been trained at all in WordPress backup and had “no idea” how to do it.</p>\n<p>Before you pour hundreds of hours into your freshly launched WordPress site and rely on it to serve an important function for your business and your marketing – start backing it up. After all it&#8217;d be a shame, not to mention a serious setback, to lose all that work.</p>\n<p>Backing up your WordPress site is a no-brainer, but in case you still have doubts, this week we&#8217;ll be talking more specifically about why you should begin backing up your site even before you launch. We&#8217;ll look at four main issues that might cause you to need a backup and then take a look at five plugins that&#8217;ll do the job for you.</p>\n<h2>Why You Should Be Backing Up Your WordPress Site</h2>\n<p>Many times the experts <a href=\"http://wptavern.com/codeguard-survey-shows-more-education-is-needed-on-backup-software-services-and-strategies-for-wordpress\" target=\"_blank\">talk about backing up</a> – how many backups to keep, how often to set automated backups, what tools to use, where to store your backups – but rarely do they delve into <em>why</em> you might need that backup one day. So if WordPress is something new to you – or you just want to brush up your knowledge – here are four reasons why you may need your backup files one day.</p>\n<h3>Hosting Server Problems</h3>\n<p>Many users don&#8217;t spend a great deal of time thinking about the server where their entire WordPress site is hosted. There&#8217;s a good reason for this: servers have built-in failsafes, keep numerous copies of entire drives, hosting services often keep their own backups, and the systems are generally very stable and very secure.</p>\n<p>Still, that doesn&#8217;t mean that a problem couldn&#8217;t come up. Natural disasters and other unpredictable issues could affect the site of your host&#8217;s server. Without proper precautions taken by a hosting service, your shared server could be damaged by code installed by another server user or a hacker. Additionally, not all hosting services are the same – some may offer more robust security than competitors. Others may try to cut corners, affecting users like you.</p>\n<h3>Malicious Hacks and Attacks</h3>\n<p>Successful hacks or cyber attacks that do major damage to businesses are thankfully still uncommon enough that they make news when they happen. However, hacking attempts and unsophisticated attacks are very common and occur frequently.</p>\n<p>Backups won&#8217;t protect you from such hacks and cyber attacks – that&#8217;s what your security plugins are for – but they can help you recover far faster than you otherwise would. Backups can be used to restore a site that had data purposefully deleted or restore a site to a previous version before malicious code was introduced.</p>\n<h3>User Error</h3>\n<p>Yet another good reason to get in the habit of backing up your WordPress site has to do with the person most likely to cause a site problem: you. There are all sorts of ways the average user could cause a problem.</p>\n<p><b>You could get locked out of your site login.</b> It&#8217;s as simple as using the wrong password with the user login. There are usually better solutions to get back into your site than restoring from a backup, but not always.</p>\n<p><b>You could delete a crucial file or make an edit that breaks the site.</b> In some ways your WordPress site is like a house of cards – one missing piece or broken function could affect other parts of the site that rely on that code. It&#8217;s possible to fix the problem you&#8217;ve created if you know what&#8217;s wrong, but it may be simpler and faster to restore to a backup, especially if you made one right before working on the site (as you should).</p>\n<h3>Plugin or Theme Problems</h3>\n<p>Plugins and themes have also been known to cause major problems on rare occasion. Two perfectly good plugins could have a bad interaction if introduced into the same site. This may be especially true if you&#8217;re using plugins not found in the repository. You could simply delete the offending file through an FTP client, but if you&#8217;ve installed several new plugins and you&#8217;re not sure where the problem lies, a backup could be the easier choice.</p>\n<p>Lastly, many developers may feel confident solving all the typical user problems I&#8217;ve just described without resorting to a backup, but developers should ask themselves what their clients would do.</p>\n<p>A client may have trouble following a technical troubleshooting procedure. Clients have also been known to have difficulty explaining what&#8217;s not working. If you&#8217;re a developer who&#8217;s providing a service plan and has instituted frequent automatic backups, you may find it easier to restore the client&#8217;s site from a backup than try to deduce what exactly went wrong.</p>\n<h2>How You Should Be Backing Up Your WordPress Site</h2>\n<p>Before we get into the tools available to help you make and keep your backups, let&#8217;s discuss some tips on how to get the best use out of a backup tool.</p>\n<p>Many plugins offer the ability to automate your backup process. Use this feature. If you do want to do manual backups without a plugin, there are detailed instructions over on the <a href=\"http://codex.wordpress.org/WordPress_Backups#Database_Backup_Instructions\" target=\"_blank\">WordPress Codex</a>. However, you won&#8217;t always know when you need a backup and if you get out of the habit of manually making backups, a plugin won&#8217;t be able save your lost data.</p>\n<p>Beyond regular backups performed by your tool of choice, get in the habit of making a quick manual backup before you do any major work to your site – new plugins, plugin updates, core updates, etc. You won&#8217;t need the codex directions for these backups once you have a backup plugin installed as most have one click manual backups.</p>\n<p>For automatic scheduling, you&#8217;ll have to choose what works best for you. If you only post one blog update per week, you don&#8217;t need daily updates. If you post dozens of pieces of content each week, you may look into your real-time backup options.</p>\n<p>Save the right number of backups. At minimum, you should save your two most recent backups. Keep more if space allows. As you&#8217;ll see below, one plugin option keeps 30 days of backups for you. However, don&#8217;t keep every backup you&#8217;ve ever made – only keep the most recent backups.</p>\n<p>Don&#8217;t store your backups on your server. Download them, email them to yourself, or use a cloud storage solution. If your server fails, your backup to a folder on that server won&#8217;t help you get your site back up and running.</p>\n<p>Now that we&#8217;ve got those guidelines covered, let&#8217;s look at some plugins.</p>\n<h2>Backup Plugins Options</h2>\n<p>There are any number of plugins to backup your site in whole or in part. I&#8217;m going to focus on the most comprehensive options – ones that back up not just the database, but your media as well. These options also allow you to set an automatic backup schedule that works for your content schedule and have good options for where to store those WordPress backups.</p>\n<h3>BackupBuddy</h3>\n<p><img class=\"aligncenter wp-image-1498 size-full\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/Backup-Buddy-Screenshot.png\" alt=\"Backup Buddy Screenshot\" width=\"726\" height=\"380\" /></p>\n<p><a href=\"https://ithemes.com/purchase/backupbuddy/\" target=\"_blank\">BackupBuddy</a> is made by iThemes, a plugin developer probably best known for their <a href=\"https://wordpress.org/plugins/better-wp-security/\" target=\"_blank\">iThemes Security plugin</a>. This backup plugin is a premium solution with all the bells and whistles.</p>\n<p>It offers numerous places to store your backups, including Dropbox, Amazon S3, Rackspace Cloud, Google Drive, FTP, email, and even their own integrated cloud storage service called Stash. Users can make full backups of everything, or pick and choose which files or tables to exclude. Backups can be scheduled daily, weekly, or monthly.</p>\n<p>A blogger license for use on two sites will set you back $80 per year, while an unlimited gold license is a good option for developers at a one-time cost of $297. Yes, it does cost money, but so did the time you put into your site, as well as perhaps other premium themes or plugins you&#8217;ve installed.</p>\n<h3>BackUpWordPress</h3>\n<p><img class=\"aligncenter size-full wp-image-1499\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/BackupWordPress-Screenshot.png\" alt=\"BackupWordPress Screenshot\" width=\"690\" height=\"329\" /></p>\n<p><a href=\"https://wordpress.org/plugins/backupwordpress/\" target=\"_blank\">BackUpWordPress</a> features the ability to manage multiple schedules and use <i>zip</i> or <i>mysqldump</i> formats for faster backups. A free version is available that allows users store their backups on their server – not particularly helpful if your server goes out – or email the backup file.</p>\n<p>A <a href=\"https://bwp.hmn.md/\" target=\"_blank\">premium extension</a> opens up access to all the usual cloud storage options, Google Drive, Dropbox, Amazon S3, and Rackspace Cloud, as well as Dreamhost DreamObjects and Microsoft Azure. FTP and sFTP are also premium options for this plugin.</p>\n<p>Each single premium backup option costs $24 per site, while a developer license allows all storage location options and a year of updates for unlimited WordPress sites for $99.</p>\n<h3>BackWPup</h3>\n<p><img class=\"aligncenter size-full wp-image-1500\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/BackWPup-Screenshot.png\" alt=\"BackWPup Screenshot\" width=\"690\" height=\"360\" /></p>\n<p><a href=\"https://wordpress.org/plugins/backwpup/\" target=\"_blank\">BackWPup</a> is a free option that ticks many of the boxes that most users are looking for. File and database backups are supported. A wide range of cloud storage options are available. A variety of backup schedules can be set depending on the amount of activity on your site. Notably missing from the free version is backup to Google Drive, while some other storage options require the use of cURL, likely beyond the abilities of a developer&#8217;s typical client.</p>\n<p>A <a href=\"https://marketpress.com/product/backwpup-pro/\" target=\"_blank\">premium version</a> starts at $75 for a year&#8217;s worth of support and updates to one site. The premium version adds a number of additional features that make backups easier for novices as well as access to premium support and documentation.</p>\n<h3>VaultPress</h3>\n<p><img class=\"aligncenter size-full wp-image-1501\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/VaultPress-Screenshot.png\" alt=\"VaultPress Screenshot\" width=\"686\" height=\"337\" /></p>\n<p><a href=\"https://vaultpress.com/\" target=\"_blank\">VaultPress</a> is a very well-regarded backup solution, thanks in no small part to its creators, Automattic, the same team behind WordPress itself. One of its best features is the ability to make daily backups automatically and save 30 days worth of those backups. The interface is impeccably designed and restores are only a click away.</p>\n<p>VaultPress is unlike other plugins on this list because it functions as a <a href=\"https://vaultpress.com/plans/\" target=\"_blank\">monthly subscription service</a>. The most basic plan starts at $5 per month, while a backup and security bundle totals $29 per month. Some plans offer real-time backups instead of just daily backups, which may be a good option for some very active sites.</p>\n<h3>UpdraftPlus</h3>\n<p><img class=\"aligncenter size-full wp-image-1502\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/UpdraftPlus-Screenshot.png\" alt=\"UpdraftPlus Screenshot\" width=\"688\" height=\"362\" /></p>\n<p><a href=\"https://wordpress.org/plugins/updraftplus/\" target=\"_blank\">UpdraftPlus</a> offers a free version that again checks most of the boxes. Automatic backup scheduling, database and file backup, integration with a wide variety of cloud storage options, quick restore functionality, even encrypted backups.</p>\n<p>An <a href=\"https://updraftplus.com/shop/\" target=\"_blank\">add-on shop</a> offers a number of extensions, such as support for multiple backup locations and enhanced options for Rackspace Cloud, Amazon S3, Google Drive, and Dropbox. Individual add-ons average $10 to $30, while packages start at $70.</p>\n<h2>Wrapping Up</h2>\n<p>Remember that backing up your new site is a must. Make a backup plugin one of the first add-ons to any new site you launch, either for yourself or for your clients. Make sure you&#8217;re following good backup best practices, like backing up to a location off your site&#8217;s server, setting an automatic backup schedule, and creating a backup before making changes or updates to your site.</p>\n<p>When choosing a backup plugin, look for one that has the options you need at a price you can handle. You don&#8217;t have to go with the most expensive option, but any money you do spend on a premium plugin will be appreciated when you need that last backup.</p>\n<p><strong>What&#8217;s your favorite backup plugin? Where do you like to store your backups – in the cloud or on your own machine? Let us know in the comments.</strong></p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/backing-up-site-before-launch/\">Why (And How) You Should Start Backing Up Your Site Before Launch</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://www.seedprod.com/backing-up-site-before-launch/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"10 Security Steps You Should Take Before Launching Your WordPress Site\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://www.seedprod.com/security-before-launching-wordpress-site/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://www.seedprod.com/security-before-launching-wordpress-site/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Jun 2015 14:00:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://www.seedprod.com/?p=1467\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:602:\"<p>There&#8217;s a lot to think about when you&#8217;re about to launch your WordPress site, but it&#8217;s important not to neglect taking the proper security steps. Site security can be one of those things you don&#8217;t realize you need until you have a problem, but by then it may be too late. Prepare to succeed with [&#8230;]</p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/security-before-launching-wordpress-site/\">10 Security Steps You Should Take Before Launching Your WordPress Site</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Tom Ewer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10810:\"<p>There&#8217;s a lot to think about when you&#8217;re about to launch your WordPress site, but it&#8217;s important not to neglect taking the proper security steps. Site security can be one of those things you don&#8217;t realize you need until you have a problem, but by then it may be too late.</p>\n<p>Prepare to succeed with your new site by taking the proper steps upfront. In this post, we&#8217;ll look at ten security steps that will get you off on the right foot with your new site.</p>\n<h2>1. Keep WordPress Updated</h2>\n<p>The first line of protection for your site is to keep everything updated. This includes not only using the most current version of WordPress, but also keeping plugins and themes up to date as well.</p>\n<p>Updating is important because often the reason for the update is a security patch for known issues. If you&#8217;re using the most recent version of the software, you&#8217;re better protected than other WordPress users who aren&#8217;t.</p>\n<p>Beyond just important security features though, updates also mean you can take advantage of new features and options. So before you launch, make sure all your software is updated and plan to keep it that way. If you&#8217;re passing your site build off to a client, make sure their team is aware of the importance of updates and knows how to apply new updates as they&#8217;re released.</p>\n<h2>2. Be Choosy with Themes and Plugins</h2>\n<p>Beyond keeping your theme and plugins up-to-date, don&#8217;t install &#8220;sketchy&#8221; plugins of questionable origin. On a rare occasion, plugins from less reputable sites may contain easily exploitable code or just downright malicious content.</p>\n<p><img class=\"aligncenter size-full wp-image-1469\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/WP-Org-Menu-Themes-and-Plugins-.png\" alt=\"WP Org Menu Themes and Plugins\" width=\"614\" height=\"97\" /></p>\n<p>Plugins and themes listed in the <a href=\"https://wordpress.org/themes/\" target=\"_blank\">WordPress Theme Directory</a> and <a href=\"https://wordpress.org/plugins/\" target=\"_blank\">Plugin Directory</a> with higher numbers of users, up-to-date versions, and good reviews are the most safe. Third party premium plugins from major developers that aren&#8217;t listed in WordPress are also generally safe, as long as the site is high quality, has up-to-date plugins, and good reviews and/or feedback from users.</p>\n<h2></h2>\n<h2>3. Create Strong Passwords</h2>\n<p>Web-wise readers out there may be shaking their heads right now for my mention of this, but realistically there are still many users who <a href=\"http://gizmodo.com/the-25-most-popular-passwords-of-2014-were-all-doomed-1680596951\" target=\"_blank\">don&#8217;t use strong passwords</a>. A surprising number of users will still use &#8220;123456&#8221; or &#8220;password&#8221;. Even &#8220;p@ssw0rd&#8221; isn&#8217;t much better at fooling sophisticated hacks.</p>\n<p>Fortunately, creating a strong password doesn&#8217;t have to be difficult. My tool of choice is <a href=\"https://strongpasswordgenerator.com/\" target=\"_blank\">Strong Password Generator</a>, with which you can create a password chock full of random letters, numbers and symbols – the perfect combination for a near-unbreakable password.</p>\n<h2>4. Limit Admin Access</h2>\n<p>The initial setup and launch of your site is actually the perfect time to think about who will have access to the admin area of your site, because few people your team are likely to need access to your site&#8217;s admin area. For those that <em>do</em>, take advantage of the available <a href=\"https://codex.wordpress.org/Roles_and_Capabilities\" target=\"_blank\">Roles and Capabilities</a>. WordPress offers a number of access levels, from subscriber all the way up to multisite super admins.</p>\n<p>Your developer, site manager, and other similar roles will need full access. But consider contributor, author or editor roles for team members that will just be creating, editing and updating content.</p>\n<h2>5. Limit Login Attempts</h2>\n<p>The more chances a hacker gets to attempt a brute force break-in, the more likely they are to succeed. However, a simple plugin can limit the number of login attempts from a specific IP address before locking it out.</p>\n<p>The <a href=\"https://wordpress.org/plugins/limit-login-attempts/\" target=\"_blank\">Limit Login Attempts</a> plugin is my solution of choice. The plugin hasn&#8217;t been updated in a couple years – which isn&#8217;t ideal – but it has more than a million active users, a number of five-star reviews, and recommendations from many WordPress blogs. That makes it a safe bet, and a good way to get your site protected before launch.</p>\n<h2>6. Use a Different Username for Display</h2>\n<p><img class=\"aligncenter size-full wp-image-1470\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/Not-admin-login-screen.png\" alt=\"Not admin login screen\" width=\"468\" height=\"467\" /></p>\n<p>Speaking of brute force logins, avoid using your actual username within your site. If you have your username on your site, you&#8217;re give hackers one-half of the information they need on your login page. Instead, head over to your <a href=\"https://codex.wordpress.org/Users_Your_Profile_Screen\" target=\"_blank\">profile page in the admin area</a> and set a display name that differs from the username you use to log in.</p>\n<h2>7. Hide Your Login Page</h2>\n<p><img class=\"aligncenter size-full wp-image-1471\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/Move-Login-Plugin.png\" alt=\"Move Login Plugin\" width=\"687\" height=\"338\" /></p>\n<p>This is one of my favorite security ideas, because it&#8217;s so simple but can make such a big difference. Nearly all WordPress admin login pages can be reached by either <em>mysite.com/wp-admin</em> or <em>mysite.com/wp-login</em>. However, <a href=\"https://wordpress.org/plugins/sf-move-login/\" target=\"_blank\">Move Login</a> is a simple plugin that lets you customize the URL for your login page. Do this, and you&#8217;ll be far and away much more secure once you launch.</p>\n<h2>8. Hide Your WordPress Version Number</h2>\n<p>Yet another simple but effective security precaution that can be implemented in a few clicks. Hiding your site&#8217;s WordPress version number adds another layer of security, by making it harder for hackers to know which kinds of vulnerabilities they could try to exploit.</p>\n<p><img class=\"aligncenter size-full wp-image-1472\" src=\"https://www.seedprod.com/wp-content/uploads/2015/06/Remove-Version-Plugin.png\" alt=\"Remove Version Plugin\" width=\"688\" height=\"359\" /></p>\n<p>Your version number can be hidden with a <a href=\"http://www.wpbeginner.com/wp-tutorials/the-right-way-to-remove-wordpress-version-number/\" target=\"_blank\">simple bit of code</a>, although there are also plugins like <a href=\"https://wordpress.org/plugins/remove-version-remver/\" target=\"_blank\">Remove Version</a> available.</p>\n<p>This tip is most helpful if you don&#8217;t use the most current version of WordPress, but I would of course recommend that you keep WordPress updated at all times!</p>\n<h2>9. Make and Keep Regular Backups</h2>\n<p>Backups enable you get your site back to how it was before you installed a bad plugin, before a hacker installed malicious code, or before someone broke your site – assuming you&#8217;ve kept your backups, that is.</p>\n<p>Set up a regular off-site backup with plugins like <a href=\"https://vaultpress.com/\" target=\"_blank\">VaultPress</a> or <a href=\"https://updraftplus.com/\" target=\"_blank\">UpdraftPlus</a>, and if you ever do have a problem, you&#8217;ll be able to recover quickly.</p>\n<p>Most backup plugins and services have either an upfront or recurring cost. Most will allow you to send your backups to a Google Drive, Dropbox, or other cloud storage location. Some can do real-time backups, while others rely on custom scheduling. For more info on your options, check out <a href=\"http://www.wpbeginner.com/plugins/7-best-wordpress-backup-plugins-compared-pros-and-cons/\" target=\"_blank\">this post over at WPBeginner</a>.</p>\n<h2>10. Use a Security Plugin</h2>\n<p>A security plugin differs from all these individual precautions because it tracks attempts to hack into your site. Statistics can be a useful tool when deciding on other factors for your site. If you see many blocked attempts, your site may be more of a target and you should take extra precautions you previously thought you could do without. Purchasing a premium plugin or forking out $5 per month for a service like VaultPress will be easier to justify when you see the benefits.</p>\n<p>Good security plugins to get your site ready for launch include:</p>\n<ul>\n<li><a href=\"https://wordpress.org/plugins/wordfence/\" target=\"_blank\">Wordfence</a></li>\n<li><a href=\"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/\" target=\"_blank\">All in One WP Security and Firewall</a></li>\n</ul>\n<h2>Even More Security Steps</h2>\n<p>The above security measures should keep most new sites safe from hackers and malicious code, but some users may want to do more. You could for example:</p>\n<ol>\n<li><a href=\"http://www.wpbeginner.com/wp-tutorials/disable-directory-browsing-wordpress/\" target=\"_blank\">Turn off directory browsing</a></li>\n<li><a href=\"https://www.acunetix.com/blog/articles/wordpress-security-tips-part-6-disable-file-editing/\" target=\"_blank\">Disable file editing</a></li>\n<li><a href=\"http://www.wpbeginner.com/wp-tutorials/how-to-add-ssl-and-https-in-wordpress/\" target=\"_blank\">Enable HTTPS for specific pages</a></li>\n</ol>\n<p>The next line of security (beyond the basics above) is more complex, so casual users and business owners should arguably let a developer handle these steps. But for a site that deals with user information for a large member database, e-commerce, or other high-target sites, these added security measures are well worth considering.</p>\n<h2>Wrapping Up</h2>\n<p>With these ten steps, your new WordPress site will be safe and secure when you&#8217;re ready to launch. As you can see there&#8217;s a range of options, from very simple fixes to more complex precautions, and some have a cost you&#8217;ll need to consider.</p>\n<p>Regardless of how you do so, make sure you implement strong security for your site – even before it is live. This will make the launch and running of your site more fun and hassle free.</p>\n<p><strong>Have your own must-do security tips for new sites? Let us know what we missed in the comments below! </strong></p>\n<p>The post <a rel=\"nofollow\" href=\"https://www.seedprod.com/security-before-launching-wordpress-site/\">10 Security Steps You Should Take Before Launching Your WordPress Site</a> appeared first on <a rel=\"nofollow\" href=\"https://www.seedprod.com\">SeedProd</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://www.seedprod.com/security-before-launching-wordpress-site/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:30:\"https://www.seedprod.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:15:{s:6:\"server\";s:16:\"cloudflare-nginx\";s:4:\"date\";s:29:\"Thu, 13 Aug 2015 21:48:40 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:10:\"set-cookie\";s:44:\"PHPSESSID=8d3mrtqr1jbej2dhhfnk2k8ql6; path=/\";s:7:\"expires\";s:29:\"Thu, 19 Nov 1981 08:52:00 GMT\";s:13:\"cache-control\";s:62:\"no-store, no-cache, must-revalidate, post-check=0, pre-check=0\";s:6:\"pragma\";s:8:\"no-cache\";s:15:\"x-cf-powered-by\";s:15:\"WP Rocket 2.6.6\";s:10:\"x-pingback\";s:35:\"https://www.seedprod.com/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Thu, 13 Aug 2015 19:15:30 GMT\";s:4:\"etag\";s:36:\"W/\"f1e4cdd6ce2134fc98955d68e89fc0c4\"\";s:12:\"x-robots-tag\";s:15:\"noindex, follow\";s:6:\"cf-ray\";s:20:\"2157a018171104d4-SYD\";s:16:\"content-encoding\";s:4:\"gzip\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("12050","_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109","1440006336","no");
INSERT INTO wp_options VALUES("12051","_transient_feed_b9388c83948825c1edaef0d856b7b109","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Aug 2015 05:21:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Your WordPress, Streamlined.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"363@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5790@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 13 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"9542@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"6743@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12073@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2646@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Protect your WordPress site by hiding vital areas of your site, protecting access to important files, preventing brute-force login attempts, detecting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"49521@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Google Analytics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/googleanalytics/#post-11199\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Jun 2009 22:09:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"11199@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Enables google analytics on all pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Kevin Sylvestre\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WP-DB-Backup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/wp-db-backup/#post-472\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 Mar 2007 04:41:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"472@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"On-demand backup of your WordPress database.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"ringmaster\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 19 Aug 2015 05:45:36 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Wed, 19 Aug 2015 05:56:23 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Wed, 19 Aug 2015 05:21:23 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("12054","_transient_timeout_plugin_slugs","1440049536","no");
INSERT INTO wp_options VALUES("12055","_transient_plugin_slugs","a:6:{i:0;s:39:\"custom-login-page/custom-login-page.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:3;s:55:\"ultimate-maintenance-mode/ultimate-maintenance-mode.php\";i:4;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:5;s:27:\"wp-super-cache/wp-cache.php\";}","no");
INSERT INTO wp_options VALUES("12060","_transient_timeout_feed_mod_a41fbee65e190c85018f9081fcc3dfc4","1440006346","no");
INSERT INTO wp_options VALUES("12061","_transient_feed_mod_a41fbee65e190c85018f9081fcc3dfc4","1439963146","no");
INSERT INTO wp_options VALUES("12058","_transient_timeout_feed_a41fbee65e190c85018f9081fcc3dfc4","1440006346","no");
INSERT INTO wp_options VALUES("12059","_transient_feed_a41fbee65e190c85018f9081fcc3dfc4","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress Training » News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://members.wpacademy.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Aug 2015 14:51:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Up to 98% Savings on Courses: Web Design, Business Development, SEO, Mobile App Development, and More\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"http://members.wpacademy.com/2015/05/up-to-98-savings-on-courses-web-design-business-development-seo-mobile-app-development-and-more/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"http://members.wpacademy.com/2015/05/up-to-98-savings-on-courses-web-design-business-development-seo-mobile-app-development-and-more/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 20 May 2015 15:04:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=20083\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:662:\"<p>Great news!&#160; Through a privileged relationship we have with online course provider Edurila, we are able to offer you some of the best online courses in the world at up to 98% savings – to a maximum price of just $10 each.&#160; Offer Valid for next 1 week only, So Grab your Copies Now. Click [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2015/05/up-to-98-savings-on-courses-web-design-business-development-seo-mobile-app-development-and-more/\">Up to 98% Savings on Courses: Web Design, Business Development, SEO, Mobile App Development, and More</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4466:\"<p></p><p><em><strong>Great news!</strong></em>&#160; Through a privileged relationship we have with online course provider Edurila, we are able to offer you some of the best online courses in the world at up to 98% savings – to a maximum price of just $10 each.&#160; </p>\n<p><em><strong>Offer Valid for next 1 week </strong></em>only, So <em><strong>Grab your Copies Now.</strong></em></p>\n<p>Click On the Link below to Buy the Course for $10 Only or just use coupon “Marc10″ while checking out.</p>\n<ul>\n<li><strong>Complete Money Making Course Bundle – Learn Youtube Secrets, Blogging, Website Making, Affiliate Marketing, Facebook Advertisement Secrets &amp; More</strong> worth <del>$499</del>&#160; for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/money-making-courses?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Running A Web Design Business</strong> worth <del>$99</del> for <strong><em>$10 only</em></strong> – <a href=\"https://edurila.com/courses/running-a-web-design-business?&amp;coupon_code=MARC10\">Purchase here</a></li>\n<li><strong>Learn to Speak: Conversational French – Full Course</strong> worth <del>$99</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/learnfrench?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Responsive Web Design Course Bundle</strong> worth <del>$249</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/responsive-web-design-course-bundle?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Complete Web Developer Course: How To Build Websites &amp; Make Money</strong> worth <del>$299</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/practical-web-development?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Create a Native App for your WordPress Business Website in 8 days – No Coding!</strong> worth <del>$99</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/create-app-for-your-wordpress-website?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>How I Make Awesome Passive Income Every Month for Free!</strong> worth <del>$199</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/makemoneyonline?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Build Your Brand: Blogging, SEO, Social Media &amp; Relationships</strong> worth <del>$79</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/blogging-seo-social-relationships-total-web-marketing?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Responsive Web Design AND Web Development with HTML5 &amp; CSS3</strong> worth <del>$49</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/design-and-develop-a-killer-website-with-html5-and-css3?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>The Complete Apple Watch Developer Course – Build 15 apps</strong> worth <del>$299</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/complete-apple-watch-developer-course-build-15-apps?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Photoshop: Real World Hands-on Graphic and Web Design</strong> worth <del>$99</del> for<em> <strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/photoshop-real-world-hands-on-graphic-and-web-design?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Youtube Secrets For Earning $2K Monthly Income – No Experience Required</strong> worth <del>$499</del> for <em><strong>$10 only</strong></em> – <a href=\"https://edurila.com/courses/youtube-secrets-for-earning-high-incomes?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n</ul>\n<p><em><strong>Hurry Up! Grab these courses for just $10 before they get back to their full price again.</strong>      <br /></em></p>\n<p><em><strong>Share this offer</strong> on<strong> </strong>Twitter, Facebook and to your websites, And help your friends and family to learn a new skill from the Experts.</em></p>\n<p>The post <a href=\"http://members.wpacademy.com/2015/05/up-to-98-savings-on-courses-web-design-business-development-seo-mobile-app-development-and-more/\">Up to 98% Savings on Courses: Web Design, Business Development, SEO, Mobile App Development, and More</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"http://members.wpacademy.com/2015/05/up-to-98-savings-on-courses-web-design-business-development-seo-mobile-app-development-and-more/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Three steps towards a true lifestyle business (free training by Natalie Sisson)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"http://members.wpacademy.com/2015/04/three-steps-towards-a-true-lifestyle-business-free-training-by-natalie-sisson/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"http://members.wpacademy.com/2015/04/three-steps-towards-a-true-lifestyle-business-free-training-by-natalie-sisson/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Apr 2015 15:52:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=20059\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:659:\"<p>As some of you know, last summer I officially became a “digital nomad”.&#160;&#160; This means that I took WP Academy on the road, and have been traveling, learning, growing and making new friends.&#160; I even wrote a book!&#160; While continuing to invest and grow my business (in fact, a lot was accomplished last year, including [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2015/04/three-steps-towards-a-true-lifestyle-business-free-training-by-natalie-sisson/\">Three steps towards a true lifestyle business (free training by Natalie Sisson)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2287:\"<p></p><p>As some of you know, last summer I officially became a “digital nomad”.&#160;&#160; This means that I took WP Academy on the road, and have been traveling, learning, growing and making new friends.&#160; I even wrote a book!&#160; While continuing to invest and grow my business (in fact, a lot was accomplished last year, including big upgrades in our <a href=\"http://wpacademy.com/hosting\">Managed WordPress Hosting</a>).</p>\n<p>If this lifestyle interests you, you will be very interested to know that Natalie Sisson, the “Suitcase Entrepreneur”, has opened up her program again.&#160; Natalie is the original “digital nomad” (much more hard-core than me, actually), having built her perfect lifestyle business while traveling the world, earning 6-figures and going on crazy cool adventures.&#160; Get the details here of the FREE TRAINING she is giving leading up to the offer: </p>\n<p>=&gt;&gt; <a href=\"https://kk125.isrefer.com/go/TFP/mbeneteau\">3 Steps to Creating Your Freedom Plan</a> &lt;==</p>\n<p><em></em></p>\n<p>I have great respect for Natalie, based on her knowledge, professionalism and sincerity in what she does.&#160; Hundreds of “lifestyle entrepreneurs” have attended her programs already.&#160; I dare say that nobody teaches this as well as she does – even some programs that cost 3-4 times as much.&#160; And the support community is outstanding.&#160; </p>\n<p>TODAY she’s celebrating 5 years in business with a fantastic 3-part video training series teaching you the steps to do this yourself. She’s going to share:</p>\n<p><em></em></p>\n<ul>\n<li>\n<p>3 Steps to Creating Your Freedom Plan</p>\n</li>\n<li>\n<p>10 Must-Have Traits of Every Successful Lifestyle Entrepreneur</p>\n</li>\n<li>\n<p>The Proven Process to Making Your Ideal Lifestyle Business a Reality</p>\n</li>\n</ul>\n<p><em></em></p>\n<p>=&gt;&gt; <a href=\"https://kk125.isrefer.com/go/TFP/mbeneteau\">Create Your Perfect Lifestyle Business right here</a> &lt;&lt;=</p>\n<p>The post <a href=\"http://members.wpacademy.com/2015/04/three-steps-towards-a-true-lifestyle-business-free-training-by-natalie-sisson/\">Three steps towards a true lifestyle business (free training by Natalie Sisson)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"http://members.wpacademy.com/2015/04/three-steps-towards-a-true-lifestyle-business-free-training-by-natalie-sisson/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Managed WordPress Hosting from $8.40/mth\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"http://members.wpacademy.com/2015/02/managed-wordpress-hosting-from-8-40mth/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://members.wpacademy.com/2015/02/managed-wordpress-hosting-from-8-40mth/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Feb 2015 11:13:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=20017\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:615:\"<p>If you are interested in secure, high-performance Managed WordPress Hosting at 30% of the going rate, then read on.&#160; 2014 was a very difficult year for the hosting business Many large conventional hosting companies (Hostgator, Bluehost, Dreamhost) experienced long downtimes exceeding 12 hours last year, and we have seen large performance degradation as well, with [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2015/02/managed-wordpress-hosting-from-8-40mth/\">Managed WordPress Hosting from $8.40/mth</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4641:\"<p></p><p>If you are interested in secure, high-performance Managed WordPress Hosting at 30% of the going rate, then read on.&#160; </p>\n<h2>2014 was a very difficult year for the hosting business</h2>\n<p>Many large conventional hosting companies (Hostgator, Bluehost, Dreamhost) experienced long downtimes exceeding 12 hours last year, and we have seen large performance degradation as well, with page load times often exceeding 5 seconds.&#160; Many studies have shown the critical importance of page load time for visitor retention.&#160; Added to these facts are ongoing concerns about WordPress hacking&#160; on the non-managed WordPress hosting companies.&#160; <strong>As a result, many of us have been looking for hosting upgrades</strong>.</p>\n<p>Late last year we completed a major upgrade to high-performance (SSD-backed) servers.&#160; Our customers are seeing page load times of&#160; 0.1 to 0.2 seconds on their home page html (1 to 2 seconds for the entire site).&#160; This is backed by our personalized support, which covers many issues that conventional (non-managed) hosting companies won’t touch.&#160; Best of all, we can now offer this service for about a third of what most managed WordPress hosting companies charge.&#160; For the first time, you can have managed WordPress hosting at prices comparable to conventional hosting.&#160; </p>\n<p>This video shows you how.&#160; It will also show you how to use a tool called Pingdom to measure your current hosts’ performance (do the test yourself, it will only take a 1 minute): </p>\n<p><a href=\"http://wpacademy.com/hosting\"><img title=\"image\" style=\"border-top: 0px; border-right: 0px; background-image: none; border-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; display: inline; padding-right: 0px\" border=\"0\" alt=\"image\" src=\"http://members.wpacademy.com/wp-content/uploads/2015/02/image1.png\" width=\"244\" height=\"141\" /></a></p>\n<h2>How can we afford to do this? </h2>\n<p>How can we afford to do this, when most managed WordPress hosting companies charge upwards of $24/mth <u>per domain</u>? (WP Academy hosting offers unlimited domains, although only 5 managed sites).&#160; It’s simple really: rather than creating a complex (and expensive) hosting infrastructure, we manage your site’s security and performance using off-the-shelf components (cPanel, Backup Buddy, Cloudflare, W3 Total Cache, etc).&#160; And we invest the savings into renting lightly-loaded, SSD-backed servers, delivering enterprise-grade performance to your website at an amazing value.&#160; </p>\n<h2>February hosting sale – ends February 28</h2>\n<p>Throughout all of February, you can get 20% off our already very affordable managed hosting by using coupon FEBRUARY.&#160; The cost can be as low as $8.40/mth for a 3-year prepay.&#160; Simply go to this link: </p>\n<p><a href=\"http://wpacademy.com/hosting\">http://wpacademy.com/hosting</a></p>\n<p>Review the offer, and apply coupon FEBRUARY at checkout.&#160; </p>\n<p>If you have any questions or feedback, simply respond to this email.&#160; I am personally supporting this </p>\n<h2>Just a few client testimonials…</h2>\n<blockquote><p>“I have had Subrato helping me out with issues I have had on my site. This has resulted in the end of such frustration going on for too long.&#160; I am so grateful to you and your staff for being who you are and created this fantastic support for us all.” — Lucinda P., Ontario, Canada</p>\n</blockquote>\n<blockquote><p>“Excellent, prompt service. My website is fast and my issues are never server related. The support for simple theme and plugins is invaluable” — Melissa B., Stuart, Florida</p>\n</blockquote>\n<blockquote><p>“Marc, as you must know, you have been pivotal in helping me create my dream of website independence… Your family and support staff are the best” — Merry M., Liberty, Texas</p>\n</blockquote>\n<blockquote><p>“I want to thank you for your service hosting HeartAndSoulMatters.com. Creating my site was about as far as I could go and I’m confident that WP Academy will continue to do the maintenance that is beyond my technical savvy…” — Rev. Janice R.,&#160; Briarcliff Manor, New York</p>\n</blockquote>\n<p>Best wishes,</p>\n<p><img src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" /></p>\n<p>Marc Beneteau   <br />”Your Small-Biz Web Technology Mentor” </p>\n<p>The post <a href=\"http://members.wpacademy.com/2015/02/managed-wordpress-hosting-from-8-40mth/\">Managed WordPress Hosting from $8.40/mth</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://members.wpacademy.com/2015/02/managed-wordpress-hosting-from-8-40mth/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Learn Web Development and iOS Swift – 85% discount!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://members.wpacademy.com/2014/11/learn-web-development-and-ios-85-discount/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://members.wpacademy.com/2014/11/learn-web-development-and-ios-85-discount/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 29 Nov 2014 04:57:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19965\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:593:\"<p>Did you miss the Udemy Black Friday deals? Well cheer up, because it&#8217;s not too late for deep, deep discounts on two of the world&#8217;s most popular Web Development &#38; iOS Development courses! The Complete Web Developer Course – Just $29 (75k Copies Sold) Web development from scratch in 6 weeks. HTML, JS, CSS, PHP, [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/11/learn-web-development-and-ios-85-discount/\">Learn Web Development and iOS Swift &#8211; 85% discount!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5149:\"<p></p><p style=\"text-align: left;\">Did you miss the Udemy Black Friday deals?</p>\n<p style=\"text-align: left;\"><strong>Well cheer up</strong>, because it&#8217;s not too late for deep, deep discounts on two of the world&#8217;s most popular Web Development &amp; iOS Development courses!</p>\n<hr />\n<h2 style=\"text-align: left;\">The Complete Web Developer Course – Just $29 (75k Copies Sold)</h2>\n<p style=\"text-align: left;\"><strong><a href=\"https://www.udemy.com/complete-web-developer-course/\"><img class=\"alignright size-full wp-image-19966\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/11/complete-web-developer-rob-percival.jpg\" alt=\"complete-web-developer-rob-percival\" width=\"240\" height=\"135\" /></a>Web development from scratch in 6 weeks. HTML, JS, CSS, PHP, MySQL, Bootstrap, WordPress, APIs, Mobile Apps all covered.<br />\n</strong></p>\n<p style=\"text-align: left;\">The Most Popular &amp; Bestselling course “<strong>The Complete Web Developer Course – Build 14 Websites” from Rob Percival</strong> which has sold 43k copies in just 5 months is now available for<strong> 85% off</strong> i.e <strong>for $29 only</strong>! for next<strong> 2 week</strong>s!</p>\n<p style=\"text-align: left;\">Use<em> Coupon Code </em>“marc29“ while checking out at Udemy</p>\n<p style=\"text-align: left;\"><strong>Here is the link to take the course</strong>:- <a href=\"https://www.udemy.com/complete-web-developer-course/\" target=\"_blank\">https://www.udemy.com/<wbr />complete-web-developer-course/</a></p>\n<p style=\"text-align: left;\">This course comes with a<strong> Free 1 year hosting worth $199 </strong>and will teach you to make almost 14 websites.</p>\n<p style=\"text-align: left;\"><strong>This offer will be valid for next 2 weeks only</strong>, so Grab your copies Now before it goes back to full price of $199 <a href=\"https://www.udemy.com/complete-ios-developer-course/\">here</a></p>\n<hr />\n<h2 style=\"text-align: left;\">The Complete iOS Developer Course – Just $29 (30k Copies sold)<strong><br />\n</strong></h2>\n<p><strong><a href=\"https://www.udemy.com/complete-ios-developer-course/\"><img class=\"alignright size-full wp-image-19967\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/11/complete-ios-developer-course-rob-percival.jpg\" alt=\"complete-ios-developer-course-rob-percival\" width=\"240\" height=\"135\" /></a>iOS App Development from scratch in 6 weeks &#8211; build full apps including Instagram and Snapchat Clones. With free Ebook </strong></p>\n<p style=\"text-align: left;\">Get the Most Popular and Amazing<strong> The Complete iOS Developer Course – Build 15 Apps with Swift (No Mac Required!)</strong> for <strong>just $29 </strong>here<strong>:- </strong><a href=\"https://www.udemy.com/complete-web-developer-course/\">https://www.udemy.com/<wbr />complete-ios-developer-course/</a></p>\n<p style=\"text-align: left;\"><em>And Use coupon code</em>:<strong> “marc29″ </strong>while <a href=\"https://www.udemy.com/complete-ios-developer-course/\">checking-out at Udemy</a></p>\n<p style=\"text-align: left;\">Rob Percival asked me to tell you this:</p>\n<p style=\"text-align: left; padding-left: 30px;\"><em>Swift is Apple’s <strong>new language for making iPhone and iPad apps</strong>- it’s a hundred times easier to learn than Objective C, and is a lot like Javascript – great news for all you web developers!</em></p>\n<p style=\"text-align: left; padding-left: 30px;\"><em>Swift is still in beta, and for the first time ever Apple have allowed anyone to download the beta version of Xcode and try out Swift before it’s even released, so you’ll bec<strong>one of the very first people to learn</strong>how to code iOS apps with Swift.</em></p>\n<p style=\"text-align: left; padding-left: 30px;\"><em><strong>Swift is pretty much guaranteed to be the next big thing in app development</strong>, so learn it now and you’ll be at the forefront of the technology, putting you head and shoulders above other app developers.</em></p>\n<p style=\"text-align: left; padding-left: 30px;\"><em>As with the Complete Web Developer Course, I’ll show you absolutely everything you’ll need, including downloading and setting up Xcode, and how to <strong>build 14 fantastic apps with Swift</strong>. And you’ll get another year’s free hosting, so it really is a no-brainer!</em></p>\n<p style=\"text-align: left; padding-left: 30px;\"><em>I’ll also show you how to install OSX on your PC for free, so you <strong>don’t need a Mac to develop iOS apps</strong>!</em></p>\n<p style=\"text-align: left;\"> Happy Coding!</p>\n<p style=\"text-align: left;\">To your success,</p>\n<p style=\"text-align: left;\"><img class=\"alignnone size-full wp-image-19324\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /><br />\nMarc Beneteau<br />\n&#8220;Your Small-Biz Web Technology Mentor&#8221;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/11/learn-web-development-and-ios-85-discount/\">Learn Web Development and iOS Swift &#8211; 85% discount!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://members.wpacademy.com/2014/11/learn-web-development-and-ios-85-discount/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Three fantastic web development courses for up to 95% off!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://members.wpacademy.com/2014/11/three-web-development/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://members.wpacademy.com/2014/11/three-web-development/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Nov 2014 12:52:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19954\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:596:\"<p>Today we have for you, 3 great web development courses from our partners at Edurila.com, with up to 95% off the regular price! Get the bestselling WordPress Ecommerce, Swift Developer Bundle, and Beginner Web Development Bundle Course with discounts up to 95%.  Buy these courses from the links below: WordPress eCommerce with WooCommerce Sale Price [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/11/three-web-development/\">Three fantastic web development courses for up to 95% off!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4191:\"<p></p><p>Today we have for you, 3 great web development courses from our partners at Edurila.com, with up to 95% off the regular price!</p>\n<p>Get the bestselling <strong>WordPress Ecommerce, Swift Developer Bundle, and Beginner Web Development Bundle Course</strong> with discounts up to 95%.  Buy these courses from the links below:</p>\n<h2>WordPress eCommerce with WooCommerce</h2>\n<p>Sale Price – $10 (Normally $17)</p>\n<p>An online course that will give you an understanding of WooCommerce in under 90 minutes.</p>\n<p>Developed by Marc Beneteau, the course offers many professional made guides.</p>\n<p>It features:</p>\n<ul>\n<li><strong>Quick Start Section</strong> – Gives you a basic understanding of WooCommerce by introducing layouts, shortcodes, adding products, PayPal configuration, and more.</li>\n<li><strong>Reference Section</strong> – Advanced product types, configuring tax, coupons, inventory management, product reviews, and more.</li>\n<li><strong>WooCommerce Styling and Programming Section</strong> – creating custom email templates,</li>\n</ul>\n<p>The course normally retails at $17, but you can purchase it for only $10 using the link below. This course is also included in the web development bundle listed later.</p>\n<p><a href=\"https://edurila.com/course/wordpress-ecommerce-with-woocommerce/?couponCode=marc10&amp;affcode=518i\">Purchase here</a></p>\n<h2>Swift Developer Bundle</h2>\n<p>Sale Price – $19 (Normally $446)</p>\n<p>Swift Developer Bundle: Swift is the programming language developed by Apple. The language is used to create applications for their mobile operating system iOS and their desktop operating system OS X.</p>\n<p>The Swift Developer Bundle shows you how to create a fully functional calculator application that you can publish in the apple app store.</p>\n<p>The courses will teach you:</p>\n<ul>\n<li>Initial Setup and Swift Basics</li>\n<li>Operators, Strings, Characters, and Collection Types</li>\n<li>Evolving from Objective C</li>\n<li>Control Flow</li>\n</ul>\n<p>The courses included in the bundle are:</p>\n<ul>\n<li>Swift – Learn Apple’s New Programming Language by Examples (Original Price: $199)</li>\n<li>Hands on Swift Language. Visual way with Light Programming (Original Price: $49)</li>\n<li>Build Web Applications in HTML5 &amp; jQuery – Learn By Making 3 Web Apps (Original Price: $49)</li>\n<li>Make &amp; Publish Your Own iPhone Game Today &amp; Make Money Now (Original Price: $149)</li>\n</ul>\n<p>The bundle normally retails at $446, but you can purchase it for only $19 using the link below.</p>\n<p><a href=\"https://edurila.com/course/Swift-Developer-Bundle/?couponCode=marc19&amp;affcode=518i\">Purchase here</a></p>\n<h2>The Beginner Web Dev Bundle</h2>\n<p>Sale Price – $29 (Normally $638)</p>\n<p>The beginner web development bundle includes <em>nine complete courses!</em>  Each course is jam-packed with tutorials and video guides.</p>\n<p>The package includes the following courses:</p>\n<ul>\n<li>Learn Complete Web Development From Scratch (Original Price: $149)</li>\n<li>Learn Responsive Web Development from Scratch (Original Price: $99)</li>\n<li>Build Web Applications in HTML5 &amp; jQuery – Learn By Making 3 Web Apps (Original Price: $49)</li>\n<li>Make &amp; Publish Your Own iPhone Game Today &amp; Make Money Now (Original Price: $149)</li>\n<li>Become a WordPress Nirvana, WordPress Expert Bundle (Original Price: $99)</li>\n<li>WordPress eCommerce with WooCommerce (Original Price: $17)</li>\n<li>WordPress Theme Selection &amp; Customization (Original Price: $27)</li>\n<li>Basics Of Web Application Penetration Testing (FREE)</li>\n<li>WordPress Tutorial for Beginners (Original Price: $49)</li>\n<li>The bundle normally retails at $638, but you can purchase it for only $29 using the link below.</li>\n</ul>\n<p><a href=\"https://edurila.com/course/the-beginner-web-dev-bundle/?couponCode=Marc29&amp;affcode=518i\">Purchase here</a></p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/11/three-web-development/\">Three fantastic web development courses for up to 95% off!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://members.wpacademy.com/2014/11/three-web-development/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Jeff Walker: Product launches for “newbies”…\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://members.wpacademy.com/2014/11/jeff-walker/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://members.wpacademy.com/2014/11/jeff-walker/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Nov 2014 15:25:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19932\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:571:\"<p>Have you heard of Jeff Walker?  He is an internet marketing legend, having helped thousands of entrepreneurs over the years generate $500 million in product launches (this is money for his clients, not for him!) Well, he has a new series of FREE training videos on what he calls the &#8220;Seed Launch&#8221;&#8230; and how anyone [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/11/jeff-walker/\">Jeff Walker: Product launches for &#8220;newbies&#8221;&#8230;</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1893:\"<p></p><p>Have you heard of Jeff Walker?  He is an internet marketing legend, having helped thousands of entrepreneurs over the years generate <strong>$500 million in product launches</strong> (this is money for his clients, not for him!)</p>\n<p>Well, he has a new series of FREE training videos on what he calls the &#8220;Seed Launch&#8221;&#8230; and how anyone can use it to create an new business from scratch &#8211; starting with NO list and NO product</p>\n<p><strong>&gt;&gt; <a href=\"http://www.productlaunchformula.com/?20059\">Get the videos here</a> &lt;&lt;</strong></p>\n<p>He also reveals how he used &#8220;Launch Stacking&#8221; to go from Mr. Mom (with $400 per year in disposable income) to his first $1,000,000 in sales &#8211; it&#8217;s a crazy story.</p>\n<p>And the amazing thing is this strategy will work with almost ANY type of business.</p>\n<p><strong>&gt;&gt; <a href=\"http://www.productlaunchformula.com/?20059\">Core Elements of the &#8220;No Fail&#8221; launch</a> &lt;&lt;</strong></p>\n<p>These videos are all pure content&#8230; the only &#8220;catch&#8221; is you need to opt-in to get them, but make sure you do &#8211; it&#8217;s totally worth it.</p>\n<p>Watch them soon &#8212; they are only good for the next 6 days.  And they only come out every 12-18 months&#8230; this is the latest and greatest of Jeff&#8217;s revolutionary business model.</p>\n<p>To Your Success,</p>\n<p>Marc Beneteau</p>\n<p><img class=\"alignnone size-full wp-image-19324\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /></p>\n<p>&#8220;Your Small-Biz Web Technology Mentor&#8221;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/11/jeff-walker/\">Jeff Walker: Product launches for &#8220;newbies&#8221;&#8230;</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://members.wpacademy.com/2014/11/jeff-walker/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Christine Kane Free Training: the New Class of Entrepreneur\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Sep 2014 05:50:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19898\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:660:\"<p>In case you missed Christine Kane&#8217;s live webinar last Thursday on the &#8220;new class of entrepreneur&#8221;, you can still get access to the excellent free training videos from here: Discover the success secrets of the &#8220;new class of entrepreneurs&#8221; &#60;&#8211; (After registering and confirming your email address, you will be directed to the landing page, [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/\">Christine Kane Free Training: the New Class of Entrepreneur</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4397:\"<p></p><p>In case you missed Christine Kane&#8217;s live webinar last Thursday on the &#8220;new class of entrepreneur&#8221;, you can still get access to the excellent free training videos from here:</p>\n<p><strong><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">Discover the success secrets of the &#8220;new class of entrepreneurs&#8221;</a> &lt;&#8211;</strong></p>\n<p><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\"><img class=\"alignright size-full wp-image-19899\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/09/7-new-laws-of-gravity.jpg\" alt=\"7-new-laws-of-gravity\" width=\"300\" height=\"403\" /></a>(After registering and confirming your email address, you will be directed to the landing page, and from there you can watch all the videos and also download the free report &#8220;7 New Laws of Gravity&#8221;).</p>\n<h3>But what defines a &#8220;new entrepreneur&#8221;?</h3>\n<p>Here is an extract from the third video (you can get the full video <a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">here</a>, including the interviews).  The &#8220;new entrepreneurs&#8221; are:</p>\n<p><em>First</em>, they are <em>relentlessly</em> self-aware</p>\n<p>They know themselves and how to manage their power</p>\n<p>They &#8220;right&#8221; their mindset when it&#8217;s needed</p>\n<p>They are no longer burdened by the emotional stories they tell themselves, and this removes struggle and it creates effortlessness in their work</p>\n<p><em>Second</em>, the new class of entrepreneurs are REAL.. they are a refreshing force field in their industries.</p>\n<p><em>Third</em>, they are IN.  they know how to be fully in relationshiop with their business, their money and their clients.  They use fear as a tool for expansion.  And they use their full presence as a powerful tool for breakthroughs that need to happen.</p>\n<p>And last, they are wildly successful.  They are pioneers.  They are &#8220;defying gravity&#8221;.</p>\n<p>mm&#8230; you are probably thinking:</p>\n<h3>Marc, I have heard this type of &#8220;woo-woo&#8221; talk before.  It doesn&#8217;t work.</h3>\n<p>Maybe.  Maybe you have heard things that sound &#8220;similar&#8221;.  But take it from me, this is the &#8220;real deal&#8221;.</p>\n<p>I have sent so many people to Christine Kane to create new passion businesses, or to double and triple existing businesses, I can&#8217;t tell you.  I suggest you put aside some time today and watch these videos:</p>\n<p><strong><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">Find out how some entrepreneurs are &#8220;Defying Gravity&#8221;</a> &lt;&#8211;</strong></p>\n<p>In fact, I met many of these entrepreneurs, graduates of WP Academy programs, at Christine&#8217;s live event in Atlanta last June.  All of the ones I spoke with found it beneficial, and most were utterly transformed.</p>\n<h3>And here is the best thing of all:</h3>\n<p>Christine is launching her new program, entitled &#8220;Becoming 360&#8243;, <strong>for about one-third of the price of her previous program</strong>s (about $500).  This is, in my humble opinion, the best small-business development training available anywhere, at any price.  <strong>Especially since it actually includes a free ticket to a live event happening in Asheville, NC, in February 2015</strong> (live event may be sold-out &#8212; you will need to check with her prior to registering, if this is important to you).</p>\n<p><strong><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">Get Access to the LIVESTREAM training on Tuesday Sept 30</a> &lt;&#8211;</strong></p>\n<p>PS: I want to hear your thoughts about this&#8230; just reply to this email if you have any questions. I stand 100% behind all the trainings and resources that I recommend.</p>\n<p>To Your Success,</p>\n<p><img class=\"alignnone size-full wp-image-19324\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau<br />\n&#8220;Your Small-Biz Web Technology Mentor&#8221;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/\">Christine Kane Free Training: the New Class of Entrepreneur</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Website Design Packages available again (very limited supply)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Sep 2014 09:21:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19872\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:626:\"<p>We are taking on 4 more website design packages in September.  Details here. A bit of background: our business is training you how to make and market your site, but some people like to fast-start the process, save time and avoid mistakes by having our instructors and virtual assistants provide direct one-on-one assistance and production [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/\">Website Design Packages available again (very limited supply)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1810:\"<p></p><p>We are taking on 4 more website design packages in September.  Details <a href=\"http://wpacademy.com/websites\">here</a>.</p>\n<p>A bit of background: our business is training you how to make and market your site, but some people like to fast-start the process, save time and avoid mistakes by having our instructors and virtual assistants provide direct one-on-one assistance and production services.  For this purpose we have created a very compellingly-priced optimal mix of on-shore marketing, design and copywriting services, and off-shore production assistance.  We don&#8217;t just make your site, we also give you advice on many topics that you are simply not going to get from your average web designer &#8212; let alone an offshore web designer.</p>\n<p><strong>&gt;&gt; <a href=\"http://wpacademy.com/websites\">View your options for Starter Website Packages Here</a> &lt;&lt;</strong></p>\n<p><em><strong>However, there is a catch</strong></em> &#8212; we only sell a very limited number of these per production cycle, so you will need to jump on this fast.  Schedule your appointment or purchase a package directly as soon as possible, if you wish to take advantage of this offer.</p>\n<p>Here are some of the sites we made in our last production run:</p>\n<p><img class=\"alignnone size-full wp-image-19873\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/09/websites-all.jpg\" alt=\"websites-all\" width=\"600\" height=\"577\" /></p>\n<p>Order yours <a href=\"http://wpacademy.com/websites\">here</a>.</p>\n<p>&nbsp;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/\">Website Design Packages available again (very limited supply)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"3 Reasons To Create A Lifestyle Business + Free Live Training with Natalie Sisson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Sep 2014 07:50:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19861\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:624:\"<p>Some of you already know this, but in July I moved to Thailand to run my business and study yoga. I am living a great personal and business adventure.  To the right is the view from my porch.  I won&#8217;t claim this as my &#8220;office&#8221; (I prefer A/C when working), but you get the idea. [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/\">3 Reasons To Create A Lifestyle Business + Free Live Training with Natalie Sisson</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5879:\"<p></p><p><strong><img class=\"alignright size-medium wp-image-19863\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/09/porch2-300x225.jpg\" alt=\"porch2\" width=\"300\" height=\"225\" />Some of you already know this, but in July I moved to Thailand to run my business and study yoga</strong>. I am living a great personal and business adventure.  To the right is the view from my porch.  I won&#8217;t claim this as my &#8220;office&#8221; (I prefer A/C when working), but you get the idea.</p>\n<p>As such I know quite a bit about creating a &#8220;lifestyle business&#8221;.  But there is someone who knows even more than me.  Her name is Natalie Sisson (the &#8220;Suitcase entrepreneur&#8221;), and<strong> she is giving a free webinar on Thursday, Sept. 18 at 3pm EST.  You can register <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">here.</a></strong></p>\n<p>Here is what she has to say about it:</p>\n<p>There are three (big) reasons you should consider creating a “lifestyle business” &#8211; one that gives you major freedom, on your own terms and allows you to live how you want to live.</p>\n<p>1) <strong>You get to make your own hours</strong>. Maybe you like to work early, stay up late. Do half-days, break up your day, do yoga in the middle &#8211; whatever you choose.</p>\n<p>2) <strong>You get to decide where you work</strong> (some like it hot, some like it cold), and not ever be tied down to one location unless you choose it. Mountain climbing, surfing or fly fishing can absolutely be a part of your ideal day.</p>\n<p>3) <strong>When YOU are in control and are running your business</strong> (instead of your business running you), you will be happier, have greater freedom and be able to rekindle those dreams you may have pushed aside, making it all a reality.</p>\n<p>Lots of people think that to be a successful entrepreneur you need to treat your business as a &#8220;job&#8221;.  That’s the world we live in and we’re taught to just follow “the rules,” work our way up and out, slaving away and THIS will eventually equal happiness.</p>\n<p><strong>Not.</strong></p>\n<p>You can’t start a business, treat it like a job and expect yourself to have a ton of freedom and flexibility.  You ought to factor in your lifestyle aspirations, your needs and wants and preferences, your preferred working style and environment, your (realistic) income needs, etc.,  from the beginning.  And (of course) you need practical and actionable traffic-getting and income-generating strategies.   Otherwise&#8230; oye, it might be a tough slog.  If you can get to the end at all (most people who try don&#8217;t, I am one of the lucky ones).</p>\n<p>Entrepreneurship is growing more rapidly than any other profession on the planet. Technology has given us freedom and most people aren’t finding happiness in a job. They want more.</p>\n<p>Now, we can literally work anywhere in the world, doing whatever we darn well please.</p>\n<p><strong>But how do you do it?</strong> How do you make it really work and create real revenue and STILL have freedom?</p>\n<p>My friend and awesome entrepreneur brainchild Natalie Sisson, Founder of The Suitcase Entrepreneur, is hosting a really cool never-done-before training on <strong>“How to Uncover Your Fastest Path To Making Real Revenue, Creating a Business Working Anywhere in the World and Never Again Be Tied Down To A Boss”.</strong></p>\n<p><strong>&gt;&gt; <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">Register to the free training here</a> &lt;&lt;</strong></p>\n<p>Natalie is a #1 best-selling author, has grown a tribe of over 16,000 hungry Freedom Seekers on her blog, has a top Podcast on iTunes and gets paid to speak around the world on freedom + entrepreneurship.</p>\n<p>She’ll be giving us FIRST DIBS on on her behind-the-scenes tactics she’s used to be able to travel the world, meet all sorts of amazing people all while creating a six figure business.</p>\n<p><strong>In this exclusive live training, we’re going to be covering:</strong></p>\n<p>1) The #1 Mistake People Make When Designing a Business Online That Keeps Them Stuck, Under-earning and Tied Down</p>\n<p>2) How You Can Find Your &#8220;Sweet Spot&#8221;, Actually Get Paid To Do What You Love, Are Good At and Turn That Into A Real Business</p>\n<p>3) Natalie’s Unique Three-Stage Plan She’s Developed To Build Her Completely Location Independent 6-figure Business</p>\n<p>4) The FOUR Things It Really Takes to Be Free and Which of These is The Most Overlooked (Yet CRITICALLY Important) For Living Life On Your Own Terms</p>\n<p>5) How YOU Can Design, Create &amp; IMPLEMENT Your PERFECT Online Lifestyle Business In Eight Weeks Or Less!</p>\n<p>If you’re ready to become a Freedom Fighter in your own life, stand for something more, making real revenue, rekindle those childhood dreams of exploring the world and going on the next big adventure, then I invite you to join us!</p>\n<p><strong>&gt;&gt; <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">Click here to register and claim your free spot</a> &lt;&lt;</strong></p>\n<p>P.S. Oh, one last thing! Natalie is also going to be giving everyone who attends a really cool bonus. It’s a<strong> Freedom Formula Checklist</strong> &#8211; “Your First Steps To Designing Your Ultimate Lifestyle Business In Just Eight Weeks.” <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">Join us live now</a>!</p>\n<p><span style=\"font-size: 12pt; font-family: arial;\"><br />\n</span></p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/\">3 Reasons To Create A Lifestyle Business + Free Live Training with Natalie Sisson</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"[LIVE] 4 simple ways to drive more sales and conversions. . .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Jul 2014 17:49:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19831\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:579:\"<p>If you’re looking to boost your sales before the end of the year. . . Or you believe your site should be generating significantly higher revenue than it is now. . . We just heard about an all-new live training that you need to see. This week, the lead generation experts at LeadPages are hosting [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/\">[LIVE] 4 simple ways to drive more sales and conversions. . .</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3002:\"<p></p><p>If you’re looking to boost your sales before the end of the year. . .</p>\n<p>Or you believe your site should be generating significantly higher revenue than it is now. . .</p>\n<p>We just heard about an all-new live training that you need to see.</p>\n<p>This week, the lead generation experts at LeadPages are hosting a new live training entitled: <i>“How to Transform Your Site into a Lead Generation Machine that Drives More Sales.”</i></p>\n<p>This live webinar is happening Thursday at 3 pm Eastern (12 noon Pacific).</p>\n<p><a href=\"https://my.leadpages.net/wl/jspencer/\">As a student in our course, you’re invited to attend.</a>&lt;&#8211;</p>\n<p>If you’re not familiar with LeadPages, this lead generation platform creates all the landing pages that you’ve seen on our website. (We can’t recommend LeadPages highly enough.)</p>\n<p>With over 20,000 customers just like us, LeadPages is constantly testing to discover which landing page designs and elements generate the most sales and conversions.</p>\n<p>Through all that research, LeadPages has discovered specific techniques that you can use to boost conversions and drive more sales.</p>\n<p>During Thursday’s live training, LeadPages Conversion Educator Tim Paige will reveal four of these simple techniques.</p>\n<p><a href=\"https://my.leadpages.net/wl/jspencer/\">Register for Thursday’s all-new live training right now. </a>&lt;&#8211;</p>\n<p>Inside Thursday’s live training, you’ll also discover. . .</p>\n<ul>\n<li>The 4 most critical, yet overlooked elements of your site (and how to tweak them to drive more sales).</li>\n</ul>\n<ul>\n<li>A simple, proven way to create the highest performing lead magnet you will likely ever use &#8212; that only takes 30 minutes to set up.</li>\n</ul>\n<ul>\n<li>3 unusual but simple ways to turn your Facebook fans into potential customers.</li>\n</ul>\n<p>There’s no telling when this live training will be available again.</p>\n<p>Again, if you’re interested in boosting your sales this year, we highly encourage you to join this all-new webinar on Thursday at 3 pm Eastern (12 noon Pacific).</p>\n<p><a href=\"https://my.leadpages.net/wl/jspencer/\">Don’t wait. Register for this live training right now. </a>&lt;&#8211;</p>\n<p>We’ll see you at Thursday’s live training.</p>\n<p>To Your Success,</p>\n<p><img class=\"alignnone wp-image-19324 size-full\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau<br />\n<a href=\"http://www.wpacademy.com\">WP Academy</a></p>\n<p>P.S. Only 1,000 people can be on this webinar at any one time. We recommend you register now and show up early on Thursday to claim your spot.</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/\">[LIVE] 4 simple ways to drive more sales and conversions. . .</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:48:\"http://members.wpacademy.com/category/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:12:\"x-powered-by\";s:10:\"PHP/5.4.31\";s:10:\"set-cookie\";a:5:{i:0;s:55:\"wlmdebug=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT\";i:1;s:210:\"wc_session_cookie_d0fb3bf6a09f702cdfb97e4d2c564710=IRWocRFdLNJ115VtH0WUUDDQO1tlHwI4%7C%7C1440135944%7C%7C1440132344%7C%7C631987ff70de86f17845f07d06f56cd1; expires=Fri, 21-Aug-2015 05:45:44 GMT; path=/; httponly\";i:2;s:74:\"woocommerce_items_in_cart=0; expires=Wed, 19-Aug-2015 04:45:45 GMT; path=/\";i:3;s:70:\"woocommerce_cart_hash=0; expires=Wed, 19-Aug-2015 04:45:45 GMT; path=/\";i:4;s:76:\"wfvt_1871270157=55d418097d4a5; expires=Wed, 19-Aug-2015 06:15:45 GMT; path=/\";}s:10:\"x-pingback\";s:39:\"http://members.wpacademy.com/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Fri, 14 Aug 2015 14:51:41 GMT\";s:4:\"etag\";s:34:\"\"8f2515aa39dfb45035ac42d2e283fc65\"\";s:12:\"x-robots-tag\";s:14:\"noindex,follow\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"date\";s:29:\"Wed, 19 Aug 2015 05:45:45 GMT\";s:13:\"accept-ranges\";s:5:\"bytes\";s:6:\"server\";s:9:\"LiteSpeed\";s:10:\"connection\";s:5:\"close\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("11890","can_compress_scripts","0","yes");
INSERT INTO wp_options VALUES("11888","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:2:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.3.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-4.3-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.3-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"4.3\";s:7:\"version\";s:3:\"4.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":12:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.3.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-4.3-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.3-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"4.3\";s:7:\"version\";s:3:\"4.3\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";s:13:\"support_email\";s:26:\"updatehelp42@wordpress.org\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1439962618;s:15:\"version_checked\";s:5:\"4.2.4\";s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("12040","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1439962621;s:7:\"checked\";a:4:{s:11:\"airconbasix\";s:3:\"1.0\";s:14:\"twentyfourteen\";s:3:\"1.4\";s:14:\"twentythirteen\";s:3:\"1.5\";s:12:\"twentytwelve\";s:3:\"1.7\";}s:8:\"response\";a:3:{s:14:\"twentyfourteen\";a:4:{s:5:\"theme\";s:14:\"twentyfourteen\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentyfourteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentyfourteen.1.5.zip\";}s:14:\"twentythirteen\";a:4:{s:5:\"theme\";s:14:\"twentythirteen\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentythirteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentythirteen.1.6.zip\";}s:12:\"twentytwelve\";a:4:{s:5:\"theme\";s:12:\"twentytwelve\";s:11:\"new_version\";s:3:\"1.8\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwelve/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwelve.1.8.zip\";}}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("12041","_site_transient_update_plugins","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1439962621;s:8:\"response\";a:1:{s:39:\"custom-login-page/custom-login-page.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"27656\";s:4:\"slug\";s:17:\"custom-login-page\";s:6:\"plugin\";s:39:\"custom-login-page/custom-login-page.php\";s:11:\"new_version\";s:3:\"2.6\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/custom-login-page/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/custom-login-page.2.6.zip\";s:14:\"upgrade_notice\";s:61:\"Serbo-Croatian translation added; WP 4.3 ready; new framework\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:5:{s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"790\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"4.2.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.4.2.2.zip\";}s:37:\"tinymce-advanced/tinymce-advanced.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:3:\"731\";s:4:\"slug\";s:16:\"tinymce-advanced\";s:6:\"plugin\";s:37:\"tinymce-advanced/tinymce-advanced.php\";s:11:\"new_version\";s:5:\"4.2.3\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/tinymce-advanced/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/tinymce-advanced.4.2.3.zip\";s:14:\"upgrade_notice\";s:44:\"Updated for WordPress 4.3 and TinyMCE 4.2.3.\";}s:55:\"ultimate-maintenance-mode/ultimate-maintenance-mode.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"28904\";s:4:\"slug\";s:25:\"ultimate-maintenance-mode\";s:6:\"plugin\";s:55:\"ultimate-maintenance-mode/ultimate-maintenance-mode.php\";s:11:\"new_version\";s:5:\"1.6.2\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/ultimate-maintenance-mode/\";s:7:\"package\";s:74:\"https://downloads.wordpress.org/plugin/ultimate-maintenance-mode.1.6.2.zip\";s:14:\"upgrade_notice\";s:24:\"Added Danish Translation\";}s:34:\"wp-clone-by-wp-academy/wpclone.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"37091\";s:4:\"slug\";s:22:\"wp-clone-by-wp-academy\";s:6:\"plugin\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:11:\"new_version\";s:5:\"2.1.8\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/wp-clone-by-wp-academy/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/wp-clone-by-wp-academy.2.1.8.zip\";}s:27:\"wp-super-cache/wp-cache.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:4:\"1221\";s:4:\"slug\";s:14:\"wp-super-cache\";s:6:\"plugin\";s:27:\"wp-super-cache/wp-cache.php\";s:11:\"new_version\";s:5:\"1.4.4\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wp-super-cache/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wp-super-cache.1.4.4.zip\";s:14:\"upgrade_notice\";s:99:\"Security release fixing an XSS bug in the settings page, and fix for fatal error in output handler.\";}}}","yes");
INSERT INTO wp_options VALUES("11899","_transient_timeout_feed_mod_9e53082436aed3c2daf5425e656d2952","1439545721","no");
INSERT INTO wp_options VALUES("11900","_transient_feed_mod_9e53082436aed3c2daf5425e656d2952","1439502521","no");
INSERT INTO wp_options VALUES("11901","tadv_settings","a:6:{s:7:\"options\";s:15:\"menubar,advlist\";s:9:\"toolbar_1\";s:117:\"bold,italic,blockquote,bullist,numlist,alignleft,aligncenter,alignright,link,unlink,table,fullscreen,undo,redo,wp_adv\";s:9:\"toolbar_2\";s:121:\"formatselect,alignjustify,strikethrough,outdent,indent,pastetext,removeformat,charmap,wp_more,emoticons,forecolor,wp_help\";s:9:\"toolbar_3\";s:0:\"\";s:9:\"toolbar_4\";s:0:\"\";s:7:\"plugins\";s:107:\"anchor,code,insertdatetime,nonbreaking,print,searchreplace,table,visualblocks,visualchars,emoticons,advlist\";}","yes");
INSERT INTO wp_options VALUES("11902","tadv_admin_settings","a:1:{s:7:\"options\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("11921","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("12044","_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1440006333","no");
INSERT INTO wp_options VALUES("12045","_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1439963133","no");
INSERT INTO wp_options VALUES("12046","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1440006335","no");
INSERT INTO wp_options VALUES("12047","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"WPTavern: WordPress 4.3 “Billie” Named After Jazz Singer Billie Holiday Is Available for Download\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47803\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://wptavern.com/wordpress-4-3-billie-named-after-jazz-singer-billie-holiday-is-available-for-download\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10229:\"<p>After four months of development led by <a href=\"http://konstantin.obenland.it/\">Konstantin Obenland</a>, WordPress 4.3 &#8220;Billie&#8221; named after jazz singer <a href=\"http://www.billieholiday.com/\">Billie Holiday</a>, is <a href=\"https://wordpress.org/news/2015/08/billie/\">available for download</a>. This release features menus in the customizer, strong passwords by default, site icons, and variety of other improvements.</p>\n<p></p>\n<p></p>\n<h2>Menus in the Customizer</h2>\n<p>You can now create, add, and edit menus in the customizer while previewing changes to your site in real-time. Unlike other parts of the customizer, previewing menus should be fast as it uses a new hybrid transport layer. Weston Ruter, who contributed to fast previews in the customizer <a href=\"https://make.wordpress.org/core/2015/07/29/fast-previewing-changes-to-menus-in-the-customizer/\">explains the approach</a>.</p>\n<blockquote><p>We also wanted to enable fast previewing of menu changes by default. So we implemented a <code>postMessage</code>/<code>refresh</code> hybrid approach which uses <code>postMessage</code> to sync the menus settings to the preview, and then the preview does an Ajax request to render just the contents of the menu container, and this Ajax response is then inserted into the DOM to replace the previous menu container. The technical name for this approach we have been calling &#8216;partial refresh&#8217;, but you can call it fast preview.</p></blockquote>\n<p>In general, previewing menus in most themes should be a fast experience.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/menu-customizer.png\"><img class=\"size-full wp-image-47806\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/menu-customizer.png?resize=1010%2C568\" alt=\"Menu Customizer\" /></a>Menu Customizer\n<h2>Strong Passwords by Default</h2>\n<p>Mark Jaquith <a href=\"https://make.wordpress.org/core/2015/07/28/passwords-strong-by-default/\">led the effort</a> to improve the way passwords are chosen and changed in WordPress. On the account management page, clicking the Generate Password button generates a strong password by default. The password strength meter is better integrated into the password field which lets users know immediately when their password is weak.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/better-passwords.png\"><img class=\"size-full wp-image-47807\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/better-passwords.png?resize=1010%2C568\" alt=\"Better Passwords in WordPress\" /></a>Better Passwords in WordPress\n<p>The same interface is on the add new user screen, the password reset screen, and the WordPress install screen. While WordPress doesn&#8217;t require users to have a strong password, it does everything it can to encourage users to choose one.</p>\n<p>In addition, WordPress no longer emails passwords and password reset links expire after 24 hours. When your password or e-mail changes, WordPress sends you an email so if someone hijacks your browser session and changes these items, you’ll be notified that it happened, and you can take action. You can disable these e-mails via the <code>send_pass_change_email</code> and <code>send_email_change_email</code> filters by setting them to false.</p>\n<h2>Site Icons</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-3-adds-new-site-icons-feature-and-a-text-editor-to-press-this\">Site Icons</a> are images that represent a website across multiple platforms. You can configure your Site Icon in the Site Identity panel within the customizer where you can upload a 512X512 sized image. This image will be used for browsers, iOS, Android, and Microsoft devices when a visitor bookmarks your site.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/site-icon-customizer.png\"><img class=\"size-full wp-image-47808\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/site-icon-customizer.png?resize=1010%2C568\" alt=\"Site Icons in The Customizer\" /></a>Site Icons in The Customizer\n<h2>Text Patterns, Quick Link Toolbar, and Word Count Changes</h2>\n<p>The editor in WordPress 4.3 has <a href=\"http://wptavern.com/text-patterns-and-the-quick-link-toolbar-in-wordpress-4-3\">undergone more improvements</a> with text shortcuts, a quick link toolbar, and word count changes. Text patterns or text shortcuts allow you to quickly add unordered lists, ordered lists, headers, and blockquotes without having to use a mouse.</p>\n<p>When starting a new paragraph with one of these formatting shortcuts followed by a space, the formatting will be applied automatically. Press Backspace or Escape to undo.</p>\n<p>In the visual editor in WordPress 4.3, typing <code>*</code> or <code>-</code> and hitting the space bar will generate a bulleted list. Typing <code>1. </code> or  <code>1)</code> and hitting space will generate a numbered list. If you don’t want to create these lists or do so in error, clicking the undo button or hitting <code>ctrl/cmd+z</code> or <code>esc</code> will undo the text pattern.</p>\n<p>Starting a paragraph with two to six number signs <code>#</code> will convert the paragraph to a heading. Similarly, the greater-than symbol <code>&gt;</code> will convert the paragraph to a blockquote.</p>\n<ul>\n<li>## = H2</li>\n<li>### = H3</li>\n<li>#### = H4</li>\n<li>##### = H5</li>\n<li>###### = H6</li>\n</ul>\n<h3>Quick Link Preview Toolbar</h3>\n<p>When you click a link in the WordPress 4.3 visual editor, a small inline link toolbar displays the full URL with buttons to edit or remove it. This avoids having to use the Insert/edit link modal window.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/PreviewLinks.png\"><img class=\"size-full wp-image-47792\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/PreviewLinks.png?resize=571%2C102\" alt=\"Preview Links in The Visual Editor WordPress 4.3\" /></a>Preview Links in The Visual Editor WordPress 4.3\n<p>Word and character counts have also changed in WordPress 4.3. Instead of updating counts when pressing enter or return, it will refresh when you stop typing. A lot more characters that shouldn’t be counted as words are excluded. Ella Iseulde Van Dorpe, WordPress core contributor, <a href=\"https://make.wordpress.org/core/2015/07/23/wordcharacter-count-updates-in-4-3/\">lists other notable changes</a>.</p>\n<h2>Changes to the Admin Bar</h2>\n<p>WordPress 4.3 moves the Customize link to the top-level menu of the admin bar. This link opens the customizer, allowing you to manage menus, appearance, and widgets through the customizer interface.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP42AdminBar.png\"><img class=\"wp-image-46995 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP42AdminBar.png?resize=429%2C232\" alt=\"WordPress 4.2 Admin Bar\" /></a>WordPress 4.2 Admin Bar\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP43AdminBar.png\"><img class=\"wp-image-46996 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP43AdminBar.png?resize=428%2C202\" alt=\"WP43AdminBar\" /></a>WordPress 4.3 Admin Bar\n<p>The Dashboard, Themes, Widgets, and Menus links take users to their corresponding admin pages in the backend of WordPress. This makes it clear which interface users are about to enter. The enhancement is a result of <a href=\"https://core.trac.wordpress.org/ticket/32678\">ticket #32678</a> where Helen Hou-Sandí and other WordPress core contributors discussed ways to improve the context of each link over the course of five weeks.</p>\n<h2>Noteworthy Changes</h2>\n<ul>\n<li><a href=\"http://wptavern.com/wordpress-4-3-improves-user-search-and-turns-comments-off-on-pages-by-default\">Comments are turned off on pages by default</a>.</li>\n<li><a href=\"https://make.wordpress.org/core/2015/07/02/deprecating-php4-style-constructors-in-wordpress-4-3/\">PHP-4 Style constructors have been deprecated</a> to prepare for the release of PHP 7.</li>\n<li>Singular.php was added to the <a href=\"https://make.wordpress.org/core/2015/07/06/singular-php-new-theme-template-in-wordpress-4-3/\">WordPress template hierarchy.</a></li>\n<li>Changes to c<a href=\"https://make.wordpress.org/core/2015/07/27/changes-to-customizer-panels-and-sections-in-4-3/\">ustomizer panels and sections.</a></li>\n<li><a href=\"https://make.wordpress.org/core/2015/07/31/headings-in-admin-screens-change-in-wordpress-4-3/\">Header tags were updated through the admin screens</a>. Plugin, theme, and framework developers, please change the main heading from an <code>&lt;h2&gt;</code> into an <code>&lt;h1&gt;</code>. Also, check the rest of your heading structure to ensure it’s semantic.</li>\n<li><a href=\"https://make.wordpress.org/core/2015/07/24/multisite-focused-changes-in-4-3/\">Multisite focused changes in 4.3</a> specifically, the introduction of get_main_network_id()</li>\n<li><a href=\"https://make.wordpress.org/core/2015/07/30/get_transient-is-now-more-strict-in-4-3/\">get_transient() is now more strict in 4.3</a></li>\n<li>The old <a href=\"https://make.wordpress.org/core/2015/07/29/old-distraction-free-writing-code-removed-in-4-3/\">Distraction Free Writing (DFW) code has been removed</a>.</li>\n<li>The code that powered the <a href=\"https://make.wordpress.org/core/2015/07/30/legacy-theme-preview-removed-in-4-3/\">old theme preview has been removed</a>.</li>\n<li><a href=\"https://make.wordpress.org/core/2015/08/08/list-table-changes-in-4-3/\">List tables have undergone API and UI changes</a>, with the introduction of a primary column concept and easier subclassing.</li>\n</ul>\n<p>WordPress 4.3 is the result of hundreds of paid and non-paid volunteers working tirelessly to improve the software used on more than 24% of the web. If you experience any issues with WordPress 4.3, please <a href=\"https://wordpress.org/support/\">report them on the support forums</a>. Volunteers are watching support threads closely and if warranted, will create a thread listing known issues.</p>\n<p>To enjoy the full upgrade experience, I encourage you to listen to Lady sings The Blues by Billie Holiday as you upgrade your WordPress sites.</p>\n<p><span class=\"embed-youtube\"></span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Aug 2015 19:13:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Automattic is Hiring\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45297\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://ma.tt/2015/08/automattic-is-hiring-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:635:\"<p>Do you know someone who is an amazing developer or designer? Someone who is passionate about helping people? An awesome lounge manager? Or maybe that person is you. <a href=\"https://automattic.com/work-with-us/\">Automattic is hiring for a variety of positions</a>, and for all except two you can live and work wherever you like in the entire planet. There are also a number of other benefits; the main downside it&#8217;s a high performance culture and expectations are extremely high. Automattic hires the best folks regardless of geography, and we are <em>especially</em> looking for people right now outside of US timezones.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Aug 2015 16:05:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Text Patterns and the Quick Link Toolbar in WordPress 4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/text-patterns-and-the-quick-link-toolbar-in-wordpress-4-3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4590:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/QuickLinkToolbarFeaturedImage.png\"><img class=\"size-full wp-image-47794\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/QuickLinkToolbarFeaturedImage.png?resize=675%2C209\" alt=\"Quick Link Toolbar Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/34547181@N00/4309431757\">metal chain</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">(license)</a>\n<p>WordPress 4.3 is on schedule to be released <a href=\"https://make.wordpress.org/core/version-4-3-project-schedule/\">August 18th</a> and contains a number of improvements. Among the enhancements to the visual editor are text patterns. Text patterns or text shortcuts allow you to quickly add unordered lists, ordered lists, headers, and blockquotes without having to use a mouse.</p>\n<p>In the visual editor in WordPress 4.3, typing <code>*</code> or <code>-</code> and hitting the space bar will generate a bulleted list. Typing <code>1. </code> or  <code>1)</code> and hitting space will generate a numbered list. If you don&#8217;t want to create these lists or do so in error, clicking the undo button or hitting <code>ctrl/cmd+z</code> or <code>esc</code> will undo the text pattern.</p>\n<p>Starting a paragraph with two to six number signs <code>#</code> will convert the paragraph to a heading. Similarly, the greater-than symbol <code>&gt;</code> will convert the paragraph to a blockquote.</p>\n<ul>\n<li>## = H2</li>\n<li>### = H3</li>\n<li>#### = H4</li>\n<li>##### = H5</li>\n<li>###### = H6</li>\n</ul>\n<p>It took a few tries to figure out but once I got the hang of it, I discovered that I prefer using text patterns versus clicking the appropriate button in the editor.</p>\n<p>For example, the blockquote text pattern places text into a blockquote and automatically closes it while also starting a new paragraph. Traditionally, I highlight text and click on the blockquote button in the editor. Often times, I have to visit the text editor and close the blockquote to start a new paragraph.</p>\n<p>Ryan Boren, WordPress core lead developer, created the <a href=\"https://make.wordpress.org/core/2015/08/01/editor-enhancements-in-4-3-%E2%9C%A8/\">following video</a> which shows the text patterns in action on a mobile device.</p>\n<h2>Quick Previews of Links</h2>\n<p>WordPress 4.2 included a subtle but convenient feature for adding links to text. Pasting the URL to highlighted text automatically turns it into a link. The problem is that there isn&#8217;t an easy way to preview the URL without opening it in a new browser tab.</p>\n<p>When you click a link in the WordPress 4.3 visual editor, a small inline link toolbar displays the full URL with buttons to edit or remove it. This avoids having to use the Insert/edit link modal window.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/PreviewLinks.png\"><img class=\"size-full wp-image-47792\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/PreviewLinks.png?resize=571%2C102\" alt=\"Preview Links in The Visual Editor WordPress 4.3\" /></a>Preview Links in The WordPress 4.3 Visual Editor\n<h2>Changes to Word and Character Counts</h2>\n<p>Word and character counts have also changed in WordPress 4.3. Instead of updating counts when pressing enter or return, it will refresh when you stop typing. A lot more characters that shouldn&#8217;t be counted as words are excluded. Ella Iseulde Van Dorpe, WordPress core contributor, <a href=\"https://make.wordpress.org/core/2015/07/23/wordcharacter-count-updates-in-4-3/\">lists other notable changes</a>.</p>\n<ul>\n<li>For <strong>character</strong> count, we no longer exclude any of these characters. This means that numbers and common western punctuation are no longer excluded compared to 4.2. Emoji and other astral characters are now counted as one character instead of two.</li>\n<li>We added a new type <strong>all</strong>, in addition to words and characters, that will count characters including spaces. This seemed necessary for Japanese and maybe other languages. This is now <code>character_including_spaces</code> and <code>character_excluding_spaces</code>.</li>\n<li>Shortcodes and HTML comments are now excluded.</li>\n</ul>\n<p>To view details and a summary of all the work that went into improving word counts, check out <a href=\"https://core.trac.wordpress.org/ticket/30966\">ticket #30966</a> on trac. As someone who uses the WordPress content editor for a living, I&#8217;m anxiously looking forward to utilizing these enhancements on an everyday basis.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Aug 2015 22:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Post Status: A WordPress conference for higher education: coming to a campus near you?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=14001\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://poststatus.com/wordpress-higher-ed-conference-wordcampus/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8684:\"<p><em><strong>Editor&#8217;s Note</strong>: Thus far, there have been numerous niche WordPress conferences aiming toward for-profit initiatives and geared toward businesses, marketers, or eCommerce site owners. But <a href=\"http://bamadesigner.com/\">Rachel Carden</a>&#8216;s concept for a niche, education focused, non-profit event is unique and I&#8217;d love to see it happen.</em></p>\n<p><em>As she notes, universities have unique challenges for managing websites and are also great candidates for utilizing WordPress to its full potential. What follows is her pitch and public brainstorming session on what a <a href=\"http://wordcampus.org/\">higher education focused WordPress conference</a> might look like.</em></p>\n<p>This all started with a tweet.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">Ooh. Dream with me: \"<a href=\"https://twitter.com/hashtag/WordCampus?src=hash\">#WordCampus</a>: A WordCamp for folks using <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> in Higher Education.\" I like it. <a href=\"https://twitter.com/hashtag/heweb?src=hash\">#heweb</a> <a href=\"https://t.co/m1zEkpkP4B\">https://t.co/m1zEkpkP4B</a></p>\n<p>&mdash; Rachel Carden (@bamadesigner) <a href=\"https://twitter.com/bamadesigner/status/628324358126235648\">August 3, 2015</a></p></blockquote>\n<p></p>\n<p>WordCamp U.S. made a big announcement that was all over Twitter, Chris Lema tweeted what we were all thinking, and I couldn’t help but start daydreaming about the possibilities.</p>\n<p>You see, I’m a web designer and developer with a passion for all things WordPress, especially using WordPress to build the world of higher ed web. Having spent the last 8 years working in higher education, I’m always looking for ways to utilize the power of WordPress to fulfill my campus’s needs and to help its communication grow, whether it’s using the powerful CMS to stretch limited resources or using its new API capabilities to share information, and break down silos, across campus departments.</p>\n<p>I love attending WordCamps and other WordPress-related events, but the issues we generally encounter in higher ed are often overlooked.</p>\n<p>Much like online businesses or blogging, higher ed is a world of its own with unique challenges, content, stakeholders, and target audiences. In our world, we don’t worry so much about which eCommerce plugin is best. Instead, we’re more concerned with things like how to manage a large-scale network of faculty blogs, making sure we’re abiding with FERPA regulations, or wondering how to best implement single sign-on that integrates with Active Directory.</p>\n<p>That’s why I’m proposing a new event in the WordPress community: a conference focused on using WordPress in the world of higher education. I call the idea “WordCampus”. (Kind of a perfect name, right? How did nobody think of this before?)</p>\n<p>The name “WordCampus” came to me from a tweet and does not, at this point, imply it would be an official WordCamp event. If needed, I’m open to organizing an event that is not affiliated with the WordPress Foundation. This is a detail that remains to be seen, but honestly, at this point, all details remain to be seen. A WordCamp representative has confirmed that a user group specific WordCamp is possible, but I would need to prove that it could draw a crowd. That’s why I need your help.</p>\n<p>If a WordPress conference for higher ed is something you would be interested in (whether it’s as an attendee, speaker, planner, sponsor, or all of the above), I invite you to read a few of my thoughts, share yours in the comments, and visit <a href=\"http://wordcampus.org/\">wordcampus.org</a> to show your support.</p>\n<h3>Cost and fee consideration</h3>\n<p>Much like your usual WordCamp, the goal for this event is to keep the costs and ticket price as low as possible. The point of this event is professional development and community, not profit. The phrases “big budget” and “higher ed” don’t generally appear in the same sentence anyway.</p>\n<p>A lot of higher ed-oriented web conferences can run upwards of $500 so an inexpensive, but valuable, event would be attractive for most higher education web professionals.</p>\n<h3>Unique sponsorship opportunity</h3>\n<p>Having sponsors to help with costs would be crucial and I am open to all kinds of support, whether it’s monetary or in-kind. Sponsoring an event like WordCampus would be a unique way to get an organization’s name in front of one of the best communities <em>outside</em> of WordPress that <em>uses</em> WordPress all the time.</p>\n<p>In the world of higher education, you often have limited resources, so there are plenty of opportunities for third party products or services like hosting, themes, plugins, custom design, accessibility consulting, and custom development, among others.</p>\n<h3>Location is a factor</h3>\n<p>The location could be a sticking point, as high travel costs might be a deal breaker for many WordCampus attendees. The beauty of local WordCamps is that they are tied to a geographical region and therefore, for most attendees, have limited travel requirements. This could be a problem for an event that is not tied to a specific region.</p>\n<p>Venue wise, universities have beautiful facilities, so I’d love to host the event on an actual college campus and, if the hosting university could donate the space in kind, this would be a huge cost saver. The most preferable universities would also be located near a major airport to help reduce travel time.</p>\n<p>If I’m really dreaming big, it would be great to find numerous universities that would be willing to host and, therefore, we could have regional WordCampus events spread across the country. I don’t think this is outside the realm of possibility, but would depend on interest and attendance. I&#8217;m certainly interested in hearing from anyone that may be interested in hosting WordCampus at their university.</p>\n<h3>A big target audience</h3>\n<p>There are a wide variety of WordPress users in higher ed, from the university-level WordPress developers and administrators, to the users who run WordPress for a college, to the faculty members using WordPress as a learning tool, and any students who’d love to learn a thing or two (they are our future, you know). That’s not even including content strategists, designers, social media managers, and more.</p>\n<p>WordCampus has the potential to attract a variety of users who could inspire a multitude of topics and professional development.</p>\n<h3>A broad variety of topics, even within the education umbrella</h3>\n<p>Speaking of topics, these could also run the gamut from higher ed marketing and content strategy to infrastructure, managing multi-author blogs, and streamlining application processes. Accessibility should also be a featured topic as federally funded institutions are required by law to make their electronic and information technology accessible to people with disabilities.</p>\n<p>Personally, I see the structure of higher ed as tailor-made for the open source mindset and would love to hear someone encourage collaboration and openness by comparing the ideologies of open source with the inner workings of higher education.</p>\n<h3>Event timing</h3>\n<p>As organizing something of this magnitude takes time, I’m looking at a 2016 booking. What time of the year in 2016, however, remains to be seen. There are obviously a lot of variables at play, from venue availability to which time of the year is best for our target attendees. In higher ed, you need time to clear your schedule and request funding, so I’d want to allow for that.</p>\n<p>Usually, the middle of the semester is best for most higher ed professionals, but this can vary depending on their field. And if we’re being honest, the majority of fall might be out of the question because of football season. We’ve included a straw poll <a href=\"http://wordcampus.org\">on the event landing page</a> to help us gauge which time of year might be best for those interested in attending.</p>\n<p>Thank you for taking the time to read through my proposal and hopefully interested parties will have a few additional thoughts for the comments. If you would like be notified of any future developments, or show your support for the project, please visit <a href=\"http://wordcampus.org\">wordcampus.org</a> to share a little bit of information. And don’t forget to tell your friends!</p>\n<p>If you have any questions, or would like to chat, you can also find me on Twitter <a href=\"https://twitter.com/bamadesigner\">@bamadesigner</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Aug 2015 21:33:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Rachel Carden\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: Artisanal Water\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45285\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"http://ma.tt/2015/08/water/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:301:\"<p></p>\n<p>Many of my friends know how obsessed I am with different types of water, from <a href=\"http://www.badoit.com/\">Badoit</a> to <a href=\"https://www.drinkhint.com/\">Hint Water (yum)</a> to <a href=\"http://delaubier.ca/site_en.html\">De L&#8217;aubier</a>. This definitely hit close to home.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Aug 2015 06:38:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: SF Germ Warfare\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45300\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://ma.tt/2015/08/sf-germ-warfare/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:258:\"<p>Speaking of San Francisco, did you know <a href=\"http://www.businessinsider.com/the-military-tested-bacterial-weapons-in-san-francisco-2015-7\">for 20 years, the military secretly tested biological/bacterial agents there, delivered through the fog</a>?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 16 Aug 2015 03:04:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Smokestack SF BBQ\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45290\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/08/smokestack-sf-bbq/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:454:\"<p>I had great BBQ in San Francisco last week at a new place called Smokestack. The brisket was on-point, and competitive with anything I&#8217;ve had in Texas. <a href=\"http://insidescoopsf.sfgate.com/blog/2014/05/08/magnolia-opens-dogpatch-brewery-and-its-restaurant-smokestack/#photo-451076\">This review in the SF Chronicle covers things pretty well</a>, if you&#8217;re hankering for some great Southern food in SF this is the place to check out.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Aug 2015 05:34:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WP REST API 1.2.3 Patches XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47770\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"http://wptavern.com/wp-rest-api-1-2-3-patches-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:798:\"<p>WP REST API version 1.2.3 and 2.0 Beta 4 <a href=\"https://make.wordpress.org/core/2015/08/14/rest-api-v1-2-3-and-v2-0-b4/\">address a security issue</a> that affects sites running 1.2 or 2.0 beta. This release fixes a potential XSS vulnerability related to JSONP support in 1.2 and 2.0 of the API. Automatic updates are in progress for 1.2.3 but if your site hasn&#8217;t automatically updated, the team suggests updating manually as soon as possible.</p>\n<p>In addition to the security release, <a href=\"https://wordpress.org/plugins/rest-api/\">2.0 Beta 4</a> includes a number of enhancements, some of which break backwards compatibility. Developers and beta testers should read the <a href=\"https://github.com/WP-API/WP-API/releases/tag/2.0-beta4\">detailed changelog</a> and release notes.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Aug 2015 15:22:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: Nick Haskins Rebrands Lasso to Editus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47763\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://wptavern.com/nick-haskins-rebrands-lasso-to-editus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1876:\"<p>In mid July, Nick Haskins, founder and lead developer of Lasso, was served a <a href=\"http://wptavern.com/nick-haskins-receives-cease-and-desist-letter-for-violating-lassosoft-trademarks\">cease and desist letter</a> from LassoSoft. LassoSoft argued that Lasso violates its <a href=\"http://www.tmfile.com/mark/?q=861046116\">registered trademarks</a> and causes confusion to its customers.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/EdiusFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-47764\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/EdiusFeaturedImage.png?resize=650%2C182\" alt=\"Edit us Featured Image\" /></a>Instead of fighting litigation, Haskins decided to rebrand the product from Lasso to<a href=\"https://edituswp.com/lasso-is-now-editus/\"> Editus.</a> The name was suggested by <a href=\"http://www.iklektive.com/\">Gavin Aldrich</a>. According to Haskins, the only references to the name is a band in Costa Rica and a directory in Luxemburg.</p>\n<p>In addition to a new domain and cloned website, Lasso 0.9.8 is available for download which includes the renaming of various admin menu items that used the term Lasso.</p>\n<h2>Lasso 0.9.8 Requires a Manual Update</h2>\n<p>Haskins says users will need to update to 0.9.8 manually because of the switch in domain names but automatic updates will return after 0.9.8,  &#8220;Updates after 0.9.8, will continue to be automatic, just as the way they were before,&#8221; Haskins said.</p>\n<p>Aesopinteractive LLC is <a href=\"http://nickhaskins.com/2015/07/on-life-and-family/\">looking for a buyer</a> but after receiving low offers, Haskins has decided to use a broker to facilitate the sale. The broker requested that the rebrand of Lasso be completed before proceeding with the sale process.</p>\n<p>I think Editus has a nice ring to it, what do you think?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Aug 2015 13:39:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Death of Mobile Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45292\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"http://ma.tt/2015/08/death-of-mobile-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:633:\"<blockquote><p>Mobile web and mobile in-app behaviour are not binary. When users are in the facebook app, they spend a tremendous amount of time accessing the mobile web through facebook’s own in-app browser. The same for twitter and others. We enter social apps for discovery and then access the mobile web while still in-app. It is a mistake to conflate time spent on the mobile web with time spent in a traditional browser.</p></blockquote>\n<p>Amen. Tony Haile of Chartbeat: <a href=\"http://www.tonyhaile.com/2015/08/11/a-correction-around-the-death-of-the-mobile-web/\">A correction around the death of the mobile web.</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Aug 2015 03:19:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: A Look at Why Some Frontend Developers are Decoupling WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47735\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://wptavern.com/decoupling-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5540:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/DecoupledWordPressFeaturedImage.png\"><img class=\"size-full wp-image-47758\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/DecoupledWordPressFeaturedImage.png?resize=677%2C240\" alt=\"Decoupled WordPress Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/77742560@N06/7782209734\">Coupler: Immigration Museum</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<hr />\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/Emily_Miller1.jpg\"><img class=\"alignright wp-image-47736 size-thumbnail\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/Emily_Miller1.jpg?resize=150%2C150\" alt=\"Emily_Miller1\" /></a>This post was contributed by <a href=\"https://twitter.com/emilymiller317\">Emily Miller</a>. A native Hoosier, Emily now lives in San Francisco, CA, and is a content specialist at hosting platform <a href=\"http://pantheon.io\">Pantheon</a>. She enjoys exploring the great outdoors with her dog and researching the latest trends in open source.</p>\n<hr />\n<p>WordPress developers are getting serious about developing flexible, powerful websites of all sizes. One trend, started as a way to break free of the constraints of traditional WordPress theming, is using a decoupled architecture to customize the frontend.</p>\n<p>There are certainly pros and cons to this method, and this post aims to examine the various reasons why some frontend developers are implementing a headless WordPress.</p>\n<h2>What Is Decoupled WordPress?</h2>\n<p>Decoupled WordPress is the separation of the backend from the frontend. WordPress is traditionally monolithic, giving you the dashboard, plugins and themes all-in-one. Many developers have been playing around with decoupled builds lately with the primary motivation of creating a better user experience.</p>\n<p>Decoupling allows you to experiment with different JavaScript frameworks, such as Angular, to build a truly custom experience for users. That’s not to say everyone should go headless, but rather that decoupling is an option if your project has a set of requirements that call for a more flexible build.</p>\n<p>In these cases, decoupling allows WordPress to do what it does best, content organization and editing while avoiding a lot of the complex custom code that goes into developing for a set CMS.</p>\n<h2>Why Are Developers Adopting It for the Frontend?</h2>\n<p>Translating modern design into a tightly coupled CMS can be tricky, so separating the UX layer of a site allows developers to leverage the tools they want, making the frontend truly agile and the end-user experience more friendly.</p>\n<p>For the right use case it’s a win-win situation. Use the best tools for frontend development, while making the WordPress authoring experience even better to empower everyone! Quite a few developers have mentioned that decoupled projects renew their love for a chosen CMS, and that the flexibility makes it fun to work with again.</p>\n<p>Another benefit of a decoupled architecture is the upgrade process. A headless build simplifies future updates by not requiring a CMS upgrade, ultimately saving a great deal of time and money come redesign. Frontend developers can now work at their own pace, independent of the CMS’s timeline, and focus on the best language for the task at hand.</p>\n<p>A good case study of a decoupled WordPress build is <a href=\"http://www.pixotech.com/\">Pixo Tech’s</a> project with the University of Illinois. They chose the best frontend tools for the job, understanding that frontend developers and CMS developers are not necessarily one in the same. For the nitty-gritty of the project, <a href=\"https://pantheon.io/what-know-about-decoupled-cms-recording\">check out this webinar. </a></p>\n<h2>What’s the Catch?</h2>\n<p>As mentioned above, although a decoupled architecture may sound like that captivating and challenging project we’ve all been waiting for, it still has its pitfalls and is probably not the route for every project.</p>\n<p>Decoupling WordPress is a more customized, complex build that could mean more time and money up front, although cost-effective in the long run. It also means losing the content previews, easy string translations and UI oriented plugins and themes we’re used to in a coupled architecture.</p>\n<p>Additionally, decoupled WordPress is still a young concept, and best practices are still emerging. There’s no set way to do it, and you certainly won’t find a how-to tailored to your specific needs.</p>\n<h2>How Would You Approach a Decoupled Build?</h2>\n<p>The <a href=\"https://github.com/WP-API/WP-API\">WP REST API</a> is a great way to facilitate a decoupled build—you can download it and then decide how much of your site you want to separate. Integrated into core and available to all WordPress users, the plugin provides an easy-to-use REST API, available via HTTP.</p>\n<p>This gives developers a great deal of flexibility for creating applications that use a WordPress backend and brings WordPress one step closer to being a complete application framework.</p>\n<h2>What Now?</h2>\n<p>Decoupled CMS is still a new concept, and as a community it is important to share our methods and what we learn as we continue to experiment with such projects, ultimately standardizing on best practices for the future.The possibilities for decoupled are endless, and it’s up to the open-source community to lead the charge and document what we learn.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 21:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WordPress for iOS: Version 5.4 Adds Statistical Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47740\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/wordpress-for-ios-version-5-4-adds-statistical-insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2285:\"<p>WordPress for iOS: Version 5.4 is <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">available on the app store</a> and includes a couple of new features. To compliment the <a href=\"http://wptavern.com/wordpress-for-ios-5-3-released-with-refreshed-stats-and-a-new-layout-for-posts-and-pages\">improvements to stats in 5.3</a>, 5.4 adds a new stats screen called insights.</p>\n<p>Insights is similar to the Right Now widget in the WordPress dashboard in that it displays a summary of key statistics for a site including, total number of published posts, views, visitors, and the best traffic day. There&#8217;s also a section that displays the current day&#8217;s stats.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/IMG_7433.png\"><img class=\"size-large wp-image-47744\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/IMG_7433.png?resize=282%2C500\" alt=\"Stat Insights\" /></a>Stat Insights\n<p>Prior to 5.4, you could only add images to posts that were stored on the device. WordPress for iOS 5.4 adds the ability to insert images from the WordPress media library.</p>\n<p>To add an image from the WordPress media library, select media library from the menu at the top of the screen. If you have a lot of items in the media library, it may take a few minutes to load.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/WPiPhoneMediaLibrary.png\"><img class=\"aligncenter size-large wp-image-47746\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/WPiPhoneMediaLibrary.png?resize=500%2C399\" alt=\"WP For iOS 5.4 Media Library Selection\" /></a>Other improvements include the ability to search the My Sites list and viewing embedded images in comments. This makes it easier to see the full context of a comment without having to view it in a different part of the app.</p>\n<p>Last but not least, the team fixed a bug that caused the app to not restore its state properly. WordPress for iOS: Version 5.4 is <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">free and available</a> on the app store. If you encounter any issues, you&#8217;re encouraged to report them on the <a href=\"https://ios.forums.wordpress.org/\">WordPress for iOS support forums</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 20:15:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Short Interview With Nikolay Bachiyski WordPress’ Security Czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2331:\"<p>While on stage at <a href=\"https://europe.wordcamp.org/2015/\">WordCamp Europe</a> answering a question related to WordPress’ security track record, Matt Mullenweg named <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a> as the first Security Czar for the <a href=\"https://wordpress.org/\">WordPress project</a>.</p>\n<p>I interviewed Bachiyski to learn why the role was created and what its purpose is.</p>\n<p><strong>What are the responsibilities of your new role?</strong></p>\n<p>My responsibilities are to coordinate the security efforts of<span class=\"Apple-converted-space\"> </span><a href=\"http://wordpress.org/\" target=\"_blank\" rel=\"noreferrer\">WordPress.org</a><span class=\"Apple-converted-space\">, </span>mostly with incident response and to make sure we respond quickly, have solid fixes, and make sure everyone involved is informed.</p>\n<p><strong>What circumstances led to this role&#8217;s creation?<br />\n</strong></p>\n<p>Nothing too spicy around the creation of the role. As the volume of requests increased, we realized a bit more structure would be helpful so that we are more focused and use our resources wisely.</p>\n<p><strong>Will you only handle security issues for the open source project or will you also help with Automattic’s bounty program as well?</strong></p>\n<p>There are other colleagues at Automattic who are responsible for the bounty program.</p>\n<p><strong>How important are the connections and trust you’ve established over the last 11 years to your role?</strong></p>\n<p>Offline relationships are very important in an online community and I am lucky to know many of the members of the security team in person. This definitely makes working with them easier.</p>\n<h2>Learn More About the WordPress Security Team</h2>\n<p>If you&#8217;d like to learn more about who&#8217;s on the WordPress security team, what they do, and how they handle security releases, listen to my interview with Gary Pendergast.</p>\n<p>Pendergast who works for Automattic, is a WordPress core contributor, and a member of the WordPress core security team. In the interview, we discuss what happened behind the scenes before <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\">4.2.3 was released</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 18:26:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: WPWeekly Episode 203 – Interview With Kiko Doran Co-organizer of Prestige Conference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47721&preview_id=47721\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/wpweekly-episode-203-interview-with-kiko-doran-co-organizer-of-prestige-conference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2165:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://kikodoran.com/\">Kiko Doran</a>, co-organizer of <a href=\"http://prestigeconf.com/\">Prestige conference</a>. Doran describes how he discovered WordPress in 2009 and explains the origin of Prestige, a career and business development conference.</p>\n<p>We discuss the <a href=\"http://wptavern.com/the-mantra-of-family-comes-first\">mantra of family first </a>and how Brazilian Jiu Jitsu helps him in his everyday life. Near the end of the interview, we learn Prestige 4 is in the planning stages.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-plugin-directory-surpasses-one-billion-total-downloads\">WordPress Plugin Directory Surpasses One Billion Total Downloads</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/site-import/\">Site Import</a> allows you to import posts and items from other websites without having to export anything. The content is extracted directly from the site.</p>\n<p><a href=\"https://wordpress.org/plugins/followprice/\">Followprice</a> adds a button to your storefront that when clicked, saves products into a universal wish list. This allows visitors to subscribe and receive price or stock alerts from your store.</p>\n<p><a href=\"https://wordpress.org/plugins/revision-strike/\">Revision Strike</a> is designed to automatically remove unneeded revisions on older, published posts.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 19th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #203:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 16:31:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt: Avis GPS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://ma.tt/2015/08/avis-gps/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2713:\"<p>After an amazing WordCamp Scranton on Saturday I was heading to a friend&#8217;s birthday on Long Island on Sunday, a few people were surprised I had flown from New York and said driving took about the same amount of time when you factor in all the airport hassle.</p>\n<p>I Google Mapped it and it did look like it was only 5-6 hours from Scranton to where I was going. Being a born and raised Texan, I love a good drive, and I probably haven&#8217;t had a proper road trip since my sister&#8217;s birthday a few years ago when we went up Highway 1. I&#8217;ve also never driven on the East Coast, and it seemed like there were some really pretty parks and lakes in between Scranton and Long Island so I ended up going to the airport anyway because that&#8217;s where the rental cars were.</p>\n<p>I like <a href=\"http://www.avis.com/\">Avis</a>. They try harder. <img src=\"http://i2.wp.com/s.ma.tt/blog/wp-includes/images/smilies/simple-smile.png?w=604\" alt=\":)\" class=\"wp-smiley\" /> One thing they do that&#8217;s pretty cool is sell  decent cables, USB wall chargers, and car chargers for a cheap price right at the check-in desk. (I always carry my own car charger, <a href=\"http://www.amazon.com/Incase-Speed-Charger-Lightning-Cable/dp/B00P7Y6M2Y/\">this is my current pick</a>. It&#8217;s super-handy in Ubers as well.) Amazingly though they still try to give you one of those Garmin GPS units that&#8217;s worse than your smartphone in every possible way. I&#8217;m sure it&#8217;s a money maker, otherwise the only reasonable thing to do would be provide <a href=\"http://www.amazon.com/dp/B00O5JARCI\">a smartphone mount</a> (or have one already set up in the car) rather than saddling people with an <a href=\"http://www.amazon.com/gp/bestsellers/electronics/559938/ref=zg_b_bs_559938_1\">archaic, non-networked navigation device</a> that has no idea about construction or traffic.</p>\n<p>I ended up going to a Walmart that was nearby to pick up a car mount (price, $12) that ended up being a life-saver for the trip. <strong>I also believe that every person in tech should visit Walmart at least once a year, and spend time in their technology section.</strong> It&#8217;s good to understand and see how people who don&#8217;t live for technology every day interact with it. It&#8217;s eye-opening, and it&#8217;s handy to know what&#8217;s in stock in case you need 50 feet of ethernet at 4 AM.</p>\n<p>Dropping the car off in Manhattan, it looks like they charged me $20 for a GPS which I don&#8217;t even have, so now going to need to sort out both the fee and the &#8220;missing&#8221; GPS system.</p>\n<p>tl; dr: Smart car rental companies should ditch the GPS, provide smartphone mounts instead.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 02:44:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: Filled With Wonder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45288\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://ma.tt/2015/08/filled-with-wonder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"<blockquote><p>Teach when you are filled with wonder, before you become a boring expert.</p>\n<p>— Mark Pilgrim</p></blockquote>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Aug 2015 01:44:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Organizing Team Explains Why Philadelphia Should Host WordCamp US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47699\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wptavern.com/organizing-team-explains-why-philadelphia-should-host-wordcamp-us\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2198:\"<p>When organizing teams in different <a href=\"http://wptavern.com/wordcamp-us-2015-now-accepting-applications-for-host-city\">cities applied to host</a> WordCamp US earlier this year, they provided a substantial amount of information through the application process. While <a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">Philadelphia will host</a> the event in 2015 and 2016, their application is not public information.</p>\n<p>Juliana Reyes, who writes for <a href=\"http://technical.ly/philly\">Technical.ly Philly</a>, acquired and <a href=\"http://technical.ly/philly/2015/08/11/wordcamp-us-philadelphia-wordpress-devs/\">published a few</a> of the responses from the organizing team&#8217;s application, specifically questions four, nine, ten, and eleven.</p>\n<p>Question nine on the application asks, why do you think your city should host WordCamp US 2015? The organizing team responded:</p>\n<blockquote>\n<p dir=\"ltr\">Philadelphia is the birthplace of our nation. The United States started here, and so should WordCamp US.</p>\n<p dir=\"ltr\">We’re ideally situated on the East Coast between New York and Washington DC, and the halfway point between the West Coast and parts of Europe.</p>\n<p dir=\"ltr\">With a population of 1.5 million, it is the 5th largest city in North America, and is a cultural hub for all things food, music, art, and technology. It is well-known for its many excellent medical and educational facilities, including the University of Pennsylvania, Temple University, Drexel University, and the University of the Sciences.</p>\n<p dir=\"ltr\">With over 1,200 daily inbound and outbound flights, Philadelphia is easy to reach from anywhere in the world. The average hotel room and cost of living, is far below any other major East Coast city, and nowhere else has cheesesteaks like we do.</p>\n</blockquote>\n<p dir=\"ltr\">I&#8217;ve yet to visit Philadelphia but one thing I&#8217;ve learned is that residents take their reputation for cheesesteaks seriously. Be sure to read <a href=\"http://technical.ly/philly/2015/08/11/wordcamp-us-philadelphia-wordpress-devs/\">the post</a> to see the team&#8217;s responses to the other three questions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 18:58:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: ThemeConf a Conference for Front-End Developers and Designers September 2nd-4th, 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47686\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://wptavern.com/themeconf-a-conference-for-front-end-developers-and-designers-september-2nd-4th-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2009:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/ThemeConfLogo.png\"><img class=\"alignright size-full wp-image-47688\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/ThemeConfLogo.png?resize=215%2C181\" alt=\"ThemeConf Logo\" /></a><a href=\"http://themeconf.com/\">ThemeConf</a> is a new conference set to take place September 2nd-4th, 2015, in Keswick, England aimed at front-end developers and designers. Confirmed speakers include a handful of Automattic theme wranglers, Noel Tock of Human Made, freelancer Adam Onishi, and Chris Hutchinson of The Times.</p>\n<p>The session schedule is expected to be released later this week however, here are some of the topics that will be covered at the event.</p>\n<ul>\n<li>Craft, workflow and best practices</li>\n<li>Browser performance and developer tools</li>\n<li>Design and photography</li>\n<li>JavaScript and REST APIs</li>\n<li>User experience</li>\n<li>Build tools</li>\n</ul>\n<p>Jack Lenox and Tammie Lister, who are the primary organizers of the event, originally came up with the idea for ThemeConf at the Automattic UK Christmas dinner, &#8220;Lenox wanted to bring a conference to where he lives in the Lake district and I wanted to do one focusing on themes,&#8221; Lister said.</p>\n<p>The two have been planning the event since January of this year. Although most of the confirmed speakers work with WordPress, ThemeConf is not dedicated to it, &#8220;It&#8217;s geared to those making themes in general and working on the front end. We have tried hard not to focus on WordPress,&#8221; Lister said.</p>\n<p><a href=\"https://ti.to/themeconf/2015\">Tickets for ThemeConf</a> are £49 and £99 respectively. The £49 tickets are for speaker sessions only while the £99 tickets include access to a workshop on using the REST API and lunch. Accommodations in the Lake District two hours from Manchester, Glasgow, Edinburgh, Newcastle, Liverpool and Leeds are available through <a href=\"http://www.keswick.org/\">Keswick.org.</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 16:37:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: $46M Scam\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://ma.tt/2015/08/46m-scam/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"<p>An incredible story: <a href=\"http://krebsonsecurity.com/2015/08/tech-firm-ubiquiti-suffers-46m-cyberheist/\">Tech Firm Ubiquiti Suffers $46M Cyberheist</a>. Notable for two reasons: I love Ubiquiti&#8217;s products, <a href=\"https://www.ubnt.com/products/#enterprise\">especially their Unifi line</a>, and I&#8217;ve never heard of phishing getting so much from a single victim.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 06:33:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: WordPress Plugin Directory Surpasses One Billion Total Downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47673\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/wordpress-plugin-directory-surpasses-one-billion-total-downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1706:\"<p>The WordPress project achieved a milestone earlier today as the official WordPress plugin directory <a href=\"https://wordpress.org/plugins/\">surpassed one billion</a> total downloads.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/1billiondownloads.png\"><img class=\"size-full wp-image-47674\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/1billiondownloads.png?resize=944%2C312\" alt=\"One billion total plugin downloads\" /></a>More than one billion total downloads\n<p>According to Scott Reilly who helps maintain WordPress.org, we&#8217;ll never know which plugin generated the one billionth download. That&#8217;s because WordPress.org doesn&#8217;t log information that matches downloads to plugins.</p>\n<p>&#8220;A download counter exists for each plugin for each day and the total amount is the summation of all those daily download counts,&#8221; Reilly said.</p>\n<p>As WordPress&#8217; <a href=\"http://w3techs.com/technologies/details/cm-wordpress/all/all\">market share</a> continues to grow, so does the amount of downloads from the plugin directory. The following numbers are the total amount of downloads from March 2006 to August 2015. This year, the directory is on pace to serve more than 300 million downloads.</p>\n<ul>\n<li>March 2006  191,567</li>\n<li>2007  2,845,802</li>\n<li>2008  15,130,856</li>\n<li>2009  49,822,116</li>\n<li>2010  72,342,598</li>\n<li>2011  108,501,907</li>\n<li>2012  141,609,682</li>\n<li>2013  182,236,517</li>\n<li>2014  241,142,505</li>\n<li>January 2015 to August 2015  186,243,700</li>\n</ul>\n<p>It took nine years for the plugin directory to reach one billion downloads, when do you think it will reach two billion?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 03:41:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: SkiPress a Week Long Excursion in the French Alps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47654\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/skipress-a-week-long-excursion-in-the-french-alps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1333:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/SkiPressFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-47658\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/SkiPressFeaturedImage.png?resize=852%2C269\" alt=\"SkiPress Featured Image\" /></a>If you enjoy skiing and WordPress, mark your calendars for <a href=\"http://skipressweek.com/\">SkiPress</a>, November 21-28, 2015. SkiPress is a week long excursion to Serre Chevalier, a ski resort in the French Alps. The cottage can hold up to 15 people where attendees can ski, discuss WordPress, develop code, or disconnect from technology.</p>\n<p><a href=\"http://skipressweek.com/\">Bernard-Jacquet</a> who writes for <a href=\"http://wp-spread.com\" target=\"_blank\">WP-spread</a>, and helps organize the local WordPress meetup in Grenoble, France, is organizing the event.</p>\n<p>Rooms at the cottage cost 350 euros. This amount covers the room for a week plus dinner at two restaurants. Prepare to bring some extra cash as the bus, skipass, and ski rental are additional costs.</p>\n<p>There&#8217;s not an official deadline to book a room but the sooner you book the better. If you&#8217;re interested in booking a room, please <a href=\"http://skipressweek.com/\">contact Berard-Jacquet</a> as soon as possible so he can make arrangements.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 20:29:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Richard Best Publishes Human Readable Version of the GPLv2 License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/richard-best-publishes-human-readable-version-of-the-gplv2-license\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2234:\"<p>WordPress is licensed under the <a href=\"https://wordpress.org/about/gpl/\">GPLv2</a> and the four freedoms it allows is considered to be its <a href=\"http://ma.tt/2014/01/four-freedoms/\">Bill of Rights</a>. The four freedoms are:</p>\n<ol start=\"0\">\n<li>The freedom to run the program, for any purpose.</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish.</li>\n<li>The freedom to redistribute copies so you can help your neighbor.</li>\n<li>The freedom to distribute copies of your modified versions, giving the community a chance to benefit from your changes.</li>\n</ol>\n<p>There is a lot more to the GPL than the four freedoms listed above however, the license details can be difficult to read and decipher. Richard Best, a qualified lawyer in New Zealand, England, and Wales, has published a <a href=\"http://wpandlegalstuff.com/a-human-readable-summary-of-the-gpl/\">human readable summary</a> of the GPL license.</p>\n<p>Inspired by how Creative Commons offers a <a href=\"http://creativecommons.org/licenses/by/3.0/\">human readable version</a> of its licenses, the summary explains the core concepts of the GPL and outlines the position in relation to copying, distribution, fees, modifications/derivative works, distributing non-source forms, termination, and downstream licensing.</p>\n<p>It&#8217;s important to note that the document is not endorsed by the Free Software Foundation nor a substitute for the full license text.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/GPLSummarySample2.png\"><img class=\"size-full wp-image-47647\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/GPLSummarySample2.png?resize=705%2C554\" alt=\"Sample of the human readable summary of the GPL\" /></a>Sample of the human readable summary of the GPL\n<p>I encourage everyone participating in the WordPress ecosystem to read the <a href=\"https://wordpress.org/about/gpl/\">full license</a> text at least once. However, the summary does a good job explaining the core components of the GPL without having to dig into the license.</p>\n<p>If you have questions concerning the GPL, I suggest seeking legal council with a lawyer familiar with software licensing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 18:31:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WPWeekly Episode 202 – Prestige is Serious Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47628&preview_id=47628\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/wpweekly-episode-202-prestige-is-serious-business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2339:\"<p>On this week&#8217;s episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I talk about the news of the week, including the release of WordPress 4.2.4 which patches six security vulnerabilities.</p>\n<p>I shared my experience attending Prestige last weekend while Marcus describes what it was like to watch the livestream. Marcus and I closed out the show with a candid conversation on the difficulty of achieving balance between work and life.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\">WordPress 4.2.4 Patches Six Security Vulnerabilities</a><br />\n<a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\"> Recap of Prestige a Conference Geared Towards Growing Businesses</a><br />\n<a href=\"http://nickhaskins.com/2015/07/on-life-and-family/\"> Aesop Interactive LLC For Sale</a><br />\n<a href=\"http://wptavern.com/the-mantra-of-family-comes-first\"> The Mantra of Family Comes First</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/export-plugins-and-templates/\">Export Plugins and Templates</a> exports your plugins and templates to a Zip file directly from the WordPress dashboard.</p>\n<p><a href=\"https://wordpress.org/plugins/expire-posts/\">Expire posts</a> automatically expires posts in WordPress and supports custom post types.</p>\n<p><a href=\"https://wordpress.org/plugins/local-seo-and-business-listings/\">Local SEO and Business Listings</a> allows you to optimize your local business website through a step by step actionable Local SEO Guide and a host of tools proven to increase web rankings.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 12th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #202:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 16:20:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: The WordPress Core Team Receives Praise for Their Efforts to Maintain Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47619\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"http://wptavern.com/the-wordpress-core-team-receives-praise-for-their-efforts-to-maintain-security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1832:\"<p>Netanel Rubin, a vulnerability researcher for <a href=\"http://www.checkpoint.com/\">Check Point Software</a> and <a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">credited</a> for properly disclosing a security vulnerability to WordPress, published the <a href=\"http://blog.checkpoint.com/2015/08/04/wordpress-vulnerabilities-1/\">first in a trilogy of posts</a> that explains how he discovered it.</p>\n<p>The vulnerability was discovered during a full audit of WordPress&#8217; code base in which Rubin praised the efforts of the WordPress development team.</p>\n<blockquote><p>In contrast to these frequent findings in 3rd party plug-ins’ code, barebones WordPress issues are rare, as WordPress core developers are well-trained to hold high security awareness for all released code.</p>\n<p>We can confirm that during our audit of the source code, we witnessed the developers ‘leaving nothing to chance’, and implementing multiple layers of security protecting most attack vectors we could think of.</p>\n<p>WordPress developers deserve praise for their efforts to maintain such complex software in this level of security, specifically considering the presence of the notoriously trigger-happy foot-gun called PHP.</p></blockquote>\n<p>I recommend <a href=\"http://blog.checkpoint.com/2015/08/04/wordpress-vulnerabilities-1/\">reading the post</a> as it&#8217;s a brief look into the mind of a <a href=\"https://en.wikipedia.org/wiki/White_hat\">white hat</a> security researcher.</p>\n<p>Although WordPress has <a href=\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\">seen its fair share</a> of security related releases this year, it&#8217;s reassuring to hear a third-party whose job it is to penetrate software security praise WordPress&#8217; codebase.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Aug 2015 00:05:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WPTavern: The Mantra of Family Comes First\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47609\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wptavern.com/the-mantra-of-family-comes-first\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2219:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/FamilyFirstFeaturedImage.png\"><img class=\"size-full wp-image-47611\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/FamilyFirstFeaturedImage.png?resize=669%2C247\" alt=\"Family First Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/63122283@N06/11867028263\">Mama&#8217;s </a>&#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>At <a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\">Prestige over the weekend</a>, I heard a presenter say that family comes first. This isn&#8217;t the first time I&#8217;ve heard this advice but it&#8217;s becoming more prevalent. I generally hear this advice from those who are living comfortably, have two kids or more, and/or have gone through the startup process more than once.</p>\n<p>I&#8217;m a distributed worker who receives a check every two weeks. I&#8217;m married, have no kids, and write about WordPress for a living. Putting family first should be easy but it&#8217;s not. The last two years as a distributed worker, I&#8217;ve put work before family unless it&#8217;s an emergency.</p>\n<p>Two weeks ago, my wife and I had a serious conversation about the way I work and how it has negatively impacted our marriage. I&#8217;m a late owl and on most nights, my wife sleeps alone. As a distributed worker, I get to make the rules and put myself in the best environment to get the job done.</p>\n<p>The conversation with my wife involved words not fit for reproduction but everything she said was right. I&#8217;m spending too much time on digital devices and not enough with her. Our conversation was the wake up call I didn&#8217;t know I needed.</p>\n<p>It&#8217;s not easy putting family first all the time. Some argue that you need to put yourself before family so that you can provide for them. Others find a critical balance between spending time with family and getting the job done.</p>\n<p>How do you put family first when there are bills that need to be paid, sites to be built, and a constant deluge of work to be done? Please share your thoughts, experiences, and advice in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Aug 2015 01:43:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: WordPress 4.2.4 Patches Six Security Vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47605\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2004:\"<p>WordPress <a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">4.2.4 is available</a> and patches six security vulnerabilities. The vulnerabilities were discovered by outside parties and members of the WordPress core security team. This release also fixes four bugs:</p>\n<ul>\n<ul>\n<li>WPDB: When checking the encoding of strings against the database, make sure we&#8217;re only relying on the return value of strings that were sent to the database. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/32279\">#32279</a></li>\n<li>Don&#8217;t blindly trust the output of <tt>glob()</tt> to be an array. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33093\">#33093</a></li>\n<li>Shortcodes: Handle <tt>do_shortcode(\'&lt;[shortcode]\')</tt> edge cases. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33116\">#33116</a></li>\n<li>Shortcodes: Protect newlines inside of <tt>CDATA</tt>. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33106\">#33106</a></li>\n</ul>\n</ul>\n<p>It&#8217;s been a busy year for the WordPress security team. Since the beginning of the year, there has been five security releases.</p>\n<ul>\n<ul>\n<li><a href=\"https://wordpress.org/news/2015/04/wordpress-4-1-2/\">WordPress 4.1.2</a></li>\n<li><a href=\"https://wordpress.org/news/2015/04/wordpress-4-2-1/\">WordPress 4.2.1</a></li>\n<li><a href=\"https://wordpress.org/news/2015/05/wordpress-4-2-2/\">WordPress 4.2.2</a></li>\n<li><a href=\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\">WordPress 4.2.3</a></li>\n<li><a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">WordPress 4.2.4</a></li>\n</ul>\n</ul>\n<p>Users should check their sites to make sure they&#8217;re running 4.2.4. If your site hasn&#8217;t automatically updated yet, you should perform a full backup and manually update. Sites running WordPress RC 2 are safe since it fixes the same issues as 4.2.4.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 23:45:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Recap of Prestige a Conference Geared Towards Growing Businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47580\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4245:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/PrestigeconfFeaturedImage.png\"><img class=\"size-full wp-image-47595\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/PrestigeconfFeaturedImage.png?resize=677%2C268\" alt=\"Tony Perez of Sucuri\" /></a>Tony Perez of Sucuri Presenting on Security at Prestige\n<p>Over the weekend, I attended <a href=\"http://prestigeconf.com/\">Prestige</a>, a conference geared towards freelancers, entrepreneurs, and small agencies looking to grow their businesses. Unlike WordCamps, plugins, themes, and WordPress in general were rarely mentioned. Instead, sessions included high level topics such as, how to land enterprise clients, knowing when to move on to the next big thing, and the benefits of partnerships.</p>\n<p>The venue was perfect with plenty of space and the WiFi worked well. Lunch was an hour-long and provided on both days. The lunchroom can easily seat 300 people or more. Only a third of the space was used when attendees ate lunch providing a great environment to network with people.</p>\n<h2>Nancy Lyons and Technology&#8217;s Dirty Little Secret</h2>\n<p>Since I don&#8217;t deal with clients or own an agency, many of the sessions at Prestige are non-applicable to my day job. However, there is one session in particular that resonated with me. <a href=\"http://www.nancylyons.com/\">Nancy Lyons</a>, founder and CEO of <a href=\"http://www.clockwork.net/\">Clockwork</a>, shared her philosophies on hiring and getting employees engaged. Happy employees do good work but what makes them happy?</p>\n<ul>\n<li>Autonomy:  Control over time, technique, team, or task.</li>\n<li>Mastery: Make progress and get better.</li>\n<li>Purpose: Be part of something bigger.</li>\n</ul>\n<p>A lot of the tips shared by Lyons are geared towards employers but they&#8217;re just as applicable to employees. The biggest danger to agencies and freelancers is the inability to have conversations with clients about what is and isn&#8217;t possible. According to Lyons, you can love someone and still tell them what they need to hear. One of the best tips she shared is to find and have fun at work as there&#8217;s nothing wrong with having fun.</p>\n<h2>Behind the Scenes of the Livestream</h2>\n<p>Prestige is <a href=\"http://prestigeconf.com/free-livestream-minneapolis-2015/\">known for having</a> a high quality livestream where more than 1,000 people can watch the conference live. The livestream is produced by <a href=\"http://pixpromedia.com/\">PixProMedia</a>. The gentleman in charge uses a TriCaster to switch between speakers and slides during sessions. Here are a couple of photographs of his equipment.</p>\n<a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses#gallery-47580-1-slideshow\">Click to view slideshow.</a>\n<p>According to some viewers, watching the livestream was like being at the conference but is not a substitute for face-to-face interactions.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">.<a href=\"https://twitter.com/jeffr0\">@jeffr0</a> The learning is like being there.  I miss the handshakes in the hallway, meeting people face-to-face.&#10;&#10;<a href=\"https://twitter.com/hashtag/prestigeconf?src=hash\">#prestigeconf</a></p>\n<p>&mdash; Cate DeRosia (@mysweetcate) <a href=\"https://twitter.com/mysweetcate/status/627924263799009280\">August 2, 2015</a></p></blockquote>\n<p></p>\n<h2>Westwerk Is a Great Venue for After Parties</h2>\n<p>The after party was held at <a href=\"http://westwerk.com/\">Westwerk</a>, a WordPress development agency and primary sponsor of the event. Their office was perfect for an after party as it includes, a foosball table, Nintendo Wii, shuffleboard, drinks, pool table, and small offices for private conversations. It&#8217;s one of the best after parties for a conference that I&#8217;ve attended.</p>\n<h2>Prestige is Serious Business</h2>\n<p>It may seem like a WordPress conference on the surface but Prestige is geared towards business minded people. It&#8217;s highly focused and filled with information you can apply to companies in and outside of WordPress. If you want to learn how to take your business to the next level, Prestige is an excellent value.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 20:40:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: How to Avoid This Embarrassing Sharing Bug on WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47476\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://wptavern.com/how-to-avoid-embarrassing-sharing-bug-on-wordpress-com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1804:\"<p>If you use the sharing feature on WordPress.com, you may have noticed an anomaly between your post title and what&#8217;s shared to social services. Since the post title is the first field to complete when writing a post, it makes sense to fill it in even if it&#8217;s a work in progress.</p>\n<p>The sharing module on WordPress.com has a bug where the initial text in a post title is used when sharing the post to social networks. For the past several months, I&#8217;ve published many articles on WordPress.com where the text within social links does not match the text used in the post title leaving me feeling embarrassed.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/BuginAction.png\"><img class=\"size-full wp-image-47477\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/BuginAction.png?resize=728%2C482\" alt=\"WordPress.com Bug in Action\" /></a>WordPress.com Bug in Action\n<p>To avoid this embarrassment, you&#8217;ll need to alter the text used in the sharing module before publishing each post. If you&#8217;re using the New Dash interface on WordPress.com, locate the Sharing metabox as seen in the screenshot above. When you&#8217;re ready to hit the publish button, change the text to match your title.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/TheCorrectPostTitle.png\"><img class=\"size-full wp-image-47478\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/TheCorrectPostTitle.png?resize=571%2C462\" alt=\"Post Title Matches the Sharing Text\" /></a>Post Title Matches the Sharing Text\n<p>I&#8217;ve spoken to several Automattic employees at various WordPress events and they&#8217;re aware of the bug. Until it&#8217;s fixed, you&#8217;ll need to remember to change the sharing text before you publish a post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jul 2015 21:52:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WPWeekly Episode 201 – Interview With Paul Gibbs and John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47469&preview_id=47469\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://wptavern.com/wpweekly-episode-201-interview-with-paul-gibbs-and-john-james-jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2500:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://byotos.com/\">Paul Gibbs</a> and <a href=\"http://jjj.me/\">John James Jacoby</a>. Jacoby shares what he learned and accomplished <a href=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\">working on bbPress and BuddyPress</a> full-time for six months.</p>\n<p>Gibbs explains his motivation to organize the first ever <a href=\"https://brighton.buddycamp.org/2015/\">BuddyCamp Brighton, UK</a>, that takes place on August 8th. We also discuss a new working group dedicated to possibly bringing back <a href=\"http://backpress.org/\">BackPress</a>. Last but not least, Gibbs and Jacoby offer their opinions on <a href=\"http://wptavern.com/meet-peepso-buddypress-newest-competitor-in-open-source-social-networking-for-wordpress\">PeepSo</a>, a new social networking plugin for WordPress.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">Philadelphia, PA to Host WordCamp US December 4th–6th</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/gallery-for-instagram/\">Instagram Gallery</a> displays a gallery from one or more Instagram accounts.</p>\n<p><a href=\"https://wordpress.org/plugins/backup-amazon-s3/\">Amazon S3 Backup and Restore</a> enables you to create full backups to Amazon S3 and restore, duplicate, clone, or migrate your site.</p>\n<p><a href=\"https://wordpress.org/plugins/responsivevoice-text-to-speech/\">ResponsiveVoice Text To Speech</a> is a HTML5 based text-to-speech library designed to add voice features to WordPress across all smart phone, tablet, and desktop devices. It supports 51 languages through 168 voices and has no dependencies.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 5th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #201:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jul 2015 19:45:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Hong Kong Morning\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45280\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/07/hong-kong-morning/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"<p><span class=\"embed-youtube\"></span></p>\n<p>The upside of jet lag, like <a href=\"http://om.co/2015/07/10/paris-je-laime/\">Om discovering the streets of Paris</a>, are enjoying parts of the day you might not normally be awake for, like a beautiful sun rise. Here&#8217;s a time lapse I made of the Victoria Harbor in Hong Kong taken from the incredible view I have in my room.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 23:40:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Postmatic Brings 100% Realtime Commenting to WordPress with Epoch Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=44317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wptavern.com/postmatic-brings-100-realtime-commenting-to-wordpress-with-epoch-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7876:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch.jpg?resize=919%2C443\" alt=\"epoch\" class=\"aligncenter size-full wp-image-47416\" /></a></p>\n<p>The team behind <a href=\"https://gopostmatic.com/\" target=\"_blank\">Postmatic</a> is aiming to breathe new life into WordPress native comments with the 1.0 release of <a href=\"https://wordpress.org/plugins/epoch/\" target=\"_blank\">Epoch</a> today. The plugin was created to provide a Disqus alternative with faster loading and submitting for comments.</p>\n<p>Epoch&#8217;s creators set an ambitious goal for themselves on the plugin&#8217;s description page:</p>\n<blockquote><p>The goal: To provide a realtime commenting/chat experience using fully native comments while being compatible with page caching, CDNs, mobile, other comment plugins, and SEO best practices.</p></blockquote>\n<p>The plugin submits comments via AJAX, which means that comments appear instantly within the conversation without refreshing the page. The experience is designed to be so fast that it blurs the line between commenting and chatting, as comments from other readers also show up automatically with the same speed. The video below shows the plugin in action and a <a href=\"https://gopostmatic.com/epoch/#reply-title\" target=\"_blank\">live demo of Epoch</a> is available on the Postmatic website.</p>\n<p></p>\n<p></p>\n<p>Epoch <a href=\"https://wordpress.org/plugins/epoch/changelog/\" target=\"_blank\">version 1.0</a> boasts compatibility with virtually any WordPress theme. The plugin will attempt to integrate with your theme via one of three ways:</p>\n<ul>\n<li>The first tries to continue using your existing comment template while still offering all the performance gains</li>\n<li>The second overrides your comment template but inherits typography and colors from your theme</li>\n<li>The third totally replaces your comment template à la Disqus or Jetpack Comments</li>\n</ul>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-theme-integration.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-theme-integration.png?resize=1025%2C839\" alt=\"epoch-theme-integration\" class=\"aligncenter size-full wp-image-47442\" /></a></p>\n<p>Unlike Postmatic, which has a <a href=\"https://gopostmatic.com/premium/\" target=\"_blank\">commercial option</a> for additional features, founder Jason Lemieux says Epoch will not be directly monetized.</p>\n<p>&#8220;We do not have any plans to create a commercial version,&#8221; he said. &#8220;Postmatic is our primary product, Epoch exists only to make it easier for people to move back to native commenting, and in turn to use Postmatic. Epoch will be free forever.&#8221;</p>\n<h3>Compatibility with Other Comment Plugins</h3>\n<p>Epoch works seamlessly with Postmatic, i.e. it will pop up an opt-in modal allowing the commenter to subscribe to new post notifications. Using Postmatic in combination with Epoch is not required, because the plugin was created to work well on its own. It&#8217;s also compatible with many other plugins that extend comments.</p>\n<p>&#8220;Other third party native commenting plugins have taken a heavy-handed approach and do not support the comment template hooks built into WordPress,&#8221; Lemieux said. &#8220;This creates a walled garden in which the innovation and hard work present in existing and future comment plugins is left out.</p>\n<p>&#8220;We decided to take a different approach. We built Epoch to be compatible with other comment plugins as much as possible. Not all are, but with little tweaks here and there they work just fine.&#8221;</p>\n<p>Version 1.0 integrates perfectly out of the box with Postmatic, WordPress Zero Spam, Akismet, WP Markdown, and WordPress Social Login.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-plugin-compatibility.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-plugin-compatibility.png?resize=1025%2C583\" alt=\"epoch-plugin-compatibility\" class=\"aligncenter size-full wp-image-47447\" /></a></p>\n<p>&#8220;In our testing most anything that does not use a lot of JavaScript works just fine,&#8221; Lemieux said. &#8220;Things I haven&#8217;t tested but I assume would work would be anything that modifies or adds fields to the comment form (Subscribe to Comments, CommentLuv, various captchas).</p>\n<p>&#8220;Fancier plugins that allow for comment editing or sorting the comment order based on voting would probably not be happy. We will have to make that functionality ourselves.&#8221;</p>\n<h3>Epoch is a Disqus Alternative with an Emphasis on Privacy</h3>\n<p>When Lemieux and his team created Epoch, the strategy was to address problems with native commenting in order to pave the way for more users to get on board with Postmatic.</p>\n<p>&#8220;We didn&#8217;t set out with intentions of competing with Disqus,&#8221; he said. &#8220;However, a few months in it became clear that there are usually two reasons people were not using native comments, and we would need to address both if we wanted widespread adoption of Postmatic.</p>\n<p>&#8220;The first is that the comment templates that come with a huge majority of themes just plain stink. Theme developers hate dealing with them. It&#8217;s usually an afterthought. So the commenting experience suffers. It is slow, ugly, and not at all fun.</p>\n<p>&#8220;The second reason is that native commenting is extremely hard on the server. You can&#8217;t run native comments on a high traffic site. The server would buckle. A CDN won&#8217;t save you because the page content is constantly changing. For larger sites, native commenting is not even an option.</p>\n<p>&#8220;Both of these problems are solved easily with solutions like Livefyre or Disqus, so they get installed. But it&#8217;s just selling your users down the river. Your data is not yours, ads start showing up on your site. Privacy is out the window. And really, the performance gains are minimal when the embedded comments still take 10 second to load because there is so much tracking JavaScript being queued up in the background.&#8221;</p>\n<p>In contrast, Epoch loads faster than third party solutions and is completely private. Your commenters&#8217; data is not farmed out and comments stay on your server.</p>\n<p>&#8220;For the first time someone can say this: running native WordPress commenting will actually increase your site performance,&#8221; Lemieux said.</p>\n<h3>What&#8217;s on the roadmap for the future of Epoch?</h3>\n<p>Lemieux and his team hope to attract a larger community around the project, which is <a href=\"https://github.com/postmatic/epoch\" target=\"_blank\">open to contribution on GitHub</a>.</p>\n<p>&#8220;We plan on aggressively recruiting others to join the project and we hope other developers will be inspired by what we have started,&#8221; he said.</p>\n<p>&#8220;We are going to build out a small API to make it easier for other plugins to hook into some of the advanced functionality.</p>\n<p>&#8220;And there are a few things that feel like they may be necessary: comment voting and a simple little like button which would be handy as a way to say, &#8216;I appreciate what you said, I do not have anything else to add.&#8217; I would love to integrate that with Postmatic. I often will get a comment in my inbox and I want to recognize the thought that went into it, but don&#8217;t feel like I have anything to add. A simple little +1 would do it nicely,&#8221; Lemieux said.</p>\n<p>The 1.0 release of Epoch is exciting news for those who have been dissatisfied with WordPress native comments but are hoping for a reason to return. The plugin is open source and <a href=\"https://wordpress.org/plugins/epoch/\" target=\"_blank\">available for free on WordPress.org</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 17:45:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: Yuuta: A Free Visual Diary Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47303\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://wptavern.com/yuuta-a-free-visual-diary-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4045:\"<p>Earlier this month, <a href=\"http://wptavern.com/new-proposal-on-trac-to-remove-post-formats-from-wordpress-core\" target=\"_blank\">a new proposal landed on trac</a>, advocating the removal of <a href=\"http://codex.wordpress.org/Post_Formats\" target=\"_blank\">post formats</a> from core. Many believe that this feature would be better as a plugin, since it has received little improvement over the years and is not used by the majority of WordPress users.</p>\n<p>If the UI can be improved to be less confusing and theme support is standardized, post formats may have a chance at more widespread adoption. The feature is entirely dependent on theme support, as post formats are not enabled by default unless the theme author opts to include them. Many still do, which is why ripping them out of core in favor of a plugin would be a major undertaking.</p>\n<p>One of the most common use cases for post formats is a diary style WordPress theme. <a href=\"https://wordpress.org/themes/yuuta/\" target=\"_blank\">Yuuta</a> is a relatively popular theme on WordPress.org that revolves entirely around post formats. In the past four months, it has been downloaded more than 7,000 times. Yuuta was created to serve as a visual diary and includes support for all nine of WordPress&#8217; post formats.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta.png?resize=880%2C660\" alt=\"yuuta\" class=\"aligncenter size-full wp-image-47392\" /></a></p>\n<p>The theme was designed by Felix Dorner, owner of <a href=\"http://drnr.co/\" target=\"_blank\">Studio DRNR</a>, a Berlin-based web development company. According to its description page, Yuuta was selected as the the theme&#8217;s name based on its Japanese meaning:</p>\n<blockquote><p>Yuuta is a Japanese name and is made up of 優 (yuu) “gentleness, superiority”, 悠 (yuu) “distant, leisurely” or 勇 (yuu) “brave” combined with 太 (ta) “thick, big”.</p></blockquote>\n<p>Each post format has its own distinguishing icon and unique display. Dorner opted to use Roboto, Roboto Slab, and a sprinkling of Courier as the theme&#8217;s primary fonts. The typography choices were selected for optimal readability on all screen sizes.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-chat-format.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-chat-format.jpg?resize=961%2C526\" alt=\"yuuta-chat-format\" class=\"aligncenter size-full wp-image-47405\" /></a></p>\n<p>Yuuta also includes specific styles for both standard and Jetpack-enabled galleries.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-jetpack-enabled-gallery.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-jetpack-enabled-gallery.jpg?resize=652%2C572\" alt=\"yuuta-jetpack-enabled-gallery\" class=\"aligncenter size-full wp-image-47407\" /></a></p>\n<p>The theme&#8217;s design is fairly set, unless you opt to create a child theme. There are zero options in the Customizer. Much of the design customization is done on a post-by-post basis, as the featured image serves as a unique background for the post. Yuuta also includes editor styles to match the editing experience to the theme&#8217;s frontend appearance.</p>\n<p>The primary navigation menu is hidden until toggled into view by the icon in the header, which keeps the reader focused on the content. There are no sidebars to contend with but widgets can be added to the footer.</p>\n<p>If you&#8217;re a fan of post formats, the Yuuta theme really makes them shine. It responds to display beautifully on all devices from desktop to tablet to smartphone. Check out a <a href=\"http://demo.felixdorner.com/yuuta/\" target=\"_blank\">live demo</a> on Dorner&#8217;s website to see each post format in action. You can download <a href=\"https://wordpress.org/themes/yuuta/\" target=\"_blank\">Yuuta</a> for free from WordPress.org or install it via your admin themes browser.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 04:06:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Awesome Geek Podcasts: A Curated List of Tech Podcasts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/awesome-geek-podcasts-a-curated-list-of-tech-podcasts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2834:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/headphones.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/headphones.jpg?resize=960%2C482\" alt=\"photo credit: Jan Vašek\" class=\"size-full wp-image-47389\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3YOVALG5DX\">Jan Vašek</a>\n<p>The WordPress community produces a couple dozen high quality podcasts covering diverse topics, such as weekly news, business/entrepreneurship, education, and development. Every year the best WordPress-related podcasts are featured in <a href=\"http://iamdavidgray.com/best-wordpress-podcasts/\" target=\"_blank\">roundup posts</a> highlighting shows that are publishing new episodes regularly.</p>\n<p>One way to venture outside the WordPress world is to expand your horizons when it comes to podcast subscriptions. <a href=\"https://github.com/cv/awesome-geek-podcasts\" target=\"_blank\">Awesome Geek Podcasts</a> is a curated list of tech podcasts that was first published in May of this year on GitHub. Since that time the repository has received 121 commits from 34 contributors.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/awesome-geek-podcasts.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/awesome-geek-podcasts.png?resize=1025%2C551\" alt=\"awesome-geek-podcasts\" class=\"aligncenter size-full wp-image-47382\" /></a></p>\n<p>None of the podcasts listed in the repo are directly related to WordPress, but many cover topics related to the various technologies that work in and with WordPress. The list includes approximately seven PHP-related podcasts in English (and more in other languages), along with shows focused on JavaScript, Sass, Git, and other technologies.</p>\n<p>Other topics included in the Awesome Geek Podcasts list that might be of interest to WordPress developers include:</p>\n<ul>\n<li>Running software companies</li>\n<li>Software design, creation, and delivery</li>\n<li>Front end web design, development, and UX</li>\n<li>Typography, design, prototyping</li>\n<li>Open source software</li>\n<li>Family and life/work balance</li>\n</ul>\n<p>Several of those listed follow a short format of 5 and 10-minute episodes for developers who are short on time. No matter where your interests lie in the various aspects of &#8220;geek life,&#8221; the Awesome Geek Podcast list has something for everyone.</p>\n<p>Currently the list has separate sections for shows in English, Portuguese, Spanish, Russian, Persian, and Swedish, but it is open to contribution. Although it doesn&#8217;t seem to include many podcasts that focus on specific CMS platforms, you can try <a href=\"https://github.com/cv/awesome-geek-podcasts/blob/master/CONTRIBUTING.md\" target=\"_blank\">submitting a pull request</a> for the inclusion of your WordPress-related podcast.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 20:58:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Behind the Scenes of WordPress 4.2.3 With Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47354\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/behind-the-scenes-of-wordpress-4-2-3-with-gary-pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2253:\"<p>When <a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\">WordPress 4.2.3 was released</a> last week, not only did it patch a critical security vulnerability, but also <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\">adversely impacted</a> a number of sites. Changes to the Shortcode API which were necessary as part of the patch caused some plugins that rely on the API to break. These changes were not immediately communicated to plugin developers. Nearly eight hours after its release, a <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/\">post published</a> on the Make WordPress Core blog explained the changes.</p>\n<p>The release process of WordPress 4.2.3 left <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites#comments\">plugin authors and users</a> scratching their heads. On one hand, point releases are not supposed to break anything. On the other, affected plugin authors were left in the dark for nearly eight hours wondering why a point release broke their plugins.</p>\n<p><a href=\"http://pento.net/\">Gary Pendergast</a> who works for Automattic, is a WordPress core contributor, and a member of the WordPress core security team, reached out to me for an interview. In the following conversation, we discuss what happened behind the scenes before 4.2.3 was released.</p>\n<p>He clears up some confusion on when the changes to the Shortcode API were implemented. He also admits the team made some mistakes and has already implemented changes to improve the release process. One of those changes includes publishing a post on the Make WordPress Core blog as soon as the update is pushed out to sites.</p>\n<p>I appreciate and thank Pendergast for reaching out to me to have this conversation. I look forward to similar collaborations with members of the core team in the future. A transcription of this interview is not available but if you have it transcribed and would like to make it available to the public, please <a href=\"http://wptavern.com/contact-me\">contact me</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 19:02:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WordPress Theme Review Team Votes to Allow Themes to Use the REST API Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47342\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://wptavern.com/wordpress-theme-review-team-votes-to-allow-themes-to-use-the-rest-api-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3363:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/colored-pencils.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/colored-pencils.jpg?resize=960%2C470\" alt=\"colored-pencils\" class=\"aligncenter size-full wp-image-42610\" /></a></p>\n<p>During this week&#8217;s WordPress Theme Review Team meeting, members considered the possibility of allowing themes hosted in the directory to make use of the <a href=\"https://wordpress.org/plugins/rest-api/\" target=\"_blank\">WP REST API plugin</a>. Since the API is not yet included in core, any theme or plugin author who wants to use it must have the feature plugin installed.</p>\n<p>Ordinarily, WordPress.org themes are not allowed to require a plugin on installation (although they can suggest one). As per the <a href=\"https://make.wordpress.org/themes/handbook/review/required/#plugins\" target=\"_blank\">Theme Review Handbook on plugins</a>: <em>A theme can recommend plugins but not include those plugins in the theme code.</em></p>\n<p>&#8220;The core team has asked us to consider temporarily allowing the requirement of the REST API for themes that may take advantage of it,&#8221; Tammie Lister said before calling for a vote. She also noted that waiving the rule would be temporary, as the API will soon be going into core.</p>\n<p>&#8220;This does not open up the way for others as an exception because it&#8217;s a core feature,&#8221; she said.</p>\n<p>The team took a quick vote and all present unanimously agreed to allow themes to require the REST API plugin as a temporary measure until it is available in core. Check out the <a href=\"https://make.wordpress.org/themes/2015/07/28/theme-review-team-weekly-meeting-notes-the-logs-7/\" target=\"_blank\">meeting logs</a> for the full discussion.</p>\n<p>The WP REST API is already being used in production in many different ways around the web, as revealed in the comments on project leader Ryan McCue&#8217;s recent <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">post</a> calling for examples. If the Theme Review Team wants to keep pace with where WordPress is headed, it must offer the flexibility to allow for more innovative themes. Temporarily waiving the guideline against plugin requirements is a smart move.</p>\n<p>As WordPress.org accrues more examples of themes that use the REST API in a way that complies with the review team&#8217;s high standards, developers who are just getting started will have strong examples for creating their own. Jack Lenox&#8217;s presentation at WordCamp London this year highlighted a few of the benefits of theming with the REST API:</p>\n<ul>\n<li>Provides a way to retrieve pure data (usually in JSON or XML format) over HTTP</li>\n<li>No loops necessary</li>\n<li>Good for mobile apps and environments where you don’t want a full webpage to render but want content from a blog or site</li>\n</ul>\n<p>With the official directory now welcoming these types of themes, it won&#8217;t be long before the entire landscape of WordPress theme development changes to support more modern ways of presenting content. Check out Jack Lenox&#8217;s presentation on <a href=\"http://wptavern.com/jack-lenox-on-building-themes-with-the-wp-rest-api\" target=\"_blank\">Building themes with the WP REST API</a> for information on how to get started.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 17:30:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Post Status: Don’t make enemies, invest in friendships\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=13860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://poststatus.com/invest-in-friendships/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4756:\"<p><em>Editor&#8217;s note: The following is a guest post by <a href=\"http://corymiller.com/about/\">Cory Miller</a>, the CEO of <a href=\"https://ithemes.com\">iThemes</a>. Cory describes his approach to making friends and avoiding making enemies. You should also check out his recent <a href=\"http://corymiller.com/my-talk-on-mental-health-and-entrepreneurship-is-now-online/\">talk on mental health and entrepreneurship</a>, which is terrific.</em></p>\n<p>I’d rather wave a white flag and compromise than make an enemy. Every. Single. Day.</p>\n<p>I’ve purposefully and intentionally, throughout my life (and business), sought to <em>not</em> make enemies, but rather build friendships.</p>\n<ul>\n<li>Enemies are only trouble.</li>\n<li>Enemies are distractions.</li>\n<li>Enemies eat my time and energy and focus.</li>\n<li>Enemies seek your destruction.</li>\n<li>Enemies oppose you.</li>\n<li>Enemies seek to “harm or weaken” you.</li>\n</ul>\n<p>Friends do the opposite.</p>\n<p>My best example of this is my wife, Lindsey. I think of her as my greatest ally and my best friend. She’s the opposite of an enemy.</p>\n<p>The words I use to describe her are “caring,” “supportive,” “loving,” and “wants my best.”</p>\n<p>So why would I spend my time seeking to <em>create</em> enemies, instead of friendships?</p>\n<ul>\n<li>You can have opinions.</li>\n<li>You can take stands.</li>\n<li>You can and should draw boundary lines.</li>\n<li>You can have your principles and <em>never</em> budge on them.</li>\n</ul>\n<p><em>But,</em> you can also, simultaneously, choose to make and focus on friendships.</p>\n<p>Some of my best friendships have come through business, and some of them would be considered “competitors.”</p>\n<p>But I’ve cherished those friendships.</p>\n<p>Additionally, I sleep better at night knowing we only want each other’s best and that there is plenty of room for each other instead of someone actively, purposefully seeking my destruction.</p>\n<p>But instead of seeking to fester anger and hate and competition, I’ve sought the opposite, asking, &#8220;Where can we find ways to help each other do better for each other?&#8221;</p>\n<p>So what if we approached life and business like this:</p>\n<p>Instead of using that anger, bile, jerk-ness, and negative energy in telling the world who you hate and how big of a jerk you can be, and how you don’t want to be an enemy of &#8212; why not seek to build true, lasting, deep friendships?</p>\n<p>The old quote, “Keep your friends close, and your enemies closer,” is pure B.S.</p>\n<p>Why not create a friend instead of nurture an enemy?</p>\n<p>Why not tell the world that you can be the <em>best</em> friend they ever made? And prove it by your actions.</p>\n<p>Friendships do take an investment. They take consistency. They take time. They take compromise sometimes. It means showing up for them when they most need it.</p>\n<p>But those relationships have been some of the richest relationships I’ve ever had. And totally worth the investment (multiple times over and over in fact).</p>\n<p>And yes, I have made enemies in my life. Purposefully and sometimes not. In fact, someone recently asked me jokingly on Twitter who didn’t like me. I responded with:</p>\n<p>“I can think of 1 or 2 a-holes but I don’t like thinking about them. <img src=\"https://poststatus.com/wp-includes/images/smilies/simple-smile.png\" alt=\":)\" class=\"wp-smiley\" /> hahahahaha”</p>\n<p>And although that’s sadly true, I’ve sought to minimize the enemies I’ve made in my life and business.</p>\n<p>My perspective on making necessary enemies is that <em>if</em> you <em>have</em> to make an enemy &#8212; and when I say that, I don’t mean because your personality defaults to that of a jerk and you sadistically like being labeled one), but you <em>have</em> to make an enemy because you have to set a boundary and tell someone no, or take a legal action &#8212; make dang sure it’s either for a <em>very</em> good purpose, value or strategic reason.</p>\n<p>And even then, question yourself about why.</p>\n<p>As my attorney told me recently: “You catch more flies with honey.”</p>\n<p>So don’t be a jerk while making enemies. You’ll make <em>more</em> enemies in the process.</p>\n<p>Simple, lip-biting kindness in the face of anger and hate and bile helps deflate a situation rather than pour lighter fluid on it.</p>\n<p>I tell people often: it doesn’t cost me anything to be nice and kind. (In fact most of the time it makes me happier.) And I seek out different avenues to vent my frustration and relieve my stress.</p>\n<p>So I say: Don’t make enemies. Invest in friendships.</p>\n<p>It should be common sense, but sometimes I (and maybe you) need a reminder.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 05:13:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Cory Miller\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: Adler: A Unique Personal Blogging Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47272\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/adler-a-unique-personal-blogging-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3395:\"<p>If you&#8217;re on the hunt for a new WordPress blogging theme but the designs are all starting to look too similar, you may want to check out <a href=\"https://wordpress.org/themes/adler/\" target=\"_blank\">Adler</a>. It is one of the more unique themes to land in the WordPress.org directory in recent months with its uncommon typography choices and bright bursts of color.</p>\n<p>Adler was created by Romanian theme designer <a href=\"https://twitter.com/BabBarDeL\" target=\"_blank\">George Olaru</a> of <a href=\"https://pixelgrade.com/\" target=\"_blank\">Pixelgrade</a>. Olaru takes a unique approach to the popular fullscreen splash page style that many themes have adopted for a homepage layout, overlaying it with a serif font title paired with a hand-script style subtitle.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler.png?resize=880%2C660\" alt=\"adler\" class=\"aligncenter size-full wp-image-47315\" /></a></p>\n<p>Styling for single posts is similar to the home page with the featured image serving as a fullscreen background for the title. Scroll further down and the post content is centered with no distracting sidebar widgets.</p>\n<p>Adler combines two unusual Google font choices in the design: Droid Sans Mono for paragraph text and Permanent Marker for blockquotes and subtitles. Images in posts overhang the text column to create a strong visual impact.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler-images-blockquotes.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler-images-blockquotes.jpg?resize=810%2C812\" alt=\"adler-images-blockquotes\" class=\"aligncenter size-full wp-image-47318\" /></a></p>\n<p>Adler&#8217;s files include a tiny leaf icon that is tastefully applied on the home and archive templates to separate posts. The effect is minimalist without appearing to be stark. The theme also includes support for Font Awesome icons.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/font-awesome.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/font-awesome.jpg?resize=656%2C534\" alt=\"font-awesome\" class=\"aligncenter size-full wp-image-47320\" /></a></p>\n<p>The necessity for large featured images can sometimes be a drawback for users when selecting a blogging theme. After testing Adler, I found that the design doesn&#8217;t break if you don&#8217;t have a large featured image assigned to a post. In fact, posts lacking a featured image look just as nice as those that include one, so you&#8217;re not tied down to hunting for one every time you publish.</p>\n<p>Adler supports three menu locations for a primary, footer, and social menu. It includes support for one footer widget area, which spans three columns. There are just two options available in the native customizer that allow you to change the background color or add a background image.</p>\n<p>Adler was created to be a personal blogging theme and the design instantly communicates: &#8220;I have something to say.&#8221; Check out the <a href=\"https://pixelgrade.com/demos/adler/\" target=\"_blank\">live demo</a> on Pixelgrade.com to see it in action. If you like what you see, you can <a href=\"https://wordpress.org/themes/adler/\" target=\"_blank\">download Adler</a> for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 01:09:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: New WordPress Plugin Automates Slack Team Invitations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47267\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/new-wordpress-plugin-automates-slack-team-invitations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4403:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg?resize=700%2C314\" alt=\"slack-logo\" class=\"aligncenter size-full wp-image-33466\" /></a></p>\n<p>Generating Slack team invitations can become rather tedious when you&#8217;re managing a large group of people &#8211; particularly when the team is open to almost anyone. In the case of a company or organization, a Slack admin can use the feature that permits anyone with an email from a specified domain to be accepted on signup. However, this feature isn&#8217;t applicable to teams that are made up of people with diverse email domains and associations.</p>\n<p><a href=\"http://boiteaweb.fr/\" target=\"_blank\">Julio Potier</a>, a French security consultant and prolific <a href=\"https://profiles.wordpress.org/juliobox/\" target=\"_blank\">plugin developer</a>, created a solution for this particular scenario. As an admin on the <a href=\"https://wordpressfr.slack.com/\" target=\"_blank\">WordPressFR.slack.com</a> team, which is open to all French WordPress users, he needed a more convenient way to allow new signups. The team has 27 channels and 250+ members with 200 added in the first week.</p>\n<p>Julio decided to create a plugin to make the invitation process easier in the future. The new <a href=\"https://wordpress.org/plugins/lazy-invitation/\" target=\"_blank\">Slack Lazy Invitation</a> plugin automates the sending of Slack team invitations by adding a frontend signup on your WordPress site.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/join-slack-team.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/join-slack-team.png?resize=404%2C405\" alt=\"join-slack-team\" class=\"aligncenter size-full wp-image-47285\" /></a></p>\n<p>The user simply enters an email address and the invitation is sent. A Slackbot confirmation will appear on the page.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-team-invite-sent.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-team-invite-sent.png?resize=365%2C253\" alt=\"slack-team-invite-sent\" class=\"aligncenter size-full wp-image-47286\" /></a></p>\n<p>To configure the plugin for your Slack team all you need to do is enter the group name and the security token for your Slack invitations. As this token is not easy to find, Julio wrote a bookmarklet that will automatically capture it for you. From the plugin&#8217;s settings page you can drag and drop the bookmarklet into your browser toolbar on the invitation page found at: <code>https://YOURGROUP.slack.com/admin/invites</code>.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/lazy-slack-settings.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/lazy-slack-settings.png?resize=782%2C439\" alt=\"lazy-slack-settings\" class=\"aligncenter size-full wp-image-47295\" /></a></p>\n<p>Once the plugin is configured, the invitation signup page will be available at <code>example.com/wp-login.php?action=slack-invitation</code>. If you&#8217;re using either the <a href=\"https://wordpress.org/plugins/wp-recaptcha/\" target=\"_blank\">wp-reCaptcha</a> or <a href=\"https://wordpress.org/plugins/google-captcha/\" target=\"_blank\">google-captcha</a> plugins, Slack Lazy Invitation will automatically add protection to the form.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-invite-recaptcha.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-invite-recaptcha.jpg?resize=350%2C481\" alt=\"slack-invite-recaptcha\" class=\"aligncenter size-full wp-image-47292\" /></a></p>\n<p>The plugin also includes support for the <a href=\"https://wordpress.org/plugins/sf-move-login/\" target=\"_blank\">SF Move Login</a> plugin, so that the invitation form is available at /slack-invitation instead of the much longer URL. This slug can be changed in the SF Move Login settings panel.</p>\n<p>In the future Julio plans to add support for adding invite pages for multiple groups. I tested <a href=\"https://wordpress.org/plugins/lazy-invitation/\" target=\"_blank\">Slack Lazy Invitation</a> and found that it works exactly as advertised. If you have a large Slack team with open invites, this plugin will save you quite a bit of time. Download it for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jul 2015 22:30:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"WPTavern: Meet PeepSo: BuddyPress’ Newest Competitor in Open Source Social Networking for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46711\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://wptavern.com/meet-peepso-buddypress-newest-competitor-in-open-source-social-networking-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10255:\"<p>When the first <a href=\"https://buddypress.org/2008/12/buddypress-10b1-components/\" target=\"_blank\">BuddyPress beta</a> arrived on the scene in 2008, there was nothing like it for WordPress. Facebook was still relatively new to the public and Twitter was just a couple years old. A plugin that transformed WordPress into a social network was an exciting prospect.</p>\n<p>After seven years of virtually unchallenged dominance among WordPress social networking plugins, BuddyPress has a new competitor. <a href=\"http://www.peepso.com/\" target=\"_blank\">PeepSo</a>, trademarked <em>&#8220;Your people. Your community. Your way,&#8221;</em> is the newest contender in WordPress&#8217; open source social networking plugin niche.</p>\n<p>Unlike <a href=\"https://buddypress.org/\" target=\"_blank\">BuddyPress</a>, which for the most part has improved slowly through community contribution, the <a href=\"http://www.peepso.com/\" target=\"_blank\">PeepSo</a> project is run more like a startup and is 100% self-funded. It is currently being marketed as an alternative to BuddyPress.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">You\'ve been asking for it. An alternative to BuddyPress. It\'s here! <a href=\"http://t.co/Uxd7AQcnCL\">http://t.co/Uxd7AQcnCL</a> <a href=\"https://twitter.com/hashtag/wordpress?src=hash\">#wordpress</a> <a href=\"https://twitter.com/hashtag/buddypress?src=hash\">#buddypress</a> <a href=\"http://t.co/yYRI5pnXJR\">pic.twitter.com/yYRI5pnXJR</a></p>\n<p>&mdash; peepso (@peepsowp) <a href=\"https://twitter.com/peepsowp/status/623768949943984128\">July 22, 2015</a></p></blockquote>\n<p></p>\n<p>The <a href=\"https://wordpress.org/plugins/peepso-core/\" target=\"_blank\">PeepSo plugin</a>, available on WordPress.org, offers many of the same <a href=\"http://www.peepso.com/pricing/\" target=\"_blank\">core features</a> as BuddyPress but was launched with a collection of commercial add-on plugins for things like photos, videos, moods, tagging, locations, friends, and messages. A groups feature is noticeably absent from Peepso but <a href=\"http://www.peepso.com/roadmap/\" target=\"_blank\">planned for version 1.4</a>. Current extensions seem to focus primarily on adding multimedia features to the activity stream.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/peepso-profile.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/peepso-profile.png?resize=1025%2C769\" alt=\"peepso-profile\" class=\"aligncenter size-full wp-image-47235\" /></a></p>\n<h3>Who is Behind PeepSo?</h3>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/merav-peepso.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/merav-peepso.jpg?resize=225%2C300\" alt=\"merav-peepso\" class=\"alignright size-medium wp-image-47241\" /></a>PeepSo was founded by <a href=\"https://about.me/meravknafo\" target=\"_blank\">Merav Knafo</a>, owner of <a href=\"http://www.jomsocial.com/\" target=\"_blank\">JomSocial</a>, Joomla&#8217;s most popular social networking solution. Knafo, a veteran in the Joomla community, brings a unique perspective on the differences between the Joomla and WordPress markets for social networking software. As <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">Joomla captures roughly 7% to WordPress&#8217; 60% of the CMS market share</a>, Knafo saw an opportunity to break into a larger market.</p>\n<p>&#8220;As a business owner, it’s my job to pay attention to trends in my industry and unfortunately, Joomla has been on a downward trend since 2009,&#8221; Knafo said.</p>\n<p>&#8220;Many of our JomSocial customers have asked us to &#8216;make JomSocial for WordPress,&#8217; because they wanted to switch to WordPress but there was nothing like JomSocial for WordPress. Finally, I could not ignore the trend nor the requests and decided to get into the WordPress market as well.&#8221;</p>\n<p>Knafo hopes to parlay her experience with JomSocial into her new venture with PeepSo.</p>\n<p>&#8220;We stuck with Joomla for almost 10 years now and took JomSocial to a whole new level when we took over in 2013,&#8221; she said. &#8220;I am very proud of what we’ve accomplished with JomSocial and super excited to implement all this experience and knowledge into PeepSo.&#8221;</p>\n<h3>How PeepSo Got Started</h3>\n<p>The idea for PeepSo was incubating for a few years before Knafo had the opportunity to execute it.</p>\n<p>&#8220;Brad Bihun used to be a customer of ours at <a href=\"http://www.ijoomla.com/\" target=\"_blank\">iJoomla</a>, and then he switched to WordPress,&#8221; she said. &#8220;We happened to live very close to each other in Encinitas, California, so we met up and suggested I’d created &#8216;JomSocial for WordPress.&#8217;</p>\n<p>&#8220;At that time, I didn’t even own JomSocial and I was too busy with all the iJoomla products. Then a couple of years later, I acquired JomSocial and he approached me again, but once again, I was just too busy. A year and a half into JomSocial acquisition, when things got a lot smoother, I finally said yes, he introduced me to the <a href=\"http://spectromtech.com/\" target=\"_blank\">SpectrOM</a> team, and we got started.&#8221;</p>\n<p>Although the plugin appears to be marketed as a direct competitor to BuddyPress, Knafo said that it wasn&#8217;t created specifically for that purpose but rather to give WordPress users a more robust array of options for building networks.</p>\n<p>&#8220;Obviously we felt there was a need for another product as an alternative to BuddyPress,&#8221; she said. &#8220;Leaving users with just one option is rarely a good idea, people like options.</p>\n<p>&#8220;We don’t necessarily plan to take on BuddyPress, we just want to offer those who want an alternative, a product that is of high quality and that is being continuously developed. Ultimately, people will choose the solution that serves them best. We are just getting started, but we have big plans and an excellent track record doing this successfully with Joomla.&#8221;</p>\n<h3>The Differences Between PeepSo and BuddyPress</h3>\n<p>I asked Knafo what her team perceives to be the most notable differences between PeepSo and its more established competitor, based on what they found to be lacking in BuddyPress.</p>\n<p>&#8220;I’d say the look and feel is a lot more modern in PeepSo right off the bat with no special themes needed,&#8221; she said. &#8220;The features are more up-to-date with the latest and greatest features of big social networks, such as Facebook &#8211; from cover photos to &#8216;likes&#8217; and so on.&#8221;</p>\n<p>BuddyPress core developers have opted to leave the aforementioned features to separate third-party plugins as opposed to packing them into core. With certain features, i.e. photos and videos, PeepSo does the same, except the add-ons are supported by PeepSo core developers.</p>\n<p>&#8220;PeepSo is lightweight and allows you to only add features that you need, to keep it lightweight,&#8221; Knafo said. &#8220;PeepSo’s code is so beautiful it made our developers shed tears of joy when they first saw it &#8211; that said, I never looked at BuddyPress’s code, nor would I be able to tell whether it’s beautiful or not.&#8221;</p>\n<p>In terms of code differences, PeepSo&#8217;s development team cited what they believe to be a few major differences between their <a href=\"https://github.com/wp-plugins/peepso-core\" target=\"_blank\">codebase</a> and BuddyPress:</p>\n<ul>\n<li>All object oriented &#8211; from the PHP to the Javascript</li>\n<li>Built with a templating engine similar to what you see in shopping cart systems. This allows use with virtually any theme.</li>\n<li>The JavaScript uses an extension mechanism, allowing add-ons to extend the abilities of the postbox.</li>\n<li>We made the database queries as optimized as possible to allow for greater scalability.</li>\n</ul>\n<p>&#8220;We have a track record creating and supporting a very large social networking application (JomSocial),&#8221; Knafo told the Tavern. &#8220;We know the ins and out of this business. We may be new to WordPress, but we are veterans when it comes to social networking applications.&#8221;</p>\n<h3>Where is PeepSo Headed?</h3>\n<p>The PeepSo development team, guided by lead architect <a href=\"https://twitter.com/davejesch\" target=\"_blank\">Dave Jesch</a> of <a href=\"http://spectromtech.com/\" target=\"_blank\">SpectrOM</a>, has an aggressive <a href=\"http://www.peepso.com/roadmap/\" target=\"_blank\">roadmap</a> for improving the plugin&#8217;s core and adding more features via commercial plugins.</p>\n<p>&#8220;Our main goal is to add more plugins to PeepSo, you can see our road map here. We’ll start with a chat plugin, custom profile fields and then groups, events, pages and so forth,&#8221; Knafo said. The team also hopes to partner with other developers who want to create PeepSo plugins.</p>\n<p>I asked her if the team plans to create a hosted PeepSo platform for community managers. Knafo said it isn&#8217;t totally out of the question but isn&#8217;t high on the priority list at the moment.</p>\n<p>&#8220;We tried to do this with JomSocial but we had a hard time finding the right hosting solution for it,&#8221; she said. &#8220;That said, we are open to the idea, a bit down the road.&#8221;</p>\n<p>PeepSo is just getting started and has not yet attracted many customers. However, Knafo&#8217;s experience of successfully running an open source project for the past 10 years has given her the determination to break into a new and unfamiliar market.</p>\n<p>&#8220;The sales have been as can be expected this early after the initial release, not too shabby to start with but we expect whole lot more sales as the WordPress users become aware of PeepSo, download the free version and give it a try,&#8221; she said.</p>\n<p>&#8220;We’re here for the long haul and we take no shortcuts in doing this right. We know it’s a huge undertaking; there is so much more to do. I am confident that investing in WordPress was the right move, I’ve been very pleased by the feedback and the community. My hope is that WordPress developers will join us and create awesome plugins to take PeepSo to the next level.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 22:50:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Only 70 Tickets Remain to Livestream Prestige for Free August 1-2, 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47208\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://wptavern.com/only-70-tickets-remain-to-livestream-prestige-for-free-august-1-2-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4855:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/08/PrestigeConfLogo.png\"><img class=\"alignright size-full wp-image-27630\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/08/PrestigeConfLogo.png?resize=275%2C233\" alt=\"Prestige Conference Logo\" /></a>With just a few days remaining before <a href=\"http://prestigeconf.com/\">Prestige takes place</a>, there are only 70 tickets left to watch the event for free. Courtesy of <a href=\"http://www.rocketgenius.com/\">Rocketgenius</a>, the event&#8217;s primary sponsor, more than 500 people will be watching the event for free this weekend. To watch the event for <del>free, use the code <strong>GravityFormsLS </strong></del>when <a href=\"http://prestigeconf.com/tickets/\">purchasing a streaming ticket</a>.</p>\n<p>Free tickets are sold out. However, entering the code <strong>PrestigeStream</strong> when <a href=\"http://prestigeconf.com/tickets/\">purchasing a streaming ticket</a>, will take 50% off the price</p>\n<p>Prestige is a conference founded by Kiko Doran and Josh Broton in 2014 that focuses on the business aspects of WordPress. The first event was held in Minneapolis, MN, in October of 2014. Earlier this year, Prestige was held in Las Vegas, NV. This weekend marks the third time the conference will be held.</p>\n<h2>The Future of Prestige</h2>\n<p>The first and second conference had approximately 100 attendees and Doran expects the same amount this weekend. However, future iterations of Prestige will have lower attendance. &#8220;We are transitioning to more of an online event. We’re actually going to make the in-person events smaller moving forward.&#8221; Doran told the Tavern.</p>\n<p>There&#8217;s also a chance the conference could morph into something completely different. &#8220;After organizing two WordCamps, I figured out some of the things I loved about them and some of the things I don&#8217;t. Prestige has given me the freedom to try new things and see what people like and what they don’t like,&#8221; Doran said.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/PrestigeinVegas.jpg\"><img class=\"wp-image-47216 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/PrestigeinVegas.jpg?resize=1025%2C576\" alt=\"Prestige in Las Vegas Nevada\" /></a>Prestige in Las Vegas, NV Image courtesy of <a href=\"https://www.happyjoe.org/prestige-conference-las-vegas-2015/\">James Dalman</a>\n<p>Although the conference has been held twice this year and in different cities, the organizing team plans to host at least one Prestige conference in Minneapolis every year. Talks are underway for the next event but details are not locked down.</p>\n<p>&#8220;We plan to do one in Minneapolis every year because we love the community there. We’d like to do Minneapolis in the summer time, due to weather, then we’d like to do any winter events in a warm place,&#8221; Doran said.</p>\n<p>Organizing a conference is a challenging experience that benefits from having motivated organizers. Doran explains what motivates him to organize Prestige, sometimes twice a year.</p>\n<p>&#8220;I have a small awesome team of organizers that love putting this event on. That and the people who come and share their knowledge. It’s a smaller event but to me, that&#8217;s the appeal of it. Everyone is far more approachable in this environment,&#8221; he said.</p>\n<h2>A First for Prestige</h2>\n<p>This weekend&#8217;s event features a hands-on workshop by Jennifer Bourn of <a href=\"http://www.bourncreative.com/\">Bourn Creative</a>. It&#8217;s the first session in Prestige&#8217;s young history to involve hands-on exercises. The session is uncharted territory for the conference which has mostly focused on people sharing their experiences building  businesses.</p>\n<h2>How Long Will Doran Organize Prestige?</h2>\n<p>With this being his third conference, I asked Doran how long does he plan to continue organizing Prestige, &#8220;I’ll organize the conference as long as there is a demand for the content. People often say to scratch your own itch. This conference started off as a little self-serving in that I wanted to ask people all of these questions. Then I thought, couldn’t others benefit from this information as well?&#8221; he replied.</p>\n<h2>I&#8217;ll Be at Prestige Conference</h2>\n<p>I&#8217;ll be among the 100 expected attendees at this weekends conference. If you&#8217;re attending the event, please stop me and say hi. If not, make sure you grab one of the <a href=\"http://prestigeconf.com/tickets/\">70 tickets left</a> to watch a livestream of the event. You can also monitor the <a href=\"https://twitter.com/search?q=prestigeconf&src=typd\">#Prestigeconf</a> hashtag on Twitter. If you&#8217;ve previously attended Prestige or watched the livestream, please share your experiences in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 21:13:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: WordPress Users Association Under New Ownership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://wptavern.com/wordpress-users-association-under-new-ownership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5827:\"<p>The <a href=\"http://wpua.org/\">WordPress Users Association</a> (WPUA) is breathing new life after it was acquired by Paul DeMott earlier this year <a href=\"https://flippa.com/4377398-pr-2-2-405-last-12-mos-wordpress-training-membership-site-3500-members\">on Flippa</a> for $797. WPUA originally launched in December 2010, with the goal of providing a central place for WordPress users to swap war stories, learn how to get the most out of WordPress, and take part in getting special discounts on themes and plugins.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUAFrontPage.png\"><img class=\"size-full wp-image-47197\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUAFrontPage.png?resize=1025%2C489\" alt=\"Redesigned Front Page\" /></a>Redesigned Front Page\n<p>Three years after its launch, the site appeared to be dead. In 2013, <a href=\"http://wptavern.com/psa-dont-give-your-money-to-the-wpua\">I paid to become a member</a> to confirm my suspicions and to see if the site still accepted payments. Free themes and plugins offered to members were not impressive and there wasn&#8217;t much to choose from. All of the videos used for WordPress training were broken. Despite these setbacks, I was able to successfully complete the refund process.</p>\n<h2>Financial Details</h2>\n<p>Earlier this year, WPUA.org was listed on <a href=\"https://flippa.com/\">Flippa.com</a>, a domain auctioning site. As part of the auction financial details of WPUA.org were made public. According to <a href=\"https://flippa.com/users/217895\">the seller</a>, the site made $20K when it launched. The previous owners spent between $500-$1,000 on ads and answering WordPress questions through the Ask a WordPress Expert section of the site.</p>\n<p>The following shows revenue, costs, and profit between October 2014 and March 2015. WPUA earned revenue primarily with product or service sales and affiliate income.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUARevenue.png\"><img class=\"size-full wp-image-47198\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUARevenue.png?resize=580%2C273\" alt=\"WPUA Revenue\" /></a>WPUA Revenue\n<p>At the time the site was listed for auction, it had 3,500+ total members made up of free and paid subscriptions. The site today boasts more than 5,600 members.</p>\n<h2>Previous Owner Explains Why He Sold The Site</h2>\n<p>Wesley Williams is the former owner of WPUA.org and helped launch the site in 2010. Williams transitioned away from the domain because his web development business used the majority of his time. &#8220;We felt with our limited time to invest in it that it was best to transition it to someone who shared our passion but had a little more time to invest in growing the community and serving the members. We completed this transition back in April,&#8221; Williams told the Tavern.</p>\n<p>From my perspective, the WPUA was not a successful venture but Williams says otherwise.</p>\n<p>&#8220;I wouldn&#8217;t say it wasn&#8217;t a success. There are thousands of members and we provided a lot of help to a lot of new and experienced WordPress users. As my main core business grew and as the time requirements of our projects increased, we couldn&#8217;t devote the time required to answer questions and give the help needed.</p>\n<p>&#8220;Actually, WPUA was a big success in my mind. Just from a number of members point of view it was a success. From the amount and number of questions and people we helped it was a success and from a financial standpoint it was a success,&#8221; he said.</p>\n<p>Williams explains his goal with WPUA and why some members of the community may not be aware of the growth it had. &#8220;My goal was to help the under-served, those just getting started and without the technical know how to make what is actually simple fixes or changes to their WordPress site.</p>\n<p>&#8220;I didn&#8217;t run the WPUA in the circles of all the established WordPress technical crowd, even though a large number of them became members of the WPUA. I ran it focused on users new to the platform and so because of that, some members of the WordPress community might not be aware of the growth and success it had,&#8221; he said.</p>\n<p>Through the course of time, Williams and his team adjusted membership levels and access points which helped increase registrations. Williams also learned that what members wanted was a direct way to ask questions and receive expert answers.</p>\n<p>&#8220;A person new to the platform didn&#8217;t want to post their question in a forum and they weren&#8217;t really sure what the real question was. Thus, we removed the forum and went to an &#8216;Ask an Expert&#8217; system where they could email their questions. This seemed to work better for everyone,&#8221; he said.</p>\n<p>Overall, Williams is happy with how WPUA progressed and feels fortunate to have played a role in its growth and success.</p>\n<h2><strong>Who is Paul DeMott?</strong></h2>\n<p>In the <a href=\"https://vimeo.com/129324627\">following video,</a> DeMott explains how to build a eCommerce site with WooCommerce and calls himself the new president of recruitment for the WPUA. According to <a href=\"https://www.linkedin.com/pub/paul-demott/79/300/727\">his LinkedIn profile</a>, he lives in Cincinnati, OH and is the owner of Paul&#8217;s SEO and Web Expertise which works with companies to develop websites that bring in internet traffic and sales.</p>\n<p>Not much is known about DeMott and multiple requests for comment have gone unanswered. It&#8217;s unclear what his plans are for WPUA.org but so far, it&#8217;s remained as a paid subscription membership site. If you are a past or current member of the WordPress Users Association, please tell us about your experience in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 20:39:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: MPAA Smoking Gun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45270\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"http://ma.tt/2015/07/mpaa-smoking-gun/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"<p>Sometimes truth is worse than what you would imagine: <a href=\"https://www.techdirt.com/articles/20150724/15501631756/smoking-gun-mpaa-emails-reveal-plan-to-run-anti-google-smear-campaign-via-today-show-wsj.shtml\">Smoking Gun: MPAA Emails Reveal Plan To Run Anti-Google Smear Campaign Via Today Show And WSJ</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 15:34:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"WPTavern: Plugin Developers Demand a Better Security Release Process After WordPress 4.2.3 Breaks Thousands of Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47146\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6880:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/07/security.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/07/security.jpg?resize=1024%2C487\" alt=\"photo credit: Ravages - cc\" class=\"size-full wp-image-27206\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/ravages/6731739485/\">Ravages</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p><a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\" target=\"_blank\"> WordPress 4.2.3</a>, a critical security release, was automatically pushed out to users yesterday to fix an XSS vulnerability. Shortly afterwards, the <a href=\"https://wordpress.org/search/4.2.3?forums=1\" target=\"_blank\">WordPress.org support forums</a> were flooded with reports of websites broken by the update.</p>\n<p>Roughly eight hours later Robert Chapin (@<a href=\"https://profiles.wordpress.org/miqrogroove/\" target=\"_blank\">miqrogroove</a>) published a post to the Make.WordPress.org/Core blog, detailing <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/\" target=\"_blank\">changes to the Shortcode API</a> that were included in the release. According to Chapin, these changes were necessary as part of the security fix:</p>\n<blockquote><p>Due to the nature of the fix – as is often the case with security fixes – we were unable to alert plugin authors ahead of time, however we did make efforts to scan the plugin directory for plugins that may have been affected.</p>\n<p>With this change, every effort has been made to preserve all of the core features of the Shortcode API. That said, there are some new limitations that affect some rare uses of shortcodes.</p></blockquote>\n<p>The security team had no reasonable way of accounting for every single edge case, but the negative impact of these changes were far more wide-reaching than they had anticipated. This particular use case likely wasn&#8217;t covered in their testing. Unfortunately, plugin developers found out about the breaking changes only after the security release had already left a slew of broken websites in its wake.</p>\n<p>&#8220;I fully understand this is an issue, but isn’t this a weird way of updating &#8211; almost all our clients are calling / e-mailing us at the moment as their sites seem to be broken,&#8221; one developer <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/#comment-26449\" target=\"_blank\">commented</a> on the Shortcode API post. &#8220;Normally it would be better to announce such huge impact changes to the plugin and theme developers. This means I need to fully reschedule my agenda, which already is full during holiday season.&#8221;</p></blockquote>\n<p>Comments on the WordPress.org post are full of developers scrambling to find a way to fix client websites. Many were disappointed that the total secrecy of the security team, which is necessary in situations like this, was not immediately followed up with a public post on the important changes to the Shortcode API. Meanwhile, the email inboxes of agencies and plugin developers are filling up with urgent messages from outraged clients.</p>\n<p>Developers want better communication from the those who are managing security releases. <a href=\"https://twitter.com/helzer\" target=\"_blank\">Amir Helzer</a>, author of <a href=\"https://wordpress.org/plugins/types/\" target=\"_blank\">Types</a> and <a href=\"http://wp-types.com/home/views-create-elegant-displays-for-your-content/\" target=\"_blank\">Views</a>, two plugins majorly affected by the release, <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/#comment-26447\" target=\"_blank\">sums up the thoughts of many other commenters</a> on the Make/WordPress.org/Core post:</p>\n<blockquote><p>We are updating the Views plugin today, so that we resolve all shortcodes before passing to WordPress to process content.</p>\n<p>This is a straightforward change, which takes us one day to complete.</p>\n<p>Would have been great to receive a heads-up about an upcoming change in WordPress, so we could do this change on time.</p>\n<p>We received a huge amount of support requests due to this, but this isn’t the issue. We can deal with a wave a support issues. This time it wasn’t “our fault”, but sometimes it is.</p>\n<p>What worries us, as mentioned above, is seeing our clients (folks who build WordPress sites for a living), losing their faith in the system. They feel like the system sees them as little ants and not as humans. People don’t like seeing their problems being dismissed.</p>\n<p>Many of them run hundreds of sites. They cannot afford to stop everything and fix content on so many sites. Especially not if they are currently away for their family vacation.</p>\n<p>What others have asked here, and I would like to ask, too, is to setup a mechanism that allows WordPress core developers to privately communicate such upcoming issues with plugins developers.</p>\n<p>We are your partners.</p>\n<p>Without WordPress (secure, stable and reliable), we would not exist.</p>\n<p>Without great themes and plugins, WordPress would not power 24% of the Web.</p>\n<p>WordPress core members already volunteer a lot of their time. I’m not asking for anyone to volunteer more time. Need help? Ask us. There is a huge community of developers who rely on WordPress. We would be happy to get involved and set up whatever is needed.</p></blockquote>\n<p>User confidence in WordPress&#8217; automatic background updates took a dent with the 4.2.3 release. Waking up to broken websites causes users to second guess automatic updates after being assured that maintenance and security releases would not include breaking changes.</p>\n<p>When users get burned by automatic updates, in the end it doesn&#8217;t matter which party is at fault &#8211; whether it&#8217;s the core team or a theme or plugin. They simply expect updates to work and not break anything. Even in instances where a poorly coded extension may be at fault, the average user has no way of determining whether or not their active plugins follow WordPress best practices.</p>\n<p>The aftermath of the most recent security release is one reason why many developers and users are still wary of automatic updates. Amir Helzer represents many other plugin developers who are eager to find better ways to work together with the core team to provide a better update experience for users. This is especially important for releases like this one where the Shortcode API changes directly affected users&#8217; content. Hezler&#8217;s comment reaffirms the fact that development agencies, plugin developers, and core developers are all partners on the same team. It&#8217;s time to find better ways of working together to provide the best update experience possible for WordPress users.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Jul 2015 02:46:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: FooPlugin’s Digital License Key Management Plugin is Now Open Source for Developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47117\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/fooplugins-digital-license-key-management-plugin-is-now-open-source-for-developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5296:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/06/open-source.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/06/open-source.jpg?resize=1024%2C514\" alt=\"photo credit: 16th st - (license)\" class=\"size-full wp-image-45884\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/79777096@N00/6866996865\">16th st</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">(license)</a>\n<p>Three years ago, <a href=\"http://fooplugins.com/\" target=\"_blank\">FooPlugins</a> built <a href=\"https://bitbucket.org/fooplugins/foolicensing\" target=\"_blank\">FooLicensing</a>, a digital license key management tool that enabled them to manage customers of their <a href=\"https://easydigitaldownloads.com/\" target=\"_blank\">EDD</a>-powered commercial plugins store. Although EDD already offered a license creation and management extension, FooPlugins required more features than it had at that time and opted to build their own.</p>\n<p>As of today, FooLicensing is now open source and free for anyone to use, along with the associated EDD connector plugin.</p>\n<p>&#8220;We love the community and wanted to give back,&#8221; FooPlugins co-founder Adam Warner said.</p>\n<p>&#8220;We know FooLicensing could be so much more but we just don&#8217;t have the time to dedicate to it alone. We are a small team and because of that we find ourselves with dozens of projects that could be so much more if only we had more time and people.&#8221;</p>\n<p>Open sourcing a project can change its trajectory if there&#8217;s enough interest and developers willing to contribute to improve it. Warner isn&#8217;t counting on that, however, and simply hopes other developers will find it useful.</p>\n<p>&#8220;It&#8217;s a bit of a leap of faith, but if it helps someone else get involved to help create an even more robust system, then great,&#8221; he said. &#8220;Bonus if it helps someone build additional extensions to help others.&#8221;</p>\n<p>FooLicensing&#8217;s main features include:</p>\n<ul>\n<li>View and manage the validated domains for your EDD license level</li>\n<li>One click EDD license upgrade/add to cart</li>\n<li>One click EDD license renewal (with associated discount) /add to cart</li>\n</ul>\n<p>A logged-in user who has entered a license key will see all the relevant account information detailing status, activations, expirations, etc.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-user-admin.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-user-admin.png?resize=580%2C332\" alt=\"foolicensing-user-admin\" class=\"aligncenter size-full wp-image-47135\" /></a></p>\n<p>Administrators who are using the plugin together with its <a href=\"https://bitbucket.org/fooplugins/edd-foolicensing\" target=\"_blank\">EDD Connector</a> will see a menu with various license creation and management tools.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-admin-view.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-admin-view.png?resize=160%2C264\" alt=\"foolicensing-admin-view\" class=\"aligncenter size-full wp-image-47137\" /></a></p>\n<p>The <a href=\"https://bitbucket.org/fooplugins/edd-foolicensing\" target=\"_blank\">EDD Connector</a>, also now open source, enables the following:</p>\n<ul>\n<li>Add new licenses to attach to an EDD product</li>\n<li>A searchable list of all license keys that have been created and assigned, complete with attached domains</li>\n<li>A list of licenses that have been renewed</li>\n<li>Testing for license validation and update checks in the API Sandbox</li>\n<li>A management area for various messages (domain attach, detach) and for license renewal discount amount and emails</li>\n</ul>\n<h3>Foo Licensing is Extensible for Other Platforms</h3>\n<p>FooLicensing was built from the beginning to be extensible for use with other platforms beyond EDD. The team at FooPlugins had plans to expand their library of connectors but didn&#8217;t have the time to execute them.</p>\n<p>&#8220;Our goal for FooLicensing was to build additional integrations for other eCommerce plugins and digital sales platforms but it quickly took a back seat as our <a href=\"https://fooplugins.com/plugins/foobox/\" target=\"_blank\">FooBox</a> and other plugins like <a href=\"https://fooplugins.com/plugins/foogallery/\" target=\"_blank\">FooGallery</a> gained popularity,&#8221; Warner said.</p>\n<p>&#8220;Documentation is non-existent at this point, but we welcome you to step through the code and consider getting involved with the core plugin or with extensions for other eCommerce platforms.&#8221;</p>\n<p>Warner said the team is considering a full-fledged site dedicated to FooLicensing if enough developers become interested and would consider the possibility of a marketplace to host any extension built. FooPlugins does not currently have plans to create additional extensions in house.</p>\n<p>&#8220;We&#8217;ll see what the future holds, but for now we need to move forward with some other things rather than holding this tight to our chests,&#8221; Warner said. &#8220;Open sourcing the plugins just fits in with what we believe is the right thing to do to make the web (and the WP community) a better place.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jul 2015 20:17:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Post Status: Thesis, Automattic, and WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=13692\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://poststatus.com/thesis-automattic-and-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70425:\"<p>Chris Pearson and Matt Mullenweg have hardly communicated with one another in the last five years, but they are ideological enemies. They are both wealthy individuals (though of different magnitudes) thanks to their online endeavors, with very strong personalities and unshakable beliefs on business and software. This is a story of their dispute, their idealism, and the implications it will have on the WordPress project.</p>\n<p><a href=\"http://ma.tt/\">Matt Mullenweg</a> co-founded WordPress, founded <a href=\"https://automattic.com\">Automattic</a>, and is one of the most successful entrepreneurs of his generation. He runs a billion dollar &#8220;unicorn&#8221; startup centered on a culture of embracing open source technology and has achieved incredible success embracing principles counterintuitive to either Silicon Valley or big corporate culture. He&#8217;s paving a new path for how to create a valuable software company while religiously defending and promoting open source software.</p>\n<p><a href=\"http://www.pearsonified.com/\">Chris Pearson</a> founded <a href=\"http://diythemes.com/\">DIYthemes</a> and helped pioneer the early WordPress commercial theme industry. He has run his business successfully for over seven years, despite unique hurdles that result from a very public dispute with Mullenweg in 2010. He vehemently defends his work as his own non-derivative achievement and rejects the religiosity and cult mentality that he believes exists in the WordPress ecosystem. He views WordPress as a huge chunk of the web, available to be monetized &#8212; which he has done so to the tune of millions of dollars &#8212; but he does not believe he must adopt Matt Mullenweg&#8217;s principles in order to meet customer demand, run his own business, and protect his own inventions.</p>\n<p>By all normal definitions, Mullenweg and Pearson have done incredibly well for themselves. However, from a pure size perspective and principles aside, Mullenweg is the big nation army and Pearson is the small revolutionary militia. Mullenweg views Pearson as a threat to everything he stands for and has worked to accomplish, and Pearson views Mullenweg as an overbearing figure with no true authority over his decisions.</p>\n<p>Mullenweg has the motivation, resources, and ability to squash Pearson &#8212; and indeed most thought he&#8217;d done so already. While he has far fewer resources, Pearson has some tools available to protect his business or to potentially even disrupt the entire WordPress ecosystem as we know it today.</p>\n<p>During their first conflict in 2010, and in the resurgent one going on now, Mullenweg and Pearson have both at times made mistakes, acted childishly, or been in the wrong. Both also have merit in various aspects of their positions. Neither conflict, so publicly debated, reflects well on the WordPress ecosystem as a whole &#8212; even though I believe it is right that each conflict is best observed under a public eye, as the results can affect so many other businesses and potentially even WordPress itself.</p>\n<p>With this post, I aim to outline the entire conflict; to describe the implications past, present and future; to highlight non-WordPress comparisons for precedent and potential implications; and to share my own thoughts on who is in the right and who is in the wrong, as viewed for the good of the global WordPress community.</p>\n<h2>A history of conflict</h2>\n<p>The commercial theme movement started in 2007 and took off in 2008. Thesis was one of the pioneers of commercial WordPress themes. The theme industry was young and evolving rapidly, and many sellers hardly considered or understood licensing issues at all.</p>\n<p>Many of the sources for this period are from Siobhan McKeown&#8217;s excellent account in the book, <a href=\"https://github.com/WordPress/book\"><em>Milestones: The Story of WordPress</em></a> (which I&#8217;ll refer to as <em>Milestones</em>).</p>\n<h3>Themes as derivative works of WordPress</h3>\n<p>WordPress is licensed by the GNU General Public License (GPL), version 2 or later. The GPL ensures certain freedoms that protect both WordPress and those that utilize it. The &#8220;four freedoms&#8221; that are the heart of the GPL are as follows:</p>\n<blockquote>\n<ul>\n<li>The freedom to run the program as you wish, for any purpose (freedom 0).</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish (freedom 1). Access to the source code is a precondition for this.</li>\n<li>The freedom to redistribute copies so you can help your neighbor (freedom 2).</li>\n<li>The freedom to distribute copies of your modified versions to others (freedom 3). By doing this you can give the whole community a chance to benefit from your changes. Access to the source code is a precondition for this.</li>\n</ul>\n</blockquote>\n<p>As WordPress co-founder Mike Little phrased it in the Post Status Slack, &#8220;The GPL is meant to be restrictive for developers and permissive for users.&#8221; The <a href=\"https://gnu.org/philosophy/philosophy.html\">GNU philosophy page</a> and subsequent articles are a good resource for understanding the nature of the license.</p>\n<p>The GPL is a <a href=\"https://en.wikipedia.org/wiki/Copyleft\">Copyleft</a> license, which creates the &#8220;stipulation that the same rights be preserved in derivative works down the line.&#8221; In an immature theme market, licensing was given relatively little notice, and many theme authors provided their themes with no license or proprietary licenses.</p>\n<p>Matt Mullenweg, to many, would be considered <a href=\"https://en.wikipedia.org/wiki/Benevolent_dictator_for_life\">BDFL</a>, or Benevolent Dictator for Life, of WordPress. It&#8217;s a common term for folks that lead open source projects and have final say on project decisions. In his role as WordPress BDFL, he now has a reputation &#8212; at least within certain circles of folks that pay close attention &#8212; for making large, impactful decisions with little description of why he has done so.</p>\n<p>In late 2008, more than 200 free WordPress themes were removed from the WordPress.org theme repository. While many of the themes were removed due to spammy links, some were pulled due to GPL violations within the themes or within the theme upsells that were linked from the theme listings.</p>\n<p>The move, which was made without announcement, shocked many theme providers that felt they were unfairly included in the group of removed themes. The situation created a spark and initiated a serious debate about theme licensing.</p>\n<p>Authors were concerned that GPL licensed themes would mean that their themes would be bought and freely distributed, removing their ability to make money from their works. A few, such as Brian Gardner with his Revolution theme, <a href=\"http://www.blogherald.com/2008/10/01/brian-gardners-revolution-theme-goes-open-source/\">changed their licensing</a> as a result of conversations with Mullenweg and Toni Schneider, Automattic&#8217;s CEO at the time. In Brian&#8217;s case, he made his theme free and offered paid support services.</p>\n<p>Eventually though, most authors &#8220;selling&#8221; themes started actually selling support, access to download, and updates for their themes. This model was both GPL compatible, as well as workable for authors to get paid.</p>\n<p>In mid-2009, Matt Mullenweg also posted <a href=\"https://wordpress.org/news/2009/07/themes-are-gpl-too/\">on the official</a> WordPress blog that he was introducing a new <a href=\"https://wordpress.org/themes/commercial/\">commercial theme listing page</a> on WordPress.org, and he shared an opinion he requested from the Software Freedom Law Center (SFLC), where they determined that the two themes packaged with WordPress were derivative works.</p>\n<p>The SFLC opinion did leave room for a &#8220;split license&#8221; where the WordPress and PHP code must inherit the GPL, and the CSS, Javascript, and images could be under a proprietary license:</p>\n<blockquote><p>In conclusion, the WordPress themes supplied contain elements that are derivative of WordPress’s copyrighted code. These themes, being collections of distinct works (images, CSS files, PHP files), need not be GPL-licensed as a whole. Rather, the PHP files are subject to the requirements of the GPL while the images and CSS are not. Third-party developers of such themes may apply restrictive copyrights to these elements if they wish.</p>\n<p>Finally, we note that it might be possible to design a valid WordPress theme that avoids the factors that subject it to WordPress’s copyright, but such a theme would have to forgo almost all the WordPress functionality that makes the software useful.</p></blockquote>\n<p>&#8220;Split license&#8221; is the colloquial term the community has assigned to this statement, but in fact the actual splitting of which parts are GPL and which parts are not matters, so it may not do the reality of the situation justice. Perhaps it should be termed &#8220;PHPGPL&#8221; or &#8220;Non-Assets GPL&#8221;.</p>\n<p>A number of prominent theme sellers were unhappy with Mullenweg&#8217;s insistence that their themes maintain a 100% GPL license, but they were not willing to shake the boat over it. At this point, themes were becoming big businesses and making new millionaires (or close to it) of some of these shop owners. This settled the issue for nearly all theme sellers, and most moved to either 100% GPL or a PHPGPL license, and the doomsday scenarios never came; the theme industry continues to thrive.</p>\n<h3>Thesis holds out</h3>\n<p>But not everyone agreed to go either 100% GPL or PHPGPL license. Chris Pearson kept his Thesis theme under a proprietary license.</p>\n<p>Thesis was one of the most popular and flexible themes in the world, and Pearson <a href=\"https://github.com/WordPress/book/blob/925d7dc6293b1662a7e6839a2703e8a858c730ad/Content/Part%205/39-thesis.md\">boasted on Andrew Warner&#8217;s Mixergy podcast</a> of revenues of $1.2 million+ over the 12-18 month period prior to the interview. Mullenweg and Pearson criticized one another publicly, and Warner invited them both to Mixergy where they debated the merits of GPL licensing.</p>\n<p>By most accounts, Mullenweg had the better argument on the Mixergy episode, and also came off as a calmer and more collected personality &#8212; in contrast to Pearson&#8217;s often heated, and sometimes very strange, statements.</p>\n<p>The debate continued between Mullenweg, Pearson, and a variety of WordPress community members and their blogs. Mullenweg was extremely aggressive, to the extent that he <a href=\"https://twitter.com/photomatt/status/18548422506\">offered to buy</a> alternative commercial themes for users of Thesis that agreed to switch. Mullenweg tells me that many took him up on his offer, but it was, &#8220;less than a thousand.&#8221; In my opinion, this was a step too far by Mullenweg, though for him the issue was already personal.</p>\n<p>Pearson held his ground over the following days until an admission by one of his own team members of wholesale copying of code in Thesis from WordPress code, which violates the WordPress copyright.</p>\n<p>At this point, Pearson finally capitulated and announced that Thesis would be a split license GPL compatible theme, and the debate died down. Pearson put his head down and started working on Thesis 2.</p>\n<p>He released Thesis 2 in late 2012, and by this time the debate was cool &#8212; the community had moved on to other drama (yes, even more GPL drama) &#8212; and the release of Thesis 2 was largely ignored outside of DIYthemes&#8217; audience, which was quite large but also largely isolated from the WordPress &#8220;community&#8221; that cares about stuff like licensing.</p>\n<p>Therefore, not many people paid attention to the new Thesis or the licensing it contained. Mullenweg, however, was still paying attention.</p>\n<h2>The battle over thesis.com</h2>\n<p>If you consider the word <em>thesis</em>, what do you think of?</p>\n<p>If you are a regular person walking down the street, you probably think of the general concept for stating a theory, or perhaps you think of the long papers that university students write as part of their programs.</p>\n<p>If you are in the WordPress world, you may also consider the Thesis WordPress theme by DIYthemes.</p>\n<p>Good, single word domain names are hard to come by. Thesis.com, if you visit it now, redirects to the <a href=\"http://themeshaper.com\">ThemeShaper blog</a>. ThemeShaper is owned and operated by Automattic, and frequently posts articles about WordPress themes.</p>\n<p>ThemeShaper is not a dedicated commercial property, but it does link to Automattic&#8217;s primary website, and Automattic does make and sell WordPress themes.</p>\n<h3>Automattic buys thesis.com</h3>\n<p>Automattic hasn&#8217;t always owned <a href=\"http://thesis.com\">thesis.com</a>. Matt Mullenweg met a third party owner of the domain at a conference &#8212; a guy named Larry &#8212; and inquired about the domain by email in January of 2014. Chris Pearson had already attempted to purchase the domain from Larry, and did not agree to pay the $150,000 that Larry requested.</p>\n<p><a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">According to Pearson&#8217;s accounts</a>, he and Larry had a few exchanges that stalled with Pearson unwilling to bid beyond $37,500 for the domain, and Larry sticking to $150,000. With a $100,000 offer on the table from Mullenweg, Larry gave Pearson an opportunity to buy the domain for $115,000, which he didn&#8217;t do &#8212; in part because he thought it too expensive, but also because he suspected Larry didn&#8217;t really have the offer from Mullenweg.</p>\n<p>As we now know, Larry did have the offer and Automattic became the owner of the thesis.com domain name.</p>\n<p>Pearson didn&#8217;t know that Mullenweg actually bought the domain until November of 2014, when he was notified by a friend that Mullenweg&#8217;s WordCamp San Francisco State of the Word Q&amp;A session included a section where Mullenweg noted that he owned the domain (more on that later).</p>\n<h3>Pearson attempts to force domain transfer</h3>\n<p>On April 9th, 2015, Pearson and his lawyers filed a UDRP (Uniform Domain-Name Dispute Resolution Policy) complaint, which is a formal method for resolving domain disputes, recognized by ICANN. UDRP isn&#8217;t a formal government court, but serves as arbitration for domains due to the recognition by ICANN.</p>\n<p>There are many, many examples of UDRP complaints in regard to trademark infringement. There are a <a href=\"https://www.icann.org/resources/pages/policy-2012-02-25-en?routing_type=path\">number of criteria</a> that come into play that guide the UDRP panel&#8217;s decision making process.</p>\n<p>The three basic tenets that must be met are as follows:</p>\n<blockquote><p>(i) your domain name is identical or confusingly similar to a trademark or service mark in which the complainant has rights; and</p>\n<p>(ii) you have no rights or legitimate interests in respect of the domain name; and</p>\n<p>(iii) your domain name has been registered and is being used in bad faith.</p></blockquote>\n<p>The panel reviews the initial complaint (in this case, by Pearson) and gives the respondent (Automattic) an opportunity to respond. All correspondence is in writing and not in person. The panel has two weeks after everything has been submitted to reach a decision.</p>\n<p>In this case, which <a href=\"http://www.adrforum.com/domaindecisions/1613723.htm\">is available publicly</a>, the panel denied Pearson&#8217;s complaint.</p>\n<p>Pearson&#8217;s complaint cited that he fulfilled each of the three criteria:</p>\n<ul>\n<li>By noting his trademark of the word &#8220;thesis&#8221;.</li>\n<li>By noting that Automattic was using the domain with a commercial interest (by redirecting it to ThemeShaper).</li>\n<li>By noting the bad faith clause by citing that Automattic, &#8220;purchased the disputed domain name to confuse and redirect customers and potential customers to Respondent’s competing webpage.&#8221;</li>\n</ul>\n<p>In the response, Automattic did not contest Pearson&#8217;s trademark on the word <em>thesis</em>. However, Automattic also noted that the word is very generic, and also that ThemeShaper was not a commercial part of Automattic, but a &#8220;blogging site.&#8221;</p>\n<p>For the bad faith argument, Automattic claimed that the redirect to ThemeShaper furthers their, &#8220;purpose in providing a blogging site,&#8221; and highlights that the intention for the domain is not as a commercial entity or one to be confused with Pearson&#8217;s trademark.</p>\n<h3>Automattic wins dispute</h3>\n<p>Automattic won the dispute against Pearson. As noted, the panel had two weeks to deliver the decision, and Automattic proposed a settlement with Pearson before the decision was handed down.</p>\n<p>Pearson was considering the settlement when the decision came a day before the two week deadline, which is apparently not a common occurrence. Had the decision not come early, Pearson may have saved himself some trouble, especially in regard to eliminating the <a href=\"http://ttabvue.uspto.gov/ttabvue/v?qs=85115266\">trademark cancellation requests</a> by Automattic on <em>thesis</em> and related terms.</p>\n<p>In Pearson&#8217;s blog post, <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">The Truth about Thesis.com</a>, he notes the general terms of the proposed settlement:</p>\n<blockquote><p>Automattic’s attorneys drafted the original settlement, which included the following terms:</p>\n<ul>\n<li>Automattic would keep thesis.com</li>\n<li>Automattic would withdraw the federal trademark cancellation request</li>\n<li>I would withdraw the UDRP</li>\n<li>Both parties would mutually release one another (agree not to sue over this issue in the future)</li>\n</ul>\n<p>Nothing in the original settlement addressed the trademark infringement, and since this was the reason I took action in the first place, I added a requirement that Automattic no longer infringe upon my mark (which would mean they stop forwarding the domain).</p>\n<p>At this point in the proceedings, I agreed to the settlement.</p></blockquote>\n<p>However, since the decision came early, the settlement was never binding. It&#8217;s also worth noting that Mullenweg commented to me that Pearson&#8217;s stated terms are actually not the terms of the settlement:</p>\n<blockquote><p>In the settlement Automattic offered Chris we agreed not to infringe his trademarks (which is the law, regardless of what the settlement said). He never asked us to change the redirect of thesis.com in the settlement, and if he asked after, we would have said no. There were no restrictions on thesis.com in the settlement.</p></blockquote>\n<p>He also said, &#8220;I wish he had reached out before litigating,&#8221; and noted that it would have &#8220;definitely&#8221; changed the outcome of the entire situation. Whether it truly would have is neither here nor there.</p>\n<h3>Possibility for appeal</h3>\n<p>The UDRP doesn&#8217;t have an official appeals process. Instead, they are willing to not make the changes that a ruling states, if indeed a domain transfer or other action is ordered, if the affected party files a suit in court within ten days of the ruling.</p>\n<p>In this case, Pearson did not file in a court within the given timeline, and since the ruling did not require a change in domain ownership, there is no further recourse with the UDRP. However, there is no time limit if Pearson wishes to file in court &#8212; but that is the only path remaining if he truly wants to go after the domain.</p>\n<h3>Legitimacy of the trademark dispute</h3>\n<p>Trademark law has a long history. Trademarks follow a categorical system, meaning words and terms must be trademarked within a particular category to be applied to.</p>\n<p>Pearson has three trademarks for the Thesis and DIYthemes brands, all under <a href=\"http://www.oppedahl.com/trademarks/tmclasses.htm\">international trademark class</a> 42, for computer, scientific, and legal purposes:</p>\n<ul>\n<li>THESIS</li>\n<li>THESIS THEME</li>\n<li>DIYTHEMES</li>\n</ul>\n<p>The applications were filed in 2010 and registered in 2011. On June 16th, 2015, Automattic filed <a href=\"http://ttabvue.uspto.gov/ttabvue/v?qs=85115266\">cancellation requests</a> for all three trademarks, which were instituted June 25th. Pearson has 40 days from the date the application was instituted (which would be August 4th) to file a response to the cancellation requests. His answers, &#8220;must contain admissions or denials of the allegations in the petition for cancellation, and may include available defenses and counterclaims.&#8221; It is his burden as the defendant to establish his defense, and, &#8220;Failure to file a timely answer may result in entry of default judgment and the cancellation of the registration.&#8221;</p>\n<p>Basically, Automattic is holding his feet to the fire to defend the trademarks, which their counsel feels should not apply for two primary reasons, as listed in their <a href=\"http://ttabvue.uspto.gov/ttabvue/v?pno=92061714&pty=CAN&eno=1\">formal filing</a>.</p>\n<ul>\n<li>The trademarks were registered in Pearson&#8217;s own name, but are used by DIYthemes, and Automattic claims that, &#8220;The Pearson Applications were improperly filed in the name of an individual, who did not have the requisite intent-to-use the marks as of the filing date, and the underlying applications are void ab initio.&#8221; Their claim notes that US Code section <a href=\"https://www.law.cornell.edu/uscode/text/15/1051\">1051(b)</a> offers this justification.</li>\n<li>Furthermore, section <a href=\"https://www.law.cornell.edu/uscode/text/15/1052\">1052(e)(1)</a> requires that a trademark not be &#8220;merely descriptive,&#8221; as Automattic claims his trademarks are.</li>\n</ul>\n<p>If upheld, the trademarks will be deregistered by the US Patent Office, further limiting Pearson&#8217;s options to defend his claims to the thesis.com domain name in a formal court suit.</p>\n<p>I don&#8217;t know how good of a case Automattic has, but purely on the surface it looks pretty good. I spent time reviewing the application and the US Code and the arguments appear fairly sound &#8212; especially the argument that Pearson applied for the trademarks as an individual and utilizes them as DIYthemes, despite DIYthemes already having been registered as an LLC.</p>\n<h3>Automattic&#8217;s justification for the domain</h3>\n<p>During the <a href=\"https://videopress.com/v/WmCl2kwS\">WordCamp San Francisco Q&amp;A</a>, Mullenweg noted the existence of the redirect of the domain name with a sense of pride, and a bit of a side-eyed smirk. In response to a question about relationships with commercial theme sellers and marketplaces, he states:</p>\n<blockquote><p>With the premium theme and plugin folks? &#8230; We have had some ups and downs, particularly with marketplaces that didn&#8217;t follow the GPL, for example, or violated WordPress&#8217;s license &#8212; themes that violated WordPress&#8217;s license. Um, you can go to thesis.com to learn more about that. Type it in, seriously.</p></blockquote>\n<p>I was at this Q&amp;A in person, and don&#8217;t remember him saying this, as it was so buried in a much larger conversation, and I was simultaneously writing a wrap-up post about the State of the Word. However, once the UDRP ruling surfaced publicly, a number of WordPress community members recalled Matt&#8217;s statement and it brought a new dimension to the ruling and Mullenweg&#8217;s motivation for the domain.</p>\n<p>While Automattic bought the domain, Matt Mullenweg was clearly the driving force behind the decision. When <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">WP Tavern prompted Automattic</a> for a comment on their motivation for purchasing the domain, they responded with the following:</p>\n<blockquote><p>We’re happy the panel ruled in our favor. We think Thesis.com is a cool, generic .com that could be used for a variety of things. Just because you have a small WordPress theme doesn’t mean you have a right to seize generic English word .com domains.</p></blockquote>\n<p>We can accept Automattic&#8217;s case that they had a general interest in a generic .com domain, but in reality we know better. Mullenweg was clearly presented with an opportunity by this Larry character that checked all of the right boxes for him.</p>\n<p>He could get a domain he obviously knew Pearson would want, and deny him.</p>\n<p>It has a side benefit that it <em>is</em> a high quality generic domain that will likely maintain or increase its value. And he probably thought it was funny.</p>\n<p>I doubt Mullenweg even knew what kind of trademarks Pearson held, but despite Pearson holding the trademarks, it seems Automattic&#8217;s attorneys now have the upper hand, and it is highly unlikely Pearson will ever own the domain now.</p>\n<p>Mullenweg <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks#comment-70849\">commented</a> on his refusal to give up the domain to Pearson on WP Tavern:</p>\n<blockquote><p>I’m not going to give a domain worth several hundred thousand dollars to the worst actor in the entire WP ecosystem, someone who keeps repeatedly violating the GPL and now has gone beyond that into patents. Why reward that? I wouldn’t sell it if he offered a million dollars.</p>\n<p>There are so many people doing amazing things in the WP community, and 100% GPL! I can and have supported them almost every opportunity I can, and one of the things I’m most proud of in the world is how many fantastic open source businesses have been built on top of WordPress.</p>\n<p>And it’s just the beginning — if you remembered in 2010 Chris said that going GPL would destroy businesses and sticking to the principles of our license would destroy investment in WordPress — we all know how that’s worked out since then.</p></blockquote>\n<p>Such a statement, combined with the WCSF video, highlights that the issue is about far more than the domain and its investment potential &#8212; a 10x return in less than a year would make for an excellent investment, in the near impossible situation Pearson would offer that.</p>\n<p>No, the move was quite clearly a personal one &#8212; if also convenient &#8212; for Mullenweg, and that&#8217;s why terms like &#8220;bully&#8221;, &#8220;petty&#8221;, and &#8220;spiteful&#8221; have been used by many WordPress community members surprised by his actions. They expected more. They expected better, even when directed toward someone as controversial as Chris Pearson.</p>\n<h2>Pearson&#8217;s patent</h2>\n<p>While a tantalizing story, the battle over thesis.com is not <em>the</em> story here. It has simply been the spark to reignite old disputes with new fervor with potentially much bigger consequences than the 2010 affair ever reached.</p>\n<p>One of two additional large components of this story is an active patent application by Pearson that was submitted in 2012 and published in 2014. Keep in mind &#8212; and Chris Pearson reiterated this to me many times &#8212; it is an application for a patent, not a published patent.</p>\n<h3>A patent on Thesis 2, or all web templates?</h3>\n<p>The main patent is titled, <a href=\"https://patents.google.com/patent/US20140095982A1/en?q=thesis&q=diythemes\"><em>Systems, Servers, and Methods for Managing Websites</em></a>. Chris Pearson is listed as the inventor and DIYthemes the assignee.</p>\n<p>The patent never mentions WordPress or WordPress themes, however both in the abstract and in the text, it does have many similarities to what one may expect as a description of a general template mechanism for a website, versus a specific description of the Thesis 2 technology.</p>\n<p>Here is the abstract in full (and here is the <a href=\"https://poststatus.com/wp-content/uploads/2015/07/US20140095982-thesis-patent-app.pdf\">full patent application PDF</a>, including art):</p>\n<blockquote><p>Systems, servers, and methods for managing websites. Some embodiments provide methods which include, according to a user selection of a website skin, activating the selected skin. The skin comprises at least one structural box further comprising structural code for the website. The method also includes receiving a request (for instance a call to a hook) to serve the website. Further, the method includes, responsive to the request, outputting (by echoing PHP code if desired) the structural code with style related code applied thereto according to a reference between the box and a style package (which comprises the stylistic code). The outputting can occur in an order associated with the boxes. In some situations, another skin can be activated. Moreover, a change (or, perhaps, an edit) can be made to another skin and displayed without affecting the website. Moreover, another skin can be selected and associated with the website.</p></blockquote>\n<p>I discussed the patent at length with Chris Pearson, and while much of that conversation is off the record, I can share what I believe his motivations are with the patent application, and what I think the potential implications for this new chapter of Pearson versus Mullenweg are.</p>\n<h3>Discovery and publicity of the patent</h3>\n<p>This patent and another that&#8217;s since been rescinded were discovered by Automattic&#8217;s lawyers during the UDRP proceedings. There is debate as to how members of the WordPress community discovered the patents&#8217; existence &#8212; Jeff Chandler of WP Tavern and Carl Hancock of Gravity Forms were two of the first to discuss it publicly &#8212; but there is speculation from Chris Pearson and others that the community discovery of these patents was leaked by Mullenweg himself in order to deflect the attention at the time away from the domain issue and onto the patents and their potential implications.</p>\n<p>I honestly don&#8217;t care how they came up, though Pearson&#8217;s questioning of Jeff Chandler&#8217;s journalistic integrity were uncalled for. It is anyone&#8217;s right and ability to tip someone off to legitimate news &#8212; and these patent applications are legitimate news &#8212; and I don&#8217;t believe for a second that Chandler has played puppet to his boss&#8217;s wishes. He has dutifully and to the best of his ability written about whatever news matters to the community, and I respect him for it.</p>\n<p>Nevertheless, this patent does potentially have significantly more newsworthiness, depending on if it is approved and how it is defended by Pearson if it is approved.</p>\n<h3>Patent law and litigation</h3>\n<p>Patents often get a bad reputation, and their role in the software world is quite murky. I apologize in advance for this long sidebar on the wild world of patents.</p>\n<h4>Patent trolls</h4>\n<p>Most folks have heard of &#8220;patent trolls&#8221; that prey on companies using vague or overly generic patents, demanding big payouts.</p>\n<p>Patent law is weird, and the lawsuits that result are infamously unpredictable and cause a scenario ripe for abuse. For example, filing patent lawsuits in one district over another can have enormous impact, like <a href=\"http://www.nytimes.com/2006/09/24/business/24ward.html?pagewanted=all&_r=0\">the case of Marshall, Texas</a>, which is a hotbed for patent trolls:</p>\n<blockquote><p>Patent litigation is a growing business across the country; Marshall is just the most visible example. Among the weightier issues behind the mushrooming of its patent docket is whether the elements that have made it expand — hungry plaintiffs’ lawyers, speedy judges and plaintiff-friendly juries — are encouraging an excess of expensive litigation that is actually stifling innovation.</p>\n<p>Some say yes. “A lot of the cases being filed in Marshall are by patent holding companies, or patent trolls, as they’re called, whose primary and only assets are patents,” Mr. Tyler said.</p></blockquote>\n<p>Companies that deal in patents but do not utilize the patented technology are <a href=\"https://www.patentfreedom.com/about-npes/background/\">called non-practicing entities (NPEs)</a>.</p>\n<p>One of the concerns with Pearson&#8217;s patent would be if it were approved and he sold it to an NPE. It&#8217;s not uncommon for NPEs to acquire patents with the express purpose to enforce them:</p>\n<blockquote><p>Finally, of course, some entities buy patents with the express purpose of licensing them aggressively. For instance, about 25% of “parent” NPEs tracked by PatentFreedom are enforcing only patents that they had acquired. Another 60% are asserting patents originally assigned to them, and the remaining 15% are asserting a blend of originally assigned and acquired patents. However, if we add in the more than 2,100 subsidiaries and affiliates of these entities and treat them all as standalone entities, we find that 19% of them are originally assignees, and 69% are acquirers, and 12% are blends.</p>\n<p>Regardless of the important variations in their origin and behavior, NPEs present a fundamentally different challenge than operating company patent assertions.</p></blockquote>\n<h4>Software patents unpredictability and &#8220;obviousness&#8221;</h4>\n<p>The concept of software patents <em>at all</em> has been in dispute for a long time. Thousands have been awarded, but there are a handful of past court rulings that seem to <a href=\"https://www.law.cornell.edu/uscode/text/35/part-II/chapter-10\">govern the US Patent and Trademark office&#8217;s interpretations</a> for making decisions when reviewing software patents.</p>\n<p><a href=\"http://www.ipwatchdog.com/2014/02/01/when-is-an-invention-obvious/id=47709/\">Obviousness</a> is a key term in the patent world. Patent applicants aim to create &#8220;meaningful&#8221; patents, but &#8220;at a minimum you must have claims that embody patent eligible subject matter, demonstrate a useful invention, cover a novel invention and which are non-obvious in light of the prior art. Obviousness is typically the real hurdle to patentability, and unfortunately the law of obviousness can be quite subjective and difficult to understand. At times obviousness determinations almost seems arbitrary.&#8221;</p>\n<p>&#8220;Art&#8221; is the outlay of the invention by the applicant, and the invention&#8217;s ability to be patented depends on &#8220;prior art&#8221; not deeming the invention as obvious. Establishing non-obviousness for software has a contentious history. If it can be shown that, &#8220;any combination of prior art references that when put together would be the invention in question,&#8221; then the applicant is in trouble.</p>\n<p>But there is a great deal of potential for subjectivity from thousands of patent examiners:</p>\n<blockquote><p>Still, ever since the Supreme Court’s decision in KSR [<a href=\"http://www.ipwatchdog.com/2012/04/29/ksr-the-5th-anniversary-one-supremely-obvious-mess/id=24456/\">reference</a>] there has been a great deal of subjectivity in the application of the law of obviousness, which is apparent if you look at the patents that issue, patents that are finally rejected and ultimately abandoned, and the patents the Federal Circuit ultimately finds to include obvious patent claims. There is little to no predictability at the edges.</p></blockquote>\n<h4>The Alice case</h4>\n<p>In my research, the <em>Alice case</em> came up many times as a pivotal case for helping to define the legitamacy of software patents. Martin Goetz is the holder of the first ever software patent, and has <a href=\"http://www.ipwatchdog.com/2015/02/06/alice-v-cls-bank-is-a-victory-for-software-patents/id=54489/\">an excellent write-up on the importance of the Alice case</a>.</p>\n<blockquote><p>I have been asked for my opinion based my long history in the software industry and from my perspective as someone that has followed that controversial question “Is Software patentable”? That question first began to be publicly debated when I received the first software patent in 1968 for an invention on a new way of sorting data on a computer. Shortly thereafter a publication printed a page one headline “First Patent is Issued for Software, Full Implications Are Not Yet Known.”</p>\n<p>Forty five years later a variation of that question was again before the Supreme Court when it agreed to hear the appeal of the Alice v. CLS Bank case.</p></blockquote>\n<p>Goetz argues that the Alice case is a victory for software patents on both sides: that it helps true inventions gain patents (he and others assign a high standard to define &#8220;invention&#8221;), and it also helps prevent abuse of overly vague or non-inventive &#8220;obvious&#8221; patents to be denied:</p>\n<blockquote><p>The Alice v CLS Bank Supreme Court decision in June 2014 was a great victory for those that believe that inventors that use a digital computer to innovate can get a patent on their invention. It is also a victory for those people and organizations that recognize how the patent System has been abused for many years by trolls and others where there was no invention. Since the Supreme Court decision in June, thousands of patents that should never have been issued are now being deemed invalid by the US Courts and by the Patent Office.</p></blockquote>\n<h4>Obviousness and invention for Pearson&#8217;s patent</h4>\n<p>This long and boring description of patents is necessary because Pearson&#8217;s patent application is still just an application, and it can be challenged, both by the patent reviewer, but also by third parties.</p>\n<p>As patent obviousness is &#8220;so unevenly applied,&#8221; there is some risk in not challenging Pearson&#8217;s patent, if a third party like Automattic (or a myriad of other web template providers) is worried about the potential implications of the patent. Although, the Alice case does seem &#8212; in my very amateur opinion &#8212; to offer better guidance to reject the patent based on a lack of true invention.</p>\n<h3>Pearson&#8217;s reasoning for a patent, and its likelihood for success</h3>\n<p>Patents are not cheap to apply for. The patent application Pearson submitted is 34 pages of art diagrams and text describing the inventiveness of Thesis 2, though Thesis 2 is not specifically named.</p>\n<p>I asked Pearson why he applied for the patent, which he did not want to share the specifics of his position due to the open nature of the application. I&#8217;ve racked my brain to try and determine the potential causes as well.</p>\n<p>There are only a couple of decent outcomes for Pearson with this patent application. The most likely, and not good outcome for him, is that he is denied the patent; and in this case he would have spent a great deal of money for nothing.</p>\n<p>In the event he does get the patent &#8212; or perhaps even before it is fully reviewed for approval &#8212; he could face a challenge from Automattic or other parties that may be concerned his invention&#8217;s description could apply more broadly than Thesis 2.</p>\n<p>If he gets the patent, and he survives a challenge, I see three ways he could theoretically use it:</p>\n<ul>\n<li>He can do nothing.</li>\n<li>He can sell it to the highest bidding NPE, which would be a dreadful outcome for any web entities that sell templates.</li>\n<li>He can keep it in his back pocket, in case someone threatens his business or his software license, wherein he can initiate a lawsuit.</li>\n</ul>\n<p>Honestly, the whole patent route seems odd. I don&#8217;t love the idea of this patent being approved, because the application does seem overly broad toward all web templates to me, from the title to the meat of the application&#8217;s art. However, there are loads of patents in the world for incredibly silly things that have never really impacted a lot of folks&#8217; life; it&#8217;s just that it doesn&#8217;t mean a silly patent <em>couldn&#8217;t</em> become a problem. The Electronic Frontier Foundation has <a href=\"https://www.eff.org/patent\">mountains of evidence</a> of patent holders causing havoc.</p>\n<p>I&#8217;m not much of a gambler, but if I had to gamble on this I&#8217;d put my money on this patent never being approved, and definitely never truly impacting the web or WordPress industry at scale.</p>\n<p>I don&#8217;t think Pearson is a bad guy for wanting to patent his work. When I requested comment about the patents, he told me, &#8220;If I were ever to consider selling my business, things like trademarks and patents show up on the balance sheet and add to the bottom line,&#8221; but that he views them as, &#8220;one of many expensive, ridiculous options for bolstering one&#8217;s business,&#8221; versus a way to celebrate and protect his achievements as I previously characterized his intentions.</p>\n<h2>The GPL</h2>\n<p>Most agree that the GPL has not been well tested in court, though a <a href=\"https://en.wikipedia.org/wiki/Software_license\">software license</a> is a &#8220;legal instrument.&#8221; There is often confusion over whether a license is a contract or not.</p>\n<h3>License versus contract</h3>\n<p>One of my favorite <a href=\"http://softwarelawyer.blogspot.com/2008/01/jacobsen-v-katzer.html\">things I&#8217;ve read on this</a> is by former Adobe Associate General Counsel Robert Pierce:</p>\n<blockquote><p>A license is not a contract. This much I know.</p>\n<p>Rather, a license is a permission granted by one party to another allowing use of a property without fear of lawsuit brought by the granting party. A license does not include a return promise (i.e., consideration) from the licensee. So, as we all learned in law school, a license cannot be a contract under law. This is not to say that a license cannot be an element of a contract under which two parties trade promises, one of such promises being a license. This is commonly known as a &#8220;license agreement.&#8221; But a bald license, a one-way promise, is enforceable outside of contract law. It is something apart. It exists and is enforceable under property law doctrine.</p>\n<p>What makes things difficult is that the scope of a license&#8217;s grant, and the conditions and restrictions on the license (or all of them together) can make what is intended to be a one-way license look a lot like a contract. The precise wording used becomes critical.</p></blockquote>\n<p>The distinction can be significant because, &#8220;contracts are enforceable by contract law, whereas licenses are enforced under copyright law,&#8221; though even this rule depends on the jurisdiction where the matter is being discussed. His larger point is that a license is a one-way street, whereas a contract is agreed upon by both sides.</p>\n<h3>Spirit of the GPL</h3>\n<p>There is little debate that a &#8220;Split GPL&#8221; or &#8220;PHP GPL&#8221; license is perfectly GPL compatible, though Mullenweg doesn&#8217;t consider that the &#8220;<a href=\"https://github.com/WordPress/book/blob/e55a93f1056ffac8466944086b2c5104becab9c4/Content/Part%206/42-spirit-of-the-gpl.md\">spirit of the GPL</a>,&#8221; and companies like Envato&#8217;s ThemeForest and others have felt the consequences of not adopting 100% GPL licenses.</p>\n<p>From <em>Milestones</em>:</p>\n<blockquote><p>While not everyone liked the fact that the WordPress project would only support 100% GPL products, most people had accepted it. Many, however, were taken by surprise, by a sudden flare-up around not just the legalities of the GPL, but the “spirit” of the license. In a 2008 interview, Jeff Chandler asks Matt about the spirit of the GPL. Matt says that the spirit of the GPL is about user empowerment, about the four freedoms: to use, distribute, modify, and distribute modifications of the software. Software distributed with these four freedoms is in the spirit of the GPL. WordPress was created and distributed in this spirit, giving users full freedom with regard to the software.</p>\n<p>The Software Freedom Law Center&#8217;s opinion &#8212; with regards to WordPress themes, however &#8212; gives developers a loophole, one that helps them achieve GPL compliance, but denies the same freedoms as WordPress. PHP in themes must be GPL, but the CSS, images, and JavaScript do not have to be GPL. This is how Thesis released with a split license &#8212; the PHP was GPL, while the rest of the code and files were proprietary. This split license ensures that the theme is GPL compliant yet it isn&#8217;t released under the same spirit as the GPL&#8217;s driving user-freedom ethos.</p>\n<p>The loophole may have kept theme sellers in line with the GPL, but WordPress.org didn&#8217;t support that approach. In a 2010 interview, Matt says “in the philosophy there are no loopholes: you’re either following the principles of it or you’re not, regardless of what the specific license of the language is.&#8221; Theme sellers that sell their themes with a 100% GPL license are supported by WordPress. Those that aren’t don’t get any support or promotion on WordPress.org or on official resources. This is also one of the WordCamp guidelines, introduced in 2010; that WordCamps should promote WordPress’ philosophies. If a speaker, volunteer, or organizer is distributing a WordPress product it needs to be 100% GPL, i.e., the CSS, JavaScript, and other assets need to be GPL, just like the PHP.</p></blockquote>\n<p>Mullenweg believes that Thesis 2 is not only not in the spirit of the GPL, but flagrantly operates in total violation of it, as Thesis 2 carries a 100% proprietary license. Considering the implications for folks that make stuff compatible with the GPL, it&#8217;s little surprise that Mullenweg has taken the stance and actions he has toward Pearson.</p>\n<h3>Thesis 2 carries a proprietary license</h3>\n<p>Chris Pearson&#8217;s <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php#comment-1507962\">comment on his blog post</a> describes that the theme has always been a proprietary license, and he describes why it is okay to be such:</p>\n<blockquote><p>In October 2012, I released an all-new version of Thesis that carried the same name as the original (which had a split-GPL license), but that’s where the similarities stopped.</p>\n<p>The new Thesis is not a Theme—it is an operating system for templates and design. This system runs Skins and Boxes, which are similar to Themes and Plugins, but with a boatload of built-in efficiencies that Themes and Plugins cannot provide.</p></blockquote>\n<p>It is worth noting the final paragraph of the SFLC&#8217;s opinion that Mullenweg has cited numerous times as justification against proprietary licenses <em>does</em> have a provision for avoiding WordPress&#8217;s copyright:</p>\n<blockquote><p>Finally, we note that it might be possible to design a valid WordPress theme that avoids the factors that subject it to WordPress’s copyright, but such a theme would have to forgo almost all the WordPress functionality that makes the software useful.</p></blockquote>\n<p>That&#8217;s exactly what Pearson believes Thesis 2 is. But the GPL has rarely been tested in a proper court, and never from a WordPress perspective. The SFLC&#8217;s opinion is just that, for now, whether Mullenweg likes it or not.</p>\n<h3>The GPL in court</h3>\n<p>The Free Software Foundation maintains the copyright on the text of the GPL itself, and between the FSF and the SFLC, a <a href=\"https://en.wikipedia.org/wiki/GNU_General_Public_License#Legal_status\">small number of lawsuits</a> have occurred, and a German court upheld the GPL as a &#8220;valid, legally binding&#8221; license, but most of these tests have occurred outside of the United States. From what I can tell, cases involving the GPL have largely settled outside of court when based in the United States, or were argued on whether the GPL was legally applied, like in the case of <a href=\"https://en.wikipedia.org/wiki/SCO_Group,_Inc._v._International_Business_Machines_Corp.#The_GPL_issue\">SCO vs IBM</a>, rather than whether the GPL was legally binding itself.</p>\n<p>In another case, <a href=\"https://en.wikipedia.org/wiki/Wallace_v._International_Business_Machines_Corp.\">Wallace vs FSF</a>, Daniel Wallace compared the GPL to price fixing, as it required software to be free. The FSF won the case, as the judge cited, &#8220;The GPL encourages, rather than discourages, free competition and the distribution of computer operating systems, the benefits of which directly pass to consumers. These benefits include lower prices, better access and more innovation.&#8221;</p>\n<p>A much <a href=\"http://www.infoworld.com/article/2893695/open-source-software/vmware-heading-to-court-over-gpl-violations.html\">newer case involving VMware</a> again tests the GPL. The Software Freedom Conservancy, &#8220;claims VMware is using the Linux kernel without respecting the terms of its copyright license, the GPL.&#8221; This case may offer a better precedent for WordPress and its derivative works, as it is centered on &#8220;module loading&#8221; in VMware, &#8220;with an insulating layer to allow its kernel to use unmodified Linux drivers.&#8221; The case gets murkier than that, as it may not have been as isolated as it was attempted, but the result could be decent precedent for similarly loading WordPress themes and plugins, in my opinion.</p>\n<h3>Limited guidance</h3>\n<p>Few lawyers want to be the first to test something in court. It&#8217;s easier to make a case when there are many cases before you to provide guidance. With the GPL, there is what&#8217;s called &#8220;limited guidance,&#8221; meaning that it&#8217;s untested, and therefore the outcome of a GPL case in the US could be very difficult to predict.</p>\n<p>If a lawsuit does occur, it could prove costly to all parties involved, and I think it&#8217;s clear that Pearson and Mullenweg both wish that litigation was not happening, though both of them maintain a bit of a &#8220;you started it&#8221; attitude.</p>\n<p>Without a formal court proceeding, which could last years, it&#8217;s going to be near impossible for Matt Mullenweg to fully prevent non-GPL compatible licenses to exist for WordPress themes and plugins. His best method to prevent it is to do what he&#8217;s done so far: make an example of bad offenders and cause anyone thinking of using a non-GPL compatible license to reconsider.</p>\n<h2>Are all WordPress themes derivative works?</h2>\n<p>A key question to whether themes and plugins must be GPL compatible licensed is whether the theme or plugin is a derivative of WordPress itself. If it is derivative, then it is under the umbrella of the GPL&#8217;s Copyleft nature.</p>\n<p>Folks disagree a good bit on how themes and plugins should be considered as derivative works, though most either agree with Mullenweg&#8217;s strict &#8220;spirit of the GPL&#8221; view, or at least have molded to avoid being an outcast.</p>\n<p>The strongest argument I&#8217;ve seen in favor of all themes being derivative of WordPress &#8212; no matter how much or little they rely on WordPress functionality &#8212; is from WordPress lead developer Mark Jaquith:</p>\n<blockquote><p>There is a tendency to think that there are two things: WordPress, and the active theme. But they do not run separately. They run as one cohesive unit. They don’t even run in a sequential order. WordPress starts up, WordPress tells the theme to run its functions and register its hooks and filters, then WordPress runs some queries, then WordPress calls the appropriate theme PHP file, and then the theme hooks into the queried WordPress data and uses WordPress functions to display it, and then WordPress shuts down and finishes the request. On that simple view, it looks like a multi-layered sandwich. But the integration is even more amalgamated than the sandwich analogy suggests.</p>\n<p>Here is one important takeaway: <em>themes interact with WordPress (and WordPress with themes) the exact same way that WordPress interacts with itself</em>. Give that a second read, and then we’ll digest.</p>\n<p>The same core WordPress functions that themes use are used by WordPress itself. The same action/filter hook system that themes use is used by WordPress itself. Themes can thus disable core WordPress functionality, or modify WordPress core data. Not just take WordPress’ ultimate output and change it, but actually reach into the internals of WordPress and change those values before WordPress is finished working with them. If you were thinking that theme code is a separate work because it is contained in a separate file, also consider that many core WordPress files work the same way. They define functions, they use the WordPress hook system to insert themselves at various places in the code, they perform various functions on their own but also interact with the rest of WordPress, etc. No one would argue that these core files don’t have to be licensed under the GPL — but they operate in the same way that themes do!</p>\n<p>It isn’t correct to think of WordPress and a theme as separate entities. As far as the code is concerned, they form one functional unit. The theme code doesn’t sit “on top of” WordPress. It is within it, in multiple different places, with multiple interdependencies. This forms a web of shared data structures and code all contained within a shared memory space. If you followed the code execution for Thesis as it jumped between WordPress core code and Thesis-specific code, you’d get a headache, because you’d be jumping back and forth literally hundreds of times. But that is an artificial distinction that you’d only be aware of based on which file contained a particular function. To the PHP parser, it is all one and the same. There isn’t WordPress core code and theme code. There is merely the resulting product, which parses as one code entity.</p></blockquote>\n<p>Jaquith&#8217;s argument that the theme and WordPress execute together to form a joint &#8220;modified work&#8221; is the key phrase, I believe. As he states, and I tend to agree, it does not matter that the files are separate or that they can be distributed independently; together, when executed, they are so intertwined that they become a single work.</p>\n<p>That said, the theme is clearly dependent on WordPress itself, which is another common justification that themes are derivative. Explaining this concept is simple: WordPress can be distributed without any theme but those that ship with it by default. But a distributed theme, like Thesis, must be <em>installed and activated using WordPress&#8217;s own schema for loading a template</em>, and cannot operate independently of WordPress.</p>\n<h3>What about the WordPress REST API?</h3>\n<p>Thus far, we&#8217;ve discussed the derivative nature of WordPress themes and plugins, which require they operate within the WordPress install. It is a different matter if we consider applications that consume data or interact with WordPress as an outside application.</p>\n<p>The WordPress REST API enables one to interact with or consume data from WordPress, while being wholly independent of the WordPress install. Jaquith makes a clear exception for a scenario like this (and also applies it to technologies like RSS and XML-RPC):</p>\n<blockquote><p>Something that interacts with these APIs sits entirely outside of WordPress. Google Reader doesn’t become part of WordPress by accessing your feed, and MarsEdit doesn’t become part of WordPress when you use it to publish a post on your WordPress blog. These are separate applications, running separately, on separate codebases. All they are doing is communicating. Applications that interact with WordPress this way are separate works, and the author can license them in any way they have authority to do so.</p></blockquote>\n<h3>The GNU&#8217;s take</h3>\n<p>The GNU agrees with Jaquith&#8217;s take. They provide <a>an FAQ</a> to answer, &#8220;&#8221;What is the difference between an &#8216;aggregate&#8217; and other kinds of &#8216;modified versions&#8217;?&#8221; The emphasis provided is my own:</p>\n<blockquote><p>An “aggregate” consists of a number of separate programs, distributed together on the same CD-ROM or other media. The GPL permits you to create and distribute an aggregate, even when the licenses of the other software are non-free or GPL-incompatible. The only condition is that you cannot release the aggregate under a license that prohibits users from exercising rights that each program&#8217;s individual license would grant them.</p>\n<p><em>Where&#8217;s the line between two separate programs, and one program with two parts? This is a legal question, which ultimately judges will decide</em>. We believe that a proper criterion depends both on the mechanism of communication (exec, pipes, rpc, function calls within a shared address space, etc.) and the semantics of the communication (what kinds of information are interchanged).</p>\n<p><em>If the modules are included in the same executable file, they are definitely combined in one program. If modules are designed to run linked together in a shared address space, that almost surely means combining them into one program</em>.</p>\n<p>By contrast, pipes, sockets and command-line arguments are communication mechanisms normally used between two separate programs. So when they are used for communication, the modules normally are separate programs. But if the semantics of the communication are intimate enough, exchanging complex internal data structures, that too could be a basis to consider the two parts as combined into a larger program.</p></blockquote>\n<p>The GNU argument falls very much in line with Jaquith&#8217;s, though admits itself that judges must decide whether it&#8217;s the case, in the end.</p>\n<h3>The case against The GNU position on derivative works</h3>\n<p>The University of Washington School of Law has a <a href=\"http://www.law.washington.edu/lta/swp/index.html\">section of their website</a> devoted to the, &#8220;business, legal and technical consequences of choosing Open Source Software (OSS) or proprietary software.&#8221; They cover many of the topics I&#8217;ve outlined in this post so far, and <a href=\"http://www.law.washington.edu/lta/swp/Law/derivative.html\">in the case of the GPL and derivative works</a>, they believe the GNU is overstepping with an &#8220;expansive definition&#8221; of derivative works with consequences, &#8220;counter to the goals of the proponents of Free Software.&#8221;</p>\n<p>The most compelling of multiple derivative works examples they provide is that of subclasses. For example, imagine a class, <code>Some_Theme_Class</code> that extends <code>Some_Core_WordPress_Class</code>. The GPL FAQ is very hardline on the topic (and for what it&#8217;s worth, Thesis 2 does extend some WordPress core classes). Washington believes the GNU stance on inheritance is too over-reaching:</p>\n<blockquote><p>Example 5: Programmer X wishes to write a class D, that is a subclass of existing class B. Class B is subject to the terms of the GPL. If X distributes D, does it have to be licensed under the terms of the GPL?</p>\n<p>The answer given in the GPL FAQ is short and to the point: &#8220;Subclassing is creating a derivative work.&#8221; In our example, this makes D a work derived from B, and thereby makes D subject to the terms of the GPL upon distribution. This approach attempts to further broaden the reach of the GPL, but it again leads to counter-intuitive results.</p>\n<p>Typical object oriented programming languages include a standard class hierarchy. This hierarchy provides a framework within which application developers can build their programs. The standard classes typically provide useful classes that represent user interface elements (e.g. windows, buttons, etc.), collection classes (for handling collections of data), and input-output abstractions (e.g. files and networking connections). In many object oriented languages, each class must be a subclass of exactly one superclass. And for this reason, the class hierarchies are rooted by a highly generic, standard class called Object. (The question of the superclass of Object is beyond the scope of this article.) The class Object describes only the most general properties and behaviors. For instance, in Java, the class Object only performs a handful of functions. In Java, every class is a subclass (directly or indirectly) of the Object class. Under the GPL approach, then, every program written in Java is a derived work of Object, because every program written in Java by definition consists of classes that inherit from the Object class.</p></blockquote>\n<p>Whether this argument or any of the others Washington outlines would apply to WordPress themes and/or plugins would, again, need to be settled in court. But Washington does give a compelling argument.</p>\n<p>They conclude with the following:</p>\n<blockquote><p>In some ways, the apparent weaknesses in the GPL should come as no surprise, as the GPL was born of an era in which the central artifact of software development and distribution was the monolithic executable. In such a universe, software development proceeded principally by modifying the existing source text of programs, compiling source modules, linking the corresponding object files, and distributing the resulting executable. This model of software development and distribution has become increasingly fractured in an era characterized by highly dynamic, late binding, object- and network-based systems. The GPL, consequently, strains to cover these newly arising scenarios.</p>\n<p>To effectuate the goals of the free software movement, the drafters of the GPL urge a generally expansive definition of derivative work. The great irony is, of course, that such an expansive definition would have second order consequences that are exactly counter to the goals of the proponents of Free Software. A broad definition of derivative would give code authors less freedom to create software that they can truly call their own and do with as they please. And if naive analytic approaches such as &#8220;subclassing equals derivation&#8221; reign, then proprietary vendors such as Microsoft could arguably stake claim to every program ever written in C#, because they authored the original class hierarchy. And since it seems unlikely that courts would employ different standards depending on the goals or ideological motivations of licensors, proponents of free software might want to be careful what they wish for: what&#8217;s good for the GNU might not be good for the gander.</p></blockquote>\n<h3>Aggressive license agreements</h3>\n<p>Both the GPL and DIYthemes&#8217; proprietary license could be appropriately identified as aggressive. The Copyleft nature of the GPL annoys many open source advocates, who would prefer a less restrictive license for developers, like the MIT or BSD licenses. The GPL is absolutely an opinionated license.</p>\n<p>Pearson&#8217;s proprietary license is also aggressive, in the other direction. I&#8217;ve never purchased a WordPress-centric product that so strongly forced me to accept a license. Usually, you have to look in the source code or a page on the website for a license; DIYthemes forces you to accept the <a href=\"http://diythemes.com/thesis/rtfm/software-extensions-license-agreement/\">terms of the proprietary license</a> before you can download the product at all.</p>\n<h3>Derivative works are not a bright line</h3>\n<p>The GNU attempts to offer a &#8220;bright line&#8221; distinction for derivative works. A bright line, in much of the legal analysis I&#8217;ve read, is where <em>thing x</em> is so because of <em>thing y</em>, and can be applied across the board. You can clearly see the bright line, and when it has been crossed.</p>\n<p>Washington proves the point quite well that the GNU&#8217;s bright line approach to derivation is quite challengeable. But I don&#8217;t think their arguments prove that WordPress themes in particular are not derivative. I believe, from a legal perspective, it&#8217;s fuzzier than a bright line approach, and if I were Mullenweg or anyone defending GPL software, I would not be excited to take the issue to court.</p>\n<p>The &#8220;spirit of the GPL&#8221; is to offer users liberal freedoms, even while restricting developers building on a GPL licensed application. And I believe there is merit in the fact that WordPress, its co-founders, its lead developers, and the vast majority of its copyright holders (contributors) wish to defend the spirit of the license, even if it&#8217;s not been tested in court.</p>\n<p>Pearson is not in the majority opinion by using a proprietary license, but he is also not definitively in a position of legal wrongdoing. His desire to protect his works from user freedoms with a proprietary license may well be tested all the way to the courts, and he must be prepared to deal with that, but I don&#8217;t believe there is clear wrongdoing, legally, with his license.</p>\n<h2>A tale of idealism</h2>\n<p>Matt Mullenweg and Chris Pearson are two of the most idealistic people I&#8217;ve ever observed. They are near polar opposites, from their business belief systems and even their general world views.</p>\n<p>One of the most depressing components of my research was something Pearson told me. I asked him why he doesn&#8217;t just get out of it all and do something else. He&#8217;s not married to the culture of WordPress bestowed on it by its leaders. He called it, the &#8220;zeitgeist of western culture,&#8221; with its openness, zen attitude, and more that he feels no need to embrace if he doesn&#8217;t want to.</p>\n<p>But he admits that WordPress, &#8220;is the most used piece of software to build a website in the world. WordPress was the beneficiary of impeccable timing.&#8221; And it&#8217;s a tool for him to make his living; it&#8217;s his job, and he doesn&#8217;t see a need to be in love with every aspect of his job. This is 