DROP TABLE wp_commentmeta;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE wp_comments;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO wp_comments VALUES("2","142","Winnie","sylvesterbiddell@inbox.com","http://Phil.wordpress.com","117.177.77.17","2014-08-02 00:11:51","2014-08-02 00:11:51","It was hard to find your page in google search results.\r\nI found it on 14 position, you should build some quality backlinks , it will help you to get \r\nmore visitors. I know how to help you, just search \r\nin google - k2 seo tricks","0","0","Mozilla/5.0 (Linux; U; Android 2.2; fr-fr; Desire_A8181 Build/FRF91) App3leWebKit/53.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1","","0","0");
INSERT INTO wp_comments VALUES("3","142","Brittney","lottiecheeseman@yahoo.de","http://Aracelis.about.com","85.185.42.3","2014-09-05 17:13:52","2014-09-05 17:13:52","I read a lot of interesting content here. Probably you  spend a lot of time writing, i know how to save you a lot of work, there is an online tool that creates readable, SEO friendly articles in minutes, just search \r\nin google  - k2seotips unlimited content","0","0","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.72 Safari/537.36","","0","0");
INSERT INTO wp_comments VALUES("4","142","Brenna","darlene.oconor@gmail.com","http://Nell.wikispaces.com","46.118.9.56","2015-02-13 14:51:20","2015-02-13 14:51:20","Want to copy posts from other sources rewrite them in seconds and post on your site, or use for contextual backlinks?\r\nYou can save a lot of writing work, just search in google:\r\n\r\nDaradess\'s Rewriter","0","0","Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.71 Safari/537.36","","0","0");
INSERT INTO wp_comments VALUES("5","142","ora exacta","mercedessterner@freenet.de","http://alvaroperaza.uy/?option=com_k2&amp;view=itemlist&amp;task=user&amp;id=18333","109.236.90.135","2015-04-07 10:35:50","2015-04-07 10:35:50","Hi there, this weekend is nice in favor of me, since \r\nthis point in time i am reading this great educational article here at my residence.","0","0","Mozilla/5.0 (Windows NT 6.1; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0","","0","0");
INSERT INTO wp_comments VALUES("6","142","Brigette","dorothymaygar@yahoo.de","http://Audrea.hu","177.124.207.243","2015-04-22 16:46:20","2015-04-22 16:46:20","I see many sites outrank your blog in google\'s search results.\r\n\r\nYou should build more contextual backlinks. These type of backlinks are the most \r\npowerful after all these google algorithm updates.\r\nWriting content is hard work, but i know what tool will save you \r\na lot of time. This tool can also make you money, just search in google \r\nfor:\r\nHaough\'s Essential Tool","0","0","Mozilla/5.0 (Windows NT 6.3; WOW64; rv:35.0) Gecko/20100101 Firefox/35.0","","0","0");
INSERT INTO wp_comments VALUES("7","142","Soyoun","zzy1rt3jc6@gmail.com","http://www.facebook.com/profile.php?id=100003469766576","188.143.234.155","2015-05-23 18:16:17","2015-05-23 18:16:17","Hi , I am a patient of  Dr Bel Zoughi and she has ivitned me to book launch this Sunday.  She also asked me to inform you that because I am disabled and have problems walking I would require to park as close to the venue as possible.  Your response to this request would be appreciated as soon as possible which would determine my attendance.Thank you.","0","0","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36","","0","0");
INSERT INTO wp_comments VALUES("8","142","Calculator Taxa Auto","jovita_martinez@aol.com","https://plus.google.com/114763702751783349969/posts","91.219.237.76","2015-06-10 23:11:31","2015-06-10 23:11:31","<a href=\"https://plus.google.com/114763702751783349969/posts\" rel=\"nofollow\">Calculator Taxa Auto</a> \r\nHowdy! I could have sworn I\'ve been to this website before but after going through a few of the articles I realized it\'s new to me.\r\n\r\nNonetheless, I\'m certainly happy I stumbled upon it and I\'ll be book-marking it \r\nand checking back frequently!","0","0","Mozilla/5.0 (Linux; Android 4.4.2; Nexus 5 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.105 Mobile Safari/537.36","","0","0");
INSERT INTO wp_comments VALUES("9","142","Mahjong","dinahmccary@gmail.com","http://mahjong-mahjong.blogspot.com","37.235.48.126","2015-07-09 21:51:51","2015-07-09 21:51:51","Hello there! I know this is kinda off topic but I\'d figured I\'d ask.\r\nWould you be interested in exchanging links or maybe guest writing a \r\nblog article or vice-versa? My blog addresses a lot \r\nof the same subjects as yours and I think we could greatly benefit from each other.\r\nIf you\'re interested feel free to send me an email.\r\n\r\nI look forward to hearing from you! Terrific blog by the \r\nway!","0","0","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.99 Safari/537.36","","0","0");



DROP TABLE wp_links;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE wp_options;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=11886 DEFAULT CHARSET=utf8;

INSERT INTO wp_options VALUES("1","siteurl","http://comfortsolutions.com.au/airconditioning","yes");
INSERT INTO wp_options VALUES("2","blogname","Sunshine Coast Airconditioning &amp; Electrical","yes");
INSERT INTO wp_options VALUES("3","blogdescription","Domestic or commercial installations and service","yes");
INSERT INTO wp_options VALUES("4","users_can_register","0","yes");
INSERT INTO wp_options VALUES("5","admin_email","info@edgewebdesign.com.au","yes");
INSERT INTO wp_options VALUES("6","start_of_week","1","yes");
INSERT INTO wp_options VALUES("7","use_balanceTags","0","yes");
INSERT INTO wp_options VALUES("8","use_smilies","1","yes");
INSERT INTO wp_options VALUES("9","require_name_email","1","yes");
INSERT INTO wp_options VALUES("10","comments_notify","1","yes");
INSERT INTO wp_options VALUES("11","posts_per_rss","10","yes");
INSERT INTO wp_options VALUES("12","rss_use_excerpt","0","yes");
INSERT INTO wp_options VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO wp_options VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO wp_options VALUES("15","mailserver_pass","password","yes");
INSERT INTO wp_options VALUES("16","mailserver_port","110","yes");
INSERT INTO wp_options VALUES("17","default_category","1","yes");
INSERT INTO wp_options VALUES("18","default_comment_status","closed","yes");
INSERT INTO wp_options VALUES("19","default_ping_status","open","yes");
INSERT INTO wp_options VALUES("20","default_pingback_flag","1","yes");
INSERT INTO wp_options VALUES("21","posts_per_page","10","yes");
INSERT INTO wp_options VALUES("22","date_format","F j, Y","yes");
INSERT INTO wp_options VALUES("23","time_format","g:i a","yes");
INSERT INTO wp_options VALUES("24","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO wp_options VALUES("28","comment_moderation","1","yes");
INSERT INTO wp_options VALUES("29","moderation_notify","1","yes");
INSERT INTO wp_options VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO wp_options VALUES("31","gzipcompression","0","yes");
INSERT INTO wp_options VALUES("32","hack_file","0","yes");
INSERT INTO wp_options VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO wp_options VALUES("34","moderation_keys","","no");
INSERT INTO wp_options VALUES("35","active_plugins","a:5:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1;s:39:\"custom-login-page/custom-login-page.php\";i:2;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:3;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:4;s:27:\"wp-super-cache/wp-cache.php\";}","yes");
INSERT INTO wp_options VALUES("11872","_transient_timeout_feed_mod_867bd5c64f85878d03a060509cd2f92c","1439545341","no");
INSERT INTO wp_options VALUES("11873","_transient_feed_mod_867bd5c64f85878d03a060509cd2f92c","1439502141","no");
INSERT INTO wp_options VALUES("11874","_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109","1439545342","no");
INSERT INTO wp_options VALUES("11875","_transient_feed_b9388c83948825c1edaef0d856b7b109","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"si-LK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 21:35:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"363@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"9542@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 13 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Your WordPress, Streamlined.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5790@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"6743@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12073@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2646@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Protect your WordPress site by hiding vital areas of your site, protecting access to important files, preventing brute-force login attempts, detecting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"49521@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Google Analytics\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/googleanalytics/#post-11199\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Jun 2009 22:09:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"11199@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Enables google analytics on all pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Kevin Sylvestre\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WP-DB-Backup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/wp-db-backup/#post-472\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 Mar 2007 04:41:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"472@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"On-demand backup of your WordPress database.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"ringmaster\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 13 Aug 2015 21:42:22 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Thu, 13 Aug 2015 22:10:09 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Thu, 13 Aug 2015 21:35:09 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("36","home","http://comfortsolutions.com.au/airconditioning","yes");
INSERT INTO wp_options VALUES("37","category_base","","yes");
INSERT INTO wp_options VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO wp_options VALUES("39","advanced_edit","0","yes");
INSERT INTO wp_options VALUES("40","comment_max_links","2","yes");
INSERT INTO wp_options VALUES("41","gmt_offset","0","yes");
INSERT INTO wp_options VALUES("42","default_email_category","1","yes");
INSERT INTO wp_options VALUES("43","recently_edited","","no");
INSERT INTO wp_options VALUES("44","template","airconbasix","yes");
INSERT INTO wp_options VALUES("45","stylesheet","airconbasix","yes");
INSERT INTO wp_options VALUES("46","comment_whitelist","1","yes");
INSERT INTO wp_options VALUES("47","blacklist_keys","","no");
INSERT INTO wp_options VALUES("48","comment_registration","","yes");
INSERT INTO wp_options VALUES("49","html_type","text/html","yes");
INSERT INTO wp_options VALUES("50","use_trackback","0","yes");
INSERT INTO wp_options VALUES("51","default_role","subscriber","yes");
INSERT INTO wp_options VALUES("52","db_version","27918","yes");
INSERT INTO wp_options VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO wp_options VALUES("54","upload_path","","yes");
INSERT INTO wp_options VALUES("55","blog_public","1","yes");
INSERT INTO wp_options VALUES("56","default_link_category","2","yes");
INSERT INTO wp_options VALUES("57","show_on_front","page","yes");
INSERT INTO wp_options VALUES("58","tag_base","","yes");
INSERT INTO wp_options VALUES("59","show_avatars","1","yes");
INSERT INTO wp_options VALUES("60","avatar_rating","G","yes");
INSERT INTO wp_options VALUES("61","upload_url_path","","yes");
INSERT INTO wp_options VALUES("62","thumbnail_size_w","150","yes");
INSERT INTO wp_options VALUES("63","thumbnail_size_h","150","yes");
INSERT INTO wp_options VALUES("64","thumbnail_crop","1","yes");
INSERT INTO wp_options VALUES("65","medium_size_w","300","yes");
INSERT INTO wp_options VALUES("66","medium_size_h","300","yes");
INSERT INTO wp_options VALUES("67","avatar_default","mystery","yes");
INSERT INTO wp_options VALUES("68","large_size_w","1024","yes");
INSERT INTO wp_options VALUES("69","large_size_h","1024","yes");
INSERT INTO wp_options VALUES("70","image_default_link_type","file","yes");
INSERT INTO wp_options VALUES("71","image_default_size","","yes");
INSERT INTO wp_options VALUES("72","image_default_align","","yes");
INSERT INTO wp_options VALUES("73","close_comments_for_old_posts","","yes");
INSERT INTO wp_options VALUES("74","close_comments_days_old","14","yes");
INSERT INTO wp_options VALUES("75","thread_comments","1","yes");
INSERT INTO wp_options VALUES("76","thread_comments_depth","5","yes");
INSERT INTO wp_options VALUES("77","page_comments","","yes");
INSERT INTO wp_options VALUES("78","comments_per_page","50","yes");
INSERT INTO wp_options VALUES("79","default_comments_page","newest","yes");
INSERT INTO wp_options VALUES("80","comment_order","asc","yes");
INSERT INTO wp_options VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO wp_options VALUES("82","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("83","widget_text","a:0:{}","yes");
INSERT INTO wp_options VALUES("84","widget_rss","a:0:{}","yes");
INSERT INTO wp_options VALUES("85","uninstall_plugins","a:1:{s:27:\"wp-super-cache/wp-cache.php\";s:23:\"wpsupercache_deactivate\";}","no");
INSERT INTO wp_options VALUES("86","timezone_string","","yes");
INSERT INTO wp_options VALUES("87","page_for_posts","16","yes");
INSERT INTO wp_options VALUES("88","page_on_front","12","yes");
INSERT INTO wp_options VALUES("89","default_post_format","0","yes");
INSERT INTO wp_options VALUES("90","link_manager_enabled","0","yes");
INSERT INTO wp_options VALUES("91","initial_db_version","26691","yes");
INSERT INTO wp_options VALUES("92","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO wp_options VALUES("93","_transient_random_seed","79fc5fb54911e4a5d359fcc52820e641","yes");
INSERT INTO wp_options VALUES("94","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("95","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("96","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("97","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("98","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("99","sidebars_widgets","a:10:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:19:\"primary-widget-area\";a:0:{}s:18:\"header-widget-area\";a:0:{}s:21:\"first-nav-widget-area\";a:0:{}s:22:\"second-nav-widget-area\";N;s:21:\"first-top-widget-area\";N;s:22:\"second-top-widget-area\";N;s:24:\"first-bottom-widget-area\";N;s:25:\"second-bottom-widget-area\";N;s:13:\"array_version\";i:3;}","yes");
INSERT INTO wp_options VALUES("154","theme_sample_data","a:5:{s:5:\"posts\";a:2:{i:0;i:27;i:1;i:28;}s:5:\"pages\";a:5:{i:0;i:12;i:1;i:13;i:2;i:14;i:3;i:15;i:4;i:16;}s:7:\"widgets\";a:0:{}s:5:\"vmenu\";a:0:{}s:4:\"menu\";a:2:{i:0;i:2;i:1;i:3;}}","yes");
INSERT INTO wp_options VALUES("155","theme_content_import","1","yes");
INSERT INTO wp_options VALUES("184","recently_activated","a:1:{s:19:\"jetpack/jetpack.php\";i:1403592169;}","yes");
INSERT INTO wp_options VALUES("101","cron","a:7:{i:1439503200;a:1:{s:11:\"wp_cache_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1439505721;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1439529436;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1439529456;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1439533797;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1439536740;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO wp_options VALUES("102","ossdl_off_cdn_url","http://comfortsolutions.com.au/airconditioning","yes");
INSERT INTO wp_options VALUES("103","ossdl_off_include_dirs","wp-content,wp-includes","yes");
INSERT INTO wp_options VALUES("104","ossdl_off_exclude",".php","yes");
INSERT INTO wp_options VALUES("105","ossdl_cname","","yes");
INSERT INTO wp_options VALUES("114","tadv_version","3420","yes");
INSERT INTO wp_options VALUES("115","tadv_plugins","a:6:{i:0;s:5:\"style\";i:1;s:8:\"emotions\";i:2;s:5:\"print\";i:3;s:13:\"searchreplace\";i:4;s:10:\"xhtmlxtras\";i:5;s:8:\"advimage\";}","yes");
INSERT INTO wp_options VALUES("116","tadv_options","a:7:{s:8:\"advlink1\";i:0;s:8:\"advimage\";i:1;s:11:\"editorstyle\";i:0;s:11:\"hideclasses\";i:0;s:11:\"contextmenu\";i:0;s:8:\"no_autop\";i:1;s:7:\"advlist\";i:0;}","yes");
INSERT INTO wp_options VALUES("117","tadv_toolbars","a:4:{s:9:\"toolbar_1\";a:20:{i:0;s:4:\"bold\";i:1;s:6:\"italic\";i:2;s:13:\"strikethrough\";i:3;s:9:\"underline\";i:4;s:7:\"bullist\";i:5;s:7:\"numlist\";i:6;s:7:\"outdent\";i:7;s:6:\"indent\";i:8;s:11:\"justifyleft\";i:9;s:13:\"justifycenter\";i:10;s:12:\"justifyright\";i:11;s:4:\"link\";i:12;s:6:\"unlink\";i:13;s:5:\"image\";i:14;s:10:\"styleprops\";i:15;s:7:\"wp_more\";i:16;s:7:\"wp_page\";i:17;s:12:\"spellchecker\";i:18;s:6:\"search\";i:19;s:10:\"fullscreen\";}s:9:\"toolbar_2\";a:17:{i:0;s:14:\"fontsizeselect\";i:1;s:12:\"formatselect\";i:2;s:9:\"pastetext\";i:3;s:9:\"pasteword\";i:4;s:12:\"removeformat\";i:5;s:7:\"charmap\";i:6;s:5:\"print\";i:7;s:9:\"forecolor\";i:8;s:9:\"backcolor\";i:9;s:8:\"emotions\";i:10;s:3:\"sup\";i:11;s:3:\"sub\";i:12;s:5:\"media\";i:13;s:4:\"undo\";i:14;s:4:\"redo\";i:15;s:7:\"attribs\";i:16;s:7:\"wp_help\";}s:9:\"toolbar_3\";a:0:{}s:9:\"toolbar_4\";a:0:{}}","no");
INSERT INTO wp_options VALUES("118","tadv_btns1","a:20:{i:0;s:4:\"bold\";i:1;s:6:\"italic\";i:2;s:13:\"strikethrough\";i:3;s:9:\"underline\";i:4;s:7:\"bullist\";i:5;s:7:\"numlist\";i:6;s:7:\"outdent\";i:7;s:6:\"indent\";i:8;s:11:\"justifyleft\";i:9;s:13:\"justifycenter\";i:10;s:12:\"justifyright\";i:11;s:4:\"link\";i:12;s:6:\"unlink\";i:13;s:5:\"image\";i:14;s:10:\"styleprops\";i:15;s:7:\"wp_more\";i:16;s:7:\"wp_page\";i:17;s:12:\"spellchecker\";i:18;s:6:\"search\";i:19;s:10:\"fullscreen\";}","no");
INSERT INTO wp_options VALUES("9908","rewrite_rules","a:68:{s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=12&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}","yes");
INSERT INTO wp_options VALUES("119","tadv_btns2","a:17:{i:0;s:14:\"fontsizeselect\";i:1;s:12:\"formatselect\";i:2;s:9:\"pastetext\";i:3;s:9:\"pasteword\";i:4;s:12:\"removeformat\";i:5;s:7:\"charmap\";i:6;s:5:\"print\";i:7;s:9:\"forecolor\";i:8;s:9:\"backcolor\";i:9;s:8:\"emotions\";i:10;s:3:\"sup\";i:11;s:3:\"sub\";i:12;s:5:\"media\";i:13;s:4:\"undo\";i:14;s:4:\"redo\";i:15;s:7:\"attribs\";i:16;s:7:\"wp_help\";}","no");
INSERT INTO wp_options VALUES("120","tadv_btns3","a:0:{}","no");
INSERT INTO wp_options VALUES("121","tadv_btns4","a:0:{}","no");
INSERT INTO wp_options VALUES("122","tadv_allbtns","a:66:{i:0;s:2:\"hr\";i:1;s:6:\"wp_adv\";i:2;s:10:\"blockquote\";i:3;s:4:\"bold\";i:4;s:6:\"italic\";i:5;s:13:\"strikethrough\";i:6;s:9:\"underline\";i:7;s:7:\"bullist\";i:8;s:7:\"numlist\";i:9;s:7:\"outdent\";i:10;s:6:\"indent\";i:11;s:11:\"justifyleft\";i:12;s:13:\"justifycenter\";i:13;s:12:\"justifyright\";i:14;s:11:\"justifyfull\";i:15;s:3:\"cut\";i:16;s:4:\"copy\";i:17;s:5:\"paste\";i:18;s:4:\"link\";i:19;s:6:\"unlink\";i:20;s:5:\"image\";i:21;s:7:\"wp_more\";i:22;s:7:\"wp_page\";i:23;s:6:\"search\";i:24;s:7:\"replace\";i:25;s:10:\"fontselect\";i:26;s:14:\"fontsizeselect\";i:27;s:7:\"wp_help\";i:28;s:10:\"fullscreen\";i:29;s:11:\"styleselect\";i:30;s:12:\"formatselect\";i:31;s:9:\"forecolor\";i:32;s:9:\"backcolor\";i:33;s:9:\"pastetext\";i:34;s:9:\"pasteword\";i:35;s:12:\"removeformat\";i:36;s:7:\"cleanup\";i:37;s:12:\"spellchecker\";i:38;s:7:\"charmap\";i:39;s:5:\"print\";i:40;s:4:\"undo\";i:41;s:4:\"redo\";i:42;s:13:\"tablecontrols\";i:43;s:4:\"cite\";i:44;s:3:\"ins\";i:45;s:3:\"del\";i:46;s:4:\"abbr\";i:47;s:7:\"acronym\";i:48;s:7:\"attribs\";i:49;s:5:\"layer\";i:50;s:5:\"advhr\";i:51;s:4:\"code\";i:52;s:11:\"visualchars\";i:53;s:11:\"nonbreaking\";i:54;s:3:\"sub\";i:55;s:3:\"sup\";i:56;s:9:\"visualaid\";i:57;s:10:\"insertdate\";i:58;s:10:\"inserttime\";i:59;s:6:\"anchor\";i:60;s:10:\"styleprops\";i:61;s:8:\"emotions\";i:62;s:5:\"media\";i:63;s:7:\"iespell\";i:64;s:9:\"separator\";i:65;s:1:\"|\";}","no");
INSERT INTO wp_options VALUES("125","wpsupercache_gc_time","1439502118","yes");
INSERT INTO wp_options VALUES("150","theme_mods_twentyfourteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1391145637;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","yes");
INSERT INTO wp_options VALUES("227","wpcf7","a:1:{s:7:\"version\";s:5:\"3.8.1\";}","yes");
INSERT INTO wp_options VALUES("11854","_site_transient_timeout_theme_roots","1439503919","yes");
INSERT INTO wp_options VALUES("11855","_site_transient_theme_roots","a:4:{s:11:\"airconbasix\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";s:12:\"twentytwelve\";s:7:\"/themes\";}","yes");
INSERT INTO wp_options VALUES("11868","_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1439545339","no");
INSERT INTO wp_options VALUES("11869","_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1439502139","no");
INSERT INTO wp_options VALUES("11870","_transient_timeout_feed_867bd5c64f85878d03a060509cd2f92c","1439545341","no");
INSERT INTO wp_options VALUES("11871","_transient_feed_867bd5c64f85878d03a060509cd2f92c","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: A Look at Why Some Frontend Developers are Decoupling WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47735\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://wptavern.com/decoupling-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5540:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/DecoupledWordPressFeaturedImage.png\"><img class=\"size-full wp-image-47758\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/DecoupledWordPressFeaturedImage.png?resize=677%2C240\" alt=\"Decoupled WordPress Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/77742560@N06/7782209734\">Coupler: Immigration Museum</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<hr />\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/Emily_Miller1.jpg\"><img class=\"alignright wp-image-47736 size-thumbnail\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/Emily_Miller1.jpg?resize=150%2C150\" alt=\"Emily_Miller1\" /></a>This post was contributed by <a href=\"https://twitter.com/emilymiller317\">Emily Miller</a>. A native Hoosier, Emily now lives in San Francisco, CA, and is a content specialist at hosting platform <a href=\"http://pantheon.io\">Pantheon</a>. She enjoys exploring the great outdoors with her dog and researching the latest trends in open source.</p>\n<hr />\n<p>WordPress developers are getting serious about developing flexible, powerful websites of all sizes. One trend, started as a way to break free of the constraints of traditional WordPress theming, is using a decoupled architecture to customize the frontend.</p>\n<p>There are certainly pros and cons to this method, and this post aims to examine the various reasons why some frontend developers are implementing a headless WordPress.</p>\n<h2>What Is Decoupled WordPress?</h2>\n<p>Decoupled WordPress is the separation of the backend from the frontend. WordPress is traditionally monolithic, giving you the dashboard, plugins and themes all-in-one. Many developers have been playing around with decoupled builds lately with the primary motivation of creating a better user experience.</p>\n<p>Decoupling allows you to experiment with different JavaScript frameworks, such as Angular, to build a truly custom experience for users. That’s not to say everyone should go headless, but rather that decoupling is an option if your project has a set of requirements that call for a more flexible build.</p>\n<p>In these cases, decoupling allows WordPress to do what it does best, content organization and editing while avoiding a lot of the complex custom code that goes into developing for a set CMS.</p>\n<h2>Why Are Developers Adopting It for the Frontend?</h2>\n<p>Translating modern design into a tightly coupled CMS can be tricky, so separating the UX layer of a site allows developers to leverage the tools they want, making the frontend truly agile and the end-user experience more friendly.</p>\n<p>For the right use case it’s a win-win situation. Use the best tools for frontend development, while making the WordPress authoring experience even better to empower everyone! Quite a few developers have mentioned that decoupled projects renew their love for a chosen CMS, and that the flexibility makes it fun to work with again.</p>\n<p>Another benefit of a decoupled architecture is the upgrade process. A headless build simplifies future updates by not requiring a CMS upgrade, ultimately saving a great deal of time and money come redesign. Frontend developers can now work at their own pace, independent of the CMS’s timeline, and focus on the best language for the task at hand.</p>\n<p>A good case study of a decoupled WordPress build is <a href=\"http://www.pixotech.com/\">Pixo Tech’s</a> project with the University of Illinois. They chose the best frontend tools for the job, understanding that frontend developers and CMS developers are not necessarily one in the same. For the nitty-gritty of the project, <a href=\"https://pantheon.io/what-know-about-decoupled-cms-recording\">check out this webinar. </a></p>\n<h2>What’s the Catch?</h2>\n<p>As mentioned above, although a decoupled architecture may sound like that captivating and challenging project we’ve all been waiting for, it still has its pitfalls and is probably not the route for every project.</p>\n<p>Decoupling WordPress is a more customized, complex build that could mean more time and money up front, although cost-effective in the long run. It also means losing the content previews, easy string translations and UI oriented plugins and themes we’re used to in a coupled architecture.</p>\n<p>Additionally, decoupled WordPress is still a young concept, and best practices are still emerging. There’s no set way to do it, and you certainly won’t find a how-to tailored to your specific needs.</p>\n<h2>How Would You Approach a Decoupled Build?</h2>\n<p>The <a href=\"https://github.com/WP-API/WP-API\">WP REST API</a> is a great way to facilitate a decoupled build—you can download it and then decide how much of your site you want to separate. Integrated into core and available to all WordPress users, the plugin provides an easy-to-use REST API, available via HTTP.</p>\n<p>This gives developers a great deal of flexibility for creating applications that use a WordPress backend and brings WordPress one step closer to being a complete application framework.</p>\n<h2>What Now?</h2>\n<p>Decoupled CMS is still a new concept, and as a community it is important to share our methods and what we learn as we continue to experiment with such projects, ultimately standardizing on best practices for the future.The possibilities for decoupled are endless, and it’s up to the open-source community to lead the charge and document what we learn.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 21:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WordPress for iOS: Version 5.4 Adds Statistical Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47740\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wptavern.com/wordpress-for-ios-version-5-4-adds-statistical-insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2285:\"<p>WordPress for iOS: Version 5.4 is <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">available on the app store</a> and includes a couple of new features. To compliment the <a href=\"http://wptavern.com/wordpress-for-ios-5-3-released-with-refreshed-stats-and-a-new-layout-for-posts-and-pages\">improvements to stats in 5.3</a>, 5.4 adds a new stats screen called insights.</p>\n<p>Insights is similar to the Right Now widget in the WordPress dashboard in that it displays a summary of key statistics for a site including, total number of published posts, views, visitors, and the best traffic day. There&#8217;s also a section that displays the current day&#8217;s stats.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/IMG_7433.png\"><img class=\"size-large wp-image-47744\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/IMG_7433.png?resize=282%2C500\" alt=\"Stat Insights\" /></a>Stat Insights\n<p>Prior to 5.4, you could only add images to posts that were stored on the device. WordPress for iOS 5.4 adds the ability to insert images from the WordPress media library.</p>\n<p>To add an image from the WordPress media library, select media library from the menu at the top of the screen. If you have a lot of items in the media library, it may take a few minutes to load.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/WPiPhoneMediaLibrary.png\"><img class=\"aligncenter size-large wp-image-47746\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/WPiPhoneMediaLibrary.png?resize=500%2C399\" alt=\"WP For iOS 5.4 Media Library Selection\" /></a>Other improvements include the ability to search the My Sites list and viewing embedded images in comments. This makes it easier to see the full context of a comment without having to view it in a different part of the app.</p>\n<p>Last but not least, the team fixed a bug that caused the app to not restore its state properly. WordPress for iOS: Version 5.4 is <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">free and available</a> on the app store. If you encounter any issues, you&#8217;re encouraged to report them on the <a href=\"https://ios.forums.wordpress.org/\">WordPress for iOS support forums</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 20:15:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Short Interview With Nikolay Bachiyski WordPress’ Security Czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2331:\"<p>While on stage at <a href=\"https://europe.wordcamp.org/2015/\">WordCamp Europe</a> answering a question related to WordPress’ security track record, Matt Mullenweg named <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a> as the first Security Czar for the <a href=\"https://wordpress.org/\">WordPress project</a>.</p>\n<p>I interviewed Bachiyski to learn why the role was created and what its purpose is.</p>\n<p><strong>What are the responsibilities of your new role?</strong></p>\n<p>My responsibilities are to coordinate the security efforts of<span class=\"Apple-converted-space\"> </span><a href=\"http://wordpress.org/\" target=\"_blank\" rel=\"noreferrer\">WordPress.org</a><span class=\"Apple-converted-space\">, </span>mostly with incident response and to make sure we respond quickly, have solid fixes, and make sure everyone involved is informed.</p>\n<p><strong>What circumstances led to this role&#8217;s creation?<br />\n</strong></p>\n<p>Nothing too spicy around the creation of the role. As the volume of requests increased, we realized a bit more structure would be helpful so that we are more focused and use our resources wisely.</p>\n<p><strong>Will you only handle security issues for the open source project or will you also help with Automattic’s bounty program as well?</strong></p>\n<p>There are other colleagues at Automattic who are responsible for the bounty program.</p>\n<p><strong>How important are the connections and trust you’ve established over the last 11 years to your role?</strong></p>\n<p>Offline relationships are very important in an online community and I am lucky to know many of the members of the security team in person. This definitely makes working with them easier.</p>\n<h2>Learn More About the WordPress Security Team</h2>\n<p>If you&#8217;d like to learn more about who&#8217;s on the WordPress security team, what they do, and how they handle security releases, listen to my interview with Gary Pendergast.</p>\n<p>Pendergast who works for Automattic, is a WordPress core contributor, and a member of the WordPress core security team. In the interview, we discuss what happened behind the scenes before <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\">4.2.3 was released</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 18:26:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"WPTavern: WPWeekly Episode 203 – Interview With Kiko Doran Co-organizer of Prestige Conference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47721&preview_id=47721\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/wpweekly-episode-203-interview-with-kiko-doran-co-organizer-of-prestige-conference\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2165:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://kikodoran.com/\">Kiko Doran</a>, co-organizer of <a href=\"http://prestigeconf.com/\">Prestige conference</a>. Doran describes how he discovered WordPress in 2009 and explains the origin of Prestige, a career and business development conference.</p>\n<p>We discuss the <a href=\"http://wptavern.com/the-mantra-of-family-comes-first\">mantra of family first </a>and how Brazilian Jiu Jitsu helps him in his everyday life. Near the end of the interview, we learn Prestige 4 is in the planning stages.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-plugin-directory-surpasses-one-billion-total-downloads\">WordPress Plugin Directory Surpasses One Billion Total Downloads</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/site-import/\">Site Import</a> allows you to import posts and items from other websites without having to export anything. The content is extracted directly from the site.</p>\n<p><a href=\"https://wordpress.org/plugins/followprice/\">Followprice</a> adds a button to your storefront that when clicked, saves products into a universal wish list. This allows visitors to subscribe and receive price or stock alerts from your store.</p>\n<p><a href=\"https://wordpress.org/plugins/revision-strike/\">Revision Strike</a> is designed to automatically remove unneeded revisions on older, published posts.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 19th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #203:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 16:31:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt: Avis GPS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://ma.tt/2015/08/avis-gps/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2713:\"<p>After an amazing WordCamp Scranton on Saturday I was heading to a friend&#8217;s birthday on Long Island on Sunday, a few people were surprised I had flown from New York and said driving took about the same amount of time when you factor in all the airport hassle.</p>\n<p>I Google Mapped it and it did look like it was only 5-6 hours from Scranton to where I was going. Being a born and raised Texan, I love a good drive, and I probably haven&#8217;t had a proper road trip since my sister&#8217;s birthday a few years ago when we went up Highway 1. I&#8217;ve also never driven on the East Coast, and it seemed like there were some really pretty parks and lakes in between Scranton and Long Island so I ended up going to the airport anyway because that&#8217;s where the rental cars were.</p>\n<p>I like <a href=\"http://www.avis.com/\">Avis</a>. They try harder. <img src=\"http://i2.wp.com/s.ma.tt/blog/wp-includes/images/smilies/simple-smile.png?w=604\" alt=\":)\" class=\"wp-smiley\" /> One thing they do that&#8217;s pretty cool is sell  decent cables, USB wall chargers, and car chargers for a cheap price right at the check-in desk. (I always carry my own car charger, <a href=\"http://www.amazon.com/Incase-Speed-Charger-Lightning-Cable/dp/B00P7Y6M2Y/\">this is my current pick</a>. It&#8217;s super-handy in Ubers as well.) Amazingly though they still try to give you one of those Garmin GPS units that&#8217;s worse than your smartphone in every possible way. I&#8217;m sure it&#8217;s a money maker, otherwise the only reasonable thing to do would be provide <a href=\"http://www.amazon.com/dp/B00O5JARCI\">a smartphone mount</a> (or have one already set up in the car) rather than saddling people with an <a href=\"http://www.amazon.com/gp/bestsellers/electronics/559938/ref=zg_b_bs_559938_1\">archaic, non-networked navigation device</a> that has no idea about construction or traffic.</p>\n<p>I ended up going to a Walmart that was nearby to pick up a car mount (price, $12) that ended up being a life-saver for the trip. <strong>I also believe that every person in tech should visit Walmart at least once a year, and spend time in their technology section.</strong> It&#8217;s good to understand and see how people who don&#8217;t live for technology every day interact with it. It&#8217;s eye-opening, and it&#8217;s handy to know what&#8217;s in stock in case you need 50 feet of ethernet at 4 AM.</p>\n<p>Dropping the car off in Manhattan, it looks like they charged me $20 for a GPS which I don&#8217;t even have, so now going to need to sort out both the fee and the &#8220;missing&#8221; GPS system.</p>\n<p>tl; dr: Smart car rental companies should ditch the GPS, provide smartphone mounts instead.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2015 02:44:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Matt: Filled With Wonder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45288\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://ma.tt/2015/08/filled-with-wonder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"<blockquote><p>Teach when you are filled with wonder, before you become a boring expert.</p>\n<p>— Mark Pilgrim</p></blockquote>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Aug 2015 01:44:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Organizing Team Explains Why Philadelphia Should Host WordCamp US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47699\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wptavern.com/organizing-team-explains-why-philadelphia-should-host-wordcamp-us\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2198:\"<p>When organizing teams in different <a href=\"http://wptavern.com/wordcamp-us-2015-now-accepting-applications-for-host-city\">cities applied to host</a> WordCamp US earlier this year, they provided a substantial amount of information through the application process. While <a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">Philadelphia will host</a> the event in 2015 and 2016, their application is not public information.</p>\n<p>Juliana Reyes, who writes for <a href=\"http://technical.ly/philly\">Technical.ly Philly</a>, acquired and <a href=\"http://technical.ly/philly/2015/08/11/wordcamp-us-philadelphia-wordpress-devs/\">published a few</a> of the responses from the organizing team&#8217;s application, specifically questions four, nine, ten, and eleven.</p>\n<p>Question nine on the application asks, why do you think your city should host WordCamp US 2015? The organizing team responded:</p>\n<blockquote>\n<p dir=\"ltr\">Philadelphia is the birthplace of our nation. The United States started here, and so should WordCamp US.</p>\n<p dir=\"ltr\">We’re ideally situated on the East Coast between New York and Washington DC, and the halfway point between the West Coast and parts of Europe.</p>\n<p dir=\"ltr\">With a population of 1.5 million, it is the 5th largest city in North America, and is a cultural hub for all things food, music, art, and technology. It is well-known for its many excellent medical and educational facilities, including the University of Pennsylvania, Temple University, Drexel University, and the University of the Sciences.</p>\n<p dir=\"ltr\">With over 1,200 daily inbound and outbound flights, Philadelphia is easy to reach from anywhere in the world. The average hotel room and cost of living, is far below any other major East Coast city, and nowhere else has cheesesteaks like we do.</p>\n</blockquote>\n<p dir=\"ltr\">I&#8217;ve yet to visit Philadelphia but one thing I&#8217;ve learned is that residents take their reputation for cheesesteaks seriously. Be sure to read <a href=\"http://technical.ly/philly/2015/08/11/wordcamp-us-philadelphia-wordpress-devs/\">the post</a> to see the team&#8217;s responses to the other three questions.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 18:58:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: ThemeConf a Conference for Front-End Developers and Designers September 2nd-4th, 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47686\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://wptavern.com/themeconf-a-conference-for-front-end-developers-and-designers-september-2nd-4th-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2009:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/ThemeConfLogo.png\"><img class=\"alignright size-full wp-image-47688\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/ThemeConfLogo.png?resize=215%2C181\" alt=\"ThemeConf Logo\" /></a><a href=\"http://themeconf.com/\">ThemeConf</a> is a new conference set to take place September 2nd-4th, 2015, in Keswick, England aimed at front-end developers and designers. Confirmed speakers include a handful of Automattic theme wranglers, Noel Tock of Human Made, freelancer Adam Onishi, and Chris Hutchinson of The Times.</p>\n<p>The session schedule is expected to be released later this week however, here are some of the topics that will be covered at the event.</p>\n<ul>\n<li>Craft, workflow and best practices</li>\n<li>Browser performance and developer tools</li>\n<li>Design and photography</li>\n<li>JavaScript and REST APIs</li>\n<li>User experience</li>\n<li>Build tools</li>\n</ul>\n<p>Jack Lenox and Tammie Lister, who are the primary organizers of the event, originally came up with the idea for ThemeConf at the Automattic UK Christmas dinner, &#8220;Lenox wanted to bring a conference to where he lives in the Lake district and I wanted to do one focusing on themes,&#8221; Lister said.</p>\n<p>The two have been planning the event since January of this year. Although most of the confirmed speakers work with WordPress, ThemeConf is not dedicated to it, &#8220;It&#8217;s geared to those making themes in general and working on the front end. We have tried hard not to focus on WordPress,&#8221; Lister said.</p>\n<p><a href=\"https://ti.to/themeconf/2015\">Tickets for ThemeConf</a> are £49 and £99 respectively. The £49 tickets are for speaker sessions only while the £99 tickets include access to a workshop on using the REST API and lunch. Accommodations in the Lake District two hours from Manchester, Glasgow, Edinburgh, Newcastle, Liverpool and Leeds are available through <a href=\"http://www.keswick.org/\">Keswick.org.</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 16:37:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: $46M Scam\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"http://ma.tt/2015/08/46m-scam/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:384:\"<p>An incredible story: <a href=\"http://krebsonsecurity.com/2015/08/tech-firm-ubiquiti-suffers-46m-cyberheist/\">Tech Firm Ubiquiti Suffers $46M Cyberheist</a>. Notable for two reasons: I love Ubiquiti&#8217;s products, <a href=\"https://www.ubnt.com/products/#enterprise\">especially their Unifi line</a>, and I&#8217;ve never heard of phishing getting so much from a single victim.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 06:33:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: WordPress Plugin Directory Surpasses One Billion Total Downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47673\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/wordpress-plugin-directory-surpasses-one-billion-total-downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1706:\"<p>The WordPress project achieved a milestone earlier today as the official WordPress plugin directory <a href=\"https://wordpress.org/plugins/\">surpassed one billion</a> total downloads.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/1billiondownloads.png\"><img class=\"size-full wp-image-47674\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/1billiondownloads.png?resize=944%2C312\" alt=\"One billion total plugin downloads\" /></a>More than one billion total downloads\n<p>According to Scott Reilly who helps maintain WordPress.org, we&#8217;ll never know which plugin generated the one billionth download. That&#8217;s because WordPress.org doesn&#8217;t log information that matches downloads to plugins.</p>\n<p>&#8220;A download counter exists for each plugin for each day and the total amount is the summation of all those daily download counts,&#8221; Reilly said.</p>\n<p>As WordPress&#8217; <a href=\"http://w3techs.com/technologies/details/cm-wordpress/all/all\">market share</a> continues to grow, so does the amount of downloads from the plugin directory. The following numbers are the total amount of downloads from March 2006 to August 2015. This year, the directory is on pace to serve more than 300 million downloads.</p>\n<ul>\n<li>March 2006  191,567</li>\n<li>2007  2,845,802</li>\n<li>2008  15,130,856</li>\n<li>2009  49,822,116</li>\n<li>2010  72,342,598</li>\n<li>2011  108,501,907</li>\n<li>2012  141,609,682</li>\n<li>2013  182,236,517</li>\n<li>2014  241,142,505</li>\n<li>January 2015 to August 2015  186,243,700</li>\n</ul>\n<p>It took nine years for the plugin directory to reach one billion downloads, when do you think it will reach two billion?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2015 03:41:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: SkiPress a Week Long Excursion in the French Alps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47654\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/skipress-a-week-long-excursion-in-the-french-alps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1333:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/SkiPressFeaturedImage.png\"><img class=\"aligncenter size-full wp-image-47658\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/08/SkiPressFeaturedImage.png?resize=852%2C269\" alt=\"SkiPress Featured Image\" /></a>If you enjoy skiing and WordPress, mark your calendars for <a href=\"http://skipressweek.com/\">SkiPress</a>, November 21-28, 2015. SkiPress is a week long excursion to Serre Chevalier, a ski resort in the French Alps. The cottage can hold up to 15 people where attendees can ski, discuss WordPress, develop code, or disconnect from technology.</p>\n<p><a href=\"http://skipressweek.com/\">Bernard-Jacquet</a> who writes for <a href=\"http://wp-spread.com\" target=\"_blank\">WP-spread</a>, and helps organize the local WordPress meetup in Grenoble, France, is organizing the event.</p>\n<p>Rooms at the cottage cost 350 euros. This amount covers the room for a week plus dinner at two restaurants. Prepare to bring some extra cash as the bus, skipass, and ski rental are additional costs.</p>\n<p>There&#8217;s not an official deadline to book a room but the sooner you book the better. If you&#8217;re interested in booking a room, please <a href=\"http://skipressweek.com/\">contact Berard-Jacquet</a> as soon as possible so he can make arrangements.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 20:29:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Richard Best Publishes Human Readable Version of the GPLv2 License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/richard-best-publishes-human-readable-version-of-the-gplv2-license\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2234:\"<p>WordPress is licensed under the <a href=\"https://wordpress.org/about/gpl/\">GPLv2</a> and the four freedoms it allows is considered to be its <a href=\"http://ma.tt/2014/01/four-freedoms/\">Bill of Rights</a>. The four freedoms are:</p>\n<ol start=\"0\">\n<li>The freedom to run the program, for any purpose.</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish.</li>\n<li>The freedom to redistribute copies so you can help your neighbor.</li>\n<li>The freedom to distribute copies of your modified versions, giving the community a chance to benefit from your changes.</li>\n</ol>\n<p>There is a lot more to the GPL than the four freedoms listed above however, the license details can be difficult to read and decipher. Richard Best, a qualified lawyer in New Zealand, England, and Wales, has published a <a href=\"http://wpandlegalstuff.com/a-human-readable-summary-of-the-gpl/\">human readable summary</a> of the GPL license.</p>\n<p>Inspired by how Creative Commons offers a <a href=\"http://creativecommons.org/licenses/by/3.0/\">human readable version</a> of its licenses, the summary explains the core concepts of the GPL and outlines the position in relation to copying, distribution, fees, modifications/derivative works, distributing non-source forms, termination, and downstream licensing.</p>\n<p>It&#8217;s important to note that the document is not endorsed by the Free Software Foundation nor a substitute for the full license text.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/GPLSummarySample2.png\"><img class=\"size-full wp-image-47647\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/08/GPLSummarySample2.png?resize=705%2C554\" alt=\"Sample of the human readable summary of the GPL\" /></a>Sample of the human readable summary of the GPL\n<p>I encourage everyone participating in the WordPress ecosystem to read the <a href=\"https://wordpress.org/about/gpl/\">full license</a> text at least once. However, the summary does a good job explaining the core components of the GPL without having to dig into the license.</p>\n<p>If you have questions concerning the GPL, I suggest seeking legal council with a lawyer familiar with software licensing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 18:31:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WPWeekly Episode 202 – Prestige is Serious Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47628&preview_id=47628\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"http://wptavern.com/wpweekly-episode-202-prestige-is-serious-business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2339:\"<p>On this week&#8217;s episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I talk about the news of the week, including the release of WordPress 4.2.4 which patches six security vulnerabilities.</p>\n<p>I shared my experience attending Prestige last weekend while Marcus describes what it was like to watch the livestream. Marcus and I closed out the show with a candid conversation on the difficulty of achieving balance between work and life.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\">WordPress 4.2.4 Patches Six Security Vulnerabilities</a><br />\n<a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\"> Recap of Prestige a Conference Geared Towards Growing Businesses</a><br />\n<a href=\"http://nickhaskins.com/2015/07/on-life-and-family/\"> Aesop Interactive LLC For Sale</a><br />\n<a href=\"http://wptavern.com/the-mantra-of-family-comes-first\"> The Mantra of Family Comes First</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/export-plugins-and-templates/\">Export Plugins and Templates</a> exports your plugins and templates to a Zip file directly from the WordPress dashboard.</p>\n<p><a href=\"https://wordpress.org/plugins/expire-posts/\">Expire posts</a> automatically expires posts in WordPress and supports custom post types.</p>\n<p><a href=\"https://wordpress.org/plugins/local-seo-and-business-listings/\">Local SEO and Business Listings</a> allows you to optimize your local business website through a step by step actionable Local SEO Guide and a host of tools proven to increase web rankings.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 12th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #202:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Aug 2015 16:20:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: The WordPress Core Team Receives Praise for Their Efforts to Maintain Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47619\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"http://wptavern.com/the-wordpress-core-team-receives-praise-for-their-efforts-to-maintain-security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1832:\"<p>Netanel Rubin, a vulnerability researcher for <a href=\"http://www.checkpoint.com/\">Check Point Software</a> and <a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">credited</a> for properly disclosing a security vulnerability to WordPress, published the <a href=\"http://blog.checkpoint.com/2015/08/04/wordpress-vulnerabilities-1/\">first in a trilogy of posts</a> that explains how he discovered it.</p>\n<p>The vulnerability was discovered during a full audit of WordPress&#8217; code base in which Rubin praised the efforts of the WordPress development team.</p>\n<blockquote><p>In contrast to these frequent findings in 3rd party plug-ins’ code, barebones WordPress issues are rare, as WordPress core developers are well-trained to hold high security awareness for all released code.</p>\n<p>We can confirm that during our audit of the source code, we witnessed the developers ‘leaving nothing to chance’, and implementing multiple layers of security protecting most attack vectors we could think of.</p>\n<p>WordPress developers deserve praise for their efforts to maintain such complex software in this level of security, specifically considering the presence of the notoriously trigger-happy foot-gun called PHP.</p></blockquote>\n<p>I recommend <a href=\"http://blog.checkpoint.com/2015/08/04/wordpress-vulnerabilities-1/\">reading the post</a> as it&#8217;s a brief look into the mind of a <a href=\"https://en.wikipedia.org/wiki/White_hat\">white hat</a> security researcher.</p>\n<p>Although WordPress has <a href=\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\">seen its fair share</a> of security related releases this year, it&#8217;s reassuring to hear a third-party whose job it is to penetrate software security praise WordPress&#8217; codebase.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Aug 2015 00:05:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WPTavern: The Mantra of Family Comes First\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47609\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"http://wptavern.com/the-mantra-of-family-comes-first\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2219:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/FamilyFirstFeaturedImage.png\"><img class=\"size-full wp-image-47611\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/FamilyFirstFeaturedImage.png?resize=669%2C247\" alt=\"Family First Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/63122283@N06/11867028263\">Mama&#8217;s </a>&#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>At <a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\">Prestige over the weekend</a>, I heard a presenter say that family comes first. This isn&#8217;t the first time I&#8217;ve heard this advice but it&#8217;s becoming more prevalent. I generally hear this advice from those who are living comfortably, have two kids or more, and/or have gone through the startup process more than once.</p>\n<p>I&#8217;m a distributed worker who receives a check every two weeks. I&#8217;m married, have no kids, and write about WordPress for a living. Putting family first should be easy but it&#8217;s not. The last two years as a distributed worker, I&#8217;ve put work before family unless it&#8217;s an emergency.</p>\n<p>Two weeks ago, my wife and I had a serious conversation about the way I work and how it has negatively impacted our marriage. I&#8217;m a late owl and on most nights, my wife sleeps alone. As a distributed worker, I get to make the rules and put myself in the best environment to get the job done.</p>\n<p>The conversation with my wife involved words not fit for reproduction but everything she said was right. I&#8217;m spending too much time on digital devices and not enough with her. Our conversation was the wake up call I didn&#8217;t know I needed.</p>\n<p>It&#8217;s not easy putting family first all the time. Some argue that you need to put yourself before family so that you can provide for them. Others find a critical balance between spending time with family and getting the job done.</p>\n<p>How do you put family first when there are bills that need to be paid, sites to be built, and a constant deluge of work to be done? Please share your thoughts, experiences, and advice in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Aug 2015 01:43:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: WordPress 4.2.4 Patches Six Security Vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47605\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/wordpress-4-2-4-patches-six-security-vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2004:\"<p>WordPress <a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">4.2.4 is available</a> and patches six security vulnerabilities. The vulnerabilities were discovered by outside parties and members of the WordPress core security team. This release also fixes four bugs:</p>\n<ul>\n<ul>\n<li>WPDB: When checking the encoding of strings against the database, make sure we&#8217;re only relying on the return value of strings that were sent to the database. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/32279\">#32279</a></li>\n<li>Don&#8217;t blindly trust the output of <tt>glob()</tt> to be an array. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33093\">#33093</a></li>\n<li>Shortcodes: Handle <tt>do_shortcode(\'&lt;[shortcode]\')</tt> edge cases. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33116\">#33116</a></li>\n<li>Shortcodes: Protect newlines inside of <tt>CDATA</tt>. <a class=\"external text\" href=\"https://core.trac.wordpress.org/ticket/33106\">#33106</a></li>\n</ul>\n</ul>\n<p>It&#8217;s been a busy year for the WordPress security team. Since the beginning of the year, there has been five security releases.</p>\n<ul>\n<ul>\n<li><a href=\"https://wordpress.org/news/2015/04/wordpress-4-1-2/\">WordPress 4.1.2</a></li>\n<li><a href=\"https://wordpress.org/news/2015/04/wordpress-4-2-1/\">WordPress 4.2.1</a></li>\n<li><a href=\"https://wordpress.org/news/2015/05/wordpress-4-2-2/\">WordPress 4.2.2</a></li>\n<li><a href=\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\">WordPress 4.2.3</a></li>\n<li><a href=\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\">WordPress 4.2.4</a></li>\n</ul>\n</ul>\n<p>Users should check their sites to make sure they&#8217;re running 4.2.4. If your site hasn&#8217;t automatically updated yet, you should perform a full backup and manually update. Sites running WordPress RC 2 are safe since it fixes the same issues as 4.2.4.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 23:45:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Recap of Prestige a Conference Geared Towards Growing Businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47580\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4245:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/PrestigeconfFeaturedImage.png\"><img class=\"size-full wp-image-47595\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/08/PrestigeconfFeaturedImage.png?resize=677%2C268\" alt=\"Tony Perez of Sucuri\" /></a>Tony Perez of Sucuri Presenting on Security at Prestige\n<p>Over the weekend, I attended <a href=\"http://prestigeconf.com/\">Prestige</a>, a conference geared towards freelancers, entrepreneurs, and small agencies looking to grow their businesses. Unlike WordCamps, plugins, themes, and WordPress in general were rarely mentioned. Instead, sessions included high level topics such as, how to land enterprise clients, knowing when to move on to the next big thing, and the benefits of partnerships.</p>\n<p>The venue was perfect with plenty of space and the WiFi worked well. Lunch was an hour-long and provided on both days. The lunchroom can easily seat 300 people or more. Only a third of the space was used when attendees ate lunch providing a great environment to network with people.</p>\n<h2>Nancy Lyons and Technology&#8217;s Dirty Little Secret</h2>\n<p>Since I don&#8217;t deal with clients or own an agency, many of the sessions at Prestige are non-applicable to my day job. However, there is one session in particular that resonated with me. <a href=\"http://www.nancylyons.com/\">Nancy Lyons</a>, founder and CEO of <a href=\"http://www.clockwork.net/\">Clockwork</a>, shared her philosophies on hiring and getting employees engaged. Happy employees do good work but what makes them happy?</p>\n<ul>\n<li>Autonomy:  Control over time, technique, team, or task.</li>\n<li>Mastery: Make progress and get better.</li>\n<li>Purpose: Be part of something bigger.</li>\n</ul>\n<p>A lot of the tips shared by Lyons are geared towards employers but they&#8217;re just as applicable to employees. The biggest danger to agencies and freelancers is the inability to have conversations with clients about what is and isn&#8217;t possible. According to Lyons, you can love someone and still tell them what they need to hear. One of the best tips she shared is to find and have fun at work as there&#8217;s nothing wrong with having fun.</p>\n<h2>Behind the Scenes of the Livestream</h2>\n<p>Prestige is <a href=\"http://prestigeconf.com/free-livestream-minneapolis-2015/\">known for having</a> a high quality livestream where more than 1,000 people can watch the conference live. The livestream is produced by <a href=\"http://pixpromedia.com/\">PixProMedia</a>. The gentleman in charge uses a TriCaster to switch between speakers and slides during sessions. Here are a couple of photographs of his equipment.</p>\n<a href=\"http://wptavern.com/recap-of-prestige-a-conference-geared-towards-growing-businesses#gallery-47580-1-slideshow\">Click to view slideshow.</a>\n<p>According to some viewers, watching the livestream was like being at the conference but is not a substitute for face-to-face interactions.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">.<a href=\"https://twitter.com/jeffr0\">@jeffr0</a> The learning is like being there.  I miss the handshakes in the hallway, meeting people face-to-face.&#10;&#10;<a href=\"https://twitter.com/hashtag/prestigeconf?src=hash\">#prestigeconf</a></p>\n<p>&mdash; Cate DeRosia (@mysweetcate) <a href=\"https://twitter.com/mysweetcate/status/627924263799009280\">August 2, 2015</a></p></blockquote>\n<p></p>\n<h2>Westwerk Is a Great Venue for After Parties</h2>\n<p>The after party was held at <a href=\"http://westwerk.com/\">Westwerk</a>, a WordPress development agency and primary sponsor of the event. Their office was perfect for an after party as it includes, a foosball table, Nintendo Wii, shuffleboard, drinks, pool table, and small offices for private conversations. It&#8217;s one of the best after parties for a conference that I&#8217;ve attended.</p>\n<h2>Prestige is Serious Business</h2>\n<p>It may seem like a WordPress conference on the surface but Prestige is geared towards business minded people. It&#8217;s highly focused and filled with information you can apply to companies in and outside of WordPress. If you want to learn how to take your business to the next level, Prestige is an excellent value.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 20:40:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: How to Avoid This Embarrassing Sharing Bug on WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47476\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"http://wptavern.com/how-to-avoid-embarrassing-sharing-bug-on-wordpress-com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1804:\"<p>If you use the sharing feature on WordPress.com, you may have noticed an anomaly between your post title and what&#8217;s shared to social services. Since the post title is the first field to complete when writing a post, it makes sense to fill it in even if it&#8217;s a work in progress.</p>\n<p>The sharing module on WordPress.com has a bug where the initial text in a post title is used when sharing the post to social networks. For the past several months, I&#8217;ve published many articles on WordPress.com where the text within social links does not match the text used in the post title leaving me feeling embarrassed.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/BuginAction.png\"><img class=\"size-full wp-image-47477\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/BuginAction.png?resize=728%2C482\" alt=\"WordPress.com Bug in Action\" /></a>WordPress.com Bug in Action\n<p>To avoid this embarrassment, you&#8217;ll need to alter the text used in the sharing module before publishing each post. If you&#8217;re using the New Dash interface on WordPress.com, locate the Sharing metabox as seen in the screenshot above. When you&#8217;re ready to hit the publish button, change the text to match your title.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/TheCorrectPostTitle.png\"><img class=\"size-full wp-image-47478\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/TheCorrectPostTitle.png?resize=571%2C462\" alt=\"Post Title Matches the Sharing Text\" /></a>Post Title Matches the Sharing Text\n<p>I&#8217;ve spoken to several Automattic employees at various WordPress events and they&#8217;re aware of the bug. Until it&#8217;s fixed, you&#8217;ll need to remember to change the sharing text before you publish a post.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jul 2015 21:52:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WPWeekly Episode 201 – Interview With Paul Gibbs and John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47469&preview_id=47469\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://wptavern.com/wpweekly-episode-201-interview-with-paul-gibbs-and-john-james-jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2500:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://byotos.com/\">Paul Gibbs</a> and <a href=\"http://jjj.me/\">John James Jacoby</a>. Jacoby shares what he learned and accomplished <a href=\"http://wptavern.com/buddypress-bbpress-and-glotpress-development-campaign-is-now-fully-funded\">working on bbPress and BuddyPress</a> full-time for six months.</p>\n<p>Gibbs explains his motivation to organize the first ever <a href=\"https://brighton.buddycamp.org/2015/\">BuddyCamp Brighton, UK</a>, that takes place on August 8th. We also discuss a new working group dedicated to possibly bringing back <a href=\"http://backpress.org/\">BackPress</a>. Last but not least, Gibbs and Jacoby offer their opinions on <a href=\"http://wptavern.com/meet-peepso-buddypress-newest-competitor-in-open-source-social-networking-for-wordpress\">PeepSo</a>, a new social networking plugin for WordPress.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\">Philadelphia, PA to Host WordCamp US December 4th–6th</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/gallery-for-instagram/\">Instagram Gallery</a> displays a gallery from one or more Instagram accounts.</p>\n<p><a href=\"https://wordpress.org/plugins/backup-amazon-s3/\">Amazon S3 Backup and Restore</a> enables you to create full backups to Amazon S3 and restore, duplicate, clone, or migrate your site.</p>\n<p><a href=\"https://wordpress.org/plugins/responsivevoice-text-to-speech/\">ResponsiveVoice Text To Speech</a> is a HTML5 based text-to-speech library designed to add voice features to WordPress across all smart phone, tablet, and desktop devices. It supports 51 languages through 168 voices and has no dependencies.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 5th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #201:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Jul 2015 19:45:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Hong Kong Morning\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45280\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/07/hong-kong-morning/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:381:\"<p><span class=\"embed-youtube\"></span></p>\n<p>The upside of jet lag, like <a href=\"http://om.co/2015/07/10/paris-je-laime/\">Om discovering the streets of Paris</a>, are enjoying parts of the day you might not normally be awake for, like a beautiful sun rise. Here&#8217;s a time lapse I made of the Victoria Harbor in Hong Kong taken from the incredible view I have in my room.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 23:40:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Postmatic Brings 100% Realtime Commenting to WordPress with Epoch Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=44317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wptavern.com/postmatic-brings-100-realtime-commenting-to-wordpress-with-epoch-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7876:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch.jpg?resize=919%2C443\" alt=\"epoch\" class=\"aligncenter size-full wp-image-47416\" /></a></p>\n<p>The team behind <a href=\"https://gopostmatic.com/\" target=\"_blank\">Postmatic</a> is aiming to breathe new life into WordPress native comments with the 1.0 release of <a href=\"https://wordpress.org/plugins/epoch/\" target=\"_blank\">Epoch</a> today. The plugin was created to provide a Disqus alternative with faster loading and submitting for comments.</p>\n<p>Epoch&#8217;s creators set an ambitious goal for themselves on the plugin&#8217;s description page:</p>\n<blockquote><p>The goal: To provide a realtime commenting/chat experience using fully native comments while being compatible with page caching, CDNs, mobile, other comment plugins, and SEO best practices.</p></blockquote>\n<p>The plugin submits comments via AJAX, which means that comments appear instantly within the conversation without refreshing the page. The experience is designed to be so fast that it blurs the line between commenting and chatting, as comments from other readers also show up automatically with the same speed. The video below shows the plugin in action and a <a href=\"https://gopostmatic.com/epoch/#reply-title\" target=\"_blank\">live demo of Epoch</a> is available on the Postmatic website.</p>\n<p></p>\n<p></p>\n<p>Epoch <a href=\"https://wordpress.org/plugins/epoch/changelog/\" target=\"_blank\">version 1.0</a> boasts compatibility with virtually any WordPress theme. The plugin will attempt to integrate with your theme via one of three ways:</p>\n<ul>\n<li>The first tries to continue using your existing comment template while still offering all the performance gains</li>\n<li>The second overrides your comment template but inherits typography and colors from your theme</li>\n<li>The third totally replaces your comment template à la Disqus or Jetpack Comments</li>\n</ul>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-theme-integration.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-theme-integration.png?resize=1025%2C839\" alt=\"epoch-theme-integration\" class=\"aligncenter size-full wp-image-47442\" /></a></p>\n<p>Unlike Postmatic, which has a <a href=\"https://gopostmatic.com/premium/\" target=\"_blank\">commercial option</a> for additional features, founder Jason Lemieux says Epoch will not be directly monetized.</p>\n<p>&#8220;We do not have any plans to create a commercial version,&#8221; he said. &#8220;Postmatic is our primary product, Epoch exists only to make it easier for people to move back to native commenting, and in turn to use Postmatic. Epoch will be free forever.&#8221;</p>\n<h3>Compatibility with Other Comment Plugins</h3>\n<p>Epoch works seamlessly with Postmatic, i.e. it will pop up an opt-in modal allowing the commenter to subscribe to new post notifications. Using Postmatic in combination with Epoch is not required, because the plugin was created to work well on its own. It&#8217;s also compatible with many other plugins that extend comments.</p>\n<p>&#8220;Other third party native commenting plugins have taken a heavy-handed approach and do not support the comment template hooks built into WordPress,&#8221; Lemieux said. &#8220;This creates a walled garden in which the innovation and hard work present in existing and future comment plugins is left out.</p>\n<p>&#8220;We decided to take a different approach. We built Epoch to be compatible with other comment plugins as much as possible. Not all are, but with little tweaks here and there they work just fine.&#8221;</p>\n<p>Version 1.0 integrates perfectly out of the box with Postmatic, WordPress Zero Spam, Akismet, WP Markdown, and WordPress Social Login.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-plugin-compatibility.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/epoch-plugin-compatibility.png?resize=1025%2C583\" alt=\"epoch-plugin-compatibility\" class=\"aligncenter size-full wp-image-47447\" /></a></p>\n<p>&#8220;In our testing most anything that does not use a lot of JavaScript works just fine,&#8221; Lemieux said. &#8220;Things I haven&#8217;t tested but I assume would work would be anything that modifies or adds fields to the comment form (Subscribe to Comments, CommentLuv, various captchas).</p>\n<p>&#8220;Fancier plugins that allow for comment editing or sorting the comment order based on voting would probably not be happy. We will have to make that functionality ourselves.&#8221;</p>\n<h3>Epoch is a Disqus Alternative with an Emphasis on Privacy</h3>\n<p>When Lemieux and his team created Epoch, the strategy was to address problems with native commenting in order to pave the way for more users to get on board with Postmatic.</p>\n<p>&#8220;We didn&#8217;t set out with intentions of competing with Disqus,&#8221; he said. &#8220;However, a few months in it became clear that there are usually two reasons people were not using native comments, and we would need to address both if we wanted widespread adoption of Postmatic.</p>\n<p>&#8220;The first is that the comment templates that come with a huge majority of themes just plain stink. Theme developers hate dealing with them. It&#8217;s usually an afterthought. So the commenting experience suffers. It is slow, ugly, and not at all fun.</p>\n<p>&#8220;The second reason is that native commenting is extremely hard on the server. You can&#8217;t run native comments on a high traffic site. The server would buckle. A CDN won&#8217;t save you because the page content is constantly changing. For larger sites, native commenting is not even an option.</p>\n<p>&#8220;Both of these problems are solved easily with solutions like Livefyre or Disqus, so they get installed. But it&#8217;s just selling your users down the river. Your data is not yours, ads start showing up on your site. Privacy is out the window. And really, the performance gains are minimal when the embedded comments still take 10 second to load because there is so much tracking JavaScript being queued up in the background.&#8221;</p>\n<p>In contrast, Epoch loads faster than third party solutions and is completely private. Your commenters&#8217; data is not farmed out and comments stay on your server.</p>\n<p>&#8220;For the first time someone can say this: running native WordPress commenting will actually increase your site performance,&#8221; Lemieux said.</p>\n<h3>What&#8217;s on the roadmap for the future of Epoch?</h3>\n<p>Lemieux and his team hope to attract a larger community around the project, which is <a href=\"https://github.com/postmatic/epoch\" target=\"_blank\">open to contribution on GitHub</a>.</p>\n<p>&#8220;We plan on aggressively recruiting others to join the project and we hope other developers will be inspired by what we have started,&#8221; he said.</p>\n<p>&#8220;We are going to build out a small API to make it easier for other plugins to hook into some of the advanced functionality.</p>\n<p>&#8220;And there are a few things that feel like they may be necessary: comment voting and a simple little like button which would be handy as a way to say, &#8216;I appreciate what you said, I do not have anything else to add.&#8217; I would love to integrate that with Postmatic. I often will get a comment in my inbox and I want to recognize the thought that went into it, but don&#8217;t feel like I have anything to add. A simple little +1 would do it nicely,&#8221; Lemieux said.</p>\n<p>The 1.0 release of Epoch is exciting news for those who have been dissatisfied with WordPress native comments but are hoping for a reason to return. The plugin is open source and <a href=\"https://wordpress.org/plugins/epoch/\" target=\"_blank\">available for free on WordPress.org</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 17:45:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: Yuuta: A Free Visual Diary Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47303\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"http://wptavern.com/yuuta-a-free-visual-diary-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4045:\"<p>Earlier this month, <a href=\"http://wptavern.com/new-proposal-on-trac-to-remove-post-formats-from-wordpress-core\" target=\"_blank\">a new proposal landed on trac</a>, advocating the removal of <a href=\"http://codex.wordpress.org/Post_Formats\" target=\"_blank\">post formats</a> from core. Many believe that this feature would be better as a plugin, since it has received little improvement over the years and is not used by the majority of WordPress users.</p>\n<p>If the UI can be improved to be less confusing and theme support is standardized, post formats may have a chance at more widespread adoption. The feature is entirely dependent on theme support, as post formats are not enabled by default unless the theme author opts to include them. Many still do, which is why ripping them out of core in favor of a plugin would be a major undertaking.</p>\n<p>One of the most common use cases for post formats is a diary style WordPress theme. <a href=\"https://wordpress.org/themes/yuuta/\" target=\"_blank\">Yuuta</a> is a relatively popular theme on WordPress.org that revolves entirely around post formats. In the past four months, it has been downloaded more than 7,000 times. Yuuta was created to serve as a visual diary and includes support for all nine of WordPress&#8217; post formats.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta.png?resize=880%2C660\" alt=\"yuuta\" class=\"aligncenter size-full wp-image-47392\" /></a></p>\n<p>The theme was designed by Felix Dorner, owner of <a href=\"http://drnr.co/\" target=\"_blank\">Studio DRNR</a>, a Berlin-based web development company. According to its description page, Yuuta was selected as the the theme&#8217;s name based on its Japanese meaning:</p>\n<blockquote><p>Yuuta is a Japanese name and is made up of 優 (yuu) “gentleness, superiority”, 悠 (yuu) “distant, leisurely” or 勇 (yuu) “brave” combined with 太 (ta) “thick, big”.</p></blockquote>\n<p>Each post format has its own distinguishing icon and unique display. Dorner opted to use Roboto, Roboto Slab, and a sprinkling of Courier as the theme&#8217;s primary fonts. The typography choices were selected for optimal readability on all screen sizes.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-chat-format.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-chat-format.jpg?resize=961%2C526\" alt=\"yuuta-chat-format\" class=\"aligncenter size-full wp-image-47405\" /></a></p>\n<p>Yuuta also includes specific styles for both standard and Jetpack-enabled galleries.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-jetpack-enabled-gallery.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/yuuta-jetpack-enabled-gallery.jpg?resize=652%2C572\" alt=\"yuuta-jetpack-enabled-gallery\" class=\"aligncenter size-full wp-image-47407\" /></a></p>\n<p>The theme&#8217;s design is fairly set, unless you opt to create a child theme. There are zero options in the Customizer. Much of the design customization is done on a post-by-post basis, as the featured image serves as a unique background for the post. Yuuta also includes editor styles to match the editing experience to the theme&#8217;s frontend appearance.</p>\n<p>The primary navigation menu is hidden until toggled into view by the icon in the header, which keeps the reader focused on the content. There are no sidebars to contend with but widgets can be added to the footer.</p>\n<p>If you&#8217;re a fan of post formats, the Yuuta theme really makes them shine. It responds to display beautifully on all devices from desktop to tablet to smartphone. Check out a <a href=\"http://demo.felixdorner.com/yuuta/\" target=\"_blank\">live demo</a> on Dorner&#8217;s website to see each post format in action. You can download <a href=\"https://wordpress.org/themes/yuuta/\" target=\"_blank\">Yuuta</a> for free from WordPress.org or install it via your admin themes browser.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Jul 2015 04:06:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Awesome Geek Podcasts: A Curated List of Tech Podcasts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/awesome-geek-podcasts-a-curated-list-of-tech-podcasts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2834:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/headphones.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/headphones.jpg?resize=960%2C482\" alt=\"photo credit: Jan Vašek\" class=\"size-full wp-image-47389\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/3YOVALG5DX\">Jan Vašek</a>\n<p>The WordPress community produces a couple dozen high quality podcasts covering diverse topics, such as weekly news, business/entrepreneurship, education, and development. Every year the best WordPress-related podcasts are featured in <a href=\"http://iamdavidgray.com/best-wordpress-podcasts/\" target=\"_blank\">roundup posts</a> highlighting shows that are publishing new episodes regularly.</p>\n<p>One way to venture outside the WordPress world is to expand your horizons when it comes to podcast subscriptions. <a href=\"https://github.com/cv/awesome-geek-podcasts\" target=\"_blank\">Awesome Geek Podcasts</a> is a curated list of tech podcasts that was first published in May of this year on GitHub. Since that time the repository has received 121 commits from 34 contributors.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/awesome-geek-podcasts.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/awesome-geek-podcasts.png?resize=1025%2C551\" alt=\"awesome-geek-podcasts\" class=\"aligncenter size-full wp-image-47382\" /></a></p>\n<p>None of the podcasts listed in the repo are directly related to WordPress, but many cover topics related to the various technologies that work in and with WordPress. The list includes approximately seven PHP-related podcasts in English (and more in other languages), along with shows focused on JavaScript, Sass, Git, and other technologies.</p>\n<p>Other topics included in the Awesome Geek Podcasts list that might be of interest to WordPress developers include:</p>\n<ul>\n<li>Running software companies</li>\n<li>Software design, creation, and delivery</li>\n<li>Front end web design, development, and UX</li>\n<li>Typography, design, prototyping</li>\n<li>Open source software</li>\n<li>Family and life/work balance</li>\n</ul>\n<p>Several of those listed follow a short format of 5 and 10-minute episodes for developers who are short on time. No matter where your interests lie in the various aspects of &#8220;geek life,&#8221; the Awesome Geek Podcast list has something for everyone.</p>\n<p>Currently the list has separate sections for shows in English, Portuguese, Spanish, Russian, Persian, and Swedish, but it is open to contribution. Although it doesn&#8217;t seem to include many podcasts that focus on specific CMS platforms, you can try <a href=\"https://github.com/cv/awesome-geek-podcasts/blob/master/CONTRIBUTING.md\" target=\"_blank\">submitting a pull request</a> for the inclusion of your WordPress-related podcast.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 20:58:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Behind the Scenes of WordPress 4.2.3 With Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47354\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/behind-the-scenes-of-wordpress-4-2-3-with-gary-pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2253:\"<p>When <a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\">WordPress 4.2.3 was released</a> last week, not only did it patch a critical security vulnerability, but also <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\">adversely impacted</a> a number of sites. Changes to the Shortcode API which were necessary as part of the patch caused some plugins that rely on the API to break. These changes were not immediately communicated to plugin developers. Nearly eight hours after its release, a <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/\">post published</a> on the Make WordPress Core blog explained the changes.</p>\n<p>The release process of WordPress 4.2.3 left <a href=\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites#comments\">plugin authors and users</a> scratching their heads. On one hand, point releases are not supposed to break anything. On the other, affected plugin authors were left in the dark for nearly eight hours wondering why a point release broke their plugins.</p>\n<p><a href=\"http://pento.net/\">Gary Pendergast</a> who works for Automattic, is a WordPress core contributor, and a member of the WordPress core security team, reached out to me for an interview. In the following conversation, we discuss what happened behind the scenes before 4.2.3 was released.</p>\n<p>He clears up some confusion on when the changes to the Shortcode API were implemented. He also admits the team made some mistakes and has already implemented changes to improve the release process. One of those changes includes publishing a post on the Make WordPress Core blog as soon as the update is pushed out to sites.</p>\n<p>I appreciate and thank Pendergast for reaching out to me to have this conversation. I look forward to similar collaborations with members of the core team in the future. A transcription of this interview is not available but if you have it transcribed and would like to make it available to the public, please <a href=\"http://wptavern.com/contact-me\">contact me</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 19:02:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WordPress Theme Review Team Votes to Allow Themes to Use the REST API Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47342\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://wptavern.com/wordpress-theme-review-team-votes-to-allow-themes-to-use-the-rest-api-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3363:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/colored-pencils.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/04/colored-pencils.jpg?resize=960%2C470\" alt=\"colored-pencils\" class=\"aligncenter size-full wp-image-42610\" /></a></p>\n<p>During this week&#8217;s WordPress Theme Review Team meeting, members considered the possibility of allowing themes hosted in the directory to make use of the <a href=\"https://wordpress.org/plugins/rest-api/\" target=\"_blank\">WP REST API plugin</a>. Since the API is not yet included in core, any theme or plugin author who wants to use it must have the feature plugin installed.</p>\n<p>Ordinarily, WordPress.org themes are not allowed to require a plugin on installation (although they can suggest one). As per the <a href=\"https://make.wordpress.org/themes/handbook/review/required/#plugins\" target=\"_blank\">Theme Review Handbook on plugins</a>: <em>A theme can recommend plugins but not include those plugins in the theme code.</em></p>\n<p>&#8220;The core team has asked us to consider temporarily allowing the requirement of the REST API for themes that may take advantage of it,&#8221; Tammie Lister said before calling for a vote. She also noted that waiving the rule would be temporary, as the API will soon be going into core.</p>\n<p>&#8220;This does not open up the way for others as an exception because it&#8217;s a core feature,&#8221; she said.</p>\n<p>The team took a quick vote and all present unanimously agreed to allow themes to require the REST API plugin as a temporary measure until it is available in core. Check out the <a href=\"https://make.wordpress.org/themes/2015/07/28/theme-review-team-weekly-meeting-notes-the-logs-7/\" target=\"_blank\">meeting logs</a> for the full discussion.</p>\n<p>The WP REST API is already being used in production in many different ways around the web, as revealed in the comments on project leader Ryan McCue&#8217;s recent <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">post</a> calling for examples. If the Theme Review Team wants to keep pace with where WordPress is headed, it must offer the flexibility to allow for more innovative themes. Temporarily waiving the guideline against plugin requirements is a smart move.</p>\n<p>As WordPress.org accrues more examples of themes that use the REST API in a way that complies with the review team&#8217;s high standards, developers who are just getting started will have strong examples for creating their own. Jack Lenox&#8217;s presentation at WordCamp London this year highlighted a few of the benefits of theming with the REST API:</p>\n<ul>\n<li>Provides a way to retrieve pure data (usually in JSON or XML format) over HTTP</li>\n<li>No loops necessary</li>\n<li>Good for mobile apps and environments where you don’t want a full webpage to render but want content from a blog or site</li>\n</ul>\n<p>With the official directory now welcoming these types of themes, it won&#8217;t be long before the entire landscape of WordPress theme development changes to support more modern ways of presenting content. Check out Jack Lenox&#8217;s presentation on <a href=\"http://wptavern.com/jack-lenox-on-building-themes-with-the-wp-rest-api\" target=\"_blank\">Building themes with the WP REST API</a> for information on how to get started.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 17:30:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Post Status: Don’t make enemies, invest in friendships\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=13860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://poststatus.com/invest-in-friendships/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4756:\"<p><em>Editor&#8217;s note: The following is a guest post by <a href=\"http://corymiller.com/about/\">Cory Miller</a>, the CEO of <a href=\"https://ithemes.com\">iThemes</a>. Cory describes his approach to making friends and avoiding making enemies. You should also check out his recent <a href=\"http://corymiller.com/my-talk-on-mental-health-and-entrepreneurship-is-now-online/\">talk on mental health and entrepreneurship</a>, which is terrific.</em></p>\n<p>I’d rather wave a white flag and compromise than make an enemy. Every. Single. Day.</p>\n<p>I’ve purposefully and intentionally, throughout my life (and business), sought to <em>not</em> make enemies, but rather build friendships.</p>\n<ul>\n<li>Enemies are only trouble.</li>\n<li>Enemies are distractions.</li>\n<li>Enemies eat my time and energy and focus.</li>\n<li>Enemies seek your destruction.</li>\n<li>Enemies oppose you.</li>\n<li>Enemies seek to “harm or weaken” you.</li>\n</ul>\n<p>Friends do the opposite.</p>\n<p>My best example of this is my wife, Lindsey. I think of her as my greatest ally and my best friend. She’s the opposite of an enemy.</p>\n<p>The words I use to describe her are “caring,” “supportive,” “loving,” and “wants my best.”</p>\n<p>So why would I spend my time seeking to <em>create</em> enemies, instead of friendships?</p>\n<ul>\n<li>You can have opinions.</li>\n<li>You can take stands.</li>\n<li>You can and should draw boundary lines.</li>\n<li>You can have your principles and <em>never</em> budge on them.</li>\n</ul>\n<p><em>But,</em> you can also, simultaneously, choose to make and focus on friendships.</p>\n<p>Some of my best friendships have come through business, and some of them would be considered “competitors.”</p>\n<p>But I’ve cherished those friendships.</p>\n<p>Additionally, I sleep better at night knowing we only want each other’s best and that there is plenty of room for each other instead of someone actively, purposefully seeking my destruction.</p>\n<p>But instead of seeking to fester anger and hate and competition, I’ve sought the opposite, asking, &#8220;Where can we find ways to help each other do better for each other?&#8221;</p>\n<p>So what if we approached life and business like this:</p>\n<p>Instead of using that anger, bile, jerk-ness, and negative energy in telling the world who you hate and how big of a jerk you can be, and how you don’t want to be an enemy of &#8212; why not seek to build true, lasting, deep friendships?</p>\n<p>The old quote, “Keep your friends close, and your enemies closer,” is pure B.S.</p>\n<p>Why not create a friend instead of nurture an enemy?</p>\n<p>Why not tell the world that you can be the <em>best</em> friend they ever made? And prove it by your actions.</p>\n<p>Friendships do take an investment. They take consistency. They take time. They take compromise sometimes. It means showing up for them when they most need it.</p>\n<p>But those relationships have been some of the richest relationships I’ve ever had. And totally worth the investment (multiple times over and over in fact).</p>\n<p>And yes, I have made enemies in my life. Purposefully and sometimes not. In fact, someone recently asked me jokingly on Twitter who didn’t like me. I responded with:</p>\n<p>“I can think of 1 or 2 a-holes but I don’t like thinking about them. <img src=\"https://poststatus.com/wp-includes/images/smilies/simple-smile.png\" alt=\":)\" class=\"wp-smiley\" /> hahahahaha”</p>\n<p>And although that’s sadly true, I’ve sought to minimize the enemies I’ve made in my life and business.</p>\n<p>My perspective on making necessary enemies is that <em>if</em> you <em>have</em> to make an enemy &#8212; and when I say that, I don’t mean because your personality defaults to that of a jerk and you sadistically like being labeled one), but you <em>have</em> to make an enemy because you have to set a boundary and tell someone no, or take a legal action &#8212; make dang sure it’s either for a <em>very</em> good purpose, value or strategic reason.</p>\n<p>And even then, question yourself about why.</p>\n<p>As my attorney told me recently: “You catch more flies with honey.”</p>\n<p>So don’t be a jerk while making enemies. You’ll make <em>more</em> enemies in the process.</p>\n<p>Simple, lip-biting kindness in the face of anger and hate and bile helps deflate a situation rather than pour lighter fluid on it.</p>\n<p>I tell people often: it doesn’t cost me anything to be nice and kind. (In fact most of the time it makes me happier.) And I seek out different avenues to vent my frustration and relieve my stress.</p>\n<p>So I say: Don’t make enemies. Invest in friendships.</p>\n<p>It should be common sense, but sometimes I (and maybe you) need a reminder.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 05:13:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Cory Miller\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: Adler: A Unique Personal Blogging Theme for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47272\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/adler-a-unique-personal-blogging-theme-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3395:\"<p>If you&#8217;re on the hunt for a new WordPress blogging theme but the designs are all starting to look too similar, you may want to check out <a href=\"https://wordpress.org/themes/adler/\" target=\"_blank\">Adler</a>. It is one of the more unique themes to land in the WordPress.org directory in recent months with its uncommon typography choices and bright bursts of color.</p>\n<p>Adler was created by Romanian theme designer <a href=\"https://twitter.com/BabBarDeL\" target=\"_blank\">George Olaru</a> of <a href=\"https://pixelgrade.com/\" target=\"_blank\">Pixelgrade</a>. Olaru takes a unique approach to the popular fullscreen splash page style that many themes have adopted for a homepage layout, overlaying it with a serif font title paired with a hand-script style subtitle.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler.png?resize=880%2C660\" alt=\"adler\" class=\"aligncenter size-full wp-image-47315\" /></a></p>\n<p>Styling for single posts is similar to the home page with the featured image serving as a fullscreen background for the title. Scroll further down and the post content is centered with no distracting sidebar widgets.</p>\n<p>Adler combines two unusual Google font choices in the design: Droid Sans Mono for paragraph text and Permanent Marker for blockquotes and subtitles. Images in posts overhang the text column to create a strong visual impact.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler-images-blockquotes.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/adler-images-blockquotes.jpg?resize=810%2C812\" alt=\"adler-images-blockquotes\" class=\"aligncenter size-full wp-image-47318\" /></a></p>\n<p>Adler&#8217;s files include a tiny leaf icon that is tastefully applied on the home and archive templates to separate posts. The effect is minimalist without appearing to be stark. The theme also includes support for Font Awesome icons.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/font-awesome.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/font-awesome.jpg?resize=656%2C534\" alt=\"font-awesome\" class=\"aligncenter size-full wp-image-47320\" /></a></p>\n<p>The necessity for large featured images can sometimes be a drawback for users when selecting a blogging theme. After testing Adler, I found that the design doesn&#8217;t break if you don&#8217;t have a large featured image assigned to a post. In fact, posts lacking a featured image look just as nice as those that include one, so you&#8217;re not tied down to hunting for one every time you publish.</p>\n<p>Adler supports three menu locations for a primary, footer, and social menu. It includes support for one footer widget area, which spans three columns. There are just two options available in the native customizer that allow you to change the background color or add a background image.</p>\n<p>Adler was created to be a personal blogging theme and the design instantly communicates: &#8220;I have something to say.&#8221; Check out the <a href=\"https://pixelgrade.com/demos/adler/\" target=\"_blank\">live demo</a> on Pixelgrade.com to see it in action. If you like what you see, you can <a href=\"https://wordpress.org/themes/adler/\" target=\"_blank\">download Adler</a> for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 01:09:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: New WordPress Plugin Automates Slack Team Invitations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47267\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wptavern.com/new-wordpress-plugin-automates-slack-team-invitations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4403:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/11/slack-logo.jpg?resize=700%2C314\" alt=\"slack-logo\" class=\"aligncenter size-full wp-image-33466\" /></a></p>\n<p>Generating Slack team invitations can become rather tedious when you&#8217;re managing a large group of people &#8211; particularly when the team is open to almost anyone. In the case of a company or organization, a Slack admin can use the feature that permits anyone with an email from a specified domain to be accepted on signup. However, this feature isn&#8217;t applicable to teams that are made up of people with diverse email domains and associations.</p>\n<p><a href=\"http://boiteaweb.fr/\" target=\"_blank\">Julio Potier</a>, a French security consultant and prolific <a href=\"https://profiles.wordpress.org/juliobox/\" target=\"_blank\">plugin developer</a>, created a solution for this particular scenario. As an admin on the <a href=\"https://wordpressfr.slack.com/\" target=\"_blank\">WordPressFR.slack.com</a> team, which is open to all French WordPress users, he needed a more convenient way to allow new signups. The team has 27 channels and 250+ members with 200 added in the first week.</p>\n<p>Julio decided to create a plugin to make the invitation process easier in the future. The new <a href=\"https://wordpress.org/plugins/lazy-invitation/\" target=\"_blank\">Slack Lazy Invitation</a> plugin automates the sending of Slack team invitations by adding a frontend signup on your WordPress site.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/join-slack-team.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/join-slack-team.png?resize=404%2C405\" alt=\"join-slack-team\" class=\"aligncenter size-full wp-image-47285\" /></a></p>\n<p>The user simply enters an email address and the invitation is sent. A Slackbot confirmation will appear on the page.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-team-invite-sent.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-team-invite-sent.png?resize=365%2C253\" alt=\"slack-team-invite-sent\" class=\"aligncenter size-full wp-image-47286\" /></a></p>\n<p>To configure the plugin for your Slack team all you need to do is enter the group name and the security token for your Slack invitations. As this token is not easy to find, Julio wrote a bookmarklet that will automatically capture it for you. From the plugin&#8217;s settings page you can drag and drop the bookmarklet into your browser toolbar on the invitation page found at: <code>https://YOURGROUP.slack.com/admin/invites</code>.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/lazy-slack-settings.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/lazy-slack-settings.png?resize=782%2C439\" alt=\"lazy-slack-settings\" class=\"aligncenter size-full wp-image-47295\" /></a></p>\n<p>Once the plugin is configured, the invitation signup page will be available at <code>example.com/wp-login.php?action=slack-invitation</code>. If you&#8217;re using either the <a href=\"https://wordpress.org/plugins/wp-recaptcha/\" target=\"_blank\">wp-reCaptcha</a> or <a href=\"https://wordpress.org/plugins/google-captcha/\" target=\"_blank\">google-captcha</a> plugins, Slack Lazy Invitation will automatically add protection to the form.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-invite-recaptcha.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/slack-invite-recaptcha.jpg?resize=350%2C481\" alt=\"slack-invite-recaptcha\" class=\"aligncenter size-full wp-image-47292\" /></a></p>\n<p>The plugin also includes support for the <a href=\"https://wordpress.org/plugins/sf-move-login/\" target=\"_blank\">SF Move Login</a> plugin, so that the invitation form is available at /slack-invitation instead of the much longer URL. This slug can be changed in the SF Move Login settings panel.</p>\n<p>In the future Julio plans to add support for adding invite pages for multiple groups. I tested <a href=\"https://wordpress.org/plugins/lazy-invitation/\" target=\"_blank\">Slack Lazy Invitation</a> and found that it works exactly as advertised. If you have a large Slack team with open invites, this plugin will save you quite a bit of time. Download it for free from WordPress.org.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Jul 2015 22:30:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"WPTavern: Meet PeepSo: BuddyPress’ Newest Competitor in Open Source Social Networking for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46711\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://wptavern.com/meet-peepso-buddypress-newest-competitor-in-open-source-social-networking-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10255:\"<p>When the first <a href=\"https://buddypress.org/2008/12/buddypress-10b1-components/\" target=\"_blank\">BuddyPress beta</a> arrived on the scene in 2008, there was nothing like it for WordPress. Facebook was still relatively new to the public and Twitter was just a couple years old. A plugin that transformed WordPress into a social network was an exciting prospect.</p>\n<p>After seven years of virtually unchallenged dominance among WordPress social networking plugins, BuddyPress has a new competitor. <a href=\"http://www.peepso.com/\" target=\"_blank\">PeepSo</a>, trademarked <em>&#8220;Your people. Your community. Your way,&#8221;</em> is the newest contender in WordPress&#8217; open source social networking plugin niche.</p>\n<p>Unlike <a href=\"https://buddypress.org/\" target=\"_blank\">BuddyPress</a>, which for the most part has improved slowly through community contribution, the <a href=\"http://www.peepso.com/\" target=\"_blank\">PeepSo</a> project is run more like a startup and is 100% self-funded. It is currently being marketed as an alternative to BuddyPress.</p>\n<blockquote class=\"twitter-tweet\" width=\"550\"><p lang=\"en\" dir=\"ltr\">You\'ve been asking for it. An alternative to BuddyPress. It\'s here! <a href=\"http://t.co/Uxd7AQcnCL\">http://t.co/Uxd7AQcnCL</a> <a href=\"https://twitter.com/hashtag/wordpress?src=hash\">#wordpress</a> <a href=\"https://twitter.com/hashtag/buddypress?src=hash\">#buddypress</a> <a href=\"http://t.co/yYRI5pnXJR\">pic.twitter.com/yYRI5pnXJR</a></p>\n<p>&mdash; peepso (@peepsowp) <a href=\"https://twitter.com/peepsowp/status/623768949943984128\">July 22, 2015</a></p></blockquote>\n<p></p>\n<p>The <a href=\"https://wordpress.org/plugins/peepso-core/\" target=\"_blank\">PeepSo plugin</a>, available on WordPress.org, offers many of the same <a href=\"http://www.peepso.com/pricing/\" target=\"_blank\">core features</a> as BuddyPress but was launched with a collection of commercial add-on plugins for things like photos, videos, moods, tagging, locations, friends, and messages. A groups feature is noticeably absent from Peepso but <a href=\"http://www.peepso.com/roadmap/\" target=\"_blank\">planned for version 1.4</a>. Current extensions seem to focus primarily on adding multimedia features to the activity stream.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/peepso-profile.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/peepso-profile.png?resize=1025%2C769\" alt=\"peepso-profile\" class=\"aligncenter size-full wp-image-47235\" /></a></p>\n<h3>Who is Behind PeepSo?</h3>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/merav-peepso.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/merav-peepso.jpg?resize=225%2C300\" alt=\"merav-peepso\" class=\"alignright size-medium wp-image-47241\" /></a>PeepSo was founded by <a href=\"https://about.me/meravknafo\" target=\"_blank\">Merav Knafo</a>, owner of <a href=\"http://www.jomsocial.com/\" target=\"_blank\">JomSocial</a>, Joomla&#8217;s most popular social networking solution. Knafo, a veteran in the Joomla community, brings a unique perspective on the differences between the Joomla and WordPress markets for social networking software. As <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">Joomla captures roughly 7% to WordPress&#8217; 60% of the CMS market share</a>, Knafo saw an opportunity to break into a larger market.</p>\n<p>&#8220;As a business owner, it’s my job to pay attention to trends in my industry and unfortunately, Joomla has been on a downward trend since 2009,&#8221; Knafo said.</p>\n<p>&#8220;Many of our JomSocial customers have asked us to &#8216;make JomSocial for WordPress,&#8217; because they wanted to switch to WordPress but there was nothing like JomSocial for WordPress. Finally, I could not ignore the trend nor the requests and decided to get into the WordPress market as well.&#8221;</p>\n<p>Knafo hopes to parlay her experience with JomSocial into her new venture with PeepSo.</p>\n<p>&#8220;We stuck with Joomla for almost 10 years now and took JomSocial to a whole new level when we took over in 2013,&#8221; she said. &#8220;I am very proud of what we’ve accomplished with JomSocial and super excited to implement all this experience and knowledge into PeepSo.&#8221;</p>\n<h3>How PeepSo Got Started</h3>\n<p>The idea for PeepSo was incubating for a few years before Knafo had the opportunity to execute it.</p>\n<p>&#8220;Brad Bihun used to be a customer of ours at <a href=\"http://www.ijoomla.com/\" target=\"_blank\">iJoomla</a>, and then he switched to WordPress,&#8221; she said. &#8220;We happened to live very close to each other in Encinitas, California, so we met up and suggested I’d created &#8216;JomSocial for WordPress.&#8217;</p>\n<p>&#8220;At that time, I didn’t even own JomSocial and I was too busy with all the iJoomla products. Then a couple of years later, I acquired JomSocial and he approached me again, but once again, I was just too busy. A year and a half into JomSocial acquisition, when things got a lot smoother, I finally said yes, he introduced me to the <a href=\"http://spectromtech.com/\" target=\"_blank\">SpectrOM</a> team, and we got started.&#8221;</p>\n<p>Although the plugin appears to be marketed as a direct competitor to BuddyPress, Knafo said that it wasn&#8217;t created specifically for that purpose but rather to give WordPress users a more robust array of options for building networks.</p>\n<p>&#8220;Obviously we felt there was a need for another product as an alternative to BuddyPress,&#8221; she said. &#8220;Leaving users with just one option is rarely a good idea, people like options.</p>\n<p>&#8220;We don’t necessarily plan to take on BuddyPress, we just want to offer those who want an alternative, a product that is of high quality and that is being continuously developed. Ultimately, people will choose the solution that serves them best. We are just getting started, but we have big plans and an excellent track record doing this successfully with Joomla.&#8221;</p>\n<h3>The Differences Between PeepSo and BuddyPress</h3>\n<p>I asked Knafo what her team perceives to be the most notable differences between PeepSo and its more established competitor, based on what they found to be lacking in BuddyPress.</p>\n<p>&#8220;I’d say the look and feel is a lot more modern in PeepSo right off the bat with no special themes needed,&#8221; she said. &#8220;The features are more up-to-date with the latest and greatest features of big social networks, such as Facebook &#8211; from cover photos to &#8216;likes&#8217; and so on.&#8221;</p>\n<p>BuddyPress core developers have opted to leave the aforementioned features to separate third-party plugins as opposed to packing them into core. With certain features, i.e. photos and videos, PeepSo does the same, except the add-ons are supported by PeepSo core developers.</p>\n<p>&#8220;PeepSo is lightweight and allows you to only add features that you need, to keep it lightweight,&#8221; Knafo said. &#8220;PeepSo’s code is so beautiful it made our developers shed tears of joy when they first saw it &#8211; that said, I never looked at BuddyPress’s code, nor would I be able to tell whether it’s beautiful or not.&#8221;</p>\n<p>In terms of code differences, PeepSo&#8217;s development team cited what they believe to be a few major differences between their <a href=\"https://github.com/wp-plugins/peepso-core\" target=\"_blank\">codebase</a> and BuddyPress:</p>\n<ul>\n<li>All object oriented &#8211; from the PHP to the Javascript</li>\n<li>Built with a templating engine similar to what you see in shopping cart systems. This allows use with virtually any theme.</li>\n<li>The JavaScript uses an extension mechanism, allowing add-ons to extend the abilities of the postbox.</li>\n<li>We made the database queries as optimized as possible to allow for greater scalability.</li>\n</ul>\n<p>&#8220;We have a track record creating and supporting a very large social networking application (JomSocial),&#8221; Knafo told the Tavern. &#8220;We know the ins and out of this business. We may be new to WordPress, but we are veterans when it comes to social networking applications.&#8221;</p>\n<h3>Where is PeepSo Headed?</h3>\n<p>The PeepSo development team, guided by lead architect <a href=\"https://twitter.com/davejesch\" target=\"_blank\">Dave Jesch</a> of <a href=\"http://spectromtech.com/\" target=\"_blank\">SpectrOM</a>, has an aggressive <a href=\"http://www.peepso.com/roadmap/\" target=\"_blank\">roadmap</a> for improving the plugin&#8217;s core and adding more features via commercial plugins.</p>\n<p>&#8220;Our main goal is to add more plugins to PeepSo, you can see our road map here. We’ll start with a chat plugin, custom profile fields and then groups, events, pages and so forth,&#8221; Knafo said. The team also hopes to partner with other developers who want to create PeepSo plugins.</p>\n<p>I asked her if the team plans to create a hosted PeepSo platform for community managers. Knafo said it isn&#8217;t totally out of the question but isn&#8217;t high on the priority list at the moment.</p>\n<p>&#8220;We tried to do this with JomSocial but we had a hard time finding the right hosting solution for it,&#8221; she said. &#8220;That said, we are open to the idea, a bit down the road.&#8221;</p>\n<p>PeepSo is just getting started and has not yet attracted many customers. However, Knafo&#8217;s experience of successfully running an open source project for the past 10 years has given her the determination to break into a new and unfamiliar market.</p>\n<p>&#8220;The sales have been as can be expected this early after the initial release, not too shabby to start with but we expect whole lot more sales as the WordPress users become aware of PeepSo, download the free version and give it a try,&#8221; she said.</p>\n<p>&#8220;We’re here for the long haul and we take no shortcuts in doing this right. We know it’s a huge undertaking; there is so much more to do. I am confident that investing in WordPress was the right move, I’ve been very pleased by the feedback and the community. My hope is that WordPress developers will join us and create awesome plugins to take PeepSo to the next level.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 22:50:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Only 70 Tickets Remain to Livestream Prestige for Free August 1-2, 2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47208\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://wptavern.com/only-70-tickets-remain-to-livestream-prestige-for-free-august-1-2-2015\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4855:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/08/PrestigeConfLogo.png\"><img class=\"alignright size-full wp-image-27630\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/08/PrestigeConfLogo.png?resize=275%2C233\" alt=\"Prestige Conference Logo\" /></a>With just a few days remaining before <a href=\"http://prestigeconf.com/\">Prestige takes place</a>, there are only 70 tickets left to watch the event for free. Courtesy of <a href=\"http://www.rocketgenius.com/\">Rocketgenius</a>, the event&#8217;s primary sponsor, more than 500 people will be watching the event for free this weekend. To watch the event for <del>free, use the code <strong>GravityFormsLS </strong></del>when <a href=\"http://prestigeconf.com/tickets/\">purchasing a streaming ticket</a>.</p>\n<p>Free tickets are sold out. However, entering the code <strong>PrestigeStream</strong> when <a href=\"http://prestigeconf.com/tickets/\">purchasing a streaming ticket</a>, will take 50% off the price</p>\n<p>Prestige is a conference founded by Kiko Doran and Josh Broton in 2014 that focuses on the business aspects of WordPress. The first event was held in Minneapolis, MN, in October of 2014. Earlier this year, Prestige was held in Las Vegas, NV. This weekend marks the third time the conference will be held.</p>\n<h2>The Future of Prestige</h2>\n<p>The first and second conference had approximately 100 attendees and Doran expects the same amount this weekend. However, future iterations of Prestige will have lower attendance. &#8220;We are transitioning to more of an online event. We’re actually going to make the in-person events smaller moving forward.&#8221; Doran told the Tavern.</p>\n<p>There&#8217;s also a chance the conference could morph into something completely different. &#8220;After organizing two WordCamps, I figured out some of the things I loved about them and some of the things I don&#8217;t. Prestige has given me the freedom to try new things and see what people like and what they don’t like,&#8221; Doran said.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/PrestigeinVegas.jpg\"><img class=\"wp-image-47216 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/PrestigeinVegas.jpg?resize=1025%2C576\" alt=\"Prestige in Las Vegas Nevada\" /></a>Prestige in Las Vegas, NV Image courtesy of <a href=\"https://www.happyjoe.org/prestige-conference-las-vegas-2015/\">James Dalman</a>\n<p>Although the conference has been held twice this year and in different cities, the organizing team plans to host at least one Prestige conference in Minneapolis every year. Talks are underway for the next event but details are not locked down.</p>\n<p>&#8220;We plan to do one in Minneapolis every year because we love the community there. We’d like to do Minneapolis in the summer time, due to weather, then we’d like to do any winter events in a warm place,&#8221; Doran said.</p>\n<p>Organizing a conference is a challenging experience that benefits from having motivated organizers. Doran explains what motivates him to organize Prestige, sometimes twice a year.</p>\n<p>&#8220;I have a small awesome team of organizers that love putting this event on. That and the people who come and share their knowledge. It’s a smaller event but to me, that&#8217;s the appeal of it. Everyone is far more approachable in this environment,&#8221; he said.</p>\n<h2>A First for Prestige</h2>\n<p>This weekend&#8217;s event features a hands-on workshop by Jennifer Bourn of <a href=\"http://www.bourncreative.com/\">Bourn Creative</a>. It&#8217;s the first session in Prestige&#8217;s young history to involve hands-on exercises. The session is uncharted territory for the conference which has mostly focused on people sharing their experiences building  businesses.</p>\n<h2>How Long Will Doran Organize Prestige?</h2>\n<p>With this being his third conference, I asked Doran how long does he plan to continue organizing Prestige, &#8220;I’ll organize the conference as long as there is a demand for the content. People often say to scratch your own itch. This conference started off as a little self-serving in that I wanted to ask people all of these questions. Then I thought, couldn’t others benefit from this information as well?&#8221; he replied.</p>\n<h2>I&#8217;ll Be at Prestige Conference</h2>\n<p>I&#8217;ll be among the 100 expected attendees at this weekends conference. If you&#8217;re attending the event, please stop me and say hi. If not, make sure you grab one of the <a href=\"http://prestigeconf.com/tickets/\">70 tickets left</a> to watch a livestream of the event. You can also monitor the <a href=\"https://twitter.com/search?q=prestigeconf&src=typd\">#Prestigeconf</a> hashtag on Twitter. If you&#8217;ve previously attended Prestige or watched the livestream, please share your experiences in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 21:13:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: WordPress Users Association Under New Ownership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46317\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://wptavern.com/wordpress-users-association-under-new-ownership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5827:\"<p>The <a href=\"http://wpua.org/\">WordPress Users Association</a> (WPUA) is breathing new life after it was acquired by Paul DeMott earlier this year <a href=\"https://flippa.com/4377398-pr-2-2-405-last-12-mos-wordpress-training-membership-site-3500-members\">on Flippa</a> for $797. WPUA originally launched in December 2010, with the goal of providing a central place for WordPress users to swap war stories, learn how to get the most out of WordPress, and take part in getting special discounts on themes and plugins.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUAFrontPage.png\"><img class=\"size-full wp-image-47197\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUAFrontPage.png?resize=1025%2C489\" alt=\"Redesigned Front Page\" /></a>Redesigned Front Page\n<p>Three years after its launch, the site appeared to be dead. In 2013, <a href=\"http://wptavern.com/psa-dont-give-your-money-to-the-wpua\">I paid to become a member</a> to confirm my suspicions and to see if the site still accepted payments. Free themes and plugins offered to members were not impressive and there wasn&#8217;t much to choose from. All of the videos used for WordPress training were broken. Despite these setbacks, I was able to successfully complete the refund process.</p>\n<h2>Financial Details</h2>\n<p>Earlier this year, WPUA.org was listed on <a href=\"https://flippa.com/\">Flippa.com</a>, a domain auctioning site. As part of the auction financial details of WPUA.org were made public. According to <a href=\"https://flippa.com/users/217895\">the seller</a>, the site made $20K when it launched. The previous owners spent between $500-$1,000 on ads and answering WordPress questions through the Ask a WordPress Expert section of the site.</p>\n<p>The following shows revenue, costs, and profit between October 2014 and March 2015. WPUA earned revenue primarily with product or service sales and affiliate income.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUARevenue.png\"><img class=\"size-full wp-image-47198\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/WPUARevenue.png?resize=580%2C273\" alt=\"WPUA Revenue\" /></a>WPUA Revenue\n<p>At the time the site was listed for auction, it had 3,500+ total members made up of free and paid subscriptions. The site today boasts more than 5,600 members.</p>\n<h2>Previous Owner Explains Why He Sold The Site</h2>\n<p>Wesley Williams is the former owner of WPUA.org and helped launch the site in 2010. Williams transitioned away from the domain because his web development business used the majority of his time. &#8220;We felt with our limited time to invest in it that it was best to transition it to someone who shared our passion but had a little more time to invest in growing the community and serving the members. We completed this transition back in April,&#8221; Williams told the Tavern.</p>\n<p>From my perspective, the WPUA was not a successful venture but Williams says otherwise.</p>\n<p>&#8220;I wouldn&#8217;t say it wasn&#8217;t a success. There are thousands of members and we provided a lot of help to a lot of new and experienced WordPress users. As my main core business grew and as the time requirements of our projects increased, we couldn&#8217;t devote the time required to answer questions and give the help needed.</p>\n<p>&#8220;Actually, WPUA was a big success in my mind. Just from a number of members point of view it was a success. From the amount and number of questions and people we helped it was a success and from a financial standpoint it was a success,&#8221; he said.</p>\n<p>Williams explains his goal with WPUA and why some members of the community may not be aware of the growth it had. &#8220;My goal was to help the under-served, those just getting started and without the technical know how to make what is actually simple fixes or changes to their WordPress site.</p>\n<p>&#8220;I didn&#8217;t run the WPUA in the circles of all the established WordPress technical crowd, even though a large number of them became members of the WPUA. I ran it focused on users new to the platform and so because of that, some members of the WordPress community might not be aware of the growth and success it had,&#8221; he said.</p>\n<p>Through the course of time, Williams and his team adjusted membership levels and access points which helped increase registrations. Williams also learned that what members wanted was a direct way to ask questions and receive expert answers.</p>\n<p>&#8220;A person new to the platform didn&#8217;t want to post their question in a forum and they weren&#8217;t really sure what the real question was. Thus, we removed the forum and went to an &#8216;Ask an Expert&#8217; system where they could email their questions. This seemed to work better for everyone,&#8221; he said.</p>\n<p>Overall, Williams is happy with how WPUA progressed and feels fortunate to have played a role in its growth and success.</p>\n<h2><strong>Who is Paul DeMott?</strong></h2>\n<p>In the <a href=\"https://vimeo.com/129324627\">following video,</a> DeMott explains how to build a eCommerce site with WooCommerce and calls himself the new president of recruitment for the WPUA. According to <a href=\"https://www.linkedin.com/pub/paul-demott/79/300/727\">his LinkedIn profile</a>, he lives in Cincinnati, OH and is the owner of Paul&#8217;s SEO and Web Expertise which works with companies to develop websites that bring in internet traffic and sales.</p>\n<p>Not much is known about DeMott and multiple requests for comment have gone unanswered. It&#8217;s unclear what his plans are for WPUA.org but so far, it&#8217;s remained as a paid subscription membership site. If you are a past or current member of the WordPress Users Association, please tell us about your experience in the comments.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 20:39:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Matt: MPAA Smoking Gun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45270\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"http://ma.tt/2015/07/mpaa-smoking-gun/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"<p>Sometimes truth is worse than what you would imagine: <a href=\"https://www.techdirt.com/articles/20150724/15501631756/smoking-gun-mpaa-emails-reveal-plan-to-run-anti-google-smear-campaign-via-today-show-wsj.shtml\">Smoking Gun: MPAA Emails Reveal Plan To Run Anti-Google Smear Campaign Via Today Show And WSJ</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Jul 2015 15:34:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"WPTavern: Plugin Developers Demand a Better Security Release Process After WordPress 4.2.3 Breaks Thousands of Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47146\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"http://wptavern.com/plugin-developers-demand-a-better-security-release-process-after-wordpress-4-2-3-breaks-thousands-of-websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6880:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/07/security.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2014/07/security.jpg?resize=1024%2C487\" alt=\"photo credit: Ravages - cc\" class=\"size-full wp-image-27206\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/ravages/6731739485/\">Ravages</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p><a href=\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\" target=\"_blank\"> WordPress 4.2.3</a>, a critical security release, was automatically pushed out to users yesterday to fix an XSS vulnerability. Shortly afterwards, the <a href=\"https://wordpress.org/search/4.2.3?forums=1\" target=\"_blank\">WordPress.org support forums</a> were flooded with reports of websites broken by the update.</p>\n<p>Roughly eight hours later Robert Chapin (@<a href=\"https://profiles.wordpress.org/miqrogroove/\" target=\"_blank\">miqrogroove</a>) published a post to the Make.WordPress.org/Core blog, detailing <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/\" target=\"_blank\">changes to the Shortcode API</a> that were included in the release. According to Chapin, these changes were necessary as part of the security fix:</p>\n<blockquote><p>Due to the nature of the fix – as is often the case with security fixes – we were unable to alert plugin authors ahead of time, however we did make efforts to scan the plugin directory for plugins that may have been affected.</p>\n<p>With this change, every effort has been made to preserve all of the core features of the Shortcode API. That said, there are some new limitations that affect some rare uses of shortcodes.</p></blockquote>\n<p>The security team had no reasonable way of accounting for every single edge case, but the negative impact of these changes were far more wide-reaching than they had anticipated. This particular use case likely wasn&#8217;t covered in their testing. Unfortunately, plugin developers found out about the breaking changes only after the security release had already left a slew of broken websites in its wake.</p>\n<p>&#8220;I fully understand this is an issue, but isn’t this a weird way of updating &#8211; almost all our clients are calling / e-mailing us at the moment as their sites seem to be broken,&#8221; one developer <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/#comment-26449\" target=\"_blank\">commented</a> on the Shortcode API post. &#8220;Normally it would be better to announce such huge impact changes to the plugin and theme developers. This means I need to fully reschedule my agenda, which already is full during holiday season.&#8221;</p></blockquote>\n<p>Comments on the WordPress.org post are full of developers scrambling to find a way to fix client websites. Many were disappointed that the total secrecy of the security team, which is necessary in situations like this, was not immediately followed up with a public post on the important changes to the Shortcode API. Meanwhile, the email inboxes of agencies and plugin developers are filling up with urgent messages from outraged clients.</p>\n<p>Developers want better communication from the those who are managing security releases. <a href=\"https://twitter.com/helzer\" target=\"_blank\">Amir Helzer</a>, author of <a href=\"https://wordpress.org/plugins/types/\" target=\"_blank\">Types</a> and <a href=\"http://wp-types.com/home/views-create-elegant-displays-for-your-content/\" target=\"_blank\">Views</a>, two plugins majorly affected by the release, <a href=\"https://make.wordpress.org/core/2015/07/23/changes-to-the-shortcode-api/#comment-26447\" target=\"_blank\">sums up the thoughts of many other commenters</a> on the Make/WordPress.org/Core post:</p>\n<blockquote><p>We are updating the Views plugin today, so that we resolve all shortcodes before passing to WordPress to process content.</p>\n<p>This is a straightforward change, which takes us one day to complete.</p>\n<p>Would have been great to receive a heads-up about an upcoming change in WordPress, so we could do this change on time.</p>\n<p>We received a huge amount of support requests due to this, but this isn’t the issue. We can deal with a wave a support issues. This time it wasn’t “our fault”, but sometimes it is.</p>\n<p>What worries us, as mentioned above, is seeing our clients (folks who build WordPress sites for a living), losing their faith in the system. They feel like the system sees them as little ants and not as humans. People don’t like seeing their problems being dismissed.</p>\n<p>Many of them run hundreds of sites. They cannot afford to stop everything and fix content on so many sites. Especially not if they are currently away for their family vacation.</p>\n<p>What others have asked here, and I would like to ask, too, is to setup a mechanism that allows WordPress core developers to privately communicate such upcoming issues with plugins developers.</p>\n<p>We are your partners.</p>\n<p>Without WordPress (secure, stable and reliable), we would not exist.</p>\n<p>Without great themes and plugins, WordPress would not power 24% of the Web.</p>\n<p>WordPress core members already volunteer a lot of their time. I’m not asking for anyone to volunteer more time. Need help? Ask us. There is a huge community of developers who rely on WordPress. We would be happy to get involved and set up whatever is needed.</p></blockquote>\n<p>User confidence in WordPress&#8217; automatic background updates took a dent with the 4.2.3 release. Waking up to broken websites causes users to second guess automatic updates after being assured that maintenance and security releases would not include breaking changes.</p>\n<p>When users get burned by automatic updates, in the end it doesn&#8217;t matter which party is at fault &#8211; whether it&#8217;s the core team or a theme or plugin. They simply expect updates to work and not break anything. Even in instances where a poorly coded extension may be at fault, the average user has no way of determining whether or not their active plugins follow WordPress best practices.</p>\n<p>The aftermath of the most recent security release is one reason why many developers and users are still wary of automatic updates. Amir Helzer represents many other plugin developers who are eager to find better ways to work together with the core team to provide a better update experience for users. This is especially important for releases like this one where the Shortcode API changes directly affected users&#8217; content. Hezler&#8217;s comment reaffirms the fact that development agencies, plugin developers, and core developers are all partners on the same team. It&#8217;s time to find better ways of working together to provide the best update experience possible for WordPress users.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Jul 2015 02:46:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: FooPlugin’s Digital License Key Management Plugin is Now Open Source for Developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47117\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/fooplugins-digital-license-key-management-plugin-is-now-open-source-for-developers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5296:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/06/open-source.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/06/open-source.jpg?resize=1024%2C514\" alt=\"photo credit: 16th st - (license)\" class=\"size-full wp-image-45884\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/79777096@N00/6866996865\">16th st</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nd/2.0/\">(license)</a>\n<p>Three years ago, <a href=\"http://fooplugins.com/\" target=\"_blank\">FooPlugins</a> built <a href=\"https://bitbucket.org/fooplugins/foolicensing\" target=\"_blank\">FooLicensing</a>, a digital license key management tool that enabled them to manage customers of their <a href=\"https://easydigitaldownloads.com/\" target=\"_blank\">EDD</a>-powered commercial plugins store. Although EDD already offered a license creation and management extension, FooPlugins required more features than it had at that time and opted to build their own.</p>\n<p>As of today, FooLicensing is now open source and free for anyone to use, along with the associated EDD connector plugin.</p>\n<p>&#8220;We love the community and wanted to give back,&#8221; FooPlugins co-founder Adam Warner said.</p>\n<p>&#8220;We know FooLicensing could be so much more but we just don&#8217;t have the time to dedicate to it alone. We are a small team and because of that we find ourselves with dozens of projects that could be so much more if only we had more time and people.&#8221;</p>\n<p>Open sourcing a project can change its trajectory if there&#8217;s enough interest and developers willing to contribute to improve it. Warner isn&#8217;t counting on that, however, and simply hopes other developers will find it useful.</p>\n<p>&#8220;It&#8217;s a bit of a leap of faith, but if it helps someone else get involved to help create an even more robust system, then great,&#8221; he said. &#8220;Bonus if it helps someone build additional extensions to help others.&#8221;</p>\n<p>FooLicensing&#8217;s main features include:</p>\n<ul>\n<li>View and manage the validated domains for your EDD license level</li>\n<li>One click EDD license upgrade/add to cart</li>\n<li>One click EDD license renewal (with associated discount) /add to cart</li>\n</ul>\n<p>A logged-in user who has entered a license key will see all the relevant account information detailing status, activations, expirations, etc.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-user-admin.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-user-admin.png?resize=580%2C332\" alt=\"foolicensing-user-admin\" class=\"aligncenter size-full wp-image-47135\" /></a></p>\n<p>Administrators who are using the plugin together with its <a href=\"https://bitbucket.org/fooplugins/edd-foolicensing\" target=\"_blank\">EDD Connector</a> will see a menu with various license creation and management tools.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-admin-view.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/foolicensing-admin-view.png?resize=160%2C264\" alt=\"foolicensing-admin-view\" class=\"aligncenter size-full wp-image-47137\" /></a></p>\n<p>The <a href=\"https://bitbucket.org/fooplugins/edd-foolicensing\" target=\"_blank\">EDD Connector</a>, also now open source, enables the following:</p>\n<ul>\n<li>Add new licenses to attach to an EDD product</li>\n<li>A searchable list of all license keys that have been created and assigned, complete with attached domains</li>\n<li>A list of licenses that have been renewed</li>\n<li>Testing for license validation and update checks in the API Sandbox</li>\n<li>A management area for various messages (domain attach, detach) and for license renewal discount amount and emails</li>\n</ul>\n<h3>Foo Licensing is Extensible for Other Platforms</h3>\n<p>FooLicensing was built from the beginning to be extensible for use with other platforms beyond EDD. The team at FooPlugins had plans to expand their library of connectors but didn&#8217;t have the time to execute them.</p>\n<p>&#8220;Our goal for FooLicensing was to build additional integrations for other eCommerce plugins and digital sales platforms but it quickly took a back seat as our <a href=\"https://fooplugins.com/plugins/foobox/\" target=\"_blank\">FooBox</a> and other plugins like <a href=\"https://fooplugins.com/plugins/foogallery/\" target=\"_blank\">FooGallery</a> gained popularity,&#8221; Warner said.</p>\n<p>&#8220;Documentation is non-existent at this point, but we welcome you to step through the code and consider getting involved with the core plugin or with extensions for other eCommerce platforms.&#8221;</p>\n<p>Warner said the team is considering a full-fledged site dedicated to FooLicensing if enough developers become interested and would consider the possibility of a marketplace to host any extension built. FooPlugins does not currently have plans to create additional extensions in house.</p>\n<p>&#8220;We&#8217;ll see what the future holds, but for now we need to move forward with some other things rather than holding this tight to our chests,&#8221; Warner said. &#8220;Open sourcing the plugins just fits in with what we believe is the right thing to do to make the web (and the WP community) a better place.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jul 2015 20:17:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Post Status: Thesis, Automattic, and WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=13692\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://poststatus.com/thesis-automattic-and-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:70425:\"<p>Chris Pearson and Matt Mullenweg have hardly communicated with one another in the last five years, but they are ideological enemies. They are both wealthy individuals (though of different magnitudes) thanks to their online endeavors, with very strong personalities and unshakable beliefs on business and software. This is a story of their dispute, their idealism, and the implications it will have on the WordPress project.</p>\n<p><a href=\"http://ma.tt/\">Matt Mullenweg</a> co-founded WordPress, founded <a href=\"https://automattic.com\">Automattic</a>, and is one of the most successful entrepreneurs of his generation. He runs a billion dollar &#8220;unicorn&#8221; startup centered on a culture of embracing open source technology and has achieved incredible success embracing principles counterintuitive to either Silicon Valley or big corporate culture. He&#8217;s paving a new path for how to create a valuable software company while religiously defending and promoting open source software.</p>\n<p><a href=\"http://www.pearsonified.com/\">Chris Pearson</a> founded <a href=\"http://diythemes.com/\">DIYthemes</a> and helped pioneer the early WordPress commercial theme industry. He has run his business successfully for over seven years, despite unique hurdles that result from a very public dispute with Mullenweg in 2010. He vehemently defends his work as his own non-derivative achievement and rejects the religiosity and cult mentality that he believes exists in the WordPress ecosystem. He views WordPress as a huge chunk of the web, available to be monetized &#8212; which he has done so to the tune of millions of dollars &#8212; but he does not believe he must adopt Matt Mullenweg&#8217;s principles in order to meet customer demand, run his own business, and protect his own inventions.</p>\n<p>By all normal definitions, Mullenweg and Pearson have done incredibly well for themselves. However, from a pure size perspective and principles aside, Mullenweg is the big nation army and Pearson is the small revolutionary militia. Mullenweg views Pearson as a threat to everything he stands for and has worked to accomplish, and Pearson views Mullenweg as an overbearing figure with no true authority over his decisions.</p>\n<p>Mullenweg has the motivation, resources, and ability to squash Pearson &#8212; and indeed most thought he&#8217;d done so already. While he has far fewer resources, Pearson has some tools available to protect his business or to potentially even disrupt the entire WordPress ecosystem as we know it today.</p>\n<p>During their first conflict in 2010, and in the resurgent one going on now, Mullenweg and Pearson have both at times made mistakes, acted childishly, or been in the wrong. Both also have merit in various aspects of their positions. Neither conflict, so publicly debated, reflects well on the WordPress ecosystem as a whole &#8212; even though I believe it is right that each conflict is best observed under a public eye, as the results can affect so many other businesses and potentially even WordPress itself.</p>\n<p>With this post, I aim to outline the entire conflict; to describe the implications past, present and future; to highlight non-WordPress comparisons for precedent and potential implications; and to share my own thoughts on who is in the right and who is in the wrong, as viewed for the good of the global WordPress community.</p>\n<h2>A history of conflict</h2>\n<p>The commercial theme movement started in 2007 and took off in 2008. Thesis was one of the pioneers of commercial WordPress themes. The theme industry was young and evolving rapidly, and many sellers hardly considered or understood licensing issues at all.</p>\n<p>Many of the sources for this period are from Siobhan McKeown&#8217;s excellent account in the book, <a href=\"https://github.com/WordPress/book\"><em>Milestones: The Story of WordPress</em></a> (which I&#8217;ll refer to as <em>Milestones</em>).</p>\n<h3>Themes as derivative works of WordPress</h3>\n<p>WordPress is licensed by the GNU General Public License (GPL), version 2 or later. The GPL ensures certain freedoms that protect both WordPress and those that utilize it. The &#8220;four freedoms&#8221; that are the heart of the GPL are as follows:</p>\n<blockquote>\n<ul>\n<li>The freedom to run the program as you wish, for any purpose (freedom 0).</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish (freedom 1). Access to the source code is a precondition for this.</li>\n<li>The freedom to redistribute copies so you can help your neighbor (freedom 2).</li>\n<li>The freedom to distribute copies of your modified versions to others (freedom 3). By doing this you can give the whole community a chance to benefit from your changes. Access to the source code is a precondition for this.</li>\n</ul>\n</blockquote>\n<p>As WordPress co-founder Mike Little phrased it in the Post Status Slack, &#8220;The GPL is meant to be restrictive for developers and permissive for users.&#8221; The <a href=\"https://gnu.org/philosophy/philosophy.html\">GNU philosophy page</a> and subsequent articles are a good resource for understanding the nature of the license.</p>\n<p>The GPL is a <a href=\"https://en.wikipedia.org/wiki/Copyleft\">Copyleft</a> license, which creates the &#8220;stipulation that the same rights be preserved in derivative works down the line.&#8221; In an immature theme market, licensing was given relatively little notice, and many theme authors provided their themes with no license or proprietary licenses.</p>\n<p>Matt Mullenweg, to many, would be considered <a href=\"https://en.wikipedia.org/wiki/Benevolent_dictator_for_life\">BDFL</a>, or Benevolent Dictator for Life, of WordPress. It&#8217;s a common term for folks that lead open source projects and have final say on project decisions. In his role as WordPress BDFL, he now has a reputation &#8212; at least within certain circles of folks that pay close attention &#8212; for making large, impactful decisions with little description of why he has done so.</p>\n<p>In late 2008, more than 200 free WordPress themes were removed from the WordPress.org theme repository. While many of the themes were removed due to spammy links, some were pulled due to GPL violations within the themes or within the theme upsells that were linked from the theme listings.</p>\n<p>The move, which was made without announcement, shocked many theme providers that felt they were unfairly included in the group of removed themes. The situation created a spark and initiated a serious debate about theme licensing.</p>\n<p>Authors were concerned that GPL licensed themes would mean that their themes would be bought and freely distributed, removing their ability to make money from their works. A few, such as Brian Gardner with his Revolution theme, <a href=\"http://www.blogherald.com/2008/10/01/brian-gardners-revolution-theme-goes-open-source/\">changed their licensing</a> as a result of conversations with Mullenweg and Toni Schneider, Automattic&#8217;s CEO at the time. In Brian&#8217;s case, he made his theme free and offered paid support services.</p>\n<p>Eventually though, most authors &#8220;selling&#8221; themes started actually selling support, access to download, and updates for their themes. This model was both GPL compatible, as well as workable for authors to get paid.</p>\n<p>In mid-2009, Matt Mullenweg also posted <a href=\"https://wordpress.org/news/2009/07/themes-are-gpl-too/\">on the official</a> WordPress blog that he was introducing a new <a href=\"https://wordpress.org/themes/commercial/\">commercial theme listing page</a> on WordPress.org, and he shared an opinion he requested from the Software Freedom Law Center (SFLC), where they determined that the two themes packaged with WordPress were derivative works.</p>\n<p>The SFLC opinion did leave room for a &#8220;split license&#8221; where the WordPress and PHP code must inherit the GPL, and the CSS, Javascript, and images could be under a proprietary license:</p>\n<blockquote><p>In conclusion, the WordPress themes supplied contain elements that are derivative of WordPress’s copyrighted code. These themes, being collections of distinct works (images, CSS files, PHP files), need not be GPL-licensed as a whole. Rather, the PHP files are subject to the requirements of the GPL while the images and CSS are not. Third-party developers of such themes may apply restrictive copyrights to these elements if they wish.</p>\n<p>Finally, we note that it might be possible to design a valid WordPress theme that avoids the factors that subject it to WordPress’s copyright, but such a theme would have to forgo almost all the WordPress functionality that makes the software useful.</p></blockquote>\n<p>&#8220;Split license&#8221; is the colloquial term the community has assigned to this statement, but in fact the actual splitting of which parts are GPL and which parts are not matters, so it may not do the reality of the situation justice. Perhaps it should be termed &#8220;PHPGPL&#8221; or &#8220;Non-Assets GPL&#8221;.</p>\n<p>A number of prominent theme sellers were unhappy with Mullenweg&#8217;s insistence that their themes maintain a 100% GPL license, but they were not willing to shake the boat over it. At this point, themes were becoming big businesses and making new millionaires (or close to it) of some of these shop owners. This settled the issue for nearly all theme sellers, and most moved to either 100% GPL or a PHPGPL license, and the doomsday scenarios never came; the theme industry continues to thrive.</p>\n<h3>Thesis holds out</h3>\n<p>But not everyone agreed to go either 100% GPL or PHPGPL license. Chris Pearson kept his Thesis theme under a proprietary license.</p>\n<p>Thesis was one of the most popular and flexible themes in the world, and Pearson <a href=\"https://github.com/WordPress/book/blob/925d7dc6293b1662a7e6839a2703e8a858c730ad/Content/Part%205/39-thesis.md\">boasted on Andrew Warner&#8217;s Mixergy podcast</a> of revenues of $1.2 million+ over the 12-18 month period prior to the interview. Mullenweg and Pearson criticized one another publicly, and Warner invited them both to Mixergy where they debated the merits of GPL licensing.</p>\n<p>By most accounts, Mullenweg had the better argument on the Mixergy episode, and also came off as a calmer and more collected personality &#8212; in contrast to Pearson&#8217;s often heated, and sometimes very strange, statements.</p>\n<p>The debate continued between Mullenweg, Pearson, and a variety of WordPress community members and their blogs. Mullenweg was extremely aggressive, to the extent that he <a href=\"https://twitter.com/photomatt/status/18548422506\">offered to buy</a> alternative commercial themes for users of Thesis that agreed to switch. Mullenweg tells me that many took him up on his offer, but it was, &#8220;less than a thousand.&#8221; In my opinion, this was a step too far by Mullenweg, though for him the issue was already personal.</p>\n<p>Pearson held his ground over the following days until an admission by one of his own team members of wholesale copying of code in Thesis from WordPress code, which violates the WordPress copyright.</p>\n<p>At this point, Pearson finally capitulated and announced that Thesis would be a split license GPL compatible theme, and the debate died down. Pearson put his head down and started working on Thesis 2.</p>\n<p>He released Thesis 2 in late 2012, and by this time the debate was cool &#8212; the community had moved on to other drama (yes, even more GPL drama) &#8212; and the release of Thesis 2 was largely ignored outside of DIYthemes&#8217; audience, which was quite large but also largely isolated from the WordPress &#8220;community&#8221; that cares about stuff like licensing.</p>\n<p>Therefore, not many people paid attention to the new Thesis or the licensing it contained. Mullenweg, however, was still paying attention.</p>\n<h2>The battle over thesis.com</h2>\n<p>If you consider the word <em>thesis</em>, what do you think of?</p>\n<p>If you are a regular person walking down the street, you probably think of the general concept for stating a theory, or perhaps you think of the long papers that university students write as part of their programs.</p>\n<p>If you are in the WordPress world, you may also consider the Thesis WordPress theme by DIYthemes.</p>\n<p>Good, single word domain names are hard to come by. Thesis.com, if you visit it now, redirects to the <a href=\"http://themeshaper.com\">ThemeShaper blog</a>. ThemeShaper is owned and operated by Automattic, and frequently posts articles about WordPress themes.</p>\n<p>ThemeShaper is not a dedicated commercial property, but it does link to Automattic&#8217;s primary website, and Automattic does make and sell WordPress themes.</p>\n<h3>Automattic buys thesis.com</h3>\n<p>Automattic hasn&#8217;t always owned <a href=\"http://thesis.com\">thesis.com</a>. Matt Mullenweg met a third party owner of the domain at a conference &#8212; a guy named Larry &#8212; and inquired about the domain by email in January of 2014. Chris Pearson had already attempted to purchase the domain from Larry, and did not agree to pay the $150,000 that Larry requested.</p>\n<p><a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">According to Pearson&#8217;s accounts</a>, he and Larry had a few exchanges that stalled with Pearson unwilling to bid beyond $37,500 for the domain, and Larry sticking to $150,000. With a $100,000 offer on the table from Mullenweg, Larry gave Pearson an opportunity to buy the domain for $115,000, which he didn&#8217;t do &#8212; in part because he thought it too expensive, but also because he suspected Larry didn&#8217;t really have the offer from Mullenweg.</p>\n<p>As we now know, Larry did have the offer and Automattic became the owner of the thesis.com domain name.</p>\n<p>Pearson didn&#8217;t know that Mullenweg actually bought the domain until November of 2014, when he was notified by a friend that Mullenweg&#8217;s WordCamp San Francisco State of the Word Q&amp;A session included a section where Mullenweg noted that he owned the domain (more on that later).</p>\n<h3>Pearson attempts to force domain transfer</h3>\n<p>On April 9th, 2015, Pearson and his lawyers filed a UDRP (Uniform Domain-Name Dispute Resolution Policy) complaint, which is a formal method for resolving domain disputes, recognized by ICANN. UDRP isn&#8217;t a formal government court, but serves as arbitration for domains due to the recognition by ICANN.</p>\n<p>There are many, many examples of UDRP complaints in regard to trademark infringement. There are a <a href=\"https://www.icann.org/resources/pages/policy-2012-02-25-en?routing_type=path\">number of criteria</a> that come into play that guide the UDRP panel&#8217;s decision making process.</p>\n<p>The three basic tenets that must be met are as follows:</p>\n<blockquote><p>(i) your domain name is identical or confusingly similar to a trademark or service mark in which the complainant has rights; and</p>\n<p>(ii) you have no rights or legitimate interests in respect of the domain name; and</p>\n<p>(iii) your domain name has been registered and is being used in bad faith.</p></blockquote>\n<p>The panel reviews the initial complaint (in this case, by Pearson) and gives the respondent (Automattic) an opportunity to respond. All correspondence is in writing and not in person. The panel has two weeks after everything has been submitted to reach a decision.</p>\n<p>In this case, which <a href=\"http://www.adrforum.com/domaindecisions/1613723.htm\">is available publicly</a>, the panel denied Pearson&#8217;s complaint.</p>\n<p>Pearson&#8217;s complaint cited that he fulfilled each of the three criteria:</p>\n<ul>\n<li>By noting his trademark of the word &#8220;thesis&#8221;.</li>\n<li>By noting that Automattic was using the domain with a commercial interest (by redirecting it to ThemeShaper).</li>\n<li>By noting the bad faith clause by citing that Automattic, &#8220;purchased the disputed domain name to confuse and redirect customers and potential customers to Respondent’s competing webpage.&#8221;</li>\n</ul>\n<p>In the response, Automattic did not contest Pearson&#8217;s trademark on the word <em>thesis</em>. However, Automattic also noted that the word is very generic, and also that ThemeShaper was not a commercial part of Automattic, but a &#8220;blogging site.&#8221;</p>\n<p>For the bad faith argument, Automattic claimed that the redirect to ThemeShaper furthers their, &#8220;purpose in providing a blogging site,&#8221; and highlights that the intention for the domain is not as a commercial entity or one to be confused with Pearson&#8217;s trademark.</p>\n<h3>Automattic wins dispute</h3>\n<p>Automattic won the dispute against Pearson. As noted, the panel had two weeks to deliver the decision, and Automattic proposed a settlement with Pearson before the decision was handed down.</p>\n<p>Pearson was considering the settlement when the decision came a day before the two week deadline, which is apparently not a common occurrence. Had the decision not come early, Pearson may have saved himself some trouble, especially in regard to eliminating the <a href=\"http://ttabvue.uspto.gov/ttabvue/v?qs=85115266\">trademark cancellation requests</a> by Automattic on <em>thesis</em> and related terms.</p>\n<p>In Pearson&#8217;s blog post, <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">The Truth about Thesis.com</a>, he notes the general terms of the proposed settlement:</p>\n<blockquote><p>Automattic’s attorneys drafted the original settlement, which included the following terms:</p>\n<ul>\n<li>Automattic would keep thesis.com</li>\n<li>Automattic would withdraw the federal trademark cancellation request</li>\n<li>I would withdraw the UDRP</li>\n<li>Both parties would mutually release one another (agree not to sue over this issue in the future)</li>\n</ul>\n<p>Nothing in the original settlement addressed the trademark infringement, and since this was the reason I took action in the first place, I added a requirement that Automattic no longer infringe upon my mark (which would mean they stop forwarding the domain).</p>\n<p>At this point in the proceedings, I agreed to the settlement.</p></blockquote>\n<p>However, since the decision came early, the settlement was never binding. It&#8217;s also worth noting that Mullenweg commented to me that Pearson&#8217;s stated terms are actually not the terms of the settlement:</p>\n<blockquote><p>In the settlement Automattic offered Chris we agreed not to infringe his trademarks (which is the law, regardless of what the settlement said). He never asked us to change the redirect of thesis.com in the settlement, and if he asked after, we would have said no. There were no restrictions on thesis.com in the settlement.</p></blockquote>\n<p>He also said, &#8220;I wish he had reached out before litigating,&#8221; and noted that it would have &#8220;definitely&#8221; changed the outcome of the entire situation. Whether it truly would have is neither here nor there.</p>\n<h3>Possibility for appeal</h3>\n<p>The UDRP doesn&#8217;t have an official appeals process. Instead, they are willing to not make the changes that a ruling states, if indeed a domain transfer or other action is ordered, if the affected party files a suit in court within ten days of the ruling.</p>\n<p>In this case, Pearson did not file in a court within the given timeline, and since the ruling did not require a change in domain ownership, there is no further recourse with the UDRP. However, there is no time limit if Pearson wishes to file in court &#8212; but that is the only path remaining if he truly wants to go after the domain.</p>\n<h3>Legitimacy of the trademark dispute</h3>\n<p>Trademark law has a long history. Trademarks follow a categorical system, meaning words and terms must be trademarked within a particular category to be applied to.</p>\n<p>Pearson has three trademarks for the Thesis and DIYthemes brands, all under <a href=\"http://www.oppedahl.com/trademarks/tmclasses.htm\">international trademark class</a> 42, for computer, scientific, and legal purposes:</p>\n<ul>\n<li>THESIS</li>\n<li>THESIS THEME</li>\n<li>DIYTHEMES</li>\n</ul>\n<p>The applications were filed in 2010 and registered in 2011. On June 16th, 2015, Automattic filed <a href=\"http://ttabvue.uspto.gov/ttabvue/v?qs=85115266\">cancellation requests</a> for all three trademarks, which were instituted June 25th. Pearson has 40 days from the date the application was instituted (which would be August 4th) to file a response to the cancellation requests. His answers, &#8220;must contain admissions or denials of the allegations in the petition for cancellation, and may include available defenses and counterclaims.&#8221; It is his burden as the defendant to establish his defense, and, &#8220;Failure to file a timely answer may result in entry of default judgment and the cancellation of the registration.&#8221;</p>\n<p>Basically, Automattic is holding his feet to the fire to defend the trademarks, which their counsel feels should not apply for two primary reasons, as listed in their <a href=\"http://ttabvue.uspto.gov/ttabvue/v?pno=92061714&pty=CAN&eno=1\">formal filing</a>.</p>\n<ul>\n<li>The trademarks were registered in Pearson&#8217;s own name, but are used by DIYthemes, and Automattic claims that, &#8220;The Pearson Applications were improperly filed in the name of an individual, who did not have the requisite intent-to-use the marks as of the filing date, and the underlying applications are void ab initio.&#8221; Their claim notes that US Code section <a href=\"https://www.law.cornell.edu/uscode/text/15/1051\">1051(b)</a> offers this justification.</li>\n<li>Furthermore, section <a href=\"https://www.law.cornell.edu/uscode/text/15/1052\">1052(e)(1)</a> requires that a trademark not be &#8220;merely descriptive,&#8221; as Automattic claims his trademarks are.</li>\n</ul>\n<p>If upheld, the trademarks will be deregistered by the US Patent Office, further limiting Pearson&#8217;s options to defend his claims to the thesis.com domain name in a formal court suit.</p>\n<p>I don&#8217;t know how good of a case Automattic has, but purely on the surface it looks pretty good. I spent time reviewing the application and the US Code and the arguments appear fairly sound &#8212; especially the argument that Pearson applied for the trademarks as an individual and utilizes them as DIYthemes, despite DIYthemes already having been registered as an LLC.</p>\n<h3>Automattic&#8217;s justification for the domain</h3>\n<p>During the <a href=\"https://videopress.com/v/WmCl2kwS\">WordCamp San Francisco Q&amp;A</a>, Mullenweg noted the existence of the redirect of the domain name with a sense of pride, and a bit of a side-eyed smirk. In response to a question about relationships with commercial theme sellers and marketplaces, he states:</p>\n<blockquote><p>With the premium theme and plugin folks? &#8230; We have had some ups and downs, particularly with marketplaces that didn&#8217;t follow the GPL, for example, or violated WordPress&#8217;s license &#8212; themes that violated WordPress&#8217;s license. Um, you can go to thesis.com to learn more about that. Type it in, seriously.</p></blockquote>\n<p>I was at this Q&amp;A in person, and don&#8217;t remember him saying this, as it was so buried in a much larger conversation, and I was simultaneously writing a wrap-up post about the State of the Word. However, once the UDRP ruling surfaced publicly, a number of WordPress community members recalled Matt&#8217;s statement and it brought a new dimension to the ruling and Mullenweg&#8217;s motivation for the domain.</p>\n<p>While Automattic bought the domain, Matt Mullenweg was clearly the driving force behind the decision. When <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">WP Tavern prompted Automattic</a> for a comment on their motivation for purchasing the domain, they responded with the following:</p>\n<blockquote><p>We’re happy the panel ruled in our favor. We think Thesis.com is a cool, generic .com that could be used for a variety of things. Just because you have a small WordPress theme doesn’t mean you have a right to seize generic English word .com domains.</p></blockquote>\n<p>We can accept Automattic&#8217;s case that they had a general interest in a generic .com domain, but in reality we know better. Mullenweg was clearly presented with an opportunity by this Larry character that checked all of the right boxes for him.</p>\n<p>He could get a domain he obviously knew Pearson would want, and deny him.</p>\n<p>It has a side benefit that it <em>is</em> a high quality generic domain that will likely maintain or increase its value. And he probably thought it was funny.</p>\n<p>I doubt Mullenweg even knew what kind of trademarks Pearson held, but despite Pearson holding the trademarks, it seems Automattic&#8217;s attorneys now have the upper hand, and it is highly unlikely Pearson will ever own the domain now.</p>\n<p>Mullenweg <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks#comment-70849\">commented</a> on his refusal to give up the domain to Pearson on WP Tavern:</p>\n<blockquote><p>I’m not going to give a domain worth several hundred thousand dollars to the worst actor in the entire WP ecosystem, someone who keeps repeatedly violating the GPL and now has gone beyond that into patents. Why reward that? I wouldn’t sell it if he offered a million dollars.</p>\n<p>There are so many people doing amazing things in the WP community, and 100% GPL! I can and have supported them almost every opportunity I can, and one of the things I’m most proud of in the world is how many fantastic open source businesses have been built on top of WordPress.</p>\n<p>And it’s just the beginning — if you remembered in 2010 Chris said that going GPL would destroy businesses and sticking to the principles of our license would destroy investment in WordPress — we all know how that’s worked out since then.</p></blockquote>\n<p>Such a statement, combined with the WCSF video, highlights that the issue is about far more than the domain and its investment potential &#8212; a 10x return in less than a year would make for an excellent investment, in the near impossible situation Pearson would offer that.</p>\n<p>No, the move was quite clearly a personal one &#8212; if also convenient &#8212; for Mullenweg, and that&#8217;s why terms like &#8220;bully&#8221;, &#8220;petty&#8221;, and &#8220;spiteful&#8221; have been used by many WordPress community members surprised by his actions. They expected more. They expected better, even when directed toward someone as controversial as Chris Pearson.</p>\n<h2>Pearson&#8217;s patent</h2>\n<p>While a tantalizing story, the battle over thesis.com is not <em>the</em> story here. It has simply been the spark to reignite old disputes with new fervor with potentially much bigger consequences than the 2010 affair ever reached.</p>\n<p>One of two additional large components of this story is an active patent application by Pearson that was submitted in 2012 and published in 2014. Keep in mind &#8212; and Chris Pearson reiterated this to me many times &#8212; it is an application for a patent, not a published patent.</p>\n<h3>A patent on Thesis 2, or all web templates?</h3>\n<p>The main patent is titled, <a href=\"https://patents.google.com/patent/US20140095982A1/en?q=thesis&q=diythemes\"><em>Systems, Servers, and Methods for Managing Websites</em></a>. Chris Pearson is listed as the inventor and DIYthemes the assignee.</p>\n<p>The patent never mentions WordPress or WordPress themes, however both in the abstract and in the text, it does have many similarities to what one may expect as a description of a general template mechanism for a website, versus a specific description of the Thesis 2 technology.</p>\n<p>Here is the abstract in full (and here is the <a href=\"https://poststatus.com/wp-content/uploads/2015/07/US20140095982-thesis-patent-app.pdf\">full patent application PDF</a>, including art):</p>\n<blockquote><p>Systems, servers, and methods for managing websites. Some embodiments provide methods which include, according to a user selection of a website skin, activating the selected skin. The skin comprises at least one structural box further comprising structural code for the website. The method also includes receiving a request (for instance a call to a hook) to serve the website. Further, the method includes, responsive to the request, outputting (by echoing PHP code if desired) the structural code with style related code applied thereto according to a reference between the box and a style package (which comprises the stylistic code). The outputting can occur in an order associated with the boxes. In some situations, another skin can be activated. Moreover, a change (or, perhaps, an edit) can be made to another skin and displayed without affecting the website. Moreover, another skin can be selected and associated with the website.</p></blockquote>\n<p>I discussed the patent at length with Chris Pearson, and while much of that conversation is off the record, I can share what I believe his motivations are with the patent application, and what I think the potential implications for this new chapter of Pearson versus Mullenweg are.</p>\n<h3>Discovery and publicity of the patent</h3>\n<p>This patent and another that&#8217;s since been rescinded were discovered by Automattic&#8217;s lawyers during the UDRP proceedings. There is debate as to how members of the WordPress community discovered the patents&#8217; existence &#8212; Jeff Chandler of WP Tavern and Carl Hancock of Gravity Forms were two of the first to discuss it publicly &#8212; but there is speculation from Chris Pearson and others that the community discovery of these patents was leaked by Mullenweg himself in order to deflect the attention at the time away from the domain issue and onto the patents and their potential implications.</p>\n<p>I honestly don&#8217;t care how they came up, though Pearson&#8217;s questioning of Jeff Chandler&#8217;s journalistic integrity were uncalled for. It is anyone&#8217;s right and ability to tip someone off to legitimate news &#8212; and these patent applications are legitimate news &#8212; and I don&#8217;t believe for a second that Chandler has played puppet to his boss&#8217;s wishes. He has dutifully and to the best of his ability written about whatever news matters to the community, and I respect him for it.</p>\n<p>Nevertheless, this patent does potentially have significantly more newsworthiness, depending on if it is approved and how it is defended by Pearson if it is approved.</p>\n<h3>Patent law and litigation</h3>\n<p>Patents often get a bad reputation, and their role in the software world is quite murky. I apologize in advance for this long sidebar on the wild world of patents.</p>\n<h4>Patent trolls</h4>\n<p>Most folks have heard of &#8220;patent trolls&#8221; that prey on companies using vague or overly generic patents, demanding big payouts.</p>\n<p>Patent law is weird, and the lawsuits that result are infamously unpredictable and cause a scenario ripe for abuse. For example, filing patent lawsuits in one district over another can have enormous impact, like <a href=\"http://www.nytimes.com/2006/09/24/business/24ward.html?pagewanted=all&_r=0\">the case of Marshall, Texas</a>, which is a hotbed for patent trolls:</p>\n<blockquote><p>Patent litigation is a growing business across the country; Marshall is just the most visible example. Among the weightier issues behind the mushrooming of its patent docket is whether the elements that have made it expand — hungry plaintiffs’ lawyers, speedy judges and plaintiff-friendly juries — are encouraging an excess of expensive litigation that is actually stifling innovation.</p>\n<p>Some say yes. “A lot of the cases being filed in Marshall are by patent holding companies, or patent trolls, as they’re called, whose primary and only assets are patents,” Mr. Tyler said.</p></blockquote>\n<p>Companies that deal in patents but do not utilize the patented technology are <a href=\"https://www.patentfreedom.com/about-npes/background/\">called non-practicing entities (NPEs)</a>.</p>\n<p>One of the concerns with Pearson&#8217;s patent would be if it were approved and he sold it to an NPE. It&#8217;s not uncommon for NPEs to acquire patents with the express purpose to enforce them:</p>\n<blockquote><p>Finally, of course, some entities buy patents with the express purpose of licensing them aggressively. For instance, about 25% of “parent” NPEs tracked by PatentFreedom are enforcing only patents that they had acquired. Another 60% are asserting patents originally assigned to them, and the remaining 15% are asserting a blend of originally assigned and acquired patents. However, if we add in the more than 2,100 subsidiaries and affiliates of these entities and treat them all as standalone entities, we find that 19% of them are originally assignees, and 69% are acquirers, and 12% are blends.</p>\n<p>Regardless of the important variations in their origin and behavior, NPEs present a fundamentally different challenge than operating company patent assertions.</p></blockquote>\n<h4>Software patents unpredictability and &#8220;obviousness&#8221;</h4>\n<p>The concept of software patents <em>at all</em> has been in dispute for a long time. Thousands have been awarded, but there are a handful of past court rulings that seem to <a href=\"https://www.law.cornell.edu/uscode/text/35/part-II/chapter-10\">govern the US Patent and Trademark office&#8217;s interpretations</a> for making decisions when reviewing software patents.</p>\n<p><a href=\"http://www.ipwatchdog.com/2014/02/01/when-is-an-invention-obvious/id=47709/\">Obviousness</a> is a key term in the patent world. Patent applicants aim to create &#8220;meaningful&#8221; patents, but &#8220;at a minimum you must have claims that embody patent eligible subject matter, demonstrate a useful invention, cover a novel invention and which are non-obvious in light of the prior art. Obviousness is typically the real hurdle to patentability, and unfortunately the law of obviousness can be quite subjective and difficult to understand. At times obviousness determinations almost seems arbitrary.&#8221;</p>\n<p>&#8220;Art&#8221; is the outlay of the invention by the applicant, and the invention&#8217;s ability to be patented depends on &#8220;prior art&#8221; not deeming the invention as obvious. Establishing non-obviousness for software has a contentious history. If it can be shown that, &#8220;any combination of prior art references that when put together would be the invention in question,&#8221; then the applicant is in trouble.</p>\n<p>But there is a great deal of potential for subjectivity from thousands of patent examiners:</p>\n<blockquote><p>Still, ever since the Supreme Court’s decision in KSR [<a href=\"http://www.ipwatchdog.com/2012/04/29/ksr-the-5th-anniversary-one-supremely-obvious-mess/id=24456/\">reference</a>] there has been a great deal of subjectivity in the application of the law of obviousness, which is apparent if you look at the patents that issue, patents that are finally rejected and ultimately abandoned, and the patents the Federal Circuit ultimately finds to include obvious patent claims. There is little to no predictability at the edges.</p></blockquote>\n<h4>The Alice case</h4>\n<p>In my research, the <em>Alice case</em> came up many times as a pivotal case for helping to define the legitamacy of software patents. Martin Goetz is the holder of the first ever software patent, and has <a href=\"http://www.ipwatchdog.com/2015/02/06/alice-v-cls-bank-is-a-victory-for-software-patents/id=54489/\">an excellent write-up on the importance of the Alice case</a>.</p>\n<blockquote><p>I have been asked for my opinion based my long history in the software industry and from my perspective as someone that has followed that controversial question “Is Software patentable”? That question first began to be publicly debated when I received the first software patent in 1968 for an invention on a new way of sorting data on a computer. Shortly thereafter a publication printed a page one headline “First Patent is Issued for Software, Full Implications Are Not Yet Known.”</p>\n<p>Forty five years later a variation of that question was again before the Supreme Court when it agreed to hear the appeal of the Alice v. CLS Bank case.</p></blockquote>\n<p>Goetz argues that the Alice case is a victory for software patents on both sides: that it helps true inventions gain patents (he and others assign a high standard to define &#8220;invention&#8221;), and it also helps prevent abuse of overly vague or non-inventive &#8220;obvious&#8221; patents to be denied:</p>\n<blockquote><p>The Alice v CLS Bank Supreme Court decision in June 2014 was a great victory for those that believe that inventors that use a digital computer to innovate can get a patent on their invention. It is also a victory for those people and organizations that recognize how the patent System has been abused for many years by trolls and others where there was no invention. Since the Supreme Court decision in June, thousands of patents that should never have been issued are now being deemed invalid by the US Courts and by the Patent Office.</p></blockquote>\n<h4>Obviousness and invention for Pearson&#8217;s patent</h4>\n<p>This long and boring description of patents is necessary because Pearson&#8217;s patent application is still just an application, and it can be challenged, both by the patent reviewer, but also by third parties.</p>\n<p>As patent obviousness is &#8220;so unevenly applied,&#8221; there is some risk in not challenging Pearson&#8217;s patent, if a third party like Automattic (or a myriad of other web template providers) is worried about the potential implications of the patent. Although, the Alice case does seem &#8212; in my very amateur opinion &#8212; to offer better guidance to reject the patent based on a lack of true invention.</p>\n<h3>Pearson&#8217;s reasoning for a patent, and its likelihood for success</h3>\n<p>Patents are not cheap to apply for. The patent application Pearson submitted is 34 pages of art diagrams and text describing the inventiveness of Thesis 2, though Thesis 2 is not specifically named.</p>\n<p>I asked Pearson why he applied for the patent, which he did not want to share the specifics of his position due to the open nature of the application. I&#8217;ve racked my brain to try and determine the potential causes as well.</p>\n<p>There are only a couple of decent outcomes for Pearson with this patent application. The most likely, and not good outcome for him, is that he is denied the patent; and in this case he would have spent a great deal of money for nothing.</p>\n<p>In the event he does get the patent &#8212; or perhaps even before it is fully reviewed for approval &#8212; he could face a challenge from Automattic or other parties that may be concerned his invention&#8217;s description could apply more broadly than Thesis 2.</p>\n<p>If he gets the patent, and he survives a challenge, I see three ways he could theoretically use it:</p>\n<ul>\n<li>He can do nothing.</li>\n<li>He can sell it to the highest bidding NPE, which would be a dreadful outcome for any web entities that sell templates.</li>\n<li>He can keep it in his back pocket, in case someone threatens his business or his software license, wherein he can initiate a lawsuit.</li>\n</ul>\n<p>Honestly, the whole patent route seems odd. I don&#8217;t love the idea of this patent being approved, because the application does seem overly broad toward all web templates to me, from the title to the meat of the application&#8217;s art. However, there are loads of patents in the world for incredibly silly things that have never really impacted a lot of folks&#8217; life; it&#8217;s just that it doesn&#8217;t mean a silly patent <em>couldn&#8217;t</em> become a problem. The Electronic Frontier Foundation has <a href=\"https://www.eff.org/patent\">mountains of evidence</a> of patent holders causing havoc.</p>\n<p>I&#8217;m not much of a gambler, but if I had to gamble on this I&#8217;d put my money on this patent never being approved, and definitely never truly impacting the web or WordPress industry at scale.</p>\n<p>I don&#8217;t think Pearson is a bad guy for wanting to patent his work. When I requested comment about the patents, he told me, &#8220;If I were ever to consider selling my business, things like trademarks and patents show up on the balance sheet and add to the bottom line,&#8221; but that he views them as, &#8220;one of many expensive, ridiculous options for bolstering one&#8217;s business,&#8221; versus a way to celebrate and protect his achievements as I previously characterized his intentions.</p>\n<h2>The GPL</h2>\n<p>Most agree that the GPL has not been well tested in court, though a <a href=\"https://en.wikipedia.org/wiki/Software_license\">software license</a> is a &#8220;legal instrument.&#8221; There is often confusion over whether a license is a contract or not.</p>\n<h3>License versus contract</h3>\n<p>One of my favorite <a href=\"http://softwarelawyer.blogspot.com/2008/01/jacobsen-v-katzer.html\">things I&#8217;ve read on this</a> is by former Adobe Associate General Counsel Robert Pierce:</p>\n<blockquote><p>A license is not a contract. This much I know.</p>\n<p>Rather, a license is a permission granted by one party to another allowing use of a property without fear of lawsuit brought by the granting party. A license does not include a return promise (i.e., consideration) from the licensee. So, as we all learned in law school, a license cannot be a contract under law. This is not to say that a license cannot be an element of a contract under which two parties trade promises, one of such promises being a license. This is commonly known as a &#8220;license agreement.&#8221; But a bald license, a one-way promise, is enforceable outside of contract law. It is something apart. It exists and is enforceable under property law doctrine.</p>\n<p>What makes things difficult is that the scope of a license&#8217;s grant, and the conditions and restrictions on the license (or all of them together) can make what is intended to be a one-way license look a lot like a contract. The precise wording used becomes critical.</p></blockquote>\n<p>The distinction can be significant because, &#8220;contracts are enforceable by contract law, whereas licenses are enforced under copyright law,&#8221; though even this rule depends on the jurisdiction where the matter is being discussed. His larger point is that a license is a one-way street, whereas a contract is agreed upon by both sides.</p>\n<h3>Spirit of the GPL</h3>\n<p>There is little debate that a &#8220;Split GPL&#8221; or &#8220;PHP GPL&#8221; license is perfectly GPL compatible, though Mullenweg doesn&#8217;t consider that the &#8220;<a href=\"https://github.com/WordPress/book/blob/e55a93f1056ffac8466944086b2c5104becab9c4/Content/Part%206/42-spirit-of-the-gpl.md\">spirit of the GPL</a>,&#8221; and companies like Envato&#8217;s ThemeForest and others have felt the consequences of not adopting 100% GPL licenses.</p>\n<p>From <em>Milestones</em>:</p>\n<blockquote><p>While not everyone liked the fact that the WordPress project would only support 100% GPL products, most people had accepted it. Many, however, were taken by surprise, by a sudden flare-up around not just the legalities of the GPL, but the “spirit” of the license. In a 2008 interview, Jeff Chandler asks Matt about the spirit of the GPL. Matt says that the spirit of the GPL is about user empowerment, about the four freedoms: to use, distribute, modify, and distribute modifications of the software. Software distributed with these four freedoms is in the spirit of the GPL. WordPress was created and distributed in this spirit, giving users full freedom with regard to the software.</p>\n<p>The Software Freedom Law Center&#8217;s opinion &#8212; with regards to WordPress themes, however &#8212; gives developers a loophole, one that helps them achieve GPL compliance, but denies the same freedoms as WordPress. PHP in themes must be GPL, but the CSS, images, and JavaScript do not have to be GPL. This is how Thesis released with a split license &#8212; the PHP was GPL, while the rest of the code and files were proprietary. This split license ensures that the theme is GPL compliant yet it isn&#8217;t released under the same spirit as the GPL&#8217;s driving user-freedom ethos.</p>\n<p>The loophole may have kept theme sellers in line with the GPL, but WordPress.org didn&#8217;t support that approach. In a 2010 interview, Matt says “in the philosophy there are no loopholes: you’re either following the principles of it or you’re not, regardless of what the specific license of the language is.&#8221; Theme sellers that sell their themes with a 100% GPL license are supported by WordPress. Those that aren’t don’t get any support or promotion on WordPress.org or on official resources. This is also one of the WordCamp guidelines, introduced in 2010; that WordCamps should promote WordPress’ philosophies. If a speaker, volunteer, or organizer is distributing a WordPress product it needs to be 100% GPL, i.e., the CSS, JavaScript, and other assets need to be GPL, just like the PHP.</p></blockquote>\n<p>Mullenweg believes that Thesis 2 is not only not in the spirit of the GPL, but flagrantly operates in total violation of it, as Thesis 2 carries a 100% proprietary license. Considering the implications for folks that make stuff compatible with the GPL, it&#8217;s little surprise that Mullenweg has taken the stance and actions he has toward Pearson.</p>\n<h3>Thesis 2 carries a proprietary license</h3>\n<p>Chris Pearson&#8217;s <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php#comment-1507962\">comment on his blog post</a> describes that the theme has always been a proprietary license, and he describes why it is okay to be such:</p>\n<blockquote><p>In October 2012, I released an all-new version of Thesis that carried the same name as the original (which had a split-GPL license), but that’s where the similarities stopped.</p>\n<p>The new Thesis is not a Theme—it is an operating system for templates and design. This system runs Skins and Boxes, which are similar to Themes and Plugins, but with a boatload of built-in efficiencies that Themes and Plugins cannot provide.</p></blockquote>\n<p>It is worth noting the final paragraph of the SFLC&#8217;s opinion that Mullenweg has cited numerous times as justification against proprietary licenses <em>does</em> have a provision for avoiding WordPress&#8217;s copyright:</p>\n<blockquote><p>Finally, we note that it might be possible to design a valid WordPress theme that avoids the factors that subject it to WordPress’s copyright, but such a theme would have to forgo almost all the WordPress functionality that makes the software useful.</p></blockquote>\n<p>That&#8217;s exactly what Pearson believes Thesis 2 is. But the GPL has rarely been tested in a proper court, and never from a WordPress perspective. The SFLC&#8217;s opinion is just that, for now, whether Mullenweg likes it or not.</p>\n<h3>The GPL in court</h3>\n<p>The Free Software Foundation maintains the copyright on the text of the GPL itself, and between the FSF and the SFLC, a <a href=\"https://en.wikipedia.org/wiki/GNU_General_Public_License#Legal_status\">small number of lawsuits</a> have occurred, and a German court upheld the GPL as a &#8220;valid, legally binding&#8221; license, but most of these tests have occurred outside of the United States. From what I can tell, cases involving the GPL have largely settled outside of court when based in the United States, or were argued on whether the GPL was legally applied, like in the case of <a href=\"https://en.wikipedia.org/wiki/SCO_Group,_Inc._v._International_Business_Machines_Corp.#The_GPL_issue\">SCO vs IBM</a>, rather than whether the GPL was legally binding itself.</p>\n<p>In another case, <a href=\"https://en.wikipedia.org/wiki/Wallace_v._International_Business_Machines_Corp.\">Wallace vs FSF</a>, Daniel Wallace compared the GPL to price fixing, as it required software to be free. The FSF won the case, as the judge cited, &#8220;The GPL encourages, rather than discourages, free competition and the distribution of computer operating systems, the benefits of which directly pass to consumers. These benefits include lower prices, better access and more innovation.&#8221;</p>\n<p>A much <a href=\"http://www.infoworld.com/article/2893695/open-source-software/vmware-heading-to-court-over-gpl-violations.html\">newer case involving VMware</a> again tests the GPL. The Software Freedom Conservancy, &#8220;claims VMware is using the Linux kernel without respecting the terms of its copyright license, the GPL.&#8221; This case may offer a better precedent for WordPress and its derivative works, as it is centered on &#8220;module loading&#8221; in VMware, &#8220;with an insulating layer to allow its kernel to use unmodified Linux drivers.&#8221; The case gets murkier than that, as it may not have been as isolated as it was attempted, but the result could be decent precedent for similarly loading WordPress themes and plugins, in my opinion.</p>\n<h3>Limited guidance</h3>\n<p>Few lawyers want to be the first to test something in court. It&#8217;s easier to make a case when there are many cases before you to provide guidance. With the GPL, there is what&#8217;s called &#8220;limited guidance,&#8221; meaning that it&#8217;s untested, and therefore the outcome of a GPL case in the US could be very difficult to predict.</p>\n<p>If a lawsuit does occur, it could prove costly to all parties involved, and I think it&#8217;s clear that Pearson and Mullenweg both wish that litigation was not happening, though both of them maintain a bit of a &#8220;you started it&#8221; attitude.</p>\n<p>Without a formal court proceeding, which could last years, it&#8217;s going to be near impossible for Matt Mullenweg to fully prevent non-GPL compatible licenses to exist for WordPress themes and plugins. His best method to prevent it is to do what he&#8217;s done so far: make an example of bad offenders and cause anyone thinking of using a non-GPL compatible license to reconsider.</p>\n<h2>Are all WordPress themes derivative works?</h2>\n<p>A key question to whether themes and plugins must be GPL compatible licensed is whether the theme or plugin is a derivative of WordPress itself. If it is derivative, then it is under the umbrella of the GPL&#8217;s Copyleft nature.</p>\n<p>Folks disagree a good bit on how themes and plugins should be considered as derivative works, though most either agree with Mullenweg&#8217;s strict &#8220;spirit of the GPL&#8221; view, or at least have molded to avoid being an outcast.</p>\n<p>The strongest argument I&#8217;ve seen in favor of all themes being derivative of WordPress &#8212; no matter how much or little they rely on WordPress functionality &#8212; is from WordPress lead developer Mark Jaquith:</p>\n<blockquote><p>There is a tendency to think that there are two things: WordPress, and the active theme. But they do not run separately. They run as one cohesive unit. They don’t even run in a sequential order. WordPress starts up, WordPress tells the theme to run its functions and register its hooks and filters, then WordPress runs some queries, then WordPress calls the appropriate theme PHP file, and then the theme hooks into the queried WordPress data and uses WordPress functions to display it, and then WordPress shuts down and finishes the request. On that simple view, it looks like a multi-layered sandwich. But the integration is even more amalgamated than the sandwich analogy suggests.</p>\n<p>Here is one important takeaway: <em>themes interact with WordPress (and WordPress with themes) the exact same way that WordPress interacts with itself</em>. Give that a second read, and then we’ll digest.</p>\n<p>The same core WordPress functions that themes use are used by WordPress itself. The same action/filter hook system that themes use is used by WordPress itself. Themes can thus disable core WordPress functionality, or modify WordPress core data. Not just take WordPress’ ultimate output and change it, but actually reach into the internals of WordPress and change those values before WordPress is finished working with them. If you were thinking that theme code is a separate work because it is contained in a separate file, also consider that many core WordPress files work the same way. They define functions, they use the WordPress hook system to insert themselves at various places in the code, they perform various functions on their own but also interact with the rest of WordPress, etc. No one would argue that these core files don’t have to be licensed under the GPL — but they operate in the same way that themes do!</p>\n<p>It isn’t correct to think of WordPress and a theme as separate entities. As far as the code is concerned, they form one functional unit. The theme code doesn’t sit “on top of” WordPress. It is within it, in multiple different places, with multiple interdependencies. This forms a web of shared data structures and code all contained within a shared memory space. If you followed the code execution for Thesis as it jumped between WordPress core code and Thesis-specific code, you’d get a headache, because you’d be jumping back and forth literally hundreds of times. But that is an artificial distinction that you’d only be aware of based on which file contained a particular function. To the PHP parser, it is all one and the same. There isn’t WordPress core code and theme code. There is merely the resulting product, which parses as one code entity.</p></blockquote>\n<p>Jaquith&#8217;s argument that the theme and WordPress execute together to form a joint &#8220;modified work&#8221; is the key phrase, I believe. As he states, and I tend to agree, it does not matter that the files are separate or that they can be distributed independently; together, when executed, they are so intertwined that they become a single work.</p>\n<p>That said, the theme is clearly dependent on WordPress itself, which is another common justification that themes are derivative. Explaining this concept is simple: WordPress can be distributed without any theme but those that ship with it by default. But a distributed theme, like Thesis, must be <em>installed and activated using WordPress&#8217;s own schema for loading a template</em>, and cannot operate independently of WordPress.</p>\n<h3>What about the WordPress REST API?</h3>\n<p>Thus far, we&#8217;ve discussed the derivative nature of WordPress themes and plugins, which require they operate within the WordPress install. It is a different matter if we consider applications that consume data or interact with WordPress as an outside application.</p>\n<p>The WordPress REST API enables one to interact with or consume data from WordPress, while being wholly independent of the WordPress install. Jaquith makes a clear exception for a scenario like this (and also applies it to technologies like RSS and XML-RPC):</p>\n<blockquote><p>Something that interacts with these APIs sits entirely outside of WordPress. Google Reader doesn’t become part of WordPress by accessing your feed, and MarsEdit doesn’t become part of WordPress when you use it to publish a post on your WordPress blog. These are separate applications, running separately, on separate codebases. All they are doing is communicating. Applications that interact with WordPress this way are separate works, and the author can license them in any way they have authority to do so.</p></blockquote>\n<h3>The GNU&#8217;s take</h3>\n<p>The GNU agrees with Jaquith&#8217;s take. They provide <a>an FAQ</a> to answer, &#8220;&#8221;What is the difference between an &#8216;aggregate&#8217; and other kinds of &#8216;modified versions&#8217;?&#8221; The emphasis provided is my own:</p>\n<blockquote><p>An “aggregate” consists of a number of separate programs, distributed together on the same CD-ROM or other media. The GPL permits you to create and distribute an aggregate, even when the licenses of the other software are non-free or GPL-incompatible. The only condition is that you cannot release the aggregate under a license that prohibits users from exercising rights that each program&#8217;s individual license would grant them.</p>\n<p><em>Where&#8217;s the line between two separate programs, and one program with two parts? This is a legal question, which ultimately judges will decide</em>. We believe that a proper criterion depends both on the mechanism of communication (exec, pipes, rpc, function calls within a shared address space, etc.) and the semantics of the communication (what kinds of information are interchanged).</p>\n<p><em>If the modules are included in the same executable file, they are definitely combined in one program. If modules are designed to run linked together in a shared address space, that almost surely means combining them into one program</em>.</p>\n<p>By contrast, pipes, sockets and command-line arguments are communication mechanisms normally used between two separate programs. So when they are used for communication, the modules normally are separate programs. But if the semantics of the communication are intimate enough, exchanging complex internal data structures, that too could be a basis to consider the two parts as combined into a larger program.</p></blockquote>\n<p>The GNU argument falls very much in line with Jaquith&#8217;s, though admits itself that judges must decide whether it&#8217;s the case, in the end.</p>\n<h3>The case against The GNU position on derivative works</h3>\n<p>The University of Washington School of Law has a <a href=\"http://www.law.washington.edu/lta/swp/index.html\">section of their website</a> devoted to the, &#8220;business, legal and technical consequences of choosing Open Source Software (OSS) or proprietary software.&#8221; They cover many of the topics I&#8217;ve outlined in this post so far, and <a href=\"http://www.law.washington.edu/lta/swp/Law/derivative.html\">in the case of the GPL and derivative works</a>, they believe the GNU is overstepping with an &#8220;expansive definition&#8221; of derivative works with consequences, &#8220;counter to the goals of the proponents of Free Software.&#8221;</p>\n<p>The most compelling of multiple derivative works examples they provide is that of subclasses. For example, imagine a class, <code>Some_Theme_Class</code> that extends <code>Some_Core_WordPress_Class</code>. The GPL FAQ is very hardline on the topic (and for what it&#8217;s worth, Thesis 2 does extend some WordPress core classes). Washington believes the GNU stance on inheritance is too over-reaching:</p>\n<blockquote><p>Example 5: Programmer X wishes to write a class D, that is a subclass of existing class B. Class B is subject to the terms of the GPL. If X distributes D, does it have to be licensed under the terms of the GPL?</p>\n<p>The answer given in the GPL FAQ is short and to the point: &#8220;Subclassing is creating a derivative work.&#8221; In our example, this makes D a work derived from B, and thereby makes D subject to the terms of the GPL upon distribution. This approach attempts to further broaden the reach of the GPL, but it again leads to counter-intuitive results.</p>\n<p>Typical object oriented programming languages include a standard class hierarchy. This hierarchy provides a framework within which application developers can build their programs. The standard classes typically provide useful classes that represent user interface elements (e.g. windows, buttons, etc.), collection classes (for handling collections of data), and input-output abstractions (e.g. files and networking connections). In many object oriented languages, each class must be a subclass of exactly one superclass. And for this reason, the class hierarchies are rooted by a highly generic, standard class called Object. (The question of the superclass of Object is beyond the scope of this article.) The class Object describes only the most general properties and behaviors. For instance, in Java, the class Object only performs a handful of functions. In Java, every class is a subclass (directly or indirectly) of the Object class. Under the GPL approach, then, every program written in Java is a derived work of Object, because every program written in Java by definition consists of classes that inherit from the Object class.</p></blockquote>\n<p>Whether this argument or any of the others Washington outlines would apply to WordPress themes and/or plugins would, again, need to be settled in court. But Washington does give a compelling argument.</p>\n<p>They conclude with the following:</p>\n<blockquote><p>In some ways, the apparent weaknesses in the GPL should come as no surprise, as the GPL was born of an era in which the central artifact of software development and distribution was the monolithic executable. In such a universe, software development proceeded principally by modifying the existing source text of programs, compiling source modules, linking the corresponding object files, and distributing the resulting executable. This model of software development and distribution has become increasingly fractured in an era characterized by highly dynamic, late binding, object- and network-based systems. The GPL, consequently, strains to cover these newly arising scenarios.</p>\n<p>To effectuate the goals of the free software movement, the drafters of the GPL urge a generally expansive definition of derivative work. The great irony is, of course, that such an expansive definition would have second order consequences that are exactly counter to the goals of the proponents of Free Software. A broad definition of derivative would give code authors less freedom to create software that they can truly call their own and do with as they please. And if naive analytic approaches such as &#8220;subclassing equals derivation&#8221; reign, then proprietary vendors such as Microsoft could arguably stake claim to every program ever written in C#, because they authored the original class hierarchy. And since it seems unlikely that courts would employ different standards depending on the goals or ideological motivations of licensors, proponents of free software might want to be careful what they wish for: what&#8217;s good for the GNU might not be good for the gander.</p></blockquote>\n<h3>Aggressive license agreements</h3>\n<p>Both the GPL and DIYthemes&#8217; proprietary license could be appropriately identified as aggressive. The Copyleft nature of the GPL annoys many open source advocates, who would prefer a less restrictive license for developers, like the MIT or BSD licenses. The GPL is absolutely an opinionated license.</p>\n<p>Pearson&#8217;s proprietary license is also aggressive, in the other direction. I&#8217;ve never purchased a WordPress-centric product that so strongly forced me to accept a license. Usually, you have to look in the source code or a page on the website for a license; DIYthemes forces you to accept the <a href=\"http://diythemes.com/thesis/rtfm/software-extensions-license-agreement/\">terms of the proprietary license</a> before you can download the product at all.</p>\n<h3>Derivative works are not a bright line</h3>\n<p>The GNU attempts to offer a &#8220;bright line&#8221; distinction for derivative works. A bright line, in much of the legal analysis I&#8217;ve read, is where <em>thing x</em> is so because of <em>thing y</em>, and can be applied across the board. You can clearly see the bright line, and when it has been crossed.</p>\n<p>Washington proves the point quite well that the GNU&#8217;s bright line approach to derivation is quite challengeable. But I don&#8217;t think their arguments prove that WordPress themes in particular are not derivative. I believe, from a legal perspective, it&#8217;s fuzzier than a bright line approach, and if I were Mullenweg or anyone defending GPL software, I would not be excited to take the issue to court.</p>\n<p>The &#8220;spirit of the GPL&#8221; is to offer users liberal freedoms, even while restricting developers building on a GPL licensed application. And I believe there is merit in the fact that WordPress, its co-founders, its lead developers, and the vast majority of its copyright holders (contributors) wish to defend the spirit of the license, even if it&#8217;s not been tested in court.</p>\n<p>Pearson is not in the majority opinion by using a proprietary license, but he is also not definitively in a position of legal wrongdoing. His desire to protect his works from user freedoms with a proprietary license may well be tested all the way to the courts, and he must be prepared to deal with that, but I don&#8217;t believe there is clear wrongdoing, legally, with his license.</p>\n<h2>A tale of idealism</h2>\n<p>Matt Mullenweg and Chris Pearson are two of the most idealistic people I&#8217;ve ever observed. They are near polar opposites, from their business belief systems and even their general world views.</p>\n<p>One of the most depressing components of my research was something Pearson told me. I asked him why he doesn&#8217;t just get out of it all and do something else. He&#8217;s not married to the culture of WordPress bestowed on it by its leaders. He called it, the &#8220;zeitgeist of western culture,&#8221; with its openness, zen attitude, and more that he feels no need to embrace if he doesn&#8217;t want to.</p>\n<p>But he admits that WordPress, &#8220;is the most used piece of software to build a website in the world. WordPress was the beneficiary of impeccable timing.&#8221; And it&#8217;s a tool for him to make his living; it&#8217;s his job, and he doesn&#8217;t see a need to be in love with every aspect of his job. This is what made me sad, because for most of us that make our living within this space, we were able to escape the &#8220;it&#8217;s just a job&#8221; mentality and be emotionally enriched by what is possible on the open web.</p>\n<p>Matt could probably drop his various issues with Pearson and life would go on. The vast majority of WordPress businesses could understand the status quo and live by it, and those that don&#8217;t can keep living their lives outside of the approval of Mullenweg, and for that matter, the official WordPress project and website. But he too insists to stand up for his ideals and the web he believes in. He sees himself as a defender of the user, and his defense of the GPL is an extension of his core beliefs on software.</p>\n<p>They will never agree on licensing, that much is clear. The question of what&#8217;s next is multi-layered.</p>\n<h3>Will litigation continue?</h3>\n<p>Undoubtedly, yes, litigation will continue. But the litigation should be viewed as three distinct parts:</p>\n<ul>\n<li>In regard to the thesis.com domain, it&#8217;s really a sideline issue that resulted from more deep-rooted differences in ideals that turned into a personal spat. Pearson may continue in court to try and get the domain back, but I doubt it. I don&#8217;t know if Automattic will relent on the trademark cancellation requests, but I wouldn&#8217;t be surprised if they dropped it in some form of settlement.</li>\n<li>The patent issue is not over. I believe Automattic and potentially other organizations will challenge Pearson&#8217;s patent application using a variety of legal options available. The chances the patent gets approved or holds up long term are unlikely (but yes, it is possible), and I don&#8217;t believe there is a significant chance it will have longstanding implications on the WordPress project.</li>\n<li>I believe the GPL will continue to be tested in court, and eventually we may have a proper precedent set to put current questions aside. I won&#8217;t pretend a guess how it will turn out, because I think it truly depends on many, many factors. I do think that if Matt Mullenweg pursues a case himself, he will be joined by a number of interested organizations, including the Free Software Foundation; or the GPL debate could be settled in court in a completely different dispute, unrelated to WordPress &#8212; but have a longstanding impact on products made for WordPress.</li>\n</ul>\n<h3>Is this debate bad for WordPress?</h3>\n<p>The <em>way</em> this debate has occurred is bad for WordPress. Neither Matt Mullenweg nor Chris Pearson looks like a saint right now. And parts of the whole thing don&#8217;t do a whole lot to further the conversation.</p>\n<p>At the root of the debate is licensing, and that debate is worth having.</p>\n<p>It is important that we separate the intent and the legal interpretation of the GPL. It is also important that we separate one&#8217;s legal ability to not license distributed WordPress products as GPL compatible, versus the business and community consequences that may result from such a decision.</p>\n<h2>Endmatter</h2>\n<p>This post would not be possible without the Post Status <a href=\"https://poststatus.com/partners\">Partners</a> and <a href=\"https://poststatus.com/profiles\">Members</a> that fund the website, and my ability to write about WordPress full time. If you enjoyed this post, please consider becoming a <a href=\"https://poststatus.com/club\">Post Status member</a> to fund more free content, plus loads of great members-only benefits, including a daily-ish newsletter that keeps you covered on the happenings of the WordPress world.</p>\n<p>I would also like to thank Matt Mullenweg and Chris Pearson for the interviews they provided me in preparation of this post.</p>\n<p>And I&#8217;d like to thank my lawyer, <a href=\"http://associatesmind.com\">Keith Lee</a> (a WordPress fan and blogger himself!) for helping me think through some of the legal matters discussed &#8212; though the opinions themselves are my own.</p>\n<p>Finally, I&#8217;d like to thank the folks that helped me review the post, consider my positions, and organize my thoughts. You know who you are.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Jul 2015 01:42:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WPTavern: Who’s Using the WordPress REST API?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47039\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"http://wptavern.com/whos-using-the-wordpress-rest-api\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4659:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/04/wp-rest-api.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/04/wp-rest-api.jpg?resize=1025%2C469\" alt=\"wp-rest-api\" class=\"aligncenter size-full wp-image-43000\" /></a></p>\n<p>Ryan McCue and the <a href=\"https://github.com/WP-API/WP-API\" target=\"_blank\">WP REST API</a> team are <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">seeking feedback</a> on the project ahead of the API merging into core. McCue invited comments on the post to find out how and where it&#8217;s currently being used, in hopes of identifying any roadblocks developers may be facing.</p>\n<p>&#8220;We’d love to hear feedback from everyone using this, from JS-only developers coming to WP for the first time, through WordPress plugin and theme developers, all the way through to PHP developers not involved with WordPress,&#8221; he said.</p>\n<p>Comments on the post provide a nice overview of places where the API is already in use in production all over the WordPress development community. A few examples include:</p>\n<ul>\n<li><a href=\"https://hmn.md/\" target=\"_blank\">Human Made</a> uses the API with client projects, i.e. to create a Node-powered frontend and maintain the familiar WordPress admin.</li>\n<li><a href=\"http://reactor.apppresser.com/\" target=\"_blank\">Reactor</a> uses the API to create mobile apps that digest the API themselves.</li>\n<li><a href=\"http://aesopstoryengine.com/\" target=\"_blank\">Aesop Interactive</a> uses the API with <a href=\"http://wptavern.com/lasso-frontend-editing-plugin-for-wordpress-now-available-on-github\" target=\"_blank\">Lasso</a> and also to power the <a href=\"http://wptavern.com/new-wp-live-search-plugin-utilizes-the-wp-rest-api\" target=\"_blank\">WP Live Search</a> plugin.</li>\n<li>A large industrial real estate firm manages its properties via an internal proprietary .NET app with a public-facing site powered by WP. It uses the API to sync property data (in real time) between the internal app and the website so the real estate listings will always be current.</li>\n<li><a href=\"https://www.joininuk.org/\" target=\"_blank\">Join In</a>, a site organizing volunteers in the UK, used the API to create <a href=\"https://www.joininuk.org/widget/\" target=\"_blank\">an embeddable JS widget</a>.</li>\n<li><a href=\"https://profiles.wordpress.org/pers/\" target=\"_blank\">Per Soderlind</a> used the WP REST API as <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/#comment-26372\" target=\"_blank\">a backend for an iOS application</a> for the Norwegian Ministry of Petroleum and Energy.</li>\n<li><a href=\"http://tri.be/about/\" target=\"_blank\">Modern Tribe</a> is building sites that use the REST API to power both Handlebars and full page React templates in themes.</li>\n</ul>\n<p>Those are just a small sampling of places where the API is being used to make WordPress more flexible for creating custom solutions. For many who are using the API or hoping to use it, the main hindrance is that it&#8217;s not yet in core.</p>\n<p>&#8220;The biggest issue right now is that the REST API isn’t included in core,&#8221; a representative from Ashworth Creative <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/#comment-26390\" target=\"_blank\">commented</a>. &#8220;If we build plugins or a theme that needs to consume data asynchronously, we’d either have to bundle the API and have to maintain it in our repositories as a dependency, or have clients install and maintain it on their own.&#8221;</p>\n<p>WordPress developer Nate Wright echoed that opinion and is eager to be able to extend it for use in his products, without having to include it as a plugin.</p>\n<p>&#8220;Put it in core, so that as a plugin developer I can make use of it in my products,&#8221; he <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/#comment-26367\" target=\"_blank\">said</a>. &#8220;I built the most popular Restaurant Reservations plugin in the .org repo, and I am eager to add a robust capacity/table management component for it using the REST API and a jQuery/Underscore/Backbone stack.&#8221;</p>\n<p>Early adopters have the unique opportunity to provide feedback on the REST API and help shape priorities for development. If you are using the API somewhere in the wild, make sure to <a href=\"https://make.wordpress.org/core/2015/07/23/rest-api-whos-using-this-thing/\" target=\"_blank\">leave your feedback on McCue&#8217;s post</a> to help the team make any necessary changes required before it&#8217;s merged into core.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 21:15:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: WPWeekly Episode 200 – The Big Two Oh Oh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=47083&preview_id=47083\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://wptavern.com/wpweekly-episode-200-the-big-two-oh-oh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3495:\"<p>In this special 200th episode of WordPress Weekly, I&#8217;m joined by <a href=\"http://marcuscouch.com/\">Marcus Couch</a>, <a href=\"http://strangework.com/\">Brad Williams</a>, <a href=\"http://www.ronalfy.com/\">Ronald Huereca</a>, and <a href=\"http://piratedunbar.com/\">Ptah Dunbar</a>. Brad, Ronald, and Ptah were among the first to support WordPress Weekly. They helped get the show off the ground and provided momentum.</p>\n<p>Seven years have passed since I started WordPress Weekly. In those seven years, each one of my guests have gone on to do great things with WordPress. We find out what they&#8217;re up to these days and recall memorable moments of the show. Near the beginning of the show, we held a moment of silence in Kim&#8217;s memory.</p>\n<p>I had a great time hosting episode 200, but I&#8217;m sad that the <a href=\"http://wptavern.com/kim-parsell-affectionately-known-as-wpmom-passes-away\">late Kim Parsell</a> couldn&#8217;t celebrate with us. When I started WordPress Weekly in 2008, Kim would often join me on each episode to provide a countdown before I pressed the record button.</p>\n<p>She was occasionally a <a href=\"http://wptavern.com/wpweekly-episode-87-%E2%80%93-the-lost-episode\">guest on the show</a>. After the show, she would stick around for a half hour to an hour to talk about whatever was on her mind. In many ways, the show offered her an opportunity to connect and speak to WordPress people every week. It was the closest thing to a meetup she could regularly attend.</p>\n<p>Thanks to everyone who listens to the show and provides us with valuable feedback. Join us next Wednesday, as we begin the journey to episode 300.</p>\n<h2>History of WordPress Weekly:</h2>\n<ul>\n<li>My first show on Talkshoe.com was 7 years ago on January 11th, 2008.</li>\n<li>WordPress 2.3.2 was released.</li>\n<li>WordPress 2.5 took the place of 2.4.</li>\n<li>Episode 100 was on June 5th 2010.</li>\n<li>I took a two year break after episode 117 October 28th, 2011.</li>\n<li>I resumed the show on August 16th 2013 which was also my last show on Talkshoe.</li>\n<li>Marcus became a co-host January 18th, 2014, on Episode 134.</li>\n</ul>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/flow-flow-social-streams/\">Flow-Flow Social Streams</a> lets you display your Facebook, Twitter, and Instagram messages in a responsive grid.</p>\n<p><a href=\"https://wordpress.org/plugins/test-gateway-for-woocommerce/\">Test Payment Module for Woocommerce</a> gives you the option to test payments in WooCommerce locally without using services such as Paypal or Authorize.net.</p>\n<p><a href=\"https://wordpress.org/plugins/easy-backup-by-supsystic/\">DropBox Backup by Supsystic</a> allows you to backup to Dropbox and FTP with one click. You can also restore full or partial backups from DropBox.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, July 29th 4 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #200:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 20:30:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: Philadelphia, PA to Host WordCamp US December 4th–6th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47068\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wptavern.com/philadelphia-pa-to-host-wordcamp-us-december-4th-6th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1943:\"<p>Matt Mullenweg <a href=\"http://ma.tt/2015/07/wcus-philadelphia/\">announced</a> that Philadelphia, PA, will host WordCamp US December 4th–6th at the <a href=\"http://www.paconvention.com/Pages/default.aspx\">Pennsylvania Convention</a> center. Philadelphia will also host WordCamp US in 2016, although no dates have been chosen yet.</p>\n<p>According to Mullenweg, &#8220;Having it the same place two years in a row allows us to keep logistics a set variable and really focus on the rest of the event in the second year.&#8221; The 2017 and 2018 host cities will be chosen in between the first and second event. This allows the team in the host city to volunteer and gain on-the-ground experience in Philadelphia.</p>\n<p>Out of six cities chosen to possibly host WordCamp US and 1,390 total voters, Tavern <a href=\"http://wptavern.com/which-one-of-these-six-cities-should-host-wordcamp-us\">readers voted</a> to have it in Phoenix, AZ, citing <a href=\"http://wptavern.com/which-one-of-these-six-cities-should-host-wordcamp-us#comment-70157\">its warm weather</a> during winter months. Philadelphia, home of the cheesesteak, was a close second.</p>\n<p>The event is inspired by WordCamp Europe, where organizers take an entire year to <a href=\"http://wptavern.com/vienna-austria-to-host-wordcamp-europe-2016\">plan and coordinate</a> the event. Some <a href=\"http://wptavern.com/which-one-of-these-six-cities-should-host-wordcamp-us#comment-70055\">readers questioned</a> whether the event would be held this year considering <a href=\"http://wptavern.com/wordcamp-us-2015-now-accepting-applications-for-host-city\">applications to be the host city </a>weren&#8217;t accepted until June.</p>\n<p>With only half a year to plan and organize WordCamp US, it will be interesting to see how the first one goes. Let us know if you plan on attending the event and if you&#8217;re going to bring ear muffs as Philadelphia during that time of year is cold.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 17:31:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Matt: WordCamp US to be in Philadelphia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45259\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://ma.tt/2015/07/wcus-philadelphia/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1188:\"<p><img class=\" wp-image-45261 alignright\" src=\"http://i1.wp.com/ma.tt/files/2015/07/wordcamp1-e1437663434378.png?resize=303%2C309\" alt=\"WordCamp US\" />There were <a href=\"http://ma.tt/2015/06/wordcamp-us-survey/\">amazing applications</a> for teams and cities to host the inaugural WordCamp US, a concept originally floated at <a href=\"http://wordpress.tv/2014/10/26/matt-mullenweg-the-state-of-the-word-2014/\">the State of the Word last year</a>. It was very hard to make a choice, but can now announce that the birthplace of the United States, <strong>Philadelphia, will host the first WCUS on December 4th&#8211;6th</strong>. They will also host it in 2016, but no dates have been chosen yet.</p>\n<p>Having it the same place two years in a row allows us to keep logistics a set variable and really focus on the rest of the event in the second year. I also want to use it to facilitate experience transfer: We&#8217;ll choose the 2017 + 2018 host city in between the first and second event, so that team can volunteer on the ground the second year Philadelphia hosts it to learn from their experience. Hat tip: Cool graphic by <a href=\"http://visualrhythm.com/\">Andrew Bergeron</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 16:38:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: WordPress 4.2.3 is a Critical Security Release, Fixes an XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=47045\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/wordpress-4-2-3-is-a-critical-security-release-fixes-an-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3025:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/security.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/security.jpg?resize=1024%2C514\" alt=\"photo credit: Lock - (license)\" class=\"size-full wp-image-40187\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/58441544@N00/2660230441\">Lock</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>\n<p>WordPress users in the Americas woke this morning to find update notices in their inboxes due to a critical security vulnerability. <a href=\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\" target=\"_blank\">WordPress 4.2.3</a> was released today and automatically pushed out to sites that have auto-updates enabled.</p>\n<p>Because this is a security release for all previous versions of WordPress, those who do not have automatic update enabled will need to manually update their sites immediately. Core contributor Gary Pendergast explained the severity of the bug in the release post:</p>\n<blockquote><p>WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was reported by <a href=\"https://profiles.wordpress.org/duck_\" target=\"_blank\">Jon Cave</a> and fixed by <a href=\"http://www.miqrogroove.com/\" target=\"_blank\">Robert Chapin</a>, both of the WordPress security team.</p>\n<p>We also fixed an issue where it was possible for a user with Subscriber permissions to create a draft through Quick Draft.</p></blockquote>\n<p>Pendergast thanked all parties reporting vulnerabilities for <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\" target=\"_blank\">responsibly disclosing them </a> to the WordPress security team.</p>\n<p>This release also contains fixes for 20 bugs from 4.2, including one that might require you to update your database before being allowed back into the admin.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/wp-update-db.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/wp-update-db.jpg?resize=773%2C370\" alt=\"wp-update-db\" class=\"aligncenter size-full wp-image-47047\" /></a></p>\n<p>Not all WordPress users who are updating will be greeted with this message, but if you see it, don&#8217;t panic. It&#8217;s related to one of the bug fixes included in the release.</p>\n<p>&#8220;It was a bug fix in 4.2.3, not backported &#8211; some versions of PHP didn&#8217;t run the utf8mb4 update correctly,&#8221; Pendergast said when asked about the required database update.</p>\n<p>Unfortunately, in some instances, clicking the &#8220;Update WordPress Database&#8221; button may require multiple attempts. This is unusual but Pendergast said that improving database upgrades is high on the team&#8217;s list of priorities.</p>\n<p>A list of all the files revised is available on the <a href=\"https://codex.wordpress.org/Version_4.2.3\" target=\"_blank\">4.2.3 release page</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 14:06:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: WordPress Custom Post Type UI Plugin Passes 1 Million Downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46940\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/wordpress-custom-post-type-ui-plugin-passes-1-million-downloads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5094:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/celebration.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/celebration.jpg?resize=960%2C482\" alt=\"photo credit: Stephanie McCabe\" class=\"size-full wp-image-47036\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/6V12NODFVM\">Stephanie McCabe</a>\n<p>In June of 2010, <a href=\"http://codex.wordpress.org/Version_3.0\" target=\"_blank\">WordPress 3.0</a> Thelonious was released with the historic merge of WordPress MU into core and the debut of the brand new Twenty Ten default theme. This pivotal release also gave developers the ability to register their own <a href=\"http://codex.wordpress.org/Custom_Post_Types\" target=\"_blank\">custom post types</a>. Expanding WordPress&#8217; custom content capabilities beyond simple posts and pages has been critical to the platform maintaining its dominance as <a href=\"http://w3techs.com/technologies/overview/content_management/all\" target=\"_blank\">the world&#8217;s most used CMS</a>.</p>\n<p>Thousands of WordPress developers make a living from products that are based on custom post types. Five years ago, when the feature was still new, you had to know how to write the code to register a new post type. That&#8217;s when the folks at <a href=\"http://webdevstudios.com/\" target=\"_blank\">WebDevStudios</a> released <a href=\"https://wordpress.org/plugins/custom-post-type-ui/\" target=\"_blank\">Custom Post Type UI</a>, a plugin that offers an admin interface for creating and managing post types and their associated taxonomies.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/cptui_post_type_editor.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/cptui_post_type_editor.png?resize=1024%2C604\" alt=\"cptui_post_type_editor\" class=\"aligncenter size-full wp-image-47028\" /></a></p>\n<p>The company counts more than <a href=\"https://profiles.wordpress.org/webdevstudios/#content-plugins\" target=\"_blank\">30 plugins</a> in its collection on WordPress.org, but Custom Post Type UI is by far the most successful. Last week it passed one million downloads and maintains a 4.6 out of 5-star average rating from users. The plugin is currently active on more than 200,000 WordPress sites.</p>\n<h3>Passing the 1 Million Downloads Milestone</h3>\n<p>Michael Beckwith, the current maintainer of Custom Post Type UI, published a <a href=\"http://webdevstudios.com/2015/07/17/the-custom-post-type-ui-million-download-celebration/\" target=\"_blank\">post</a> detailing the evolution of the plugin&#8217;s UI and codebase. His transparent account covers how the team overcame the challenges of their massive codebase overhaul and the undetected bugs that come crawling out of the woodwork with a major release.</p>\n<p>A plugin with a user base in the hundreds of thousands that manages to maintain a nearly 5-star average rating on WordPress.org is a notable achievement, especially when it involves weathering the UI and code updates required to keep pace with WordPress.</p>\n<p>&#8220;I believe this milestone represents the fact that making features usable and more user-friendly to the &#8216;average Joe&#8217; can take you a long ways,&#8221; Beckwith said. &#8220;Custom Post Type UI made it easier for more people to tap into the power and customization ability that custom post types and taxonomies offer to a WordPress powered website. Because of that ease of use, many have added it to their toolbox for every website they have or work on, and recommend it to their friends.&#8221;</p>\n<p>The plugin is being developed on <a href=\"https://github.com/WebDevStudios/custom-post-type-ui\" target=\"_blank\">GitHub</a>. Although there are many <a href=\"https://github.com/WebDevStudios/custom-post-type-ui/labels/enhancement\" target=\"_blank\">enhancements</a> under consideration, Beckwith said that no major changes are planned for the near future.</p>\n<p>&#8220;I would love more to get more people up-to-date on the current version and let it be the stable version for awhile,&#8221; he said.</p>\n<p>&#8220;Looking at our stats page, we still have reported active installs using as far back as version 0.6. While I can sit here scratching my head as to why, I also have to consider that that version is stable enough and still meeting the needs of 0.6% of our users.</p>\n<p>&#8220;If it is not breaking for them, and there is no security concerns, then it is not all bad that they are still marching on. There is also the minimum version requirement to keep in mind. There are still WordPress installs active and out in the wild that are not running WordPress 3.8 or higher. Until they are, those users are not going to be notified that there is even an update available,&#8221; he said.</p>\n<p>If you want to learn more about what it takes to maintain a popular plugin while successfully navigating the years of changes and support, check out WebDevStudios&#8217; <a href=\"http://webdevstudios.com/2015/07/17/the-custom-post-type-ui-million-download-celebration/\" target=\"_blank\">1 million downloads celebration post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 01:35:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WordPress 4.3 Moves Customize to Its Own Top-level Menu in the Admin Bar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46979\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/wordpress-4-3-moves-customize-to-its-own-top-level-menu-in-the-admin-bar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3156:\"<p>When menu management was <a href=\"http://wptavern.com/menu-customizer-officially-proposed-for-merge-into-wordpress-4-3\">proposed to be merged into WordPress 4.3</a>, a common complaint <a href=\"http://wptavern.com/menu-customizer-officially-proposed-for-merge-into-wordpress-4-3#comment-68988\">expressed by readers</a> was that clicking the Widgets menu item in the admin bar loads the customizer instead of the Widgets admin screen. WordPress 4.3 separates the management interfaces by moving the Customize link to the top-level menu of the admin bar. This link opens the customizer, allowing you to manage menus, appearance, and widgets through the customizer interface.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP42AdminBar.png\"><img class=\"wp-image-46995 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP42AdminBar.png?resize=429%2C232\" alt=\"WordPress 4.2 Admin Bar\" /></a>WordPress 4.2 Admin Bar\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP43AdminBar.png\"><img class=\"wp-image-46996 size-full\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/WP43AdminBar.png?resize=428%2C202\" alt=\"WP43AdminBar\" /></a>WordPress 4.3 Admin Bar\n<p>The Dashboard, Themes, Widgets, and Menus links take users to their corresponding admin pages in the backend of WordPress. This makes it clear which interface users are about to enter. The enhancement is a result of <a href=\"https://core.trac.wordpress.org/ticket/32678\">ticket #32678</a> where Helen Hou-Sandí and other WordPress core contributors discussed ways to improve the context of each link over the course of five weeks.</p>\n<p>Within the ticket, Nick Halsey, who has spent a lot of time on the customizer, explains that the approach taken in the ticket addresses short-term problems while setting the stage for future improvements.</p>\n<blockquote><p>The Customizer gets the visibility it deserves and becomes more conceptually separated from &#8216;Appearance&#8217;, the admin becomes significantly more accessible from the front-end, the often-unhelpful dashboard is de-emphasized, etc. We also have the ability to easily upgrade the Customize link to do a much faster/shinier loading of the Customizer in the future without moving it.</p>\n<p>Notably, the add-content and edit-content links remain separated from the admin menu (and we skip submenus there for simplicity), setting us up to be able to point them to a front-end-contextual content-creating/editing experience if we build that in the future, without moving links around. This minor rearrangement should be able to last several years without things moving around much if at all, even as further adjustments are made to the features they point to.</p></blockquote>\n<p>On the surface, it appears to be a simple change but a lot of time and effort went into it. It required several core contributors to discuss a variety of mockups, ideas, and flows before the team figured out a solution.</p>\n<p>Separating how users enter each interface will be a welcome enhancement to anyone who prefers one over the other to manage themes, widgets, and menus.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 23:28:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: How and When Mullenweg Learned Thesis Changed Back to a Proprietary License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46960\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"http://wptavern.com/how-and-when-mullenweg-learned-thesis-changed-back-to-a-proprietary-license\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5837:\"<p>We now know when Matt Mullenweg discovered Chris Pearson changed Thesis&#8217; license from split GPL to a proprietary one. On April 1st 2014, Siobhan McKeown <a href=\"http://archive.wordpress.org/interviews/2014_04_01_Mullenweg.html\">interviewed Matt Mullenweg</a> for the <a href=\"https://github.com/WordPress/book\">WordPress history book</a>.</p>\n<p>In the interview, we learn about the history of WordPress themes, the GPL, how Automattic unintentionally created the commercial theme market, why 200 themes were removed from the directory for sponsored links and much more.</p>\n<p>At the 30 minute mark, McKeown asks Mullenweg, at what point did he decide to go to the Software Freedom Law Center to receive clarification on if the default themes that ship with WordPress are derivatives? He responds:</p>\n<blockquote><p>I believe that was around our engagement with Mr. Pearson. I don&#8217;t know if it was before or after the Mixergy interview with our spirited online debate, but it was definitely around that time. I&#8217;m not a lawyer! I can read it and I can understand it from a logical point of view, but the Software Freedom Law Center is obviously the world experts in this and having them officially opine is the closest we can get to &#8211; it&#8217;s the next best thing to having a court case.</p>\n<p>I was actually very excited that perhaps Chris would actually go to court, because as you know there isn&#8217;t a ton of case law around the GPL and normally, because no one is stubborn enough to actually go to court over it, and I thought, &#8220;Oh, we finally got one!&#8221; And I was looking forward to being able to discuss in the U.S. law system and provide the precedent for anyone who comes after us to protect the GPL.</p>\n<p>Because companies like Cisco and LinkSys and huge companies with billions of dollars in resources have opted to not fight it, so you really do need someone who is going to be stubborn enough to fight it.</p></blockquote>\n<p>At the climax of the debate in 2010, <a href=\"http://ma.tt/2010/07/syn-thesis-1/#comment-481743\">some members</a> of the WordPress community wanted to see the argument go to court so a ruling could set a precedent on when a work becomes derivative.</p>\n<p>At the 33 minute mark, McKeown informs Mullenweg that Thesis switched from a split GPL license to a proprietary license. This is the first time since his debate with Pearson in 2010, that Mullenweg discovers Thesis switched back to a proprietary license. He responds:</p>\n<blockquote><p>I have not seen that. So we&#8217;d have to do a code analysis again. As you know the Software Freedom Law Center says that non-PHP, so non-linked code which can be CSS, images and JavaScript, isn&#8217;t required to be GPL. It doesn&#8217;t trigger the viral nature of WordPress&#8217; GPL code.</p>\n<p>The stance of the WordPress community was that a theme without images or CSS isn&#8217;t much of a theme so, even though something could be legally compliant, if the entire package isn&#8217;t providing the same freedoms for users it&#8217;s not something that we want to link to or promote. Because it doesn&#8217;t really follow the things that we hold dear and true in WordPress.</p></blockquote>\n<p>On January 15, 2014, <a href=\"http://www.pearsonified.com/2015/07/truth-about-thesis-com.php\">Chris Pearson received</a> a copy of Mullenweg&#8217;s inquiry into thesis.com from Larry of GetYourDomain.com. This is approximately four months prior to discovering Thesis was being sold under a proprietary license. However, the exact date in which Mullenweg obtained ownership of the domain is unknown.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/email-matt.png\"><img class=\"size-full wp-image-46845\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/email-matt.png?resize=486%2C191\" alt=\"Email shared by Pearson showing Mullenweg\'s interest in the domain\" /></a>Email shared by Pearson showing Mullenweg&#8217;s interest in the domain\n<p>The first <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">publicly known use of the domain</a> that confirmed Mullenweg&#8217;s ownership was on October 26th, 2014, at WordCamp San Francisco during the Question and Answer session.</p>\n<p>As the interview continues, McKeown asks Mullenweg if he reached out to companies like Template Monster that sells WordPress themes that are not GPL Licensed. He responds:</p>\n<blockquote><p>We got in touch with everyone that we could, and it was definitely &#8211; it was a lot of time. There are times when WordPress core stuff is more than a full-time job for me and now is definitely one of them.</p>\n<p>I see your link to a [inaudible]. There&#8217;s always ways to word licenses around multi-site support where perhaps the code is GPL but the developer chooses to not provide support for more than one site unless you buy a special license. So sometimes people interpret those to be a GPL violation when actually they&#8217;re not.</p>\n<p>I&#8217;m not aware of what Chris has done and I&#8217;d like to think that he is supportive &#8211; he has done so well from the WordPress community that he&#8217;d be supportive of themes continuing to be GPL, especially since his business didn&#8217;t crash like he was worried it would.</p></blockquote>\n<p>McKeown jokes that lawyers might have written Thesis&#8217; license agreement. Mullenweg responds, &#8220;Well, maybe we&#8217;ll dive back into it.&#8221; More than 14 months later, <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">Mullenweg has dived back into it with Pearson</a>.</p>\n<p>It&#8217;s unclear if in this second round of arguments, Mullenweg will take Pearson to court to settle the GPL derivative argument once and for all.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 23:21:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: Create and Manage BuddyPress Member Types with the BP Member Type Generator Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46893\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wptavern.com/create-and-manage-buddypress-member-types-with-the-bp-member-type-generator-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4810:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/different-users.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/09/different-users.jpg?resize=1024%2C492\" alt=\"photo credit: Dunechaser - cc\" class=\"size-full wp-image-30565\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/dunechaser/6042984689/\">Dunechaser</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p><a href=\"http://wptavern.com/buddypress-2-2-spumoni-released-featuring-new-member-type-api\" target=\"_blank\">BuddyPress 2.2</a> introduced a <a href=\"https://codex.buddypress.org/developer/member-types/\" target=\"_blank\">Member Type API</a>, which allows developers to register their own unique member types, i.e. teacher, student, coach, etc. This was an exciting addition to BuddyPress but not very accessible to non-technical community managers, since it requires writing your own plugin to utilize it.</p>\n<p><a href=\"https://wordpress.org/plugins/bp-member-type-generator/\" target=\"_blank\">BP Member Type Generator</a> is a new plugin from Brajesh Singh, prolific plugin author and owner of <a href=\"http://buddydev.com/\" target=\"_blank\">BuddyDev</a>. The plugin makes it easy for site administrators to create and manage member types in the admin &#8211; without having to write any code.</p>\n<p>A quick overview of its features includes:</p>\n<ul>\n<li>Create/Edit/Delete Member Types from WordPress admin</li>\n<li>Bulk assign member type to users from the users list screen</li>\n<li>A member type can be marked active/inactive from the edit member type page</li>\n<li>Compatible with multisite installations</li>\n</ul>\n<p>When creating a new member type, administrators have the option to enable a directory that will list all members from that type on one page.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/create-member-type.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/create-member-type.png?resize=968%2C725\" alt=\"create-member-type\" class=\"aligncenter size-full wp-image-46984\" /></a></p>\n<p>If you want to add the plugin and separate your members into different types, the task is not as overwhelming as it might sound. When you visit the user listing page in the admin, you can use the plugin&#8217;s bulk &#8220;change member type&#8221; dropdown to bulk assign users to a new member type. (This feature is also available in the Extended Profile section for each individual user in the admin.)</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/change-member-type.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/change-member-type.png?resize=737%2C440\" alt=\"change-member-type\" class=\"aligncenter size-full wp-image-46988\" /></a></p>\n<p>If you want to make the member types available for selection upon user registration, Singh created a free companion plugin called <a href=\"http://buddydev.com/buddypress/using-buddypress-member-type-as-profile-field-introducing-bp-xprofile-member-type-field-plugin/\" target=\"_blank\">BP Xprofile Member Type Field</a> that puts this on the frontend. If you want to restrict members from modifying their user type after registration, you can also add the free <a href=\"http://buddydev.com/plugins/bp-non-editable-profile-fields/\" target=\"_blank\">Non Editable Profile</a> field plugin.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/registration-member-type-field.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/registration-member-type-field.png?resize=490%2C337\" alt=\"registration-member-type-field\" class=\"aligncenter size-full wp-image-46992\" /></a></p>\n<p>Please note that BP Member Type Generator cannot detect and manage other member types that have previously been added via code in a plugin. This might create some confusion if you already have existing member types. However, if you&#8217;re just starting with setting up and organizing member types, or are willing to reorganize member types, the BP Member Type Generator offers an easy way to do it.</p>\n<p>This plugin is an important and much needed new tool that puts the creation of unique member types into the hands of BuddyPress community administrators, regardless of skill level. You can download <a href=\"https://wordpress.org/plugins/bp-member-type-generator/\" target=\"_blank\">BP Member Type Generator</a> for free from WordPress.org. Singh does not officially support his plugins via the WordPress forums, but users can provide feedback via the <a href=\"http://buddydev.com/buddypress/introducing-buddypress-member-type-generator/\" target=\"_blank\">BuddyDev blog</a> or get professional support on the <a href=\"http://buddydev.com/support/forums/\" target=\"_blank\">BuddyDev Premium Support Forums</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 21:51:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Joseph: Recommended Consultants\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://josephscott.org/?p=9888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://josephscott.org/archives/2015/07/recommended-consultants/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:277:\"<p>My personal list of WordPress consultants has dried up ( some took full time jobs, the rest are always booked solid ).  Now I&#8217;m directing people to the <a href=\"http://jkudish.com/recommendations/\">Recommended Consultants &amp; Resources list</a> from Joey Kudish.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 14:01:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Joseph Scott\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: Nick Haskins Receives Cease and Desist Letter for Violating LassoSoft Trademarks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46768\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"http://wptavern.com/nick-haskins-receives-cease-and-desist-letter-for-violating-lassosoft-trademarks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4619:\"<p><a href=\"http://nickhaskins.com/\">Nick Haskins</a>, the founder and lead developer of <a href=\"https://lasso.is/\">Lasso</a>, is <a href=\"https://lasso.is/the-ugly-truth-about-trademarks/\">rebranding the product</a> after being served a cease and desist letter.</p>\n<p>A few days ago, Haskins was served a cease and desist letter from <a href=\"http://lassosoft.com/\">LassoSoft</a>. According <a href=\"http://www.lassosoft.com/What-Is-Lasso\">to LassoSoft</a>, &#8220;Lasso is a development platform and is the easiest, quickest and most secure method of supporting custom, data-driven web sites on the market today.&#8221;</p>\n<p>Before launching a product, Haskins searches Google to see if similar products exist with the same name, &#8220;Apparently we didn’t look hard enough when naming Lasso,&#8221; he said.</p>\n<h2>Three Requirements That Must Be Met</h2>\n<p>Haskins <a href=\"http://cl.ly/39400J3A100k\">shared the letter</a> to educate others in the business of WordPress. In the letter, attorney&#8217;s for LassoSoft point out the company&#8217;s <a href=\"http://www.tmfile.com/mark/?q=861046116\">registered trademarks</a> and says it commenced using the mark in the US in 1998 and in Canada in 1997.</p>\n<p>LassoSoft claims to have documented at least one case of confusion between the two brands and says the continued use of Lasso will cause even more confusion.</p>\n<p>Attorney&#8217;s for LassoSoft provided three requirements that must be met for an amicable end to the dispute:</p>\n<ol>\n<li>Permanently ceasing all use of the term &#8220;Lasso&#8221; and any trademark which includes or incorporates the term &#8220;Lasso&#8221;, in connection with any software or related goods and services.</li>\n<li>Removing all references to the term &#8220;Lasso&#8221; from the Website.</li>\n<li>Removing all references to the term &#8220;Lasso&#8221; from any marketing materials including flyers, catalogs, etc.</li>\n</ol>\n<p>Haskins has until <strong>July 29th</strong> to satisfy the requirements and provide LassoSoft with written confirmation that he has permanently ceased all use of the term &#8220;Lasso&#8221; in association with software.</p>\n<h2>Transitioning Momentum</h2>\n<p>Rebranding a product that has momentum can be a crushing blow to a business that doesn&#8217;t manage the transition correctly. I asked Haskins how he plans to shift momentum from Lasso to the new brand name.</p>\n<p>&#8220;The first idea I had, was to let the community rename it, possibly even have a $500 prize to the winning name. By incentivizing a rebranding campaign, together with a concentrated effort on re-educating, along with URL redirects and custom messages, I feel pretty strongly that we&#8217;ll be able to move right along without skipping a beat,&#8221; he said.</p>\n<p>When it comes to naming a WordPress product and launching it into the WordPress ecosystem, Haskins offers the following advice:</p>\n<p>&#8220;Use Google to see if it already exists either in the WordPress ecosystem or in a related field. This may seem like a no-brainer and it&#8217;s really common sense, but for some reason, I either never searched or that company never popped up. At any rate, I think you&#8217;ll be in good shape by sticking to something with wp prefixed or appended to the name.&#8221;</p>\n<p>&#8220;Avoid generic terms and verbs because apparently, you can trademark a verb. I&#8217;d also run the search again in six months and if it&#8217;s a product that you plan on working on for a while, go through the process of getting the term trademarked.&#8221;</p>\n<p>In addition to Haskins&#8217; advice, I recommend using a search and discovery process provided by legal counsel familiar with trademark law.</p>\n<h2>Help Haskins Rebrand Lasso</h2>\n<p>In light of the battle between <a href=\"http://wptavern.com/mullenweg-and-pearson-square-off-on-patents-gpl-and-trademarks\">Chris Pearson and Matt Mullenweg</a> involving patents, GPL, and trademarks, Haskins decided to rebrand Lasso, &#8220;There are a lot more important things in life than the name of a plugin for WordPress,&#8221; he said.</p>\n<p>Haskins is giving the community an opportunity to rebrand his product. So far, he&#8217;s ruled out WP Front End Editor as it&#8217;s too similar to the <a href=\"https://wordpress.org/plugins/wp-front-end-editor/\">name of a feature plugin</a> that may one day be merged into WordPress core.</p>\n<p>If you have an idea on what to call Lasso, please leave a comment on this post. Sometime next week, Haskins will gather the suggestions and publish a poll where the community can vote on which one is best.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 01:08:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Matt: There is No Such Thing as a Split License\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45256\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"http://ma.tt/2015/07/licenses-going-dutch/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2845:\"<p>There&#8217;s a term that pops in the WordPress community, &#8220;split license&#8221;, that we should put to rest. It&#8217;s sloppy at best, misleading at worst.</p>\n<p>First, some background. WordPress is under a license called the GPL, which basically says you can do whatever you like with the software, but if you distribute changes or create derivative works they also need to be under the GPL. Think of it like a Creative Commons Sharealike license.</p>\n<p>In the past people weren&#8217;t sure if themes for WordPress were derivative works and needed to be GPL. <a href=\"https://wordpress.org/news/2009/07/themes-are-gpl-too/\">In 2009 we got an outside legal opinion that cleared up the matter</a> saying that the PHP in themes definitely had to be GPL, and for CSS and images it was optional. Basically everyone in the WP community went fully GPL, sometimes called 100% GPL, for all the files required to run their theme (PHP, JS, CSS, artwork). The predicted theme apocalypse and death of WordPress didn&#8217;t happen and in fact both theme shops and WordPress flourished, and best of all users had all the same freedoms from their themes as they got from WordPress. It was controversial at the time, but I think history has reflected well on the approach the WP community took.</p>\n<p>As I said the PHP has to be GPL, the other stuff can be something else &#8212; many people started to use the term &#8220;split license&#8221; or &#8220;split GPL&#8221; to describe this. The problem, especially with the latter, is it leaves out the most important information. &#8220;Split GPL&#8221; doesn&#8217;t say whether the theme is violating WordPress&#8217; license or not (maybe it&#8217;s proprietary PHP and GPL CSS), and more importantly doesn&#8217;t say what the non-GPL stuff is, which is the part you need to worry about! It also makes it sound like a split license is a thing, when all it really means is there are different licenses for different parts of the work. If something has a &#8220;split license&#8221; you have no idea what restrictions or freedoms it provides.</p>\n<p>If someone decides to have different licenses for different parts of a theme they ship in one package, it&#8217;s probably worth taking a few extra words to spell out what the rights and restrictions are, like &#8220;GPL PHP, and a restrictive proprietary license for all other elements included with the theme.&#8221; This is really important because if you&#8217;re a smart WordPress consumer you should avoid proprietary software, there is always a GPL alternative that <a href=\"http://www.gnu.org/philosophy/free-sw.en.html\">gives you the rights and freedoms you deserve</a>, and probably is from a nicer person who is more in line with the philosophy of the rest of WordPress. Vote with your pocketbook, buy GPL software!</p>\n<p>&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jul 2015 20:55:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: Shortcake Bakery Plugin Offers a Suite of Useful Shortcodes for WordPress Publishers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46896\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://wptavern.com/shortcake-bakery-plugin-offers-a-suite-of-useful-shortcodes-for-wordpress-publishers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4116:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/baker.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/baker.jpg?resize=1024%2C516\" alt=\"photo credit: Panettiere - (license)\" class=\"size-full wp-image-46899\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/27505428@N06/16282512996\">Panettiere</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p>In March, the <a href=\"http://wptavern.com/shortcake-is-now-a-wordpress-feature-plugin\" target=\"_blank\">Shortcake project officially began its journey as a feature plugin</a> with regular meetings for contributors working to make it ready to propose for inclusion in WordPress core. The <a href=\"https://wordpress.org/plugins/shortcode-ui/\" target=\"_blank\">plugin</a> provides a friendly UI for adding shortcodes and transforms them to render a nice preview in the visual editor.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/pullquote-shortcode.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/pullquote-shortcode.png?resize=1025%2C538\" alt=\"pullquote-shortcode\" class=\"aligncenter size-full wp-image-46904\" /></a></p>\n<p>Last week, <a href=\"https://twitter.com/danielbachhuber\" target=\"_blank\">Daniel Bachhuber</a> and the engineering team at <a href=\"http://fusion.net/\" target=\"_blank\">Fusion</a> released <a href=\"https://wordpress.org/plugins/shortcake-bakery/\" target=\"_blank\">Shortcake Bakery</a>, a plugin that extends the Shortcake project to supply a suite of handy shortcodes for publishers. The plugin currently includes the following:</p>\n<ul>\n<li>Image Comparison (powered by <a href=\"https://juxtapose.knightlab.com/\" target=\"_blank\">JuxtaposeJS</a>)</li>\n<li>Facebook embeds</li>\n<li>iFrames (require whitelisted hostnames)</li>\n<li>Infogram embeds</li>\n<li>PDF’s (powered by <a href=\"https://mozilla.github.io/pdf.js/\" target=\"_blank\">PDF.js</a>)</li>\n<li>Playbuzz embeds</li>\n<li>Rap Genius annotations</li>\n<li>Scribd embeds</li>\n<li>Scripts (require whitelisted hostnames)</li>\n</ul>\n<p>&#8220;We’ve been steadily making shortcodes for use by the Fusion newsroom since we launched Shortcake in November, and by releasing these universally useful patterns to the world, we hope to create a large repository of structured post elements for use by the WordPress community,&#8221; Bachhuber said.</p>\n<p>For example, Shortcake Bakery supplies a friendly UI for embedding an infographic from <a href=\"https://infogr.am/\" target=\"_blank\">Infogra.am</a>. The author selects the post element and then pastes in the URL to the infographic. It instantly appears in the post editor with a TinyMCE preview.</p>\n<p><a href=\"http://wptavern.com/wp-content/uploads/2015/07/shortcake-bakery-demo.mp4\">http://wptavern.com/wp-content/uploads/2015/07/shortcake-bakery-demo.mp4</a></p>\n<p>Shortcake Bakery also makes it easy to embed a single Facebook post, PDF, image comparison, and other content types that might otherwise prove troublesome to include in WordPress. Each content type is optimized for instant visual preview in the editor.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/shortcake-bakery-facebook-embed.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/07/shortcake-bakery-facebook-embed.png?resize=919%2C689\" alt=\"shortcake-bakery-facebook-embed\" class=\"aligncenter size-full wp-image-46917\" /></a></p>\n<p>Version 0.1.0 includes nine useful post elements that make it easy to embed content from external services commonly referenced by publishers. Shortcodes for Instagram, Tubmlr, and Silk are listed as possible upcoming enhancements on the project&#8217;s <a href=\"https://github.com/fusioneng/shortcake-bakery/labels/enhancement\" target=\"_blank\">GitHub issues queue</a>. <a href=\"https://wordpress.org/plugins/shortcake-bakery/\" target=\"_blank\">Shortcake Bakery</a> is an open source plugin and is now available on WordPress.org. It works best when combined with the <a href=\"https://wordpress.org/plugins/shortcode-ui/\" target=\"_blank\">Shortcake</a> plugin.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Jul 2015 02:16:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: WP Rocket Reports $355K in Annual Revenue After 2 Years in Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=46719\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"http://wptavern.com/wp-rocket-reports-355k-in-annual-revenue-after-2-years-in-business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4872:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/05/wp-rocket-feature.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/05/wp-rocket-feature.jpg?resize=1025%2C452\" alt=\"wp-rocket-feature\" class=\"aligncenter size-full wp-image-22199\" /></a></p>\n<p><a href=\"http://wp-rocket.me/\" target=\"_blank\">WP Rocket</a> is celebrating its second year in business. The commercial caching plugin for WordPress launched two years ago in the French market and <a href=\"http://blog.wp-rocket.me/2-years-reports-feedbacks/\" target=\"_blank\">opened its doors to international customers</a> last May.</p>\n<p>At that time, WP Rocket was entering unproven territory as the first major caching plugin to launch with a 100% commercial model. Could the plugin succeed in a market dominated by free caching solutions like <a href=\"https://wordpress.org/plugins/w3-total-cache/\" target=\"_blank\">W3 Total Cache</a> and <a href=\"https://wordpress.org/plugins/wp-super-cache/\" target=\"_blank\">WP Super Cache</a>?</p>\n<p>WP Rocket has the numbers to prove that WordPress users are willing to pay for an easy-to-configure solution to site optimization. In February, the 100% bootstrapped company published a transparency report showing that the product was now active on 15,000+ websites and <a href=\"http://wptavern.com/wp-rocket-grows-from-0-to-35k-in-monthly-revenue\" target=\"_blank\">averaging $35K in monthly revenue</a>. Six months later, the plugin is now active on more than 32,000 websites. From July 2014 &#8211; July 2015, WP Rocket <a href=\"http://blog.wp-rocket.me/2-years-reports-feedbacks/\" target=\"_blank\">reports</a> that the company pulled in a total of $351,097 in revenue.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/wprocket-2014-2015.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/07/wprocket-2014-2015.jpg?resize=629%2C525\" alt=\"photo credit: WP Rocket</a.\" /></a>photo credit: <a href=\"http://blog.wp-rocket.me/2-years-reports-feedbacks/\">WP Rocket</a>\n<p>WP Rocket has been successful in identifying ways to stand out among established competitors. During our <a href=\"http://wptavern.com/wp-rocket-launches-commercial-caching-plugin-for-wordpress\" target=\"_blank\">initial tests of the plugin</a>, we found that it took under a minute to configure caching for a small blogging site using its simple, basic settings panel. Without even touching the more advanced options, such as DNS prefetching and file exclusions, we were able to reduce the page size and load time by roughly 50%.</p>\n<p>Inspired by a recent three-month stay in San Francisco, WP Rocket developers and co-founders  Jonathan Buttigieg and Jean-Baptiste Marchand-Arvier are now working to diversify their product offerings.</p>\n<p>&#8220;WP Rocket will be one product among others from our startup and not the only one,&#8221; Marchand-Arvier said. &#8220;We want to have a portfolio of products and not depend on only one.&#8221;</p>\n<p>To that end, the company is dipping its toes into multiple potentially welcoming revenue streams, including plugins, themes, and SaaS.</p>\n<p>&#8220;For the past few months, Julio has been working on a security plugin,&#8221; Marchand-Arvier said. &#8220;This is going to be a great challenge for us as we experiment with a freemium model for the first time, and because there are great competitors in the space, like WordFence and iThemes Security.</p>\n<p>WP Rocket currently has a dedicated team working on <a href=\"https://imagify.io/\" target=\"_blank\">Imagify</a>, an image compression toolkit and their first SaaS venture. The company also plans to enter the theme market with its own shop.</p>\n<p>&#8220;We want to take on that huge challenge which will be very different compared to selling a plugin,&#8221; Marchand-Arvier said.</p>\n<p>WP Rocket&#8217;s founders believe that building a strong company culture will be one of the key factors to their continued success.</p>\n<p>&#8220;To work in a mostly remote team can create a lack of human connection,&#8221; Marchand-Arvier said. &#8220;That’s why we’ve decided to organize a ‘startup retreat’ every year.&#8221; This decision was inspired by the founders&#8217; 2014 trip to explore Silicon Valley, a pivotal event that changed the way they approached business in the WordPress ecosystem.</p>\n<p>&#8220;This [trip] transformed three guys who were selling a WordPress plugin into a Startup of eight people (today) with a strong company culture,&#8221; he said.</p>\n<p>If the success of WP Rocket&#8217;s caching plugin is any indication, WordPress users should be on the lookout for the company to bring a new twist into other existing product niches. Momentum is running high on their currently incubating projects with <a href=\"https://imagify.io/\" target=\"_blank\">Imagify</a> on track to launch in the upcoming weeks.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Jul 2015 20:33:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Streak Broken\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=45251\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://ma.tt/2015/07/streak-broken/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:689:\"<p>Due to some distractions and mishandling of scheduled posts on my part, I broke my blogging streak. I got up to 198 days, which isn&#8217;t bad, and I&#8217;m looking forward to beating it next time. A lot of people might not know this, but if you&#8217;re on <a href=\"http://wordpress.com/\">WordPress.com</a> or run <a href=\"http://jetpack.me/\">Jetpack</a> when you start a posting streak it will give you a notification high-five every day you continue it, this was the last one I got:</p>\n<p><img class=\"aligncenter  wp-image-45252\" src=\"http://i2.wp.com/ma.tt/files/2015/07/Screen-Shot-2015-07-18-at-9.06.19-AM.png?resize=386%2C394\" alt=\"Screen Shot 2015-07-18 at 9.06.19 AM\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Jul 2015 13:08:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 13 Aug 2015 21:42:20 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"276259\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Thu, 13 Aug 2015 21:30:16 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("151","current_theme","airconbasix","yes");
INSERT INTO wp_options VALUES("152","theme_mods_airconbasix","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:3;}}","yes");
INSERT INTO wp_options VALUES("153","theme_switched","","yes");
INSERT INTO wp_options VALUES("282","seedprod_maintenancemode_options","a:4:{s:19:\"comingsoon_bg_image\";s:76:\"http://moodsofafrica.com/develop/wp-content/uploads/2013/07/maintenance1.jpg\";s:19:\"comingsoon_headline\";s:25:\"Website under development\";s:3:\"msg\";s:112:\"<p style=\"text-align: center;\">Please contact <a href=\"http://edgewebdesign.com.au\">edgewebdesign.com.au</a></p>\";s:24:\"comingsoon_footer_credit\";s:1:\"0\";}","yes");
INSERT INTO wp_options VALUES("285","seedprod_maintenancemode_mshot_pass","TAOtzli64XeI","yes");
INSERT INTO wp_options VALUES("369","wpsupercache_start","1392000846","yes");
INSERT INTO wp_options VALUES("370","wpsupercache_count","0","yes");
INSERT INTO wp_options VALUES("463","supercache_stats","a:3:{s:9:\"generated\";i:1392704311;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:12:\"expired_list\";a:0:{}s:6:\"cached\";i:0;s:11:\"cached_list\";a:0:{}s:2:\"ts\";i:1392704311;}s:7:\"wpcache\";a:3:{s:6:\"cached\";i:0;s:7:\"expired\";i:0;s:5:\"fsize\";s:3:\"0KB\";}}","yes");
INSERT INTO wp_options VALUES("501","wp_login_logo_settings","a:3:{s:11:\"enable_logo\";s:2:\"no\";s:8:\"logo_url\";s:0:\"\";s:15:\"custom_bg_color\";s:0:\"\";}","yes");
INSERT INTO wp_options VALUES("505","clp_options","a:23:{s:7:\"version\";s:5:\"1.9.1\";s:4:\"logo\";s:88:\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/login-logo.png\";s:3:\"url\";s:47:\"http://comfortsolutions.com.au/airconditioning/\";s:5:\"title\";s:34:\"Web design by edgewebdesign.com.au\";s:10:\"logo_width\";s:3:\"239\";s:11:\"logo_height\";s:2:\"63\";s:8:\"h1_width\";s:0:\"\";s:9:\"h1_height\";s:0:\"\";s:9:\"h1_margin\";s:0:\"\";s:10:\"h1_padding\";s:0:\"\";s:9:\"h1_corner\";s:0:\"\";s:11:\"h1_shadow_x\";s:0:\"\";s:11:\"h1_shadow_y\";s:0:\"\";s:18:\"h1_shadow_softness\";s:0:\"\";s:15:\"h1_shadow_color\";s:0:\"\";s:15:\"body_background\";s:0:\"\";s:15:\"body_img_repeat\";s:0:\"\";s:12:\"body_img_pos\";s:0:\"\";s:14:\"body_bg_color1\";s:0:\"\";s:14:\"body_bg_color2\";s:0:\"\";s:12:\"body_bg_size\";s:0:\"\";s:9:\"multisite\";b:0;s:9:\"last_open\";s:8:\"logo_tab\";}","yes");
INSERT INTO wp_options VALUES("1451","db_upgraded","","yes");
INSERT INTO wp_options VALUES("11863","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1439502138;s:7:\"checked\";a:4:{s:11:\"airconbasix\";s:3:\"1.0\";s:14:\"twentyfourteen\";s:3:\"1.1\";s:14:\"twentythirteen\";s:3:\"1.2\";s:12:\"twentytwelve\";s:3:\"1.4\";}s:8:\"response\";a:3:{s:14:\"twentyfourteen\";a:4:{s:5:\"theme\";s:14:\"twentyfourteen\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentyfourteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentyfourteen.1.4.zip\";}s:14:\"twentythirteen\";a:4:{s:5:\"theme\";s:14:\"twentythirteen\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentythirteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentythirteen.1.5.zip\";}s:12:\"twentytwelve\";a:4:{s:5:\"theme\";s:12:\"twentytwelve\";s:11:\"new_version\";s:3:\"1.7\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwelve/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwelve.1.7.zip\";}}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("11864","can_compress_scripts","0","yes");
INSERT INTO wp_options VALUES("11860","_site_transient_timeout_browser_d222b6a854d35c9c9584e695b623c468","1440106935","yes");
INSERT INTO wp_options VALUES("11861","_site_transient_browser_d222b6a854d35c9c9584e695b623c468","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"44.0.2403.155\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("4859","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:25:\"info@edgewebdesign.com.au\";s:7:\"version\";s:5:\"3.9.8\";s:9:\"timestamp\";i:1439502135;}","yes");
INSERT INTO wp_options VALUES("11866","_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","1439545339","no");
INSERT INTO wp_options VALUES("11857","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:4:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.2.4.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.2.4.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.2.4-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.2.4-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.2.4\";s:7:\"version\";s:5:\"4.2.4\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.2.4.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.2.4.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.2.4-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.2.4-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.2.4\";s:7:\"version\";s:5:\"4.2.4\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";s:13:\"support_email\";s:26:\"updatehelp42@wordpress.org\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.1.7.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.1.7.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.1.7-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.1.7-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.1.7\";s:7:\"version\";s:5:\"4.1.7\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";s:13:\"support_email\";s:26:\"updatehelp42@wordpress.org\";}i:3;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.0.7.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.0.7.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.0.7-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.0.7-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.0.7\";s:7:\"version\";s:5:\"4.0.7\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";s:13:\"support_email\";s:26:\"updatehelp42@wordpress.org\";}}s:12:\"last_checked\";i:1439502133;s:15:\"version_checked\";s:5:\"3.9.8\";s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("11865","_site_transient_update_plugins","O:8:\"stdClass\":3:{s:12:\"last_checked\";i:1439502138;s:8:\"response\";a:3:{s:39:\"custom-login-page/custom-login-page.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"27656\";s:4:\"slug\";s:17:\"custom-login-page\";s:6:\"plugin\";s:39:\"custom-login-page/custom-login-page.php\";s:11:\"new_version\";s:5:\"2.5.4\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/custom-login-page/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/custom-login-page.2.5.4.zip\";s:14:\"upgrade_notice\";s:12:\"small bugfix\";}s:55:\"ultimate-maintenance-mode/ultimate-maintenance-mode.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"28904\";s:4:\"slug\";s:25:\"ultimate-maintenance-mode\";s:6:\"plugin\";s:55:\"ultimate-maintenance-mode/ultimate-maintenance-mode.php\";s:11:\"new_version\";s:5:\"1.6.2\";s:3:\"url\";s:56:\"https://wordpress.org/plugins/ultimate-maintenance-mode/\";s:7:\"package\";s:74:\"https://downloads.wordpress.org/plugin/ultimate-maintenance-mode.1.6.2.zip\";s:14:\"upgrade_notice\";s:24:\"Added Danish Translation\";}s:34:\"wp-clone-by-wp-academy/wpclone.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"37091\";s:4:\"slug\";s:22:\"wp-clone-by-wp-academy\";s:6:\"plugin\";s:34:\"wp-clone-by-wp-academy/wpclone.php\";s:11:\"new_version\";s:5:\"2.1.8\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/wp-clone-by-wp-academy/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/wp-clone-by-wp-academy.2.1.8.zip\";}}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("11867","_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 12:10:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://wordpress.org/?v=4.3-RC2-33612\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.4 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 12:10:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3827\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:397:\"WordPress 4.2.4 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. This release addresses six issues, including three cross-site scripting vulnerabilities and a potential SQL injection that could be used to compromise a site, which were discovered by Marc-Alexandre Montpas of Sucuri, Helen Hou-Sandí [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Samuel Sidler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2011:\"<p>WordPress 4.2.4 is now available. This is a<strong> security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>This release addresses six issues, including three cross-site scripting vulnerabilities and a potential SQL injection that could be used to compromise a site, which were discovered by <a href=\"https://sucuri.net/\">Marc-Alexandre Montpas</a> of Sucuri, <a href=\"http://helenhousandi.com/\">Helen Hou-Sandí</a> of the WordPress security team, <a href=\"http://www.checkpoint.com/\">Netanel Rubin</a> of Check Point, and <a href=\"https://hackerone.com/reactors08\">Ivan Grigorov</a>. It also includes a fix for a potential timing side-channel attack, discovered by <a href=\"http://www.scrutinizer-ci.com/\">Johannes Schmitt</a> of Scrutinizer, and prevents an attacker from locking a post from being edited, discovered by <a href=\"https://www.linkedin.com/in/symbiansymoh\">Mohamed A. Baset</a>.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.4 also fixes four bugs. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.4\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=33573&amp;stop_rev=33396\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.4</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.4.</p>\n<p><em>Already testing WordPress 4.3? The second release candidate is now available (<a href=\"https://wordpress.org/wordpress-4.3-RC2.zip\">zip</a>) and it contains these fixes. For more on 4.3, see <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/\">the RC 1 announcement post</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.3 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 23:50:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3817\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:340:\"The release candidate for WordPress 4.3 is now available. We&#8217;ve made more than 100 changes since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.3 on Tuesday, August 18, but we [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2256:\"<p>The release candidate for WordPress 4.3 is now available.</p>\n<p>We&#8217;ve made more than <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33512&amp;stop_rev=33372&amp;limit=120\">100 changes</a> since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.3 on <strong>Tuesday, August 18</strong>, but we need your help to get there.</p>\n<p>If you haven’t tested 4.3 yet, now is the time!</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you&#8217;ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.3 RC1, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.3-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.3 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.3 before next week. If you find compatibility problems, we never want to break things, so please be sure to post to the support forums so we can figure those out before the final release.</p>\n<p>Be sure to <a href=\"https://make.wordpress.org/core/\">follow along the core development blog</a>, where we&#8217;ll continue to post <a href=\"https://make.wordpress.org/core/tag/dev-notes+4-3/\">notes for developers</a> for 4.3.</p>\n<p><em>Drei Monate Arbeit</em><br />\n<em>Endlich das Ziel vor Augen</em><br />\n<em>Bald hab ich Urlaub!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.3 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2015/07/wordpress-4-2-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 11:21:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3807\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:380:\"WordPress 4.2.3 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was initially reported by Jon Cave and [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2708:\"<p>WordPress 4.2.3 is now available. This is a<strong> security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was initially reported by <a href=\"https://profiles.wordpress.org/duck_\">Jon Cave</a> and fixed by <a href=\"http://www.miqrogroove.com/\">Robert Chapin</a>, both of the WordPress security team, and later reported by <a href=\"http://klikki.fi/\">Jouko Pynnönen</a>.</p>\n<p>We also fixed an issue where it was possible for a user with Subscriber permissions to create a draft through Quick Draft. Reported by Netanel Rubin from <a href=\"https://www.checkpoint.com/\">Check Point Software Technologies</a>.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.3 also contains fixes for 20 bugs from 4.2. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.3\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=33382&amp;stop_rev=32430\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.3</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.3.</p>\n<p>Thanks to everyone who contributed to 4.2.3:</p>\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/gabrielperezs\">Gabriel Pérez</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Mike Adams</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, and <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-2-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 21:55:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3796\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.3 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2212:\"<p>WordPress 4.3 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\">Beta 3</a> blog posts. Some of the changes in Beta 4 include:</p>\n<ul>\n<li><span class=\"s1\">Fixed several bugs and broken flows in the </span><span class=\"s1\"><strong>publish box </strong></span><span class=\"s1\">in the edit screen.</span></li>\n<li>Addressed a number of edge cases for word count in the <strong>editor</strong>.</li>\n<li><span class=\"s1\"><strong>Site icons</strong> </span><span class=\"s1\">can now be previewed within the customizer. The feature has been removed from general settings.</span></li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33369&amp;stop_rev=33289\">more than 60 changes</a> in the last week.</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.3\">everything we’ve fixed</a>.</p>\n<p><em>Few Tickets Remain</em><br />\n<em>Edge Cases Disappearing</em><br />\n<em>You Must Test Today</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Jul 2015 21:49:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3787\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.3 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2529:\"<p>WordPress 4.3 Beta 3 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta3.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a> blog posts. Some of the changes in Beta 3 include:</p>\n<ul>\n<li>Performance improvements for <strong>Menus in the Customizer</strong>, as well as bug fixes and visual enhancements.</li>\n<li>Added <strong>Site Icon</strong> to the Customizer. The feature is now complete and requires lots of testing. Please help us ensure the site icon feature works well in both Settings and the Customizer.</li>\n<li>The improvements to <strong>Passwords</strong> have been added to the installation flow. When installing and setting up WordPress, a strong password will be suggested to site administrators. Please test and let us know if you encounter issues.</li>\n<li>Improved <strong>accessibility of comments and media list tables</strong>. If you use a screen reader, please let us know if you encounter any issues.</li>\n<li>Lots and lots of code documentation improvements.</li>\n<li><strong>Various other bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33286&amp;stop_rev=33141&amp;limit=150\">more than 140 changes</a> in the last week.</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.3\">everything we’ve fixed</a>.</p>\n<p><em>Want to test new things?</em><br />\n<em>Wonder how four three shapes up?</em><br />\n<em>Answer: beta three</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jul 2015 22:04:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3769\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.3 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2876:\"<p>WordPress 4.3 Beta 2 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta2.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">check out the Beta 1 blog post</a>. Some of the changes in Beta 2 include:</p>\n<ul>\n<li>Fixed an issue in beta 1 where an alert appeared when saving or publishing a new post/page for the first time.</li>\n<li><strong><strong>Customizer</strong></strong> improvements including enhanced accessibility, smoother menu creation and location assignment, and the ability to handle nameless menus. Please help us test menus in the Customizer to fix any remaining edge cases!</li>\n<li>More robust<strong> list tables</strong> with full content support on small screens and a fallback for the primary column for custom list tables. We&#8217;d love to know how these list tables, such as All Posts and Comments, work for you now on small screen devices.</li>\n<li>The <strong>Site Icon</strong> feature has been improved so that cropping is skipped if the image is the exact size (512px square) and the media modal now suggests a minimum icon size. Please let us know how the flow feels and if you encounter any glitches!</li>\n<li>The <strong>toolbar</strong> now has a direct link to the customizer, along with quick access to themes, widgets, and menus in the dashboard.</li>\n<li>We enabled <strong>utf8mb4 for MySQL</strong> extension users, which was previously unintentionally limited to MySQLi users. Please let us know if you run into any issues.</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33138&amp;stop_rev=33046\">almost 100 changes</a> in the last week.</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=4.3&amp;group=component&amp;order=priority\">everything we’ve fixed</a>.</p>\n<p><em>Edges polished up</em><br />\n<em>Features meliorated</em><br />\n<em>Beta Two: go test!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordCamps Update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/news/2015/07/wordcamps-update/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordcamps-update/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Jul 2015 16:13:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3758\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:311:\"Last week saw the halfway point for 2015, yay! This seems like a good time to update you on WordCamp happenings in the first half of this year. There have been 39 WordCamps in 2015 so far, with events organized in 17 different countries and on 5 continents. More than 14,000 people have registered for [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9419:\"<p>Last week saw the halfway point for 2015, yay! This seems like a good time to update you on WordCamp happenings in the first half of this year.</p>\n<p>There have been <a href=\"https://central.wordcamp.org/schedule/past-wordcamps/\">39 WordCamps in 2015</a> so far, with events organized in 17 different countries and on 5 continents. More than 14,000 people have registered for WordCamp tickets so far this year, isn&#8217;t that amazing?</p>\n<p><a href=\"https://europe.wordcamp.org/2015/\">WordCamp Europe</a> was held in Seville, Spain just a few weeks ago, with close to 1,000 registered participants and over 500 live stream participants. You can watch  <a href=\"http://wordpress.tv/2015/07/04/matt-mullenweg-keynote-qanda-wordcamp-europe-2015/\">Matt Mullenweg’s keynote Q&amp;A</a> session from WordCamp Europe right now on WordPress.tv.</p>\n<p>WordPress.tv has published 537 videos so far in 2015 from WordCamps around the world. Some of the more popular 2015 WordCamp talks on WordPress.tv include <a href=\"http://wordpress.tv/2015/03/13/tammie-lister-theme-dont-be-my-everything/\">Tammie Lister: Theme, Don’t Be My Everything </a>from WordCamp Maui, <a href=\"http://wordpress.tv/2015/04/17/jenny-munn-seo-for-2015-whats-in-whats-out-and-how-to-be-in-it-to-win-it-for-good/\">Jenny Munn: SEO for 2015 – What’s In, What’s Out and How to Be In It to Win It (For Good)</a> from WordCamp Atlanta, <a href=\"http://wordpress.tv/2015/02/27/fabrice-ducarme-les-constructeurs-de-page-pour-wordpress/\">Fabrice Ducarme: Les Constructeurs de Page pour WordPress</a> from WordCamp Paris, <a href=\"http://wordpress.tv/2015/06/02/ben-furfie-how-to-value-price-websites/\">Ben Furfie: How to Value Price Websites</a> from WordCamp London, and <a href=\"http://wordpress.tv/2015/06/09/morten-rand-hendriksen-building-themes-from-scratch-using-underscores-_s/\">Morten Rand-Hendriksen: Building Themes From Scratch Using Underscores (_S)</a> from WordCamp Seattle. Check them out!</p>\n<h3>Lots of great WordCamps are still to come</h3>\n<p><a href=\"http://ma.tt/2015/06/wordcamp-us-survey/\">WordCamp US</a> is currently in pre-planning, in the process of deciding on a host city. The following cities have proposed themselves as a great place to host the first WordCamp US: Chattanooga, Chicago, Detroit, Orlando, Philadelphia, and Phoenix. It&#8217;s possible the first WordCamp US will be held in 2016 so we can organize the best first WordCamp US imaginable.</p>\n<p>At this time, there are 28 <a href=\"https://central.wordcamp.org/schedule/\">WordCamps</a>, in 9 different countries, that have announced their dates for the rest of 2015. Twelve of these have tickets on sale:</p>\n<ul>\n<li><a href=\"https://columbus.wordcamp.org/2015/\">WordCamp Columbus</a>, Columbus, Ohio: July 17-18</li>\n<li><a href=\"https://scranton.wordcamp.org/2015/\">WordCamp Scranton</a>, Scranton, Pennsylvania: July 18</li>\n<li><a href=\"https://boston.wordcamp.org/2015/\">WordCamp Boston</a>, Boston, Massachussetts: July 18-19</li>\n<li><a href=\"https://milwaukee.wordcamp.org/2015/\">WordCamp Milwaukee</a>, Milwaukee, Wisconsin: July 24-26</li>\n<li><a href=\"https://asheville.wordcamp.org/2015/\">WordCamp Asheville</a>, Asheville, North Carolina: July 24-26</li>\n<li><a href=\"https://kansai.wordcamp.org/2015/\">WordCamp Kansai</a>, Kansai, Japan: July 25-26</li>\n<li><a href=\"https://fayetteville.wordcamp.org/2015/\">WordCamp Fayetteville</a>, Fayetteville, Arkansas: July 31-August 2</li>\n<li><a href=\"https://brighton.buddycamp.org/2015/\">BuddyCamp Brighton</a>,  Brighton, UK: August 8</li>\n<li><a href=\"https://vancouver.wordcamp.org/2015/\">WordCamp Vancouver, BC,</a> Vancouver, BC, Canada: August 15-16</li>\n<li><a href=\"https://russia.wordcamp.org/2015/\">WordCamp Russia</a>, Moscow, Russia: August 15</li>\n<li><a href=\"https://norrkoping.wordcamp.org/2015/\">WordCamp Norrköping</a>, Norrköping, Sweden: August 28-29</li>\n<li><a href=\"https://croatia.wordcamp.org/2015/\">WordCamp Croatia</a>, Rijeka, Croatia: September 5-6</li>\n<li><a href=\"https://krakow.wordcamp.org/2015/\">WordCamp Krakow,</a>  Krakow, Poland: September 12-13</li>\n<li><a href=\"https://nyc.wordcamp.org/2015/\">WordCamp NYC</a>, New York City, New York: October 30-November 1</li>\n</ul>\n<p>The other 16 events don’t have tickets on sale yet, but they’ve set their dates! Subscribe to the sites to find out when registration opens:</p>\n<ul>\n<li><a href=\"https://pune.wordcamp.org/2015/\">WordCamp Pune</a>, Pune, India: September 6</li>\n<li><a href=\"https://capetown.wordcamp.org/2015/\">WordCamp Cape Town</a>, Cape Town, South Africa: September 10-11</li>\n<li><a href=\"https://baltimore.wordcamp.org/2015/\">WordCamp Baltimore</a>, Baltimore, Maryland: September 12</li>\n<li><a href=\"https://slc.wordcamp.org/2015/\">WordCamp Salt Lake City</a>, Salt Lake City, Utah: September 12</li>\n<li><a href=\"https://lithuania.wordcamp.org/2015/\">WordCamp Lithuania</a>, Vilnius, Lithuania: September 19</li>\n<li><a href=\"https://vegas.wordcamp.org/2015\">WordCamp Vegas</a>, Las Vegas, Nevada: September 19-20</li>\n<li><a href=\"https://switzerland.wordcamp.org/2015/\">WordCamp Switzerland</a>, Zurich, Switzerland: September 19-20</li>\n<li><a href=\"https://tampa.wordcamp.org/2015/\">WordCamp Tampa</a>, Tampa, Florida: September 25-27</li>\n<li><a href=\"https://rhodeisland.wordcamp.org/2015/\">WordCamp Rhode Island</a>,  Providence, Rhode Island: September 25-26</li>\n<li><a href=\"https://la.wordcamp.org/2015/\">WordCamp Los Angeles</a>, Los Angeles, California: September 26-27</li>\n<li><a href=\"https://denmark.wordcamp.org/2015/\">WordCamp Denmark,</a>  Copenhagen, Denmark: October 3-4</li>\n<li><a href=\"https://toronto.wordcamp.org/2015\">WordCamp Toronto</a>, Toronto, Ontario, Canada: October 3-4</li>\n<li><a href=\"https://hamptonroads.wordcamp.org/2015/\">WordCamp Hampton Roads, </a>  Virginia Beach, VA, USA: October 17</li>\n<li><a href=\"https://annarbor.wordcamp.org/2015\">WordCamp Ann Arbor</a>, Ann Arbor, Michigan: October 24</li>\n<li><a href=\"https://portland.wordcamp.org/2015/\">WordCamp Portland</a>,  Portland, OR: October 24-25</li>\n</ul>\n<p>On top of all those exciting community events, there are 26 WordCamps in pre-planning as they look for the right event space.  If you have a great idea for a free or cheap WordCamp venue in any of the below locations, get in touch with the organizers through the WordCamp sites:</p>\n<ul>\n<li><a href=\"https://dfw.wordcamp.org/2015/\">WordCamp DFW</a>:  Dallas/Fort Worth, Texas</li>\n<li><a href=\"https://riodejaneiro.wordcamp.org/2015/\">WordCamp Rio</a>: Rio de Janeiro, Brazil</li>\n<li><a href=\"https://saratoga.wordcamp.org/2015/\">WordCamp Saratoga</a>:  Saratoga Springs, New York</li>\n<li><a href=\"https://sofia.wordcamp.org/2015\">WordCamp Sofia</a>:  Sofia, Bulgaria</li>\n<li><a href=\"https://austin.wordcamp.org/2015/\">WordCamp Austin</a>:  Austin, TX</li>\n<li><a href=\"https://ottawa.wordcamp.org/2015/\">WordCamp Ottawa</a>:  Ottawa, Canada</li>\n<li><a href=\"https://charleston.wordcamp.org/2015/\">WordCamp Charleston</a>:  Charleston, South Carolina</li>\n<li><a href=\"https://chicago.wordcamp.org/2015/\">WordCamp Chicago</a>:  Chicago, Illinois</li>\n<li><a href=\"https://albuquerque.wordcamp.org/2015/\">WordCamp Albuquerque</a>:  Albuquerque, New Mexico</li>\n<li><a href=\"https://prague.wordcamp.org/2015/\">WordCamp Prague</a>:  Prague, Czech Republic</li>\n<li><a href=\"https://seoul.wordcamp.org/2014/\">WordCamp Seoul: </a>Seoul, South Korea</li>\n<li><a href=\"https://louisville.wordcamp.org/2014/\">WordCamp Louisville</a>: Louisville, Kentucky</li>\n<li><a href=\"https://omaha.wordcamp.org/2015/\">WordCamp Omaha</a>:  Omaha, Nebraska</li>\n<li><a href=\"https://grandrapids.wordcamp.org/2015/\">WordCamp Grand Rapids</a>:  Grand Rapids, Michigan</li>\n<li><a href=\"https://easttroy.wordcamp.org/2015/\">WordCamp East Troy</a>:  East Troy, Wisconsin</li>\n<li><a href=\"https://palmademallorca.wordcamp.org/2015\">WordCamp Mallorca</a>: Palma de Mallorca, Spain</li>\n<li><a href=\"https://edinburgh.wordcamp.org/2015/\">WordCamp Edinburgh</a>:  Edinburgh, United Kingdom</li>\n<li><a href=\"https://orlando.wordcamp.org/2015/\">WordCamp Orlando</a>:  Orlando, Florida</li>\n<li><a href=\"https://mexico.wordcamp.org/2015/\">WordCamp Mexico City</a>:  Mexico City, Mexico</li>\n<li><a href=\"https://netherlands.wordcamp.org/2015/\">WordCamp Netherlands</a>:  Utrecht, Netherlands</li>\n<li><a href=\"https://phoenix.wordcamp.org/2016/\">WordCamp Phoenix</a>:  Phoenix, Arizona</li>\n<li><a href=\"https://saopaulo.wordcamp.org/2015/\">WordCamp São Paulo</a>:  São Paulo, Brazil</li>\n<li><a href=\"https://manchester.wordcamp.org/2015/\">WordCamp Manchester</a>:  Manchester, United Kingdom</li>\n<li><a href=\"https://tokyo.wordcamp.org/2015/\">WordCamp Tokyo</a>:  Tokyo, Japan</li>\n<li><a href=\"https://lima.wordcamp.org/2015/\">WordCamp Lima</a>:  Lima, Peru</li>\n<li><a href=\"https://seattle.wordcamp.org/2015-beginner/\">WordCamp Seattle: Beginner</a>: Seattle, WA</li>\n</ul>\n<p>Don’t see your city on the list, but yearning for a local WordCamp? WordCamps are organized by local volunteers from the WordPress community, and we have a whole team of people to support new organizers setting up a first-time WordCamp. If you want to bring WordCamp to town, check out how you can <a href=\"https://central.wordcamp.org/become-an-organizer/\">become a WordCamp organizer</a>!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/news/2015/07/wordcamps-update/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Jul 2015 01:30:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3738\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.3 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4352:\"<p>WordPress 4.3 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta1.zip\">download the beta here</a> (zip).</p>\n<p>4.3 is due out next month, but to get there, we need your help testing what we&#8217;ve been working on:</p>\n<ul>\n<li><strong>Menus</strong> can now be managed with the <strong>Customizer</strong>, which allows you to live preview changes you’re making without changing your site for visitors until you’re ready. We&#8217;re especially interested to know if this helps streamline the process of setting up your site (<a href=\"https://core.trac.wordpress.org/ticket/32576\">#32576</a>).</li>\n<li>Take control of another piece of your site with the <strong>Site Icon</strong> feature. You can now manage your site’s favicon and app icon from the admin area (<a href=\"https://core.trac.wordpress.org/ticket/16434\">#16434</a>).</li>\n<li>We put a lot of work into <strong>Better Passwords</strong> throughout WordPress. Now, WordPress will limit the life time of password resets, no longer send passwords via email, and generate and suggest secure passwords for you. Try it out and let us know what you think! (<a href=\"https://core.trac.wordpress.org/ticket/32589\">#32589</a>)</li>\n<li>We’ve also added <strong>Editor Improvements</strong>. Certain text patterns are automatically transformed as you type, including <code>*</code> and <code>-</code> transforming into unordered lists, <code>1.</code> and <code>1)</code> for ordered lists, <code>&gt;</code> for blockquotes and two to six number signs (<code>#</code>) for headings (<a href=\"https://core.trac.wordpress.org/ticket/31441\">#31441</a>).</li>\n<li>We’ve improved the <strong>list view</strong> across the admin dashboard. Now, when you view your posts and pages <strong>on small screen devices</strong>, columns are not truncated and can be toggled into view (<a href=\"https://core.trac.wordpress.org/ticket/32395\">#32395</a>).</li>\n</ul>\n<p><strong>Developers</strong>: There have been a few of changes for you to test as well, including:</p>\n<ul>\n<li><strong>Taxonomy Roadmap:</strong> Terms shared across multiple taxonomies will <a href=\"https://make.wordpress.org/core/2015/06/09/eliminating-shared-taxonomy-terms-in-wordpress-4-3/\">now be split</a> into separate terms on update to 4.3. Please let us know if you hit any snags (<a href=\"https://core.trac.wordpress.org/ticket/30261\">#30261</a>).</li>\n<li>Added <code>singular.php</code> to the template hierarchy as a fallback for <code>single.php</code> and <code>page.php</code>. (<a href=\"https://core.trac.wordpress.org/ticket/22314\">#22314</a>).</li>\n<li>The old Distraction Free Writing code was removed (<a href=\"https://core.trac.wordpress.org/ticket/30949\">#30949</a>).</li>\n<li>List tables now can (and often should) have a primary column defined. We’re working on a fallback for existing custom list tables but right now they likely have some breakage in the aforementioned responsive view (<a href=\"https://core.trac.wordpress.org/ticket/25408\">#25408</a>).</li>\n</ul>\n<p>If you want a more in-depth view of what changes have made it into 4.3, <a href=\"https://make.wordpress.org/core/tag/4-3/\">check out all 4.3-tagged posts</a> on the main development blog.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.3\">everything we’ve fixed</a> so far.</p>\n<p>Happy testing!</p>\n<p><em>Site icons for all</em><br />\n<em>Live preview menu changes</em><br />\n<em>Four three beta now</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.2 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/05/wordpress-4-2-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2015/05/wordpress-4-2-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 07 May 2015 02:24:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3718\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:355:\"WordPress 4.2.2 is now available. This is a critical security release for all previous versions and we strongly encourage you to update your sites immediately. Version 4.2.2 addresses two security issues: The Genericons icon font package, which is used in a number of popular themes and plugins, contained an HTML file vulnerable to a cross-site [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Samuel Sidler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3213:\"<p>WordPress 4.2.2 is now available. This is a <strong>critical security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>Version 4.2.2 addresses two security issues:</p>\n<ul>\n<li>The Genericons icon font package, which is used in a number of popular themes and plugins, contained an HTML file vulnerable to a cross-site scripting attack. All affected themes and plugins hosted on <a href=\"https://wordpress.org/\">WordPress.org</a> (including the Twenty Fifteen default theme) have been updated today by the WordPress security team to address this issue by removing this nonessential file. To help protect other Genericons usage, WordPress 4.2.2 proactively scans the wp-content directory for this HTML file and removes it. Reported by Robert Abela of <a href=\"http://netsparker.com\">Netsparker</a>.</li>\n<li>WordPress versions 4.2 and earlier are affected by a <a href=\"https://wordpress.org/news/2015/04/wordpress-4-2-1/\">critical cross-site scripting vulnerability</a>, which could enable anonymous users to compromise a site. WordPress 4.2.2 includes a comprehensive fix for this issue. Reported separately by Rice Adu and Tong Shi from Baidu[X-team].</li>\n</ul>\n<p>The release also includes hardening for a potential cross-site scripting vulnerability when using the visual editor. This issue was reported by Mahadev Subedi.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.2 also contains fixes for 13 bugs from 4.2. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.2\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=32418&amp;stop_rev=32324\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.2</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.2.</p>\n<p>Thanks to everyone who contributed to 4.2.2:</p>\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Mike Adams</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/taka2\">taka2</a>, and <a href=\"https://profiles.wordpress.org/willstedt\">willstedt</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/05/wordpress-4-2-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.2.1 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/04/wordpress-4-2-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2015/04/wordpress-4-2-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Apr 2015 18:34:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3706\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"WordPress 4.2.1 is now available. This is a critical security release for all previous versions and we strongly encourage you to update your sites immediately. A few hours ago, the WordPress team was made aware of a cross-site scripting vulnerability, which could enable commenters to compromise a site. The vulnerability was discovered by Jouko Pynnönen. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1010:\"<p>WordPress 4.2.1 is now available. This is a <strong>critical security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>A few hours ago, the WordPress team was made aware of a cross-site scripting vulnerability, which could enable commenters to compromise a site. The vulnerability was discovered by <a href=\"http://klikki.fi/\">Jouko Pynnönen</a>.</p>\n<p>WordPress 4.2.1 has begun to roll out as an automatic background update, for sites that <a href=\"https://wordpress.org/plugins/background-update-tester/\">support</a> those.</p>\n<p>For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=32311&amp;stop_rev=32300\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.1</a> or venture over to <strong>Dashboard → Updates</strong> and simply click &#8220;Update Now&#8221;.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/04/wordpress-4-2-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 13 Aug 2015 21:42:19 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:10:\"x-pingback\";s:37:\"https://wordpress.org/news/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Tue, 04 Aug 2015 12:10:40 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("11876","_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109","1439545342","no");
INSERT INTO wp_options VALUES("11877","_transient_feed_mod_b9388c83948825c1edaef0d856b7b109","1439502142","no");
INSERT INTO wp_options VALUES("11878","_transient_timeout_plugin_slugs","1439588543","no");
INSERT INTO wp_options VALUES("11879","_transient_plugin_slugs","a:6:{i:0;s:39:\"custom-login-page/custom-login-page.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:3;s:55:\"ultimate-maintenance-mode/ultimate-maintenance-mode.php\";i:4;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:5;s:27:\"wp-super-cache/wp-cache.php\";}","no");
INSERT INTO wp_options VALUES("11880","_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51","1439545343","no");
INSERT INTO wp_options VALUES("11881","_transient_dash_4077549d03da2e451c8b5f002294ff51","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\'>WordPress 4.2.4 Security and Maintenance Release</a> <span class=\"rss-date\">August 4, 2015</span><div class=\"rssSummary\">WordPress 4.2.4 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. This release addresses six issues, including three cross-site scripting vulnerabilities and a potential SQL injection that could be used to compromise a site, which were discovered by Marc-Alexandre Montpas of</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wptavern.com/decoupling-wordpress\' title=\'photo credit: Coupler: Immigration Museum – (license) This post was contributed by Emily Miller. A native Hoosier, Emily now lives in San Francisco, CA, and is a content specialist at hosting platform Pantheon. She enjoys exploring the great outdoors with her dog and researching the latest trends in open source. WordPress developers are getting serious about\'>WPTavern: A Look at Why Some Frontend Developers are Decoupling WordPress</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/wordpress-for-ios-version-5-4-adds-statistical-insights\' title=\'WordPress for iOS: Version 5.4 is available on the app store and includes a couple of new features. To compliment the improvements to stats in 5.3, 5.4 adds a new stats screen called insights. Insights is similar to the Right Now widget in the WordPress dashboard in that it displays a summary of key statistics for a site including, total number of published\'>WPTavern: WordPress for iOS: Version 5.4 Adds Statistical Insights</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/short-interview-with-nikolay-bachiyski-wordpress-security-czar\' title=\'While on stage at WordCamp Europe answering a question related to WordPress’ security track record, Matt Mullenweg named Nikolay Bachiyski as the first Security Czar for the WordPress project. I interviewed Bachiyski to learn why the role was created and what its purpose is. What are the responsibilities of your new role? My responsibilities are to coordinat\'>WPTavern: Short Interview With Nikolay Bachiyski WordPress’ Security Czar</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Popular Plugin:</span> <a href=\'https://wordpress.org/plugins/woocommerce/\' class=\'dashboard-news-plugin-link\'>WooCommerce - excelling eCommerce</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=woocommerce&amp;_wpnonce=4785b8421a&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'WooCommerce - excelling eCommerce\'>Install</a>)</span></li></ul></div>","no");
INSERT INTO wp_options VALUES("11882","_transient_timeout_feed_a41fbee65e190c85018f9081fcc3dfc4","1439545345","no");
INSERT INTO wp_options VALUES("11883","_transient_feed_a41fbee65e190c85018f9081fcc3dfc4","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress Training » News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://members.wpacademy.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 Jun 2015 19:24:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Up to 98% Savings on Courses: Web Design, Business Development, SEO, Mobile App Development, and More\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"http://members.wpacademy.com/2015/05/up-to-98-savings-on-courses-web-design-business-development-seo-mobile-app-development-and-more/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"http://members.wpacademy.com/2015/05/up-to-98-savings-on-courses-web-design-business-development-seo-mobile-app-development-and-more/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 20 May 2015 15:04:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=20083\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:662:\"<p>Great news!&#160; Through a privileged relationship we have with online course provider Edurila, we are able to offer you some of the best online courses in the world at up to 98% savings – to a maximum price of just $10 each.&#160; Offer Valid for next 1 week only, So Grab your Copies Now. Click [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2015/05/up-to-98-savings-on-courses-web-design-business-development-seo-mobile-app-development-and-more/\">Up to 98% Savings on Courses: Web Design, Business Development, SEO, Mobile App Development, and More</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4466:\"<p></p><p><em><strong>Great news!</strong></em>&#160; Through a privileged relationship we have with online course provider Edurila, we are able to offer you some of the best online courses in the world at up to 98% savings – to a maximum price of just $10 each.&#160; </p>\n<p><em><strong>Offer Valid for next 1 week </strong></em>only, So <em><strong>Grab your Copies Now.</strong></em></p>\n<p>Click On the Link below to Buy the Course for $10 Only or just use coupon “Marc10″ while checking out.</p>\n<ul>\n<li><strong>Complete Money Making Course Bundle – Learn Youtube Secrets, Blogging, Website Making, Affiliate Marketing, Facebook Advertisement Secrets &amp; More</strong> worth <del>$499</del>&#160; for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/money-making-courses?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Running A Web Design Business</strong> worth <del>$99</del> for <strong><em>$10 only</em></strong> – <a href=\"https://edurila.com/courses/running-a-web-design-business?&amp;coupon_code=MARC10\">Purchase here</a></li>\n<li><strong>Learn to Speak: Conversational French – Full Course</strong> worth <del>$99</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/learnfrench?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Responsive Web Design Course Bundle</strong> worth <del>$249</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/responsive-web-design-course-bundle?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Complete Web Developer Course: How To Build Websites &amp; Make Money</strong> worth <del>$299</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/practical-web-development?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Create a Native App for your WordPress Business Website in 8 days – No Coding!</strong> worth <del>$99</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/create-app-for-your-wordpress-website?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>How I Make Awesome Passive Income Every Month for Free!</strong> worth <del>$199</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/makemoneyonline?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Build Your Brand: Blogging, SEO, Social Media &amp; Relationships</strong> worth <del>$79</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/blogging-seo-social-relationships-total-web-marketing?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Responsive Web Design AND Web Development with HTML5 &amp; CSS3</strong> worth <del>$49</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/design-and-develop-a-killer-website-with-html5-and-css3?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>The Complete Apple Watch Developer Course – Build 15 apps</strong> worth <del>$299</del> for <em><strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/complete-apple-watch-developer-course-build-15-apps?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Photoshop: Real World Hands-on Graphic and Web Design</strong> worth <del>$99</del> for<em> <strong>$10 Only</strong></em> – <a href=\"https://edurila.com/courses/photoshop-real-world-hands-on-graphic-and-web-design?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n<li><strong>Youtube Secrets For Earning $2K Monthly Income – No Experience Required</strong> worth <del>$499</del> for <em><strong>$10 only</strong></em> – <a href=\"https://edurila.com/courses/youtube-secrets-for-earning-high-incomes?&amp;coupon_code=MARC10\">Purchase Here</a></li>\n</ul>\n<p><em><strong>Hurry Up! Grab these courses for just $10 before they get back to their full price again.</strong>      <br /></em></p>\n<p><em><strong>Share this offer</strong> on<strong> </strong>Twitter, Facebook and to your websites, And help your friends and family to learn a new skill from the Experts.</em></p>\n<p>The post <a href=\"http://members.wpacademy.com/2015/05/up-to-98-savings-on-courses-web-design-business-development-seo-mobile-app-development-and-more/\">Up to 98% Savings on Courses: Web Design, Business Development, SEO, Mobile App Development, and More</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"http://members.wpacademy.com/2015/05/up-to-98-savings-on-courses-web-design-business-development-seo-mobile-app-development-and-more/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Three steps towards a true lifestyle business (free training by Natalie Sisson)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"http://members.wpacademy.com/2015/04/three-steps-towards-a-true-lifestyle-business-free-training-by-natalie-sisson/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"http://members.wpacademy.com/2015/04/three-steps-towards-a-true-lifestyle-business-free-training-by-natalie-sisson/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Apr 2015 15:52:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=20059\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:659:\"<p>As some of you know, last summer I officially became a “digital nomad”.&#160;&#160; This means that I took WP Academy on the road, and have been traveling, learning, growing and making new friends.&#160; I even wrote a book!&#160; While continuing to invest and grow my business (in fact, a lot was accomplished last year, including [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2015/04/three-steps-towards-a-true-lifestyle-business-free-training-by-natalie-sisson/\">Three steps towards a true lifestyle business (free training by Natalie Sisson)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2287:\"<p></p><p>As some of you know, last summer I officially became a “digital nomad”.&#160;&#160; This means that I took WP Academy on the road, and have been traveling, learning, growing and making new friends.&#160; I even wrote a book!&#160; While continuing to invest and grow my business (in fact, a lot was accomplished last year, including big upgrades in our <a href=\"http://wpacademy.com/hosting\">Managed WordPress Hosting</a>).</p>\n<p>If this lifestyle interests you, you will be very interested to know that Natalie Sisson, the “Suitcase Entrepreneur”, has opened up her program again.&#160; Natalie is the original “digital nomad” (much more hard-core than me, actually), having built her perfect lifestyle business while traveling the world, earning 6-figures and going on crazy cool adventures.&#160; Get the details here of the FREE TRAINING she is giving leading up to the offer: </p>\n<p>=&gt;&gt; <a href=\"https://kk125.isrefer.com/go/TFP/mbeneteau\">3 Steps to Creating Your Freedom Plan</a> &lt;==</p>\n<p><em></em></p>\n<p>I have great respect for Natalie, based on her knowledge, professionalism and sincerity in what she does.&#160; Hundreds of “lifestyle entrepreneurs” have attended her programs already.&#160; I dare say that nobody teaches this as well as she does – even some programs that cost 3-4 times as much.&#160; And the support community is outstanding.&#160; </p>\n<p>TODAY she’s celebrating 5 years in business with a fantastic 3-part video training series teaching you the steps to do this yourself. She’s going to share:</p>\n<p><em></em></p>\n<ul>\n<li>\n<p>3 Steps to Creating Your Freedom Plan</p>\n</li>\n<li>\n<p>10 Must-Have Traits of Every Successful Lifestyle Entrepreneur</p>\n</li>\n<li>\n<p>The Proven Process to Making Your Ideal Lifestyle Business a Reality</p>\n</li>\n</ul>\n<p><em></em></p>\n<p>=&gt;&gt; <a href=\"https://kk125.isrefer.com/go/TFP/mbeneteau\">Create Your Perfect Lifestyle Business right here</a> &lt;&lt;=</p>\n<p>The post <a href=\"http://members.wpacademy.com/2015/04/three-steps-towards-a-true-lifestyle-business-free-training-by-natalie-sisson/\">Three steps towards a true lifestyle business (free training by Natalie Sisson)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"http://members.wpacademy.com/2015/04/three-steps-towards-a-true-lifestyle-business-free-training-by-natalie-sisson/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Managed WordPress Hosting from $8.40/mth\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"http://members.wpacademy.com/2015/02/managed-wordpress-hosting-from-8-40mth/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://members.wpacademy.com/2015/02/managed-wordpress-hosting-from-8-40mth/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Feb 2015 11:13:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=20017\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:615:\"<p>If you are interested in secure, high-performance Managed WordPress Hosting at 30% of the going rate, then read on.&#160; 2014 was a very difficult year for the hosting business Many large conventional hosting companies (Hostgator, Bluehost, Dreamhost) experienced long downtimes exceeding 12 hours last year, and we have seen large performance degradation as well, with [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2015/02/managed-wordpress-hosting-from-8-40mth/\">Managed WordPress Hosting from $8.40/mth</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4641:\"<p></p><p>If you are interested in secure, high-performance Managed WordPress Hosting at 30% of the going rate, then read on.&#160; </p>\n<h2>2014 was a very difficult year for the hosting business</h2>\n<p>Many large conventional hosting companies (Hostgator, Bluehost, Dreamhost) experienced long downtimes exceeding 12 hours last year, and we have seen large performance degradation as well, with page load times often exceeding 5 seconds.&#160; Many studies have shown the critical importance of page load time for visitor retention.&#160; Added to these facts are ongoing concerns about WordPress hacking&#160; on the non-managed WordPress hosting companies.&#160; <strong>As a result, many of us have been looking for hosting upgrades</strong>.</p>\n<p>Late last year we completed a major upgrade to high-performance (SSD-backed) servers.&#160; Our customers are seeing page load times of&#160; 0.1 to 0.2 seconds on their home page html (1 to 2 seconds for the entire site).&#160; This is backed by our personalized support, which covers many issues that conventional (non-managed) hosting companies won’t touch.&#160; Best of all, we can now offer this service for about a third of what most managed WordPress hosting companies charge.&#160; For the first time, you can have managed WordPress hosting at prices comparable to conventional hosting.&#160; </p>\n<p>This video shows you how.&#160; It will also show you how to use a tool called Pingdom to measure your current hosts’ performance (do the test yourself, it will only take a 1 minute): </p>\n<p><a href=\"http://wpacademy.com/hosting\"><img title=\"image\" style=\"border-top: 0px; border-right: 0px; background-image: none; border-bottom: 0px; padding-top: 0px; padding-left: 0px; border-left: 0px; display: inline; padding-right: 0px\" border=\"0\" alt=\"image\" src=\"http://members.wpacademy.com/wp-content/uploads/2015/02/image1.png\" width=\"244\" height=\"141\" /></a></p>\n<h2>How can we afford to do this? </h2>\n<p>How can we afford to do this, when most managed WordPress hosting companies charge upwards of $24/mth <u>per domain</u>? (WP Academy hosting offers unlimited domains, although only 5 managed sites).&#160; It’s simple really: rather than creating a complex (and expensive) hosting infrastructure, we manage your site’s security and performance using off-the-shelf components (cPanel, Backup Buddy, Cloudflare, W3 Total Cache, etc).&#160; And we invest the savings into renting lightly-loaded, SSD-backed servers, delivering enterprise-grade performance to your website at an amazing value.&#160; </p>\n<h2>February hosting sale – ends February 28</h2>\n<p>Throughout all of February, you can get 20% off our already very affordable managed hosting by using coupon FEBRUARY.&#160; The cost can be as low as $8.40/mth for a 3-year prepay.&#160; Simply go to this link: </p>\n<p><a href=\"http://wpacademy.com/hosting\">http://wpacademy.com/hosting</a></p>\n<p>Review the offer, and apply coupon FEBRUARY at checkout.&#160; </p>\n<p>If you have any questions or feedback, simply respond to this email.&#160; I am personally supporting this </p>\n<h2>Just a few client testimonials…</h2>\n<blockquote><p>“I have had Subrato helping me out with issues I have had on my site. This has resulted in the end of such frustration going on for too long.&#160; I am so grateful to you and your staff for being who you are and created this fantastic support for us all.” — Lucinda P., Ontario, Canada</p>\n</blockquote>\n<blockquote><p>“Excellent, prompt service. My website is fast and my issues are never server related. The support for simple theme and plugins is invaluable” — Melissa B., Stuart, Florida</p>\n</blockquote>\n<blockquote><p>“Marc, as you must know, you have been pivotal in helping me create my dream of website independence… Your family and support staff are the best” — Merry M., Liberty, Texas</p>\n</blockquote>\n<blockquote><p>“I want to thank you for your service hosting HeartAndSoulMatters.com. Creating my site was about as far as I could go and I’m confident that WP Academy will continue to do the maintenance that is beyond my technical savvy…” — Rev. Janice R.,&#160; Briarcliff Manor, New York</p>\n</blockquote>\n<p>Best wishes,</p>\n<p><img src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" /></p>\n<p>Marc Beneteau   <br />”Your Small-Biz Web Technology Mentor” </p>\n<p>The post <a href=\"http://members.wpacademy.com/2015/02/managed-wordpress-hosting-from-8-40mth/\">Managed WordPress Hosting from $8.40/mth</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://members.wpacademy.com/2015/02/managed-wordpress-hosting-from-8-40mth/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Learn Web Development and iOS Swift – 85% discount!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://members.wpacademy.com/2014/11/learn-web-development-and-ios-85-discount/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://members.wpacademy.com/2014/11/learn-web-development-and-ios-85-discount/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 29 Nov 2014 04:57:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19965\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:593:\"<p>Did you miss the Udemy Black Friday deals? Well cheer up, because it&#8217;s not too late for deep, deep discounts on two of the world&#8217;s most popular Web Development &#38; iOS Development courses! The Complete Web Developer Course – Just $29 (75k Copies Sold) Web development from scratch in 6 weeks. HTML, JS, CSS, PHP, [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/11/learn-web-development-and-ios-85-discount/\">Learn Web Development and iOS Swift &#8211; 85% discount!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5149:\"<p></p><p style=\"text-align: left;\">Did you miss the Udemy Black Friday deals?</p>\n<p style=\"text-align: left;\"><strong>Well cheer up</strong>, because it&#8217;s not too late for deep, deep discounts on two of the world&#8217;s most popular Web Development &amp; iOS Development courses!</p>\n<hr />\n<h2 style=\"text-align: left;\">The Complete Web Developer Course – Just $29 (75k Copies Sold)</h2>\n<p style=\"text-align: left;\"><strong><a href=\"https://www.udemy.com/complete-web-developer-course/\"><img class=\"alignright size-full wp-image-19966\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/11/complete-web-developer-rob-percival.jpg\" alt=\"complete-web-developer-rob-percival\" width=\"240\" height=\"135\" /></a>Web development from scratch in 6 weeks. HTML, JS, CSS, PHP, MySQL, Bootstrap, WordPress, APIs, Mobile Apps all covered.<br />\n</strong></p>\n<p style=\"text-align: left;\">The Most Popular &amp; Bestselling course “<strong>The Complete Web Developer Course – Build 14 Websites” from Rob Percival</strong> which has sold 43k copies in just 5 months is now available for<strong> 85% off</strong> i.e <strong>for $29 only</strong>! for next<strong> 2 week</strong>s!</p>\n<p style=\"text-align: left;\">Use<em> Coupon Code </em>“marc29“ while checking out at Udemy</p>\n<p style=\"text-align: left;\"><strong>Here is the link to take the course</strong>:- <a href=\"https://www.udemy.com/complete-web-developer-course/\" target=\"_blank\">https://www.udemy.com/<wbr />complete-web-developer-course/</a></p>\n<p style=\"text-align: left;\">This course comes with a<strong> Free 1 year hosting worth $199 </strong>and will teach you to make almost 14 websites.</p>\n<p style=\"text-align: left;\"><strong>This offer will be valid for next 2 weeks only</strong>, so Grab your copies Now before it goes back to full price of $199 <a href=\"https://www.udemy.com/complete-ios-developer-course/\">here</a></p>\n<hr />\n<h2 style=\"text-align: left;\">The Complete iOS Developer Course – Just $29 (30k Copies sold)<strong><br />\n</strong></h2>\n<p><strong><a href=\"https://www.udemy.com/complete-ios-developer-course/\"><img class=\"alignright size-full wp-image-19967\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/11/complete-ios-developer-course-rob-percival.jpg\" alt=\"complete-ios-developer-course-rob-percival\" width=\"240\" height=\"135\" /></a>iOS App Development from scratch in 6 weeks &#8211; build full apps including Instagram and Snapchat Clones. With free Ebook </strong></p>\n<p style=\"text-align: left;\">Get the Most Popular and Amazing<strong> The Complete iOS Developer Course – Build 15 Apps with Swift (No Mac Required!)</strong> for <strong>just $29 </strong>here<strong>:- </strong><a href=\"https://www.udemy.com/complete-web-developer-course/\">https://www.udemy.com/<wbr />complete-ios-developer-course/</a></p>\n<p style=\"text-align: left;\"><em>And Use coupon code</em>:<strong> “marc29″ </strong>while <a href=\"https://www.udemy.com/complete-ios-developer-course/\">checking-out at Udemy</a></p>\n<p style=\"text-align: left;\">Rob Percival asked me to tell you this:</p>\n<p style=\"text-align: left; padding-left: 30px;\"><em>Swift is Apple’s <strong>new language for making iPhone and iPad apps</strong>- it’s a hundred times easier to learn than Objective C, and is a lot like Javascript – great news for all you web developers!</em></p>\n<p style=\"text-align: left; padding-left: 30px;\"><em>Swift is still in beta, and for the first time ever Apple have allowed anyone to download the beta version of Xcode and try out Swift before it’s even released, so you’ll bec<strong>one of the very first people to learn</strong>how to code iOS apps with Swift.</em></p>\n<p style=\"text-align: left; padding-left: 30px;\"><em><strong>Swift is pretty much guaranteed to be the next big thing in app development</strong>, so learn it now and you’ll be at the forefront of the technology, putting you head and shoulders above other app developers.</em></p>\n<p style=\"text-align: left; padding-left: 30px;\"><em>As with the Complete Web Developer Course, I’ll show you absolutely everything you’ll need, including downloading and setting up Xcode, and how to <strong>build 14 fantastic apps with Swift</strong>. And you’ll get another year’s free hosting, so it really is a no-brainer!</em></p>\n<p style=\"text-align: left; padding-left: 30px;\"><em>I’ll also show you how to install OSX on your PC for free, so you <strong>don’t need a Mac to develop iOS apps</strong>!</em></p>\n<p style=\"text-align: left;\"> Happy Coding!</p>\n<p style=\"text-align: left;\">To your success,</p>\n<p style=\"text-align: left;\"><img class=\"alignnone size-full wp-image-19324\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /><br />\nMarc Beneteau<br />\n&#8220;Your Small-Biz Web Technology Mentor&#8221;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/11/learn-web-development-and-ios-85-discount/\">Learn Web Development and iOS Swift &#8211; 85% discount!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://members.wpacademy.com/2014/11/learn-web-development-and-ios-85-discount/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Three fantastic web development courses for up to 95% off!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://members.wpacademy.com/2014/11/three-web-development/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://members.wpacademy.com/2014/11/three-web-development/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Nov 2014 12:52:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19954\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:596:\"<p>Today we have for you, 3 great web development courses from our partners at Edurila.com, with up to 95% off the regular price! Get the bestselling WordPress Ecommerce, Swift Developer Bundle, and Beginner Web Development Bundle Course with discounts up to 95%.  Buy these courses from the links below: WordPress eCommerce with WooCommerce Sale Price [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/11/three-web-development/\">Three fantastic web development courses for up to 95% off!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4191:\"<p></p><p>Today we have for you, 3 great web development courses from our partners at Edurila.com, with up to 95% off the regular price!</p>\n<p>Get the bestselling <strong>WordPress Ecommerce, Swift Developer Bundle, and Beginner Web Development Bundle Course</strong> with discounts up to 95%.  Buy these courses from the links below:</p>\n<h2>WordPress eCommerce with WooCommerce</h2>\n<p>Sale Price – $10 (Normally $17)</p>\n<p>An online course that will give you an understanding of WooCommerce in under 90 minutes.</p>\n<p>Developed by Marc Beneteau, the course offers many professional made guides.</p>\n<p>It features:</p>\n<ul>\n<li><strong>Quick Start Section</strong> – Gives you a basic understanding of WooCommerce by introducing layouts, shortcodes, adding products, PayPal configuration, and more.</li>\n<li><strong>Reference Section</strong> – Advanced product types, configuring tax, coupons, inventory management, product reviews, and more.</li>\n<li><strong>WooCommerce Styling and Programming Section</strong> – creating custom email templates,</li>\n</ul>\n<p>The course normally retails at $17, but you can purchase it for only $10 using the link below. This course is also included in the web development bundle listed later.</p>\n<p><a href=\"https://edurila.com/course/wordpress-ecommerce-with-woocommerce/?couponCode=marc10&amp;affcode=518i\">Purchase here</a></p>\n<h2>Swift Developer Bundle</h2>\n<p>Sale Price – $19 (Normally $446)</p>\n<p>Swift Developer Bundle: Swift is the programming language developed by Apple. The language is used to create applications for their mobile operating system iOS and their desktop operating system OS X.</p>\n<p>The Swift Developer Bundle shows you how to create a fully functional calculator application that you can publish in the apple app store.</p>\n<p>The courses will teach you:</p>\n<ul>\n<li>Initial Setup and Swift Basics</li>\n<li>Operators, Strings, Characters, and Collection Types</li>\n<li>Evolving from Objective C</li>\n<li>Control Flow</li>\n</ul>\n<p>The courses included in the bundle are:</p>\n<ul>\n<li>Swift – Learn Apple’s New Programming Language by Examples (Original Price: $199)</li>\n<li>Hands on Swift Language. Visual way with Light Programming (Original Price: $49)</li>\n<li>Build Web Applications in HTML5 &amp; jQuery – Learn By Making 3 Web Apps (Original Price: $49)</li>\n<li>Make &amp; Publish Your Own iPhone Game Today &amp; Make Money Now (Original Price: $149)</li>\n</ul>\n<p>The bundle normally retails at $446, but you can purchase it for only $19 using the link below.</p>\n<p><a href=\"https://edurila.com/course/Swift-Developer-Bundle/?couponCode=marc19&amp;affcode=518i\">Purchase here</a></p>\n<h2>The Beginner Web Dev Bundle</h2>\n<p>Sale Price – $29 (Normally $638)</p>\n<p>The beginner web development bundle includes <em>nine complete courses!</em>  Each course is jam-packed with tutorials and video guides.</p>\n<p>The package includes the following courses:</p>\n<ul>\n<li>Learn Complete Web Development From Scratch (Original Price: $149)</li>\n<li>Learn Responsive Web Development from Scratch (Original Price: $99)</li>\n<li>Build Web Applications in HTML5 &amp; jQuery – Learn By Making 3 Web Apps (Original Price: $49)</li>\n<li>Make &amp; Publish Your Own iPhone Game Today &amp; Make Money Now (Original Price: $149)</li>\n<li>Become a WordPress Nirvana, WordPress Expert Bundle (Original Price: $99)</li>\n<li>WordPress eCommerce with WooCommerce (Original Price: $17)</li>\n<li>WordPress Theme Selection &amp; Customization (Original Price: $27)</li>\n<li>Basics Of Web Application Penetration Testing (FREE)</li>\n<li>WordPress Tutorial for Beginners (Original Price: $49)</li>\n<li>The bundle normally retails at $638, but you can purchase it for only $29 using the link below.</li>\n</ul>\n<p><a href=\"https://edurila.com/course/the-beginner-web-dev-bundle/?couponCode=Marc29&amp;affcode=518i\">Purchase here</a></p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/11/three-web-development/\">Three fantastic web development courses for up to 95% off!</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://members.wpacademy.com/2014/11/three-web-development/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Jeff Walker: Product launches for “newbies”…\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://members.wpacademy.com/2014/11/jeff-walker/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://members.wpacademy.com/2014/11/jeff-walker/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Nov 2014 15:25:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19932\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:571:\"<p>Have you heard of Jeff Walker?  He is an internet marketing legend, having helped thousands of entrepreneurs over the years generate $500 million in product launches (this is money for his clients, not for him!) Well, he has a new series of FREE training videos on what he calls the &#8220;Seed Launch&#8221;&#8230; and how anyone [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/11/jeff-walker/\">Jeff Walker: Product launches for &#8220;newbies&#8221;&#8230;</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1893:\"<p></p><p>Have you heard of Jeff Walker?  He is an internet marketing legend, having helped thousands of entrepreneurs over the years generate <strong>$500 million in product launches</strong> (this is money for his clients, not for him!)</p>\n<p>Well, he has a new series of FREE training videos on what he calls the &#8220;Seed Launch&#8221;&#8230; and how anyone can use it to create an new business from scratch &#8211; starting with NO list and NO product</p>\n<p><strong>&gt;&gt; <a href=\"http://www.productlaunchformula.com/?20059\">Get the videos here</a> &lt;&lt;</strong></p>\n<p>He also reveals how he used &#8220;Launch Stacking&#8221; to go from Mr. Mom (with $400 per year in disposable income) to his first $1,000,000 in sales &#8211; it&#8217;s a crazy story.</p>\n<p>And the amazing thing is this strategy will work with almost ANY type of business.</p>\n<p><strong>&gt;&gt; <a href=\"http://www.productlaunchformula.com/?20059\">Core Elements of the &#8220;No Fail&#8221; launch</a> &lt;&lt;</strong></p>\n<p>These videos are all pure content&#8230; the only &#8220;catch&#8221; is you need to opt-in to get them, but make sure you do &#8211; it&#8217;s totally worth it.</p>\n<p>Watch them soon &#8212; they are only good for the next 6 days.  And they only come out every 12-18 months&#8230; this is the latest and greatest of Jeff&#8217;s revolutionary business model.</p>\n<p>To Your Success,</p>\n<p>Marc Beneteau</p>\n<p><img class=\"alignnone size-full wp-image-19324\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /></p>\n<p>&#8220;Your Small-Biz Web Technology Mentor&#8221;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/11/jeff-walker/\">Jeff Walker: Product launches for &#8220;newbies&#8221;&#8230;</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://members.wpacademy.com/2014/11/jeff-walker/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Christine Kane Free Training: the New Class of Entrepreneur\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Sep 2014 05:50:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19898\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:660:\"<p>In case you missed Christine Kane&#8217;s live webinar last Thursday on the &#8220;new class of entrepreneur&#8221;, you can still get access to the excellent free training videos from here: Discover the success secrets of the &#8220;new class of entrepreneurs&#8221; &#60;&#8211; (After registering and confirming your email address, you will be directed to the landing page, [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/\">Christine Kane Free Training: the New Class of Entrepreneur</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4397:\"<p></p><p>In case you missed Christine Kane&#8217;s live webinar last Thursday on the &#8220;new class of entrepreneur&#8221;, you can still get access to the excellent free training videos from here:</p>\n<p><strong><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">Discover the success secrets of the &#8220;new class of entrepreneurs&#8221;</a> &lt;&#8211;</strong></p>\n<p><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\"><img class=\"alignright size-full wp-image-19899\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/09/7-new-laws-of-gravity.jpg\" alt=\"7-new-laws-of-gravity\" width=\"300\" height=\"403\" /></a>(After registering and confirming your email address, you will be directed to the landing page, and from there you can watch all the videos and also download the free report &#8220;7 New Laws of Gravity&#8221;).</p>\n<h3>But what defines a &#8220;new entrepreneur&#8221;?</h3>\n<p>Here is an extract from the third video (you can get the full video <a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">here</a>, including the interviews).  The &#8220;new entrepreneurs&#8221; are:</p>\n<p><em>First</em>, they are <em>relentlessly</em> self-aware</p>\n<p>They know themselves and how to manage their power</p>\n<p>They &#8220;right&#8221; their mindset when it&#8217;s needed</p>\n<p>They are no longer burdened by the emotional stories they tell themselves, and this removes struggle and it creates effortlessness in their work</p>\n<p><em>Second</em>, the new class of entrepreneurs are REAL.. they are a refreshing force field in their industries.</p>\n<p><em>Third</em>, they are IN.  they know how to be fully in relationshiop with their business, their money and their clients.  They use fear as a tool for expansion.  And they use their full presence as a powerful tool for breakthroughs that need to happen.</p>\n<p>And last, they are wildly successful.  They are pioneers.  They are &#8220;defying gravity&#8221;.</p>\n<p>mm&#8230; you are probably thinking:</p>\n<h3>Marc, I have heard this type of &#8220;woo-woo&#8221; talk before.  It doesn&#8217;t work.</h3>\n<p>Maybe.  Maybe you have heard things that sound &#8220;similar&#8221;.  But take it from me, this is the &#8220;real deal&#8221;.</p>\n<p>I have sent so many people to Christine Kane to create new passion businesses, or to double and triple existing businesses, I can&#8217;t tell you.  I suggest you put aside some time today and watch these videos:</p>\n<p><strong><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">Find out how some entrepreneurs are &#8220;Defying Gravity&#8221;</a> &lt;&#8211;</strong></p>\n<p>In fact, I met many of these entrepreneurs, graduates of WP Academy programs, at Christine&#8217;s live event in Atlanta last June.  All of the ones I spoke with found it beneficial, and most were utterly transformed.</p>\n<h3>And here is the best thing of all:</h3>\n<p>Christine is launching her new program, entitled &#8220;Becoming 360&#8243;, <strong>for about one-third of the price of her previous program</strong>s (about $500).  This is, in my humble opinion, the best small-business development training available anywhere, at any price.  <strong>Especially since it actually includes a free ticket to a live event happening in Asheville, NC, in February 2015</strong> (live event may be sold-out &#8212; you will need to check with her prior to registering, if this is important to you).</p>\n<p><strong><a href=\"https://christinekane.isrefer.com/go/b3602014/marc\">Get Access to the LIVESTREAM training on Tuesday Sept 30</a> &lt;&#8211;</strong></p>\n<p>PS: I want to hear your thoughts about this&#8230; just reply to this email if you have any questions. I stand 100% behind all the trainings and resources that I recommend.</p>\n<p>To Your Success,</p>\n<p><img class=\"alignnone size-full wp-image-19324\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau<br />\n&#8220;Your Small-Biz Web Technology Mentor&#8221;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/\">Christine Kane Free Training: the New Class of Entrepreneur</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://members.wpacademy.com/2014/09/christine-kane-free-training-the-new-class-of-entrepreneur/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Website Design Packages available again (very limited supply)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Sep 2014 09:21:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19872\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:626:\"<p>We are taking on 4 more website design packages in September.  Details here. A bit of background: our business is training you how to make and market your site, but some people like to fast-start the process, save time and avoid mistakes by having our instructors and virtual assistants provide direct one-on-one assistance and production [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/\">Website Design Packages available again (very limited supply)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1810:\"<p></p><p>We are taking on 4 more website design packages in September.  Details <a href=\"http://wpacademy.com/websites\">here</a>.</p>\n<p>A bit of background: our business is training you how to make and market your site, but some people like to fast-start the process, save time and avoid mistakes by having our instructors and virtual assistants provide direct one-on-one assistance and production services.  For this purpose we have created a very compellingly-priced optimal mix of on-shore marketing, design and copywriting services, and off-shore production assistance.  We don&#8217;t just make your site, we also give you advice on many topics that you are simply not going to get from your average web designer &#8212; let alone an offshore web designer.</p>\n<p><strong>&gt;&gt; <a href=\"http://wpacademy.com/websites\">View your options for Starter Website Packages Here</a> &lt;&lt;</strong></p>\n<p><em><strong>However, there is a catch</strong></em> &#8212; we only sell a very limited number of these per production cycle, so you will need to jump on this fast.  Schedule your appointment or purchase a package directly as soon as possible, if you wish to take advantage of this offer.</p>\n<p>Here are some of the sites we made in our last production run:</p>\n<p><img class=\"alignnone size-full wp-image-19873\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/09/websites-all.jpg\" alt=\"websites-all\" width=\"600\" height=\"577\" /></p>\n<p>Order yours <a href=\"http://wpacademy.com/websites\">here</a>.</p>\n<p>&nbsp;</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/\">Website Design Packages available again (very limited supply)</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://members.wpacademy.com/2014/09/website-design-packages-available-again-very-limited-supply/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"3 Reasons To Create A Lifestyle Business + Free Live Training with Natalie Sisson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Sep 2014 07:50:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19861\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:624:\"<p>Some of you already know this, but in July I moved to Thailand to run my business and study yoga. I am living a great personal and business adventure.  To the right is the view from my porch.  I won&#8217;t claim this as my &#8220;office&#8221; (I prefer A/C when working), but you get the idea. [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/\">3 Reasons To Create A Lifestyle Business + Free Live Training with Natalie Sisson</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5879:\"<p></p><p><strong><img class=\"alignright size-medium wp-image-19863\" src=\"http://members.wpacademy.com/wp-content/uploads/2014/09/porch2-300x225.jpg\" alt=\"porch2\" width=\"300\" height=\"225\" />Some of you already know this, but in July I moved to Thailand to run my business and study yoga</strong>. I am living a great personal and business adventure.  To the right is the view from my porch.  I won&#8217;t claim this as my &#8220;office&#8221; (I prefer A/C when working), but you get the idea.</p>\n<p>As such I know quite a bit about creating a &#8220;lifestyle business&#8221;.  But there is someone who knows even more than me.  Her name is Natalie Sisson (the &#8220;Suitcase entrepreneur&#8221;), and<strong> she is giving a free webinar on Thursday, Sept. 18 at 3pm EST.  You can register <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">here.</a></strong></p>\n<p>Here is what she has to say about it:</p>\n<p>There are three (big) reasons you should consider creating a “lifestyle business” &#8211; one that gives you major freedom, on your own terms and allows you to live how you want to live.</p>\n<p>1) <strong>You get to make your own hours</strong>. Maybe you like to work early, stay up late. Do half-days, break up your day, do yoga in the middle &#8211; whatever you choose.</p>\n<p>2) <strong>You get to decide where you work</strong> (some like it hot, some like it cold), and not ever be tied down to one location unless you choose it. Mountain climbing, surfing or fly fishing can absolutely be a part of your ideal day.</p>\n<p>3) <strong>When YOU are in control and are running your business</strong> (instead of your business running you), you will be happier, have greater freedom and be able to rekindle those dreams you may have pushed aside, making it all a reality.</p>\n<p>Lots of people think that to be a successful entrepreneur you need to treat your business as a &#8220;job&#8221;.  That’s the world we live in and we’re taught to just follow “the rules,” work our way up and out, slaving away and THIS will eventually equal happiness.</p>\n<p><strong>Not.</strong></p>\n<p>You can’t start a business, treat it like a job and expect yourself to have a ton of freedom and flexibility.  You ought to factor in your lifestyle aspirations, your needs and wants and preferences, your preferred working style and environment, your (realistic) income needs, etc.,  from the beginning.  And (of course) you need practical and actionable traffic-getting and income-generating strategies.   Otherwise&#8230; oye, it might be a tough slog.  If you can get to the end at all (most people who try don&#8217;t, I am one of the lucky ones).</p>\n<p>Entrepreneurship is growing more rapidly than any other profession on the planet. Technology has given us freedom and most people aren’t finding happiness in a job. They want more.</p>\n<p>Now, we can literally work anywhere in the world, doing whatever we darn well please.</p>\n<p><strong>But how do you do it?</strong> How do you make it really work and create real revenue and STILL have freedom?</p>\n<p>My friend and awesome entrepreneur brainchild Natalie Sisson, Founder of The Suitcase Entrepreneur, is hosting a really cool never-done-before training on <strong>“How to Uncover Your Fastest Path To Making Real Revenue, Creating a Business Working Anywhere in the World and Never Again Be Tied Down To A Boss”.</strong></p>\n<p><strong>&gt;&gt; <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">Register to the free training here</a> &lt;&lt;</strong></p>\n<p>Natalie is a #1 best-selling author, has grown a tribe of over 16,000 hungry Freedom Seekers on her blog, has a top Podcast on iTunes and gets paid to speak around the world on freedom + entrepreneurship.</p>\n<p>She’ll be giving us FIRST DIBS on on her behind-the-scenes tactics she’s used to be able to travel the world, meet all sorts of amazing people all while creating a six figure business.</p>\n<p><strong>In this exclusive live training, we’re going to be covering:</strong></p>\n<p>1) The #1 Mistake People Make When Designing a Business Online That Keeps Them Stuck, Under-earning and Tied Down</p>\n<p>2) How You Can Find Your &#8220;Sweet Spot&#8221;, Actually Get Paid To Do What You Love, Are Good At and Turn That Into A Real Business</p>\n<p>3) Natalie’s Unique Three-Stage Plan She’s Developed To Build Her Completely Location Independent 6-figure Business</p>\n<p>4) The FOUR Things It Really Takes to Be Free and Which of These is The Most Overlooked (Yet CRITICALLY Important) For Living Life On Your Own Terms</p>\n<p>5) How YOU Can Design, Create &amp; IMPLEMENT Your PERFECT Online Lifestyle Business In Eight Weeks Or Less!</p>\n<p>If you’re ready to become a Freedom Fighter in your own life, stand for something more, making real revenue, rekindle those childhood dreams of exploring the world and going on the next big adventure, then I invite you to join us!</p>\n<p><strong>&gt;&gt; <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">Click here to register and claim your free spot</a> &lt;&lt;</strong></p>\n<p>P.S. Oh, one last thing! Natalie is also going to be giving everyone who attends a really cool bonus. It’s a<strong> Freedom Formula Checklist</strong> &#8211; “Your First Steps To Designing Your Ultimate Lifestyle Business In Just Eight Weeks.” <a href=\"https://kk125.isrefer.com/go/freedomwebinar/mbeneteau%20\">Join us live now</a>!</p>\n<p><span style=\"font-size: 12pt; font-family: arial;\"><br />\n</span></p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/\">3 Reasons To Create A Lifestyle Business + Free Live Training with Natalie Sisson</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"http://members.wpacademy.com/2014/09/3-reasons-to-create-a-lifestyle-business-free-live-training-with-natalie-sisson/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"[LIVE] 4 simple ways to drive more sales and conversions. . .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Jul 2014 17:49:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://members.wpacademy.com/?p=19831\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:579:\"<p>If you’re looking to boost your sales before the end of the year. . . Or you believe your site should be generating significantly higher revenue than it is now. . . We just heard about an all-new live training that you need to see. This week, the lead generation experts at LeadPages are hosting [&#8230;]</p><p>The post <a href=\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/\">[LIVE] 4 simple ways to drive more sales and conversions. . .</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"marc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3002:\"<p></p><p>If you’re looking to boost your sales before the end of the year. . .</p>\n<p>Or you believe your site should be generating significantly higher revenue than it is now. . .</p>\n<p>We just heard about an all-new live training that you need to see.</p>\n<p>This week, the lead generation experts at LeadPages are hosting a new live training entitled: <i>“How to Transform Your Site into a Lead Generation Machine that Drives More Sales.”</i></p>\n<p>This live webinar is happening Thursday at 3 pm Eastern (12 noon Pacific).</p>\n<p><a href=\"https://my.leadpages.net/wl/jspencer/\">As a student in our course, you’re invited to attend.</a>&lt;&#8211;</p>\n<p>If you’re not familiar with LeadPages, this lead generation platform creates all the landing pages that you’ve seen on our website. (We can’t recommend LeadPages highly enough.)</p>\n<p>With over 20,000 customers just like us, LeadPages is constantly testing to discover which landing page designs and elements generate the most sales and conversions.</p>\n<p>Through all that research, LeadPages has discovered specific techniques that you can use to boost conversions and drive more sales.</p>\n<p>During Thursday’s live training, LeadPages Conversion Educator Tim Paige will reveal four of these simple techniques.</p>\n<p><a href=\"https://my.leadpages.net/wl/jspencer/\">Register for Thursday’s all-new live training right now. </a>&lt;&#8211;</p>\n<p>Inside Thursday’s live training, you’ll also discover. . .</p>\n<ul>\n<li>The 4 most critical, yet overlooked elements of your site (and how to tweak them to drive more sales).</li>\n</ul>\n<ul>\n<li>A simple, proven way to create the highest performing lead magnet you will likely ever use &#8212; that only takes 30 minutes to set up.</li>\n</ul>\n<ul>\n<li>3 unusual but simple ways to turn your Facebook fans into potential customers.</li>\n</ul>\n<p>There’s no telling when this live training will be available again.</p>\n<p>Again, if you’re interested in boosting your sales this year, we highly encourage you to join this all-new webinar on Thursday at 3 pm Eastern (12 noon Pacific).</p>\n<p><a href=\"https://my.leadpages.net/wl/jspencer/\">Don’t wait. Register for this live training right now. </a>&lt;&#8211;</p>\n<p>We’ll see you at Thursday’s live training.</p>\n<p>To Your Success,</p>\n<p><img class=\"alignnone wp-image-19324 size-full\" src=\"http://members.wpacademy.com/wp-content/uploads/2013/11/marc-small.jpg\" alt=\"marc-small.jpg\" width=\"150\" height=\"150\" /></p>\n<p>Marc Beneteau<br />\n<a href=\"http://www.wpacademy.com\">WP Academy</a></p>\n<p>P.S. Only 1,000 people can be on this webinar at any one time. We recommend you register now and show up early on Thursday to claim your spot.</p>\n<p>The post <a href=\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/\">[LIVE] 4 simple ways to drive more sales and conversions. . .</a> appeared first on <a href=\"http://members.wpacademy.com\">WordPress Training</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://members.wpacademy.com/2014/07/live-4-simple-ways-to-drive-more-sales-and-conversions/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:48:\"http://members.wpacademy.com/category/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:12:\"x-powered-by\";s:10:\"PHP/5.4.31\";s:10:\"set-cookie\";a:5:{i:0;s:55:\"wlmdebug=deleted; expires=Thu, 01-Jan-1970 00:00:01 GMT\";i:1;s:210:\"wc_session_cookie_d0fb3bf6a09f702cdfb97e4d2c564710=SQFMqjKV9tmmRmqiHQGFBEQJQ5JOnJV3%7C%7C1439674943%7C%7C1439671343%7C%7C9326e23f2b51302b48b94b17ec109fa0; expires=Sat, 15-Aug-2015 21:42:23 GMT; path=/; httponly\";i:2;s:74:\"woocommerce_items_in_cart=0; expires=Thu, 13-Aug-2015 20:42:25 GMT; path=/\";i:3;s:70:\"woocommerce_cart_hash=0; expires=Thu, 13-Aug-2015 20:42:25 GMT; path=/\";i:4;s:76:\"wfvt_1871270157=55cd0f4110c6d; expires=Thu, 13-Aug-2015 22:12:25 GMT; path=/\";}s:10:\"x-pingback\";s:39:\"http://members.wpacademy.com/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Wed, 17 Jun 2015 19:24:31 GMT\";s:4:\"etag\";s:34:\"\"c539439970ce6f66a1398767e268e816\"\";s:12:\"x-robots-tag\";s:14:\"noindex,follow\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"date\";s:29:\"Thu, 13 Aug 2015 21:42:25 GMT\";s:13:\"accept-ranges\";s:5:\"bytes\";s:6:\"server\";s:9:\"LiteSpeed\";s:10:\"connection\";s:5:\"close\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("11884","_transient_timeout_feed_mod_a41fbee65e190c85018f9081fcc3dfc4","1439545345","no");
INSERT INTO wp_options VALUES("11885","_transient_feed_mod_a41fbee65e190c85018f9081fcc3dfc4","1439502145","no");



DROP TABLE wp_postmeta;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=233 DEFAULT CHARSET=utf8;

INSERT INTO wp_postmeta VALUES("1","2","_wp_page_template","default");
INSERT INTO wp_postmeta VALUES("4","5","_wp_attached_file","2014/01/contactus-large.jpg");
INSERT INTO wp_postmeta VALUES("5","5","_wp_attachment_metadata","a:5:{s:5:\"width\";i:275;s:6:\"height\";i:413;s:4:\"file\";s:27:\"2014/01/contactus-large.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"contactus-large-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"contactus-large-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("8","7","_wp_attached_file","2014/01/contactus2_sml.png");
INSERT INTO wp_postmeta VALUES("9","7","_wp_attachment_metadata","a:5:{s:5:\"width\";i:125;s:6:\"height\";i:125;s:4:\"file\";s:26:\"2014/01/contactus2_sml.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("216","211","_wp_attached_file","2014/01/about2.jpg");
INSERT INTO wp_postmeta VALUES("217","211","_wp_attachment_metadata","a:5:{s:5:\"width\";i:220;s:6:\"height\";i:674;s:4:\"file\";s:18:\"2014/01/about2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"about2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"about2-97x300.jpg\";s:5:\"width\";i:97;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("202","143","_wp_attached_file","2014/02/blog1.jpg");
INSERT INTO wp_postmeta VALUES("203","143","_wp_attachment_metadata","a:5:{s:5:\"width\";i:400;s:6:\"height\";i:266;s:4:\"file\";s:17:\"2014/02/blog1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"blog1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"blog1-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("212","206","_wp_attached_file","2014/01/Logo.png");
INSERT INTO wp_postmeta VALUES("213","206","_wp_attachment_metadata","a:5:{s:5:\"width\";i:375;s:6:\"height\";i:99;s:4:\"file\";s:16:\"2014/01/Logo.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"Logo-150x99.png\";s:5:\"width\";i:150;s:6:\"height\";i:99;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"Logo-300x79.png\";s:5:\"width\";i:300;s:6:\"height\";i:79;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("16","11","_wp_attached_file","2014/01/contactus.jpg");
INSERT INTO wp_postmeta VALUES("17","11","_wp_attachment_metadata","a:5:{s:5:\"width\";i:247;s:6:\"height\";i:371;s:4:\"file\";s:21:\"2014/01/contactus.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"contactus-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"contactus-199x300.jpg\";s:5:\"width\";i:199;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("18","12","_theme_show_in_menu","1");
INSERT INTO wp_postmeta VALUES("19","12","_theme_show_as_separator","0");
INSERT INTO wp_postmeta VALUES("20","12","_theme_title_in_menu","Home");
INSERT INTO wp_postmeta VALUES("21","12","_theme_show_page_title","0");
INSERT INTO wp_postmeta VALUES("22","12","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("23","12","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("24","12","_theme_header_image_with_flash","0");
INSERT INTO wp_postmeta VALUES("25","12","theme_head","<style>.edg-content .post-12 .layout-item-0 {  border-collapse: separate;  }\r\n.edg-content .post-12 .layout-item-1 { border-right-style:solid;border-right-width:0px;border-right-color:#D9D9D9; padding-right: 0px;padding-left: 0px;  }\r\n.edg-content .post-12 .layout-item-2 { margin-bottom: 7px;  }\r\n.edg-content .post-12 .layout-item-3 { border-right-style:solid;border-right-width:0px;border-right-color:#D9D9D9; color: #002E4D; background: #1AA3FF; padding-top: 0px;padding-right: 6px;padding-bottom: 5px;padding-left: 6px; border-radius: 15px;  }\r\n.edg-content .post-12 .layout-item-4 { margin-right: 10px;margin-left: 10px;  }\r\n.edg-content .post-12 .layout-item-5 { border-spacing: 10px 0px; border-collapse: separate;  }\r\n.edg-content .post-12 .layout-item-6 { border-right-style:solid;border-right-width:0px;border-right-color:#D9D9D9; color: #003152; background: #F7F7F7 url(\'http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/2dd6c.png\') scroll; padding-right: 6px;padding-left: 6px;  }\r\n.edg-content .post-12 .layout-item-7 { border-right-style:solid;border-right-width:0px;border-right-color:#D9D9D9; color: #003152; background: #F7F7F7 url(\'http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/8b180.png\') scroll; padding-right: 0px;padding-left: 0px;  }\r\n.edg-content .post-12 .layout-item-8 { border-right-style:solid;border-right-width:0px;border-right-color:#D9D9D9; color: #003152; background: #F7F7F7 url(\'http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0171.png\') scroll; padding-right: 6px;padding-left: 6px;  }\r\n.edg-content .post-12 .layout-item-9 { margin-top: 0px;margin-bottom: 0px;  }\r\n.edg-content .post-12 .layout-item-10 { border-bottom-style:Dotted;border-bottom-width:0px;border-bottom-color:#D9D9D9;  }\r\n.edg-content .post-12 .layout-item-11 { margin-top: 2px;  }\r\n.edg-content .post-12 .layout-item-12 { border-right-style:solid;border-right-width:1px;border-right-color:#D9D9D9; padding-right: 5px;padding-left: 5px;  }\r\n.edg-content .post-12 .layout-item-13 { padding-right: 10px;padding-left: 10px;  }\r\n.ie7 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\r\n.ie6 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\r\n\r\n</style>");
INSERT INTO wp_postmeta VALUES("26","12","page_title","Home");
INSERT INTO wp_postmeta VALUES("27","12","use_wpautop","false");
INSERT INTO wp_postmeta VALUES("28","13","_theme_show_in_menu","1");
INSERT INTO wp_postmeta VALUES("29","13","_theme_show_as_separator","0");
INSERT INTO wp_postmeta VALUES("30","13","_theme_title_in_menu","About Us");
INSERT INTO wp_postmeta VALUES("31","13","_theme_show_page_title","1");
INSERT INTO wp_postmeta VALUES("32","13","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("33","13","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("34","13","_theme_header_image_with_flash","0");
INSERT INTO wp_postmeta VALUES("35","13","page_title","About Us");
INSERT INTO wp_postmeta VALUES("36","13","use_wpautop","false");
INSERT INTO wp_postmeta VALUES("37","14","_theme_show_in_menu","1");
INSERT INTO wp_postmeta VALUES("38","14","_theme_show_as_separator","0");
INSERT INTO wp_postmeta VALUES("39","14","_theme_title_in_menu","Services");
INSERT INTO wp_postmeta VALUES("40","14","_theme_show_page_title","1");
INSERT INTO wp_postmeta VALUES("41","14","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("42","14","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("43","14","_theme_header_image_with_flash","0");
INSERT INTO wp_postmeta VALUES("44","14","page_title","Services");
INSERT INTO wp_postmeta VALUES("45","14","use_wpautop","false");
INSERT INTO wp_postmeta VALUES("46","15","_theme_show_in_menu","1");
INSERT INTO wp_postmeta VALUES("47","15","_theme_show_as_separator","0");
INSERT INTO wp_postmeta VALUES("48","15","_theme_title_in_menu","Contact Us");
INSERT INTO wp_postmeta VALUES("49","15","_theme_show_page_title","1");
INSERT INTO wp_postmeta VALUES("50","15","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("51","15","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("52","15","_theme_header_image_with_flash","0");
INSERT INTO wp_postmeta VALUES("53","15","theme_head","<style>.edg-content .post-15 .layout-item-0 { padding-left: 5px;  }\r\n.edg-content .post-15 .layout-item-1 { padding: 5px;  }\r\n.ie7 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\r\n.ie6 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\r\n\r\n</style>");
INSERT INTO wp_postmeta VALUES("54","15","page_title","Contact Us");
INSERT INTO wp_postmeta VALUES("55","15","use_wpautop","false");
INSERT INTO wp_postmeta VALUES("56","16","_theme_show_in_menu","1");
INSERT INTO wp_postmeta VALUES("57","16","_theme_show_as_separator","0");
INSERT INTO wp_postmeta VALUES("58","16","_theme_title_in_menu","Blog");
INSERT INTO wp_postmeta VALUES("59","16","_theme_show_page_title","1");
INSERT INTO wp_postmeta VALUES("60","16","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("61","16","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("62","16","_theme_header_image_with_flash","1");
INSERT INTO wp_postmeta VALUES("63","16","theme_head","<style>.edg-content .post-16 .layout-item-0 { padding-right: 10px;padding-left: 10px;  }\n.ie7 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\n.ie6 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }.edg-content .post-16 .layout-item-0 { padding-right: 10px;padding-left: 10px;  }\n.ie7 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\n.ie6 .edg-post .edg-layout-cell {border:none !important; padding:0 !important; }\n\n</style>");
INSERT INTO wp_postmeta VALUES("64","16","page_title","Blog Page");
INSERT INTO wp_postmeta VALUES("65","16","use_wpautop","false");
INSERT INTO wp_postmeta VALUES("66","17","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("67","17","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("68","17","_menu_item_object_id","12");
INSERT INTO wp_postmeta VALUES("69","17","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("70","17","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("71","17","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("72","17","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("73","17","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("74","18","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("75","18","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("76","18","_menu_item_object_id","13");
INSERT INTO wp_postmeta VALUES("77","18","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("78","18","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("79","18","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("80","18","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("81","18","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("82","19","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("83","19","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("84","19","_menu_item_object_id","14");
INSERT INTO wp_postmeta VALUES("85","19","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("86","19","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("87","19","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("88","19","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("89","19","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("90","20","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("91","20","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("92","20","_menu_item_object_id","15");
INSERT INTO wp_postmeta VALUES("93","20","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("94","20","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("95","20","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("96","20","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("97","20","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("98","21","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("99","21","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("100","21","_menu_item_object_id","16");
INSERT INTO wp_postmeta VALUES("101","21","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("102","21","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("103","21","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("104","21","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("105","21","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("106","22","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("107","22","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("108","22","_menu_item_object_id","12");
INSERT INTO wp_postmeta VALUES("109","22","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("110","22","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("111","22","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("112","22","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("113","22","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("114","23","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("115","23","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("116","23","_menu_item_object_id","13");
INSERT INTO wp_postmeta VALUES("117","23","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("118","23","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("119","23","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("120","23","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("121","23","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("122","24","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("123","24","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("124","24","_menu_item_object_id","14");
INSERT INTO wp_postmeta VALUES("125","24","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("126","24","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("127","24","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("128","24","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("129","24","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("130","25","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("131","25","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("132","25","_menu_item_object_id","15");
INSERT INTO wp_postmeta VALUES("133","25","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("134","25","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("135","25","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("136","25","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("137","25","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("138","26","_menu_item_type","post_type");
INSERT INTO wp_postmeta VALUES("139","26","_menu_item_menu_item_parent","0");
INSERT INTO wp_postmeta VALUES("140","26","_menu_item_object_id","16");
INSERT INTO wp_postmeta VALUES("141","26","_menu_item_object","page");
INSERT INTO wp_postmeta VALUES("142","26","_menu_item_target","");
INSERT INTO wp_postmeta VALUES("143","26","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wp_postmeta VALUES("144","26","_menu_item_xfn","");
INSERT INTO wp_postmeta VALUES("145","26","_menu_item_url","");
INSERT INTO wp_postmeta VALUES("228","2","_theme_layout_template_header","1");
INSERT INTO wp_postmeta VALUES("229","2","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("230","2","_theme_show_page_title","1");
INSERT INTO wp_postmeta VALUES("160","13","_edit_lock","1392626507:1");
INSERT INTO wp_postmeta VALUES("161","32","_wp_attached_file","2014/01/about.jpg");
INSERT INTO wp_postmeta VALUES("162","32","_wp_attachment_metadata","a:5:{s:5:\"width\";i:220;s:6:\"height\";i:530;s:4:\"file\";s:17:\"2014/01/about.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"about-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"about-124x300.jpg\";s:5:\"width\";i:124;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("163","13","_edit_last","1");
INSERT INTO wp_postmeta VALUES("164","14","_edit_lock","1392704669:1");
INSERT INTO wp_postmeta VALUES("168","42","_wp_attached_file","2014/01/service.jpg");
INSERT INTO wp_postmeta VALUES("169","42","_wp_attachment_metadata","a:5:{s:5:\"width\";i:175;s:6:\"height\";i:645;s:4:\"file\";s:19:\"2014/01/service.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"service-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"service-81x300.jpg\";s:5:\"width\";i:81;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("167","14","_edit_last","1");
INSERT INTO wp_postmeta VALUES("170","12","_edit_lock","1393036980:1");
INSERT INTO wp_postmeta VALUES("171","12","_edit_last","1");
INSERT INTO wp_postmeta VALUES("172","54","_form","<p>Your Name (required)<br />\n    [text* your-name] </p>\n\n<p>Your Email (required)<br />\n    [email* your-email] </p>\n\n<p>Subject<br />\n    [text your-subject] </p>\n\n<p>Your Message<br />\n    [textarea your-message] </p>\n\n<p>[submit \"Send\"]</p>");
INSERT INTO wp_postmeta VALUES("173","54","_mail","a:7:{s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:26:\"[your-name] <[your-email]>\";s:4:\"body\";s:231:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Sunshine Coast Airconditioning &amp; Electrical (http://comfortsolutions.com.au/airconditioning)\";s:9:\"recipient\";s:28:\"info@comfortsolutions.com.au\";s:18:\"additional_headers\";s:0:\"\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;}");
INSERT INTO wp_postmeta VALUES("174","54","_mail_2","a:8:{s:6:\"active\";b:0;s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:26:\"[your-name] <[your-email]>\";s:4:\"body\";s:173:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Sunshine Coast Airconditioning &amp; Electrical (http://comfortsolutions.com.au/airconditioning)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:0:\"\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;}");
INSERT INTO wp_postmeta VALUES("175","54","_messages","a:21:{s:12:\"mail_sent_ok\";s:43:\"Your message was sent successfully. Thanks.\";s:12:\"mail_sent_ng\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:16:\"validation_error\";s:74:\"Validation errors occurred. Please confirm the fields and submit it again.\";s:4:\"spam\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:12:\"accept_terms\";s:35:\"Please accept the terms to proceed.\";s:16:\"invalid_required\";s:31:\"Please fill the required field.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:14:\"invalid_number\";s:28:\"Number format seems invalid.\";s:16:\"number_too_small\";s:25:\"This number is too small.\";s:16:\"number_too_large\";s:25:\"This number is too large.\";s:13:\"invalid_email\";s:28:\"Email address seems invalid.\";s:11:\"invalid_url\";s:18:\"URL seems invalid.\";s:11:\"invalid_tel\";s:31:\"Telephone number seems invalid.\";s:23:\"quiz_answer_not_correct\";s:27:\"Your answer is not correct.\";s:12:\"invalid_date\";s:26:\"Date format seems invalid.\";s:14:\"date_too_early\";s:23:\"This date is too early.\";s:13:\"date_too_late\";s:22:\"This date is too late.\";s:13:\"upload_failed\";s:22:\"Failed to upload file.\";s:24:\"upload_file_type_invalid\";s:30:\"This file type is not allowed.\";s:21:\"upload_file_too_large\";s:23:\"This file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"Failed to upload file. Error occurred.\";}");
INSERT INTO wp_postmeta VALUES("176","54","_additional_settings","");
INSERT INTO wp_postmeta VALUES("177","54","_locale","en_US");
INSERT INTO wp_postmeta VALUES("178","15","_edit_lock","1392685611:1");
INSERT INTO wp_postmeta VALUES("179","15","_edit_last","1");
INSERT INTO wp_postmeta VALUES("180","100","_wp_attached_file","2014/01/domstic.jpg");
INSERT INTO wp_postmeta VALUES("181","100","_wp_attachment_metadata","a:5:{s:5:\"width\";i:530;s:6:\"height\";i:350;s:4:\"file\";s:19:\"2014/01/domstic.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"domstic-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"domstic-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("187","135","_wp_attached_file","2014/02/sidebar.jpg");
INSERT INTO wp_postmeta VALUES("188","135","_wp_attachment_metadata","a:5:{s:5:\"width\";i:175;s:6:\"height\";i:2000;s:4:\"file\";s:19:\"2014/02/sidebar.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"sidebar-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"sidebar-26x300.jpg\";s:5:\"width\";i:26;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"sidebar-89x1024.jpg\";s:5:\"width\";i:89;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("184","126","_wp_attached_file","2014/02/home_right.jpg");
INSERT INTO wp_postmeta VALUES("185","126","_wp_attachment_metadata","a:5:{s:5:\"width\";i:530;s:6:\"height\";i:350;s:4:\"file\";s:22:\"2014/02/home_right.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"home_right-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"home_right-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("186","126","_edit_lock","1392608568:1");
INSERT INTO wp_postmeta VALUES("189","135","_edit_lock","1392618162:1");
INSERT INTO wp_postmeta VALUES("227","1","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("197","142","_theme_show_post_title","1");
INSERT INTO wp_postmeta VALUES("198","142","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("199","142","_theme_header_image_with_flash","0");
INSERT INTO wp_postmeta VALUES("200","142","_edit_last","1");
INSERT INTO wp_postmeta VALUES("201","142","_edit_lock","1392619827:1");
INSERT INTO wp_postmeta VALUES("218","223","_wp_attached_file","2014/02/Logo.png");
INSERT INTO wp_postmeta VALUES("219","223","_wp_attachment_metadata","a:5:{s:5:\"width\";i:375;s:6:\"height\";i:99;s:4:\"file\";s:16:\"2014/02/Logo.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"Logo-150x99.png\";s:5:\"width\";i:150;s:6:\"height\";i:99;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"Logo-300x79.png\";s:5:\"width\";i:300;s:6:\"height\";i:79;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("220","224","_wp_attached_file","2014/02/daiken_small.jpg");
INSERT INTO wp_postmeta VALUES("221","224","_wp_attachment_metadata","a:5:{s:5:\"width\";i:100;s:6:\"height\";i:48;s:4:\"file\";s:24:\"2014/02/daiken_small.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("222","225","_wp_attached_file","2014/02/Comfort-Solutions_72.bmp");
INSERT INTO wp_postmeta VALUES("223","226","_wp_attached_file","2014/02/login-logo.png");
INSERT INTO wp_postmeta VALUES("224","226","_wp_attachment_metadata","a:5:{s:5:\"width\";i:239;s:6:\"height\";i:63;s:4:\"file\";s:22:\"2014/02/login-logo.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"login-logo-150x63.png\";s:5:\"width\";i:150;s:6:\"height\";i:63;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO wp_postmeta VALUES("225","226","_edit_lock","1392796059:1");
INSERT INTO wp_postmeta VALUES("226","42","_edit_lock","1393036223:1");
INSERT INTO wp_postmeta VALUES("231","3","_theme_header_image","");
INSERT INTO wp_postmeta VALUES("232","4","_theme_header_image","");



DROP TABLE wp_posts;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=229 DEFAULT CHARSET=utf8;

INSERT INTO wp_posts VALUES("2","1","2014-01-31 05:17:14","2014-01-31 05:17:14","This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my blog. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://comfortsolutions.com.au/airconditioning/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!","Sample Page","","publish","open","open","","sample-page","","","2014-01-31 05:17:14","2014-01-31 05:17:14","","0","http://comfortsolutions.com.au/airconditioning/?page_id=2","0","page","","0");
INSERT INTO wp_posts VALUES("5","1","2014-01-31 05:20:41","2014-01-31 05:20:41","","contactus-large","","inherit","open","open","","contactus-large","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus-large.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("145","1","2014-02-17 06:48:16","2014-02-17 06:48:16","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\n<p>Providing a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\n<p>Split system or ducted air conditioners professionally installed by qualified technicians. We will also install your pre purchased unit if required.</p>\n<p>Ventilation solutions provided for any situation including bathrooms, parking garages and more.</p>\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p><a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","Airconditioning and Electrical Sunshine Coast","","inherit","open","open","","142-autosave-v1","","","2014-02-17 06:48:16","2014-02-17 06:48:16","","142","http://comfortsolutions.com.au/airconditioning/142-autosave-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("7","1","2014-01-31 05:20:41","2014-01-31 05:20:41","","contactus2_sml","","inherit","open","open","","contactus2_sml","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png","0","attachment","image/png","0");
INSERT INTO wp_posts VALUES("143","1","2014-02-17 06:35:19","2014-02-17 06:35:19","","blog1","","inherit","open","open","","blog1","","","2014-02-17 06:35:19","2014-02-17 06:35:19","","142","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("144","1","2014-02-17 06:42:22","2014-02-17 06:42:22","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\r\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\r\n<p>We provide a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\r\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\r\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p>","Airconditioning and Electrical Sunshine Coast","","inherit","open","open","","142-revision-v1","","","2014-02-17 06:42:22","2014-02-17 06:42:22","","142","http://comfortsolutions.com.au/airconditioning/142-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("11","1","2014-01-31 05:20:41","2014-01-31 05:20:41","","contactus","","inherit","open","open","","contactus","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("12","1","2014-01-31 05:20:36","2014-01-31 05:20:36","<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://comfortsolutions.com.au/airconditioning/services/\"><img class=\"#\" style=\"margin: 0px;\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://comfortsolutions.com.au/airconditioning/services/\"><img class=\"#\" style=\"margin: 0px;\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n<div class=\"edg-content-layout layout-item-0\" style=\"margin-bottom: 10px;\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%; padding-bottom: 8px;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\" style=\"padding-bottom: 5px;\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","publish","closed","open","","home","","","2014-02-17 09:06:06","2014-02-17 09:06:06","","0","http://comfortsolutions.com.au/airconditioning/?page_id=12","1","page","","0");
INSERT INTO wp_posts VALUES("105","1","2014-02-17 03:22:44","2014-02-17 03:22:44","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:22:44","2014-02-17 03:22:44","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("104","1","2014-02-17 03:22:24","2014-02-17 03:22:24","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:22:24","2014-02-17 03:22:24","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("102","1","2014-02-17 03:18:06","2014-02-17 03:18:06","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:18:06","2014-02-17 03:18:06","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("46","1","2014-02-03 04:09:17","2014-02-03 04:09:17","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Nunc a sollicitudin est. Curabitur ullamcorper gravida felis, sit amet scelerisque lorem iaculis sed. Donec vel neque in neque porta venenatis.  <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Nunc a sollicitudin est. Curabitur ullamcorper gravida felis, sit amet scelerisque lorem iaculis sed. Donec vel neque in neque porta venenatis.  <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 04:09:17","2014-02-03 04:09:17","","12","http://comfortsolutions.com.au/airconditioning/?p=46","0","revision","","0");
INSERT INTO wp_posts VALUES("13","1","2014-01-31 05:20:37","2014-01-31 05:20:37","<p><img class=\"alignleft size-full wp-image-211\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about2.jpg\" width=\"220\" height=\"674\" /></p>\r\n<p><span style=\"font-weight: bold;\">Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned. It is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service. </p>\r\n<p><strong>Licenced operator</strong></p>\r\n<ul>\r\n<li>Arctic lic #  AU29333</li>\r\n<li>BSA # 1191385</li>\r\n<li>Elec cont # 74839</li>\r\n</ul>\r\n<h2>Customer Satisfaction</h2>\r\n<p>Our commitment to customer satisfaction is paramount and we offer service that is second to none.<br /> We specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.</p>\r\n<h2>Professional Service</h2>\r\n<p>Our professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.</p>\r\n<h2>Electrical Contractor</h2>\r\n<p>We are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.</p>\r\n<h2>Domestic and Commercial Airconditioning and Electrical</h2>\r\n<p>We provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p>\r\n<p>Please contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","About Us","","publish","closed","open","","about-us","","","2014-02-17 08:41:46","2014-02-17 08:41:46","","0","http://comfortsolutions.com.au/airconditioning/?page_id=13","2","page","","0");
INSERT INTO wp_posts VALUES("14","1","2014-01-31 05:20:38","2014-01-31 05:20:38","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/sidebar.jpg\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and Ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p>We supply and install the following major brands: <strong>Daikin - Fujitsu - Mitsubishi - Samsung - Toshiba</strong></p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n<li>Air handling/fancoil systems.</li>\r\n<li>General ventilation fans</li>\r\n<li>Roof mounted exhaust fans</li>\r\n<li>Toilet exhaust fans</li>\r\n<li>Roof ventilators</li>\r\n<li>Car park exhaust fans</li>\r\n<li>Supply air fans.</li>\r\n<li>Smoke split and exhaust systems</li>\r\n<li>Warehouse exhaust fans</li>\r\n<li>Multi splits systems</li>\r\n<li>Ducted systems</li>\r\n<li>Split systems</li>\r\n<li>Computer room air conditioning systems</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check fan and air handler operation</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation</li>\r\n<li> Check operation and condition of the compressor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","publish","closed","open","","services","","","2014-02-18 06:24:29","2014-02-18 06:24:29","","0","http://comfortsolutions.com.au/airconditioning/?page_id=14","3","page","","0");
INSERT INTO wp_posts VALUES("15","1","2014-01-31 05:20:39","2014-01-31 05:20:39","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n<p><img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n<p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p>\r\n<p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Mob: 0410 205 271</span></p>\r\n<p>Email: info@comfortsolutions.com.au</p>\r\n<p><img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\"><br /> </span></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n<p>[contact-form-7 id=\"54\" title=\"Contact form 1\"]</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>","Contact Us","","publish","closed","open","","contact-us","","","2014-02-17 06:57:26","2014-02-17 06:57:26","","0","http://comfortsolutions.com.au/airconditioning/?page_id=15","4","page","","0");
INSERT INTO wp_posts VALUES("149","1","2014-02-17 06:56:23","2014-02-17 06:56:23","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n<p><img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n<p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p>\r\n<p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p>\r\n<p>Tel: (07) 5499 6299</p>\r\n<p><span style=\"font-weight: bold;\">Mob: 0410 205 271</span></p>\r\n<p>&nbsp;</p>\r\n<p>Email: info@comfortsolutions.com.au</p>\r\n<p><img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\"><br /> </span></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n<p>[contact-form-7 id=\"54\" title=\"Contact form 1\"]</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-17 06:56:23","2014-02-17 06:56:23","","15","http://comfortsolutions.com.au/airconditioning/15-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("55","1","2014-02-03 06:05:01","2014-02-03 06:05:01","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 25%;\">\r\n\r\n<span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:05:01","2014-02-03 06:05:01","","15","http://comfortsolutions.com.au/airconditioning/?p=55","0","revision","","0");
INSERT INTO wp_posts VALUES("16","1","2014-01-31 05:20:40","2014-01-31 05:20:40","<article class=\"edg-post edg-article\">\n                                <h2 class=\"edg-postheader\"><a href=\"#\">Conse ctetur</a>\n                                </h2>\n                                                <div class=\"edg-postheadericons edg-metadata-icons\">\n                    <span class=\"edg-postdateicon\"></span>\n                     | <span class=\"edg-postauthoricon\"> <a href=\"#\" title=\"Posts by Admin\">Admin</a></span>\n                     | <span class=\"edg-postediticon\"></span>\n                                    </div>\n                <div class=\"edg-postcontent edg-postcontent-0 clearfix\" >\n<div class=\"edg-content-layout\">\n<div class=\"edg-content-layout-row\">\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 100%\">\n<div class=\"image-caption-wrapper\" style=\"width: 55%; float: left\"><img alt=\"an image\" style=\"width: 100%; max-width:360px\" class=\"edg-lightbox\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/shutterstock_32050237.png\"></div>\n<p>Lorem <sup>superscript</sup> dolor <sub>subscript</sub>&nbsp;amet, consectetuer adipiscing elit, <a href=\"#\" title=\"test link\">test link</a>. Nullam dignissim convallis est. Quisque aliquam. <cite>cite</cite>. Nunc iaculis suscipit dui. Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.</p>\n<p>Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus. Maecenas ornare tortor. Donec sed tellus eget sapien fringilla nonummy. <abbr title=\"National Basketball Association\">NBA</abbr> Mauris a ante.</p></div></div></div><br /><a href=\"#\">Read more...</a>\n                </div>\n\n</article>\n<article class=\"edg-post edg-article\">\n                                <h2 class=\"edg-postheader\"><a href=\"#\">Lorem ipsum</a>\n                                </h2>\n                                                <div class=\"edg-postheadericons edg-metadata-icons\">\n                    <span class=\"edg-postdateicon\"></span>\n                     | <span class=\"edg-postauthoricon\"> <a href=\"#\" title=\"Posts by Admin\">Admin</a></span>\n                     | <span class=\"edg-postediticon\"></span>\n                                    </div>\n                <div class=\"edg-postcontent edg-postcontent-1 clearfix\" >\n<div class=\"edg-content-layout\">\n<div class=\"edg-content-layout-row\">\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 100%\">\n<div class=\"image-caption-wrapper\" style=\"width: 55%; float: left\"><img alt=\"an-image\" style=\"width: 100%; max-width:360px\" class=\"edg-lightbox\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/shutterstock_62287657-01-3.jpg\"></div>\n<h1>Heading 1</h1>\n<h2>Heading 2</h2>\n<h3>Heading 3</h3>\n<h4>Heading 4</h4>\n<h5>Heading 5</h5>\n<h6>Heading 6</h6>\n<p>Lorem dolor&nbsp;amet, consectetuer adipiscing elit. Nullam dignissim convallis est. Quisque aliquam. <cite>cite</cite>. Nunc iaculis suscipit dui. Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.</p>\n \n<blockquote>\n This stylesheet is going to help so freaking much.</blockquote></div></div></div><br /><a href=\"#\">Read more...</a>\n                </div>\n\n</article>\n","Blog Page","","publish","closed","open","","blog","","","2014-01-31 05:20:40","2014-01-31 05:20:40","","0","http://comfortsolutions.com.au/airconditioning/?page_id=16","5","page","","0");
INSERT INTO wp_posts VALUES("17","1","2014-01-31 05:20:41","2014-01-31 05:20:41"," ","","","publish","open","open","","17","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/?p=17","0","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("18","1","2014-01-31 05:20:41","2014-01-31 05:20:41"," ","","","publish","open","open","","18","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/?p=18","2","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("19","1","2014-01-31 05:20:41","2014-01-31 05:20:41"," ","","","publish","open","open","","19","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/?p=19","3","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("20","1","2014-01-31 05:20:41","2014-01-31 05:20:41"," ","","","publish","open","open","","20","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/?p=20","4","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("21","1","2014-01-31 05:20:41","2014-01-31 05:20:41","","Blog","","publish","open","open","","blog","","","2014-01-31 05:20:41","2014-01-31 05:20:41","","0","http://comfortsolutions.com.au/airconditioning/?p=21","5","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("22","1","2014-01-31 05:20:42","2014-01-31 05:20:42"," ","","","publish","open","open","","22","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","0","http://comfortsolutions.com.au/airconditioning/?p=22","0","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("23","1","2014-01-31 05:20:42","2014-01-31 05:20:42"," ","","","publish","open","open","","23","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","0","http://comfortsolutions.com.au/airconditioning/?p=23","2","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("24","1","2014-01-31 05:20:42","2014-01-31 05:20:42"," ","","","publish","open","open","","24","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","0","http://comfortsolutions.com.au/airconditioning/?p=24","3","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("25","1","2014-01-31 05:20:42","2014-01-31 05:20:42"," ","","","publish","open","open","","25","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","0","http://comfortsolutions.com.au/airconditioning/?p=25","4","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("26","1","2014-01-31 05:20:42","2014-01-31 05:20:42","","Blog","","publish","open","open","","blog-2","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","0","http://comfortsolutions.com.au/airconditioning/?p=26","5","nav_menu_item","","0");
INSERT INTO wp_posts VALUES("29","1","2014-01-31 05:20:42","2014-01-31 05:20:42","<span style=\"font-weight: bold;\">Comfort Solutions</span>&nbsp;is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned, it is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.<h2>Customer Satisfaction</h2><p>Our commitment to customer satisfaction is paramount and we offer service that is second to none.<br>We specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.</p><h3>Professional Service</h3><p>Our professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.</p><h4>Electrical Contractor</h4><p>We are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.<br>\n</p><h5>Domestic and Commercial Airconditioning and Electrical</h5><p>We provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p><p>Please contact us today to discuss your air conditioning or electrical requirements&nbsp;<a href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\" title=\"Contact us\" class=\"edg-button\">Contact Us</a>&nbsp;</p>","About Us","","inherit","open","open","","13-revision-v1","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","13","http://comfortsolutions.com.au/airconditioning/?p=29","0","revision","","0");
INSERT INTO wp_posts VALUES("30","1","2014-01-31 05:20:42","2014-01-31 05:20:42","<h1>Airconditioning and Electrical</h1><p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p><h2>AIRCONDITIONING</h2><p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p><h3>ELECTRICAL</h3><p style=\"text-align: left;\">Switchboard upgrades, new wiring, rewiring, commercial, electricalsurge protection, new power points,electrical safety inspections, smoke detectors, indoor lighting solutions, outdoor and landscaping lighting, and appliance installations</p><p style=\"text-align: left;\">Please contact us today for more infromation&nbsp;<a href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\" title=\"Contact us\" class=\"edg-button\">Contact Us</a>&nbsp;</p>","Services","","inherit","open","open","","14-revision-v1","","","2014-01-31 05:20:42","2014-01-31 05:20:42","","14","http://comfortsolutions.com.au/airconditioning/?p=30","0","revision","","0");
INSERT INTO wp_posts VALUES("32","1","2014-02-03 02:37:41","2014-02-03 02:37:41","","about","","inherit","open","open","","about","","","2014-02-03 02:37:41","2014-02-03 02:37:41","","13","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("33","1","2014-02-03 02:38:06","2014-02-03 02:38:06","<span style=\"font-weight: bold;\"><img class=\"alignleft size-full wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"220\" height=\"530\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned, it is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.\r\n<h2>Customer Satisfaction</h2>\r\nOur commitment to customer satisfaction is paramount and we offer service that is second to none.\r\nWe specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.\r\n<h3>Professional Service</h3>\r\nOur professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.\r\n<h4>Electrical Contractor</h4>\r\nWe are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.\r\n<h5>Domestic and Commercial Airconditioning and Electrical</h5>\r\nWe provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.\r\n\r\nPlease contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 02:38:06","2014-02-03 02:38:06","","13","http://comfortsolutions.com.au/airconditioning/?p=33","0","revision","","0");
INSERT INTO wp_posts VALUES("34","1","2014-02-03 02:39:05","2014-02-03 02:39:05","<span style=\"font-weight: bold;\"><img class=\"alignleft  wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"176\" height=\"424\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned, it is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.\r\n<h2>Customer Satisfaction</h2>\r\nOur commitment to customer satisfaction is paramount and we offer service that is second to none.\r\nWe specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.\r\n<h3>Professional Service</h3>\r\nOur professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.\r\n<h4>Electrical Contractor</h4>\r\nWe are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.\r\n<h5>Domestic and Commercial Airconditioning and Electrical</h5>\r\nWe provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.\r\n\r\nPlease contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 02:39:05","2014-02-03 02:39:05","","13","http://comfortsolutions.com.au/airconditioning/?p=34","0","revision","","0");
INSERT INTO wp_posts VALUES("35","1","2014-02-03 02:40:39","2014-02-03 02:40:39","<span style=\"font-weight: bold;\"><img class=\"alignleft  wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"176\" height=\"424\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned, it is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.\r\n<h2>Customer Satisfaction</h2>\r\nOur commitment to customer satisfaction is paramount and we offer service that is second to none.\r\nWe specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.\r\n<h3>Professional Service</h3>\r\nOur professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.\r\n<h4>Electrical Contractor</h4>\r\nWe are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.\r\n<h5>Domestic and Commercial Airconditioning and Electrical</h5>\r\nWe provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p>\r\n\r\nPlease contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 02:40:39","2014-02-03 02:40:39","","13","http://comfortsolutions.com.au/airconditioning/?p=35","0","revision","","0");
INSERT INTO wp_posts VALUES("42","1","2014-02-03 03:09:39","2014-02-03 03:09:39","","service","","inherit","open","open","","service","","","2014-02-03 03:09:39","2014-02-03 03:09:39","","14","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("37","1","2014-02-03 02:51:46","2014-02-03 02:51:46","<h1><img class=\"alignleft size-full wp-image-36\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"480\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Switchboard upgrades, new wiring, rewiring, commercial, electricalsurge protection, new power points,electrical safety inspections, smoke detectors, indoor lighting solutions, outdoor and landscaping lighting, and appliance installations</p>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 02:51:46","2014-02-03 02:51:46","","14","http://comfortsolutions.com.au/airconditioning/?p=37","0","revision","","0");
INSERT INTO wp_posts VALUES("39","1","2014-02-03 02:56:38","2014-02-03 02:56:38","<h1><img class=\"alignleft size-full wp-image-36\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"480\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<p style=\"text-align: left;\">switchboard upgrades, new wiring, rewiring, commercial, electricalsurge protection, new power points,electrical safety inspections, smoke detectors, indoor lighting solutions, outdoor/landscaping lighting, and appliance installations.</p>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 02:56:38","2014-02-03 02:56:38","","14","http://comfortsolutions.com.au/airconditioning/?p=39","0","revision","","0");
INSERT INTO wp_posts VALUES("40","1","2014-02-03 02:59:17","2014-02-03 02:59:17","<h1><img class=\"alignleft size-full wp-image-36\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"480\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n\r\n<ul>\r\n	<li>switchboard upgrades,</li>\r\n	<li>new wiring,</li>\r\n	<li>rewiring,</li>\r\n	<li>commercial,</li>\r\n	<li>electricalsurge protection,</li>\r\n	<li>new power points</li>\r\n	<li>,electrical safety inspections,</li>\r\n	<li>smoke detectors,</li>\r\n	<li>indoor lighting solutions,</li>\r\n	<li>outdoor/landscaping lighting,</li>\r\n	<li>and appliance installations.</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 02:59:17","2014-02-03 02:59:17","","14","http://comfortsolutions.com.au/airconditioning/?p=40","0","revision","","0");
INSERT INTO wp_posts VALUES("41","1","2014-02-03 03:03:56","2014-02-03 03:03:56","<h1><img class=\"alignleft size-full wp-image-36\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"480\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n\r\n<ul>\r\n	<li>Switchboard upgrades,</li>\r\n	<li>New wiring,</li>\r\n	<li>Rewiring,</li>\r\n	<li>Commercial,</li>\r\n	<li>Electricalsurge protection,</li>\r\n	<li>New power points</li>\r\n	<li>Electrical safety inspections,</li>\r\n	<li>Smoke detectors,</li>\r\n	<li>Indoor lighting solutions,</li>\r\n	<li>Outdoor/landscaping lighting,</li>\r\n	<li>Appliance installations.</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 03:03:56","2014-02-03 03:03:56","","14","http://comfortsolutions.com.au/airconditioning/?p=41","0","revision","","0");
INSERT INTO wp_posts VALUES("43","1","2014-02-03 03:09:48","2014-02-03 03:09:48","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n\r\n<ul>\r\n	<li>Switchboard upgrades,</li>\r\n	<li>New wiring,</li>\r\n	<li>Rewiring,</li>\r\n	<li>Commercial,</li>\r\n	<li>Electricalsurge protection,</li>\r\n	<li>New power points</li>\r\n	<li>Electrical safety inspections,</li>\r\n	<li>Smoke detectors,</li>\r\n	<li>Indoor lighting solutions,</li>\r\n	<li>Outdoor/landscaping lighting,</li>\r\n	<li>Appliance installations.</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 03:09:48","2014-02-03 03:09:48","","14","http://comfortsolutions.com.au/airconditioning/?p=43","0","revision","","0");
INSERT INTO wp_posts VALUES("44","1","2014-02-03 03:10:50","2014-02-03 03:10:50","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n\r\n<h3>ELECTRICAL</h3>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n\r\n<ul>\r\n	<li>Switchboard upgrades</li>\r\n	<li>New wiring</li>\r\n	<li>Rewiring</li>\r\n	<li>Commercial</li>\r\n	<li>Electrical surge protection</li>\r\n	<li>New power points</li>\r\n	<li>Electrical safety inspections</li>\r\n	<li>Smoke detectors</li>\r\n	<li>Indoor lighting solutions</li>\r\n	<li>Outdoor/landscaping lighting</li>\r\n	<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 03:10:50","2014-02-03 03:10:50","","14","http://comfortsolutions.com.au/airconditioning/?p=44","0","revision","","0");
INSERT INTO wp_posts VALUES("47","1","2014-02-03 04:59:23","2014-02-03 04:59:23","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners prompt professional service guranteed.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Nunc a sollicitudin est. Curabitur ullamcorper gravida felis, sit amet scelerisque lorem iaculis sed. Donec vel neque in neque porta venenatis.  <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 04:59:23","2014-02-03 04:59:23","","12","http://comfortsolutions.com.au/airconditioning/?p=47","0","revision","","0");
INSERT INTO wp_posts VALUES("48","1","2014-02-03 05:09:52","2014-02-03 05:09:52","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners prompt professional service guranteed.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 05:09:52","2014-02-03 05:09:52","","12","http://comfortsolutions.com.au/airconditioning/?p=48","0","revision","","0");
INSERT INTO wp_posts VALUES("49","1","2014-02-03 05:10:44","2014-02-03 05:10:44","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We offer a prompt professional service, guranteed.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 05:10:44","2014-02-03 05:10:44","","12","http://comfortsolutions.com.au/airconditioning/?p=49","0","revision","","0");
INSERT INTO wp_posts VALUES("52","1","2014-02-03 06:02:34","2014-02-03 06:02:34","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 06:02:34","2014-02-03 06:02:34","","12","http://comfortsolutions.com.au/airconditioning/?p=52","0","revision","","0");
INSERT INTO wp_posts VALUES("50","1","2014-02-03 05:56:16","2014-02-03 05:56:16","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 05:56:16","2014-02-03 05:56:16","","12","http://comfortsolutions.com.au/airconditioning/?p=50","0","revision","","0");
INSERT INTO wp_posts VALUES("51","1","2014-02-03 06:02:01","2014-02-03 06:02:01","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n\r\n&nbsp;\r\n\r\n<img class=\"edg-lightbox\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n\r\n<img class=\"edg-lightbox\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 06:02:01","2014-02-03 06:02:01","","12","http://comfortsolutions.com.au/airconditioning/?p=51","0","revision","","0");
INSERT INTO wp_posts VALUES("53","1","2014-02-03 06:03:08","2014-02-03 06:03:08","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n<img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n<img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 06:03:08","2014-02-03 06:03:08","","12","http://comfortsolutions.com.au/airconditioning/?p=53","0","revision","","0");
INSERT INTO wp_posts VALUES("54","1","2014-02-03 06:04:16","2014-02-03 06:04:16","<p>Your Name (required)<br />\r\n    [text* your-name] </p>\r\n\r\n<p>Your Email (required)<br />\r\n    [email* your-email] </p>\r\n\r\n<p>Subject<br />\r\n    [text your-subject] </p>\r\n\r\n<p>Your Message<br />\r\n    [textarea your-message] </p>\r\n\r\n<p>[submit \"Send\"]</p>\n[your-subject]\n[your-name] <[your-email]>\nFrom: [your-name] <[your-email]>\r\nSubject: [your-subject]\r\n\r\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on Sunshine Coast Airconditioning &amp; Electrical (http://comfortsolutions.com.au/airconditioning)\ninfo@comfortsolutions.com.au\n\n\n\n\n[your-subject]\n[your-name] <[your-email]>\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on Sunshine Coast Airconditioning &amp; Electrical (http://comfortsolutions.com.au/airconditioning)\n[your-email]\n\n\n\nYour message was sent successfully. Thanks.\nFailed to send your message. Please try later or contact the administrator by another method.\nValidation errors occurred. Please confirm the fields and submit it again.\nFailed to send your message. Please try later or contact the administrator by another method.\nPlease accept the terms to proceed.\nPlease fill the required field.\nYour entered code is incorrect.\nNumber format seems invalid.\nThis number is too small.\nThis number is too large.\nEmail address seems invalid.\nURL seems invalid.\nTelephone number seems invalid.\nYour answer is not correct.\nDate format seems invalid.\nThis date is too early.\nThis date is too late.\nFailed to upload file.\nThis file type is not allowed.\nThis file is too large.\nFailed to upload file. Error occurred.","Contact form 1","","publish","open","open","","contact-form-1","","","2014-02-19 03:36:37","2014-02-19 03:36:37","","0","http://comfortsolutions.com.au/airconditioning/?post_type=wpcf7_contact_form&#038;p=54","0","wpcf7_contact_form","","0");
INSERT INTO wp_posts VALUES("56","1","2014-02-17 06:55:47","2014-02-17 06:55:47","<div class=\"edg-content-layout\">\n<div class=\"edg-content-layout-row\">\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\n<p><img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /></p>\n</div>\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\n<p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p>\n<p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p>\n<p>Tel: (07) 5499 6299</p>\n<p><span style=\"font-weight: bold;\">Mob: 0418 155 313</span></p>\n<p>&nbsp;</p>\n<p>Email: info@comfortsolutions.com.au</p>\n<p><img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\"><br /> </span></p>\n</div>\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\n<p>[contact-form-7 id=\"54\" title=\"Contact form 1\"]</p>\n</div>\n</div>\n</div>\n<div class=\"edg-content-layout\">\n<div class=\"edg-content-layout-row\">\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\n<p>&nbsp;</p>\n</div>\n</div>\n</div>","Contact Us","","inherit","open","open","","15-autosave-v1","","","2014-02-17 06:55:47","2014-02-17 06:55:47","","15","http://comfortsolutions.com.au/airconditioning/?p=56","0","revision","","0");
INSERT INTO wp_posts VALUES("57","1","2014-02-03 06:06:09","2014-02-03 06:06:09","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 35%;\">\r\n\r\n<span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:06:09","2014-02-03 06:06:09","","15","http://comfortsolutions.com.au/airconditioning/?p=57","0","revision","","0");
INSERT INTO wp_posts VALUES("58","1","2014-02-03 06:07:06","2014-02-03 06:07:06","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 35%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:07:06","2014-02-03 06:07:06","","15","http://comfortsolutions.com.au/airconditioning/?p=58","0","revision","","0");
INSERT INTO wp_posts VALUES("59","1","2014-02-03 06:07:46","2014-02-03 06:07:46","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 45%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:07:46","2014-02-03 06:07:46","","15","http://comfortsolutions.com.au/airconditioning/?p=59","0","revision","","0");
INSERT INTO wp_posts VALUES("60","1","2014-02-03 06:08:01","2014-02-03 06:08:01","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 25%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:08:01","2014-02-03 06:08:01","","15","http://comfortsolutions.com.au/airconditioning/?p=60","0","revision","","0");
INSERT INTO wp_posts VALUES("70","1","2014-02-03 06:15:59","2014-02-03 06:15:59","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:15:59","2014-02-03 06:15:59","","15","http://comfortsolutions.com.au/airconditioning/?p=70","0","revision","","0");
INSERT INTO wp_posts VALUES("61","1","2014-02-03 06:09:03","2014-02-03 06:09:03","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 25%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:09:03","2014-02-03 06:09:03","","15","http://comfortsolutions.com.au/airconditioning/?p=61","0","revision","","0");
INSERT INTO wp_posts VALUES("62","1","2014-02-03 06:09:31","2014-02-03 06:09:31","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:09:31","2014-02-03 06:09:31","","15","http://comfortsolutions.com.au/airconditioning/?p=62","0","revision","","0");
INSERT INTO wp_posts VALUES("63","1","2014-02-03 06:10:31","2014-02-03 06:10:31","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; margin-left: 15px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:10:31","2014-02-03 06:10:31","","15","http://comfortsolutions.com.au/airconditioning/?p=63","0","revision","","0");
INSERT INTO wp_posts VALUES("64","1","2014-02-03 06:10:54","2014-02-03 06:10:54","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 15px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:10:54","2014-02-03 06:10:54","","15","http://comfortsolutions.com.au/airconditioning/?p=64","0","revision","","0");
INSERT INTO wp_posts VALUES("65","1","2014-02-03 06:11:35","2014-02-03 06:11:35","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:11:35","2014-02-03 06:11:35","","15","http://comfortsolutions.com.au/airconditioning/?p=65","0","revision","","0");
INSERT INTO wp_posts VALUES("69","1","2014-02-03 06:15:12","2014-02-03 06:15:12","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:15:12","2014-02-03 06:15:12","","15","http://comfortsolutions.com.au/airconditioning/?p=69","0","revision","","0");
INSERT INTO wp_posts VALUES("66","1","2014-02-03 06:12:22","2014-02-03 06:12:22","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; margin-top: 5px;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:12:22","2014-02-03 06:12:22","","15","http://comfortsolutions.com.au/airconditioning/?p=66","0","revision","","0");
INSERT INTO wp_posts VALUES("67","1","2014-02-03 06:13:06","2014-02-03 06:13:06","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%; margin-top: 5px;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:13:06","2014-02-03 06:13:06","","15","http://comfortsolutions.com.au/airconditioning/?p=67","0","revision","","0");
INSERT INTO wp_posts VALUES("68","1","2014-02-03 06:13:47","2014-02-03 06:13:47","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%; margin-top: 25px;\">\r\n\r\n<img class=\"edg-lightbox\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n&nbsp;\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:13:47","2014-02-03 06:13:47","","15","http://comfortsolutions.com.au/airconditioning/?p=68","0","revision","","0");
INSERT INTO wp_posts VALUES("71","1","2014-02-03 06:16:41","2014-02-03 06:16:41","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; margin-right: 20px;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:16:41","2014-02-03 06:16:41","","15","http://comfortsolutions.com.au/airconditioning/?p=71","0","revision","","0");
INSERT INTO wp_posts VALUES("76","1","2014-02-03 06:26:15","2014-02-03 06:26:15","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span>\r\n\r\n<span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob: 0418 155 313</span>\r\n\r\n<span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:26:15","2014-02-03 06:26:15","","15","http://comfortsolutions.com.au/airconditioning/?p=76","0","revision","","0");
INSERT INTO wp_posts VALUES("72","1","2014-02-03 06:17:04","2014-02-03 06:17:04","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 20px;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:17:04","2014-02-03 06:17:04","","15","http://comfortsolutions.com.au/airconditioning/?p=72","0","revision","","0");
INSERT INTO wp_posts VALUES("73","1","2014-02-03 06:17:23","2014-02-03 06:17:23","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<p><span style=\"font-weight: bold;\">Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have. </span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Mob 0418 155 313</span></p>\r\n\r\n<p><span style=\"font-weight: bold;\">Email: info@comfortsolutions.com.au</span></p>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:17:23","2014-02-03 06:17:23","","15","http://comfortsolutions.com.au/airconditioning/?p=73","0","revision","","0");
INSERT INTO wp_posts VALUES("74","1","2014-02-03 06:19:00","2014-02-03 06:19:00","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n<img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n<img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring, switchboards and more.<a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 06:19:00","2014-02-03 06:19:00","","12","http://comfortsolutions.com.au/airconditioning/?p=74","0","revision","","0");
INSERT INTO wp_posts VALUES("75","1","2014-02-03 06:20:36","2014-02-03 06:20:36","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n<img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n<img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a\r\nprofessional, cost effective solution for all your airconditioning requirements.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring, switchboards and more.   <a class=\"edg-button\" href=\"http://#\">Read more</a></p>\r\n\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n	<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n	<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n	<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 06:20:36","2014-02-03 06:20:36","","12","http://comfortsolutions.com.au/airconditioning/?p=75","0","revision","","0");
INSERT INTO wp_posts VALUES("77","1","2014-02-03 06:34:06","2014-02-03 06:34:06","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p> </span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Tel: (07) 5499 6299</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:34:06","2014-02-03 06:34:06","","15","http://comfortsolutions.com.au/airconditioning/?p=77","0","revision","","0");
INSERT INTO wp_posts VALUES("78","1","2014-02-03 06:35:02","2014-02-03 06:35:02","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p> </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:35:02","2014-02-03 06:35:02","","15","http://comfortsolutions.com.au/airconditioning/?p=78","0","revision","","0");
INSERT INTO wp_posts VALUES("79","1","2014-02-03 06:35:45","2014-02-03 06:35:45","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p> </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span>\r\n\r\n<span style=\"font-weight: bold;\">Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:35:45","2014-02-03 06:35:45","","15","http://comfortsolutions.com.au/airconditioning/?p=79","0","revision","","0");
INSERT INTO wp_posts VALUES("80","1","2014-02-03 06:36:16","2014-02-03 06:36:16","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p> </span>\r\n\r\n<span style=\"font-weight: bold;\">Tel: (07) 5499 6299</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:36:16","2014-02-03 06:36:16","","15","http://comfortsolutions.com.au/airconditioning/?p=80","0","revision","","0");
INSERT INTO wp_posts VALUES("81","1","2014-02-03 06:37:16","2014-02-03 06:37:16","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p> </span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Tel: (07) 5499 6299</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:37:16","2014-02-03 06:37:16","","15","http://comfortsolutions.com.au/airconditioning/?p=81","0","revision","","0");
INSERT INTO wp_posts VALUES("82","1","2014-02-03 06:37:41","2014-02-03 06:37:41","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n\r\n<img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" />\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n\r\n<span style=\"font-weight: bold;\"><p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Tel: (07) 5499 6299</span></p>\r\n\r\n<span style=\"font-weight: bold;\">Mob: 0418 155 313</p></span>\r\n\r\n<span style=\"font-weight: bold;\"><p>Email: info@comfortsolutions.com.au</p></span>\r\n\r\n<img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\">\r\n</span>\r\n\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n\r\n[contact-form-7 id=\"54\" title=\"Contact form 1\"]\r\n\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n\r\n&nbsp;\r\n\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-03 06:37:41","2014-02-03 06:37:41","","15","http://comfortsolutions.com.au/airconditioning/?p=82","0","revision","","0");
INSERT INTO wp_posts VALUES("83","1","2014-02-03 07:09:26","2014-02-03 07:09:26","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\">\r\n<img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" />\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\">\r\n<img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" /></p>\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - We offer a<br />\r\nprofessional, cost effective solution for all your airconditioning requirements.   <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.   <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring, switchboards and more.   <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\"><p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p></blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:09:26","2014-02-03 07:09:26","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("84","1","2014-02-03 07:11:37","2014-02-03 07:11:37","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - Split system or ducted aircondtioners. We deliver prompt professional service, using the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:11:37","2014-02-03 07:11:37","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("85","1","2014-02-03 07:12:24","2014-02-03 07:12:24","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast, domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:12:24","2014-02-03 07:12:24","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("86","1","2014-02-03 07:13:08","2014-02-03 07:13:08","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region, domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:13:08","2014-02-03 07:13:08","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("87","1","2014-02-03 07:14:00","2014-02-03 07:14:00","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:14:00","2014-02-03 07:14:00","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("100","1","2014-02-17 03:17:26","2014-02-17 03:17:26","","domstic","","inherit","open","open","","domstic","","","2014-02-17 03:17:26","2014-02-17 03:17:26","","12","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("88","1","2014-02-03 07:18:25","2014-02-03 07:18:25","<p><span style=\"font-weight: bold;\"><img class=\"alignleft  wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"176\" height=\"424\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned, it is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.</p>\r\n<h2>Customer Satisfaction</h2>\r\n<p>Our commitment to customer satisfaction is paramount and we offer service that is second to none.<br />\r\nWe specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.</p>\r\n<h2>Professional Service</h2>\r\n<p>Our professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.</p>\r\n<h2>Electrical Contractor</h2>\r\n<p>We are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.</p>\r\n<h2>Domestic and Commercial Airconditioning and Electrical</h2>\r\n<p>We provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p>\r\n<p>Please contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>\r\n","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 07:18:25","2014-02-03 07:18:25","","13","http://comfortsolutions.com.au/airconditioning/13-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("89","1","2014-02-03 07:18:54","2014-02-03 07:18:54","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>AIRCONDITIONING</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<h2>ELECTRICAL</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>\r\n","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 07:18:54","2014-02-03 07:18:54","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("90","1","2014-02-03 07:20:00","2014-02-03 07:20:00","<p><span style=\"font-weight: bold;\"><img class=\"alignleft  wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"176\" height=\"424\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned. It is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.</p>\r\n<h2>Customer Satisfaction</h2>\r\n<p>Our commitment to customer satisfaction is paramount and we offer service that is second to none.<br /> We specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.</p>\r\n<h2>Professional Service</h2>\r\n<p>Our professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.</p>\r\n<h2>Electrical Contractor</h2>\r\n<p>We are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.</p>\r\n<h2>Domestic and Commercial Airconditioning and Electrical</h2>\r\n<p>We provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p>\r\n<p>Please contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 07:20:00","2014-02-03 07:20:00","","13","http://comfortsolutions.com.au/airconditioning/13-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("93","1","2014-02-03 07:26:58","2014-02-03 07:26:58","<p><span style=\"font-weight: bold;\"><img class=\"alignleft  wp-image-32\" alt=\"about\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/about.jpg\" width=\"198\" height=\"477\" />Comfort Solutions</span> is a Sunshine Coast Air Conditioning and Electrical business that is family operated and owned. It is a company taking pride in over 20 year’s experience providing a prompt, professional air conditioning and electrical service.</p>\r\n<h2>Customer Satisfaction</h2>\r\n<p>Our commitment to customer satisfaction is paramount and we offer service that is second to none.<br /> We specialise in air conditioning and are experts when it comes to servicing both the residential and commercial marketplace. We will tailor an air conditioning solution for you, that offers the best value and most cost efficient product for your specific application.</p>\r\n<h2>Professional Service</h2>\r\n<p>Our professional service will also provide you with full after sales support for your air conditioner, including recommending an ongoing maintenance schedule to ensure your air conditioning system runs efficiently, cost effectively and with no down time.</p>\r\n<h2>Electrical Contractor</h2>\r\n<p>We are unique as an air conditioning company, in that we are also fully qualified electrical contractors who provide this excellent service for our residential customers. This allows for a complete professional air conditioning installation from start to finish.</p>\r\n<h2>Domestic and Commercial Airconditioning and Electrical</h2>\r\n<p>We provide a professional service to both domestic and commercial customers, maintainence, service and installation of commercial and domestic air conditioning systems including ducted and split units. We also provide an electrical installation, repair and maintence service for domestic or commercial premises.</p>\r\n<p>Please contact us today to discuss your air conditioning or electrical requirements <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","About Us","","inherit","open","open","","13-revision-v1","","","2014-02-03 07:26:58","2014-02-03 07:26:58","","13","http://comfortsolutions.com.au/airconditioning/13-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("91","1","2014-02-03 07:22:24","2014-02-03 07:22:24","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more infromation <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 07:22:24","2014-02-03 07:22:24","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("92","1","2014-02-03 07:24:59","2014-02-03 07:24:59","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Electrical and Air Conditioning requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-03 07:24:59","2014-02-03 07:24:59","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("96","1","2014-02-03 07:30:01","2014-02-03 07:30:01","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" />\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding=left: 5px;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:30:01","2014-02-03 07:30:01","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("97","1","2014-02-03 07:31:25","2014-02-03 07:31:25","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" /></p>\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding=left: 5px; !important\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:31:25","2014-02-03 07:31:25","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("98","1","2014-02-03 07:32:27","2014-02-03 07:32:27","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" /></p>\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding=left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:32:27","2014-02-03 07:32:27","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("99","1","2014-02-03 07:33:05","2014-02-03 07:33:05","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 25%;\"><img class=\"#\" style=\"border-width: 0px; margin: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/f0b6b446-83c1-4213-8a4c-381e8a2f079b.png\" width=\"263\" height=\"347\" /></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 75%;\"><img class=\"#\" style=\"margin-top: 0px; margin-right: 5px; margin-bottom: 0px; margin-left: 0px; border-width: 0px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/889543f1-4dc2-40c3-9b74-e2aafb351054.png\" width=\"787\" height=\"346\" /></p>\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-03 07:33:05","2014-02-03 07:33:05","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("103","1","2014-02-17 03:21:25","2014-02-17 03:21:25","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:21:25","2014-02-17 03:21:25","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("106","1","2014-02-17 03:23:14","2014-02-17 03:23:14","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:23:14","2014-02-17 03:23:14","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("107","1","2014-02-17 03:23:25","2014-02-17 03:23:25","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:23:25","2014-02-17 03:23:25","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("108","1","2014-02-17 03:24:11","2014-02-17 03:24:11","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-righ: 10px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:24:11","2014-02-17 03:24:11","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("109","1","2014-02-17 03:24:25","2014-02-17 03:24:25","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-right: 10px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:24:25","2014-02-17 03:24:25","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("158","1","2014-02-17 07:30:09","2014-02-17 07:30:09","<div class=\"edg-content-layout layout-item-0\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:30:09","2014-02-17 07:30:09","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("110","1","2014-02-17 03:25:00","2014-02-17 03:25:00","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: 0px; width: 48%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-right: 10px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:25:00","2014-02-17 03:25:00","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("111","1","2014-02-17 03:25:28","2014-02-17 03:25:28","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: 0px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 10px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:25:28","2014-02-17 03:25:28","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("112","1","2014-02-17 03:26:53","2014-02-17 03:26:53","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: 0px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width:45%; margin-right:50px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:26:53","2014-02-17 03:26:53","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("113","1","2014-02-17 03:27:09","2014-02-17 03:27:09","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width:45%; margin-right:50px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:27:09","2014-02-17 03:27:09","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("114","1","2014-02-17 03:27:24","2014-02-17 03:27:24","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width:45%; margin-right:55px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:27:24","2014-02-17 03:27:24","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("115","1","2014-02-17 03:27:36","2014-02-17 03:27:36","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\" float:left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width:45%; margin-right:60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:27:36","2014-02-17 03:27:36","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("127","1","2014-02-17 03:43:13","2014-02-17 03:43:13","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:43:13","2014-02-17 03:43:13","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("116","1","2014-02-17 03:30:09","2014-02-17 03:30:09","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:30:09","2014-02-17 03:30:09","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("117","1","2014-02-17 03:30:55","2014-02-17 03:30:55","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 50%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:30:55","2014-02-17 03:30:55","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("118","1","2014-02-17 03:31:13","2014-02-17 03:31:13","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:31:13","2014-02-17 03:31:13","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("119","1","2014-02-17 03:31:28","2014-02-17 03:31:28","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:31:28","2014-02-17 03:31:28","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("120","1","2014-02-17 03:31:38","2014-02-17 03:31:38","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 48%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:31:38","2014-02-17 03:31:38","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("121","1","2014-02-17 03:31:53","2014-02-17 03:31:53","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 46%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 46%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:31:53","2014-02-17 03:31:53","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("122","1","2014-02-17 03:32:06","2014-02-17 03:32:06","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 48%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 46%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:32:06","2014-02-17 03:32:06","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("123","1","2014-02-17 03:32:16","2014-02-17 03:32:16","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 48%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 48%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:32:16","2014-02-17 03:32:16","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("124","1","2014-02-17 03:32:29","2014-02-17 03:32:29","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%; border-right: 1px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:32:29","2014-02-17 03:32:29","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("126","1","2014-02-17 03:42:44","2014-02-17 03:42:44","","home_right","","inherit","open","open","","home_right-2","","","2014-02-17 03:42:44","2014-02-17 03:42:44","","12","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("125","1","2014-02-17 03:34:00","2014-02-17 03:34:00","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"530\" height=\"350\" border-right: 1px; /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/home_right.jpg\" width=\"530\" height=\"350\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 03:34:00","2014-02-17 03:34:00","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("129","1","2014-02-17 04:30:52","2014-02-17 04:30:52","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p>&nbsp;</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:30:52","2014-02-17 04:30:52","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("130","1","2014-02-17 04:31:35","2014-02-17 04:31:35","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:31:35","2014-02-17 04:31:35","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("131","1","2014-02-17 04:39:20","2014-02-17 04:39:20","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:39:20","2014-02-17 04:39:20","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("132","1","2014-02-17 04:40:41","2014-02-17 04:40:41","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:40:41","2014-02-17 04:40:41","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("133","1","2014-02-17 04:40:52","2014-02-17 04:40:52","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and Ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:40:52","2014-02-17 04:40:52","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("138","1","2014-02-17 06:28:53","2014-02-17 06:28:53","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/sidebar.jpg\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and Ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n<li>Air handling/fancoil systems.</li>\r\n<li>Fume cupboards</li>\r\n<li>General ventilation fans</li>\r\n<li>Roof mounted exhaust fans</li>\r\n<li>Toilet exhaust fans</li>\r\n<li>Roof ventilators</li>\r\n<li>Car park exhaust fans</li>\r\n<li>Supply air fans.</li>\r\n<li>Smoke split and exhaust systems</li>\r\n<li>Warehouse exhaust fans</li>\r\n<li>Multi splits systems</li>\r\n<li>Ducted systems</li>\r\n<li>Split systems</li>\r\n<li>Computer room air conditioning systems</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 06:28:53","2014-02-17 06:28:53","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("134","1","2014-02-17 04:59:11","2014-02-17 04:59:11","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/service.jpg\" width=\"175\" height=\"645\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and Ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n<li>Air handling/fancoil systems.</li>\r\n<li>Fume cupboards</li>\r\n<li>General ventilation fans</li>\r\n<li>Roof mounted exhaust fans</li>\r\n<li>Toilet exhaust fans</li>\r\n<li>Roof ventilators</li>\r\n<li>Car park exhaust fans</li>\r\n<li>Supply air fans.</li>\r\n<li>Smoke split and exhaust systems</li>\r\n<li>Lift motor room ventilation</li>\r\n<li>Warehouse exhaust fans</li>\r\n<li>Multi splits systems</li>\r\n<li>Ducted systems</li>\r\n<li>Split systems</li>\r\n<li>Computer room air conditioning systems</li>\r\n<li>Pressurization system</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 04:59:11","2014-02-17 04:59:11","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("136","1","2014-02-17 06:23:19","2014-02-17 06:23:19","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/sidebar.jpg\" />Airconditioning and Electrical</h1>\r\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\r\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\r\n<h2>Airconditioning and Ventilation</h2>\r\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\r\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\r\n<ul>\r\n<li>Hi-Wall split Systems</li>\r\n<li>Ducted Split Systems</li>\r\n<li>Commercial Packages Units</li>\r\n<li>Mechanical Ventilation Systems</li>\r\n<li>Variable Refrigerant Flow Systems (VRF)</li>\r\n<li>Variable Air Volume (VAV)</li>\r\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\r\n<li>Air handling/fancoil systems.</li>\r\n<li>Fume cupboards</li>\r\n<li>General ventilation fans</li>\r\n<li>Roof mounted exhaust fans</li>\r\n<li>Toilet exhaust fans</li>\r\n<li>Roof ventilators</li>\r\n<li>Car park exhaust fans</li>\r\n<li>Supply air fans.</li>\r\n<li>Smoke split and exhaust systems</li>\r\n<li>Lift motor room ventilation</li>\r\n<li>Warehouse exhaust fans</li>\r\n<li>Multi splits systems</li>\r\n<li>Ducted systems</li>\r\n<li>Split systems</li>\r\n<li>Computer room air conditioning systems</li>\r\n<li>Pressurization system</li>\r\n</ul>\r\n<h2>Service</h2>\r\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\r\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\r\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\r\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\r\n<h2>Comprehensive Airconditioning Service</h2>\r\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\r\n<p>Please see a guide below:</p>\r\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li>Inspect refrigerant lines for signs of leakage</li>\r\n<li>Check and clean standard air filters over</li>\r\n<li> Check operating temperatures</li>\r\n<li> Check blower/air handler operation and lubricate as necessary</li>\r\n<li> Check blower belt and tension</li>\r\n<li> Check condensate drain and clean as necessary</li>\r\n<li> Check operational controls and thermostat</li>\r\n</ul>\r\n</ul>\r\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\r\n<ul>\r\n<ul>\r\n<li> Inspect refrigerant lines for signs of leakage</li>\r\n<li> Inspect and clean condenser coil as necessary</li>\r\n<li> Check condenser fan operation and lubricate as necessary</li>\r\n<li> Check operation and condition of the compressor contractor</li>\r\n<li> Check system voltage</li>\r\n<li> Check operating temperatures</li>\r\n</ul>\r\n</ul>\r\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\r\n<p style=\"text-align: left;\"> </p>\r\n<h2>Electrical</h2>\r\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\r\n<ul>\r\n<li>Switchboard upgrades</li>\r\n<li>New wiring</li>\r\n<li>Rewiring</li>\r\n<li>Commercial</li>\r\n<li>Electrical surge protection</li>\r\n<li>New power points</li>\r\n<li>Electrical safety inspections</li>\r\n<li>Smoke detectors</li>\r\n<li>Indoor lighting solutions</li>\r\n<li>Outdoor/landscaping lighting</li>\r\n<li>Appliance installations</li>\r\n</ul>\r\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-revision-v1","","","2014-02-17 06:23:19","2014-02-17 06:23:19","","14","http://comfortsolutions.com.au/airconditioning/14-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("135","1","2014-02-17 06:22:39","2014-02-17 06:22:39","","sidebar","","inherit","open","open","","sidebar","","","2014-02-17 06:22:39","2014-02-17 06:22:39","","0","http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/sidebar.jpg","0","attachment","image/jpeg","0");
INSERT INTO wp_posts VALUES("137","1","2014-02-18 06:25:31","2014-02-18 06:25:31","<h1><img class=\"alignleft size-full wp-image-42\" alt=\"service\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/sidebar.jpg\" />Airconditioning and Electrical</h1>\n<p style=\"text-align: left;\">We provide a comprehensive service for all Air Conditioning and Electrical requirements, from installing an additional power point, installing domestic Air Conditioning, through to commercial installations of Electrical and Air Conditioning services.</p>\n<p style=\"text-align: left;\">All work is carried out to a high standard by fully qualified technicians using industry approved techniques and products.</p>\n<h2>Airconditioning and Ventilation</h2>\n<p style=\"text-align: left;\">Air conditioning installations require a specialist who is familiar with the new split system or ducted air conditioning. We will supply and install units to your specification, or install an air conditioner that you may have already purchased.</p>\n<p>We supply and install the following major brands: <strong>Daikin - Fujitsu - Mitsubishi - Samsung - Toshiba</strong></p>\n<p style=\"text-align: left;\">We provide installation, service and maintenance for the following:</p>\n<ul>\n<li>Hi-Wall split Systems</li>\n<li>Ducted Split Systems</li>\n<li>Commercial Packages Units</li>\n<li>Mechanical Ventilation Systems</li>\n<li>Variable Refrigerant Flow Systems (VRF)</li>\n<li>Variable Air Volume (VAV)</li>\n<li>Ceiling Cassette Systems Under Ceiling systems</li>\n<li>Air handling/fancoil systems.</li>\n<li>General ventilation fans</li>\n<li>Roof mounted exhaust fans</li>\n<li>Toilet exhaust fans</li>\n<li>Roof ventilators</li>\n<li>Car park exhaust fans</li>\n<li>Supply air fans.</li>\n<li>Smoke split and exhaust systems</li>\n<li>Warehouse exhaust fans</li>\n<li>Multi splits systems</li>\n<li>Ducted systems</li>\n<li>Split systems</li>\n<li>Computer room air conditioning systems</li>\n</ul>\n<h2>Service</h2>\n<p>Our Comfort Solutions Maintenance plan will have you covered.</p>\n<p>Annual maintenance of your system, by our airconditioning experts can detect potential problems before these become an expensive and inconvenient emergency repair job.</p>\n<p>The ongoing air conditioning maintenance plan and can also prevent the premature replacement of the airconditioning unit.</p>\n<p>A well-maintained system runs more efficiently, and assures the peak cooling performance of your airconditioner and has the potential to save you money on your monthly electricity bills.</p>\n<h2>Comprehensive Airconditioning Service</h2>\n<p>Comfort Solutions Air Conditioner Maintenance Plan is designed to provide an efficient, clean and trouble free airconditioning system. Our service includes a comprehensive diagnostic check-up and cleaning of your central air conditioning system.</p>\n<p>Please see a guide below:</p>\n<p><strong>Indoor component:repair of air conditioning indoor unit</strong></p>\n<ul>\n<ul>\n<li>Inspect refrigerant lines for signs of leakage</li>\n<li>Check and clean standard air filters over</li>\n<li> Check operating temperatures</li>\n<li> Check fan and air handler operation</li>\n<li> Check condensate drain and clean as necessary</li>\n<li> Check operational controls and thermostat</li>\n</ul>\n</ul>\n<p><strong>Outdoor component:fixing air conditioner outdoor unit</strong></p>\n<ul>\n<ul>\n<li> Inspect refrigerant lines for signs of leakage</li>\n<li> Inspect and clean condenser coil as necessary</li>\n<li> Check condenser fan operation</li>\n<li> Check operation and condition of the compressor</li>\n<li> Check system voltage</li>\n<li> Check operating temperatures</li>\n</ul>\n</ul>\n<p>We shall advise you of any issues or future potential problems found during the service, if any problems are detected we can offer a cost effective solution.</p>\n<h2>Electrical</h2>\n<p style=\"text-align: left;\">Our electrical service is diverse and includes the following:</p>\n<ul>\n<li>Switchboard upgrades</li>\n<li>New wiring</li>\n<li>Rewiring</li>\n<li>Commercial</li>\n<li>Electrical surge protection</li>\n<li>New power points</li>\n<li>Electrical safety inspections</li>\n<li>Smoke detectors</li>\n<li>Indoor lighting solutions</li>\n<li>Outdoor/landscaping lighting</li>\n<li>Appliance installations</li>\n</ul>\n<p style=\"text-align: left;\">Please contact us today for more information <a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a></p>","Services","","inherit","open","open","","14-autosave-v1","","","2014-02-18 06:25:31","2014-02-18 06:25:31","","14","http://comfortsolutions.com.au/airconditioning/14-autosave-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("142","1","2014-02-17 06:42:22","2014-02-17 06:42:22","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\r\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\r\n<p>Providing a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\r\n<p>Split system or ducted air conditioners professionally installed by qualified technicians. We will also install your pre purchased unit if required.</p>\r\n<p>Ventilation solutions provided for any situation including bathrooms, parking garages and more.</p>\r\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\r\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p><a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","Airconditioning and Electrical Sunshine Coast","","publish","open","open","","airconditioning-and-electrical-sunshine-coast","","","2014-02-17 06:48:18","2014-02-17 06:48:18","","0","http://comfortsolutions.com.au/airconditioning/?p=142","0","post","","0");
INSERT INTO wp_posts VALUES("146","1","2014-02-17 06:45:26","2014-02-17 06:45:26","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\r\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\r\n<p>Providing a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\r\n<p>Split system or ducted air conditioners professionally installed by qualified technicians. We will install your pre purchased unit if required.</p>\r\n<p>Ventilation for any situation </p>\r\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\r\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p>","Airconditioning and Electrical Sunshine Coast","","inherit","open","open","","142-revision-v1","","","2014-02-17 06:45:26","2014-02-17 06:45:26","","142","http://comfortsolutions.com.au/airconditioning/142-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("147","1","2014-02-17 06:47:14","2014-02-17 06:47:14","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\r\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\r\n<p>Providing a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\r\n<p>Split system or ducted air conditioners professionally installed by qualified technicians. We will also install your pre purchased unit if required.</p>\r\n<p>Ventilation solutions provided for any situation including bathrooms, parking garages and more.</p>\r\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\r\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p>","Airconditioning and Electrical Sunshine Coast","","inherit","open","open","","142-revision-v1","","","2014-02-17 06:47:14","2014-02-17 06:47:14","","142","http://comfortsolutions.com.au/airconditioning/142-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("148","1","2014-02-17 06:48:18","2014-02-17 06:48:18","<p><img class=\"alignleft size-full wp-image-143\" alt=\"blog1\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/blog1.jpg\" width=\"400\" height=\"266\" /></p>\r\n<p>Comfort Solutions launches new website for airconditioning and electrical Sunshine Coast.</p>\r\n<p>Providing a comprehensive range of services, including the supply and installation of airconditioners for domestic and commercial applications.</p>\r\n<p>Split system or ducted air conditioners professionally installed by qualified technicians. We will also install your pre purchased unit if required.</p>\r\n<p>Ventilation solutions provided for any situation including bathrooms, parking garages and more.</p>\r\n<p>We also provide an electrical service covering all your installation, maintenance and repairs needs.</p>\r\n<p>New plug sockets, rewiring, switchboards and appliance installations undertaken by fully qualified electricians.</p><a class=\"edg-button\" title=\"Contact us\" href=\"http://comfortsolutions.com.au/airconditioning/?page_id=15\">Contact Us</a>","Airconditioning and Electrical Sunshine Coast","","inherit","open","open","","142-revision-v1","","","2014-02-17 06:48:18","2014-02-17 06:48:18","","142","http://comfortsolutions.com.au/airconditioning/142-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("150","1","2014-02-17 06:56:46","2014-02-17 06:56:46","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n<p><img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n<p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p>\r\n<p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p>\r\n<p>Tel: (07) 5499 6299</p>\r\n<p><span style=\"font-weight: bold;\">Mob: 0410 205 271</span></p>\r\n<p>Email: info@comfortsolutions.com.au</p>\r\n<p><img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\"><br /> </span></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n<p>[contact-form-7 id=\"54\" title=\"Contact form 1\"]</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-17 06:56:46","2014-02-17 06:56:46","","15","http://comfortsolutions.com.au/airconditioning/15-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("151","1","2014-02-17 06:57:26","2014-02-17 06:57:26","<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 25%;\">\r\n<p><img class=\"#\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus.jpg\" width=\"247\" height=\"371\" /></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-0\" style=\"width: 30%; padding-right: 10px;\">\r\n<p>Contact us for all your Sunshine Coast Airconditioning and Electrical Service requirements.</p>\r\n<p>Please use our contact details below or fill in our short form, we are pleased to answer any questions you may have.</p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Mob: 0410 205 271</span></p>\r\n<p>Email: info@comfortsolutions.com.au</p>\r\n<p><img style=\"margin-top: 1px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/contactus2_sml.png\" width=\"125\" height=\"125\" /><span style=\"font-weight: bold;\"><br /> </span></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 35%; padding-left: 25px; padding-right: 5px;\">\r\n<p>[contact-form-7 id=\"54\" title=\"Contact form 1\"]</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell\" style=\"width: 100%;\">\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n</div>","Contact Us","","inherit","open","open","","15-revision-v1","","","2014-02-17 06:57:26","2014-02-17 06:57:26","","15","http://comfortsolutions.com.au/airconditioning/15-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("152","1","2014-02-17 07:08:33","2014-02-17 07:08:33","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: -10px; width: 45%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 45%; margin-right: 60px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:08:33","2014-02-17 07:08:33","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("153","1","2014-02-17 07:09:17","2014-02-17 07:09:17","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: 0px; width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 0px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:09:17","2014-02-17 07:09:17","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("154","1","2014-02-17 07:14:37","2014-02-17 07:14:37","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: 0px; width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 0px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" href=\"#\" name=\"headline\"><h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:14:37","2014-02-17 07:14:37","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("155","1","2014-02-17 07:15:15","2014-02-17 07:15:15","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: 0px; width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 0px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" name=\"headline\"><br />\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></a></span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:15:15","2014-02-17 07:15:15","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("157","1","2014-02-17 07:22:55","2014-02-17 07:22:55","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: 0px; width: 50%;\"><a href=\"http://#\"><img class=\"size-full wp-image-100 alignnone\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 0px;\"><a href=\"http://#\"><img class=\"size-full wp-image-101 alignnone\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n<p><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" name=\"headline\"></a></span></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:22:55","2014-02-17 07:22:55","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("156","1","2014-02-17 07:21:45","2014-02-17 07:21:45","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div style=\"float: left; margin-left: 0px; width: 50%;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div style=\"float: right; width: 50%; margin-right: 0px;\"><a href=\"http://#\"><img class=\"alignleft size-full wp-image-101\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\"><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"></a></span></span>\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n<span style=\"color: #006394; font-size: 20px; line-height: 20px; white-space: nowrap;\"><a id=\"headline\" style=\"line-height: 24px; color: #006394; outline-color: #646464;\" name=\"headline\"></a></span></div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:21:45","2014-02-17 07:21:45","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("159","1","2014-02-17 07:32:36","2014-02-17 07:32:36","<div class=\"edg-content-layout layout-item-0\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> <a href=\"http://#\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:32:36","2014-02-17 07:32:36","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("160","1","2014-02-17 07:41:25","2014-02-17 07:41:25","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\">\r\n<a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> <a href=\"http://#\"></div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></a></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:41:25","2014-02-17 07:41:25","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("163","1","2014-02-17 07:47:19","2014-02-17 07:47:19","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:47:19","2014-02-17 07:47:19","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("162","1","2014-02-17 07:47:03","2014-02-17 07:47:03","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-size: 18px; font-weight: bold;\">Electrical Installations</span><img style=\"margin-left: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/electrical.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Electrical repairs, service and installations throughout the Sunshine Coast region. Domestic or commercial electrical including new power points, rewiring, switchboards and more. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-9\"> </div>\r\n<div class=\"edg-content-layout-wrapper layout-item-11\">\r\n<div class=\"edg-content-layout\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-12\" style=\"width: 50%;\">\r\n<ul>\r\n<li>Airconditioning installations and repairs anywhere on the Sunshine Coast.</li>\r\n<li>Commercial and Domestic installations of split system or ducted airconditioning.</li>\r\n<li>Electrical installations, service and repairs to domestic and commercial premises.</li>\r\n</ul>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-13\" style=\"width: 50%;\">\r\n<blockquote style=\"margin: 10px 0;\">\r\n<p>Sunshine Coast Airconditioning and Electrical services - provided by fully qualified, friendly technicians using quality products. We assure you of  complete customer satisfaction.</p>\r\n</blockquote>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n","Home","","inherit","open","open","","12-revision-v1","","","2014-02-17 07:47:03","2014-02-17 07:47:03","","12","http://comfortsolutions.com.au/airconditioning/12-revision-v1/","0","revision","","0");
INSERT INTO wp_posts VALUES("161","1","2014-02-17 07:46:42","2014-02-17 07:46:42","<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><a href=\"http://#\"><img class=\"alignleft  wp-image-100\" alt=\"domstic\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/domstic.jpg\" width=\"525\" height=\"347\" /></a> </div>\r\n<div class=\"edg-layout-cell layout-item-1\" style=\"width: 50%;\"><img class=\"alignright  wp-image-126\" alt=\"home_right\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/02/home_right.jpg\" width=\"525\" height=\"347\" /></div>\r\n<div class=\"edg-content-layout-wrapper layout-item-2\">\r\n<div class=\"edg-content-layout layout-item-0\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-3\" style=\"width: 100%;\">\r\n<h1><span style=\"color: #ffffff;\">Sunshine Coast Airconditioning &amp; Electrical</span></h1>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"edg-content-layout-wrapper layout-item-4\">\r\n<div class=\"edg-content-layout layout-item-5\">\r\n<div class=\"edg-content-layout-row\">\r\n<div class=\"edg-layout-cell layout-item-6\" style=\"width: 33%;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Installations</span><img style=\"margin-right: 5px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon1.jpg\" width=\"299\" height=\"348\" /></p>\r\n<p style=\"text-align: left;\">Air conditioning installations anywhere on the Sunshine Coast - we offer a<br /> professional, cost effective solution for all your airconditioning requirements. <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-7\" style=\"width: 33%; padding-left: 5px !important;\">\r\n<p style=\"text-align: center;\"><span style=\"font-weight: bold; font-size: 18px;\">Airconditioning Service</span><img style=\"margin-right: 7px;\" alt=\"\" src=\"http://comfortsolutions.com.au/airconditioning/wp-content/uploads/2014/01/aircon_service.jpg\" width=\"300\" height=\"349\" /></p>\r\n<p style=\"text-align: left;\">Airconditioning service, repairs and maintenance - split system or ducted airconditioners. We deliver prompt professional service, using only the highest quality components.  <a class=\"edg-button\" href=\"http://comfortsolutions.com.au/airconditioning/services/\">Read more</a></p>\r\n</div>\r\n<div class=\"edg-layout-cell layout-item-8\" style=\"width: 34%;\