<?php
global $theme_sidebars;
$places = array();
foreach ($theme_sidebars as $sidebar){
    if ($sidebar['group'] !== 'footer')
        continue;
    $widgets = theme_get_dynamic_sidebar_data($sidebar['id']);
    if (!is_array($widgets) || count($widgets) < 1)
        continue;
    $places[$sidebar['id']] = $widgets;
}
$place_count = count($places);
$needLayout = ($place_count > 1);
if (theme_get_option('theme_override_default_footer_content')) {
    if ($place_count > 0) {
        $centred_begin = '<div class="edg-center-wrapper"><div class="edg-center-inner">';
        $centred_end = '</div></div><div class="clearfix"> </div>';
        if ($needLayout) { ?>
<div class="edg-content-layout">
    <div class="edg-content-layout-row">
        <?php 
        }
        foreach ($places as $widgets) { 
            if ($needLayout) { ?>
            <div class="edg-layout-cell edg-layout-cell-size<?php echo $place_count; ?>">
            <?php 
            }
            $centred = false;
            foreach ($widgets as $widget) {
                 $is_simple = ('simple' == $widget['style']);
                 if ($is_simple) {
                     $widget['class'] = implode(' ', array_merge(explode(' ', theme_get_array_value($widget, 'class', '')), array('edg-footer-text')));
                 }
                 if (false === $centred && $is_simple) {
                     $centred = true;
                     echo $centred_begin;
                 }
                 if (true === $centred && !$is_simple) {
                     $centred = false;
                     echo $centred_end;
                 }
                 theme_print_widget($widget);
            } 
            if (true === $centred) {
                echo $centred_end;
            }
            if ($needLayout) {
           ?>
            </div>
        <?php 
            }
        } 
        if ($needLayout) { ?>
    </div>
</div>
        <?php 
        }
    }
?>
<div class="edg-footer-text">
<?php
global $theme_default_options;
echo do_shortcode(theme_get_option('theme_override_default_footer_content') ? theme_get_option('theme_footer_content') : theme_get_array_value($theme_default_options, 'theme_footer_content'));
} else { 
?>
<div class="edg-footer-text">

<div class="edg-content-layout">
    <div class="edg-content-layout-row">
    <div class="edg-layout-cell" style="width: 25%">
        <p>&nbsp;<a href="http://#" class="edg-facebook-tag-icon" style="line-height: 32px;"></a>&nbsp;&nbsp;<a href="http://#" class="edg-twitter-tag-icon" style="line-height: 32px;"></a>&nbsp;&nbsp;<?php theme_ob_start() ?><a href="http://#" class="edg-rss-tag-icon" style="line-height: 32px;"></a><?php echo do_shortcode(theme_ob_get_clean()) ?>&nbsp;<br></p>
    </div><div class="edg-layout-cell" style="width: 50%">
        <p><a href="<?php theme_ob_start() ?>[post_link name='/home']<?php echo do_shortcode(theme_ob_get_clean()) ?>">Home</a> | <a href="<?php theme_ob_start() ?>[post_link name='/about-us']<?php echo do_shortcode(theme_ob_get_clean()) ?>">About Us</a> | <a href="<?php theme_ob_start() ?>[post_link name='/contact-us']<?php echo do_shortcode(theme_ob_get_clean()) ?>">Contact Us</a></p>
        <p>Copyright © 2014. All Rights Reserved.</p>
    </div><div class="edg-layout-cell" style="width: 25%">
        <p><a href="#"><img width="100" height="48" alt="" src="<?php echo get_template_directory_uri() ?>/images/logo_lft.jpg" style="margin-right: 3px;"></a><a href="#"><img width="100" height="48" alt="" src="<?php echo get_template_directory_uri() ?>/images/logo_rgt.jpg" style="margin-left: 3px;"></a><br></p>
    </div>
    </div>
</div>


<?php } ?>

</div>
